/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.gui.reports.ComenziReportEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class ComenziReportPanel
extends AbstractReportPanel
implements CleanupRequired {
    public static final String[] columns = new String[]{LangRoAll.produs, "Stoc actual", "Consum", "Medie consum", LangRoAll.comanda};
    private static final Class[] types = new Class[]{String.class, String.class, String.class, String.class, String.class};
    private JComboBox furnizori;
    private XComboBox produse;
    private FilterableComboBoxModel xStocksComboModel;
    private JTextField nrZileComanda;
    private ReportInterface pdfReportInterface;
    private Hashtable printCriteria = new Hashtable();

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> searchCriteria = new Hashtable<String, Comparable<Date>>();
        searchCriteria.put(Constants.START_KEY, startDate);
        searchCriteria.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.furnizori)) {
            Client f = (Client)this.furnizori.getSelectedItem();
            searchCriteria.put("Furnizor", Integer.valueOf(f.getId()));
            this.printCriteria.put("Furnizor", f.toString());
        } else {
            searchCriteria.put("Furnizor", Integer.valueOf(-1));
            this.printCriteria.remove("Furnizor");
        }
        if (ComboUtils.anythingButAllSelected(this.produse)) {
            Stock c = (Stock)this.produse.getSelectedItem();
            searchCriteria.put(Constants.STOCK_KEY, Integer.valueOf(c.getId()));
            this.printCriteria.put(Constants.STOCK_KEY, c.getLabel());
        } else {
            searchCriteria.put(Constants.STOCK_KEY, Integer.valueOf(-1));
            this.printCriteria.remove(Constants.STOCK_KEY);
        }
        int nrZile = 0;
        String s1 = this.nrZileComanda.getText();
        if (Validators.correctInteger(s1)) {
            nrZile = Integer.parseInt(s1);
            this.printCriteria.put("Numar zile comanda", nrZile);
        } else {
            this.printCriteria.remove("Numar zile comanda");
        }
        searchCriteria.put("Numar zile comanda", Integer.valueOf(nrZile));
        return searchCriteria;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, null, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return RestLogic.getInstance().getComenziReport(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    ComenziReportEntry entry = (ComenziReportEntry)o;
                    try {
                        int column = 0;
                        Label label = new Label(column, row, entry.getProdus());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getStoc()));
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getConsum()));
                        sheet.addCell((WritableCell)new Number(++column, row, entry.getMedieConsum()));
                        ++column;
                        double comanda = entry.getComanda();
                        if (comanda > 0.0) {
                            sheet.addCell((WritableCell)new Number(column, row, comanda));
                            ++column;
                        }
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return ComenziReportPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Comenzi";
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                ComenziReportEntry fe = (ComenziReportEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return fe.getProdus();
                    }
                    case 1: {
                        return Utils.getString2Decimals(fe.getStoc());
                    }
                    case 2: {
                        double consum = fe.getConsum();
                        if (consum > 0.0) {
                            return Utils.getString2Decimals(consum);
                        }
                        return "";
                    }
                    case 3: {
                        double medie = fe.getMedieConsum();
                        if (medie > 0.0) {
                            return Utils.getString2Decimals(medie);
                        }
                        return "";
                    }
                    case 4: {
                        double comanda = fe.getComanda();
                        if (comanda > 0.0) {
                            return Utils.getString2Decimals(comanda);
                        }
                        return "";
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        return null;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        buttonsPanel.add((Component)new JLabel("Furnizori"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.furnizori = new JComboBox();
        buttonsPanel.add((Component)this.furnizori, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        buttonsPanel.add((Component)new JLabel(LangRoAll.produs), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.xStocksComboModel = new FilterableComboBoxModel(StockLogic.getInstance().getPowerSearchStocks());
        this.produse = new XComboBox(this.xStocksComboModel);
        buttonsPanel.add((Component)this.produse, c);
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        buttonsPanel.add((Component)new JLabel("Nr zile"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nrZileComanda = new JTextField(10);
        buttonsPanel.add((Component)this.nrZileComanda, c);
        return buttonsPanel;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.furnizori, ContaLogic.getInstance().getFurnizori(1));
        GenericListenersLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(ComenziReportPanel.this.furnizori, ContaLogic.getInstance().getFurnizori(1));
            }

            @Override
            public String getName() {
                return "ComenziReportPanel_furnizori";
            }
        }, 11);
        StockLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComenziReportPanel.this.xStocksComboModel.refresh(StockLogic.getInstance().getPowerSearchStocks());
            }

            @Override
            public String getName() {
                return "ComenziReportPanel_stocks";
            }
        }, 26);
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 3;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return ComenziReportPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return ComenziReportPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                ComenziReportEntry sve = (ComenziReportEntry)row;
                switch (column) {
                    case 0: {
                        return sve.getProdus();
                    }
                    case 1: {
                        return Utils.getString2Decimals(sve.getStoc());
                    }
                    case 2: {
                        return Utils.getString2Decimals(sve.getConsum());
                    }
                    case 3: {
                        return Utils.getString2Decimals(sve.getMedieConsum());
                    }
                    case 4: {
                        double comanda = sve.getComanda();
                        if (comanda > 0.0) {
                            return Utils.getString2Decimals(comanda);
                        }
                        return "";
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public void cleanup() {
    }
}

