/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.util.Vector;
import javax.swing.JPanel;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class DetaliiOrder
extends AbstractListPanel {
    private int idOrder;

    public DetaliiOrder(int idOrder) {
        this.idOrder = idOrder;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Sale e = (Sale)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return e.getProductName();
                    }
                    case 1: {
                        return Utils.getString3Decimals(e.getCantitateMarcata());
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel getBottomPanel() {
        return null;
    }

    @Override
    public Vector buildData() {
        return RestLogic.getInstance().getSales(this.idOrder, true, -1, new ScreenSaleInterface());
    }

    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.produs, LangRoAll.cantitate};
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public void doStuff() {
        this.display();
    }
}

