/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.FoodCostEntry;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class FoodCostPanel
extends AbstractReportPanel {
    public static final String[] columns = new String[]{LangRoAll.produs, "Pret vanzare", "Costuri", "Valoare vanzare", "Food cost %", "Adaos %"};
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    private double totalCosturi;
    private double totalVanzare;
    private double costMediu;
    private double adaosMediu;
    private JLabel totalCostLabel;
    private JLabel totalVzLabel;
    private JLabel costMediuLabel;
    private JLabel adaosMediuLabel;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Date> result = new Hashtable<String, Date>();
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return new Vector();
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    FoodCostEntry entry = (FoodCostEntry)o;
                    try {
                        Label label = new Label(0, row, entry.getProdus());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(1, row, entry.getPretVanzare()));
                        sheet.addCell((WritableCell)new Number(2, row, entry.getCosturi()));
                        sheet.addCell((WritableCell)new Number(3, row, entry.getVanzare()));
                        sheet.addCell((WritableCell)new Number(4, row, entry.getFoodCost()));
                        sheet.addCell((WritableCell)new Number(5, row, entry.getAdaos()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return FoodCostPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Food cost";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FoodCostEntry sqv = (FoodCostEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return sqv.getProdus();
                    }
                    case 1: {
                        return Utils.getString2Decimals(sqv.getPretVanzare());
                    }
                    case 2: {
                        return Utils.getString2Decimals(sqv.getCosturi());
                    }
                    case 3: {
                        return Utils.getString2Decimals(sqv.getVanzare());
                    }
                    case 4: {
                        return Utils.getString2Decimals(sqv.getFoodCost());
                    }
                    case 5: {
                        return Utils.getString2Decimals(sqv.getAdaos());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Costuri"), c);
        ++c.gridx;
        this.totalCostLabel = new JLabel("");
        result.add((Component)this.totalCostLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.vanzari), c);
        ++c.gridx;
        this.totalVzLabel = new JLabel("");
        result.add((Component)this.totalVzLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Food cost mediu"), c);
        ++c.gridx;
        this.costMediuLabel = new JLabel("");
        result.add((Component)this.costMediuLabel, c);
        ++c.gridx;
        result.add((Component)new JLabel("Adaos mediu"), c);
        ++c.gridx;
        this.adaosMediuLabel = new JLabel("");
        result.add((Component)this.adaosMediuLabel, c);
        return result;
    }

    private void computeTotals(Vector items) {
        this.totalCosturi = 0.0;
        this.totalVanzare = 0.0;
        this.costMediu = 0.0;
        this.adaosMediu = 0.0;
        for (FoodCostEntry element : items) {
            this.totalCosturi += element.getCosturi();
            this.totalVanzare += element.getVanzare();
        }
        this.costMediu = this.totalCosturi / this.totalVanzare * 100.0;
        this.adaosMediu = (this.totalVanzare / this.totalCosturi - 1.0) * 100.0;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        return null;
    }

    @Override
    public void refreshTotalPanel() {
        this.computeTotals(this.tm.getData());
        this.totalCostLabel.setText(Utils.getString2Decimals(this.totalCosturi));
        this.totalVzLabel.setText(Utils.getString2Decimals(this.totalVanzare));
        this.adaosMediuLabel.setText(Utils.getString2Decimals(this.adaosMediu));
        this.costMediuLabel.setText(Utils.getString2Decimals(this.costMediu));
    }

    @Override
    public void doStuff() {
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        return FoodCostPanel.this.totalCostLabel.getText();
                    }
                    case 3: {
                        return FoodCostPanel.this.totalVzLabel.getText();
                    }
                    case 4: {
                        return FoodCostPanel.this.costMediuLabel.getText();
                    }
                    case 5: {
                        return FoodCostPanel.this.adaosMediuLabel.getText();
                    }
                }
                return null;
            }

            @Override
            public String getReportTitle() {
                return FoodCostPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return FoodCostPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                FoodCostEntry sve = (FoodCostEntry)row;
                switch (column) {
                    case 0: {
                        return sve.getProdus();
                    }
                    case 1: {
                        return Utils.getString2Decimals(sve.getPretVanzare());
                    }
                    case 2: {
                        return Utils.getString2Decimals(sve.getCosturi());
                    }
                    case 3: {
                        return Utils.getString2Decimals(sve.getVanzare());
                    }
                    case 4: {
                        return Utils.getString2Decimals(sve.getFoodCost());
                    }
                    case 5: {
                        return Utils.getString2Decimals(sve.getAdaos());
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

