/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Timestamp;
import javax.swing.JTabbedPane;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.Factura;
import ro.atreides.contabilitate.Nir;
import ro.atreides.contabilitate.gui.EditNirPanel;
import ro.atreides.contabilitate.gui.FacturiReport;
import ro.atreides.stocks.gui.RaportGestiunePanel;
import ro.atreides.stocks.gui.StocFapticPanel;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.TimedPermissionsInterface;
import ro.atreides.utils.events.EventsLogic;
import ro.atreides.utils.gui.table.DoubleClicked;
import ro.atreides.utils.gui.table.SwitchToList;

public class GestionarPanel
extends ReflectedJPanel
implements CleanupRequired {
    private JTabbedPane _tabbedPane = null;
    private StocFapticPanel fapticPanel;
    private EditNirPanel eNirPanel;
    private FacturiReport facturi;
    private RaportGestiunePanel balantaPanel;
    private ContaLogic logic = ContaLogic.getInstance();

    public void display() {
        this._tabbedPane = new JTabbedPane();
        this.fapticPanel = new StocFapticPanel();
        this._tabbedPane.add(this.fapticPanel.getName(), this.fapticPanel);
        this.fapticPanel.doStuff();
        this.balantaPanel = new RaportGestiunePanel();
        this._tabbedPane.add(this.balantaPanel.getName(), this.balantaPanel);
        this.balantaPanel.doStuff();
        this.eNirPanel = new EditNirPanel(this.logic, this);
        this._tabbedPane.add((Component)this.eNirPanel, "Adaugare nir");
        this.facturi = new FacturiReport();
        this.facturi.doStuff();
        this._tabbedPane.add((Component)this.facturi, this.facturi.getName());
        this.facturi.setAction(new DoubleClicked(){

            @Override
            public void doubleClicked(Object o) {
                Factura factura = (Factura)o;
                Nir n = GestionarPanel.this.logic.getNirByFacturaId(factura.getId());
                GestionarPanel.this.eNirPanel.setFactura(factura, n);
                GestionarPanel.this._tabbedPane.setSelectedComponent(GestionarPanel.this.eNirPanel);
            }

            @Override
            public void doubleClicked(Object o, Object entry, int selRow) {
            }
        });
        this.eNirPanel.setAction(new SwitchToList(){

            @Override
            public void doAction() {
                GestionarPanel.this._tabbedPane.setSelectedComponent(GestionarPanel.this.facturi);
            }
        });
        int max = this._tabbedPane.getTabCount();
        for (int i = 0; i < max; ++i) {
            ReflectedJPanel panel = (ReflectedJPanel)this._tabbedPane.getComponentAt(i);
            panel.setUserLogInterface(this.userLogInterface);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._tabbedPane, c);
    }

    @Override
    public void doStuff() {
        this.display();
        TimedPermissionsInterface i = new TimedPermissionsInterface(){

            @Override
            public boolean canModify(Timestamp time) {
                Timestamp now = DateUtils.getCurrentTimestamp();
                Timestamp lastOpen = EventsLogic.getInstance().getLastOpenDate(1);
                return !time.before(lastOpen) && !time.after(now);
            }

            @Override
            public boolean canView(Timestamp time) {
                return this.canModify(time);
            }

            @Override
            public String getViewError() {
                return "Data si ora nu se incadreaza in intervalul permis";
            }

            @Override
            public String getModifyError() {
                return "Data si ora nu se incadreaza in intervalul permis";
            }
        };
        this.balantaPanel.setTimedPermissions(i);
        this.eNirPanel.setTimePermission(i);
        this.facturi.setTimedPermissions(i);
        this.fapticPanel.setTimedPermissions(i);
    }

    @Override
    public void cleanup() {
        this.fapticPanel.cleanup();
        this.eNirPanel.cleanup();
        this.facturi.cleanup();
    }
}

