/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.gui.reports.ManagerReportEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class ManagerReport
extends AbstractReportPanel {
    private static final String[] columns = new String[]{Utils.getTranslation(LangRoAll.atribut), LangRoAll.valoare};
    private static final Class[] types = new Class[]{String.class, String.class};
    private ReportInterface pdfReportInterface;
    private ReportInterface asciiReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private JComboBox waiters;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        if (ComboUtils.anythingButAllSelected(this.waiters)) {
            User waiter = (User)this.waiters.getSelectedItem();
            this.printCriteria.put(LangRoAll.utilizator, waiter.getName());
            result.put("user_fo", waiter);
        } else {
            this.printCriteria.remove(LangRoAll.utilizator);
        }
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, this.asciiReportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return RestLogic.getInstance().getManagerReport(criteria, this.whatToPrint);
    }

    @Override
    public void writeExcel(File reportFile) {
    }

    @Override
    public String getName() {
        return Utils.getTranslation(LangRoAll.statistica, new String[0]);
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                ManagerReportEntry se = (ManagerReportEntry)data.elementAt(rowIndex);
                if (se == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return se.getAttributeName();
                    }
                    case 1: {
                        return se.getAttributeValue();
                    }
                }
                return null;
            }
        });
        return model;
    }

    @Override
    public JPanel buildTotalPanel() {
        return null;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.operator), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.waiters = new JComboBox();
        result.add((Component)this.waiters, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void doStuff() {
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return ManagerReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return ManagerReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                ManagerReportEntry ie = (ManagerReportEntry)row;
                if (ie == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        return ie.getAttributeName();
                    }
                    case 1: {
                        return ie.getAttributeValue();
                    }
                }
                return null;
            }
        };
        this.asciiReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return Utils.getTranslation(LangRoAll.atribut) + "|" + Utils.getTranslation(LangRoAll.valoare);
                    }
                }
                return null;
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return ManagerReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return ManagerReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                ManagerReportEntry me = (ManagerReportEntry)row;
                return me.getAttributeName() + "|" + me.getAttributeValue();
            }
        };
        ComboUtils.replaceItemsForCombo(this.waiters, UsersLogic.getInstance().getUsersInGroup("group_fo_users"));
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

