/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.base.MonetarView;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Shift;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;
import ro.atreides.utils.reports.AbstractReportPanel;

public class MonetarReportPanel
extends AbstractReportPanel {
    public static String[] columns = new String[]{LangRoAll.operator, LangRoAll.modPlata, LangRoAll.suma, Utils.getTranslation(LangRoAll.dataInchiderii, new String[0])};
    protected JComboBox modPlata;
    protected JComboBox waiters;
    protected JComboBox tables;
    protected JComboBox clienti;
    protected JComboBox ture;
    protected JComboBox locatieCombo;
    private JLabel totalSuma;
    protected RestLogic logic;
    protected ReportInterface pdfReportInterface;
    protected ReportInterface asciiReportInterface;
    protected Hashtable printCriteria = new Hashtable();

    protected String getFirstColumnValue(MonetarView fe) {
        return fe.getOspatarMasa();
    }

    public MonetarReportPanel() {
        this.logic = RestLogic.getInstance();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Object waiter = this.waiters.getSelectedItem();
        if (waiter instanceof User) {
            result.put("user_fo", waiter);
            this.printCriteria.put(LangRoAll.utilizator, waiter);
        } else {
            this.printCriteria.put(LangRoAll.utilizator, LangRoAll.toti);
        }
        Object table = this.tables.getSelectedItem();
        if (table instanceof Table) {
            result.put(Constants.TABLE_KEY, table);
            this.printCriteria.put(Constants.TABLE_KEY, table);
        } else {
            this.printCriteria.remove(Constants.TABLE_KEY);
        }
        Object client = this.clienti.getSelectedItem();
        if (client instanceof Client) {
            result.put(Constants.CLIENT_KEY, client);
            this.printCriteria.put(LangRoAll.client, client);
        } else {
            this.printCriteria.put(LangRoAll.client, LangRoAll.toti);
        }
        Object tipValue = this.modPlata.getSelectedItem();
        if (tipValue instanceof TipPlata) {
            result.put("Tip plata", tipValue);
            this.printCriteria.put(LangRoAll.modPlata, tipValue);
        } else {
            this.printCriteria.put(LangRoAll.modPlata, LangRoAll.toate);
        }
        if (ComboUtils.anythingButAllSelected(this.locatieCombo)) {
            Location l = (Location)this.locatieCombo.getSelectedItem();
            result.put(Constants.LOCATIE_KEY, l);
            this.printCriteria.put(Constants.LOCATIE_KEY, l.getName());
        } else {
            this.printCriteria.remove(Constants.LOCATIE_KEY);
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.tura), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.ture = new JComboBox();
        result.add((Component)this.ture, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.locatie), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.locatieCombo = new JComboBox();
        result.add((Component)this.locatieCombo, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.operator), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.waiters = new JComboBox();
        result.add((Component)this.waiters, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.comanda), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tables = new JComboBox();
        result.add((Component)this.tables, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.modPlata), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.modPlata = new JComboBox();
        result.add((Component)this.modPlata, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.clienti = new JComboBox();
        result.add((Component)this.clienti, c);
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        Class[] types = Utils.getStringClass(columns.length);
        AbstractTM tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                MonetarView fe = (MonetarView)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return MonetarReportPanel.this.getFirstColumnValue(fe);
                    }
                    case 1: {
                        return fe.getModPlata() + (Validators.correctString(fe.getDetalii()) ? " (" + fe.getDetalii() + ")" : "");
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.getSuma());
                    }
                    case 3: {
                        return fe.getData() != null ? Formatters.DATE_AND_TIME_FORMAT.format(fe.getData()) : "";
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 2;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.explicatiiDataInchiderii, new String[0])), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        this.totalSuma = new JLabel("");
        result.add((Component)this.totalSuma, c);
        return result;
    }

    @Override
    public String getName() {
        return LangRoAll.monetar;
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return this.logic.getMonetar(criteria, this.whatToPrint);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, this.asciiReportInterface, this.data);
    }

    @Override
    public void refreshTotalPanel() {
        this.updateTotals(this.data);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    MonetarView entry = (MonetarView)o;
                    try {
                        Label label = new Label(0, row, MonetarReportPanel.this.getFirstColumnValue(entry));
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getModPlata() + (Validators.correctString(entry.getDetalii()) ? " (" + entry.getDetalii() + ")" : ""));
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(2, row, entry.getSuma()));
                        label = new Label(3, row, entry.getData() != null ? Formatters.DATE_AND_TIME_FORMAT.format(entry.getData()) : "");
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return MonetarReportPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void updateTotals(Vector items) {
        double suma = 0.0;
        for (MonetarView element : items) {
            suma += element.getSuma();
        }
        this.totalSuma.setText(Utils.getString2Decimals(suma));
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.waiters, this.logic.getWaiters());
        ComboUtils.replaceItemsForCombo(this.tables, this.logic.getTables());
        ComboUtils.replaceItemsForCombo(this.clienti, ClientLogic.getInstance().getAllClientsSorted());
        ComboUtils.replaceItemsForCombo(this.modPlata, TipPlataProvider.getInstance().getTipPlata());
        ComboUtils.replaceItemsForCombo(this.ture, RestLogic.getInstance().getShifts());
        ComboUtils.replaceItemsForCombo(this.locatieCombo, RestLogic.getInstance().getLocations());
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 4;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 2: {
                        return MonetarReportPanel.this.totalSuma.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return MonetarReportPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return MonetarReportPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                MonetarView fe = (MonetarView)row;
                switch (column) {
                    case 0: {
                        return MonetarReportPanel.this.getFirstColumnValue(fe);
                    }
                    case 1: {
                        return fe.getModPlata() + (Validators.correctString(fe.getDetalii()) ? " (" + fe.getDetalii() + ")" : "");
                    }
                    case 2: {
                        return Utils.getString2Decimals(fe.getSuma());
                    }
                    case 3: {
                        return fe.getData() != null ? Formatters.DATE_AND_TIME_FORMAT.format(fe.getData()) : "";
                    }
                }
                return null;
            }
        };
        this.asciiReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.produs + "|" + LangRoAll.cantitate + "|" + LangRoAll.valoare;
                    }
                }
                return null;
            }

            @Override
            public String getTotal(int column) {
                if (column == 0) {
                    String s = LangRoAll.total + ": " + MonetarReportPanel.this.totalSuma.getText();
                    return s;
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return MonetarReportPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return MonetarReportPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                if (column == 0) {
                    MonetarView nv = (MonetarView)row;
                    String line = MonetarReportPanel.this.getFirstColumnValue(nv) + "|" + nv.getModPlata() + (Validators.correctString(nv.getDetalii()) ? " (" + nv.getDetalii() + ")" : "") + "|" + nv.getSuma() + "|" + nv.getData();
                    return line;
                }
                return "";
            }
        };
        this.ture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ComboUtils.anythingButAllSelected(MonetarReportPanel.this.ture)) {
                    Shift s = (Shift)MonetarReportPanel.this.ture.getSelectedItem();
                    MonetarReportPanel.this.dateSelector.selectPeriod();
                    MonetarReportPanel.this.dateSelector.setStartDate(s.getStart());
                    MonetarReportPanel.this.dateSelector.setStopDate(s.getStop());
                } else {
                    MonetarReportPanel.this.dateSelector.setStartDate(DateUtils.getStartOfDay(new Date()));
                    MonetarReportPanel.this.dateSelector.setStopDate(DateUtils.getEndOfDay(new Date()));
                    MonetarReportPanel.this.dateSelector.selectDay();
                }
            }
        });
    }
}

