/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.reports;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.facturi.gui.AddFacturaPanel;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.PaymentLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.users.User;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Order;
import ro.atreides.utils.Shift;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class NoteReportPanel
extends AbstractReportPanel {
    public static String[] columns;
    protected RestLogic logic;
    protected JComboBox waiters;
    protected JComboBox tables;
    protected JComboBox tip;
    protected JComboBox clienti;
    protected JComboBox angajati;
    protected JComboBox ture;
    protected JComboBox modPlata;
    protected JLabel totalSuma;
    protected JLabel totalDiscount;
    protected JLabel selectateLabel;
    private ReportInterface pdfReportInterface;
    private ReportInterface asciiReportInterface;
    private Hashtable printCriteria = new Hashtable();
    protected JTextField detalii;
    protected static boolean showMasaFilter;
    protected static boolean showTuraFilter;
    protected static boolean popupShowFacturare;
    protected static boolean popupShowExportCiel;
    private Hashtable<Integer, Order> selectedOrders = new Hashtable();
    private JButton stergeSelectia;
    private JButton invertSelection;

    private void clearSelection() {
        this.selectedOrders.clear();
        for (int i = 0; i < this.data.size(); ++i) {
            NoteView nv = (NoteView)this.data.elementAt(i);
            nv.setSelected(false);
        }
        this.selectateLabel.setText("0");
        this.tm.fireTableDataChanged();
    }

    public NoteReportPanel() {
        this.logic = RestLogic.getInstance();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Object tipValue1;
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Object waiter = this.waiters.getSelectedItem();
        if (waiter instanceof User) {
            result.put("user_fo", waiter);
            this.printCriteria.put(LangRoAll.utilizator, waiter);
        } else {
            this.printCriteria.remove(LangRoAll.utilizator);
        }
        Object table = this.tables.getSelectedItem();
        if (table instanceof Table) {
            result.put(Constants.TABLE_KEY, table);
            this.printCriteria.put(Constants.TABLE_KEY, table);
        } else {
            this.printCriteria.remove(Constants.TABLE_KEY);
        }
        Object client = this.clienti.getSelectedItem();
        if (client instanceof ClientPersJuridica) {
            result.put("client_pj", client);
            this.printCriteria.put(LangRoAll.clientPJ, client);
            if (ComboUtils.anythingButAllSelected(this.angajati)) {
                Object c2 = this.angajati.getSelectedItem();
                result.put("client_pf", c2);
                this.printCriteria.put(LangRoAll.clientPF, c2);
            } else {
                this.printCriteria.remove(LangRoAll.clientPF);
            }
        } else if (client instanceof ClientPersFizica) {
            result.put("client_pf", client);
            this.printCriteria.put(LangRoAll.clientPF, client);
        } else {
            this.printCriteria.remove(LangRoAll.clientPJ);
            this.printCriteria.remove(LangRoAll.clientPF);
        }
        String tipValue = (String)this.tip.getSelectedItem();
        if (!tipValue.equalsIgnoreCase("All")) {
            if (tipValue.equalsIgnoreCase("Normal")) {
                result.put("Tip protocol", "false");
                this.printCriteria.put(LangRoAll.tipNota, LangRoAll.clienti);
            } else {
                result.put("Tip protocol", "true");
                this.printCriteria.put(LangRoAll.tipNota, LangRoAll.protocol);
            }
        } else {
            this.printCriteria.remove(LangRoAll.tipNota);
        }
        if (VpConfig.getInstance().showDetaliiNota) {
            String s1 = this.detalii.getText();
            if (Validators.correctString(s1)) {
                result.put(LangRoAll.detalii, s1);
                this.printCriteria.put(LangRoAll.detalii, s1);
            } else {
                this.printCriteria.remove(LangRoAll.detalii);
            }
        }
        if ((tipValue1 = this.modPlata.getSelectedItem()) instanceof TipPlata) {
            result.put("Tip plata", tipValue1);
            this.printCriteria.put(LangRoAll.modPlata, tipValue1);
        } else {
            this.printCriteria.put(LangRoAll.modPlata, LangRoAll.toate);
        }
        return result;
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, this.asciiReportInterface, this.data);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return this.logic.getNote(criteria, false, this.whatToPrint);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    NoteView entry = (NoteView)o;
                    try {
                        String s = NoteReportPanel.this.getFirstColumnValue(entry);
                        Label label = new Label(0, row, s);
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getProdus());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(2, row, entry.getCantitate()));
                        sheet.addCell((WritableCell)new Number(3, row, entry.getSuma()));
                        label = new Label(4, row, entry.getData() != null ? Formatters.DATE_AND_TIME_FORMAT.format(entry.getData()) : "");
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return NoteReportPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return LangRoAll.note;
    }

    @Override
    public AbstractTM buildTableModel() {
        Class[] types = Utils.getStringClass(columns.length);
        this.tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                NoteView fe = (NoteView)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return NoteReportPanel.this.getFirstColumnValue(fe);
                    }
                    case 1: {
                        return fe.getProdus();
                    }
                    case 2: {
                        return Utils.getString3Decimals(fe.getCantitate());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getSuma());
                    }
                    case 4: {
                        return fe.getData() != null ? Formatters.DATE_AND_TIME_FORMAT.format(fe.getData()) : "";
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    protected String getFirstColumnValue(NoteView fe) {
        return fe.getData() != null ? (VpConfig.getInstance().showDetaliiNota ? fe.getDetalii() + "," : "") + fe.getOspatarMasa() + "," + Utils.getString2Decimals(fe.getTotalNota()) : "";
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        this.totalSuma = new JLabel("");
        result.add((Component)this.totalSuma, c);
        ++c.gridx;
        result.add((Component)new JLabel(LangRoAll.discount), c);
        ++c.gridx;
        this.totalDiscount = new JLabel("");
        result.add((Component)this.totalDiscount, c);
        ++c.gridx;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.noteSelectate, new String[0])), c);
        ++c.gridx;
        this.selectateLabel = new JLabel("");
        result.add((Component)this.selectateLabel, c);
        final NoteReportPanel panel = this;
        ++c.gridx;
        this.invertSelection = new JButton(Utils.getTranslation(LangRoAll.inverseazaSelectia, new String[0]));
        this.invertSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Hashtable<Integer, Order> newSelection = new Hashtable<Integer, Order>();
                for (int i = 0; i < NoteReportPanel.this.data.size(); ++i) {
                    NoteView pve = (NoteView)NoteReportPanel.this.data.elementAt(i);
                    int idOrder = pve.getIdOrder();
                    pve.setSelected(false);
                    if (NoteReportPanel.this.selectedOrders.get(idOrder) != null) continue;
                    if (newSelection.get(idOrder) == null) {
                        Order o = NoteReportPanel.this.logic.getOrderById(idOrder);
                        newSelection.put(idOrder, o);
                    }
                    pve.setSelected(true);
                }
                NoteReportPanel.this.selectedOrders = newSelection;
                NoteReportPanel.this.selectateLabel.setText(NoteReportPanel.this.selectedOrders.size() + "");
                NoteReportPanel.this.tm.fireTableDataChanged();
            }
        });
        this.invertSelection.setMargin(new Insets(1, 1, 1, 1));
        result.add((Component)this.invertSelection, c);
        ++c.gridx;
        this.stergeSelectia = new JButton(Utils.getTranslation(LangRoAll.stergeSelectia));
        this.stergeSelectia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NoteReportPanel.this.clearSelection();
            }
        });
        this.stergeSelectia.setMargin(new Insets(1, 1, 1, 1));
        result.add((Component)this.stergeSelectia, c);
        ++c.gridx;
        JButton stoc = new JButton(LangRoAll.reproceseazaFisaStoc);
        stoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DialogUtils.confirmDialog(panel, LangRoAll.reprocesamFisaStocPtNote, LangRoAll.confirmare) && DialogUtils.confirmDialog(panel, LangRoAll.putemDereglaFisaStoc, LangRoAll.confirmare)) {
                    int lastOrder = -1;
                    for (int i = 0; i < NoteReportPanel.this.data.size(); ++i) {
                        NoteView noteView = (NoteView)NoteReportPanel.this.data.elementAt(i);
                        Order o = NoteReportPanel.this.logic.getOrderById(noteView.getIdOrder());
                        if (lastOrder != o.getId()) {
                            NoteReportPanel.this.logic.notifyObjectListeners(104, o);
                        }
                        lastOrder = o.getId();
                    }
                }
            }
        });
        stoc.setMargin(new Insets(1, 1, 1, 1));
        result.add((Component)stoc, c);
        ++c.gridx;
        JButton factura = new JButton(LangRoAll.factura);
        factura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Client clientPJ = (Client)NoteReportPanel.this.criteria.get("client_pj");
                Client clientPF = (Client)NoteReportPanel.this.criteria.get("client_pf");
                Client c = null;
                c = clientPJ != null ? clientPJ : clientPF;
                boolean facturamSelectate = false;
                Vector<NoteView> deFacturat = new Vector<NoteView>();
                if (NoteReportPanel.this.selectedOrders.size() > 0) {
                    facturamSelectate = true;
                    for (NoteView view : NoteReportPanel.this.data) {
                        int idOrder = view.getIdOrder();
                        if (NoteReportPanel.this.selectedOrders.get(idOrder) == null) continue;
                        deFacturat.add(view);
                    }
                } else {
                    deFacturat.addAll(NoteReportPanel.this.data);
                }
                if (DialogUtils.confirmDialog(panel, facturamSelectate ? LangRoAll.generamFacturaSelectate : LangRoAll.generamFacturaAfisate, LangRoAll.confirmare)) {
                    AddFacturaPanel facturaPanel = FacturiLogic.getInstance().getAddFacturaPanel();
                    if (facturaPanel != null) {
                        NoteReportPanel.this.addNoteToFactura(panel, deFacturat, facturaPanel, c);
                    } else {
                        DialogUtils.errorDialog(panel, LangRoAll.nuAvetiAccesLaFacturare, LangRoAll.nuPotContinua);
                    }
                }
            }
        });
        factura.setMargin(new Insets(1, 1, 1, 1));
        result.add((Component)factura, c);
        ++c.gridx;
        JButton sterge = new JButton(LangRoAll.sterge);
        sterge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (VpConfig.getInstance().allowStergere && DialogUtils.confirmDialog(panel, LangRoAll.stergemNoteleSelectate, LangRoAll.confirmare)) {
                    User currentLoggedUser = AdministrationPanel.loggedUser;
                    Vector<Order> toDelete = new Vector<Order>();
                    for (Order or : NoteReportPanel.this.selectedOrders.values()) {
                        if (or == null) continue;
                        boolean canDelete = true;
                        Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(or.getId());
                        for (Plata plata : plati) {
                            int idTipPlata = plata.getIdTipPlata();
                            TipPlata tp = TipPlataProvider.getInstance().getTipPlataById(idTipPlata);
                            if (!tp.isDocumentDePlata()) continue;
                            canDelete = false;
                            break;
                        }
                        if (!canDelete) continue;
                        toDelete.add(or);
                    }
                    for (Order order : toDelete) {
                        NoteReportPanel.this.logic.deleteOrder(order, currentLoggedUser, "", panel, false);
                    }
                    NoteReportPanel.this.tm.refresh(NoteReportPanel.this.logic.getNote(NoteReportPanel.this.criteria, false, NoteReportPanel.this.whatToPrint));
                }
            }
        });
        sterge.setMargin(new Insets(1, 1, 1, 1));
        result.add((Component)sterge, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        this.ture = new JComboBox();
        if (showTuraFilter) {
            result.add((Component)new JLabel(LangRoAll.tura), c);
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)this.ture, c);
            c.gridx = 0;
            ++c.gridy;
        }
        if (VpConfig.getInstance().showDetaliiNota) {
            c.weightx = 0.0;
            result.add((Component)new JLabel(LangRoAll.detalii), c);
            ++c.gridx;
            c.weightx = 1.0;
            this.detalii = new JTextField(10);
            result.add((Component)this.detalii, c);
            ++c.gridy;
            c.gridx = 0;
        }
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.operator), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.waiters = new JComboBox();
        result.add((Component)this.waiters, c);
        this.tables = new JComboBox();
        if (showMasaFilter) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            result.add((Component)new JLabel(LangRoAll.masa), c);
            ++c.gridx;
            c.weightx = 1.0;
            result.add((Component)this.tables, c);
        }
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.tip), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tip = new JComboBox();
        result.add((Component)this.tip, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.clienti = new JComboBox();
        result.add((Component)this.clienti, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.angajat), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.angajati = new JComboBox();
        result.add((Component)this.angajati, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.modPlata), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.modPlata = new JComboBox();
        result.add((Component)this.modPlata, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        this.updateTotals(this.data);
    }

    private void addNoteToFactura(Component parent, Vector<NoteView> newData, AddFacturaPanel facturaPanel, Client client) {
        String magazie;
        int idMagazie;
        boolean inlocuimNota = false;
        if (VpConfig.getInstance().inlocuireNotaLaFacturareDialog) {
            inlocuimNota = DialogUtils.confirmDialog(parent, LangRoAll.adaugamFacturaCuDescarcare, LangRoAll.confirmare);
        }
        double suma = 0.0;
        Hashtable<Integer, Integer> ids = new Hashtable<Integer, Integer>();
        for (int i = 0; i < newData.size(); ++i) {
            NoteView noteView = newData.elementAt(i);
            suma += noteView.getSuma();
            ids.put(noteView.getIdOrder(), 1);
        }
        boolean addItems = true;
        int idCodProdusFacturare = VpConfig.getInstance().livrariCodProdusFacturare;
        if (idCodProdusFacturare > 0 && DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.adaugamProdusulGeneric, new String[0]), LangRoAll.confirmare)) {
            Product p = NomeclaturaLogic.getInstance().getProductByCod(idCodProdusFacturare);
            if (p != null) {
                NoteView nv = new NoteView();
                nv.setCantitate(1.0);
                nv.setProdus(p.getName());
                nv.setIdProdus(p.getId());
                nv.setSuma(suma);
                nv.setIdOrder(-1);
                newData.clear();
                newData.add(nv);
                idMagazie = 0;
                magazie = LangRoAll.faraDescarcare;
                Vector<Integer> ids1 = new Vector<Integer>(ids.keySet());
                facturaPanel.addNotaEntry(nv, magazie, idMagazie, client, ids1);
                addItems = false;
            } else {
                DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.produsulCuCodulInternNuAFostGasit, idCodProdusFacturare + ""), LangRoAll.confirmare);
                return;
            }
        }
        if (addItems) {
            for (int i = 0; i < newData.size(); ++i) {
                NoteView noteView = newData.elementAt(i);
                idMagazie = 0;
                magazie = LangRoAll.faraDescarcare;
                if (inlocuimNota) {
                    Table t = RestLogic.getInstance().getTableById(noteView.getIdTable());
                    int idLocatie = t.getIdLocatie();
                    idMagazie = RestLogic.getInstance().getIdMagazie(noteView.getIdProdus(), idLocatie);
                    Magazie m = StockLogic.getInstance().getMagazieById(idMagazie);
                    magazie = m.getLabel();
                }
                facturaPanel.addNotaEntry(noteView, magazie, idMagazie, client, null);
            }
        }
        facturaPanel.sortEntries();
        facturaPanel.populateWithDiscount();
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.waiters, this.logic.getWaiters());
        ComboUtils.replaceItemsForCombo(this.tables, this.logic.getTables());
        ComboUtils.replaceItemsForCombo(this.clienti, ClientLogic.getInstance().getAllClientsSorted());
        ComboUtils.replaceItemsForCombo(this.ture, RestLogic.getInstance().getShifts());
        ComboUtils.replaceItemsForCombo(this.modPlata, TipPlataProvider.getInstance().getTipPlata());
        this.tip.addItem("All");
        this.tip.addItem("Normal");
        this.tip.addItem(Constants.PROTOCOL_STRING);
        final NoteReportPanel parent = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final NoteView nv = (NoteView)NoteReportPanel.this.data.elementAt(selRow);
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) > 0) {
                    int idOrder = nv.getIdOrder();
                    for (Object obj : NoteReportPanel.this.data) {
                        NoteView n = (NoteView)obj;
                        if (n.getIdOrder() != idOrder) continue;
                        n.setSelected(!n.isSelected());
                    }
                    Order o = (Order)NoteReportPanel.this.selectedOrders.get(idOrder);
                    if (o != null) {
                        NoteReportPanel.this.selectedOrders.remove(idOrder);
                    } else {
                        o = NoteReportPanel.this.logic.getOrderById(idOrder);
                        NoteReportPanel.this.selectedOrders.put(idOrder, o);
                    }
                    NoteReportPanel.this.selectateLabel.setText(NoteReportPanel.this.selectedOrders.size() + "");
                    NoteReportPanel.this.tm.fireTableDataChanged();
                } else {
                    final JPopupMenu popup = new JPopupMenu();
                    JMenuItem reprint = new JMenuItem(LangRoAll.retiparesteNota);
                    JMenuItem factura = new JMenuItem(LangRoAll.trimiteLaFacturare);
                    JMenuItem deleteProdus = new JMenuItem(LangRoAll.modificaCantitatea);
                    JMenuItem delete = new JMenuItem(LangRoAll.stergeNota);
                    JMenuItem facturaCiel = new JMenuItem(LangRoAll.exportFacturareCiel);
                    if (popupShowFacturare) {
                        popup.add(factura);
                    }
                    popup.add(reprint);
                    if (VpConfig.getInstance().allowStergere) {
                        popup.add(deleteProdus);
                        popup.add(delete);
                    }
                    if (popupShowExportCiel) {
                        popup.add(facturaCiel);
                    }
                    popup.setInvoker(NoteReportPanel.this.table);
                    deleteProdus.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            String value;
                            if (DialogUtils.confirmDialog(parent, LangRoAll.modificamCantitateaLa + nv.getProdus(), LangRoAll.confirmare) && Validators.correctDouble(value = DialogUtils.inputDialog(parent, Utils.getString3Decimals(nv.getCantitate()), LangRoAll.cantitateaDeSters))) {
                                double quantity = Utils.parseDouble(value);
                                NoteReportPanel.this.logic.deleteQuantityFromClosedOrder(nv.getIdOrder(), nv.getIdProdus(), nv.getProdus(), AdministrationPanel.loggedUser, quantity, null);
                                NoteReportPanel.this.raport();
                                NoteReportPanel.this.stergeSelectia.doClick();
                            }
                            popup.setVisible(false);
                        }
                    });
                    delete.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (DialogUtils.confirmDialog(parent, LangRoAll.stergemNota, LangRoAll.confirmare)) {
                                Order or = NoteReportPanel.this.logic.getOrderById(nv.getIdOrder());
                                User currentLoggedUser = AdministrationPanel.loggedUser;
                                NoteReportPanel.this.logic.deleteOrder(or, currentLoggedUser, "", parent, true);
                                NoteReportPanel.this.raport();
                                NoteReportPanel.this.stergeSelectia.doClick();
                            }
                            popup.setVisible(false);
                            NoteReportPanel.this.stergeSelectia.doClick();
                        }
                    });
                    reprint.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Order o = NoteReportPanel.this.logic.getOrderById(nv.getIdOrder());
                            Table t = NoteReportPanel.this.logic.getTableById(nv.getIdTable());
                            if (DialogUtils.confirmDialog(parent, LangRoAll.tiparimNota, LangRoAll.confirmare)) {
                                NoteReportPanel.this.logic.reprintNota(o, t, null);
                            }
                            if (DialogUtils.confirmDialog(parent, LangRoAll.tiparimBonFiscal, LangRoAll.confirmare)) {
                                NoteReportPanel.this.logic.printBonFiscalSeparat(o, true);
                            }
                            popup.setVisible(false);
                            NoteReportPanel.this.raport();
                            NoteReportPanel.this.stergeSelectia.doClick();
                        }
                    });
                    factura.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Hashtable<String, Integer> h = new Hashtable<String, Integer>();
                            h.put("id_order_key", nv.getIdOrder());
                            Vector<NoteView> newData = NoteReportPanel.this.logic.getNote(h, false, NoteReportPanel.this.whatToPrint);
                            AddFacturaPanel facturaPanel = FacturiLogic.getInstance().getAddFacturaPanel();
                            if (facturaPanel != null) {
                                Order o = NoteReportPanel.this.logic.getOrderById(nv.getIdOrder());
                                Client client = ClientLogic.getInstance().getClientById(o.getIdClient());
                                NoteReportPanel.this.addNoteToFactura(parent, newData, facturaPanel, client);
                            } else {
                                DialogUtils.errorDialog(parent, LangRoAll.nuAvetiAccesLaFacturare, LangRoAll.nuPotContinua);
                            }
                            popup.setVisible(false);
                            NoteReportPanel.this.raport();
                            NoteReportPanel.this.stergeSelectia.doClick();
                        }
                    });
                    facturaCiel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Hashtable<String, Integer> h = new Hashtable<String, Integer>();
                            h.put("id_order_key", nv.getIdOrder());
                            Vector<NoteView> newData = NoteReportPanel.this.logic.getNote(h, false, NoteReportPanel.this.whatToPrint);
                            try {
                                FacturiLogic.getInstance().exportFacturaToCiel(newData);
                            }
                            catch (IOException e1) {
                                Logger.logException(this, (Exception)e1);
                            }
                            popup.setVisible(false);
                            NoteReportPanel.this.raport();
                            NoteReportPanel.this.stergeSelectia.doClick();
                        }
                    });
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        final ClientLogic clientLogic = ClientLogic.getInstance();
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "NoteReport_persJuridice";
            }

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(NoteReportPanel.this.clienti, ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 42);
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "NoteReport_persFizice";
            }

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(NoteReportPanel.this.clienti, ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 41);
        this.clienti.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboUtils.anythingButAllSelected(NoteReportPanel.this.clienti)) {
                    Client c = (Client)NoteReportPanel.this.clienti.getSelectedItem();
                    if (c instanceof ClientPersJuridica) {
                        ClientPersJuridica c1 = (ClientPersJuridica)c;
                        Vector angajatiForCompanie = clientLogic.getAnjagati(c1.getIdPersJuridica());
                        ComboUtils.replaceItemsForCombo(NoteReportPanel.this.angajati, angajatiForCompanie);
                    } else {
                        ComboUtils.replaceItemsForCombo(NoteReportPanel.this.angajati, new Vector());
                    }
                } else {
                    ComboUtils.replaceItemsForCombo(NoteReportPanel.this.angajati, new Vector());
                }
            }
        });
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 6;
                    }
                    case 1: {
                        return 6;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 3;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.total;
                    }
                    case 3: {
                        return NoteReportPanel.this.totalSuma.getText();
                    }
                    case 4: {
                        return NoteReportPanel.this.totalDiscount.getText();
                    }
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return NoteReportPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return NoteReportPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                NoteView fe = (NoteView)row;
                if (fe == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        return NoteReportPanel.this.getFirstColumnValue(fe);
                    }
                    case 1: {
                        return fe.getProdus();
                    }
                    case 2: {
                        return Utils.getString3Decimals(fe.getCantitate());
                    }
                    case 3: {
                        return Utils.getString2Decimals(fe.getSuma());
                    }
                    case 4: {
                        return fe.getData() != null ? Formatters.DATE_AND_TIME_FORMAT.format(fe.getData()) : "";
                    }
                }
                return null;
            }
        };
        this.asciiReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return LangRoAll.produs + "|" + LangRoAll.cantitate + "|" + LangRoAll.valoare;
                    }
                }
                return null;
            }

            @Override
            public String getTotal(int column) {
                if (column == 0) {
                    String s = LangRoAll.total + ": " + NoteReportPanel.this.totalSuma.getText() + "\n" + LangRoAll.discount + ": " + NoteReportPanel.this.totalDiscount.getText();
                    return s;
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return NoteReportPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return NoteReportPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                NoteView fe = (NoteView)row;
                if (fe == null) {
                    return null;
                }
                if (column == 0) {
                    if (fe.getData() != null) {
                        String s = "\n" + NoteReportPanel.this.getFirstColumnValue(fe) + "," + Utils.getString2Decimals(fe.getTotalNota()) + "," + Formatters.DATE_AND_TIME_FORMAT.format(fe.getData());
                        s = s + "\n";
                        s = s + fe.getProdus() + "|" + Utils.getString3Decimals(fe.getCantitate()) + "|" + Utils.getString2Decimals(fe.getSuma());
                        return s;
                    }
                    String s = fe.getProdus() + "|" + Utils.getString3Decimals(fe.getCantitate()) + "|" + Utils.getString2Decimals(fe.getSuma());
                    return s;
                }
                return "";
            }
        };
        this.ture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ComboUtils.anythingButAllSelected(NoteReportPanel.this.ture)) {
                    Shift s = (Shift)NoteReportPanel.this.ture.getSelectedItem();
                    NoteReportPanel.this.dateSelector.selectPeriod();
                    NoteReportPanel.this.dateSelector.setStartDate(s.getStart());
                    NoteReportPanel.this.dateSelector.setStopDate(s.getStop());
                } else {
                    NoteReportPanel.this.dateSelector.setStartDate(DateUtils.getStartOfDay(new Date()));
                    NoteReportPanel.this.dateSelector.setStopDate(DateUtils.getEndOfDay(new Date()));
                    NoteReportPanel.this.dateSelector.selectDay();
                }
            }
        });
        this.updateJTableColumns(this.table);
        this.table.setSelectionMode(0);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    public void updateTotals(Vector items) {
        double suma = 0.0;
        double discount = 0.0;
        for (NoteView element : items) {
            suma += element.getSuma();
            discount += element.getDiscount();
        }
        this.totalSuma.setText(Utils.getString2Decimals(suma));
        this.totalDiscount.setText(Utils.getString2Decimals(discount));
    }

    private void updateJTableColumns(JTable unu) {
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                NoteView nv = (NoteView)NoteReportPanel.this.data.elementAt(row);
                if (nv.isSelected()) {
                    this.setBackground(Color.YELLOW);
                    this.setForeground(Color.BLACK);
                } else {
                    this.setBackground(Color.WHITE);
                    this.setForeground(Color.BLACK);
                }
                return this;
            }
        };
        TableColumnModel colModel = unu.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(cellRenderer);
        }
    }

    @Override
    public void exportToXml() {
        String inputFile = FileDialog.getSaveDialogLocation(this, LangRoAll.alegetiFisierulDestinatie, "xml");
        if (inputFile != null) {
            this.logic.exportOrdersToXml(this.printCriteria, this.tm.getData(), inputFile);
            DialogUtils.okDialog(this, LangRoAll.operatieExecutata, LangRoAll.succes);
        }
    }

    @Override
    public boolean showXmlButton() {
        return true;
    }

    static {
        showMasaFilter = true;
        showTuraFilter = true;
        popupShowFacturare = true;
        popupShowExportCiel = true;
        columns = new String[]{(VpConfig.getInstance().showDetaliiNota ? LangRoAll.detalii + "," : "") + LangRoAll.operatorMasaTotal, LangRoAll.produs, LangRoAll.cantitate, LangRoAll.suma, LangRoAll.inchisNota};
    }
}

