/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.retail;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.gui.retail.ProductFoundInterface;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Utils;
import ro.atreides.utils.multilang.LangRoAll;

public class BcrProductFinder
extends JPanel {
    private NomeclaturaLogic logic = NomeclaturaLogic.getInstance();
    private ProductFoundInterface prod;

    public BcrProductFinder(ProductFoundInterface prod) {
        this.prod = prod;
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 1;
        final JLabel produsText = new JLabel();
        final JLabel pretText = new JLabel();
        this.add((Component)new JLabel("Cod"), c);
        ++c.gridx;
        final JTextField cod = new JTextField(20);
        cod.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    BcrProductFinder.this.codCompleted(cod.getText(), produsText, pretText);
                    cod.setText("");
                    cod.requestFocus();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.add((Component)cod, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel(LangRoAll.produs), c);
        ++c.gridx;
        this.add((Component)produsText, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel(LangRoAll.pret), c);
        ++c.gridx;
        this.add((Component)pretText, c);
    }

    private void codCompleted(String cod, JLabel productText, JLabel pretText) {
        String product = "Necunoscut";
        String price = "";
        Product p = this.logic.getProductByCodBare(cod);
        double pret = -1.0;
        if (p != null) {
            product = p.getName();
            pret = RestLogic.getInstance().getPriceForProductCommit(p.getId());
            price = Utils.getString2Decimals(pret);
        }
        productText.setText(product);
        pretText.setText(price);
        this.prod.foundProduct(p, pret);
    }
}

