/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.retail;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.retail.RetailPanel;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class RetailTable
extends AbstractListPanel {
    private RestLogic logic;
    private Order order;
    private Table t;
    private RetailPanel parent;
    private JLabel total = new JLabel("0");
    private double totalMarcat = 0.0;
    private double totalTemp = 0.0;

    public RetailTable(RestLogic logic, Order o, Table t, RetailPanel parent) {
        this.logic = logic;
        this.order = o;
        this.t = t;
        this.parent = parent;
    }

    @Override
    public AbstractTM buildTableModel() {
        return new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Sale rte = (Sale)RetailTable.this.tm.getObjectAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return rte.getProductName();
                    }
                    case 1: {
                        return rte.getQuantity();
                    }
                    case 2: {
                        return Utils.getString2Decimals(rte.getTotal());
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 1;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        result.add((Component)this.total, c);
        final RetailTable panel = this;
        ++c.gridy;
        c.gridx = 0;
        JButton inchide = new JButton("Inchide");
        inchide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                User currentLoggedUser = UsersLogic.getInstance().getUserById(RetailTable.this.order.getUser());
                RetailTable.this.logic.deleteOrder(RetailTable.this.order, currentLoggedUser, "", panel, true);
                RetailTable.this.parent.inchideComanda();
            }
        });
        result.add((Component)inchide, c);
        ++c.gridx;
        JButton nota = new JButton(LangRoAll.nota);
        nota.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Vector<Sale> toAdd;
                boolean newProducts = false;
                Vector categories = RetailTable.this.logic.getSectii();
                for (Sectie element : categories) {
                    toAdd = RetailTable.this.logic.getTemporarySalesForCategory(element, RetailTable.this.tm.getData());
                    if (toAdd.size() == 0) continue;
                    newProducts = true;
                }
                if (!newProducts) {
                    return;
                }
                for (Sectie element : categories) {
                    toAdd = RetailTable.this.logic.getTemporarySalesForCategory(element, RetailTable.this.tm.getData());
                    if (toAdd.size() <= 0) continue;
                    RetailTable.this.logic.productsSold(toAdd, RetailTable.this.order, RetailTable.this.t, element, false, null);
                }
                RetailTable.this.order.setDetalii(RetailTable.this.parent.getDetalii());
                RetailTable.this.logic.setDetalii(RetailTable.this.order);
                RetailTable.this.logic.laPlataOrder(RetailTable.this.order, RetailTable.this.t, null);
                RetailTable.this.totalTemp = 0.0;
                RetailTable.this.refreshTable();
                RetailTable.this.updateTotal();
            }
        });
        result.add((Component)nota, c);
        ++c.gridx;
        JButton achitat = new JButton("Achitat");
        achitat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RetailTable.this.logic.printBonFiscalSeparat(RetailTable.this.order, true);
                RetailTable.this.logic.closeOrder(RetailTable.this.order);
                RetailTable.this.parent.inchideComanda();
            }
        });
        result.add((Component)achitat, c);
        return result;
    }

    @Override
    public Vector buildData() {
        Vector<Sale> sales = this.logic.getSales(this.order.getId(), true, -1, new ScreenSaleInterface());
        if (sales == null) {
            throw new NullPointerException("data might not be null");
        }
        this.totalMarcat = 0.0;
        for (Sale element : sales) {
            this.totalMarcat += element.getPpuOriginal() * element.getCantitateMarcata();
        }
        this.updateTotal();
        return sales;
    }

    private void updateTotal() {
        this.total.setText(Utils.getString2Decimals(this.totalMarcat + this.totalTemp));
    }

    @Override
    public String[] buildColumns() {
        return new String[]{LangRoAll.produs, LangRoAll.cantitate, LangRoAll.valoare};
    }

    @Override
    public Class[] buildTypes() {
        return new Class[]{String.class, String.class, String.class};
    }

    @Override
    public void doStuff() {
        this.display();
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = RetailTable.this.table.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2) {
                    Sale rte = (Sale)RetailTable.this.tm.getObjectAt(selRow);
                    if (DialogUtils.confirmDialog(RetailTable.this.table, "Doriti sa stergeti aceasta vanzare", LangRoAll.confirmare)) {
                        double pret = RetailTable.this.logic.getPriceForProductCommit(rte.getIdProduct());
                        RetailTable.this.totalTemp -= rte.getCantitateNoua() * pret;
                        RetailTable.this.updateTotal();
                        RetailTable.this.tm.fireTableDataChanged();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public Sale addProduct(Product p, double quantity, String modPreparare, int idPlatou, String ordineServire, double price) {
        Vector data = this.tm.getData();
        long now = System.currentTimeMillis();
        Sale toAdd = this.logic.buildSale(p, 0.0, quantity, modPreparare, -1, idPlatou, -1, -1, -1, now, 0);
        data.add(toAdd);
        this.totalTemp += quantity * price;
        this.updateTotal();
        this.tm.fireTableDataChanged();
        return toAdd;
    }
}

