/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.shop;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.gui.reports.NoteReportPanel;
import ro.atreides.users.User;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Order;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class ShopBronzeNoteReportPanel
extends NoteReportPanel {
    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        this.ture = new JComboBox();
        result.add((Component)new JLabel(LangRoAll.tura), c);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.ture, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.operator), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.waiters = new JComboBox();
        result.add((Component)this.waiters, c);
        this.tables = new JComboBox();
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.comanda), c);
        ++c.gridx;
        c.weightx = 1.0;
        result.add((Component)this.tables, c);
        this.clienti = new JComboBox();
        this.angajati = new JComboBox();
        this.modPlata = new JComboBox();
        this.tip = new JComboBox();
        this.detalii = new JTextField(10);
        return result;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        this.totalSuma = new JLabel("");
        result.add((Component)this.totalSuma, c);
        final ShopBronzeNoteReportPanel panel = this;
        ++c.gridx;
        JButton stoc = new JButton(LangRoAll.reproceseazaFisaStoc);
        stoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DialogUtils.confirmDialog(panel, LangRoAll.reprocesamFisaStocPtNote, LangRoAll.confirmare) && DialogUtils.confirmDialog(panel, LangRoAll.putemDereglaFisaStoc, LangRoAll.confirmare)) {
                    int lastOrder = -1;
                    for (int i = 0; i < ShopBronzeNoteReportPanel.this.data.size(); ++i) {
                        NoteView noteView = (NoteView)ShopBronzeNoteReportPanel.this.data.elementAt(i);
                        Order o = ShopBronzeNoteReportPanel.this.logic.getOrderById(noteView.getIdOrder());
                        if (lastOrder != o.getId()) {
                            ShopBronzeNoteReportPanel.this.logic.notifyObjectListeners(104, o);
                            System.out.println("Am procesat i=" + i + " din size=" + ShopBronzeNoteReportPanel.this.data.size() + " timestamp=" + new Timestamp(o.getStopTime()));
                        }
                        lastOrder = o.getId();
                    }
                }
            }
        });
        result.add((Component)stoc, c);
        ++c.gridx;
        JButton sterge = new JButton(LangRoAll.sterge);
        sterge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (VpConfig.getInstance().allowStergere && DialogUtils.confirmDialog(panel, LangRoAll.stergemNoteleSelectate, LangRoAll.confirmare)) {
                    User currentLoggedUser = AdministrationPanel.loggedUser;
                    for (int i = 0; i < ShopBronzeNoteReportPanel.this.data.size(); ++i) {
                        NoteView nv = (NoteView)ShopBronzeNoteReportPanel.this.data.elementAt(i);
                        Order or = ShopBronzeNoteReportPanel.this.logic.getOrderById(nv.getIdOrder());
                        if (or == null) continue;
                        ShopBronzeNoteReportPanel.this.logic.deleteOrder(or, currentLoggedUser, "", panel, false);
                    }
                    ShopBronzeNoteReportPanel.this.tm.refresh(ShopBronzeNoteReportPanel.this.logic.getNote(ShopBronzeNoteReportPanel.this.criteria, false, ShopBronzeNoteReportPanel.this.whatToPrint));
                }
            }
        });
        result.add((Component)sterge, c);
        this.totalDiscount = new JLabel("");
        return result;
    }

    @Override
    public void doStuff() {
        super.doStuff();
        popupShowExportCiel = false;
        popupShowFacturare = false;
    }

    static {
        columns = new String[]{LangRoAll.operatorPOSTotal, LangRoAll.produs, LangRoAll.cantitate, LangRoAll.suma, LangRoAll.inchisComanda};
    }
}

