/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.touch;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JPanel;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.touch.LocationPanel;
import ro.atreides.restaurant.gui.touch.TouchOrder;
import ro.atreides.restaurant.gui.touch.WaitersSelection;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Order;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class TouchMain
extends ReflectedJPanel
implements CleanupRequired {
    private RestLogic logic = RestLogic.getInstance();
    private User currentUser;
    private Table table;
    private LocationPanel locationPanel;
    private WaitersSelection waitersPanel;
    private TouchOrder orderPanel;
    public static Vector locations;
    public static Vector sectii;
    public static boolean controllerMode;

    @Override
    public void doStuff() {
        this.locationPanel = new LocationPanel(this.logic, this, locations);
        this.orderPanel = new TouchOrder(this.logic, this, sectii);
        this.waitersPanel = new WaitersSelection(this, controllerMode);
        this.setLayout(new GridBagLayout());
        this.switchPanel(this.locationPanel);
    }

    @Override
    public void cleanup() {
        this.locationPanel.cleanup();
    }

    private void switchPanel(JPanel newPanel) {
        this.setVisible(false);
        this.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(7, 7, 7, 7);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)newPanel, c);
        this.setVisible(true);
    }

    public void tableSelected(Table t) {
        this.table = t;
        if (this.currentUser == null) {
            this.switchPanel(this.waitersPanel);
            this.waitersPanel.focus();
        } else {
            Order o = this.logic.getOpenOrderAtTable(t);
            if (o == null || o.getUser() == this.currentUser.getId()) {
                this.orderPanel.setTable(t, this.currentUser, o);
                this.switchPanel(this.orderPanel);
            }
        }
    }

    public void logout() {
        User oldUser = this.currentUser;
        this.logic.alertProductie(this.currentUser);
        this.currentUser = null;
        this.locationPanel.waiterChanged(this.currentUser, oldUser);
    }

    public void waiterSelected(User w, User boUser) {
        if (w != null || boUser != null) {
            Table t = this.table;
            Order o = this.logic.getOpenOrderAtTable(t);
            Integer tableOwner = null;
            if (o != null) {
                tableOwner = o.getUser();
            }
            if (w != null) {
                this.currentUser = w;
                this.locationPanel.waiterChanged(this.currentUser, this.currentUser);
                if (o == null || tableOwner != null && tableOwner.equals(w.getId())) {
                    this.orderPanel.setTable(t, w, o);
                    this.switchPanel(this.orderPanel);
                } else if (boUser != null) {
                    User tableUser;
                    this.currentUser = tableUser = UsersLogic.getInstance().getUserById(tableOwner);
                    this.locationPanel.waiterChanged(this.currentUser, this.currentUser);
                    this.orderPanel.setTable(t, tableUser, o);
                    this.switchPanel(this.orderPanel);
                } else {
                    this.switchPanel(this.locationPanel);
                }
            } else if (tableOwner == null) {
                DialogUtils.errorDialog(this, LangRoAll.nuPutetiDeschideMese, LangRoAll.nuPotContinua);
                this.switchPanel(this.locationPanel);
            } else {
                User tableUser;
                this.currentUser = tableUser = UsersLogic.getInstance().getUserById(tableOwner);
                this.locationPanel.waiterChanged(this.currentUser, this.currentUser);
                this.orderPanel.setTable(t, tableUser, o);
                this.switchPanel(this.locationPanel);
            }
        } else {
            this.currentUser = null;
            this.locationPanel.waiterChanged(this.currentUser, this.currentUser);
            this.switchPanel(this.locationPanel);
        }
    }

    public void logout(Order o) {
        this.logout();
        this.plan(o);
    }

    public void plan(Order o) {
        if (o != null) {
            this.locationPanel.tableStatusChanged(this.table, o);
        } else {
            this.locationPanel.tableStatusChanged(this.table, null);
        }
        this.switchPanel(this.locationPanel);
    }

    public void nota(Order o) {
        this.locationPanel.tableStatusChanged(this.table, o);
        this.switchPanel(this.locationPanel);
    }
}

