/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.touch;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.gui.ClientEditDialog;
import ro.atreides.clienti.gui.ClientEditPanelProvider;
import ro.atreides.clienti.gui.ClientSelectDialog;
import ro.atreides.clienti.gui.PersFizicaAddEditPanel;
import ro.atreides.clienti.gui.PersJuridicaAddEditPanel;
import ro.atreides.facturi.gui.AddFacturaDialog;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.promo.ClientPromotieView;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.promo.gui.PromotiiDialog;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Meniu;
import ro.atreides.restaurant.base.OptiuneMeniu;
import ro.atreides.restaurant.base.OptiuneProdus;
import ro.atreides.restaurant.base.OrdineServire;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.ModPreparareDialog;
import ro.atreides.restaurant.gui.OrdineServireDialog;
import ro.atreides.restaurant.gui.ProdusDialog;
import ro.atreides.restaurant.gui.TransferDialog;
import ro.atreides.restaurant.gui.meniuri.MeniuriDialog;
import ro.atreides.restaurant.gui.touch.LocationPanel;
import ro.atreides.restaurant.gui.touch.TouchMain;
import ro.atreides.restaurant.gui.touch.TouchOrderColorProvider;
import ro.atreides.restaurant.gui.touch.TouchOrderTableModel;
import ro.atreides.restaurant.logic.PaymentLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.events.EventsLogic;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.CardInputDialog;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.keypad.KeypadListener;
import ro.atreides.utils.gui.keypad.VirtualKeypad;
import ro.atreides.utils.gui.selector.DataProvider;
import ro.atreides.utils.gui.selector.Selector;
import ro.atreides.utils.gui.table.CustomCellRenderer;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.PlatiOperationsInterface;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataButtonPushed;
import ro.atreides.utils.plati.TipPlataProvider;
import ro.atreides.utils.users.gui.ChooseUserDialog;

public class TouchOrder
extends JPanel {
    private JLabel tableNo;
    private JLabel total;
    private JCheckBox protocol;
    private JButton incasat;
    private JButton marcaj;
    private JButton retur;
    private JButton platouButton;
    private JButton fidelitate;
    private JButton promotie;
    private JButton transfer;
    private JButton preparare;
    private JButton servireButton;
    private JButton incarcaCasaButton;
    private JButton ospatar;
    private JLabel selectie;
    private JLabel promoText;
    private JLabel clientText;
    private Insets insets = new Insets(1, 1, 1, 1);
    private RestLogic logic;
    private VpConfig config;
    private PlatiOperationsInterface op;
    private TouchOrderTableModel tm;
    private Selector selector;
    private double cantitateCurenta = 0.0;
    private double pretNormal;
    private Product produsCurent;
    private Sale entry;
    private boolean platou;
    private boolean alterPrice;
    private int platouId = 0;
    private int idServire = -1;
    private String preparareString;
    private TouchMain main;
    private Table table;
    private Order order;
    private User waiter;
    private Table transferSource;
    private int decimals;
    private DecimalFormat truncFormat;
    private DecimalFormat notruncFormat;
    private Vector sectiiNames;
    private double pretCurent = -1.0;
    private static final int KB_CANT_MODE = 1;
    private static final int KB_PLATA_MODE = 2;
    private int kb_mode = 1;
    private TipPlata tipPlata = null;

    public TouchOrder(RestLogic logic, TouchMain main, Vector sectii) {
        this.logic = logic;
        this.main = main;
        this.sectiiNames = sectii;
        this.config = VpConfig.getInstance();
        this.decimals = this.config.touchDecimals;
        switch (this.decimals) {
            case 0: {
                this.truncFormat = Formatters.NUMBER_0DECIMALS;
                this.notruncFormat = Formatters.NUMBER_0DECIMALS;
                break;
            }
            case 1: {
                this.truncFormat = Formatters.NUMBER_1DECIMALS;
                this.notruncFormat = Formatters.NUMBER_1DECIMALS_NO_TRUNC;
                break;
            }
            case 2: {
                this.truncFormat = Formatters.NUMBER_2DECIMALS;
                this.notruncFormat = Formatters.NUMBER_2DECIMALS_NO_TRUNC;
                break;
            }
            case 3: {
                this.truncFormat = Formatters.NUMBER_3DECIMALS;
                this.notruncFormat = Formatters.NUMBER_3DECIMALS_NO_TRUNC;
                break;
            }
        }
        this.init();
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        this.add((Component)this.getTopPanel(), c);
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        JPanel left = this.getLeftPanel();
        this.add((Component)left, c);
        ++c.gridx;
        c.weighty = 0.0;
        c.weightx = 1.0;
        JPanel middle = this.getMiddlePanel();
        this.add((Component)middle, c);
        ++c.gridx;
        c.weighty = 0.0;
        c.weightx = 0.0;
        JPanel right = this.getRightPanel();
        this.add((Component)right, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.selector = this.getBottomPanel();
        this.add((Component)this.selector, c);
        int leftWidth = 150;
        int middleWidth = 480;
        int rightWidth = 370;
        int middleHeight = 270;
        left.setPreferredSize(new Dimension(leftWidth, middleHeight));
        middle.setPreferredSize(new Dimension(middleWidth, middleHeight));
        right.setPreferredSize(new Dimension(rightWidth, middleHeight));
    }

    private void init() {
    }

    private JPanel getLeftPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        final TouchOrder parent = this;
        JButton nota = new JButton("<html><center>Nota<br></center></html>");
        nota.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                boolean triggerIncasat;
                boolean duplicat;
                if (VpConfig.getInstance().notaTriggersBon) {
                    TouchOrder.this.marcaj.doClick();
                }
                int totalRows = TouchOrder.this.tm.getRowCount();
                int maxItems = ((TouchOrder)TouchOrder.this).config.ecrMaxItems;
                if (maxItems > 0 && totalRows > maxItems && !DialogUtils.confirmDialog(parent, LangRoAll.maxProducts1 + maxItems + LangRoAll.maxProducts2, "Atentie")) {
                    return;
                }
                boolean bl = duplicat = TouchOrder.this.order != null && TouchOrder.this.order.isLaPlata();
                if (duplicat) {
                    if (VpConfig.getInstance().allowNoteDuplicate) {
                        if (!DialogUtils.confirmDialog(parent, LangRoAll.tiparimNotaDuplicat, LangRoAll.confirmare)) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                TouchOrder.this.nota(!(triggerIncasat = VpConfig.getInstance().notaTriggersIncasat));
                TouchOrder.this.idServire = -1;
                if (triggerIncasat) {
                    TouchOrder.this.incasat.doClick();
                }
            }
        });
        result.add((Component)nota, c);
        if (VpConfig.getInstance().showProformaButton) {
            ++c.gridy;
            JButton intermediara = new JButton("<html><center>Proforma<br></center></html>");
            intermediara.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    User supervizor = null;
                    if (((TouchOrder)TouchOrder.this).config.passwordForProforma) {
                        supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    }
                    if (supervizor != null || !((TouchOrder)TouchOrder.this).config.passwordForProforma) {
                        TouchOrder.this.logic.notaProforma(TouchOrder.this.order, TouchOrder.this.table, null);
                    }
                }
            });
            result.add((Component)intermediara, c);
        }
        ++c.gridy;
        this.incasat = new JButton("<html><center>Incasat<br></center></html>");
        this.incasat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TouchOrder.this.incasat();
                if (((TouchOrder)TouchOrder.this).config.logoutAtIncasat) {
                    TouchOrder.this.logout();
                } else {
                    TouchOrder.this.main.nota(TouchOrder.this.order);
                }
            }
        });
        this.incasat.setEnabled(false);
        result.add((Component)this.incasat, c);
        ++c.gridy;
        JButton plan = new JButton("<html><center>Mese<br></center></html>");
        plan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TouchOrder.this.goToMese();
            }
        });
        result.add((Component)plan, c);
        ++c.gridy;
        JButton logout = new JButton("<html><center>Logout<br></center></html>");
        logout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TouchOrder.this.logout();
            }
        });
        result.add((Component)logout, c);
        return result;
    }

    private boolean nota(boolean gotoMese) {
        if (this.order != null) {
            this.logic.laPlataOrder(this.order, this.table, null);
            if (!this.config.allowMarcajAfterNota) {
                this.marcaj.setEnabled(false);
            }
            this.incasat.setEnabled(true);
            if (VpConfig.getInstance().bonFiscalAtNota) {
                this.logic.printBonFiscalSeparat(this.order, true);
            }
            if (gotoMese) {
                this.main.nota(this.order);
                if (VpConfig.getInstance().logoutAtNota) {
                    this.logout();
                }
            }
            return true;
        }
        return false;
    }

    private void incasat() {
        boolean ok = false;
        if (VpConfig.getInstance().passwordForIncasat) {
            User supervizor = null;
            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
            if (supervizor != null) {
                ok = true;
            }
        } else {
            ok = true;
        }
        if (!ok) {
            return;
        }
        if (!VpConfig.getInstance().bonFiscalAtNota) {
            this.logic.printBonFiscalSeparat(this.order, true);
        }
        this.logic.closeOrder(this.order);
        this.marcaj.setEnabled(true);
        this.incasat.setEnabled(false);
        this.order = null;
        this.idServire = -1;
        TipPlataProvider.getInstance().cleanPlatiLabel1();
    }

    private void updateTotal() {
        String newTotal = Utils.getString2Decimals(this.tm.getTotal());
        this.total.setText(newTotal);
    }

    private JPanel getTopPanel() {
        final JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        final TouchOrder parent = this;
        c.gridx = 0;
        c.gridy = 0;
        this.ospatar = new JButton("");
        this.ospatar.setForeground(Color.RED);
        this.ospatar.setFont(new Font(null, 1, this.config.touchKeypadFontSize));
        this.ospatar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (TouchOrder.this.order == null) {
                    return;
                }
                if (!DialogUtils.confirmDialog(parent, LangRoAll.schimbamOspatarul, LangRoAll.confirmare)) {
                    return;
                }
                Vector users = TouchOrder.this.logic.getWaiters();
                User supervizor = null;
                supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                if (supervizor != null && !TouchOrder.this.order.isLaPlata() && users.size() > 0) {
                    ChooseUserDialog dialog1 = new ChooseUserDialog(4, users);
                    int idUser = dialog1.getSelected();
                    TouchOrder.this.logic.setUserToOrder(idUser, TouchOrder.this.order);
                    TouchOrder.this.goToMese();
                }
            }
        });
        result.add((Component)this.ospatar, c);
        c.gridy = 1;
        this.tableNo = new JLabel("");
        result.add((Component)this.tableNo, c);
        c.gridy = 0;
        this.protocol = new JCheckBox(LangRoAll.protocol);
        this.protocol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean newState = TouchOrder.this.protocol.isSelected();
                User supervizor = null;
                if (((TouchOrder)TouchOrder.this).config.passwordForProtocol) {
                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                }
                if (supervizor != null || !((TouchOrder)TouchOrder.this).config.passwordForProtocol) {
                    TouchOrder.this.createOrderIfNull();
                    if (!TouchOrder.this.order.isLaPlata()) {
                        TouchOrder.this.logic.setProtocolForOrder(TouchOrder.this.order, newState);
                        TouchOrder.this.order.setProtocol(newState);
                        TouchOrder.this.setProtocolColor();
                    } else {
                        TouchOrder.this.protocol.setSelected(!newState);
                    }
                } else {
                    TouchOrder.this.protocol.setSelected(!newState);
                }
            }
        });
        c.weightx = 1.0;
        if (VpConfig.getInstance().showProtocolButton) {
            c.gridx = 1;
            result.add((Component)this.protocol, c);
        }
        c.gridx = 2;
        c.gridy = 0;
        this.promoText = new JLabel("");
        this.promoText.setForeground(Color.RED);
        this.promoText.setFont(new Font(null, 1, this.config.touchKeypadFontSize));
        result.add((Component)this.promoText, c);
        c.gridy = 1;
        this.clientText = new JLabel("");
        this.clientText.setForeground(Color.RED);
        this.clientText.setFont(new Font(null, 1, this.config.touchKeypadFontSize));
        result.add((Component)this.clientText, c);
        final TouchOrder panel = this;
        c.gridheight = 1;
        if (VpConfig.getInstance().showTipsButton) {
            c.gridx = 3;
            c.gridy = 0;
            JButton tips = new JButton(LangRoAll.tips);
            tips.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TouchOrder.this.order != null) {
                        double proposedTips = TouchOrder.this.logic.computeTipsForOrder(TouchOrder.this.order);
                        if (proposedTips >= 0.0) {
                            String value = DialogUtils.inputDialog(panel, Utils.getString2Decimals(proposedTips), LangRoAll.totalTips);
                            if (Validators.correctDouble(value)) {
                                double totalTips = Utils.parseDouble(value);
                                TouchOrder.this.logic.setTipsToOrder1(TouchOrder.this.order, totalTips, null);
                                Vector<Sale> s = TouchOrder.this.logic.getSales(TouchOrder.this.order.getId(), true, -1, new ScreenSaleInterface());
                                TouchOrder.this.tm.updateTable(s);
                                TouchOrder.this.updateTotal();
                            } else {
                                DialogUtils.errorDialog(panel, LangRoAll.valoareIncorecta, LangRoAll.nuPotContinua);
                            }
                        } else if (proposedTips == -1.0) {
                            DialogUtils.errorDialog(panel, LangRoAll.completatiCodProdusTips, LangRoAll.nuPotContinua);
                        } else if (proposedTips == -2.0) {
                            DialogUtils.errorDialog(panel, LangRoAll.codProdusTipsIncorect, LangRoAll.nuPotContinua);
                        }
                    } else {
                        DialogUtils.errorDialog(panel, "Nu pot stabili tips la o masa goala", LangRoAll.nuPotContinua);
                    }
                }
            });
            result.add((Component)tips, c);
        }
        if (VpConfig.getInstance().showPriceButton) {
            c.gridx = 3;
            c.gridy = 1;
            JButton price = new JButton(LangRoAll.pret);
            price.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (TouchOrder.this.produsCurent == null) {
                        DialogUtils.errorDialog(panel, "Selectati un produs", LangRoAll.nuPotContinua);
                        TouchOrder.this.pretCurent = -1.0;
                    } else {
                        User supervizor = null;
                        if (((TouchOrder)TouchOrder.this).config.passwordForPret) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor != null || !((TouchOrder)TouchOrder.this).config.passwordForPret) {
                            TouchOrder.this.pretCurent = TouchOrder.this.logic.getPriceForProductCommit(TouchOrder.this.produsCurent.getId());
                            TouchOrder.this.pretNormal = TouchOrder.this.pretCurent;
                            String value = DialogUtils.inputDialog(panel, Utils.getString2Decimals(TouchOrder.this.pretCurent), "Pret pentru " + TouchOrder.this.produsCurent.getName());
                            if (Validators.correctDouble(value)) {
                                TouchOrder.this.pretCurent = Utils.parseDouble(value);
                                TouchOrder.this.alterPrice = true;
                            } else {
                                DialogUtils.errorDialog(panel, LangRoAll.valoareIncorecta, LangRoAll.nuPotContinua);
                                TouchOrder.this.pretCurent = -1.0;
                            }
                        }
                    }
                }
            });
            result.add((Component)price, c);
        }
        c.gridx = 4;
        c.gridy = 0;
        JButton meniu = new JButton(LangRoAll.meniu);
        meniu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MeniuriDialog dia;
                Meniu selected;
                Vector<Meniu> meniuri = TouchOrder.this.logic.getAllMeniuri();
                if (meniuri.size() > 0 && (selected = (dia = new MeniuriDialog(5, meniuri)).getMeniu()) != null) {
                    Vector optiuniMeniu = TouchOrder.this.logic.getOptiuniForMenu(selected.getId());
                    for (int i = 0; i < optiuniMeniu.size(); ++i) {
                        OptiuneMeniu optiuneMeniu = (OptiuneMeniu)optiuniMeniu.elementAt(i);
                        Vector produse = TouchOrder.this.logic.getOptiuniProdusFrontOffice(selected.getId(), optiuneMeniu.getIdOptiune());
                        ProdusDialog dia2 = new ProdusDialog(5, produse);
                        OptiuneProdus optiuneProdus = dia2.getP();
                        if (optiuneProdus == null) continue;
                        int idProdus = optiuneProdus.getIdProdus();
                        Product pr = NomeclaturaLogic.getInstance().getProductById(idProdus);
                        Sale newSale = TouchOrder.this.logic.buildSale(pr, 0.0, optiuneProdus.getCantitate(), TouchOrder.this.preparareString, -1, -1, -1, -1, TouchOrder.this.idServire, System.currentTimeMillis(), optiuneProdus.getPret(), "", 0);
                        TouchOrder.this.tm.addSale(newSale);
                    }
                    TouchOrder.this.produsCurent = null;
                    TouchOrder.this.entry = null;
                    TouchOrder.this.cantitateCurenta = 0.0;
                    TouchOrder.this.setSelectie(TouchOrder.this.selectie, "");
                    TouchOrder.this.disableCorrectionButtons();
                    TouchOrder.this.resetPreparare();
                    TouchOrder.this.updateTotal();
                }
            }
        });
        result.add((Component)meniu, c);
        if (this.logic.getCashRegister().numerarInputReady()) {
            ++c.gridy;
            this.incarcaCasaButton = new JButton(LangRoAll.incarcaCasa);
            this.incarcaCasaButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String s = DialogUtils.inputDialog(panel, "0", LangRoAll.valoareIncarcaCasa);
                    if (!Validators.correctDouble(s)) {
                        DialogUtils.errorDialog(panel, "Valoare incorecta", LangRoAll.nuPotContinua);
                        return;
                    }
                    double value = Utils.parseDouble(s);
                    TouchOrder.this.logic.introduNumerar(value);
                }
            });
            result.add((Component)this.incarcaCasaButton, c);
        }
        c.gridy = 0;
        c.gridx = 5;
        JButton facturare = new JButton(LangRoAll.factura);
        facturare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<NoteView> newData = new Vector();
                if (TouchOrder.this.order != null) {
                    Hashtable<String, Integer> h = new Hashtable<String, Integer>();
                    h.put("id_order_key", TouchOrder.this.order.getId());
                    newData = TouchOrder.this.logic.getNote(h, true, 1);
                    new AddFacturaDialog(true, result, newData, TouchOrder.this.order.getIdClient(), null);
                }
            }
        });
        result.add((Component)facturare, c);
        c.gridy = 1;
        c.gridheight = 1;
        JButton client = new JButton(LangRoAll.client);
        final ClientEditPanelProvider provider = new ClientEditPanelProvider(){

            @Override
            public PersFizicaAddEditPanel getPfPanel() {
                return new PersFizicaAddEditPanel();
            }

            @Override
            public PersJuridicaAddEditPanel getPjPanel() {
                return new PersJuridicaAddEditPanel();
            }
        };
        client.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TouchOrder.this.createOrderIfNull();
                ClientSelectDialog dia = new ClientSelectDialog(GuiUtils.currentFrame);
                int sel = dia.getSelected();
                Client c = dia.getSelectedClient();
                if (sel != -1) {
                    if (((TouchOrder)TouchOrder.this).config.showClientEditDialogAtClientSelection) {
                        ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), c, c instanceof ClientPersJuridica, provider);
                    }
                } else if (dia.isMustAdd()) {
                    boolean pf = DialogUtils.confirmDialog(panel, LangRoAll.adaugamPersFizica, LangRoAll.persFizicaJuridica);
                    ClientEditDialog cDia = new ClientEditDialog(GuiUtils.currentFrame, ClientLogic.getInstance(), null, !pf, provider);
                    sel = cDia.getClientId();
                }
                if (sel != -1) {
                    TouchOrder.this.logic.setClientForOrder(TouchOrder.this.order, sel, dia.getSelectedAdresa());
                    TouchOrder.this.setClientText();
                }
            }
        });
        result.add((Component)client, c);
        c.gridy = 0;
        c.gridx = 6;
        c.gridheight = 1;
        this.fidelitate = new JButton(LangRoAll.fidelitate);
        this.fidelitate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                User supervizor = null;
                if (((TouchOrder)TouchOrder.this).config.passwordForFidelitate) {
                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                }
                if (supervizor != null || !((TouchOrder)TouchOrder.this).config.passwordForFidelitate) {
                    CardInputDialog dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().codFidelitateLength);
                    dialog.setVisible(true);
                    TouchOrder.this.main.requestFocus();
                    ClientPromotieView cpv = PromotionLogic.getInstance().getClientPromotieForCard(dialog.getCodAutentificare());
                    if (cpv != null) {
                        TouchOrder.this.createOrderIfNull();
                        if (!TouchOrder.this.order.isLaPlata()) {
                            TouchOrder.this.order.setIdPromotie(cpv.getIdPromotie());
                            TouchOrder.this.order.setIdClient(cpv.getIdClient());
                            TouchOrder.this.logic.setClientAndPromotionForOrder(TouchOrder.this.order, cpv.getIdClient(), cpv.getIdPromotie());
                            TouchOrder.this.setPromotionText();
                            TouchOrder.this.setClientText();
                        }
                    }
                }
            }
        });
        result.add((Component)this.fidelitate, c);
        c.gridy = 1;
        this.promotie = new JButton(LangRoAll.promotie);
        this.promotie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                User supervizor = null;
                if (((TouchOrder)TouchOrder.this).config.passwordForPromo) {
                    supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                }
                if (supervizor != null || !((TouchOrder)TouchOrder.this).config.passwordForPromo) {
                    Vector<Promotion> promotii;
                    TouchOrder.this.createOrderIfNull();
                    if (!TouchOrder.this.order.isLaPlata() && (promotii = PromotionLogic.getInstance().getFidelitatePromotions()).size() > 0) {
                        PromotiiDialog dialog = new PromotiiDialog(4, promotii);
                        int idPromotie = dialog.getSelected();
                        TouchOrder.this.logic.setPromotionForOrder(TouchOrder.this.order, idPromotie);
                        TouchOrder.this.order.setIdPromotie(idPromotie);
                        TouchOrder.this.setPromotionText();
                    }
                }
            }
        });
        result.add((Component)this.promotie, c);
        c.gridx = 7;
        c.gridy = 0;
        this.servireButton = new JButton(LangRoAll.servire);
        this.servireButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<OrdineServire> os = TouchOrder.this.logic.getOrdineServire(-1);
                if (os.size() > 0) {
                    OrdineServireDialog dia = new OrdineServireDialog(5, os);
                    TouchOrder.this.idServire = dia.getIdServire();
                    dia.dispose();
                    TouchOrder.this.setServireButtonText();
                }
            }
        });
        result.add((Component)this.servireButton, c);
        c.gridy = 1;
        this.platouButton = new JButton("<html><center>Platou start<br>&nbsp;</center></html>");
        this.platouButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TouchOrder.this.platou) {
                    TouchOrder.this.platou = false;
                } else {
                    TouchOrder.this.platou = true;
                    if (TouchOrder.this.platouId == -1) {
                        TouchOrder.this.platouId = TouchOrder.this.logic.getMaxPlatouIdForOrder(TouchOrder.this.order);
                    }
                    TouchOrder.this.platouId++;
                }
                TouchOrder.this.setPlatouButtonText();
            }
        });
        result.add((Component)this.platouButton, c);
        return result;
    }

    private void setServireButtonText() {
        if (this.idServire != -1) {
            String servire = this.logic.getOrdineServireName(this.idServire);
            this.servireButton.setText("<html>Servire <strong><font color=\"red\">" + servire + "</font></strong></html>");
        } else {
            this.servireButton.setText("<html>Servire</html>");
        }
    }

    private void setPlatouButtonText() {
        if (this.platou) {
            this.platouButton.setText("<html><strong><font color=\"red\">Platou gata</font></strong></html>");
        } else {
            this.platouButton.setText("<html>Platou start</html>");
        }
    }

    private Vector getSectiiRow() {
        if (this.sectiiNames.size() > 0) {
            return this.logic.getSectiiInSet(this.sectiiNames);
        }
        return this.logic.getSectii();
    }

    private Vector getSubcategoriesRow(Object selection) {
        Vector subcats = new Vector();
        if (selection != null) {
            if (selection instanceof Sectie) {
                Sectie c = (Sectie)selection;
                subcats = NomeclaturaLogic.getInstance().getCategoriiForcedOrder(c.getId());
                if (subcats.size() == 0) {
                    Logger.logDebug(this, "getSubcategoriesRow returned 0 for selection \"" + selection + "\"");
                }
            } else {
                Logger.logDebug(this, "getSubcategoriesRow class cast, received \"" + selection + "\"");
            }
        } else {
            Logger.logDebug(this, "getSubcategoriesRow selection is null");
        }
        return subcats;
    }

    private Vector getProductsRow(Object selection) {
        Vector products = new Vector();
        if (selection != null) {
            if (selection instanceof Categorie) {
                Categorie sc = (Categorie)selection;
                products = NomeclaturaLogic.getInstance().getProductsForCategorie(sc);
                if (products.size() == 0) {
                    Logger.logDebug(this, "getProductsRow returned 0 for selection \"" + selection + "\"");
                }
            } else {
                Logger.logDebug(this, "getProductsRow class cast, received \"" + selection + "\"");
            }
        } else {
            Logger.logDebug(this, "getProductsRow selection is null");
        }
        return products;
    }

    private void productChosen(Object selection) {
        Product p;
        if (this.kb_mode == 2) {
            if (this.order != null) {
                DialogUtils.errorDialog(this, "Finalizati modul de plata, apasand pe OK", LangRoAll.nuPotContinua);
                return;
            }
            this.kb_mode = 1;
            this.setSelectie(this.selectie, "");
        }
        if (!(p = (Product)selection).equals(this.produsCurent)) {
            this.cantitateCurenta = 0.0;
        }
        this.produsCurent = p;
        this.entry = null;
        this.cantitateCurenta += 1.0;
        String string = this.truncFormat.format(this.cantitateCurenta);
        this.setSelectie(this.selectie, string);
    }

    private Selector getBottomPanel() {
        DataProvider fullDataProvider = new DataProvider(){

            @Override
            public Vector getData(int level, Object selection) {
                TouchOrder.this.disableCorrectionButtons();
                switch (level) {
                    case 0: {
                        return TouchOrder.this.getSectiiRow();
                    }
                    case 1: {
                        return TouchOrder.this.getSubcategoriesRow(selection);
                    }
                    case 2: {
                        return TouchOrder.this.getProductsRow(selection);
                    }
                    case 3: {
                        TouchOrder.this.productChosen(selection);
                        return null;
                    }
                }
                return new Vector();
            }
        };
        DataProvider simpleDataProvider = new DataProvider(){

            @Override
            public Vector getData(int level, Object selection) {
                TouchOrder.this.disableCorrectionButtons();
                switch (level) {
                    case 0: {
                        return NomeclaturaLogic.getInstance().getCategoriiForcedOrder(-1);
                    }
                    case 1: {
                        return TouchOrder.this.getProductsRow(selection);
                    }
                    case 2: {
                        TouchOrder.this.productChosen(selection);
                        return null;
                    }
                }
                return new Vector();
            }
        };
        Selector sel = null;
        sel = this.config.touchShowCategoriesInSelector ? new Selector(fullDataProvider, this.config.touchSelectorFontSize, this.config.selectorShowStartButton, this.config.touchSelectorItemsPerLine, this.config.touchSelectorLinesPerPage, this.config.selectorHtmlButtons) : new Selector(simpleDataProvider, this.config.touchSelectorFontSize, this.config.selectorShowStartButton, this.config.touchSelectorItemsPerLine, this.config.touchSelectorLinesPerPage, this.config.selectorHtmlButtons);
        return sel;
    }

    private JPanel getRightPanel() {
        final JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.selectie = new JLabel();
        this.selectie.setFont(new Font(null, 1, this.config.touchKeypadFontSize));
        this.selectie.setForeground(Color.RED);
        result.add((Component)this.selectie, c);
        ++c.gridy;
        result.add((Component)new JLabel(""), c);
        final TouchOrder panel = this;
        ++c.gridy;
        VirtualKeypad kp = new VirtualKeypad(VpConfig.getInstance().touchSelectorFontSize);
        kp.addKeypadListener(new KeypadListener(){

            @Override
            public void keypadPressed(int digit) {
                switch (TouchOrder.this.kb_mode) {
                    case 1: {
                        double n = (double)digit * Math.pow(10.0, -TouchOrder.this.decimals);
                        TouchOrder.this.cantitateCurenta = TouchOrder.this.cantitateCurenta * 10.0 + n;
                        String temp = TouchOrder.this.notruncFormat.format(TouchOrder.this.cantitateCurenta);
                        TouchOrder.this.setSelectie(TouchOrder.this.selectie, temp);
                        break;
                    }
                    case 2: {
                        int deci = 2;
                        double n = (double)digit * Math.pow(10.0, -deci);
                        TouchOrder.this.cantitateCurenta = TouchOrder.this.cantitateCurenta * 10.0 + n;
                        TouchOrder.this.cantitateCurenta = FloatUtils.roundFloat(TouchOrder.this.cantitateCurenta, deci);
                        String temp = Formatters.NUMBER_2DECIMALS_NO_TRUNC.format(TouchOrder.this.cantitateCurenta);
                        TouchOrder.this.setSelectie(TouchOrder.this.selectie, temp, TouchOrder.this.tipPlata.getLabel());
                        break;
                    }
                }
            }

            @Override
            public void enterPressed() {
            }

            @Override
            public void okPressed() {
                switch (TouchOrder.this.kb_mode) {
                    case 1: {
                        if (TouchOrder.this.entry == null) {
                            if (TouchOrder.this.cantitateCurenta == 0.0) {
                                return;
                            }
                            if (TouchOrder.this.produsCurent != null) {
                                boolean ignoreStockWarning;
                                boolean enoughStock;
                                int idPlatou = -1;
                                if (TouchOrder.this.platou) {
                                    idPlatou = TouchOrder.this.platouId;
                                }
                                int idPromotie = -1;
                                long now = System.currentTimeMillis();
                                Sale newSale = null;
                                newSale = TouchOrder.this.pretCurent != -1.0 ? TouchOrder.this.logic.buildSale(TouchOrder.this.produsCurent, 0.0, TouchOrder.this.cantitateCurenta, TouchOrder.this.preparareString, -1, idPlatou, idPromotie, -1, TouchOrder.this.idServire, now, TouchOrder.this.pretCurent, "", 0) : TouchOrder.this.logic.buildSale(TouchOrder.this.produsCurent, 0.0, TouchOrder.this.cantitateCurenta, TouchOrder.this.preparareString, -1, idPlatou, idPromotie, -1, TouchOrder.this.idServire, now, 0);
                                if (VpConfig.getInstance().checkEnoughStock && !(enoughStock = TouchOrder.this.logic.enoughStockForSale(newSale, new Timestamp(now), TouchOrder.this.table.getIdLocatie(), StockLogic.COMANDA_TYPE.EFECTUAT)) && !(ignoreStockWarning = DialogUtils.confirmDialog(panel, "Cantitate insuficienta pentru produsul " + TouchOrder.this.produsCurent.getName() + ". Continuam", LangRoAll.confirmare))) {
                                    return;
                                }
                                TouchOrder.this.tm.addSale(newSale);
                                TouchOrder.this.alterPrice = false;
                                TouchOrder.this.pretCurent = -1.0;
                            }
                        } else {
                            TouchOrder.this.entry.setCantitateNoua(TouchOrder.this.cantitateCurenta);
                            TouchOrder.this.tm.removeTempSale(TouchOrder.this.entry);
                            TouchOrder.this.tm.fireTableDataChanged();
                        }
                        TouchOrder.this.produsCurent = null;
                        TouchOrder.this.entry = null;
                        TouchOrder.this.cantitateCurenta = 0.0;
                        TouchOrder.this.setSelectie(TouchOrder.this.selectie, "");
                        TouchOrder.this.disableCorrectionButtons();
                        TouchOrder.this.resetPreparare();
                        TouchOrder.this.updateTotal();
                        break;
                    }
                    case 2: {
                        if (TouchOrder.this.tipPlata != null) {
                            if (VpConfig.getInstance().verificaPlati) {
                                double totalNow = TouchOrder.this.logic.getTotalPlati(TouchOrder.this.order.getId());
                                if (TouchOrder.this.cantitateCurenta + totalNow > TouchOrder.this.tm.getTotal() && !DialogUtils.confirmDialog(panel, "Platile depasesc totalul notei. Continuam", LangRoAll.confirmare)) {
                                    TouchOrder.this.kb_mode = 1;
                                    TouchOrder.this.setSelectie(TouchOrder.this.selectie, "");
                                    return;
                                }
                            }
                            String comment = "";
                            boolean commentSet = false;
                            while (TouchOrder.this.tipPlata.isRequestComment() && !commentSet) {
                                String s = DialogUtils.inputDialog(panel, "", LangRoAll.detalii);
                                if (!Validators.correctString(s)) continue;
                                commentSet = true;
                                comment = s;
                            }
                            Plata plata = new Plata(TouchOrder.this.tipPlata.getId(), TouchOrder.this.cantitateCurenta, TouchOrder.this.tipPlata.getEcrMapping(), TouchOrder.this.tipPlata.getLabel(), comment, 0);
                            TouchOrder.this.logic.addPlataToOrder(TouchOrder.this.order, plata);
                            Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(TouchOrder.this.order.getId());
                            TipPlataProvider.getInstance().updatePlatiLabels(plati, TouchOrder.this.op);
                        }
                        TouchOrder.this.kb_mode = 1;
                        TouchOrder.this.setSelectie(TouchOrder.this.selectie, "");
                        break;
                    }
                    default: {
                        TouchOrder.this.kb_mode = 1;
                    }
                }
            }

            @Override
            public void backspace() {
                TouchOrder.this.eraseQuantity();
            }

            @Override
            public void decimalPressed() {
            }
        });
        result.add((Component)kp, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.marcaj = new JButton("<html><center>Marcaj<br>&nbsp;</center></html>");
        this.marcaj.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EventsLogic.getInstance().isDayOpen(1)) {
                    DialogUtils.errorDialog(result, "Va rog deschideti ziua", LangRoAll.nuPotContinua);
                    return;
                }
                if (TouchOrder.this.platou) {
                    TouchOrder.this.platouButton.doClick();
                }
                boolean proto = TouchOrder.this.protocol.isSelected();
                Vector categories = TouchOrder.this.logic.getSectii();
                for (Sectie element : categories) {
                    Vector<Sale> toAdd = TouchOrder.this.logic.getTemporarySalesForCategory(element, TouchOrder.this.tm.getAllSales());
                    if (toAdd.size() == 0) continue;
                    TouchOrder.this.createOrderIfNull();
                    TouchOrder.this.logic.productsSold(toAdd, TouchOrder.this.order, TouchOrder.this.table, element, proto, null);
                }
                Vector<Sale> s = TouchOrder.this.logic.getSales(TouchOrder.this.order.getId(), true, -1, new ScreenSaleInterface());
                TouchOrder.this.tm.updateTable(s);
                TouchOrder.this.disableCorrectionButtons();
                TouchOrder.this.updateTotal();
                TouchOrder.this.idServire = -1;
                if (VpConfig.getInstance().logoutAtMarcaj) {
                    TouchOrder.this.logout();
                }
            }
        });
        result.add((Component)this.marcaj, c);
        ++c.gridx;
        this.preparare = new JButton("<html><center>Preparare<br>&nbsp;</center></html>");
        this.preparare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TouchOrder.this.produsCurent == null) {
                    DialogUtils.errorDialog(result, "Selectati intai un produs nemarcat", LangRoAll.nuPotContinua);
                    return;
                }
                Vector moduriPreparare = TouchOrder.this.logic.getModuriPreparare();
                if (moduriPreparare.size() > 0) {
                    ModPreparareDialog mpd = new ModPreparareDialog(4, moduriPreparare, TouchOrder.this.produsCurent.getName());
                    String newMpd = mpd.getModPreparare();
                    if (!Validators.correctString(newMpd)) {
                        TouchOrder.this.preparareString = "";
                    } else if (TouchOrder.this.preparareString == null) {
                        TouchOrder.this.preparareString = newMpd;
                    } else {
                        TouchOrder.this.preparareString = TouchOrder.this.preparareString + ("," + newMpd);
                    }
                }
            }
        });
        result.add((Component)this.preparare, c);
        ++c.gridy;
        c.gridx = 0;
        this.retur = new JButton("<html><center>Retur<br>&nbsp;</center></html>");
        this.retur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TouchOrder.this.retur();
            }
        });
        result.add((Component)this.retur, c);
        ++c.gridx;
        String transferString = "<html><center>Transfera<br>&nbsp;</center></html>";
        String transferStringStop = "<html><center>Aici<br>&nbsp;</center></html>";
        this.transfer = new JButton("<html><center>Transfera<br>&nbsp;</center></html>");
        this.transfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TouchOrder.this.transfer.getText().equalsIgnoreCase("<html><center>Transfera<br>&nbsp;</center></html>")) {
                    User supervizor = null;
                    if (((TouchOrder)TouchOrder.this).config.passwordForTransfer) {
                        supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                    }
                    if (TouchOrder.this.order != null && TouchOrder.this.order.isLaPlata() && !((TouchOrder)TouchOrder.this).config.allowTransferAfterNota) {
                        DialogUtils.errorDialog(panel, "Nu putem efectua transferuri dupa tiparirea notei.", "Nu pot continua.");
                        return;
                    }
                    if (!(supervizor == null && ((TouchOrder)TouchOrder.this).config.passwordForTransfer || TouchOrder.this.order == null)) {
                        TouchOrder.this.transferSource = TouchOrder.this.table;
                        TouchOrder.this.transfer.setText("<html><center>Aici<br>&nbsp;</center></html>");
                        TouchOrder.this.goToMese();
                    }
                } else {
                    TouchOrder.this.createOrderIfNull();
                    new TransferDialog(TouchOrder.this.logic, TouchOrder.this.transferSource, TouchOrder.this.table);
                    TouchOrder.this.transferSource = null;
                    TouchOrder.this.transfer.setText("<html><center>Transfera<br>&nbsp;</center></html>");
                    TouchOrder.this.disableCorrectionButtons();
                    TouchOrder.this.tm.updateTable(TouchOrder.this.logic.getSales(TouchOrder.this.order.getId(), true, -1, new ScreenSaleInterface()));
                    TouchOrder.this.updateTotal();
                }
            }
        });
        result.add((Component)this.transfer, c);
        this.disableCorrectionButtons();
        return result;
    }

    private void resetPreparare() {
        this.preparareString = "";
    }

    private void goToMese() {
        this.idServire = -1;
        this.main.plan(this.order);
        this.disableCorrectionButtons();
    }

    private Order createOrderIfNull() {
        if (this.order == null) {
            this.order = this.logic.newOrder(this.table.getId(), this.waiter.getId());
        }
        return this.order;
    }

    private void eraseQuantity() {
        this.cantitateCurenta = 0.0;
        String t = this.truncFormat.format(this.cantitateCurenta);
        switch (this.kb_mode) {
            case 1: {
                this.setSelectie(this.selectie, t);
                break;
            }
            case 2: {
                this.setSelectie(this.selectie, t, this.tipPlata.getLabel());
                break;
            }
        }
    }

    private void logout() {
        this.idServire = -1;
        this.main.logout(this.order);
        this.disableCorrectionButtons();
    }

    private void retur() {
        if (this.config.allowRetur && this.cantitateCurenta > 0.0) {
            User supervizor = null;
            if (this.config.passwordForStergereRetur) {
                supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
            }
            if (supervizor != null || !this.config.passwordForStergereRetur) {
                if (this.cantitateCurenta > this.entry.getCantitateMarcata()) {
                    this.cantitateCurenta = this.entry.getCantitateMarcata();
                }
                User u = supervizor != null ? supervizor : this.waiter;
                this.logic.decrementSale(this.order, this.entry, u, "", this.cantitateCurenta, this.table, null);
                if (this.entry.getCantitateMarcata() == 0.0) {
                    this.tm.removeTempSale(this.entry);
                }
                this.tm.fireTableDataChanged();
                this.disableCorrectionButtons();
                this.updateTotal();
                this.produsCurent = null;
                this.eraseQuantity();
            } else {
                DialogUtils.errorDialog(this, "Utilizator sau parola incorecte", LangRoAll.nuPotContinua);
            }
        }
    }

    private void disableCorrectionButtons() {
        this.retur.setEnabled(false);
    }

    private void enableCorrectionButtons() {
        this.retur.setEnabled(true);
    }

    private void setSelectie(JLabel selectie, String temp) {
        String prodString = "";
        if (this.produsCurent != null) {
            prodString = this.produsCurent.getName();
        }
        this.setSelectie(selectie, temp, prodString);
    }

    private void setSelectie(JLabel selectie, String temp, String prodString) {
        String selText = temp + " * " + prodString;
        selectie.setText(selText);
    }

    private JPanel getMiddlePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.tm = new TouchOrderTableModel();
        JTable table = new JTable(this.tm);
        table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                int selRow = source.rowAtPoint(e.getPoint());
                if (selRow != -1) {
                    TouchOrder.this.entry = TouchOrder.this.tm.getEntryAtRow(selRow);
                    TouchOrder.this.produsCurent = NomeclaturaLogic.getInstance().getProductById(TouchOrder.this.entry.getIdProduct());
                    TouchOrder.this.cantitateCurenta = 0.0;
                    TouchOrder.this.selector.reset();
                    if (TouchOrder.this.entry.hasCantitateNoua()) {
                        TouchOrder.this.cantitateCurenta = TouchOrder.this.entry.getCantitateNoua();
                    } else if (!TouchOrder.this.order.isLaPlata() || ((TouchOrder)TouchOrder.this).config.allowStergereAfterNota) {
                        TouchOrder.this.cantitateCurenta = 0.0;
                        TouchOrder.this.enableCorrectionButtons();
                    }
                    String t = TouchOrder.this.truncFormat.format(TouchOrder.this.cantitateCurenta);
                    TouchOrder.this.setSelectie(TouchOrder.this.selectie, t);
                }
            }
        });
        TouchOrderColorProvider touchColor = new TouchOrderColorProvider(this.tm);
        CustomCellRenderer cellRender = new CustomCellRenderer(touchColor, this.tm);
        GuiUtils.updateJTableColumnSize(table, this.tm);
        GuiUtils.updateJTableRowSize(table, this.config.touchTableFontSize);
        TableColumnModel colModel = table.getColumnModel();
        Enumeration<TableColumn> enum1 = colModel.getColumns();
        while (enum1.hasMoreElements()) {
            TableColumn column = enum1.nextElement();
            column.setCellRenderer(cellRender);
        }
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        JScrollPane scroll = new JScrollPane(table);
        result.add((Component)scroll, c);
        c.gridy = 1;
        c.gridwidth = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.anchor = 13;
        result.add((Component)this.buildTotalPanel(), c);
        return result;
    }

    private JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.total), c);
        ++c.gridx;
        this.total = new JLabel("");
        result.add((Component)this.total, c);
        this.op = new PlatiOperationsInterface(){

            @Override
            public boolean canRunOperations() {
                return TouchOrder.this.order != null;
            }

            @Override
            public double getSumaForPlata(int elemId, int clientIndex) {
                return TouchOrder.this.logic.getSumaForPlataNoPlataSkip(TouchOrder.this.order, elemId, TouchOrder.this.tm.getTotal(), clientIndex);
            }

            @Override
            public void addPlata(Plata p) {
                TouchOrder.this.logic.addPlataToOrder(TouchOrder.this.order, p);
                Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(TouchOrder.this.order.getId());
                TipPlataProvider.getInstance().updatePlatiLabels(plati, TouchOrder.this.op);
            }

            @Override
            public double getTotal() {
                return TouchOrder.this.tm.getTotal();
            }

            @Override
            public int getClientIndex() {
                return -1;
            }

            @Override
            public boolean filterTipPlata(TipPlata toFilter) {
                return true;
            }
        };
        final TouchOrder panel = this;
        ++c.gridx;
        JPanel platiPanel = TipPlataProvider.getInstance().buildPlatiPanel(this, this.op, new TipPlataButtonPushed(){

            @Override
            public void startEditSuma(TipPlata plata) {
                if (TouchOrder.this.op.canRunOperations()) {
                    TouchOrder.this.kb_mode = 2;
                    TouchOrder.this.cantitateCurenta = TouchOrder.this.logic.getSumaForPlataNoPlataSkip(TouchOrder.this.order, plata.getId(), TouchOrder.this.tm.getTotal(), 0);
                    TouchOrder.this.tipPlata = plata;
                    String t = Utils.getString2Decimals(TouchOrder.this.cantitateCurenta);
                    TouchOrder.this.setSelectie(TouchOrder.this.selectie, t, TouchOrder.this.tipPlata.getLabel());
                } else {
                    DialogUtils.errorDialog(panel, LangRoAll.comandaGoala, LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)platiPanel, c);
        c.weightx = 1.0;
        ++c.gridx;
        result.add((Component)new JLabel(""), c);
        result.setBorder(new TitledBorder("-"));
        return result;
    }

    public void setTable(Table t, User w, Order o) {
        this.order = o;
        this.waiter = w;
        this.table = t;
        this.platou = false;
        this.platouId = -1;
        if (o != null) {
            this.platouId = this.logic.getMaxPlatouIdForOrder(o);
        }
        this.platouButton.setText(LangRoAll.platouStart);
        this.setFields(t, w);
    }

    private void setFields(Table t, User w) {
        TipPlataProvider.getInstance().cleanPlatiLabel1();
        Date d = new Date();
        if (this.order != null) {
            d = new Date(this.order.getStartTime());
        }
        String dateS = Formatters.TIME_FORMAT.format(d);
        this.tableNo.setText(this.logic.getFullNameForTable(t.getLabel(), t.getIdLocatie()) + " (" + dateS + ")");
        this.ospatar.setText(w.getLogin());
        if (this.order != null) {
            if (this.order.isLaPlata()) {
                this.incasat.setEnabled(true);
                if (!this.config.allowMarcajAfterNota) {
                    this.marcaj.setEnabled(false);
                }
            } else {
                this.incasat.setEnabled(false);
                this.marcaj.setEnabled(true);
            }
            this.protocol.setSelected(this.order.isProtocol());
            this.setProtocolColor();
            this.tm.updateTable(this.logic.getSales(this.order.getId(), true, -1, new ScreenSaleInterface()));
            Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(this.order.getId());
            TipPlataProvider.getInstance().updatePlatiLabels(plati, this.op);
        } else {
            this.incasat.setEnabled(false);
            this.marcaj.setEnabled(true);
            this.protocol.setEnabled(true);
            this.fidelitate.setEnabled(true);
            this.protocol.setSelected(false);
            this.fidelitate.setSelected(false);
            this.protocol.setForeground(Color.BLACK);
            this.tm.clear();
        }
        this.updateTotal();
        this.setPromotionText();
        this.setClientText();
    }

    private void setPromotionText() {
        if (this.order != null) {
            Promotion promo = PromotionLogic.getInstance().getPromotionById(this.order.getIdPromotie());
            if (promo != null) {
                String promoName = promo.getLabel();
                this.promoText.setText(promoName);
            } else {
                this.promoText.setText("");
            }
        } else {
            this.promoText.setText("");
        }
    }

    private void setClientText() {
        if (this.order != null) {
            Client c = ClientLogic.getInstance().getClientById(this.order.getIdClient());
            if (c != null) {
                this.clientText.setText(c.toString());
            } else {
                this.clientText.setText("");
            }
        } else {
            this.clientText.setText("");
        }
    }

    private void setProtocolColor() {
        if (this.order.isProtocol()) {
            this.protocol.setForeground(LocationPanel.PROTOCOL_COLOR);
        } else {
            this.protocol.setForeground(Color.BLACK);
        }
    }
}

