/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.touch2;

import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.multilang.LangRoAll;

public abstract class ComandaTableModel
extends AbstractTableModel {
    protected String[] _columnNames = new String[]{LangRoAll.servire, LangRoAll.produs, LangRoAll.cantitate, LangRoAll.valoare};
    protected Class[] _columnTypes = new Class[]{String.class, String.class, String.class, String.class};
    protected Vector _sales = new Vector();

    public abstract MessageFormat getProductLineHtml();

    public abstract MessageFormat getQtyHtml();

    public abstract MessageFormat getValueHtml();

    public void updateTable(Vector data) {
        if (data == null) {
            throw new NullPointerException("data might not be null");
        }
        this._sales = data;
        this.fireTableDataChanged();
    }

    public void clear() {
        this.updateTable(new Vector());
    }

    @Override
    public int getColumnCount() {
        return this._columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this._sales == null) {
            return 0;
        }
        return this._sales.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this._sales == null) {
            return null;
        }
        if (rowIndex > this._sales.size() || rowIndex < 0 || columnIndex < 0 || columnIndex >= this._columnNames.length) {
            return null;
        }
        String s = "";
        Sale o = (Sale)this._sales.elementAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                int id = o.getIdServire();
                String s1 = "";
                if (id != -1) {
                    s1 = RestLogic.getInstance().getOrdineServireName(id);
                }
                s = s + s1;
                break;
            }
            case 1: {
                String s2 = o.getProductName();
                String mp = o.getModPreparare();
                MessageFormat msgF = this.getProductLineHtml();
                if (msgF != null) {
                    String mpS = mp;
                    if (Validators.correctString(mp)) {
                        mpS = " (" + mp + ")";
                    }
                    String priceS = " (" + Utils.getString2Decimals(o.getPrice()) + ")";
                    s = Utils.getTranslation(msgF, s2, mpS, priceS);
                    break;
                }
                if (Validators.correctString(mp)) {
                    s2 = s2 + " (" + mp + ")";
                }
                s = s + s2;
                break;
            }
            case 2: {
                MessageFormat msgQty = this.getQtyHtml();
                if (msgQty != null) {
                    s = Utils.getTranslation(msgQty, Utils.getString3Decimals(o.getCantitateNoua()), Utils.getString3Decimals(o.getCantitateMarcata()));
                    break;
                }
                s = s + o.getQuantity();
                break;
            }
            case 3: {
                MessageFormat msgValue = this.getValueHtml();
                if (msgValue != null) {
                    s = Utils.getTranslation(msgValue, Utils.getString2Decimals(o.getTotal()));
                    break;
                }
                s = s + Utils.getString2Decimals(o.getTotal());
                break;
            }
        }
        return s;
    }

    public Sale getEntryAtRow(int row) {
        return (Sale)this._sales.elementAt(row);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex >= this._columnTypes.length) {
            return String.class;
        }
        return this._columnTypes[columnIndex];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= this._columnNames.length) {
            return "";
        }
        return this._columnNames[columnIndex];
    }

    public double getTotal() {
        return RestLogic.computeTotalForSales(this._sales);
    }

    public void addSale(Sale s) {
        this._sales.add(s);
        int lastRow = this.getRowCount() - 1;
        this.fireTableRowsInserted(lastRow, lastRow + 1);
    }

    public Vector getAllSales() {
        return this._sales;
    }

    public void removeTempSale(Sale entry, int index) {
        if (entry.isEmpty()) {
            this._sales.remove(index);
        }
    }

    public double getDiscount() {
        double result = 0.0;
        for (Sale element : this._sales) {
            result += element.getDiscount() * element.getCantitateMarcata();
        }
        return result;
    }
}

