/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.gui.touch7;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.gui.ProductPicturePanel;
import ro.atreides.productie.ProductieLogic;
import ro.atreides.productie.gui.QuickSmallProductiePanel;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.NewRecipeEntry;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.touch2.TouchOrder2;
import ro.atreides.restaurant.gui.touch7.TouchMain7;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.gui.QuickSmallStocksInMagaziePanel;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NotEnoughIngredientsException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.keypad.VirtualKeypad3;
import ro.atreides.utils.gui.selector.DataProvider2;
import ro.atreides.utils.gui.selector.Selector2;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.licensing.LicenseManager;
import ro.atreides.utils.multilang.LangRoAll;

public class TouchOrder7
extends TouchOrder2 {
    private QuickSmallProductiePanel qspp;
    private ProductPicturePanel ppp;
    private DetaliiProdusPanel detaliiProdus;
    private DetaliiProdusPanel detaliiComanda;
    private JTextArea modPreparare;
    private AbstractListPanel stockInMagazie;

    public TouchOrder7(RestLogic logic, TouchMain7 main, VpConfig config, Vector sectii, boolean autoMarcaj, boolean deleteAllPlateau) {
        super(logic, main, config, sectii, autoMarcaj, deleteAllPlateau);
        this.logic = logic;
        this.main = main;
        this.config = config;
        this.sectii = sectii;
        this.marcajAtPrecomandaAdd = autoMarcaj;
        this.deleteAllPlateau = deleteAllPlateau;
    }

    private JPanel getRightPanel() {
        Magazie m1;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 18;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JPanel result = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        result.add((Component)this.getButtonsPanel(), c);
        Insets buttonMargins = new Insets(5, 5, 5, 5);
        Insets buttonInsets = new Insets(5, 5, 5, 5);
        this.kp = new VirtualKeypad3(VpConfig.getInstance().touchSelectorFontSize, true, buttonMargins, buttonInsets, 1);
        Dimension d = new Dimension(150, 375);
        this.kp.setMinimumSize(d);
        this.kp.setMaximumSize(d);
        this.kp.setPreferredSize(d);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        JPanel selector = this.getSelectorPanel();
        result.add((Component)selector, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 4;
        result.add((Component)this.kp, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 14;
        if (VpConfig.getInstance().touch6ShowProductiePanel && LicenseManager.getInstance().isGuiPanelLicenced(QuickSmallProductiePanel.class.getName())) {
            int fontSize = Config.getInstance().getInt("productieFontSize", 20);
            ProductieLogic pl = ProductieLogic.getInstance();
            Vector readIds = pl.getReadIds();
            if (readIds.size() > 1) {
                this.qspp = new QuickSmallProductiePanel(fontSize, ProductieLogic.getInstance(), pl.getReadIds(), pl.getWriteIds(), ProductieLogic.waiterInterface);
                this.qspp.setBorder(new TitledBorder("In lucru"));
                d = new Dimension(600, 200);
                this.qspp.setMinimumSize(d);
                this.qspp.setPreferredSize(d);
                this.qspp.setMaximumSize(d);
                result.add((Component)this.qspp, c);
            } else {
                result.add((Component)new JLabel(), c);
            }
        } else {
            result.add((Component)new JLabel(), c);
        }
        c.gridx = 0;
        c.anchor = 18;
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 2;
        result.add((Component)this.getQuickTablePanel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        c.fill = 1;
        JTabbedPane _tabbedPane = new JTabbedPane();
        String magazieProductieS = VpConfig.getInstance().productieSemifabricateMagazieProductie;
        if (Validators.correctString(magazieProductieS) && (m1 = StockLogic.getInstance().getMagazieByLabel(magazieProductieS)) != null) {
            this.stockInMagazie = new QuickSmallStocksInMagaziePanel(m1.getId());
            _tabbedPane.addTab("Stoc in \"" + magazieProductieS + "\"", this.stockInMagazie);
            this.stockInMagazie.doStuff();
        }
        this.ppp = new ProductPicturePanel(false, VpConfig.getInstance().productPictureDx);
        _tabbedPane.addTab("Imagine", this.ppp);
        JPanel instructiuniPanel = this.getInstructiuniPanel();
        _tabbedPane.add((Component)instructiuniPanel, LangRoAll.instructiuni);
        result.add((Component)_tabbedPane, c);
        return result;
    }

    @Override
    protected void addLaPrecomanda(Product p, double quantity, Component panel) {
        super.addLaPrecomanda(p, this.getQuantityMultiplier(quantity, p), panel);
        this.refreshProduct(p.getId());
    }

    private double getQuantityMultiplier(double originalQuantity, Product p) {
        String multiplierString = VpConfig.getInstance().productieSemifabricateQuantityMultiplier;
        if (Validators.correctString(multiplierString)) {
            Vector tokens = Utils.splitString(multiplierString, ',');
            double multiply = 1.0;
            for (String token : tokens) {
                Vector pair = Utils.splitString(token, '=');
                if (pair.size() < 2) continue;
                String codS = (String)pair.get(0);
                String multiplyS = (String)pair.get(1);
                if (Validators.correctInteger(codS)) {
                    Integer codI = Integer.parseInt(codS);
                    if (Validators.correctDouble(multiplyS)) {
                        if (codI.intValue() != p.getCod()) continue;
                        multiply = Double.parseDouble(multiplyS);
                        return multiply * originalQuantity;
                    }
                    DialogUtils.errorDialog(this, "Configurare incorecta productieSemifabricateQuantityMultiplier", LangRoAll.nuPotContinua);
                    return originalQuantity;
                }
                DialogUtils.errorDialog(this, "Configurare incorecta productieSemifabricateQuantityMultiplier", LangRoAll.nuPotContinua);
                return originalQuantity;
            }
        }
        return originalQuantity;
    }

    @Override
    protected MouseAdapter getPreorderMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Sale s = TouchOrder7.this.preorderTm.getEntryAtRow(selRow);
                int selCol = t.columnAtPoint(p);
                switch (selCol) {
                    case 1: {
                        TouchOrder7.this.refreshProduct(s.getIdProduct());
                        break;
                    }
                    case 2: {
                        double toRemain;
                        double toDelete = s.getCantitateNoua();
                        if (TouchOrder7.this.kp.getValue() > 0.0) {
                            toDelete = TouchOrder7.this.kp.getValue();
                            TouchOrder7.this.kp.reset();
                        }
                        if ((toRemain = s.getCantitateNoua() - toDelete) < 0.0) {
                            toRemain = 0.0;
                        }
                        s.setCantitateNoua(toRemain);
                        if (toRemain == 0.0) {
                            TouchOrder7.this.preorderTm.removeTempSale(s, selRow);
                        }
                        TouchOrder7.this.preorderTm.fireTableDataChanged();
                        TouchOrder7.this.updateTotalPreorder();
                        TouchOrder7.this.detaliiComanda.refresh(-1, TouchOrder7.this.orderTm.getAllSales());
                        break;
                    }
                    case 3: {
                        User supervizor = null;
                        if (((TouchOrder7)TouchOrder7.this).config.passwordForPret) {
                            supervizor = UsersLogic.getInstance().requestAdminLogin(GuiUtils.currentFrame, VpConfig.getInstance().allowPasswords, true);
                        }
                        if (supervizor == null && ((TouchOrder7)TouchOrder7.this).config.passwordForPret) break;
                        String newPrice = TouchOrder7.this.kp.getValueS();
                        if (Validators.correctDouble(newPrice)) {
                            double price = TouchOrder7.this.kp.getValue();
                            s.setPrice(price);
                            s.setPpuOriginal(price);
                            TouchOrder7.this.updateTotalPreorder();
                        } else {
                            double originalPrice = TouchOrder7.this.logic.getPriceForProductCommit(s.getIdProduct());
                            s.setPrice(originalPrice);
                            s.setPpuOriginal(originalPrice);
                            TouchOrder7.this.updateTotalPreorder();
                        }
                        TouchOrder7.this.kp.reset();
                        break;
                    }
                }
            }
        };
    }

    @Override
    protected MouseAdapter getOrderMouseListener(final Component panel) {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                Sale s = TouchOrder7.this.orderTm.getEntryAtRow(selRow);
                int selCol = t.columnAtPoint(p);
                switch (selCol) {
                    case 1: {
                        TouchOrder7.this.refreshProduct(s.getIdProduct());
                        break;
                    }
                    case 2: {
                        if (TouchOrder7.this.order != null && TouchOrder7.this.order.isLaPlata() && !((TouchOrder7)TouchOrder7.this).config.allowStergereAfterNota) {
                            DialogUtils.errorDialog(panel, LangRoAll.nuPutetiEfectuaReturDupaNota, LangRoAll.nuPotContinua);
                            return;
                        }
                        if (!((TouchOrder7)TouchOrder7.this).config.allowRetur) break;
                        double toDelete = s.getCantitateMarcata();
                        if (TouchOrder7.this.kp.getValue() > 0.0) {
                            toDelete = TouchOrder7.this.kp.getValue();
                            TouchOrder7.this.kp.reset();
                        }
                        if (toDelete > s.getCantitateMarcata()) {
                            toDelete = s.getCantitateMarcata();
                        }
                        if (s.getIdPlatou() > 0 && TouchOrder7.this.deleteAllPlateau) {
                            TouchOrder7.this.deleteAllPlateau(toDelete, panel, s);
                            break;
                        }
                        TouchOrder7.this.deleteSingleProduct(toDelete, panel, s, selRow);
                    }
                }
            }
        };
    }

    private void refreshProduct(int idProduct) {
        this.ppp.reload(idProduct);
        this.detaliiProdus.refresh(idProduct, null);
        int idReteta = this.logic.getIdReteta(idProduct);
        String mp = this.logic.getModPreparareForReteta(idReteta);
        this.modPreparare.setText(mp);
    }

    @Override
    protected void marcaj(boolean triggeredByNota, Component panel, boolean stayput) {
        super.marcaj(triggeredByNota, panel, true);
        this.modPreparare.setText("");
        this.setFields(this.table, this.waiter);
    }

    @Override
    protected void notaClicked(Component parent, ActionEvent ev) {
        String magazieProductieS = VpConfig.getInstance().productieSemifabricateMagazieProductie;
        String magazieBcS = VpConfig.getInstance().productieSemifabricateMagazieBonConsum;
        Magazie magBc = null;
        Magazie magProd = null;
        if (!Validators.correctString(magazieProductieS)) {
            DialogUtils.errorDialog(this, "productieSemifabricateMagazieProductie neconfigurat", LangRoAll.nuPotContinua);
            return;
        }
        magProd = StockLogic.getInstance().getMagazieByLabel(magazieProductieS);
        if (magProd == null) {
            DialogUtils.errorDialog(this, "magazie inexistenta : " + magazieProductieS, LangRoAll.nuPotContinua);
        }
        if (!Validators.correctString(magazieBcS)) {
            DialogUtils.errorDialog(this, "productieSemifabricateMagazieBonConsum neconfigurat", LangRoAll.nuPotContinua);
            return;
        }
        magBc = StockLogic.getInstance().getMagazieByLabel(magazieBcS);
        if (magBc == null) {
            DialogUtils.errorDialog(this, "magazie inexistenta : " + magazieBcS, LangRoAll.nuPotContinua);
        }
        if (RestLogic.getInstance().productie(this.orderTm.getAllSales(), this.order, magProd.getId(), magBc.getId())) {
            this.detaliiComanda.refresh(-1, new Vector<Sale>());
            this.detaliiProdus.refresh(-1, new Vector<Sale>());
            this.order = null;
            this.setFields(this.table, this.waiter);
            this.refreshQuickTable();
        }
    }

    @Override
    protected void setFields(Table t, User w) {
        super.setFields(t, w);
        if (this.qspp != null) {
            this.qspp.setUser(w.getId(), w.getLogin());
            this.qspp.refreshData();
        }
        this.detaliiComanda.refresh(-1, this.orderTm.getAllSales());
    }

    @Override
    protected JPanel getSelectorPanel() {
        DataProvider2 fullDataProvider = new DataProvider2(){

            @Override
            public int getLinesPerPage(int level) {
                switch (level) {
                    case 0: {
                        return ((TouchOrder7)TouchOrder7.this).config.selector2Level2LinesPerPage;
                    }
                    case 1: {
                        return ((TouchOrder7)TouchOrder7.this).config.selector2Level3LinesPerPage;
                    }
                }
                return 0;
            }

            @Override
            public int getItemsPerLine(int level) {
                switch (level) {
                    case 0: {
                        return ((TouchOrder7)TouchOrder7.this).config.selector2Level2ItemsPerLine;
                    }
                    case 1: {
                        return ((TouchOrder7)TouchOrder7.this).config.selector2Level3ItemsPerLine;
                    }
                }
                return 0;
            }

            @Override
            public int getFontSize(int level) {
                switch (level) {
                    case 0: {
                        return ((TouchOrder7)TouchOrder7.this).config.selector2Level2FontSize;
                    }
                    case 1: {
                        return ((TouchOrder7)TouchOrder7.this).config.selector2Level3FontSize;
                    }
                }
                return 0;
            }

            @Override
            public int getFontStyle(int level) {
                return 1;
            }

            @Override
            public int getMaxLevels() {
                return 2;
            }

            @Override
            public String getTitle(int level) {
                switch (level) {
                    case 0: {
                        return LangRoAll.categorii;
                    }
                    case 1: {
                        return LangRoAll.produse;
                    }
                }
                return "";
            }

            @Override
            public Vector getData(int level, Object selection) {
                switch (level) {
                    case 0: {
                        return TouchOrder7.this.getSubcategoriesRow(selection);
                    }
                    case 1: {
                        return TouchOrder7.this.getProductsRow(selection);
                    }
                    case 2: {
                        TouchOrder7.this.productChosen(selection, GuiUtils.currentFrame);
                        return null;
                    }
                }
                return new Vector();
            }

            @Override
            public int getMinBtnHeight(int level) {
                switch (level) {
                    case 0: {
                        return ((TouchOrder7)TouchOrder7.this).config.selector2Level1MinHeight;
                    }
                    case 1: {
                        return ((TouchOrder7)TouchOrder7.this).config.selector2Level2MinHeight;
                    }
                    case 2: {
                        return ((TouchOrder7)TouchOrder7.this).config.selector2Level3MinHeight;
                    }
                }
                return 0;
            }

            @Override
            public int getMinBtnWidth(int level) {
                switch (level) {
                    case 0: {
                        return ((TouchOrder7)TouchOrder7.this).config.selector2Level1MinWidth;
                    }
                    case 1: {
                        return ((TouchOrder7)TouchOrder7.this).config.selector2Level2MinWidth;
                    }
                    case 2: {
                        return ((TouchOrder7)TouchOrder7.this).config.selector2Level3MinWidth;
                    }
                }
                return 0;
            }
        };
        this.produsePrincipaleSelector = new Selector2(fullDataProvider);
        return this.produsePrincipaleSelector;
    }

    @Override
    protected Vector getProductsRow(Object selection) {
        return this.getProductsForRow(selection, -1);
    }

    @Override
    protected void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.getDetaliiPanel(), c);
        ++c.gridy;
        c.weighty = 1.0;
        JSplitPane splitPane = new JSplitPane(1, this.getLeftPanel(), this.getRightPanel());
        splitPane.setDividerLocation(0.4);
        this.add((Component)splitPane, c);
    }

    private JPanel getLeftPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        JTabbedPane top = this.getTabs();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.4;
        result.add((Component)top, c);
        ++c.gridy;
        c.weighty = 0.3;
        this.detaliiProdus = new DetaliiProdusPanel("Produs");
        result.add((Component)this.detaliiProdus, c);
        ++c.gridy;
        c.weighty = 0.3;
        this.detaliiComanda = new DetaliiProdusPanel("Comanda");
        result.add((Component)this.detaliiComanda, c);
        return result;
    }

    @Override
    protected JPanel getButtonsPanel() {
        this.initButtons();
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        c.fill = 1;
        c.anchor = 10;
        c.insets = this.insets;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        ++c.gridx;
        this.marcaj.setText(LangRoAll.salveaza);
        result.add((Component)this.marcaj, c);
        ++c.gridx;
        this.nota.setText(LangRoAll.productie);
        result.add((Component)this.nota, c);
        TouchOrder7 panel = this;
        ++c.gridx;
        this.plan.setText(LangRoAll.inapoi);
        result.add((Component)this.plan, c);
        ++c.gridx;
        result.add((Component)this.logout, c);
        return result;
    }

    private JPanel getInstructiuniPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        this.modPreparare = new JTextArea(100, 30);
        this.modPreparare.setLineWrap(true);
        JScrollPane s = new JScrollPane(this.modPreparare);
        result.add((Component)s, c);
        return result;
    }

    class DetaliiProdusPanel
    extends JPanel {
        private JLabel numeProdus;
        private Vector<NewRecipeEntry> data = new Vector();
        private AbstractListPanel alp;
        private String[] _columnNames = new String[]{"Materie prima", LangRoAll.cantitate, "Unitate", LangRoAll.pret, LangRoAll.valoare};
        private Class[] _columnTypes = new Class[]{String.class, String.class, String.class, String.class, String.class};

        DetaliiProdusPanel(String name) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.anchor = 10;
            c.insets = TouchOrder7.this.insets;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            this.numeProdus = new JLabel("");
            this.add((Component)new JLabel(name + ":"), c);
            ++c.gridx;
            this.add((Component)this.numeProdus, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 2;
            c.weighty = 1.0;
            this.alp = new AbstractListPanel(){

                @Override
                public AbstractTM buildTableModel() {
                    this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

                        @Override
                        public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                            double pret;
                            NewRecipeEntry iq;
                            block14: {
                                if (data == null) {
                                    return null;
                                }
                                if (rowIndex >= data.size() || columnIndex >= DetaliiProdusPanel.this._columnNames.length) {
                                    return null;
                                }
                                Object obj = data.elementAt(rowIndex);
                                iq = (NewRecipeEntry)obj;
                                pret = 0.0;
                                if (iq.getIdProduct() > 0) {
                                    try {
                                        int idReteta = RestLogic.getInstance().getIdReteta(iq.getIdProduct());
                                        if (idReteta > 0) {
                                            Vector stack = new Vector();
                                            pret = RestLogic.getInstance().getPretIngredienteCommit(idReteta, new NotEnoughIngredientsException(), stack);
                                            break block14;
                                        }
                                        int idStock = RestLogic.getInstance().getIdStock(iq.getIdProduct());
                                        pret = ContaLogic.getInstance().getPretAchizitieForStock(idStock, iq.getQuantity(), VpConfig.getInstance().calculPretUseCurrentLot);
                                    }
                                    catch (NotEnoughIngredientsException e) {
                                        Logger.logException(this, (Exception)e);
                                    }
                                } else {
                                    pret = ContaLogic.getInstance().getPretAchizitieForStock(iq.getIdStock(), iq.getQuantity(), VpConfig.getInstance().calculPretUseCurrentLot);
                                }
                            }
                            switch (columnIndex) {
                                case 0: {
                                    return iq.getName();
                                }
                                case 1: {
                                    return Utils.getString6Decimals(iq.getQuantity());
                                }
                                case 2: {
                                    return iq.getUm();
                                }
                                case 3: {
                                    return Utils.getString2Decimals(pret);
                                }
                                case 4: {
                                    return Utils.getString2Decimals(iq.getQuantity() * pret);
                                }
                            }
                            return null;
                        }

                        @Override
                        public boolean isCellEditable(int rowIndex, int columnIndex) {
                            return false;
                        }

                        @Override
                        public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                        }
                    });
                    return this.tm;
                }

                @Override
                public JPanel getBottomPanel() {
                    return null;
                }

                @Override
                public Vector buildData() {
                    return DetaliiProdusPanel.this.data;
                }

                @Override
                public String[] buildColumns() {
                    return DetaliiProdusPanel.this._columnNames;
                }

                @Override
                public Class[] buildTypes() {
                    return DetaliiProdusPanel.this._columnTypes;
                }

                @Override
                public void doStuff() {
                    this.display();
                }
            };
            this.alp.doStuff();
            this.add((Component)this.alp, c);
            this.setBorder(new EtchedBorder());
        }

        public void refresh(int idProduct, Vector<Sale> sales) {
            if (idProduct > 0) {
                Product p = NomeclaturaLogic.getInstance().getProductById(idProduct);
                this.numeProdus.setText(p.getName());
                int idReteta = TouchOrder7.this.logic.getIdReteta(idProduct);
                this.data = TouchOrder7.this.logic.getRecipesForProdusReteta(idReteta, 1);
                this.alp.refreshTable();
            }
            if (sales != null) {
                this.numeProdus.setText("Toata comanda");
                Hashtable<String, NewRecipeEntry> entries = new Hashtable<String, NewRecipeEntry>();
                for (Sale sale : sales) {
                    int idProdus = sale.getIdProduct();
                    int idReteta = TouchOrder7.this.logic.getIdReteta(idProdus);
                    Vector<NewRecipeEntry> temp = TouchOrder7.this.logic.getRecipesForProdusReteta(idReteta, 1);
                    for (NewRecipeEntry recipeEntry : temp) {
                        NewRecipeEntry existing = (NewRecipeEntry)entries.get(recipeEntry.getName());
                        if (existing != null) {
                            existing.setQuantity(existing.getQuantity() + recipeEntry.getQuantity() * sale.getCantitateMarcata());
                            continue;
                        }
                        recipeEntry.setQuantity(recipeEntry.getQuantity() * sale.getCantitateMarcata());
                        entries.put(recipeEntry.getName(), recipeEntry);
                    }
                }
                this.data = new Vector(entries.values());
                this.alp.refreshTable();
            }
        }
    }
}

