/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.imports.csv;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.util.Vector;
import jxl.read.biff.BiffException;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.excel.ExcelImportInterface;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.units.UnitsLogic;

public class CsvRetetarImporter {
    private static CsvRetetarImporter instance;
    private ConnectionPool pool = ConnectionPool.getInstance();

    public static synchronized CsvRetetarImporter getInstance() {
        if (instance == null) {
            instance = new CsvRetetarImporter();
        }
        return instance;
    }

    private CsvRetetarImporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRetetar(String file, Component parent) {
        String um = "buc";
        Unit u = UnitsLogic.getInstance().getUnitByName(um);
        if (u == null) {
            UnitsLogic.getInstance().addUnit(um);
        }
        u = UnitsLogic.getInstance().getUnitByName(um);
        int idUm = u.getId();
        try {
            int linuNumber = 0;
            LineNumberReader reader = new LineNumberReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                Vector fields = Utils.splitStringKeepStructure(line, '|', ' ');
                if (fields.size() >= 3) {
                    String codProdus = (String)fields.get(0);
                    String ingredient = (String)fields.get(1);
                    String cantitate = (String)fields.get(2);
                    if (Validators.correctString(codProdus) && Validators.correctString(ingredient) && Validators.correctString(cantitate)) {
                        if (Validators.correctInteger(codProdus)) {
                            if (Validators.correctDouble(cantitate)) {
                                int cod = Integer.parseInt(codProdus);
                                double q = Utils.parseDouble(cantitate);
                                Stock s = StockLogic.getInstance().getStockByNameNoCommit(ingredient);
                                int idStoc = -1;
                                idStoc = s == null ? StockLogic.getInstance().addStockNoCommit(ingredient, idUm, 0.0, 0.0, 0.0, true) : s.getId();
                                Product p = NomeclaturaLogic.getInstance().getProductByCodNoCommit(cod);
                                if (p != null) {
                                    int idReteta = RestLogic.getInstance().getIdRetetaFromDbNoCommit(p.getId());
                                    if (idReteta > 0) {
                                        RestLogic.getInstance().addRecipeItemNoCommit(idReteta, idStoc, -1, q);
                                        this.pool.commit();
                                    } else {
                                        Logger.logWarning(this, " LINIA : " + linuNumber + " Produsul " + p.getName() + " este o marfa !! Il voi transforma in reteta !! ATENTIE ! DUPA IMPORT STERGETI MANUAL STOCURILE INUTILE RAMASE !!!");
                                        int idMarfa = StockLogic.getInstance().getIdStockForProductIdNoCommit(p.getId());
                                        double price = StockLogic.getInstance().getPriceForStockNoCommit(idMarfa, DateUtils.getCurrentTimestamp());
                                        idReteta = RestLogic.getInstance().transformaMarfaInRetetaNoCommit(idMarfa, p.getId(), price, false, false, parent);
                                        RestLogic.getInstance().addRecipeItemNoCommit(idReteta, idStoc, -1, q);
                                        this.pool.commit();
                                    }
                                } else {
                                    Logger.logWarning(this, " LINIA : " + linuNumber + " Nu am gasit nici un produs cu codul intern " + cod);
                                }
                            } else {
                                Logger.logWarning(this, " LINIA : " + linuNumber + " Cantitatea nu este un numar");
                            }
                        } else {
                            Logger.logWarning(this, " LINIA : " + linuNumber + " CodProdus nu este un numar");
                        }
                    }
                }
                line = reader.readLine();
                ++linuNumber;
            }
            this.pool.commit();
        }
        catch (Exception e) {
            Logger.logException("CsvRetetarImporter", e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void importRetetarFromExcel(String excelFile) {
        final NomeclaturaLogic nomeclaturaLogic = NomeclaturaLogic.getInstance();
        final RestLogic logic = RestLogic.getInstance();
        final StockLogic stockLogic = StockLogic.getInstance();
        try {
            ExcelUtils.readExcel(new File(excelFile), new ExcelImportInterface(){
                String sectie = "";
                String categorie = "";
                String produs = "";
                double pret = -1.0;
                boolean isMarfa = false;
                double cantitateIngredient = -1.0;
                String numeIngredient = "";
                String um = "";
                int idTva = 1;

                @Override
                public void sheetEnd(String sheetName) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void lineEnd() {
                    if (Validators.correctString(this.sectie) && Validators.correctString(this.categorie) && Validators.correctString(this.produs)) {
                        try {
                            Sectie s = null;
                            while (s == null) {
                                s = nomeclaturaLogic.getSectieByNameNoCommit(this.sectie);
                                if (s != null) continue;
                                nomeclaturaLogic.addSectieNoCommit(this.sectie, "", "");
                            }
                            Categorie c = null;
                            while (c == null) {
                                c = nomeclaturaLogic.getCategoryByNameNoCommit(this.categorie);
                                if (c != null) continue;
                                nomeclaturaLogic.newCategoryNoCommit(s.getId(), this.categorie, Color.WHITE.getRGB(), s.getCod() + "", this.idTva, false, 0.0);
                            }
                            if (!this.isMarfa) {
                                int idProdusReteta = -1;
                                while (idProdusReteta <= 0) {
                                    Product p = nomeclaturaLogic.getProductByNameNoCommit(this.produs, -1);
                                    if (p == null) {
                                        int cod = nomeclaturaLogic.getNextProductCodeNoCommit();
                                        idProdusReteta = logic.newRetetaProductNoCommit(c.getId(), this.produs, this.pret, new Vector(), cod, this.produs, this.produs, "", "", "", false, true, false, new Vector(), null, cod + "", new Vector<String>())[1];
                                        continue;
                                    }
                                    idProdusReteta = logic.getIdRetetaNoCommit(p.getId());
                                    break;
                                }
                                if (idProdusReteta > 0 && Validators.correctString(this.numeIngredient) && this.cantitateIngredient >= 0.0) {
                                    int idUnit = -1;
                                    while (idUnit <= 0) {
                                        Unit u = UnitsLogic.getInstance().getUnitByNameNoCommit(this.um);
                                        if (u == null) {
                                            idUnit = UnitsLogic.getInstance().addUnitNoCommit(this.um);
                                            continue;
                                        }
                                        idUnit = u.getId();
                                    }
                                    int idStock = -1;
                                    while (idStock <= 0) {
                                        Stock stock = stockLogic.getStockByNameNoCommit(this.numeIngredient);
                                        if (stock == null) {
                                            idStock = stockLogic.addStockNoCommit(this.numeIngredient, idUnit, 0.0, 0.0, -1.0, true);
                                            continue;
                                        }
                                        idStock = stock.getId();
                                    }
                                    logic.addRecipeItemNoCommit(idProdusReteta, idStock, -1, this.cantitateIngredient);
                                }
                            }
                            CsvRetetarImporter.this.pool.commit();
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                            try {
                                CsvRetetarImporter.this.pool.rollBack();
                            }
                            catch (SQLException e1) {
                                Logger.logException(this, (Exception)e);
                            }
                        }
                        finally {
                            CsvRetetarImporter.this.pool.releaseConnection();
                        }
                    }
                    this.sectie = "";
                    this.categorie = "";
                    this.produs = "";
                    this.pret = 0.0;
                    this.isMarfa = false;
                    this.cantitateIngredient = -1.0;
                    this.numeIngredient = "";
                    this.um = "";
                }

                @Override
                public void lineStart() {
                }

                @Override
                public void sheetStart(String sheetName) {
                }

                @Override
                public void valueRead(int row, int column, String value) {
                    if (row == 0) {
                        return;
                    }
                    switch (column) {
                        case 0: {
                            this.sectie = value;
                            break;
                        }
                        case 1: {
                            this.categorie = value;
                            break;
                        }
                        case 2: {
                            this.produs = value;
                            break;
                        }
                        case 3: {
                            value = value.replaceAll(",", ".");
                            if (Validators.correctDouble(value)) {
                                this.pret = Utils.parseDouble(value);
                                break;
                            }
                            this.pret = 0.0;
                            break;
                        }
                        case 4: {
                            if (!Validators.correctString(value) || !value.equalsIgnoreCase("da") && !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("1")) break;
                            this.isMarfa = true;
                            break;
                        }
                        case 5: {
                            if (!Validators.correctString(value)) break;
                            this.numeIngredient = value;
                            break;
                        }
                        case 6: {
                            if (!Validators.correctDouble(value)) break;
                            this.cantitateIngredient = Utils.parseDouble(value);
                            break;
                        }
                        case 7: {
                            if (!Validators.correctString(value)) break;
                            this.um = value;
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (BiffException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }
}

