/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientsLocationsBean;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.base.BonFiscalNumber;
import ro.atreides.restaurant.base.Meniu;
import ro.atreides.restaurant.base.OptiuneProduseMeniu;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.base.TranzactieContClient;
import ro.atreides.restaurant.logic.PaymentLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.logic.exports.DataSyncBean;
import ro.atreides.restaurant.logic.exports.DataSyncChannel;
import ro.atreides.restaurant.modules.fidelitybo.EventClients;
import ro.atreides.restaurant.modules.fidelitybo.EventDef;
import ro.atreides.restaurant.modules.fidelitybo.EventInstance;
import ro.atreides.restaurant.modules.fidelitybo.FidelityLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.SimplePromotion;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;

public class DataSyncServerLogic {
    private static DataSyncServerLogic instance;
    private boolean printBonFiscal = false;
    private ConnectionPool pool;
    private Hashtable<String, DataSyncChannel> channels;

    public boolean isPrintBonFiscal() {
        return this.printBonFiscal;
    }

    public void setPrintBonFiscal(boolean printBonFiscal) {
        this.printBonFiscal = printBonFiscal;
    }

    private DataSyncServerLogic(Hashtable<String, DataSyncChannel> channels) {
        this.channels = channels;
        this.pool = ConnectionPool.getInstance();
    }

    public static final synchronized DataSyncServerLogic getFirstInstance(Hashtable<String, DataSyncChannel> channels) {
        if (instance == null) {
            instance = new DataSyncServerLogic(channels);
        }
        return instance;
    }

    public static final synchronized DataSyncServerLogic getLaterInstance() {
        return instance;
    }

    public void importParteneriNew(String filename) throws IOException, SAXException {
        ClientLogic.getInstance().importOrUpdatePartenerFromXmlNew(filename);
    }

    public void importSales(final String filename, final String channelCodePrefix) throws SAXException, IOException {
        Utils.importXml(new DefaultHandler(){
            private Vector salesToAdd = new Vector();
            Vector plati = new Vector();
            long closedate = System.currentTimeMillis();
            private boolean bonOk = true;
            String location = "";
            String fallbackUser = "";
            int idTable;
            int idUser;
            String username;
            String tablename;
            String orderIdentifier = "";
            String tipOrder = "";
            String clientCodSync = "";
            BonFiscalNumber bonFiscalNumber = null;
            boolean f = true;
            int idPromoForOrder = -1;
            Hashtable<String, Promotion> promotiiHash = new Hashtable();

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                String promoName;
                if (qName.equalsIgnoreCase("document")) {
                    this.promotiiHash.clear();
                    double q = Utils.parseDouble(attributes.getValue("total"));
                    int cardinal = Integer.parseInt(attributes.getValue("cardinal"));
                    String tipuriPlataS = attributes.getValue("tipuri_plata");
                    this.clientCodSync = attributes.getValue("clientCodSync");
                    this.location = attributes.getValue("location");
                    this.idTable = -1;
                    String s1 = attributes.getValue("idTable");
                    if (Validators.correctInteger(s1)) {
                        this.idTable = Integer.parseInt(s1);
                    }
                    this.tablename = attributes.getValue("tablename");
                    this.fallbackUser = attributes.getValue("fallbackUser");
                    s1 = attributes.getValue("idUser");
                    if (Validators.correctInteger(s1)) {
                        this.idUser = Integer.parseInt(s1);
                    }
                    this.username = attributes.getValue("username");
                    this.orderIdentifier = attributes.getValue("orderIdentifier");
                    Vector tipuriPlata = Utils.splitString(tipuriPlataS, ';');
                    for (int i = 0; i < tipuriPlata.size(); ++i) {
                        String tipPlata2 = (String)tipuriPlata.elementAt(i);
                        Vector elements = Utils.splitString(tipPlata2, '|');
                        String tp = (String)elements.get(0);
                        double valoare = Utils.parseDouble((String)elements.get(1));
                        TipPlata tipPlata1 = TipPlataProvider.getInstance().getTipPlataByNameCommit(tp);
                        Plata p = new Plata(tipPlata1.getId(), valoare, tipPlata1.getEcrMapping(), tipPlata1.getLabel(), "", 0);
                        this.plati.add(p);
                    }
                    String closedateS = attributes.getValue("closedate");
                    if (Validators.correctBigInteger(closedateS)) {
                        this.closedate = Long.parseLong(closedateS);
                    }
                    this.tipOrder = Order.TIP_ORDER.VANZARE.toString();
                    String sn = attributes.getValue("tipOrder");
                    if (sn != null) {
                        this.tipOrder = sn;
                    }
                    String bfn_nrzS = attributes.getValue("bfn_nrz");
                    String bfn_nrbon = attributes.getValue("bfn_nrbon");
                    String bfn_nrcasa = attributes.getValue("bfn_nrcasa");
                    if (Validators.correctInteger(bfn_nrbon) && Validators.correctInteger(bfn_nrcasa) && Validators.correctInteger(bfn_nrzS)) {
                        this.bonFiscalNumber = new BonFiscalNumber();
                        this.bonFiscalNumber.setNrBon(Integer.parseInt(bfn_nrbon));
                        this.bonFiscalNumber.setNrCasa(Integer.parseInt(bfn_nrcasa));
                        this.bonFiscalNumber.setNrZ(Integer.parseInt(bfn_nrzS));
                    }
                    this.f = Boolean.parseBoolean(attributes.getValue("f"));
                    SimplePromotion promotion = null;
                    promoName = attributes.getValue("promoName");
                    if (Validators.correctString(promoName) && (promotion = this.promotiiHash.get(promoName)) == null && (promotion = PromotionLogic.getInstance().getPromotionByLabel(promoName)) != null) {
                        this.promotiiHash.put(promoName, (Promotion)promotion);
                    }
                    this.idPromoForOrder = promotion != null ? promotion.getId() : -1;
                }
                if (qName.equalsIgnoreCase("sale")) {
                    String codSync = attributes.getValue("codSync");
                    String codSyncReal = channelCodePrefix + codSync;
                    Product p = NomeclaturaLogic.getInstance().getProductByCodSync(codSyncReal);
                    if (p != null) {
                        double q = Utils.parseDouble(attributes.getValue("cantitate"));
                        double price = Utils.parseDouble(attributes.getValue("pret"));
                        double discount = Utils.parseDouble(attributes.getValue("discount"));
                        double originalPrice = Utils.parseDouble(attributes.getValue("originalPrice"));
                        Sale s = RestLogic.getInstance().buildSale(p, 0.0, q, "", -1, -1, -1, -1, -1, this.closedate, price, "", 0);
                        s.setPpuOriginal(originalPrice);
                        s.setDiscount(discount);
                        promoName = attributes.getValue("promoName");
                        if (Validators.correctString(promoName)) {
                            Promotion promotion = this.promotiiHash.get(promoName);
                            if (promotion == null && (promotion = PromotionLogic.getInstance().getPromotionByLabel(promoName)) != null) {
                                this.promotiiHash.put(promoName, promotion);
                            }
                            if (promotion != null) {
                                s.setIdPromotie(promotion.getId());
                            }
                        }
                        this.salesToAdd.add(s);
                    } else {
                        Logger.logWarning(this, "Produsul cu codul de sincronizare : " + codSyncReal + " nu a fost gasit ! ");
                        this.bonOk = false;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (!this.bonOk) {
                    try {
                        String fullBon = FileUtils.readFileToString(filename);
                        Logger.logWarning(this, "Ignoram intregul bon !! Listam continutul bonului: " + fullBon);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                if (qName.equalsIgnoreCase("document")) {
                    String x = "Order identifier " + this.orderIdentifier + " for filename " + filename;
                    System.out.println(x);
                    try {
                        if (Validators.correctString(this.orderIdentifier)) {
                            int existingOrder = RestLogic.getInstance().getOrderByExternalIdNoCommit(this.orderIdentifier);
                            if (existingOrder > 0) {
                                RestLogic.getInstance().deleteOrderNoCommit(existingOrder);
                                Logger.logDebug(this, "AM sters orderul cu id extern " + this.orderIdentifier + " , id intern " + existingOrder + " PT CA am primit orderul din nou de la statie !!");
                            }
                        } else {
                            try {
                                Logger.logWarning(this, "Am primit orderidentifier incorect . Filename " + filename + " Dump xml : " + FileUtils.readFileToString(filename));
                            }
                            catch (IOException e) {
                                Logger.logWarning(this, e.getMessage());
                                e.printStackTrace();
                            }
                        }
                        Table table = null;
                        Location loc = RestLogic.getInstance().getLocationByCodNoCommit(this.location);
                        if (loc == null) {
                            loc = RestLogic.getInstance().getLocationByNameNoCommit(this.location);
                        }
                        Vector<Location> locations = new Vector<Location>();
                        if (loc != null) {
                            locations.add(loc);
                        }
                        table = RestLogic.getInstance().getFirstFreeTableNoCommit(locations);
                        User casier = UsersLogic.getInstance().getUserByLoginNoCommit(this.fallbackUser);
                        if (casier == null) {
                            Vector<User> v1 = UsersLogic.getInstance().getUsersInGroupNoCommit("group_fo_users");
                            casier = v1.get(0);
                        }
                        if (this.salesToAdd.size() > 0) {
                            Client client;
                            Order order = RestLogic.getInstance().newOrderNoCommit(table.getId(), casier.getId(), false);
                            if (Validators.correctString(this.clientCodSync) && (client = ClientLogic.getInstance().getClientByCodSync(this.clientCodSync)) != null) {
                                RestLogic.getInstance().setClientForOrderNoCommit(order, client.getId(), "");
                            }
                            for (Sale element : this.salesToAdd) {
                                element.setIdOrder(order.getId());
                                RestLogic.getInstance().addSaleNoCommit(element, casier.getId());
                            }
                            order.setFiscal(true);
                            for (int i = 0; i < this.plati.size(); ++i) {
                                Plata plata = (Plata)this.plati.elementAt(i);
                                PaymentLogic.getInstance().addSimplePlataToOrderNoCommit(order, plata);
                            }
                            Order.TIP_ORDER tip = null;
                            try {
                                tip = Order.TIP_ORDER.valueOf(this.tipOrder);
                                RestLogic.getInstance().setTipOrderForIdNoCommit(order, tip);
                            }
                            catch (IllegalArgumentException e) {
                                Logger.logException(this, (Exception)e);
                            }
                            RestLogic.getInstance().setPromotionForOrderNoCommit(order, this.idPromoForOrder);
                            RestLogic.getInstance().closeOrderNoCommit(order, new Timestamp(this.closedate));
                            RestLogic.getInstance().setOrderIdentifierNoCommit(order.getId(), this.orderIdentifier);
                            if (DataSyncServerLogic.this.printBonFiscal && tip.equals((Object)Order.TIP_ORDER.VANZARE)) {
                                RestLogic.getInstance().printBonFiscalSeparat(order, true);
                            } else {
                                if (this.bonFiscalNumber != null) {
                                    PaymentLogic.getInstance().bonFinished(order.getId(), this.bonFiscalNumber.getNrBon(), this.bonFiscalNumber.getNrZ(), this.bonFiscalNumber.getNrCasa(), MP55Impl.CASA_EXPLAIN_MESSAGES.BON_SELLED_NORMALLY, this.orderIdentifier, false);
                                }
                                RestLogic.getInstance().updateOrderF(order, this.f);
                            }
                        } else {
                            String mess = "No sales for orderidentifier " + this.orderIdentifier;
                            Logger.logDebug(this, mess);
                            System.out.println(mess);
                        }
                        DataSyncServerLogic.this.pool.commit();
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                        try {
                            DataSyncServerLogic.this.pool.rollBack();
                        }
                        catch (SQLException e1) {
                            Logger.logException(this, (Exception)e1);
                        }
                    }
                    finally {
                        DataSyncServerLogic.this.pool.releaseConnection();
                    }
                    this.salesToAdd.clear();
                    this.plati.clear();
                    this.bonFiscalNumber = null;
                    this.f = true;
                }
            }
        }, filename);
    }

    public List<DataSyncBean> processRemoteCommands(List<DataSyncBean> toProcess, String channelName) {
        for (DataSyncBean newsBean : toProcess) {
            String content = newsBean.getPayload();
            if (this.testXmlFile(content, channelName)) {
                boolean processedOK = false;
                int tipD = newsBean.getDataType();
                SYNC_OBJECTS type = DataSyncServerLogic.getTipFromCode(tipD);
                DataSyncChannel dataSyncChannelObj = this.channels.get(channelName);
                String channelCodePrefix = "";
                if (dataSyncChannelObj != null) {
                    channelCodePrefix = dataSyncChannelObj.getChannelCodePrefix();
                }
                switch (type) {
                    case SYNC_NOTA: {
                        processedOK = this.processArrivedOrder(content, channelName, channelCodePrefix);
                        break;
                    }
                    case SYNC_PRODUCT: {
                        processedOK = this.processArrivedProduct(content, channelName, channelCodePrefix);
                        break;
                    }
                    case SYNC_NIR: {
                        processedOK = this.processArrivedNir(content, channelName);
                        break;
                    }
                    case SYNC_STOCK: {
                        processedOK = this.processArrivedStock(content, channelName, channelCodePrefix);
                        break;
                    }
                    case SYNC_MAT_PRIMA: {
                        processedOK = this.processArrivedMateriePrima(content, channelName);
                        break;
                    }
                    case SYNC_RETETA: {
                        processedOK = this.processArrivedReteta(content, channelName, channelCodePrefix);
                        break;
                    }
                    case SYNC_MENIU: {
                        processedOK = this.processArrivedMeniuri(content, channelName, channelCodePrefix);
                        break;
                    }
                    case SYNC_CONTCLIENT: {
                        processedOK = this.processArrivedTranzaction(content, channelName, channelCodePrefix);
                        break;
                    }
                    case SYNC_CARDURI: {
                        processedOK = this.processArrivedCarduri(content, channelName, channelCodePrefix);
                        break;
                    }
                    case SYNC_EV_DEF: {
                        processedOK = this.processArrivedEv_Def(content, channelName, channelCodePrefix);
                        break;
                    }
                    case SYNC_EV_INSTANCE: {
                        processedOK = this.processArrivedEv_Instance(content, channelName, channelCodePrefix);
                        break;
                    }
                    case SYNC_EV_CLIENTS: {
                        processedOK = this.processArrivedEv_Client(content, channelName, channelCodePrefix);
                        break;
                    }
                    case SYNC_PARTENER_NEW: {
                        processedOK = this.processArrivedPartenerNew(content, channelName);
                        break;
                    }
                    case SYNC_CLIENTS_LOCATIONS: {
                        processedOK = this.processArrivedClientsLocationsMapping(content, channelName);
                    }
                }
                newsBean.setProcessedOK(processedOK);
                if (processedOK) continue;
                newsBean.setErrorMessage("Server Error. See log for details !");
                continue;
            }
            newsBean.setErrorMessage("Invalid xml file");
            newsBean.setProcessedOK(false);
        }
        return toProcess;
    }

    private boolean processArrivedEv_Client(String xml, String channelName, String channelCodePrefix) {
        String filename = FileUtils.getTempDir() + File.separator + "export_ev_clienti_" + channelName + ".xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            this.importEvClient(filename);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void importEvClient(String filename) throws IOException, SAXException {
        Utils.importXml(new DefaultHandler(){
            private Integer id;
            private Integer puncteClient;
            private Integer tipCard;
            private String codLocatie;
            private String codSyncClient;
            private String codSync;
            private String codSyncEvDef;
            private String nrCard;
            private Timestamp dataPuncte;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equals("ev_client")) {
                    this.id = Integer.valueOf(attributes.getValue("id"));
                    this.puncteClient = Integer.valueOf(attributes.getValue("puncte_client"));
                    this.tipCard = Integer.valueOf(attributes.getValue("tip_card"));
                    this.codLocatie = attributes.getValue("cod_locatie");
                    this.codSyncClient = attributes.getValue("client_cod_sync");
                    this.codSync = attributes.getValue("cod_sync");
                    this.codSyncEvDef = attributes.getValue("cod_sync_id_def");
                    this.nrCard = attributes.getValue("nr_card");
                    this.dataPuncte = Timestamp.valueOf(attributes.getValue("data_puncte"));
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (qName.equals("ev_client")) {
                    EventDef evDef = FidelityLogic.getInstance().getEventDefByCodSync(this.codSyncEvDef);
                    Location loc = RestLogic.getInstance().getLocationByCod(this.codLocatie);
                    Client localClient = ClientLogic.getInstance().getClientByCodSync(this.codSyncClient);
                    EventClients eventClient = null;
                    if (evDef != null && loc != null && localClient != null) {
                        eventClient = new EventClients();
                        eventClient.setIdLocatie(loc.getId());
                        eventClient.setIdEventDef(evDef.getId());
                        eventClient.setNrPuncte(this.puncteClient);
                        eventClient.setTipCard(this.tipCard);
                        eventClient.setCodSync(this.codSync);
                        eventClient.setNrCard(this.nrCard);
                        eventClient.setDataPuncte(this.dataPuncte);
                        eventClient.setIdClient(localClient.getId());
                        EventClients foundEvClient = FidelityLogic.getInstance().getEventClientByCodSync(this.codSync);
                        if (foundEvClient == null) {
                            FidelityLogic.getInstance().addEventClient(eventClient);
                        }
                    }
                }
            }
        }, filename);
    }

    private boolean processArrivedEv_Def(String xml, String channelName, String channelCodePrefix) {
        String filename = FileUtils.getTempDir() + File.separator + "export_ev_def_" + channelName + ".xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            this.importEvDef(filename);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean processArrivedEv_Instance(String xml, String channelName, String channelCodePrefix) {
        String filename = FileUtils.getTempDir() + File.separator + "export_ev_instance_" + channelName + ".xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            this.importEvInstance(filename);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void importEvDef(String filename) throws IOException, SAXException {
        Utils.importXml(new DefaultHandler(){
            private Integer idTipCont;
            private Integer puncte;
            private Integer smsPeriod;
            private Integer emailPeriod;
            private Integer deltaInainte;
            private Integer deltaDupa;
            private Integer tipEveniment;
            private Integer status;
            private String label;
            private String codSync;
            private boolean activ;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equals("ev_def")) {
                    this.idTipCont = Integer.valueOf(attributes.getValue("tipcont"));
                    this.puncte = Integer.valueOf(attributes.getValue("puncte_def"));
                    this.smsPeriod = Integer.valueOf(attributes.getValue("notify_sms_period"));
                    this.emailPeriod = Integer.valueOf(attributes.getValue("notify_email_period"));
                    this.deltaInainte = Integer.valueOf(attributes.getValue("delta_t_inainte"));
                    this.deltaDupa = Integer.valueOf(attributes.getValue("delta_t_dupa"));
                    this.tipEveniment = Integer.valueOf(attributes.getValue("tip"));
                    this.label = attributes.getValue("label");
                    this.codSync = attributes.getValue("cod_sync");
                    String activ1 = attributes.getValue("activ");
                    this.activ = Boolean.parseBoolean(activ1);
                    this.status = Integer.valueOf(attributes.getValue("status"));
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                EventDef newEvDef = new EventDef();
                newEvDef.setActiv(this.activ);
                newEvDef.setIdTipCont(this.idTipCont);
                newEvDef.setPuncte(this.puncte);
                newEvDef.setSmsPeriod(this.smsPeriod);
                newEvDef.setEmailPeriod(this.emailPeriod);
                newEvDef.setDeltaInainte(this.deltaInainte);
                newEvDef.setDeltaDupa(this.deltaDupa);
                newEvDef.setLabel(this.label);
                newEvDef.setTip_eveniment(FidelityLogic.TIP_EVENIMENT.getEvenimentByCode(this.tipEveniment));
                newEvDef.setCodSync(this.codSync);
                newEvDef.setStatus(this.status);
                EventDef eventDef = FidelityLogic.getInstance().getEventDefByCodSync(this.codSync);
                if (eventDef != null) {
                    if (!eventDef.equals(newEvDef)) {
                        FidelityLogic.getInstance().updateEventDefWhereCodSync(newEvDef);
                    }
                } else {
                    FidelityLogic.getInstance().addEventDef(newEvDef);
                }
            }
        }, filename);
    }

    private void importEvInstance(String filename) throws IOException, SAXException {
        Utils.importXml(new DefaultHandler(){
            private Integer id;
            private Integer idLocatie;
            private Integer idEvDef;
            private String codLocatie;
            private String codSync;
            private String codSyncEvDef;
            Timestamp start;
            Timestamp stop;
            private boolean deleted;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equals("ev_instance")) {
                    this.id = Integer.valueOf(attributes.getValue("id"));
                    this.codLocatie = attributes.getValue("cod_locatie");
                    this.idEvDef = Integer.valueOf(attributes.getValue("id_ev_def"));
                    this.codSyncEvDef = attributes.getValue("cod_sync_id_def");
                    this.start = Timestamp.valueOf(attributes.getValue("data_start"));
                    this.stop = Timestamp.valueOf(attributes.getValue("data_stop"));
                    this.codSync = attributes.getValue("cod_sync");
                    this.deleted = Boolean.parseBoolean(attributes.getValue("deleted"));
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                EventDef evDef = FidelityLogic.getInstance().getEventDefByCodSync(this.codSyncEvDef);
                if (evDef != null) {
                    EventInstance foundEvInstance = FidelityLogic.getInstance().getEventInstanceByCodSync(this.codSync);
                    Location loc = RestLogic.getInstance().getLocationByCod(this.codLocatie);
                    if (loc != null && loc.isActive()) {
                        EventInstance incEvInstance = new EventInstance();
                        incEvInstance.setDataStart(this.start);
                        incEvInstance.setDataStop(this.stop);
                        incEvInstance.setCodSync(this.codSync);
                        incEvInstance.setIdEventDef(evDef.getId());
                        incEvInstance.setIdLocatie(loc.getId());
                        incEvInstance.setNumeLocatie(loc.getName());
                        incEvInstance.setNumeEventDef(evDef.getLabel());
                        incEvInstance.setDeleted(this.deleted);
                        if (foundEvInstance != null) {
                            if (!incEvInstance.equals(foundEvInstance)) {
                                FidelityLogic.getInstance().updateEventInstanceWhereCodSync(incEvInstance);
                            }
                        } else {
                            FidelityLogic.getInstance().addEventInstance(incEvInstance);
                        }
                    }
                }
            }
        }, filename);
    }

    private boolean testXmlFile(String xml, String channelName) {
        String filename = FileUtils.getTempDir() + File.separator + "test_" + channelName + ".xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            return true;
        }
        catch (Throwable e) {
            Logger.logError((Object)this, e);
            return false;
        }
    }

    private boolean processArrivedCarduri(String xml, String channel, String channelCodePrefix) {
        String filename = FileUtils.getTempDir() + File.separator + channel + "_" + "current_export_carduri.xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            this.importPromotiiClienti(filename, channelCodePrefix);
            return true;
        }
        catch (Throwable e) {
            Logger.logError((Object)this, e);
            return false;
        }
    }

    private boolean processArrivedTranzaction(String xml, String channel, String channelCodePrefix) {
        String filename = FileUtils.getTempDir() + File.separator + channel + "_" + "current_transaction.xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            this.importTranzactie(filename, channelCodePrefix);
            return true;
        }
        catch (Throwable e) {
            Logger.logError((Object)this, e);
            try {
                String s = FileUtils.readFileToString(xml);
                Logger.logWarning(this, "CONTINUT FISIER : " + s);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
    }

    private boolean processArrivedClientsLocationsMapping(String xml, String channel) {
        String filename = FileUtils.getTempDir() + File.separator + channel + "_" + "current_clientsLocationsMapping.xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            this.importClientLocationMapping(filename);
            return true;
        }
        catch (Throwable e) {
            Logger.logError((Object)this, e);
            return false;
        }
    }

    private void importPromotiiClienti(String filename, String channelCodePrefix) throws IOException, SAXException {
        Utils.importXml(new DefaultHandler(){
            private String card;
            private String promotieLabel;
            private String cardStop;
            private String delete;
            private String codSyncCard;
            private String codSyncClient;
            private Date dateadded = new Date();

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equalsIgnoreCase("promotie")) {
                    this.delete = attributes.getValue("delete");
                    this.codSyncCard = attributes.getValue("codSyncCard");
                    if (this.delete == null) {
                        this.codSyncClient = attributes.getValue("codSyncClient");
                        this.promotieLabel = attributes.getValue("promotie");
                        this.card = attributes.getValue("card");
                        this.cardStop = attributes.getValue("cardstop");
                        String dateS = attributes.getValue("dateadded");
                        if (Validators.correctDate(dateS, Formatters.DATE_TIME_AND_SECONDS_FORMAT)) {
                            try {
                                this.dateadded = Formatters.DATE_TIME_AND_SECONDS_FORMAT.parse(dateS);
                            }
                            catch (ParseException e) {
                                // empty catch block
                            }
                        }
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (qName.equalsIgnoreCase("promotie")) {
                    if (this.delete != null) {
                        PromotionLogic.getInstance().deletePromotionClientByCodSync(this.codSyncCard);
                    } else {
                        boolean cardExists;
                        Promotion p;
                        int idClientLocal = ClientLogic.getInstance().getIdClientByCodSync(this.codSyncClient);
                        Client c = ClientLogic.getInstance().getClientById(idClientLocal);
                        if (c != null && (p = PromotionLogic.getInstance().getPromotionByLabel(this.promotieLabel)) != null && !(cardExists = PromotionLogic.getInstance().existaCardPentruClient(c.getId(), p.getId(), this.card, this.cardStop))) {
                            PromotionLogic.getInstance().addPromotionClientCuCodSync(c.getId(), p.getId(), this.card, this.cardStop, this.codSyncCard, new Timestamp(this.dateadded.getTime()));
                        }
                    }
                }
            }
        }, filename);
    }

    private void importTranzactie(String filename, String channelCodePrefix) throws IOException, SAXException {
        Utils.importXml(new DefaultHandler(){
            private int tipcont;
            private String codSyncClient;
            private String codSyncTranzactie;
            private String detalii;
            private String todelete = null;
            private Timestamp data;
            private double valoare;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equalsIgnoreCase("tranzactie")) {
                    this.todelete = attributes.getValue("todelete");
                    this.codSyncTranzactie = attributes.getValue("codSyncTranzactie");
                    if (this.todelete == null) {
                        this.tipcont = Integer.valueOf(attributes.getValue("tipcont"));
                        this.codSyncClient = attributes.getValue("codSyncClient");
                        this.data = Timestamp.valueOf(attributes.getValue("data"));
                        this.valoare = Double.valueOf(attributes.getValue("valoare"));
                        this.detalii = attributes.getValue("detalii");
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (qName.equalsIgnoreCase("tranzactie")) {
                    if (this.todelete == null) {
                        TranzactieContClient tranzactieContClient = ClientLogic.getInstance().getTranzactieByCodSync(this.codSyncTranzactie);
                        if (tranzactieContClient == null) {
                            int idClient = ClientLogic.getInstance().getIdClientByCodSync(this.codSyncClient);
                            if (idClient > 0) {
                                ClientLogic.getInstance().adaugaTranzactieClientRemote(this.tipcont, idClient, this.valoare, this.detalii, this.codSyncTranzactie, this.data);
                            } else {
                                System.out.println("Idclient not found");
                            }
                        }
                    } else {
                        ClientLogic.getInstance().deleteTranzactieByRemoteId(this.codSyncTranzactie);
                    }
                }
            }
        }, filename);
    }

    private void importClientLocationMapping(String filename) throws IOException, SAXException {
        Utils.importXml(new DefaultHandler(){
            private String codSyncClient;
            private String codLocation;
            private String codSyncMapping;
            private String todelete = null;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equalsIgnoreCase("clientLocationMapping")) {
                    this.todelete = attributes.getValue("todelete");
                    this.codSyncMapping = attributes.getValue("codSync");
                    if (this.todelete == null) {
                        this.codSyncClient = attributes.getValue("codClient");
                        this.codLocation = attributes.getValue("codLocation");
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (qName.equalsIgnoreCase("clientLocationMapping")) {
                    if (this.todelete == null) {
                        ClientsLocationsBean existing = ClientLogic.getInstance().getClientLocationBeanByCodSync(this.codSyncMapping);
                        if (existing == null) {
                            ClientLogic.getInstance().addClientLocationMappingBySync(this.codLocation, this.codSyncClient, this.codSyncMapping);
                        }
                    } else {
                        ClientLogic.getInstance().deleteClientLocationsMappingByCodSync(this.codSyncMapping);
                    }
                }
            }
        }, filename);
    }

    private boolean processArrivedMeniuri(String xml, String channel, String channelCodePrefix) {
        String filename = FileUtils.getTempDir() + File.separator + channel + "_" + "current_menus.xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            this.importMenus(filename, channelCodePrefix);
            return true;
        }
        catch (Throwable e) {
            Logger.logError((Object)this, e);
            return false;
        }
    }

    private void importMenus(String filename, String channelCodePrefix) throws IOException, SAXException {
        Utils.importXml(new DefaultHandler(){
            private int statusMeniu;
            private String labelMeniu;
            private String zileMeniu;
            private String oraStartMeniu;
            private String oraStopMeniu;
            private String codsyncmeniu;
            private boolean isMeniuActiv = false;
            private String codSync = null;
            private String labelOptiune;
            private String labelCategory = null;
            private String labelMeniuAtOptiune;
            private double pret;
            private double cantitate;

            public void resetElements() {
                this.labelMeniu = null;
                this.zileMeniu = null;
                this.oraStartMeniu = null;
                this.oraStopMeniu = null;
                this.isMeniuActiv = false;
                this.codSync = null;
                this.labelOptiune = null;
                this.labelCategory = null;
                this.labelMeniuAtOptiune = null;
                this.codsyncmeniu = null;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equals("meniu")) {
                    this.labelMeniu = attributes.getValue("label");
                    String activ = attributes.getValue("activ");
                    this.codsyncmeniu = attributes.getValue("codsync");
                    if (activ.equals("true")) {
                        this.isMeniuActiv = true;
                    }
                    this.zileMeniu = attributes.getValue("zile");
                    this.oraStartMeniu = attributes.getValue("orastart");
                    this.oraStopMeniu = attributes.getValue("orastop");
                    this.statusMeniu = Integer.valueOf(attributes.getValue("status"));
                }
                if (qName.equals("optiune")) {
                    this.codSync = attributes.getValue("codSync");
                    this.labelOptiune = attributes.getValue("optiune");
                    this.labelMeniuAtOptiune = attributes.getValue("labelmeniu");
                    this.pret = Utils.parseDouble(attributes.getValue("pret"));
                    this.cantitate = Utils.parseDouble(attributes.getValue("cantitate"));
                    this.labelCategory = attributes.getValue("subcategory");
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (qName.equalsIgnoreCase("meniu")) {
                    Meniu m = new Meniu();
                    m.setActiv(this.isMeniuActiv);
                    m.setLabel(this.labelMeniu);
                    m.setOraStart(this.oraStartMeniu);
                    m.setOraStop(this.oraStopMeniu);
                    m.setZile(this.zileMeniu);
                    m.setCodsync(this.codsyncmeniu);
                    m.setStatus(this.statusMeniu);
                    int idMeniuVechi = RestLogic.getInstance().getIdMeniuFromCodsync(m.getCodsync());
                    if (idMeniuVechi != -1) {
                        if (m.getStatus() == 1) {
                            RestLogic.getInstance().deleteAllOptiuniProduse(idMeniuVechi);
                            RestLogic.getInstance().updateMeniu(m.getLabel(), m.isActiv(), idMeniuVechi, m.getZile(), m.getOraStart(), m.getOraStop());
                        } else {
                            RestLogic.getInstance().deleteAllOptiuniProduse(idMeniuVechi);
                            RestLogic.getInstance().deleteMeniu(idMeniuVechi);
                        }
                    } else if (m.getStatus() == 1) {
                        RestLogic.getInstance().addMeniu(m.getLabel(), m.getZile(), m.getOraStart(), m.getOraStop(), this.codsyncmeniu);
                    }
                }
                if (qName.equalsIgnoreCase("optiune")) {
                    OptiuneProduseMeniu op = new OptiuneProduseMeniu();
                    op.setPret(this.pret);
                    op.setCantitate(this.cantitate);
                    int id = RestLogic.getInstance().getIdMeniuFromLabel(this.labelMeniuAtOptiune);
                    op.setIdMeniu(id);
                    if (this.codSync != null) {
                        Product productByCodSync = NomeclaturaLogic.getInstance().getProductByCodSync(this.codSync);
                        if (productByCodSync != null) {
                            op.setIdProduct(productByCodSync.getId());
                        }
                    } else {
                        op.setIdProduct(0);
                    }
                    if (this.labelCategory != null) {
                        Categorie categoryByName = NomeclaturaLogic.getInstance().getCategoryByName(this.labelCategory);
                        if (categoryByName != null) {
                            op.setIdSubcategory(categoryByName.getId());
                        }
                    } else {
                        op.setIdSubcategory(0);
                    }
                    op.setIdOptiune(RestLogic.getInstance().getIdOptiuneFromLabel(this.labelOptiune));
                    if (op.getIdMeniu() != -1) {
                        RestLogic.getInstance().addOptiuneProdus(op.getIdMeniu(), op.getIdSubcategory(), op.getIdProduct(), op.getIdOptiune(), op.getPret(), op.getCantitate());
                    }
                }
                this.resetElements();
            }
        }, filename);
    }

    private boolean processArrivedOrder(String xml, String channel, String channelCodePrefix) {
        String filename = FileUtils.getTempDir() + File.separator + channel + "_" + "current_order.xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            this.importSales(filename, channelCodePrefix);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println("ERROR XML : " + xml);
            return false;
        }
    }

    private boolean processArrivedPartenerNew(String xml, String channel) {
        String filename = FileUtils.getTempDir() + File.separator + channel + "_" + "current_partener_new.xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            this.importParteneriNew(filename);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println("ERROR XML : " + xml);
            return false;
        }
    }

    private boolean processArrivedProduct(String xml, String channel, String channelCodePrefix) {
        String filename = FileUtils.getTempDir() + File.separator + channel + "_" + "current_product.xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            RestLogic.getInstance().importOrUpdateProductFromXml(filename, channelCodePrefix);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println("ERROR XML : " + xml);
            return false;
        }
    }

    private boolean processArrivedStock(String xml, String channel, String channelCodePrefix) {
        String filename = FileUtils.getTempDir() + File.separator + channel + "_" + "current_stock.xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            RestLogic.getInstance().importOrUpdateProductFromXml(filename, channelCodePrefix);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println("ERROR XML : " + xml);
            return false;
        }
    }

    private boolean processArrivedMateriePrima(String xml, String channel) {
        String filename = FileUtils.getTempDir() + File.separator + channel + "_" + "current_materie_prima.xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            RestLogic.getInstance().importOrUpdateMateriePrima(filename);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println("ERROR XML : " + xml);
            return false;
        }
    }

    private boolean processArrivedReteta(String xml, String channel, String channelCodePrefix) {
        String filename = FileUtils.getTempDir() + File.separator + channel + "_" + "current_reteta.xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            RestLogic.getInstance().importOrUpdateReteta(filename, channelCodePrefix);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println("ERROR XML : " + xml);
            return false;
        }
    }

    private boolean processArrivedNir(String xml, String channel) {
        String filename = FileUtils.getTempDir() + File.separator + channel + "_" + "current_nir.xml";
        try {
            File file = new File(filename);
            FileWriter writer = null;
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new FileWriter(file.getAbsolutePath(), false);
            writer.append(xml);
            writer.flush();
            writer.close();
            int idSocietateaNoastra = -1;
            RestLogic.getInstance().importOrUpdateNirFromXml(filename, idSocietateaNoastra);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println("ERROR XML : " + xml);
            return false;
        }
    }

    public static SYNC_OBJECTS getTipFromCode(int code) {
        if (code == SYNC_OBJECTS.SYNC_NOTA.code) {
            return SYNC_OBJECTS.SYNC_NOTA;
        }
        if (code == SYNC_OBJECTS.SYNC_PRODUCT.code) {
            return SYNC_OBJECTS.SYNC_PRODUCT;
        }
        if (code == SYNC_OBJECTS.SYNC_NIR.code) {
            return SYNC_OBJECTS.SYNC_NIR;
        }
        if (code == SYNC_OBJECTS.SYNC_STOCK.code) {
            return SYNC_OBJECTS.SYNC_STOCK;
        }
        if (code == SYNC_OBJECTS.SYNC_MAT_PRIMA.code) {
            return SYNC_OBJECTS.SYNC_MAT_PRIMA;
        }
        if (code == SYNC_OBJECTS.SYNC_RETETA.code) {
            return SYNC_OBJECTS.SYNC_RETETA;
        }
        if (code == SYNC_OBJECTS.SYNC_MENIU.code) {
            return SYNC_OBJECTS.SYNC_MENIU;
        }
        if (code == SYNC_OBJECTS.SYNC_CONTCLIENT.code) {
            return SYNC_OBJECTS.SYNC_CONTCLIENT;
        }
        if (code == SYNC_OBJECTS.SYNC_CARDURI.code) {
            return SYNC_OBJECTS.SYNC_CARDURI;
        }
        if (code == SYNC_OBJECTS.SYNC_EV_DEF.code) {
            return SYNC_OBJECTS.SYNC_EV_DEF;
        }
        if (code == SYNC_OBJECTS.SYNC_EV_INSTANCE.code) {
            return SYNC_OBJECTS.SYNC_EV_INSTANCE;
        }
        if (code == SYNC_OBJECTS.SYNC_EV_CLIENTS.code) {
            return SYNC_OBJECTS.SYNC_EV_CLIENTS;
        }
        if (code == SYNC_OBJECTS.SYNC_PARTENER_NEW.code) {
            return SYNC_OBJECTS.SYNC_PARTENER_NEW;
        }
        if (code == SYNC_OBJECTS.SYNC_CLIENTS_LOCATIONS.code) {
            return SYNC_OBJECTS.SYNC_CLIENTS_LOCATIONS;
        }
        return null;
    }

    public static enum SYNC_OBJECTS {
        SYNC_NOTA(1),
        SYNC_PRODUCT(3),
        SYNC_NIR(4),
        SYNC_STOCK(5),
        SYNC_MAT_PRIMA(6),
        SYNC_RETETA(7),
        SYNC_MENIU(8),
        SYNC_CONTCLIENT(9),
        SYNC_CARDURI(10),
        SYNC_EV_DEF(11),
        SYNC_EV_INSTANCE(12),
        SYNC_EV_CLIENTS(13),
        SYNC_PARTENER_NEW(14),
        SYNC_CLIENTS_LOCATIONS(15);

        int code;

        private SYNC_OBJECTS(int code) {
            this.code = code;
        }
    }
}

