/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.gui.festive.FestiveDate;
import ro.atreides.restaurant.gui.festive.FestiveEntry;
import ro.atreides.restaurant.gui.festive.FestiveProductEntry;
import ro.atreides.restaurant.gui.festive.FestiveTabel1Bean;
import ro.atreides.restaurant.gui.festive.FestiveTabel1Entry;
import ro.atreides.restaurant.gui.festive.FestiveTabel2Entry;
import ro.atreides.restaurant.gui.festive.FestiveTabel3Entry;
import ro.atreides.restaurant.gui.festive.Servire;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.store.cl.FestiveDao;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NotEnoughIngredientsException;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;

public class FestiveLogic
extends EventGenerator {
    private static FestiveLogic instance = null;
    private ConnectionPool pool = ConnectionPool.getInstance();

    private FestiveLogic() {
    }

    public static synchronized FestiveLogic getInstance() {
        if (instance == null) {
            try {
                instance = new FestiveLogic();
            }
            catch (Exception e) {
                Logger.logException(FestiveLogic.class, e);
            }
        }
        return instance;
    }

    private synchronized FestiveDao getFestiveDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        FestiveDao dao = null;
        while (dao == null) {
            dao = (FestiveDao)this.pool.getDao(FestiveDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(FestiveDao.class.getName(), connection);
        }
        return dao;
    }

    public Vector getFestive(Hashtable criteria) {
        try {
            Date start = (Date)criteria.get(Constants.START_KEY);
            Date stop = (Date)criteria.get(Constants.STOP_KEY);
            int idClient = (Integer)criteria.get(Constants.CLIENT_KEY);
            Vector result = this.getFestiveDao().getFestive(idClient, new Timestamp(start.getTime()), new Timestamp(stop.getTime()));
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            for (int i = 0; i < result.size(); ++i) {
                FestiveEntry o = (FestiveEntry)result.elementAt(i);
                Client c = ClientLogic.getInstance().getClientById(o.getIdClient());
                o.setClient(c.toString());
            }
            return result;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return new Vector();
        }
    }

    public boolean deleteEvent(int idEvent) {
        return true;
    }

    public FestiveEntry getFestiveById(int idFestive) {
        return null;
    }

    public void updatePret(int idEvent, int idProduct, double pretNou) {
        try {
            FestiveDate date = this.getFestiveDao().getFestiveDate(idProduct, idEvent);
            int idFestiveDate = -1;
            if (date == null) {
                this.getFestiveDao().addFestiveDate(idEvent, idProduct, pretNou);
                idFestiveDate = this.pool.requestConnection().getIndentityLocal();
            } else {
                idFestiveDate = date.getId();
                this.getFestiveDao().updateFestiveDate(idFestiveDate, pretNou);
            }
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void updateCantitate(int idEvent, int idProduct, double cantConsumata) {
        try {
            FestiveDate date = this.getFestiveDao().getFestiveDate(idProduct, idEvent);
            int idFestiveDate = date.getId();
            this.getFestiveDao().updateFestiveQuantity(idFestiveDate, cantConsumata);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void updateTabel1(int idProduct, int idFel, int idEvent, double newQuantity, double pretNou) {
        try {
            FestiveDate date = this.getFestiveDao().getFestiveDate(idProduct, idEvent);
            int idFestiveDate = -1;
            this.getFestiveDao().deleteFestiveIntrare(idFestiveDate, idFel);
            if (date == null) {
                this.getFestiveDao().addFestiveDate(idEvent, idProduct, pretNou);
                idFestiveDate = this.pool.requestConnection().getIndentityLocal();
            } else {
                idFestiveDate = date.getId();
            }
            this.getFestiveDao().addFestiveIntrari(idFel, newQuantity, idFestiveDate);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public Vector getFestive3ForEveniment(int idEvent) {
        Vector<FestiveTabel3Entry> result = new Vector<FestiveTabel3Entry>();
        try {
            Vector<Product> products = NomeclaturaLogic.getInstance().getAllProducts(-1);
            for (int j = 0; j < products.size(); ++j) {
                Product p = products.elementAt(j);
                double cantNormata = 0.0;
                Vector servire = this.getFeluri();
                for (int i = 0; i < servire.size(); ++i) {
                    Servire s = (Servire)servire.elementAt(i);
                    FestiveTabel1Bean b = new FestiveTabel1Bean();
                    b.setIdServire(s.getId());
                    b.setServire(s.getLabel());
                    double cant = this.getFestiveDao().getTabel1Beans(p.getId(), idEvent, s.getId());
                    b.setCantitate(cant);
                    cantNormata += cant;
                }
                if (!(cantNormata > 0.0)) continue;
                FestiveTabel3Entry e = new FestiveTabel3Entry();
                e.setCantNormata(cantNormata);
                e.setIdProdus(p.getId());
                double pretInreg = RestLogic.getInstance().getPriceForProductCommit(p.getId());
                e.setPretInreg(pretInreg);
                FestiveDate d = this.getFestiveDao().getFestiveDate(p.getId(), idEvent);
                if (d != null) {
                    e.setPretNou(d.getPret());
                    e.setCantConsumata(d.getCantEfectiva());
                } else {
                    e.setPretNou(pretInreg);
                    e.setCantConsumata(0.0);
                }
                e.setProdus(p.getName());
                e.compute();
                result.add(e);
            }
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        return result;
    }

    public Vector getFestive2ForEveniment(int idEvent) {
        Vector<FestiveTabel2Entry> result = new Vector<FestiveTabel2Entry>();
        try {
            Vector<Product> products = NomeclaturaLogic.getInstance().getAllProducts(-1);
            for (int j = 0; j < products.size(); ++j) {
                Product p = products.elementAt(j);
                double cantNormata = 0.0;
                Vector servire = this.getFeluri();
                for (int i = 0; i < servire.size(); ++i) {
                    Servire s = (Servire)servire.elementAt(i);
                    FestiveTabel1Bean b = new FestiveTabel1Bean();
                    b.setIdServire(s.getId());
                    b.setServire(s.getLabel());
                    double cant = this.getFestiveDao().getTabel1Beans(p.getId(), idEvent, s.getId());
                    b.setCantitate(cant);
                    cantNormata += cant;
                }
                if (!(cantNormata > 0.0)) continue;
                FestiveTabel2Entry e = new FestiveTabel2Entry();
                e.setCantNormata(cantNormata);
                e.setIdProdus(p.getId());
                double pretInreg = RestLogic.getInstance().getPriceForProductCommit(p.getId());
                e.setPretInreg(pretInreg);
                FestiveDate d = this.getFestiveDao().getFestiveDate(p.getId(), idEvent);
                if (d != null) {
                    e.setPretNou(d.getPret());
                    e.setCantConsumata(d.getCantEfectiva());
                } else {
                    e.setPretNou(pretInreg);
                    e.setCantConsumata(0.0);
                }
                e.setProdus(p.getName());
                e.compute();
                result.add(e);
            }
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        return result;
    }

    public Vector getFestive1ForEveniment(int idEvent) {
        Vector<FestiveTabel1Entry> result = new Vector<FestiveTabel1Entry>();
        Vector<Product> products = NomeclaturaLogic.getInstance().getAllProducts(-1);
        try {
            for (int j = 0; j < products.size(); ++j) {
                Product p = products.elementAt(j);
                FestiveTabel1Entry e = new FestiveTabel1Entry();
                Vector<FestiveTabel1Bean> items = new Vector<FestiveTabel1Bean>();
                Vector servire = this.getFeluri();
                for (int i = 0; i < servire.size(); ++i) {
                    Servire s = (Servire)servire.elementAt(i);
                    FestiveTabel1Bean b = new FestiveTabel1Bean();
                    b.setIdServire(s.getId());
                    b.setServire(s.getLabel());
                    double cant = this.getFestiveDao().getTabel1Beans(p.getId(), idEvent, s.getId());
                    b.setCantitate(cant);
                    items.add(b);
                }
                e.setItems(items);
                e.setIdProdus(p.getId());
                e.setProdus(p.getName());
                double pretInreg = RestLogic.getInstance().getPriceForProductCommit(p.getId());
                e.setPretInreg(pretInreg);
                FestiveDate d = this.getFestiveDao().getFestiveDate(p.getId(), idEvent);
                if (d != null) {
                    e.setPretNou(d.getPret());
                } else {
                    e.setPretNou(pretInreg);
                }
                e.compute();
                result.add(e);
            }
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        return result;
    }

    public Vector getDataForEveniment(int idEvent) {
        return new Vector();
    }

    public Vector getFeluri() {
        try {
            Vector result = this.getFestiveDao().getFeluri();
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return result;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return new Vector();
        }
    }

    public double[] computeValoareEveniment(Vector data) {
        double[] result = new double[3];
        for (int i = 0; i < data.size(); ++i) {
            FestiveProductEntry fpe = (FestiveProductEntry)data.elementAt(i);
            double total = fpe.getValoare();
            RestLogic rLogic = RestLogic.getInstance();
            double cost = 0.0;
            NotEnoughIngredientsException ex = new NotEnoughIngredientsException();
            if (rLogic.isReteta(fpe.getIdProduct())) {
                int idReteta = rLogic.getIdReteta(fpe.getIdProduct());
                try {
                    Vector stack = new Vector();
                    cost = fpe.getCantitate() * RestLogic.getInstance().getPretIngredienteCommit(idReteta, ex, stack);
                }
                catch (NotEnoughIngredientsException e) {
                    Logger.logException(this, (Exception)e);
                }
            } else {
                int idStock = rLogic.getIdStock(fpe.getIdProduct());
                try {
                    cost = ContaLogic.getInstance().getPretAchizitieForStockNoCommit(idStock, -1.0, false);
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
            }
            result[0] = result[0] + total;
            result[1] = result[1] + cost;
        }
        result[2] = result[0] - result[1] * (1.0 + Config.getInstance().getDouble("tvaNoi"));
        return result;
    }

    public void addEveniment(Vector items, Timestamp data, int idClient, double total, double profit, double aprovizionare) {
        try {
            this.getFestiveDao().addFestive(idClient, data, total, profit, aprovizionare);
            int idFestive = this.pool.requestConnection().getIndentityLocal();
            Hashtable<Integer, Integer> pretAdded = new Hashtable<Integer, Integer>();
            for (int i = 0; i < items.size(); ++i) {
                int idFestiveDate;
                FestiveProductEntry o = (FestiveProductEntry)items.elementAt(i);
                Integer idFestivePret = (Integer)pretAdded.get(o.getIdProduct());
                if (idFestivePret != null) {
                    idFestiveDate = idFestivePret;
                } else {
                    this.getFestiveDao().addFestiveDate(idFestive, o.getIdProduct(), o.getPret());
                    idFestiveDate = this.pool.requestConnection().getIndentityLocal();
                    pretAdded.put(o.getIdProduct(), idFestiveDate);
                }
                this.getFestiveDao().addFestiveIntrari(o.getIdServire(), o.getCantitate(), idFestiveDate);
            }
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }
}

