/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.ecr_online_native.StrangeCodeException;
import ro.atreides.ecr_online_native.database.ProductData;
import ro.atreides.ecr_online_native.database.TransfersInterface;
import ro.atreides.ecr_online_native.newecr.MP55Online;
import ro.atreides.ecr_online_native.newecr.online_event.PaymentType;
import ro.atreides.ecronline.BonFiscal;
import ro.atreides.ecronline.BonFiscalItem;
import ro.atreides.ecronline.BonFiscalPlata;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.nativeonline.db.NativeOnlineDao;
import ro.atreides.restaurant.modules.nativeonline.gui.NativeOnlineMain;
import ro.atreides.stocks.StockLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ObjectEventListener;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;

public class NativeOnlineLogic
extends EventGenerator {
    private ConnectionPool pool;
    private Hashtable products = new Hashtable();
    private static NativeOnlineLogic instance = null;
    private RestLogic logic;
    private boolean lasy = false;
    private Vector threads = new Vector();
    private String allParams;
    private static Object lock = new Object();

    private NativeOnlineLogic() {
    }

    public static synchronized NativeOnlineLogic getInstance() {
        if (instance == null) {
            instance = new NativeOnlineLogic();
        }
        return instance;
    }

    private synchronized NativeOnlineDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        NativeOnlineDao dao = null;
        while (dao == null) {
            dao = (NativeOnlineDao)this.pool.getDao(NativeOnlineDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(NativeOnlineDao.class.getName(), connection);
        }
        return dao;
    }

    private void addProductData(ProductData o, Timestamp now) {
        ProductData existing;
        String c = o.getProductCode();
        if (c.trim().length() != c.length()) {
            String s = "!! Cod de bare : \"" + c + "\" contine spatii.";
            this.notifyObjectListeners(501, s);
        }
        double pret = this.logic.getPriceForProductCommit(o.getProductId());
        String pr = Utils.getString2DecimalsNoTrunc(pret);
        o.setPrice(pr);
        o.setPret(pret);
        if (!Validators.correctString(o.getTvaGroup())) {
            o.setTvaGroup("1");
        }
        if ((existing = (ProductData)this.products.get(c)) != null) {
            String s = "!! Cod de bare dublat : \"" + c + "\" produsele : \"" + o.getProductName() + "\", \"" + existing.getProductName() + "\"";
            this.notifyObjectListeners(501, s);
        }
        this.products.put(c, o);
    }

    private void addProductData(Vector productData) {
        Timestamp now = DateUtils.getCurrentTimestamp();
        for (int i = 0; i < productData.size(); ++i) {
            ProductData o = (ProductData)productData.elementAt(i);
            this.addProductData(o, now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rebuildProducts() {
        this.products.clear();
        try {
            if (!this.lasy) {
                Vector prods = this.getDao().getProducts(-1);
                this.addProductData(prods);
                String s = "Rebuild products completed : " + this.products.size() + " items.";
                Logger.logDebug(this, s);
                this.notifyObjectListeners(501, s);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void init(String allParams, String numeCasa) {
        this.logic = RestLogic.getInstance();
        this.pool = ConnectionPool.getInstance();
        NativeOnlineMain.numeCasa = numeCasa;
        NomeclaturaLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                NativeOnlineLogic.this.rebuildProducts();
            }

            @Override
            public String getName() {
                return "NativeOnline_products";
            }
        }, 2);
        StockLogic.getInstance().addObjectListener(new ObjectEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dataChanged(Object o) {
                Product p = (Product)o;
                String cod = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(p.getId());
                ProductData pd = (ProductData)NativeOnlineLogic.this.products.get(cod);
                if (pd != null) {
                    NativeOnlineLogic.this.products.remove(cod);
                }
                try {
                    Vector products = NativeOnlineLogic.this.getDao().getProducts(p.getId());
                    NativeOnlineLogic.this.addProductData(products);
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                finally {
                    try {
                        NativeOnlineLogic.this.pool.commit();
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    NativeOnlineLogic.this.pool.releaseConnection();
                }
            }

            @Override
            public String getName() {
                return "NativeOnline_Product_Changed";
            }
        }, 100);
        StockLogic.getInstance().addObjectListener(new ObjectEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dataChanged(Object o) {
                Product p = (Product)o;
                try {
                    Vector products = NativeOnlineLogic.this.getDao().getProducts(p.getId());
                    NativeOnlineLogic.this.addProductData(products);
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                finally {
                    try {
                        NativeOnlineLogic.this.pool.commit();
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    NativeOnlineLogic.this.pool.releaseConnection();
                }
            }

            @Override
            public String getName() {
                return "NativeOnline_Product_Added";
            }
        }, 101);
        this.allParams = allParams;
        this.buildAllThreads();
        this.rebuildProducts();
    }

    private void buildAllThreads() {
        Vector params = Utils.splitString(this.allParams, ',');
        for (int i = 0; i < params.size(); ++i) {
            String o = (String)params.elementAt(i);
            Vector configs = Utils.splitString(o, '=');
            String port = (String)configs.elementAt(0);
            String speedS = (String)configs.elementAt(1);
            String masaS = (String)configs.elementAt(2);
            String user = (String)configs.elementAt(3);
            String loadType = (String)configs.elementAt(4);
            if (Validators.correctString(loadType) && loadType.equalsIgnoreCase("lasy")) {
                this.lasy = true;
            }
            int speed = Integer.parseInt(speedS);
            int masa = Integer.parseInt(masaS);
            User u = UsersLogic.getInstance().getUserByLogin(user);
            if (u != null) {
                int idUser = u.getId();
                MP55Online mpThread = this.startNativeThread(idUser, port, speed, masa);
                this.threads.add(mpThread);
                continue;
            }
            DialogUtils.errorDialog(null, "Utilizatorul \"" + user + "\" nu este introdus in sistem", "NativeOnline eroare initializare");
        }
    }

    public synchronized void restartThreads() {
        for (int i = 0; i < this.threads.size(); ++i) {
            MP55Online mp55Online = (MP55Online)this.threads.elementAt(i);
            mp55Online.closeAll();
        }
        this.threads.clear();
        this.buildAllThreads();
    }

    private MP55Online startNativeThread(final int idUser, String port, int speed, final int masa) {
        MP55Online mp = null;
        try {
            mp = new MP55Online(port, speed, new TransfersInterface(){
                BonFiscal bf;
                Vector bfitems = new Vector();
                Vector bfPlati = new Vector();
                double totalBon = 0.0;

                private void plataAdded(String codCasa, double totalPlata, double restDePlata) {
                    BonFiscalPlata bfp = new BonFiscalPlata();
                    bfp.setSuma(totalPlata);
                    TipPlata tp = TipPlataProvider.getInstance().getTipPlataByCodCasa(codCasa);
                    if (tp == null) {
                        String warning = "!!! Tipul de plata " + codCasa + " nu este definit.";
                        NativeOnlineLogic.this.notifyObjectListeners(501, warning);
                    }
                    bfp.setTipPlata(tp.getId());
                    this.bfPlati.add(bfp);
                    this.totalBon += totalPlata;
                    if (restDePlata <= totalPlata) {
                        this.inchideBon(this.totalBon);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void inchideBon(double total) {
                    BonFiscal bf = new BonFiscal();
                    bf.setDataBon(System.currentTimeMillis());
                    bf.setItems(this.bfitems);
                    bf.setPlati(this.bfPlati);
                    bf.setTotal(total);
                    try {
                        if (NativeOnlineLogic.this.logic.notaByBonFiscal(bf, idUser, masa, false, true, false)) {
                            NativeOnlineLogic.this.pool.commit();
                        } else {
                            NativeOnlineLogic.this.pool.rollBack();
                        }
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                        try {
                            NativeOnlineLogic.this.pool.rollBack();
                        }
                        catch (SQLException e1) {
                            Logger.logException(this, (Exception)e1);
                        }
                    }
                    finally {
                        NativeOnlineLogic.this.pool.releaseConnection();
                    }
                    this.bfitems.clear();
                    this.bfPlati.clear();
                    this.totalBon = 0.0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public ProductData getProductData(String code, double cantitateCeruta, String serieCasa) throws StrangeCodeException {
                    ProductData pd;
                    Logger.logDebug(this, "getProductData: code=\"" + code + "\" cantitate=\"" + cantitateCeruta + "\" serieCasa=\"" + serieCasa + "\"");
                    String c1 = code.trim();
                    boolean cantar = false;
                    if (Utils.isCodCantar(c1)) {
                        c1 = Utils.getCantarCodBare(c1);
                        cantar = true;
                    }
                    if ((pd = (ProductData)NativeOnlineLogic.this.products.get(c1)) == null && NativeOnlineLogic.this.lasy) {
                        Object object = lock;
                        // MONITORENTER : object
                        try {
                            pd = NativeOnlineLogic.this.getDao().getProductByCodBare(c1);
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                        }
                        finally {
                            try {
                                NativeOnlineLogic.this.pool.commit();
                            }
                            catch (SQLException e) {
                                Logger.logException(this, (Exception)e);
                            }
                            NativeOnlineLogic.this.pool.releaseConnection();
                        }
                        // MONITOREXIT : object
                        if (pd == null) {
                            String warning = "! Produsul cu codul de bare : " + c1 + " nu a fost gasit in baza date.";
                            Logger.logWarning(this, warning);
                            NativeOnlineLogic.this.notifyObjectListeners(501, warning);
                            throw new StrangeCodeException(code);
                        }
                        NativeOnlineLogic.this.addProductData(pd, DateUtils.getCurrentTimestamp());
                    } else if (pd == null) {
                        String warning = "! Produsul cu codul de bare : " + c1 + " nu a fost gasit in hashtable.";
                        Logger.logWarning(this, warning);
                        NativeOnlineLogic.this.notifyObjectListeners(501, warning);
                        throw new StrangeCodeException(code);
                    }
                    if (cantar) {
                        double realCantitate = Utils.getCantarCantitate(code);
                        double valoare = pd.getPret() * realCantitate;
                        ProductData pd1 = new ProductData(pd.getProductCode(), pd.getProductName(), pd.getPrice(), pd.getQuantityString(), pd.getDepartement(), pd.getGroup(), pd.getTvaGroup(), pd.getQuantity());
                        pd1.setPrice(Utils.getString2DecimalsNoTrunc(valoare));
                        Logger.logDebug(this, "Produs cantarit: " + pd1.toString());
                        return pd1;
                    }
                    Logger.logDebug(this, "Produs normal: " + pd.toString());
                    return pd;
                }

                @Override
                public void sellProduct(String code, double cantitate) {
                    BonFiscalItem bfi = new BonFiscalItem();
                    String realCode = code;
                    double realCantitate = cantitate;
                    if (Utils.isCodCantar(code)) {
                        realCode = Utils.getCantarCodBare(code);
                        realCantitate = Utils.getCantarCantitate(code);
                    }
                    bfi.setCodBare(realCode);
                    bfi.setQuantity(realCantitate);
                    this.bfitems.add(bfi);
                }

                @Override
                public void totalTICHET(double total, double restDePlata) {
                    this.plataAdded("1", total, restDePlata);
                }

                @Override
                public void totalCEC(double total, double restDePlata) {
                    this.plataAdded("2", total, restDePlata);
                }

                @Override
                public void totalEUR(double total, double restDePlata) {
                }

                @Override
                public void totalNUMERAR(double total, double restDePlata) {
                    this.plataAdded("0", total, restDePlata);
                }

                @Override
                public void removeProduct(String code) {
                }

                @Override
                public void sellProduct(String code, double cantitate, double price, String serieCasa) {
                }

                @Override
                public void productSentToEcr(String code, double cantitate, double price, String serieCasa) {
                }

                @Override
                public void removeLastTempProduct() {
                }

                @Override
                public void total(PaymentType type, double currentTotal, double restPlata, double totalBon, int nrBon, int nrZ, String serieCasa) {
                }
            });
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        return mp;
    }
}

