/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic;

import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.store.cl.PaymentImpl;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.TipPlata;

public class PaymentLogic
implements EcrFeedbackInterface {
    private static PaymentLogic instance = null;
    private ConnectionPool pool = ConnectionPool.getInstance();

    private synchronized PaymentImpl getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        PaymentImpl dao = null;
        while (dao == null) {
            dao = (PaymentImpl)this.pool.getDao(PaymentImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(PaymentImpl.class.getName(), connection);
        }
        return dao;
    }

    private PaymentLogic() {
    }

    public static synchronized PaymentLogic getInstance() {
        if (instance == null) {
            instance = new PaymentLogic();
        }
        return instance;
    }

    public void addSimplePlataToOrderNoCommit(Order o, Plata plata) throws SQLException {
        this.getDao().addPlata(o.getId(), plata.getIdTipPlata(), plata.getSuma(), plata.getComment(), 0);
    }

    public void addPlataNoCommit(int idOrder, TipPlata tp, double diff, String detalii, int clientIndex) throws SQLException {
        this.getDao().addPlata(idOrder, tp.getId(), diff, detalii, clientIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlataToOrderForHotel(Order o, Plata toAdd, Vector<Sale> salesPlatite) {
        try {
            this.getDao().addPlata(o.getId(), toAdd.getIdTipPlata(), toAdd.getSuma(), toAdd.getComment(), toAdd.getClientIndex());
            int idPlata = this.pool.getIdentityLocal();
            for (Sale sale : salesPlatite) {
                for (Integer idSale : sale.getIdSales()) {
                    this.getDao().addPlataToSale(idPlata, idSale);
                }
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllPlatiForOrder(Order o, int clientIndex) {
        try {
            this.deleteAllPlatiForOrderAndClientIndexNoCommit(o.getId(), clientIndex);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void deleteAllPlatiForOrderAndClientIndexNoCommit(int idOrder, int clientIndex) throws SQLException {
        this.deleteAllPlatiForOrderAndClientIndexAndTipPlataNoCommit(idOrder, clientIndex, -1);
    }

    public void deleteAllPlatiForOrderAndClientIndexAndTipPlataNoCommit(int idOrder, int clientIndex, int idTipPlata) throws SQLException {
        this.getDao().deletePlatiForOrder(idOrder, clientIndex, idTipPlata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlataToOrder(Order o, Plata toAdd) {
        try {
            this.addPlataToOrderNoCommit(o, toAdd);
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.requestConnection().rollback();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void addPlataToOrderNoCommit(Order o, Plata toAdd) throws SQLException {
        this.deleteAllPlatiForOrderAndClientIndexAndTipPlataNoCommit(o.getId(), toAdd.getClientIndex(), toAdd.getIdTipPlata());
        if (Utils.isValueGreaterThanZero(toAdd.getSuma())) {
            this.getDao().addPlata(o.getId(), toAdd.getIdTipPlata(), toAdd.getSuma(), toAdd.getComment(), toAdd.getClientIndex());
        }
    }

    public void deleteAllPlati() throws SQLException {
        this.getDao().deleteAllPlati();
    }

    public void deleteAllPlatiNF() throws SQLException {
        this.getDao().deleteAllPlatiNF();
    }

    public Vector<Plata> getPlatiForOrderNoCommit(int idOrder) throws SQLException {
        return this.getPlatiForOrderNoCommit(idOrder, -1);
    }

    public Vector<Plata> getPlatiForOrderNoCommit(int idOrder, int clientIndex) throws SQLException {
        Vector<Plata> result = this.getDao().getPlatiForOrder(idOrder, clientIndex);
        return result;
    }

    @Deprecated
    public Vector<Plata> getPlatiForOrder(int idOrder) {
        return this.getPlatiForOrder(idOrder, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Plata> getPlatiForOrder(int idOrder, int clientIndex) {
        Vector<Plata> result = new Vector();
        try {
            result = this.getPlatiForOrderNoCommit(idOrder, clientIndex);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public static double getPlatiInVector(Vector plati) {
        return PaymentLogic.getPlatiInVector(plati, -1);
    }

    private static double getPlatiInVector(Vector plati, int idPlataSkip) {
        double result = 0.0;
        for (int i = 0; i < plati.size(); ++i) {
            Plata o = (Plata)plati.elementAt(i);
            if (o.getIdTipPlata() == idPlataSkip) continue;
            result += o.getSuma();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void bonFinished(int idOrder, int nrBon, int nrZ, int idCasa, MP55Impl.CASA_EXPLAIN_MESSAGES explain_messages, String orderIdentifier, boolean lastBon) {
        try {
            Logger.logDebug(this, "IdOrder: " + idOrder + " idCasa: " + idCasa + " nrZ : " + nrZ + " nrBon: " + nrBon + " explain : " + (Object)((Object)explain_messages) + " UNIQUE ORDER ID : " + orderIdentifier);
            this.getDao().addBonFiscalNumber(idOrder, nrBon, nrZ, idCasa, explain_messages);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }
}

