/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic;

import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;

public class ProduseXmlHandler
extends DefaultHandler {
    private int idSectie;
    private int idCategorie;
    private int codSectie;
    private int codCategorie;
    private NomeclaturaLogic nomenclaturaLogic = NomeclaturaLogic.getInstance();
    private RestLogic restLogic = RestLogic.getInstance();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int cod;
        String label;
        if (qName.equalsIgnoreCase("sectie")) {
            label = attributes.getValue("label");
            cod = Integer.parseInt(attributes.getValue("cod"));
            Sectie c = this.nomenclaturaLogic.getSectieByCod(cod);
            if (c == null) {
                this.idSectie = this.nomenclaturaLogic.addSectie(label, cod, "", "");
                this.codSectie = cod;
            } else {
                this.idSectie = c.getId();
                this.codSectie = c.getCod();
                c.setName(label);
                this.nomenclaturaLogic.updateSectie(c);
            }
        }
        if (qName.equalsIgnoreCase("categorie") && this.idSectie > 0) {
            label = attributes.getValue("label");
            cod = Integer.parseInt(attributes.getValue("cod"));
            int color = Integer.parseInt(attributes.getValue("color"));
            int ordine = Integer.parseInt(attributes.getValue("ordine"));
            boolean pretKg = Boolean.parseBoolean(attributes.getValue("pretKg"));
            String codDepartament = attributes.getValue("cod_departament");
            if (codDepartament == null) {
                codDepartament = this.idSectie + "";
            }
            int idTva = Integer.parseInt(attributes.getValue("idTva"));
            Categorie sc = this.nomenclaturaLogic.getCategoryByCod(cod);
            if (sc == null) {
                this.idCategorie = this.nomenclaturaLogic.newCategory(this.idSectie, label, color, cod, ordine, codDepartament, idTva, pretKg, 0.0);
                this.codCategorie = cod;
            } else {
                this.idCategorie = sc.getId();
                this.codCategorie = sc.getCod();
                sc.setColor(color);
                sc.setName(label);
                sc.setNrOrdine(ordine);
                sc.setSectie(this.idSectie);
                sc.setPretKg(pretKg);
                this.nomenclaturaLogic.updateCategory(sc);
            }
        }
        if (qName.equalsIgnoreCase("produs") && this.idCategorie > 0) {
            label = attributes.getValue("label");
            cod = Integer.parseInt(attributes.getValue("cod"));
            String codBareEnum = attributes.getValue("codBare");
            double pret = Utils.parseDouble(attributes.getValue("pret"));
            String casaLabel = attributes.getValue("short_label");
            String sectieLabel = attributes.getValue("sectie_label");
            String liber1 = attributes.getValue("liber1");
            String liber2 = attributes.getValue("liber2");
            String mp = attributes.getValue("mod_preparare");
            boolean uzIntern = Boolean.parseBoolean(attributes.getValue("uz_intern"));
            boolean productie = Boolean.parseBoolean(attributes.getValue("productie"));
            Product p = this.nomenclaturaLogic.getProductByCod(cod);
            Vector coduri = Utils.splitString(codBareEnum, ',');
            if (p == null) {
                int idProdus = this.restLogic.newRetetaProduct(this.idCategorie, label, pret, new Vector(), cod, casaLabel, sectieLabel, liber1, liber2, mp, uzIntern, productie, false, new Vector(), null, String.valueOf(cod), coduri);
                this.nomenclaturaLogic.updateBarcodesForProductById(idProdus, coduri);
            } else {
                p.setName(label);
                p.setIdCategorie(this.idCategorie);
                p.setNumeCasa(casaLabel);
                p.setNumeSectie(sectieLabel);
                p.setLiber1(liber1);
                p.setLiber2(liber2);
                int idReteta = this.restLogic.getIdReteta(p.getId());
                this.restLogic.setModPreparareForReteta(idReteta, mp);
                p.setUzIntern(uzIntern);
                this.restLogic.setProductieForReteta(idReteta, productie);
                this.nomenclaturaLogic.updateProduct(p, pret, new Vector());
                this.nomenclaturaLogic.updateBarcodesForProductById(p.getId(), coduri);
                this.restLogic.setPriceForRetetaProduct(idReteta, pret, false);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("sectie")) {
            this.idSectie = 0;
        }
        if (qName.equalsIgnoreCase("categorie")) {
            this.idCategorie = 0;
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        Logger.logException(this, (Exception)ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        Logger.logException(this, (Exception)ex);
    }
}

