/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import jxl.biff.DisplayFormat;
import jxl.format.CellFormat;
import jxl.format.Font;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeException;
import net.sourceforge.barbecue.BarcodeFactory;
import net.sourceforge.barbecue.BarcodeImageHandler;
import net.sourceforge.barbecue.linear.ean.EAN13Barcode;
import net.sourceforge.barbecue.output.OutputException;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.Server;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.clienti.BiCi;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.clienti.ValoareContClient;
import ro.atreides.clienti.gui.ClientHistoryCommentBean;
import ro.atreides.clienti.gui.ClientHistoryInterface;
import ro.atreides.clienti.gui.ClientHistorySalesBean;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.Factura;
import ro.atreides.contabilitate.Nir;
import ro.atreides.contabilitate.NirEntryFull;
import ro.atreides.contabilitate.export.platforma.ExportNirPlatforma;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.CashRegisterInterface;
import ro.atreides.ecr.DummyCashRegister;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.EcrUtils;
import ro.atreides.ecronline.BonFiscal;
import ro.atreides.ecronline.BonFiscalItem;
import ro.atreides.ecronline.BonFiscalPlata;
import ro.atreides.ecronline.PluFilePrinter;
import ro.atreides.ecronline.PluItem;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.gef.DiagramPanel;
import ro.atreides.monitor.MonitorActions;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.ProductWithPrice;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.AbstractPrinter;
import ro.atreides.print.PrintLogic;
import ro.atreides.print.PrintUtils;
import ro.atreides.print.PrinterBonItem;
import ro.atreides.print.PrinterConfig;
import ro.atreides.print.PrinterSale;
import ro.atreides.productie.NewProductieLogic;
import ro.atreides.productie.ProductieInterface;
import ro.atreides.productie.ProductieLogic;
import ro.atreides.promo.ClientPromotieView;
import ro.atreides.promo.PremiuInstantView;
import ro.atreides.promo.PriceProvider;
import ro.atreides.promo.PriceWrapper;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.promo.PromotionPeriod;
import ro.atreides.restaurant.AdaosReportEntry;
import ro.atreides.restaurant.Fabricare;
import ro.atreides.restaurant.PreparareEntry;
import ro.atreides.restaurant.SalesExcelProcessor;
import ro.atreides.restaurant.SimplePriceProviderImpl;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Bon;
import ro.atreides.restaurant.base.BonFiscalNumber;
import ro.atreides.restaurant.base.Correction;
import ro.atreides.restaurant.base.HotelOrderSaleInterface;
import ro.atreides.restaurant.base.Meniu;
import ro.atreides.restaurant.base.ModPreparare;
import ro.atreides.restaurant.base.NewRecipeEntry;
import ro.atreides.restaurant.base.OptiuneMeniu;
import ro.atreides.restaurant.base.OptiuneProdus;
import ro.atreides.restaurant.base.OptiuneProduseMeniu;
import ro.atreides.restaurant.base.OrdineServire;
import ro.atreides.restaurant.base.PrintSaleInterface;
import ro.atreides.restaurant.base.RaportPeCategoriiSiCoteTva;
import ro.atreides.restaurant.base.RecipeItem;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.SearchSaleInterface;
import ro.atreides.restaurant.base.SectieMagazieEntry;
import ro.atreides.restaurant.base.SimpleMonetarView;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.base.TranzactieContClient;
import ro.atreides.restaurant.base.reports.CorrectionsEntry;
import ro.atreides.restaurant.base.reports.ProtocolEntry;
import ro.atreides.restaurant.base.reports.SalesEntry;
import ro.atreides.restaurant.base.reports.SimpleIncasariEntry;
import ro.atreides.restaurant.clinicabase.ClinicaAnalizeInterface;
import ro.atreides.restaurant.gui.LocatiiDialog;
import ro.atreides.restaurant.gui.achizitii.AchizitiiProdusePanel;
import ro.atreides.restaurant.gui.achizitii.NecesarReportEntry;
import ro.atreides.restaurant.gui.admin.articole.ArticolBean;
import ro.atreides.restaurant.gui.admin.prices.PricePanelEntry;
import ro.atreides.restaurant.gui.admin.recipe.RecipeEntry;
import ro.atreides.restaurant.gui.hotel.HotelOrderBean;
import ro.atreides.restaurant.gui.reports.ComenziReportEntry;
import ro.atreides.restaurant.gui.reports.ManagerReportEntry;
import ro.atreides.restaurant.gui.touch2.LocationPanel2;
import ro.atreides.restaurant.gui.touch2.TouchMain2;
import ro.atreides.restaurant.logic.BonFIscalInterface;
import ro.atreides.restaurant.logic.BonMarcajInterface;
import ro.atreides.restaurant.logic.ColorChooserInterface;
import ro.atreides.restaurant.logic.DecrementFastStockItem;
import ro.atreides.restaurant.logic.ImportProduseBean;
import ro.atreides.restaurant.logic.ImportProduseInterface;
import ro.atreides.restaurant.logic.LocationsFilter;
import ro.atreides.restaurant.logic.MagazieProviderInterface;
import ro.atreides.restaurant.logic.NotaInterface;
import ro.atreides.restaurant.logic.OrderEvent;
import ro.atreides.restaurant.logic.OrderEventReceiver;
import ro.atreides.restaurant.logic.PaymentLogic;
import ro.atreides.restaurant.logic.PlataLaCazareFacturareInterface;
import ro.atreides.restaurant.logic.PlataLaCazareTotalBean;
import ro.atreides.restaurant.logic.PrintEticheteInterface;
import ro.atreides.restaurant.logic.ProductRecurseInterface;
import ro.atreides.restaurant.logic.ProduseXmlHandler;
import ro.atreides.restaurant.logic.TablesFilter;
import ro.atreides.restaurant.logic.UsersFilter;
import ro.atreides.restaurant.modules.afisajclient.AfisajClientBean;
import ro.atreides.restaurant.modules.asterisk.AsteriskEventInterface;
import ro.atreides.restaurant.modules.rezervari.RezervariLogic;
import ro.atreides.restaurant.modules.scale.ScaleMessageConsumer;
import ro.atreides.restaurant.pda2.PdaMeseEntry;
import ro.atreides.restaurant.pda2.PdaUsersEntry;
import ro.atreides.restaurant.store.cl.BonImpl;
import ro.atreides.restaurant.store.cl.ClDaoImpl;
import ro.atreides.restaurant.store.cl.CorrectionsImpl;
import ro.atreides.restaurant.store.cl.LocationsImpl;
import ro.atreides.restaurant.store.cl.ModPreparareDao;
import ro.atreides.restaurant.store.cl.OrdersImpl;
import ro.atreides.restaurant.store.cl.RestProductsImpl;
import ro.atreides.restaurant.store.cl.SalesImpl;
import ro.atreides.restaurant.store.cl.TableCodsBean;
import ro.atreides.restaurant.store.cl.TablesImpl;
import ro.atreides.restaurant.util.CompareUtils;
import ro.atreides.simplestocks.SimpleStockLogic;
import ro.atreides.stocks.BonConsumItem;
import ro.atreides.stocks.Corectie;
import ro.atreides.stocks.DeleteStockImpediments;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockExcelProcessor;
import ro.atreides.stocks.StockInterface;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.db.PosImpl;
import ro.atreides.stocks.export.ExportBCPlatforma;
import ro.atreides.stocks.gui.StockViewEntry;
import ro.atreides.stocks.gui.StockViewPanel;
import ro.atreides.users.User;
import ro.atreides.users.UserDeleteInterface;
import ro.atreides.users.UserLogEntry;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.AlarmInterface;
import ro.atreides.utils.Backup;
import ro.atreides.utils.Client;
import ro.atreides.utils.ClientiPeZileBean;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ContaExportInterface;
import ro.atreides.utils.ContaExportMapping;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.DummySmsSender;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.IncasareClientView;
import ro.atreides.utils.InformatieMagazieProdus;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NotEnoughIngredientsException;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Order;
import ro.atreides.utils.PlatiEntry;
import ro.atreides.utils.ProductPriceInterface;
import ro.atreides.utils.Shift;
import ro.atreides.utils.SmsSender;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Unit;
import ro.atreides.utils.UpdateSaleInterface;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.CommonsDao;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.documente.Document;
import ro.atreides.utils.documente.DocumentInterface;
import ro.atreides.utils.documente.DocumenteLogic;
import ro.atreides.utils.documente.TipDocument;
import ro.atreides.utils.events.EventsLogic;
import ro.atreides.utils.excel.ExcelImportInterface;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.facturi.FacturaItemView;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.messaging.Message;
import ro.atreides.utils.messaging.Messenger;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.multilanguage.LanguageLogic;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;
import ro.atreides.utils.plati.TipPlataValue;
import ro.atreides.utils.registre.RegistreLogic;
import ro.atreides.utils.tricky.NonPrintedBonInterface;
import ro.atreides.utils.tricky.TrickyInterface;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.units.UnitsLogic;
import ro.atreides.utils.users.gui.AdministrationPanel;
import ro.atreides.utils.web.WebServerInterface;

public class RestLogic
extends EventGenerator
implements StockInterface,
DeleteStockImpediments,
DocumentInterface,
ProductieInterface,
UserDeleteInterface,
WebServerInterface,
MonitorActions,
TrickyInterface,
ProductPriceInterface,
NonPrintedBonInterface,
MagazieProviderInterface,
ScaleMessageConsumer,
AsteriskEventInterface,
ContaExportInterface,
ClientHistoryInterface {
    private static RestLogic instance = null;
    public static double restOnCurrentOrderForAfisaj = 0.0;
    private PriceProvider priceProvider;
    private StockLogic stockLogic;
    private ContaLogic contaLogic;
    private SmsSender sender;
    private Collection alertDestinations;
    private CashRegisterInterface cashRegister;
    private CashRegisterInterface secondaryCashRegister;
    private Vector<Integer> secondaryCashRegisterSectiiIds = new Vector();
    private ClinicaAnalizeInterface clinicaInterface;
    private EventsLogic eventsLogic;
    private PrintLogic printer;
    private UsersLogic userLogic;
    private NomeclaturaLogic nomeclaturaLogic;
    private PluFilePrinter pluPrinter;
    private ProductieLogic productie;
    private NewProductieLogic newProductie;
    private String logo;
    private Server server;
    private ConnectionPool pool;
    private AlarmInterface alarma;
    private EventGenerator accesInterface;
    private Vector<ScaleMessageConsumer> scaleConsumers = new Vector();
    public AchizitiiProdusePanel achizitiiPanel;
    private Hashtable asteriskEventListeners = new Hashtable();
    private Hashtable reteteByProductHash = new Hashtable();
    private Hashtable stocksByProductHash = new Hashtable();
    private Hashtable<String, List<Integer>> magazieByProductsLocationsHash = new Hashtable();
    private Hashtable<Integer, Double> pricesForStocks = new Hashtable();
    public int fiscalStatus = 1;
    public static final int FISCAL_ALWAYS_ON = 3;
    public static final int FISCAL_ALWAYS_OFF = 2;
    public static final int FISCAL_AS_REQUESTED = 1;
    private Vector<OrderEventReceiver> orderEventReceivers = new Vector();

    private RestLogic() throws SQLException {
        this.pool = ConnectionPool.getInstance();
        this.userLogic = UsersLogic.getInstance();
        this.nomeclaturaLogic = NomeclaturaLogic.getInstance();
        this.eventsLogic = EventsLogic.getInstance();
        this.priceProvider = new SimplePriceProviderImpl();
        this.stockLogic = StockLogic.getInstance();
        this.contaLogic = ContaLogic.getInstance();
        this.sender = new DummySmsSender();
        this.alertDestinations = VpConfig.getInstance().smsDestination;
        this.cashRegister = new DummyCashRegister();
        this.secondaryCashRegister = new DummyCashRegister();
        this.eventsLogic.openDay(1);
    }

    public void addOrderEventReceiver(OrderEventReceiver orderEventReceiver) {
        this.orderEventReceivers.add(orderEventReceiver);
    }

    public void pushOrderEventToReceivers(OrderEvent event) {
        for (OrderEventReceiver orderEventReceiver : this.orderEventReceivers) {
            orderEventReceiver.processEvent(event);
        }
    }

    public ClinicaAnalizeInterface getClinicaInterface() {
        return this.clinicaInterface;
    }

    public void setClinicaInterface(ClinicaAnalizeInterface clinicaInterface) {
        this.clinicaInterface = clinicaInterface;
    }

    public EventGenerator getAccesInterface() {
        return this.accesInterface;
    }

    public void setAccesInterface(EventGenerator accesInterface) {
        System.out.println("Set acces interface: " + accesInterface.getClass().getName());
        this.accesInterface = accesInterface;
    }

    public AlarmInterface getAlarma() {
        return this.alarma;
    }

    public void setAlarma(AlarmInterface alarma) {
        this.alarma = alarma;
    }

    public CashRegisterInterface getCashRegister() {
        return this.cashRegister;
    }

    private synchronized ClDaoImpl getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        ClDaoImpl dao = null;
        while (dao == null) {
            dao = (ClDaoImpl)this.pool.getDao(ClDaoImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(ClDaoImpl.class.getName(), connection);
        }
        return dao;
    }

    private synchronized TablesImpl getTablesDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        TablesImpl dao = null;
        while (dao == null) {
            dao = (TablesImpl)this.pool.getDao(TablesImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(TablesImpl.class.getName(), connection);
        }
        return dao;
    }

    private synchronized OrdersImpl getOrdersDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        OrdersImpl dao = null;
        while (dao == null) {
            dao = (OrdersImpl)this.pool.getDao(OrdersImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(OrdersImpl.class.getName(), connection);
        }
        return dao;
    }

    private synchronized SalesImpl getSalesDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        SalesImpl dao = null;
        while (dao == null) {
            dao = (SalesImpl)this.pool.getDao(SalesImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(SalesImpl.class.getName(), connection);
        }
        return dao;
    }

    private synchronized BonImpl getBonsDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        BonImpl dao = null;
        while (dao == null) {
            dao = (BonImpl)this.pool.getDao(BonImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(BonImpl.class.getName(), connection);
        }
        return dao;
    }

    private synchronized CorrectionsImpl getCorrectionsDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        CorrectionsImpl dao = null;
        while (dao == null) {
            dao = (CorrectionsImpl)this.pool.getDao(CorrectionsImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(CorrectionsImpl.class.getName(), connection);
        }
        return dao;
    }

    private synchronized LocationsImpl getLocationsDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        LocationsImpl dao = null;
        while (dao == null) {
            dao = (LocationsImpl)this.pool.getDao(LocationsImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(LocationsImpl.class.getName(), connection);
        }
        return dao;
    }

    private synchronized RestProductsImpl getProductsDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        RestProductsImpl dao = null;
        while (dao == null) {
            dao = (RestProductsImpl)this.pool.getDao(RestProductsImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(RestProductsImpl.class.getName(), connection);
        }
        return dao;
    }

    private synchronized PosImpl getPosDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        PosImpl dao = null;
        while (dao == null) {
            dao = (PosImpl)this.pool.getDao(PosImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(PosImpl.class.getName(), connection);
        }
        return dao;
    }

    private synchronized ModPreparareDao getMpDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        ModPreparareDao dao = null;
        while (dao == null) {
            dao = (ModPreparareDao)this.pool.getDao(ModPreparareDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(ModPreparareDao.class.getName(), connection);
        }
        return dao;
    }

    public Vector getMonetarPeZile(Hashtable criteria) {
        Vector result = new Vector();
        Date start = (Date)criteria.get(Constants.START_KEY);
        Date stop = (Date)criteria.get(Constants.STOP_KEY);
        return result;
    }

    public double computeTipsForOrder(Order o) {
        int idTips = VpConfig.getInstance().codProdusTips;
        if (idTips > 0) {
            Product p = this.nomeclaturaLogic.getProductByCod(idTips);
            if (p == null) {
                return -2.0;
            }
            double total = 0.0;
            Vector<Sale> sales = this.getSales(o.getId(), true, -1, new ScreenSaleInterface());
            for (int i = 0; i < sales.size(); ++i) {
                Sale o1 = sales.elementAt(i);
                if (o1.getIdProduct() == idTips) continue;
                total += o1.getTotal();
            }
            double tips = total * VpConfig.getInstance().tipsPercent / 100.0;
            Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(o.getId());
            PaymentLogic.getInstance();
            double totalPlati = PaymentLogic.getPlatiInVector(plati);
            if (totalPlati > total) {
                double diff;
                tips = diff = totalPlati - total;
            }
            return tips;
        }
        return -1.0;
    }

    public void setTipsToOrder1(Order o, double totalTips, AbstractPrinter forcedPrinter) {
        int idTips = VpConfig.getInstance().codProdusTips;
        double tipsExistent = 0.0;
        Vector<Sale> sales = this.getSales(o.getId(), true, -1, new ScreenSaleInterface());
        for (int i = 0; i < sales.size(); ++i) {
            Sale o1 = sales.elementAt(i);
            if (o1.getIdProduct() != idTips) continue;
            tipsExistent += o1.getTotal();
        }
        Vector<Sale> tempSales = new Vector<Sale>();
        Product p = this.nomeclaturaLogic.getProductByCod(idTips);
        double price = totalTips;
        Sale se = this.buildSale(p, 0.0, 1.0, "", o.getId(), -1, -1, -1, -1, System.currentTimeMillis(), price, "", 0);
        tempSales.add(se);
        Table t = this.getTableById(o.getTable());
        Sectie s = this.nomeclaturaLogic.getSectieByCategoryId(p.getIdCategorie());
        this.productsSold(tempSales, o, t, s, false, forcedPrinter);
    }

    public void setProductie(ProductieLogic productie) {
        this.productie = productie;
    }

    public void setPrinter(PrintLogic printer) {
        this.printer = printer;
    }

    public void setPriceProvider(PriceProvider priceProvider) {
        this.priceProvider = priceProvider;
    }

    public void setSender(SmsSender sender) {
        this.sender = sender;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public static synchronized RestLogic getInstance() {
        if (instance == null) {
            try {
                instance = new RestLogic();
            }
            catch (SQLException e) {
                Logger.logException(RestLogic.class, (Exception)e);
                Utils.systemExit();
            }
            catch (Exception e) {
                Logger.logException(RestLogic.class, e);
                Utils.systemExit();
            }
        }
        return instance;
    }

    public Sale addSaleNoCommit(Sale newSale, int idRevenueGenerator) throws SQLException {
        this.getSalesDao().addSale(newSale, idRevenueGenerator);
        int id = this.pool.requestConnection().getIndentityLocal();
        if (newSale.getImg() != null) {
            this.insertIntoSalesPictures(id, newSale.getImg());
        }
        newSale.addIdSale(id);
        return newSale;
    }

    public boolean descarcaNotaFast(Order o, Document doc, boolean allSales, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        boolean result = true;
        Vector<Sale> sales = new Vector<Sale>();
        if (o.isFiscal() || o.isProtocol() || allSales) {
            Table t = this.getTableById(o.getTable());
            Vector<Sale> sales1 = this.getOrdersDao().getSales(o.getId(), true, -1, -1, this.pool.requestConnection().getConnection(), new ScreenSaleInterface());
            sales.addAll(sales1);
            Vector results = new Vector();
            for (int i = 0; i < sales.size(); ++i) {
                Sale s = (Sale)sales.elementAt(i);
                boolean result1 = this.descarcaSaleFast(s, new Timestamp(o.getStopTime()), t.getIdLocatie(), doc.getDocument(), doc.isFiscal(), o.isProtocol(), results, s.getIdLot());
                result = result && result1;
            }
            Hashtable<String, DecrementFastStockItem> flatened = new Hashtable<String, DecrementFastStockItem>();
            for (int i = 0; i < results.size(); ++i) {
                DecrementFastStockItem existing;
                DecrementFastStockItem decrementFastStockItem = (DecrementFastStockItem)results.elementAt(i);
                int stockItem = decrementFastStockItem.getStockItem();
                int idMagazie = decrementFastStockItem.getIdMagazie();
                int idLot = decrementFastStockItem.getIdLot();
                String key = stockItem + "_" + idMagazie + idLot;
                if (VpConfig.getInstance().descarcareSeparareByIdSale) {
                    key = key + "_" + decrementFastStockItem.getIdSale();
                }
                if ((existing = (DecrementFastStockItem)flatened.get(key)) != null) {
                    existing.setTotalQuantity(existing.getTotalQuantity() + decrementFastStockItem.getTotalQuantity());
                    continue;
                }
                flatened.put(key, decrementFastStockItem);
            }
            for (DecrementFastStockItem o2 : flatened.values()) {
                this.stockLogic.decrementStock(o2.getIdMagazie(), o2.getStockItem(), o2.getTotalQuantity(), o2.getIdSale(), o2.getSalesTime(), o2.getDocument(), o2.isFiscal(), o2.isProtocol(), comandaType, o2.getIdLot());
            }
        }
        return result;
    }

    public void descarcaNotaSimpleSale(Order o, String document) throws SQLException {
        Table t = this.getTableById(o.getTable());
        Vector<Sale> sales = this.getOrdersDao().getSales(o.getId(), true, -1, -1, this.pool.requestConnection().getConnection(), new ScreenSaleInterface());
        for (int i = 0; i < sales.size(); ++i) {
            Sale s = sales.elementAt(i);
            this.descarcaSaleSimpleStock(s, new Timestamp(o.getStopTime()), t.getIdLocatie(), document, false, s.getCantitateMarcata(), o.isFiscal(), o.isProtocol());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enoughStockForSale(Sale s, Timestamp closeOrder, int idLocatie, StockLogic.COMANDA_TYPE comandaType) {
        boolean result = true;
        try {
            Product p = this.nomeclaturaLogic.getProductById(s.getIdProduct());
            double cantitateRest = s.getCantitateNoua();
            result = this.decrement(p, cantitateRest, s.getFirstIdSale(), idLocatie, closeOrder, "Check stock", true, false, comandaType);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            result = false;
        }
        finally {
            try {
                this.pool.requestConnection().rollback();
                this.pool.releaseConnection();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
        }
        return result;
    }

    private boolean descarcaSaleFast(Sale s, Timestamp closeOrder, int idLocatie, String numeNota, boolean fiscal, boolean protocol, Vector results, int idLot) throws SQLException {
        boolean decrementOK = true;
        Product p = this.nomeclaturaLogic.getProductByIdNoCommit(s.getIdProduct());
        double cantitateRest = s.getCantitateMarcata();
        decrementOK = this.decrementFast(p, cantitateRest, s.getFirstIdSale(), idLocatie, closeOrder, numeNota, fiscal, protocol, results, idLot);
        return decrementOK;
    }

    public boolean descarcaSaleSimpleStock(Sale s, Timestamp closeOrder, int idLocatie, String numeNota, boolean storno, double quantity, boolean fiscal, boolean protocol) throws SQLException {
        Product p = this.nomeclaturaLogic.getProductById(s.getIdProduct());
        double cantitateRest = quantity;
        if (storno) {
            cantitateRest = -cantitateRest;
        }
        this.decrementSimpleStock(p, cantitateRest, s.getFirstIdSale(), idLocatie, closeOrder, numeNota, fiscal, protocol);
        return true;
    }

    public Vector getVanzariNedescarcate(Hashtable criteria) {
        try {
            Date startDate = (Date)criteria.get(Constants.START_KEY);
            Date stopDate = (Date)criteria.get(Constants.STOP_KEY);
            Vector result = this.getSalesDao().getVanzariNeprocesate(new Timestamp(startDate.getTime()), new Timestamp(stopDate.getTime()));
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return result;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return new Vector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recomputePrices(Order o) {
        try {
            this.recomputePricesNoCommit(o);
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void recomputePricesNoCommit(Order o) throws SQLException {
        Vector<Sale> sales = this.getOrdersDao().getSales(o.getId(), false, -1, -1, this.pool.requestConnection().getConnection(), new ScreenSaleInterface());
        this.recomputePricesGenericNoCommit(o, sales, new UpdateSaleInterface(){

            @Override
            public void updateSale(Sale s, double cant, int idPromo, double discount, double price) throws SQLException {
                RestLogic.this.getSalesDao().updateSale(s.getFirstIdSale(), cant, idPromo, discount, price);
            }
        });
    }

    public void subtractDiscountFromSales(Vector<Sale> salesToProcess, double totalValueToSubtract) throws SQLException {
        double updatedValueToSubtract = totalValueToSubtract;
        for (Sale sale : salesToProcess) {
            if (!(updatedValueToSubtract > 0.0)) continue;
            double cantitate = sale.getCantitateMarcata();
            if (cantitate == 0.0) {
                cantitate = sale.getCantitateNoua();
            }
            double valueSale = sale.getPrice() * cantitate;
            double toSubtract = sale.getDiscount();
            if (updatedValueToSubtract > valueSale) {
                updatedValueToSubtract -= valueSale;
                toSubtract += valueSale;
            } else {
                toSubtract += updatedValueToSubtract;
                updatedValueToSubtract -= updatedValueToSubtract;
            }
            this.getSalesDao().updateSale(sale.getFirstIdSale(), cantitate, sale.getIdPromotie(), toSubtract, sale.getPpuOriginal() - toSubtract);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recomputePricesBeforeMarcaj(Order o, Vector sales, UpdateSaleInterface saleInterface) {
        try {
            this.recomputePricesGenericNoCommit(o, sales, saleInterface);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void recomputePricesGenericNoCommit(Order o, Vector sales, UpdateSaleInterface saleInterface) throws SQLException {
        Table t;
        int idPromotion = o.getIdPromotie();
        boolean allowHappyHour = true;
        if (o != null && (t = this.getTableByIdNoCommit(o.getTable())) != null) {
            Location locatie = this.getLocationByIdNoCommit(t.getIdLocatie());
            allowHappyHour = locatie.isAllowHappyHour();
        }
        double totalOrder = this.getTotalOriginalPriceNoCommit(o);
        Hashtable mapByXPlusUnuPromotion = new Hashtable();
        Hashtable<Integer, Integer> xValueForIdPromotion = new Hashtable<Integer, Integer>();
        for (Sale s : sales) {
            Tva tva;
            Categorie cat;
            int idCat;
            double newPrice;
            double ingrediente;
            Product p;
            double discount = 0.0;
            double price = s.getPrice();
            double normalPrice = s.getPpuOriginal();
            int procentAdaosProtocol = VpConfig.getInstance().protocolAdaosComercial;
            double procentAdaosComercial = VpConfig.getInstance().vanzareAdaosComercial;
            int idPromo = -1;
            if (o.isProtocol()) {
                if (procentAdaosProtocol >= 0) {
                    p = this.nomeclaturaLogic.getProductByIdNoCommit(s.getIdProduct());
                    AdaosReportEntry adaos = this.getAdaosEntry(p);
                    ingrediente = adaos.getValIngrediente();
                    newPrice = ingrediente * (double)(100 + procentAdaosProtocol) / 100.0;
                    idCat = p.getIdCategorie();
                    cat = this.nomeclaturaLogic.getCategoryByIdNoCommit(idCat);
                    tva = TvaLogic.getInstance().getTvaByIdNoCommit(cat.getIdTva());
                    newPrice *= 1.0 + tva.getCota();
                    newPrice = FloatUtils.roundDoubleUp(newPrice, 2);
                    discount = normalPrice - newPrice;
                    price = newPrice;
                } else {
                    discount = normalPrice;
                    price = 0.0;
                }
            } else if (procentAdaosComercial >= 0.0) {
                p = this.nomeclaturaLogic.getProductByIdNoCommit(s.getIdProduct());
                AdaosReportEntry adaos = this.getAdaosEntry(p);
                ingrediente = adaos.getValIngrediente();
                newPrice = ingrediente * (100.0 + procentAdaosComercial) / 100.0;
                idCat = p.getIdCategorie();
                cat = this.nomeclaturaLogic.getCategoryByIdNoCommit(idCat);
                tva = TvaLogic.getInstance().getTvaByIdNoCommit(cat.getIdTva());
                newPrice *= 1.0 + tva.getCota();
                newPrice = FloatUtils.roundDoubleUp(newPrice, 2);
                discount = 0.0;
                price = newPrice;
            } else {
                PriceWrapper pw = null;
                if (!s.ignorePromotion()) {
                    normalPrice = s.getPpuOriginal();
                    long d2 = s.getSaledate();
                    pw = this.priceProvider.getPriceForProduct(s.getIdProduct(), s.getIdCategorie(), s.getIdSectie(), idPromotion, normalPrice, d2, totalOrder, allowHappyHour);
                    if (VpConfig.getInstance().maxDiscountValuePerDay > 0.0) {
                        discount = o.getIdClient() > 0 ? this.getAllowedDiscountForCurrentDay(o.getIdClient(), o.getStartTime(), pw, sales, s) : 0.0;
                        price = normalPrice - discount;
                        s.setDiscount(discount);
                        s.setPrice(price);
                    } else {
                        price = pw.getPrice();
                        discount = pw.getDiffPret();
                        s.setDiscount(discount);
                        s.setPrice(price);
                    }
                    if (discount > 0.0) {
                        idPromo = pw.getIdPromotion();
                    }
                    idPromo = pw.getIdPromotion();
                    xValueForIdPromotion.put(idPromo, pw.getValueXForXPlusUnuPromotie());
                }
                if (idPromo != -1) {
                    if (mapByXPlusUnuPromotion.get(idPromo) == null) {
                        mapByXPlusUnuPromotion.put(idPromo, new Vector());
                    }
                    ((Vector)mapByXPlusUnuPromotion.get(idPromo)).add(s);
                }
            }
            if (s.ignorePromotion()) continue;
            s.setIdPromotie(idPromo);
            saleInterface.updateSale(s, s.getCantitateMarcata(), idPromo, discount, price);
        }
        if (!mapByXPlusUnuPromotion.isEmpty()) {
            for (Integer idPromotie : mapByXPlusUnuPromotion.keySet()) {
                int valueXInPromo = (Integer)xValueForIdPromotion.get(idPromotie);
                double totalQuantityInSales = 0.0;
                Promotion promo = PromotionLogic.getInstance().getPromotionByIdNoCommit(idPromotie);
                if (promo == null || promo.getType() != 4) continue;
                Vector salesVector = (Vector)mapByXPlusUnuPromotion.get(idPromotie);
                for (Sale sale : salesVector) {
                    double cantitate = sale.getCantitateMarcata();
                    if (cantitate == 0.0) {
                        cantitate = sale.getCantitateNoua();
                    }
                    totalQuantityInSales += cantitate;
                }
                Collections.sort(salesVector, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Sale s1 = (Sale)o1;
                        Sale s2 = (Sale)o2;
                        double result = s1.getPrice() - s2.getPrice();
                        if (result < 0.0) {
                            return -1;
                        }
                        if (result == 0.0) {
                            return 0;
                        }
                        return 1;
                    }
                });
                int numarProdusePentruDiscount = 0;
                if (valueXInPromo != -1) {
                    numarProdusePentruDiscount = (int)(totalQuantityInSales / (double)(valueXInPromo + 1));
                }
                double totalDiscountValue = 0.0;
                if (numarProdusePentruDiscount <= 0) continue;
                for (Sale sale : salesVector) {
                    double cantitate = sale.getCantitateMarcata();
                    if (cantitate == 0.0) {
                        cantitate = sale.getCantitateNoua();
                    }
                    int cantitateRamasa = 0;
                    if ((double)numarProdusePentruDiscount >= cantitate) {
                        cantitateRamasa = (int)cantitate;
                        numarProdusePentruDiscount = (int)((double)numarProdusePentruDiscount - cantitate);
                    } else {
                        cantitateRamasa = numarProdusePentruDiscount;
                        numarProdusePentruDiscount = 0;
                    }
                    totalDiscountValue += (double)cantitateRamasa * sale.getPrice();
                }
                this.subtractDiscountFromSales(salesVector, totalDiscountValue);
            }
        }
        if (o.getReducereValorica() > 0.0) {
            this.subtractDiscountFromSales(sales, o.getReducereValorica());
        }
    }

    public double getTotalDiscountClient(Client client, Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        if (client instanceof ClientPersJuridica) {
            result.put("client_pj", client);
        } else if (client instanceof ClientPersFizica) {
            result.put("client_pf", client);
        }
        double total = 0.0;
        Vector<IncasareClientView> r = this.getIncasariClienti(result, 1);
        for (int i = 0; i < r.size(); ++i) {
            IncasareClientView incasareClientView = r.elementAt(i);
            total += incasareClientView.getDiscount();
        }
        return total;
    }

    private double getTotalDailyDiscount(long saledate) {
        double dailyQuota;
        double total = dailyQuota = VpConfig.getInstance().maxDiscountValuePerDay;
        return total;
    }

    public double getAvailableDiscountBeforeNota(Client c) {
        ClientPersFizica cpf;
        if (c == null) {
            return 0.0;
        }
        if (c instanceof ClientPersFizica && !(cpf = (ClientPersFizica)c).isDiscount()) {
            return 0.0;
        }
        long saledate = System.currentTimeMillis();
        Date stopDate = DateUtils.getEndOfDay(new Date(saledate));
        Date startDate = DateUtils.getStartOfDay(stopDate);
        double totalDiscountOnCurrentDayBeforeCurrentOrder = this.getTotalDiscountClient(c, startDate, stopDate);
        double totalDailyDiscount = this.getTotalDailyDiscount(saledate);
        return totalDailyDiscount - totalDiscountOnCurrentDayBeforeCurrentOrder;
    }

    private double getAllowedDiscountForCurrentDay(int idClient, long saledate, PriceWrapper pw, Vector<Sale> allSalesOnOrder, Sale currentSale) throws SQLException {
        ClientPersFizica cpf;
        Client c = ClientLogic.getInstance().getClientByIdNoCommit(idClient);
        if (c == null) {
            return 0.0;
        }
        if (c instanceof ClientPersFizica && !(cpf = (ClientPersFizica)c).isDiscount()) {
            return 0.0;
        }
        Date stopDate = DateUtils.getEndOfDay(new Date(saledate));
        Date startDate = DateUtils.getStartOfDay(stopDate);
        double totalDiscountOnCurrentDayBeforeCurrentOrder = this.getTotalDiscountClient(c, startDate, stopDate);
        double totalDiscountOnCurrentOrderBeforeCurrentSale = 0.0;
        for (Sale sale : allSalesOnOrder) {
            if (sale.equals(currentSale)) continue;
            totalDiscountOnCurrentOrderBeforeCurrentSale += sale.getDiscount() * sale.getCantitateMarcata();
        }
        double totalDailyDiscount = this.getTotalDailyDiscount(saledate);
        double discountPropus = pw.getDiffPret() * currentSale.getCantitateMarcata();
        double availableDiscount = totalDailyDiscount - (totalDiscountOnCurrentDayBeforeCurrentOrder + totalDiscountOnCurrentOrderBeforeCurrentSale);
        if (availableDiscount < 0.0) {
            availableDiscount = 0.0;
        }
        discountPropus = Math.min(discountPropus, availableDiscount);
        double result = discountPropus / currentSale.getCantitateMarcata();
        result = FloatUtils.roundDoubleUp(result, 2);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientForOrder(Order o, int idClient, String adresaLivrare) {
        try {
            this.getOrdersDao().setIdClient(idClient, o.getId());
            this.getOrdersDao().setAdresaLivrare(adresaLivrare, o.getId());
            o.setIdClient(idClient);
            o.setAdresaLivrare(adresaLivrare);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void setClientForOrderNoCommit(Order o, int idClient, String adresaLivrare) throws SQLException {
        this.getOrdersDao().setIdClient(idClient, o.getId());
        this.getOrdersDao().setAdresaLivrare(adresaLivrare, o.getId());
        o.setIdClient(idClient);
        o.setAdresaLivrare(adresaLivrare);
    }

    public void setClientAndPromotionForOrderNoCommit(Order o, int idClient, int idPromotion) throws SQLException {
        this.getOrdersDao().setIdClient(idClient, o.getId());
        this.setPromotionForOrderNoCommit(o, idPromotion);
        o.setIdClient(idClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTipOrderForIdCommit(Order o, Order.TIP_ORDER newTip) {
        try {
            this.setTipOrderForIdNoCommit(o, newTip);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void setTipOrderForIdNoCommit(Order o, Order.TIP_ORDER newTip) throws SQLException {
        o.setTipOrder(newTip);
        this.getOrdersDao().setTipOrderForId(o.getTipOrder(), o.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientAndPromotionForOrder(Order o, int idClient, int idPromotion) {
        try {
            this.setClientAndPromotionForOrderNoCommit(o, idClient, idPromotion);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPromotionForOrder(Order o, int idPromotie) {
        try {
            this.setPromotionForOrderNoCommit(o, idPromotie);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void setPromotionForOrderNoCommit(Order o, int idPromotie) throws SQLException {
        this.getOrdersDao().setIdPromotion(idPromotie, o.getId());
        o.setIdPromotie(idPromotie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProtocolForOrder(Order o, boolean protocol) {
        try {
            this.setProtocolForOrderNoCommit(o, protocol);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        String text = (protocol ? "Setat atribut " : "Scos atribut ") + " PROTOCOL pe comanda " + o.getId() + " la data " + Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date());
        String detalii = " Data comanda" + Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date(o.getStartTime()));
        Map map = this.buildMapForExport(text, detalii);
        GenericListenersLogic.getInstance().notifyObjectListeners(1008, map);
    }

    public void setProtocolForOrderNoCommit(Order o, boolean protocol) throws SQLException {
        this.getOrdersDao().setProtocol(protocol, o.getId());
    }

    public boolean isRecipeRecursed(int idProductNou, int idProductVechi) {
        if (idProductNou == idProductVechi) {
            return true;
        }
        if (!this.isReteta(idProductNou)) {
            return false;
        }
        int idReteta = this.getIdReteta(idProductNou);
        Vector recipeItems = new Vector();
        try {
            recipeItems = this.getProductsDao().getRecipeItemsForProdusRetetaId(idReteta);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        for (int i = 0; i < recipeItems.size(); ++i) {
            boolean r1;
            RecipeItem item = (RecipeItem)recipeItems.elementAt(i);
            int idProductItem = item.getIdProduct();
            if (idProductItem == -1 || !(r1 = this.isRecipeRecursed(idProductItem, idProductVechi))) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Integer> getIdMagaziiByProvider(int idProduct, int idLocatie) throws SQLException {
        return this.getIdMagaziiNoCommit(idProduct, idLocatie);
    }

    private boolean decrement(Product p, double productsQuantity, int idSale, int idLocatie, Timestamp saleTime, String document, boolean fiscal, boolean protocol, final StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        ProductRecurseInterface decrementStock = new ProductRecurseInterface(){

            @Override
            public double operateOnStock(int idMagazie, int stockItem, double totalQuantity, int idSale, Timestamp saleTime, String document, Vector results, boolean fiscal, boolean protocol) throws SQLException {
                return RestLogic.this.stockLogic.decrementStock(idMagazie, stockItem, totalQuantity, idSale, saleTime, document, fiscal, protocol, comandaType, -1);
            }
        };
        boolean result = this.operateOnProduct(p, productsQuantity, idSale, idLocatie, saleTime, document, decrementStock, new Vector(), fiscal, protocol, this);
        return result;
    }

    private boolean decrementFast(Product p, double productsQuantity, int idSale, int idLocatie, Timestamp saleTime, String document, boolean fiscal, boolean protocol, Vector stockItems, final int idLot) throws SQLException {
        ProductRecurseInterface decrementStock = new ProductRecurseInterface(){

            @Override
            public double operateOnStock(int idMagazie, int stockItem, double totalQuantity, int idSale, Timestamp saleTime, String document, Vector results, boolean fiscal, boolean protocol) throws SQLException {
                DecrementFastStockItem toAdd = new DecrementFastStockItem();
                toAdd.setIdMagazie(idMagazie);
                toAdd.setStockItem(stockItem);
                toAdd.setTotalQuantity(totalQuantity);
                toAdd.setIdSale(idSale);
                toAdd.setSalesTime(saleTime);
                toAdd.setDocument(document);
                toAdd.setFiscal(fiscal);
                toAdd.setProtocol(protocol);
                toAdd.setIdLot(idLot);
                results.add(toAdd);
                return 0.0;
            }
        };
        boolean result = this.operateOnProduct(p, productsQuantity, idSale, idLocatie, saleTime, document, decrementStock, stockItems, fiscal, protocol, this);
        return result;
    }

    private void decrementSimpleStock(Product p, double productsQuantity, int idSale, int idLocatie, Timestamp saleTime, String document, boolean fiscal, boolean protocol) throws SQLException {
        ProductRecurseInterface decrementStock = new ProductRecurseInterface(){

            @Override
            public double operateOnStock(int idMagazie, int stockItem, double totalQuantity, int idSale, Timestamp saleTime, String document, Vector results, boolean fiscal, boolean protocol) throws SQLException {
                if (VpConfig.getInstance().piratMode && !fiscal) {
                    SimpleStockLogic.getInstance().addConsum2(stockItem, idMagazie, totalQuantity);
                } else {
                    SimpleStockLogic.getInstance().addConsum(stockItem, idMagazie, totalQuantity);
                }
                return totalQuantity;
            }
        };
        this.operateOnProduct(p, productsQuantity, idSale, idLocatie, saleTime, document, decrementStock, new Vector(), fiscal, protocol, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdMagazie(int idProduct, int idLocatie) {
        try {
            List<Integer> idMagazii = this.getIdMagaziiNoCommit(idProduct, idLocatie);
            if (idMagazii == null || idMagazii.isEmpty()) {
                int n = -1;
                return n;
            }
            int n = idMagazii.get(0);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public List<Integer> getIdMagaziiNoCommit(int idProduct, int idLocatie) throws SQLException {
        String key = idProduct + "_" + idLocatie;
        List<Integer> idMagaziiForKey = this.magazieByProductsLocationsHash.get(key);
        if (idMagaziiForKey != null) {
            return this.magazieByProductsLocationsHash.get(key);
        }
        List<Integer> idMagazii = this.getPosDao().getIdMagazieByProductIdAndLocatieId(idProduct, idLocatie);
        this.magazieByProductsLocationsHash.put(key, idMagazii);
        return idMagazii;
    }

    private boolean operateOnProduct(Product p, double productsQuantity, int idSale, int idLocatie, Timestamp saleTime, String document, ProductRecurseInterface recurseInterface, Vector results, boolean fiscal, boolean protocol, MagazieProviderInterface magazieProvider) throws SQLException {
        boolean result = true;
        if (p != null) {
            List<Integer> idMagaziiByProvider = magazieProvider.getIdMagaziiByProvider(p.getId(), idLocatie);
            if (idMagaziiByProvider == null || idMagaziiByProvider.isEmpty()) {
                return false;
            }
            for (final int idMagazieCurenta : idMagaziiByProvider) {
                int idReteta = this.getIdRetetaNoCommit(p.getId());
                int idStock = this.getIdStockNoCommit(p.getId());
                if (idReteta > 0) {
                    int idStockPreparat = this.getDao().getPreparatByIdReteta(idReteta);
                    if (idStockPreparat != -1 && idMagazieCurenta != -1) {
                        productsQuantity = recurseInterface.operateOnStock(idMagazieCurenta, idStockPreparat, productsQuantity, idSale, saleTime, document, results, fiscal, protocol);
                    }
                    if (productsQuantity == 0.0) {
                        result = true;
                        continue;
                    }
                    MagazieProviderInterface parentMagazieProvider = new MagazieProviderInterface(){

                        @Override
                        public List<Integer> getIdMagaziiByProvider(int idProduct, int idLocatie) throws SQLException {
                            ArrayList<Integer> result = new ArrayList<Integer>();
                            result.add(idMagazieCurenta);
                            return result;
                        }
                    };
                    result = this.operateOnReteta(idReteta, p.getId(), productsQuantity, idSale, idLocatie, saleTime, document, recurseInterface, results, fiscal, protocol, parentMagazieProvider);
                    continue;
                }
                if (idStock > 0) {
                    if (idMagazieCurenta == -1) continue;
                    result = recurseInterface.operateOnStock(idMagazieCurenta, idStock, productsQuantity, idSale, saleTime, document, results, fiscal, protocol) == 0.0;
                    continue;
                }
                Logger.logError((Object)this, "Produsul " + p.getName() + " nu este nici reteta, nici produs finit !!");
            }
        } else {
            Logger.logError((Object)this, "Mi s-a cerut sa descarc produsul \"null\"");
        }
        return result;
    }

    private boolean operateOnReteta(int idProdusReteta, int idProduct, double productsQuantity, int idSale, int idLocatie, Timestamp saleTime, String document, ProductRecurseInterface recurseInterface, Vector results, boolean fiscal, boolean protocol, MagazieProviderInterface parentProductMagazieProvider) throws SQLException {
        boolean result = true;
        Vector recipeItems = this.getProductsDao().getRecipeItemsForProdusRetetaId(idProdusReteta);
        for (RecipeItem item : recipeItems) {
            int idProductItem = item.getIdProduct();
            int stockItem = item.getIdStock();
            double quantity = item.getQuantity();
            double totalQuantity = quantity * productsQuantity;
            if (idProductItem != -1) {
                Product prod = this.nomeclaturaLogic.getProductByIdNoCommit(idProductItem);
                boolean ok = this.operateOnProduct(prod, totalQuantity, idSale, idLocatie, saleTime, document, recurseInterface, results, fiscal, protocol, parentProductMagazieProvider);
                result = result && ok;
                continue;
            }
            List<Integer> idMagaziiNoCommit = parentProductMagazieProvider.getIdMagaziiByProvider(idProduct, idLocatie);
            int idMagazie = idMagaziiNoCommit == null || idMagaziiNoCommit.isEmpty() ? -1 : idMagaziiNoCommit.get(0);
            if (idMagazie == -1) continue;
            boolean ok = recurseInterface.operateOnStock(idMagazie, stockItem, totalQuantity, idSale, saleTime, document, results, fiscal, protocol) == 0.0;
            result = result && ok;
        }
        return result;
    }

    public boolean descarcaRetetaForFacturaEmisa(int idProdusReteta, double productsQuantity, Timestamp saleTime, String document, final int idMagazie, Vector results, int idSale, boolean fiscal, boolean protocol, final StockLogic.COMANDA_TYPE comandaType, final int idLot) throws SQLException {
        ProductRecurseInterface decrementStock = new ProductRecurseInterface(){

            @Override
            public double operateOnStock(int idMagazie, int stockItem, double totalQuantity, int idSale, Timestamp saleTime, String document, Vector results, boolean fiscal, boolean protocol) throws SQLException {
                return RestLogic.this.stockLogic.decrementStock(idMagazie, stockItem, totalQuantity, idSale, saleTime, document, fiscal, protocol, comandaType, idLot);
            }
        };
        MagazieProviderInterface mpi = new MagazieProviderInterface(){

            @Override
            public List<Integer> getIdMagaziiByProvider(int idProduct, int idLocatie) throws SQLException {
                ArrayList<Integer> idMagazii = new ArrayList<Integer>();
                idMagazii.add(idMagazie);
                return idMagazii;
            }
        };
        int idStockPreparat = this.getDao().getPreparatByIdReteta(idProdusReteta);
        if (idStockPreparat != -1) {
            if (idMagazie != -1) {
                productsQuantity = decrementStock.operateOnStock(idMagazie, idStockPreparat, productsQuantity, idSale, saleTime, document, results, fiscal, protocol);
            }
            return true;
        }
        boolean result = true;
        Vector recipeItems = this.getProductsDao().getRecipeItemsForProdusRetetaId(idProdusReteta);
        for (RecipeItem item : recipeItems) {
            int idProductItem = item.getIdProduct();
            int stockItem = item.getIdStock();
            double quantity = item.getQuantity();
            double totalQuantity = quantity * productsQuantity;
            if (idProductItem != -1) {
                Product prod = this.nomeclaturaLogic.getProductById(idProductItem);
                boolean ok = this.operateOnProduct(prod, totalQuantity, idSale, -1, saleTime, document, decrementStock, results, true, false, mpi);
                result = result && ok;
                continue;
            }
            boolean ok = decrementStock.operateOnStock(idMagazie, stockItem, totalQuantity, idSale, saleTime, document, results, fiscal, protocol) == 0.0;
            result = result && ok;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxPlatouIdForOrder(Order order) {
        try {
            int last = 0;
            if (order != null) {
                last = this.getOrdersDao().getLastPlatouForOrderId(order.getId());
            }
            int n = last;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<Sale> getTemporarySalesForCategory(Sectie cat, Vector sales) {
        Vector<Sale> result = new Vector<Sale>();
        for (Sale element : sales) {
            if (cat.getId() != element.getIdSectie() || !(element.getCantitateNoua() > 0.0)) continue;
            result.add(element);
        }
        return result;
    }

    public String getOrdineServireName(int idServire) {
        Vector<OrdineServire> os = this.getOrdineServire(idServire);
        return os.get(0).getServire();
    }

    public String getOrdineServireNameNoCommit(int idServire) throws SQLException {
        Vector<OrdineServire> os = this.getOrdineServireNoCommit(idServire);
        return os.get(0).getServire();
    }

    public void setNewProductie(NewProductieLogic newProductie) {
        this.newProductie = newProductie;
    }

    public void productsSoldNoCommit(Vector tempSales, Order order, Table t, Sectie cat, boolean protocol, AbstractPrinter forcedPrinter, Client client, int idRevenueGenerator) throws SQLException {
        this.productsSoldNoCommit(tempSales, order, t, cat, protocol, forcedPrinter, client, idRevenueGenerator, true);
    }

    public void productsSoldNoCommit(Vector tempSales, final Order order, final Table table, Sectie cat, boolean protocol, AbstractPrinter forcedPrinter, Client client, int idRevenueGenerator, boolean cutter) throws SQLException {
        this.allSalesToDbNoCommit(tempSales, order, idRevenueGenerator);
        Collections.sort(tempSales);
        final String ora = Formatters.TIME_FORMAT.format(new Date(order.getStartTime()));
        BonMarcajInterface bonAction = new BonMarcajInterface(){

            @Override
            public void productieAction(Sale sale, String detalii, Client client, String currentServireName, int currentPlatouId, User operator, int idSectie) throws SQLException {
                if (RestLogic.this.productie != null && !table.isVirtuala()) {
                    String free1 = "";
                    free1 = VpConfig.getInstance().productieUseOrderId ? RestLogic.this.getFullNameForTableForLivrari(order.getId(), table.getIdLocatie(), ora, order.getAdresaLivrare(), client.getTelefoane(",")) : RestLogic.this.getFullNameForTable(table.getLabel(), table.getIdLocatie());
                    RestLogic.this.productie.addProductieNoCommit(free1, currentServireName == null ? "" : currentServireName, operator.getId(), idSectie, sale.getIdCategorie(), sale.getIdProduct(), currentPlatouId, sale.getCantitateNoua(), sale.getPrice(), detalii, order.getId(), order.getStartTime());
                }
                if (RestLogic.this.newProductie != null && !table.isVirtuala()) {
                    for (Integer saleId : sale.getIdSales()) {
                        RestLogic.this.newProductie.addSaleBeanNoCommit(saleId);
                    }
                }
            }

            @Override
            public void blockedStockAction(Sale sale) throws SQLException {
            }

            @Override
            public String getBonName(Bon bon) throws SQLException {
                String bonName = "";
                if (VpConfig.getInstance().livrariUseBarcodePrinter) {
                    bonName = RestLogic.this.getFullNameForTableForLivrariLabel(ora, order.getId(), table.getIdLocatie()) + " " + order.getDetalii();
                } else {
                    if (VpConfig.getInstance().bonNumbering) {
                        bonName = "Nr " + bon.getNrBon();
                    }
                    if (VpConfig.getInstance().livrariUseNotaNumberAsBonNumber) {
                        bonName = "Comanda Nr " + order.getId();
                    }
                }
                return bonName;
            }
        };
        if (tempSales.size() > 0) {
            String livrare = this.getDetaliiLivrareForLabelPrinter(order);
            String fullTableName = this.getFullNameForTable(table.getLabel(), table.getIdLocatie());
            Location locatie = this.getLocationByIdNoCommit(table.getIdLocatie());
            String[] detaliiClient = RestLogic.getDetaliiClientForBon(order);
            this.printBonMarcajNoCommit(tempSales, order.getUser(), livrare, fullTableName, cat, locatie, forcedPrinter, cutter, protocol, bonAction, detaliiClient, client);
            for (Object o : tempSales) {
                Sale s = (Sale)o;
                if (!VpConfig.getInstance().blockedStocksEnabled) continue;
                bonAction.blockedStockAction(s);
            }
        }
    }

    public void printBonMarcajNoCommit(Vector tempSales, int idUser, String livrare, String fullTableName, Sectie sectie, Location locatie, AbstractPrinter forcedPrinter, boolean cutter, boolean protocol, BonMarcajInterface action, String[] detaliiClient, Client client) throws SQLException {
        Bon b = this.addBonNoCommit(sectie.getId(), idUser);
        User operator = this.userLogic.getUserByIdNoCommit(idUser);
        Vector<PrinterBonItem> bonItems = new Vector<PrinterBonItem>();
        String lastServire = null;
        double totalBon = 0.0;
        for (int i = 0; i < tempSales.size(); ++i) {
            Sale sale = (Sale)tempSales.elementAt(i);
            double price = sale.getPrice();
            double t1 = sale.getCantitateNoua() * price;
            totalBon += t1;
            int currentServireId = sale.getIdServire();
            String currentServireName = "";
            if (currentServireId > 0) {
                currentServireName = this.getOrdineServireNameNoCommit(currentServireId);
            }
            int currentPlatouId = sale.getIdPlatou();
            String platouChar = this.getPlatouChar(tempSales, i, currentPlatouId);
            String detalii = "";
            String quantityS = "";
            if (VpConfig.getInstance().livrariUseBarcodePrinter) {
                detalii = detalii + sale.getModPreparare();
            } else {
                quantityS = Utils.getString3Decimals(sale.getCantitateNoua()) + " ";
                if (Validators.correctString(sale.getModPreparare())) {
                    detalii = detalii + " (" + sale.getModPreparare() + ") ";
                }
            }
            String line = currentServireName + " " + platouChar + " " + quantityS + sale.getSectieName();
            if (!VpConfig.getInstance().livrariUseBarcodePrinter) {
                line = line + " " + detalii;
            }
            if (platouChar.equalsIgnoreCase("/") && !VpConfig.getInstance().livrariUseBarcodePrinter) {
                bonItems.add(new PrinterBonItem("", "", "", "", -1, null));
            }
            if (lastServire != null && !lastServire.equalsIgnoreCase(currentServireName) && !VpConfig.getInstance().livrariUseBarcodePrinter) {
                bonItems.add(new PrinterBonItem("", "", "", "", -1, null));
            }
            Vector<Integer> idCategorieParent = new Vector();
            if (VpConfig.getInstance().livrariUseBarcodePrinter) {
                idCategorieParent = this.nomeclaturaLogic.getParentCategories(sale.getIdCategorie());
            }
            PrinterBonItem bi = new PrinterBonItem(line, "", Utils.getString2Decimals(t1), detalii, sale.getIdCategorie(), idCategorieParent);
            bonItems.add(bi);
            action.productieAction(sale, detalii, client, currentServireName, currentPlatouId, operator, sectie.getId());
            lastServire = currentServireName;
        }
        String bon = action.getBonName(b);
        String numeMasa = "";
        if (VpConfig.getInstance().bonMarcajPrintMasa) {
            numeMasa = fullTableName;
        }
        String waiterName = operator.getName();
        if (client != null) {
            waiterName = livrare;
        }
        String adresaClient = detaliiClient[0];
        String numeClient = detaliiClient[1];
        String telefonClient = detaliiClient[2];
        String bonText = this.printer.printBon(bonItems, waiterName, sectie.getName(), numeMasa, bon, protocol, PrinterConfig.getInstance().nrExemplareBonComanda, sectie, locatie, Utils.getString2Decimals(totalBon), forcedPrinter, livrare, cutter, adresaClient, numeClient, telefonClient);
        String text = "Bon marcaj " + numeSectie + " nr " + b.getNrBon();
        if (Validators.correctString(bonText)) {
            Map map = this.buildMapForExport(text + " " + Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date(b.getTimestamp())), bonText);
            GenericListenersLogic.getInstance().notifyObjectListeners(1001, map);
        }
        if (VpConfig.getInstance().smsSendAtMarcaj) {
            this.sender.sendSms(bonText, this.alertDestinations);
        }
        Logger.logDebugVerbose(this, "BON " + bonText);
        this.addBonItemsNoCommit(b.getId(), bonText);
        this.userLogic.addUserLogNoCommit(operator.getId(), text);
    }

    private void allSalesToDbNoCommit(Vector tempSales, Order order, int idRevenueGenerator) throws SQLException {
        for (Sale element : tempSales) {
            element.setIdOrder(order.getId());
            this.addSaleNoCommit(element, idRevenueGenerator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStartTimeForOrder(Order o, Date newOpenDate) {
        try {
            this.getOrdersDao().setOpendateForOrder(o.getId(), new Timestamp(newOpenDate.getTime()));
            if (this.productie != null) {
                this.productie.updateDateForOrderIdNoCommit(new Timestamp(newOpenDate.getTime()), o.getId());
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void productsSold(Vector tempSales, Order order, Table t, Sectie cat, boolean protocol, AbstractPrinter forcedPrinter, boolean cutter) {
        this.productsSold(tempSales, order, t, cat, protocol, forcedPrinter, null, order.getUser(), cutter);
    }

    public void productsSold(Vector tempSales, Order order, Table t, Sectie cat, boolean protocol, AbstractPrinter forcedPrinter) {
        this.productsSold(tempSales, order, t, cat, protocol, forcedPrinter, null, order.getUser(), true);
    }

    public void productsSold(Vector tempSales, Order order, Table t, Sectie cat, boolean protocol, AbstractPrinter forcedPrinter, int idRevenueGenerator, boolean cutter) {
        this.productsSold(tempSales, order, t, cat, protocol, forcedPrinter, null, idRevenueGenerator, cutter);
    }

    public void productsSoldClientAsWaiter(Vector tempSales, Order order, Table t, Sectie cat, boolean protocol, AbstractPrinter forcedPrinter, Client client) {
        this.productsSold(tempSales, order, t, cat, protocol, forcedPrinter, client, order.getUser(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void productsSold(Vector tempSales, Order order, Table t, Sectie cat, boolean protocol, AbstractPrinter forcedPrinter, Client client, int idRevenueGenerator, boolean cutter) {
        try {
            this.productsSoldNoCommit(tempSales, order, t, cat, protocol, forcedPrinter, client, idRevenueGenerator, cutter);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        if (this.alarma != null) {
            this.alarma.triggerAlarm(cat.getName());
        }
    }

    private String getPlatouChar(Vector sales, int currentIndex, int currentIdPlatou) {
        String result = " ";
        if (currentIdPlatou == -1) {
            return result;
        }
        int previousPlatouId = -1;
        int nextPlatouId = -1;
        if (currentIndex > 0) {
            Sale prev = (Sale)sales.elementAt(currentIndex - 1);
            previousPlatouId = prev.getIdPlatou();
        }
        if (currentIndex < sales.size() - 1) {
            Sale next = (Sale)sales.elementAt(currentIndex + 1);
            nextPlatouId = next.getIdPlatou();
        }
        if (currentIdPlatou == previousPlatouId) {
            result = currentIdPlatou == nextPlatouId ? "|" : "\\";
        } else if (currentIdPlatou == nextPlatouId) {
            result = "/";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getBons() {
        try {
            Vector result;
            Vector vector = result = this.getBonsDao().getAllBons();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Bon addBonNoCommit(Integer cat, Integer user) throws SQLException {
        Bon b = new Bon();
        b.setIdUser(user);
        b.setIdCategory(cat);
        b.setTimestamp(System.currentTimeMillis());
        int nrBon = this.getBonsDao().getLastBonForCategory(cat) + 1;
        b.setNrBon(nrBon);
        this.getBonsDao().addBon(b);
        int id = this.pool.requestConnection().getIndentityLocal();
        b.setId(id);
        return b;
    }

    public void addBonItemsNoCommit(int idBon, String bonText) throws SQLException {
        StringTokenizer token = new StringTokenizer(bonText, "\n");
        while (token.hasMoreTokens()) {
            String t = token.nextToken();
            t = t.replaceAll("\\p{C}", " ");
            this.getBonsDao().addBonEntry(idBon, t);
        }
    }

    public Order getOrderByIdNoCommit(int idOrder) throws SQLException {
        Order result = this.getOrdersDao().getOrderById(idOrder);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Order getOrderById(int idOrder) {
        try {
            Order order = this.getOrderByIdNoCommit(idOrder);
            return order;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Order order = null;
            return order;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteQuantityFromClosedOrder(int idOrder, int idProdus, String numeProdus, User supervisor, double quantity, AbstractPrinter forcedPrinter) {
        Order o = this.getOrderById(idOrder);
        Table t = this.getTableById(o.getTable());
        Vector<Sale> sales = this.getSales(idOrder, false, -1, new ScreenSaleInterface());
        double remaining = quantity;
        for (int i = 0; i < sales.size() && remaining > 0.0; ++i) {
            Sale s = sales.elementAt(i);
            if (s.getIdProduct() != idProdus) continue;
            double currentQ = s.getCantitateMarcata();
            double q = currentQ >= remaining ? remaining : currentQ;
            try {
                if (o.getStopTime() > this.eventsLogic.getLastOpenDateNoCommit(1).getTime()) {
                    this.deleteSaleSimpleStock(s, o, t, q);
                }
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            finally {
                try {
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                this.pool.releaseConnection();
            }
            this.decrementSale(o, s, supervisor, "Modificat cantitatea la produsul " + numeProdus + " nota " + idOrder, q, t, forcedPrinter);
            remaining -= q;
        }
    }

    private void deleteSaleSimpleStock(Sale s, Order o, Table t, double toRemove) {
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        params.put("sale", s);
        params.put("timestamp", new Timestamp(o.getStopTime()));
        params.put("idLocatie", t.getIdLocatie());
        params.put("numeNota", "Nota " + o.getId());
        params.put("quantity", toRemove);
        this.notifyObjectListeners(105, params);
    }

    private String getDetaliiLivrareForLabelPrinter(Order o) {
        String adresaClient = "";
        String numeClient = "";
        String telefonClient = "";
        String detalii = "";
        if (o != null) {
            if (o.getDetalii() != null) {
                detalii = o.getDetalii();
            }
            if (o.getIdClient() != -1) {
                int min;
                Client c = ClientLogic.getInstance().getClientById(o.getIdClient());
                if (VpConfig.getInstance().notaPrintAdresaClient) {
                    adresaClient = o.getAdresaLivrare();
                    min = Math.min(adresaClient.length(), VpConfig.getInstance().notaPrintAdresaClientMaxSize);
                    adresaClient = adresaClient.substring(0, min);
                }
                if (VpConfig.getInstance().notaPrintNumeClient) {
                    numeClient = c.toString();
                    min = Math.min(numeClient.length(), VpConfig.getInstance().notaPrintNumeClientMaxSize);
                    numeClient = numeClient.substring(0, min);
                }
                if (VpConfig.getInstance().notaPrintTelefonClient) {
                    telefonClient = c.getTelefoaneShort(", ");
                }
            }
        }
        return detalii + " " + numeClient + " " + telefonClient + " " + adresaClient + " ";
    }

    public void decrementSale(Order o, Sale s, User u, String explain, double quantityRemoved, Table t, AbstractPrinter forcedPrinter) {
        this.decrementSale(o, s, u, explain, quantityRemoved, t, forcedPrinter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementSale(Order order, Sale s, User authorizedBy, String explain, double quantityRemoved, Table t, AbstractPrinter forcedPrinter, boolean addUserLog) {
        try {
            this.deleteSale(s, authorizedBy.getId(), explain, quantityRemoved, addUserLog);
            s.setCantitateMarcata(s.getCantitateMarcata() - quantityRemoved);
            if (addUserLog) {
                this.userLogic.addUserLogNoCommit(authorizedBy.getId(), "Retur " + s.getProductName() + " " + Utils.getString3Decimals(quantityRemoved));
            }
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e1) {
            Logger.logException(this, (Exception)e1);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        try {
            User w = this.getOrdersDao().getUserByOrderId(s.getIdOrder());
            String logText = "Produs (" + w.getLogin() + ") sters:" + " " + Utils.getString2Decimals(quantityRemoved) + " * " + s.getProductName() + " = " + Utils.getString2Decimals(s.getPrice() * quantityRemoved) + " LEI" + " autorizat de " + authorizedBy.getLogin() + " la " + Formatters.currentDateAndTimeForPrinter.format(new Date());
            Map map = this.buildMapForExport(logText, new String[0]);
            GenericListenersLogic.getInstance().notifyObjectListeners(1002, map);
            if (VpConfig.getInstance().smsSendAtSaleRemoval) {
                this.sender.sendSms(logText, this.alertDestinations);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        if (VpConfig.getInstance().printReturStergere) {
            String ora = Formatters.TIME_FORMAT.format(new Date(order.getStartTime()));
            try {
                Product p = this.nomeclaturaLogic.getProductById(s.getIdProduct());
                Categorie subcat = this.getCategorieById(p.getIdCategorie());
                Sectie cat = this.nomeclaturaLogic.getSectieByCategoryId(subcat.getId());
                Bon b = this.addBonNoCommit(cat.getId(), order.getUser());
                this.pool.requestConnection().commitTransaction();
                this.pool.releaseConnection();
                Vector<PrinterBonItem> bonItems = new Vector<PrinterBonItem>();
                double price = s.getPrice();
                double t1 = -quantityRemoved * price;
                String totalBI = Utils.getString2Decimals(t1);
                String detalii = "";
                String quantityS = "";
                if (VpConfig.getInstance().livrariUseBarcodePrinter) {
                    detalii = detalii + s.getModPreparare();
                } else {
                    quantityS = Utils.getString3Decimals(-quantityRemoved) + " ";
                    if (Validators.correctString(s.getModPreparare())) {
                        detalii = detalii + " (" + s.getModPreparare() + ") ";
                    }
                }
                String line = quantityS + s.getSectieName() + " Retur";
                String realQ = Utils.getString3Decimals(-quantityRemoved);
                if (VpConfig.getInstance().livrariUseBarcodePrinter) {
                    realQ = "--";
                }
                PrinterBonItem bi = new PrinterBonItem(line, realQ, totalBI, detalii, -1, new Vector<Integer>());
                bonItems.add(bi);
                String bon = "";
                if (VpConfig.getInstance().livrariUseBarcodePrinter) {
                    bon = this.getFullNameForTableForLivrariLabel(ora, order.getId(), t.getIdLocatie()) + " " + order.getDetalii();
                } else {
                    if (VpConfig.getInstance().bonNumbering) {
                        bon = "Nr " + b.getNrBon();
                    }
                    if (VpConfig.getInstance().livrariUseNotaNumberAsBonNumber) {
                        bon = "Comanda Nr " + order.getId();
                    }
                }
                Location l = this.getLocationByIdNoCommit(t.getIdLocatie());
                String numeMasa = "";
                if (VpConfig.getInstance().bonMarcajPrintMasa) {
                    numeMasa = this.getFullNameForTable(t.getLabel(), t.getIdLocatie());
                }
                String livrare = this.getDetaliiLivrareForLabelPrinter(order);
                String waiterName = authorizedBy.getName();
                if (order.getIdClient() > 0) {
                    waiterName = livrare;
                }
                String[] detaliiClient = RestLogic.getDetaliiClientForBon(order);
                String adresaClient = detaliiClient[0];
                String numeClient = detaliiClient[1];
                String telefonClient = detaliiClient[2];
                this.printer.printBon(bonItems, waiterName, cat.getName(), numeMasa, bon, order.isProtocol(), PrinterConfig.getInstance().nrExemplareBonComanda, cat, l, totalBI, forcedPrinter, livrare, true, adresaClient, numeClient, telefonClient);
                User ospatar = UsersLogic.getInstance().getUserById(order.getUser());
                if (this.productie != null && !t.isVirtuala()) {
                    String free1 = "";
                    free1 = VpConfig.getInstance().productieUseOrderId ? this.getFullNameForTableForLivrari(order.getId(), t.getIdLocatie(), Formatters.TIME_FORMAT.format(new Date(order.getStartTime())), order.getAdresaLivrare(), telefonClient) : this.getFullNameForTable(t.getLabel(), t.getIdLocatie());
                    this.productie.addProductieNoCommit(free1, "", ospatar.getId(), cat.getId(), subcat.getId(), p.getId(), s.getIdPlatou(), -quantityRemoved, s.getPrice(), detalii, order.getId(), order.getStartTime());
                }
                if (this.newProductie != null && !t.isVirtuala()) {
                    this.newProductie.addMessageOnChannel(cat.getId(), t.getIdLocatie(), s.getProductName(), quantityRemoved, order.getId(), s.getModPreparare(), order.getStartTime(), s.getSaledate(), "");
                }
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
        }
    }

    private static String[] getDetaliiClientForBon(Order toPrint) {
        String adresaClient = "";
        String numeClient = "";
        String telefonClient = "";
        if (toPrint.getIdClient() != -1) {
            Client c = ClientLogic.getInstance().getClientById(toPrint.getIdClient());
            if (VpConfig.getInstance().notaPrintAdresaClient) {
                adresaClient = toPrint.getAdresaLivrare();
            }
            if (VpConfig.getInstance().notaPrintNumeClient) {
                numeClient = c.toString();
            }
            if (VpConfig.getInstance().notaPrintTelefonClient) {
                telefonClient = c.getTelefoane(", ");
            }
        }
        String[] result = new String[]{adresaClient, numeClient, telefonClient};
        return result;
    }

    public void addCorrectionNoCommit(User user, String what, double price, String explain, double quantity) throws SQLException {
        Correction co = new Correction(user.getId(), user.getId(), what, price, explain, quantity);
        this.getCorrectionsDao().addCorrection(co);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteComanda(int[] toDeleteIndexes, Vector<SalesEntry> data) {
        try {
            for (int index : toDeleteIndexes) {
                SalesEntry se = data.get(index);
                this.deleteComandaNoCommit(se.getIdSale());
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void deleteComandaNoCommit(int idSale) throws SQLException {
        this.getSalesDao().deleteSale(idSale);
    }

    private void deleteSale(Sale s, int authorizedBy, String explain, double quantityRemoved, boolean recordCorrection) throws SQLException {
        block5: {
            block4: {
                User w = this.getOrdersDao().getUserByOrderId(s.getIdOrder());
                if (!(quantityRemoved > 0.0)) break block4;
                if (recordCorrection) {
                    Correction co = new Correction(w.getId(), authorizedBy, s.getProductName(), s.getPrice(), explain, quantityRemoved);
                    this.getCorrectionsDao().addCorrection(co);
                }
                double toDelete = quantityRemoved;
                Vector<Integer> idSales = s.getIdSales();
                for (int i = 0; i < idSales.size() && toDelete > 0.0; ++i) {
                    Integer o = idSales.elementAt(i);
                    Sale s1 = this.getOrdersDao().getSaleById(o, s.getIdOrder(), this.pool.requestConnection().getConnection());
                    if (s1 == null) continue;
                    double canDelete = s1.getCantitateMarcata();
                    if (canDelete <= toDelete) {
                        this.getSalesDao().deleteSale(s1.getFirstIdSale());
                        toDelete -= canDelete;
                        continue;
                    }
                    this.getSalesDao().updateSale(s1.getFirstIdSale(), canDelete - toDelete, s1.getIdPromotie(), s1.getDiscount(), s1.getPrice());
                    toDelete = 0.0;
                }
                break block5;
            }
            if (!(quantityRemoved < 0.0)) break block5;
            Vector<Integer> idSales = s.getIdSales();
            for (int i = 0; i < idSales.size(); ++i) {
                Integer o = idSales.elementAt(i);
                Sale s1 = this.getOrdersDao().getSaleById(o, s.getIdOrder(), this.pool.requestConnection().getConnection());
                this.getSalesDao().deleteSale(s1.getFirstIdSale());
            }
        }
    }

    public Sale reloadSaleNoCommit(int idSale, int idOrder) throws SQLException {
        Sale result = this.getOrdersDao().getSaleById(idSale, idOrder, this.pool.requestConnection().getConnection());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<SalesEntry> getSalesReport(Hashtable criteria, int what) {
        Vector<SalesEntry> result = new Vector();
        try {
            result = this.getSalesReportNoCommit(criteria, what);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector<SalesEntry> getSalesReportNoCommit(Hashtable criteria, int what) throws SQLException {
        Vector<SalesEntry> result = this.getSalesReportNoGroupNoCommit(criteria, what);
        String g = (String)criteria.get(Constants.GRUPARE_KEY);
        if (g != null && g.equalsIgnoreCase("Dupa comanda")) {
            Vector<Integer> ids = new Vector<Integer>();
            for (SalesEntry salesEntry : result) {
                Integer id = Integer.parseInt(salesEntry.getDataOra());
                ids.add(id);
            }
            Hashtable<Integer, Integer> mappings = this.getDao().getInfoClienti(ids);
            for (SalesEntry salesEntry : result) {
                Client c;
                Integer idOrder = Integer.parseInt(salesEntry.getDataOra());
                Integer idClient = mappings.get(idOrder);
                if (idClient == null || (c = ClientLogic.getInstance().getClientFromHash(idClient)) == null) continue;
                String telefoane = c.getTelefoane(",");
                String adresa = c.getAddressAsString(';');
                String nume = c.toString();
                salesEntry.setDataOra(salesEntry.getDataOra() + ": " + nume + " | " + telefoane + " | " + adresa);
            }
        }
        return result;
    }

    public Vector<SalesEntry> getSalesReportNoGroupNoCommit(Hashtable criteria, int what) throws SQLException {
        return this.getDao().getSalesReport2(criteria, what, VpConfig.getInstance().multipleUsersPerOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getIncasariReport(Hashtable criteria, int what) {
        try {
            Vector result;
            Vector vector = result = this.getDao().getIncasariReport2(criteria, what);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public int[] newRetetaProductNoCommit(int subcategoryId, String name, double price, Vector recipeItems, int cod, String casaName, String sectieName, String free1, String free2, String modPreparare, boolean uzIntern, boolean productie, boolean exportCantar, Vector productsAttributes, String pictureFile, String codSync, Vector<String> barcodes) throws SQLException {
        int[] result = new int[2];
        int idProdus = this.nomeclaturaLogic.addProductNoCommit(name, casaName, sectieName, free1, free2, cod, subcategoryId, uzIntern, exportCantar, pictureFile, codSync, barcodes);
        this.getProductsDao().addProdusReteta(idProdus, price, modPreparare, productie);
        int idProdusReteta = this.pool.requestConnection().getIndentityLocal();
        this.addItemsToRetetaProductNoCommit(idProdusReteta, recipeItems);
        result[0] = idProdus;
        result[1] = idProdusReteta;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int newRetetaProduct(int subcategoryId, String name, double price, Vector recipeItems, int cod, String casaName, String sectieName, String free1, String free2, String modPreparare, boolean uzIntern, boolean productie, boolean exportCantar, Vector productsAttributes, String pictureFile, String codSync, Vector<String> barcodes) {
        try {
            int idProdus = this.newRetetaProductNoCommit(subcategoryId, name, price, recipeItems, cod, casaName, sectieName, free1, free2, modPreparare, uzIntern, productie, exportCantar, productsAttributes, pictureFile, codSync, barcodes)[0];
            this.nomeclaturaLogic.addProductAttributes(idProdus, productsAttributes);
            NomeclaturaLogic.getInstance().deleteAllBarcodesFromProduct(idProdus);
            for (String barcode : barcodes) {
                NomeclaturaLogic.getInstance().addBarcodeToProductNoCommit(idProdus, barcode);
            }
            this.pool.commit();
            this.nomeclaturaLogic.updatePowerSearchProducts(idProdus, barcodes);
            Product rp = this.nomeclaturaLogic.getProductById(idProdus);
            this.notifyObjectListeners(101, rp);
            this.nomeclaturaLogic.productAdded(idProdus, price);
            this.nomeclaturaLogic.notifyListeners(2);
            this.modifiedRetetaProduct();
            int n = idProdus;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void modifiedRetetaProduct() {
        this.notifyListeners(2);
    }

    public void addItemsToRetetaProductNoCommit(int idRetetaProduct, Vector recipeItems) throws SQLException {
        for (NewRecipeEntry element : recipeItems) {
            this.getProductsDao().addRecipeItem(idRetetaProduct, element.getIdStock(), element.getIdProduct(), element.getQuantity());
            int idRecipe = this.pool.requestConnection().getIndentityLocal();
            element.setId(idRecipe);
        }
    }

    public Sale buildSaleNoCommit(Product p, double cantitateMarcata, double cantitateNoua, String modPreparare, int idOrder, int idPlatou, int idPromotie, int idSale, int idServire, long saledate, double price, String numeSectiePrefix, int clientIndex) throws SQLException {
        return this.buildSaleNoCommit(p, cantitateMarcata, cantitateNoua, modPreparare, idOrder, idPlatou, idPromotie, idSale, idServire, saledate, price, numeSectiePrefix, clientIndex, false);
    }

    public Sale buildSaleNoCommit(Product p, double cantitateMarcata, double cantitateNoua, String modPreparare, int idOrder, int idPlatou, int idPromotie, int idSale, int idServire, long saledate, double price, String numeSectiePrefix, int clientIndex, boolean ignorePromotion) throws SQLException {
        String promotie = null;
        Categorie c = this.nomeclaturaLogic.getCategoryByIdNoCommit(p.getIdCategorie());
        Sectie s = this.nomeclaturaLogic.getSectieByIdNoCommit(c.getSectie());
        double priceOriginal = price;
        double discount = 0.0;
        if (modPreparare == null) {
            modPreparare = "";
        }
        Sale toAdd = new Sale(cantitateMarcata, cantitateNoua, discount, c.getId(), idOrder, idPlatou, p.getId(), ignorePromotion ? -1 : idPromotie, s.getId(), idServire, modPreparare, priceOriginal, price, p.getName(), numeSectiePrefix + p.getNumeSectie(), promotie, saledate, clientIndex, ignorePromotion);
        if (idSale > 0) {
            toAdd.addIdSale(idSale);
        }
        return toAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sale buildSale(Product p, double cantitateMarcata, double cantitateNoua, String modPreparare, int idOrder, int idPlatou, int idPromotie, int idSale, int idServire, long saledate, double price, String numeSectiePrefix, int clientIndex) {
        try {
            Sale s = this.buildSaleNoCommit(p, cantitateMarcata, cantitateNoua, modPreparare, idOrder, idPlatou, idPromotie, idSale, idServire, saledate, price, "", clientIndex);
            this.pool.commit();
            Sale sale = s;
            return sale;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Sale sale = null;
            return sale;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sale buildSale(Product p, double cantitateMarcata, double cantitateNoua, String modPreparare, int idOrder, int idPlatou, int idPromotie, int idSale, int idServire, long saledate, double price, String numeSectiePrefix, int clientIndex, boolean ignorePromotion) {
        try {
            Sale s = this.buildSaleNoCommit(p, cantitateMarcata, cantitateNoua, modPreparare, idOrder, idPlatou, idPromotie, idSale, idServire, saledate, price, "", clientIndex, ignorePromotion);
            this.pool.commit();
            Sale sale = s;
            return sale;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Sale sale = null;
            return sale;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Sale buildSaleNoCommit(Product p, double cantitateMarcata, double cantitateNoua, String modPreparare, int idOrder, int idPlatou, int idPromotie, int idSale, int idServire, long saledate, int clientIndex) throws SQLException {
        double price = this.getPriceForProductNoCommit(p.getId());
        return this.buildSaleNoCommit(p, cantitateMarcata, cantitateNoua, modPreparare, idOrder, idPlatou, idPromotie, idSale, idServire, saledate, price, "", clientIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sale buildSale(Product p, double cantitateMarcata, double cantitateNoua, String modPreparare, int idOrder, int idPlatou, int idPromotie, int idSale, int idServire, long saledate, int clientIndex) {
        try {
            Sale sale = this.buildSaleNoCommit(p, cantitateMarcata, cantitateNoua, modPreparare, idOrder, idPlatou, idPromotie, idSale, idServire, saledate, clientIndex);
            return sale;
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Sale sale = null;
            return sale;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public boolean notaByBonFiscal(BonFiscal bf, int idUser, int idTable, boolean protocol, boolean codBare, boolean codBareDeleteLeadingZeros) throws SQLException {
        Order order = this.newOrderNoCommit(idTable, idUser, protocol);
        order.setFiscal(true);
        this.getOrdersDao().setFiscal(order);
        boolean result = true;
        for (BonFiscalItem bfi : bf.getItems()) {
            Product rp = null;
            String codEcr = "";
            if (codBare) {
                String codFaraZerouri = bfi.getCodBare();
                codFaraZerouri = codFaraZerouri.trim();
                if (codBareDeleteLeadingZeros) {
                    codFaraZerouri = TextUtils.trimChar(codFaraZerouri, '0');
                }
                rp = this.nomeclaturaLogic.getProductByCodBareNoCommit(codFaraZerouri);
                codEcr = codEcr + codFaraZerouri;
            } else {
                rp = this.nomeclaturaLogic.getProductByCodNoCommit(bfi.getCod());
                codEcr = codEcr + bfi.getCod();
            }
            if (rp != null) {
                long now = bf.getDataBon();
                String modPreparare = null;
                Sale tm = this.buildSaleNoCommit(rp, 0.0, bfi.getQuantity(), modPreparare, order.getId(), bfi.getIdPlatou(), -1, -1, -1, now, 0);
                this.addSaleNoCommit(tm, order.getUser());
                continue;
            }
            result = false;
            Logger.logException(this, new Exception("Nu am gasit produsul cu codul : " + codEcr));
        }
        if (result) {
            Vector plati = bf.getPlati();
            for (int i = 0; i < plati.size(); ++i) {
                BonFiscalPlata bfp = (BonFiscalPlata)plati.elementAt(i);
                Plata plata = new Plata(bfp.getTipPlata(), bfp.getSuma(), "", "", "", 0);
                PaymentLogic.getInstance().addSimplePlataToOrderNoCommit(order, plata);
            }
            this.closeOrderNoCommit(order, new Timestamp(bf.getDataBon()));
        } else {
            System.out.println("Ignoram nota");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotal(int idOrder, int clientIndex) {
        double total = 0.0;
        try {
            Vector<Sale> sales = this.getOrdersDao().getSales(idOrder, true, -1, clientIndex, this.pool.requestConnection().getConnection(), new ScreenSaleInterface());
            total = RestLogic.computeTotalForSales(sales);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return total;
    }

    public double getTotal(Order o, int clientIndex) {
        if (o != null) {
            return this.getTotal(o.getId(), clientIndex);
        }
        return 0.0;
    }

    public double getTotal(Order o) {
        return this.getTotal(o, -1);
    }

    public boolean isTotalCovered(Order o) {
        double diff = this.getTotalDiff(o);
        return diff >= 0.0;
    }

    public boolean isTotalOrderEqualWithTotalPlati(Order o) {
        double abs = Math.abs(this.getTotalDiff(o));
        return abs < 1.0E-4;
    }

    public double getTotalDiff(Order o) {
        if (o == null) {
            return 0.0;
        }
        double totalOrder = this.getTotal(o);
        double totalPlati = this.getTotalPlati(o.getId());
        return totalPlati - totalOrder;
    }

    public double getTotalPlati(int idOrder) {
        Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(idOrder);
        return PaymentLogic.getPlatiInVector(plati);
    }

    public boolean needPlatiCheckingAtNota(Order order) {
        return this.needPlatiChecki(order, VpConfig.getInstance().touch2RequestTipPlataBeforeNota);
    }

    public boolean needPlatiCheckingAtIncasat(Order order) {
        return this.needPlatiChecki(order, VpConfig.getInstance().touch2RequestTipPlataBeforeIncasat);
    }

    public boolean needPlatiChecki(Order order, boolean requested) {
        if (requested) {
            return true;
        }
        if (order != null) {
            Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(order.getId());
            for (Plata plata : plati) {
                int idTipPlata = plata.getIdTipPlata();
                TipPlata tipPlata2 = TipPlataProvider.getInstance().getTipPlataById(idTipPlata);
                if (!tipPlata2.isDocumentDePlata()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<NewRecipeEntry> getRecipesForProdusReteta(int idProdusReteta, int idLanguage) {
        try {
            Vector<NewRecipeEntry> result;
            Vector<NewRecipeEntry> vector = result = this.getRecipesForProdusRetetaNoCommit(idProdusReteta, idLanguage);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<NewRecipeEntry> vector = new Vector<NewRecipeEntry>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private Vector<NewRecipeEntry> getRecipesForProdusRetetaNoCommit(int idProdusReteta, int idLanguage) throws SQLException {
        return this.getProductsDao().getRetetarViewEntries(idProdusReteta, idLanguage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdReteta(int idProduct) {
        try {
            int result;
            int n = result = this.getIdRetetaNoCommit(idProduct);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public int getIdRetetaNoCommit(int idProduct) throws SQLException {
        Object idReteta = this.reteteByProductHash.get(idProduct);
        if (idReteta != null) {
            return (Integer)idReteta;
        }
        int idReteta2 = this.getIdRetetaFromDbNoCommit(idProduct);
        this.reteteByProductHash.put(idProduct, idReteta2);
        return idReteta2;
    }

    public int getIdRetetaFromDbNoCommit(int idProduct) throws SQLException {
        int idReteta2 = this.getProductsDao().getIdRetetaForProduct(idProduct);
        return idReteta2;
    }

    public boolean isReteta(int idProduct) {
        return this.getIdReteta(idProduct) > 0;
    }

    public boolean isRetetaNoCommit(int idProduct) throws SQLException {
        return this.getIdRetetaNoCommit(idProduct) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModPreparareForReteta(int idReteta) {
        try {
            String result;
            String string = result = this.getModPreparareForRetetaNoCommit(idReteta);
            return string;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            String string = "";
            return string;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public String getModPreparareForRetetaNoCommit(int idReteta) throws SQLException {
        return this.getProductsDao().getModPreparare(idReteta);
    }

    public void setModPreparareForReteta(int idReteta, String mp) {
        try {
            this.getProductsDao().setModPreparare(idReteta, mp);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProductieForReteta(int idReteta, boolean productie) {
        try {
            this.getProductsDao().setProductieForReteta(productie, idReteta);
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProductie(int idProduct) {
        try {
            boolean result;
            boolean bl = result = this.getProductsDao().isProductie(idProduct);
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public int getIdStockNoCommit(int idProduct) throws SQLException {
        Object stockId = this.stocksByProductHash.get(idProduct);
        if (stockId != null && (Integer)stockId != -1) {
            return (Integer)stockId;
        }
        int idStock = this.getIdStockForProductFromDB(idProduct);
        this.stocksByProductHash.put(idProduct, idStock);
        return idStock;
    }

    public int getIdStockForProductFromDB(int idProduct) throws SQLException {
        return this.getProductsDao().getIdStockForProduct(idProduct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIdStock(int idProduct) {
        try {
            int result;
            int n = result = this.getIdStockNoCommit(idProduct);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    @Override
    public int getIdStockForProductNoCommit(int idProduct) throws SQLException {
        int result = this.getIdStockNoCommit(idProduct);
        return result;
    }

    public String getStringDisponibilForMagazieAndStock(int idProduct, int idMagazie) {
        Hashtable<Integer, String> one = this.getStringDisponibilForMagazieAndStock(idProduct, idMagazie, false);
        return new Vector<String>(one.values()).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable<Integer, String> getStringDisponibilForMagazieAndStock(int idProduct, int idMagazie, boolean groupByMagazie) {
        Hashtable<Integer, String> result = new Hashtable<Integer, String>();
        try {
            int idStock = this.stockLogic.getIdStockForProductIdNoCommit(idProduct);
            Double disponibil = this.stockLogic.getDisponibilMagazieForStock(idStock, StockLogic.COMANDA_TYPE.EFECTUAT);
            Double blocat = 0.0;
            if (VpConfig.getInstance().futureStocksEnabledFacturiEmise) {
                blocat = this.stockLogic.getDisponibilMagazieForStock(idStock, StockLogic.COMANDA_TYPE.COMANDA_FERMA);
                if (blocat == null) {
                    blocat = 0.0;
                }
                blocat = Math.abs(blocat);
            }
            Double total = disponibil + blocat;
            String dibloto = total + " / " + disponibil + " / " + blocat;
            result.put(idMagazie, dibloto);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector<Product> getAllRetetaProducts(boolean productieOnly) {
        Vector<Product> result = new Vector<Product>();
        Vector<Product> allProducts = this.nomeclaturaLogic.getAllProducts(-1);
        for (int i = 0; i < allProducts.size(); ++i) {
            Product o = allProducts.elementAt(i);
            if (productieOnly && !this.isProductie(o.getId())) continue;
            result.add(o);
        }
        return result;
    }

    public Sectie getSectieByCategorieId(Integer subcategoryId) {
        return this.nomeclaturaLogic.getSectieByCategoryId(subcategoryId);
    }

    public void addIngredientToProductNoCommit(int idParent, int idStock, int idProduct, double quantity, String ingredient, String productName) throws SQLException {
        this.getProductsDao().addRecipeItem(idParent, idStock, idProduct, quantity);
        UsersLogic.getInstance().addBOUserLogNoCommit("Adaugare ingredient " + ingredient + " cantitate " + Utils.getString6Decimals(quantity) + " la produsul " + productName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIngredientToProduct(int idParent, int idStock, int idProduct, double quantity, String ingredient, String productName) {
        try {
            this.addIngredientToProductNoCommit(idParent, idStock, idProduct, quantity, ingredient, productName);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void addRecipeItemNoCommit(int idParent, int idStock, int idProduct, double quantity) throws SQLException {
        this.getProductsDao().addRecipeItem(idParent, idStock, idProduct, quantity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIngredientFromProduct(String productName, int recipeItem, String ingredient, double quantity) {
        try {
            this.getProductsDao().deleteRecipeItem(recipeItem);
            UsersLogic.getInstance().addBOUserLogNoCommit("Stergere ingredient " + ingredient + " cantitate " + Utils.getString6Decimals(quantity) + " din produsul " + productName);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProduct(Product p) {
        try {
            this.nomeclaturaLogic.deleteProductNoCommit(p);
            this.pool.requestConnection().commitTransaction();
            this.nomeclaturaLogic.productDeleted(p.getId());
            this.nomeclaturaLogic.notifyListeners(2);
            this.modifiedRetetaProduct();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Vector getSectii() {
        return this.nomeclaturaLogic.getAllSectii();
    }

    public Vector getSectiiInSet(Vector sectiiName) {
        Vector<Sectie> result = new Vector<Sectie>();
        Vector<Sectie> all = this.nomeclaturaLogic.getAllSectii();
        for (int i = 0; i < all.size(); ++i) {
            Sectie o = all.elementAt(i);
            if (!sectiiName.contains(o.getName())) continue;
            result.add(o);
        }
        return result;
    }

    public Sectie getSectieById(Integer id) {
        return this.nomeclaturaLogic.getSectieById(id);
    }

    public Table getFirstFreeTableNoCommit(Vector<Location> locations) throws SQLException {
        Table t = null;
        if (locations.size() > 0) {
            for (int i = 0; i < locations.size(); ++i) {
                Location location = locations.elementAt(i);
                Table t1 = this.getTablesDao().getFirstFreeTable(location.getId());
                if (t1 == null) continue;
                t = t1;
                break;
            }
        } else {
            t = this.getTablesDao().getFirstFreeTable(-1);
        }
        if (t == null) {
            Location loc;
            int idlocatie = 1;
            if (locations.size() > 0) {
                loc = this.getLocationsDao().getLocationByName(locations.get(0).getName());
                idlocatie = loc.getId();
            } else {
                loc = this.getLocationsDao().getLocationByName(VpConfig.getInstance().tableGeneratorNumeLocatie);
                if (loc != null) {
                    idlocatie = loc.getId();
                }
            }
            t = this.newTable("comanda", 1, false, "", idlocatie);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getFirstFreeTable(Vector locations) {
        Table t = null;
        try {
            t = this.getFirstFreeTableNoCommit(locations);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Table table = null;
            return table;
        }
        finally {
            this.pool.releaseConnection();
        }
        return t;
    }

    public Vector getCamereSortedByName() {
        Vector tables = this.getCamere();
        Collections.sort(tables, new Comparator(){

            public int compare(Object o1, Object o2) {
                Table t1 = (Table)o1;
                Table t2 = (Table)o2;
                return t1.getLabel().compareToIgnoreCase(t2.getLabel());
            }
        });
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Table> getTables() {
        try {
            Vector<Table> result;
            Vector<Table> vector = result = this.getTablesDao().getTables(1);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Table> vector = new Vector<Table>();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCamere() {
        try {
            Vector<Table> result;
            Vector<Table> vector = result = this.getTablesDao().getTables(2);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Table getTableByIdNoCommit(Integer tableId) throws SQLException {
        Table result = this.getTablesDao().getTableById(tableId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTableById(Integer tableId) {
        try {
            Table result = this.getTableByIdNoCommit(tableId);
            this.pool.commit();
            Table table = result;
            return table;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Table table = null;
            return table;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public EventsLogic getEventsLogic() {
        return this.eventsLogic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTable(String newName, int locuri, boolean virtuala, String fullDetails, int id) {
        try {
            this.getTablesDao().updateTable(newName, locuri, virtuala, fullDetails, id);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table newTable(String name, int locuri, boolean virtuala, String fullDetails, int idLocatie) {
        try {
            Table t = new Table(new Integer(-1), name, idLocatie, locuri, virtuala, fullDetails);
            this.getTablesDao().addTable(t);
            int id = this.pool.getIdentityLocal();
            this.pool.requestConnection().commitTransaction();
            t.setId(id);
            Table table = t;
            return table;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Table table = null;
            return table;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTable(Table toDelete) {
        try {
            this.getTablesDao().deleteTable(toDelete);
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Vector<Table> getTablesByLocationSortedByName(int idLocation) {
        Vector<Table> tables = this.getTablesByLocation(idLocation);
        Collections.sort(tables, new Comparator(){

            public int compare(Object o1, Object o2) {
                Table t1 = (Table)o1;
                Table t2 = (Table)o2;
                return t1.getLabel().compareToIgnoreCase(t2.getLabel());
            }
        });
        return tables;
    }

    public void updateQuickTableNames(Vector tables) {
        for (Object o : tables) {
            Table t = (Table)o;
            Order order = this.getOpenOrderAtTable(t);
            if (order != null) {
                String detalii = order.getDetalii();
                if (!Validators.correctString(detalii)) continue;
                t.setLabel(detalii);
                continue;
            }
            Table t1 = this.getTableById(t.getId());
            t.setLabel(t1.getLabel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Table> getTablesByLocation(int idLocation) {
        Vector<Table> result = new Vector();
        try {
            result = this.getTablesByLocationNoCommit(idLocation);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector<Table> getTablesByLocationNoCommit(int idLocation) throws SQLException {
        Vector<Table> result = this.getTablesDao().selectTablesByIdLocation(idLocation);
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                return CompareUtils.compareTables(o1, o2);
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTableByLocatieAndName(int idLocatie, String name) {
        Table result = null;
        try {
            result = this.getTablesDao().selectTableByLocatieAndName(idLocatie, name);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Order newOrder(int idTable, int idUser) {
        try {
            Order o = this.newOrderNoCommit(idTable, idUser, false);
            this.pool.commit();
            Order order = o;
            return order;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Order order = null;
            return order;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Order newOrderNoCommit(int idTable, int idUser, boolean protocol) throws SQLException {
        Order o = new Order(new Integer(-1), idTable, idUser);
        o.setProtocol(protocol);
        o.setStatus(1);
        this.getOrdersDao().addOrder(o);
        int id = this.pool.requestConnection().getIndentityLocal();
        o.setId(id);
        o.setStartTime(System.currentTimeMillis());
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetalii(Order o) {
        try {
            this.getOrdersDao().setDetaliiForOrder(o.getId(), o.getDetalii());
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBarcodeForOrder(Order o) {
        try {
            this.getOrdersDao().setBarcodeForOrder(o.getId(), o.getBarcode());
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrderIdentifierForOrder(int idOrder, String identifier) {
        try {
            this.setOrderIdentifierNoCommit(idOrder, identifier);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void setOrderIdentifierNoCommit(int idOrder, String identifier) throws SQLException {
        this.getOrdersDao().setExternalIdForOrder(identifier, idOrder);
    }

    public void laPlataOrder(Order o, Table t, AbstractPrinter forcedPrinter) {
        this.laPlataOrder(o, t, VpConfig.getInstance().remizaAutomata, forcedPrinter, false, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculeazaOrder(Order o) {
        if (o == null) {
            return;
        }
        try {
            this.recomputePricesNoCommit(o);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void laPlataOrder(Order o, Table t, AbstractPrinter forcedPrinter, boolean groupByClientIndex, int clientiIndex) {
        this.laPlataOrder(o, t, VpConfig.getInstance().remizaAutomata, forcedPrinter, groupByClientIndex, clientiIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void laPlataOrder(Order o, Table t, boolean remizaAutomat, AbstractPrinter forcedPrinter, boolean groupByClientIndex, int clientiIndex) {
        try {
            this.laPlataOrderNoCommit(o, t, remizaAutomat, forcedPrinter, groupByClientIndex, clientiIndex);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.requestConnection().rollback();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void laPlataOrderNoCommit(Order o, Table t, boolean remizaAutomat, AbstractPrinter forcedPrinter, boolean groupByClientIndex, int clientiIndex) throws SQLException {
        boolean notaKeepProductsAsOnScreen = VpConfig.getInstance().notaPrintProductsAsOnScreen;
        this.getOrdersDao().laPlata(o);
        if (remizaAutomat && !o.isLaPlata() && !o.isProtocol()) {
            double totalTips = this.computeTipsForOrder(o);
            this.setTipsToOrder1(o, totalTips, forcedPrinter);
        }
        this.recomputePricesNoCommit(o);
        boolean printNota = true;
        if (!VpConfig.getInstance().printNotaIfBonFiscal) {
            Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrderNoCommit(o.getId());
            if (!plati.isEmpty()) {
                for (Plata plata : plati) {
                    if (!Validators.correctString(plata.getEcrMapping())) continue;
                    printNota = false;
                    break;
                }
            } else {
                TipPlata defaultTipPlata = TipPlataProvider.getInstance().getDefaultTipPlataNoCommit();
                if (defaultTipPlata != null && Validators.correctString(defaultTipPlata.getEcrMapping())) {
                    printNota = false;
                }
            }
        }
        if (printNota) {
            if (!notaKeepProductsAsOnScreen) {
                this.printNota(o, t, forcedPrinter, groupByClientIndex, clientiIndex);
            } else {
                this.printNota(o, t, forcedPrinter, new ScreenSaleInterface(), groupByClientIndex, clientiIndex);
            }
        }
        o.setStatus(5);
        this.userLogic.addUserLogNoCommit(o.getUser(), "Nota " + o.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notaProforma(Order o, Table t, AbstractPrinter forcedPrinter) {
        try {
            this.recomputePricesNoCommit(o);
            this.printNota(o, t, forcedPrinter, false, -1);
            this.userLogic.addUserLogNoCommit(o.getUser(), "Proforma " + o.getId());
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notaIntermediara(Order o, Table t, AbstractPrinter forcedPrinter) {
        try {
            this.recomputePricesNoCommit(o);
            this.printNotaIntermediara(o, t, forcedPrinter, false, -1);
            this.userLogic.addUserLogNoCommit(o.getUser(), "Intermediara " + o.getId());
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notaIntermediaraForTipPlata(Order o, Table t, AbstractPrinter forcedPrinter, Vector<Sale> allSales) {
        Hashtable<Integer, Vector<Sale>> hashToPrint = new Hashtable<Integer, Vector<Sale>>();
        hashToPrint.put(-1, allSales);
        this.printNotaInternallyHash(o, t, forcedPrinter, false, hashToPrint);
        if (allSales.size() == 0) {
            return;
        }
        try {
            for (int i = 0; i < allSales.size(); ++i) {
                Sale sale = allSales.elementAt(i);
                for (Integer idSale : sale.getIdSales()) {
                    this.getSalesDao().setSalePrinted(idSale);
                }
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getReprintableOrders() {
        try {
            Vector result;
            Connection conn = this.pool.requestConnection().getConnection();
            Timestamp t = CommonsDao.getServerTimestamp(conn);
            t = new Timestamp(t.getTime() - (long)(VpConfig.getInstance().ordersReprintableMinutes * 60 * 1000));
            Vector vector = result = this.getOrdersDao().getRecentOrders(t);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reprintNota(int idOrder, int idTable, AbstractPrinter forcedPrinter) {
        try {
            Order o = this.getOrdersDao().getOrderById(idOrder);
            Table t = this.getTablesDao().getTableById(idTable);
            this.userLogic.addUserLogNoCommit(o.getUser(), "Retiparire nota " + o.getId());
            this.pool.commit();
            this.reprintNota(o, t, forcedPrinter);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void reprintNota(Order o, Table t, AbstractPrinter forcedPrinter) {
        this.printNota(o, t, forcedPrinter, false, -1);
    }

    public void closeOrderFastNoCommit(Order o, Timestamp forcedClosedate) throws SQLException {
        String barcode = this.getNewBarcodeProductNoCommit();
        this.getOrdersDao().closeOrder(o, barcode);
        Timestamp closedate = this.getTimeDocument(3, forcedClosedate);
        this.getOrdersDao().updateCloseTimeForOrder(o.getId(), closedate);
    }

    public void closeOrderNoCommit(Order o, Timestamp forcedClosedate) throws SQLException {
        Vector<Sale> sales = this.getOrdersDao().getSales(o.getId(), true, -1, -1, this.pool.requestConnection().getConnection(), new ScreenSaleInterface());
        if (sales.size() == 0) {
            PaymentLogic.getInstance().deleteAllPlatiForOrderAndClientIndexNoCommit(o.getId(), -1);
            this.getOrdersDao().deleteOrder(o.getId());
        } else {
            int i;
            String barcode = this.getNewBarcodeProductNoCommit();
            this.getOrdersDao().closeOrder(o, barcode);
            o.setStatus(4);
            Timestamp closedate = this.getOrdersDao().getCloseTimeForOrder(o.getId());
            if (forcedClosedate != null) {
                closedate = forcedClosedate;
            }
            closedate = this.getTimeDocument(3, closedate);
            o.setStopTime(closedate.getTime());
            this.getOrdersDao().updateCloseTimeForOrder(o.getId(), closedate);
            String doc = "Nota " + o.getId();
            boolean f = true;
            if (VpConfig.getInstance().piratMode) {
                f = o.isFiscal();
            }
            this.orderAdded(o.getId(), closedate, doc, f);
            Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrderNoCommit(o.getId());
            int idTable = o.getTable();
            Table t = this.getTableByIdNoCommit(idTable);
            Location l = this.getLocationByIdNoCommit(t.getIdLocatie());
            if (o.getIdClient() != -1 && VpConfig.getInstance().addTranzactieClientAtCloseOrder) {
                for (i = 0; i < plati.size(); ++i) {
                    Plata o1 = plati.elementAt(i);
                    int idTip = o1.getIdTipPlata();
                    TipPlata tp = TipPlataProvider.getInstance().getTipPlataByIdNoCommit(idTip);
                    int idTipCont = tp.getIdTipCont();
                    if (idTipCont <= 0) continue;
                    String detalii = doc;
                    if (VpConfig.getInstance().contClientLocationOnDetalii) {
                        detalii = detalii + " (" + l.getName() + ")";
                    }
                    ClientLogic.getInstance().adaugaTranzactieNoCommit(idTipCont, o.getIdClient(), -o1.getSuma(), detalii);
                }
            }
            if (VpConfig.getInstance().registruCasaAdaugaIncasareLaInchidereNota) {
                for (i = 0; i < plati.size(); ++i) {
                    Plata plata = plati.elementAt(i);
                    ContaLogic.getInstance().adaugaIncasareBonFiscalNoCommit(plata, t.getIdLocatie(), o.getId(), closedate, l.getName());
                }
            }
            if (l.getTip() == 2) {
                this.setCameraMurdareNoCommit(idTable, true);
                RezervariLogic.getInstance().checkout(o.getId());
            }
            this.notifyObjectListeners(104, o);
            this.userLogic.addUserLogNoCommit(o.getUser(), "Incasat " + o.getId());
        }
        restOnCurrentOrderForAfisaj = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOrder(Order o) {
        try {
            this.closeOrderNoCommit(o, null);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void setCashRegister(AbstractCashRegister cashRegister) {
        this.cashRegister = cashRegister;
        this.cashRegister.setInter(this);
        cashRegister.addListener(PaymentLogic.getInstance());
        if (cashRegister.ecrConnectedAtStartup()) {
            EcrLogic.getInstance().ecrConnected(true);
        }
    }

    public Categorie getCategorieById(int id) {
        return this.nomeclaturaLogic.getCategoryById(id);
    }

    private EcrSale createEcrSale(int idProduct, double price, double cantMarcata, double pretOriginal, double discount) {
        Product p = this.nomeclaturaLogic.getProductById(idProduct);
        int cod = p.getCod();
        String product = p.getNumeCasa();
        if (!Validators.correctString(product)) {
            product = p.getName();
        }
        Categorie subcat = this.getCategorieById(p.getIdCategorie());
        Sectie sectie = this.nomeclaturaLogic.getSectieById(subcat.getSectie());
        int subcategory = subcat.getId();
        String codDepartament = subcat.getCodDepartament();
        if (Utils.isValueGreaterThanZero(price) || Utils.isValueZero(price) && !VpConfig.getInstance().bonFiscalIgnoreProduseCuPretZero && !VpConfig.getInstance().bonFiscalPrintProduseCuZeroAsComments) {
            Tva t = TvaLogic.getInstance().getTvaById(subcat.getIdTva());
            String codCasa = t.getCodCasa();
            double cota = t.getCota();
            String newCodCasa = Config.getInstance().getString("tva_" + cota, codCasa);
            Logger.logDebug(this, "Using " + newCodCasa + " for cota tva : " + cota);
            EcrSale ecrSale = new EcrSale(product, cantMarcata, price, pretOriginal, discount, cod, codDepartament, subcategory, newCodCasa, cota, sectie.getName());
            return ecrSale;
        }
        return null;
    }

    private String createCommentForZeroPriceProduct(int idProduct, double price) {
        String prefix;
        if (price != 0.0) {
            return null;
        }
        Product p = this.nomeclaturaLogic.getProductById(idProduct);
        int cod = p.getCod();
        String product = p.getNumeCasa();
        if (!Validators.correctString(product)) {
            product = p.getName();
        }
        if (Validators.correctString(prefix = VpConfig.getInstance().bonFiscalPrintProduseCuZeroPrefix)) {
            prefix = prefix + " ";
        }
        product = prefix + product;
        return product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cashRegisterLikesPlati(Order o) {
        try {
            boolean bl = this.cashRegisterLikesPlatiNoCommit(o);
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            this.pool.releaseConnection();
        }
    }

    public boolean cashRegisterLikesPlatiNoCommit(Order o) throws SQLException {
        Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrderNoCommit(o.getId());
        return plati == null || plati.size() <= 1 || this.cashRegister.multiplePaymentTypesSupported() && this.secondaryCashRegister.multiplePaymentTypesSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBonFiscalSeparat(Order o, boolean f) {
        try {
            this.printBonFiscalSeparatNoCommit(o, f);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public synchronized void printBonFiscalSeparatNoCommit(Order o, boolean f) throws SQLException {
        Vector<Integer> clientIndex = this.getOrdersDao().getClientIndexesForOrder(o.getId());
        Logger.logDebug(this, "PrintBonFiscalSeparat order : " + o.getId() + " Indexes : " + clientIndex);
        for (Integer index : clientIndex) {
            this.printBonFiscalInternal(o, f, index);
        }
    }

    @Deprecated
    private void printBonFiscalInternal(Order o, boolean f, int clientIndex) {
        Vector<Sale> allSales = this.getSalesForBf(o, clientIndex);
        this.printBonFiscal(o, f, clientIndex, allSales);
    }

    private void printBonFiscal(final Order o, final boolean f, final int clientIndex, Vector<Sale> allSales) {
        if (f || this.secondaryCashRegister.isForceF()) {
            if (this.secondaryCashRegister.isForceF()) {
                Vector<Plata> allPlati = PaymentLogic.getInstance().getPlatiForOrder(o.getId(), clientIndex);
                final Vector<Sale> primarySales = new Vector<Sale>();
                final Vector<Sale> secondarySales = new Vector<Sale>();
                final Vector<Plata> primaryPlati = new Vector<Plata>();
                final Vector<Plata> secondaryPlati = new Vector<Plata>();
                double totalPrimary = 0.0;
                double totalSecondary = 0.0;
                double totalGeneral = 0.0;
                for (Sale sale : allSales) {
                    int idSectie = sale.getIdSectie();
                    if (this.secondaryCashRegisterSectiiIds.contains(idSectie)) {
                        String mess = "Adaug vanzarea la casa secundara : " + sale.getProductName();
                        System.out.println(mess);
                        Logger.logDebug(this, mess);
                        secondarySales.add(sale);
                        totalSecondary += sale.getTotal();
                    } else {
                        primarySales.add(sale);
                        totalPrimary += sale.getTotal();
                    }
                    totalGeneral += sale.getTotal();
                }
                int decimals = 3;
                for (Plata plata : allPlati) {
                    double totalSec = plata.getSuma() * totalSecondary / totalGeneral;
                    double totalPrim = plata.getSuma() * totalPrimary / totalGeneral;
                    Plata p1 = new Plata(plata.getIdTipPlata(), FloatUtils.roundFloat(totalPrim, 2), plata.getEcrMapping(), plata.getTipPlata(), plata.getComment(), plata.getClientIndex());
                    primaryPlati.add(p1);
                    Plata p2 = new Plata(plata.getIdTipPlata(), FloatUtils.roundFloat(totalSec, 2), plata.getEcrMapping(), plata.getTipPlata(), plata.getComment(), plata.getClientIndex());
                    secondaryPlati.add(p2);
                }
                new Thread(){

                    @Override
                    public void run() {
                        RestLogic.this.printBonFiscal(o, f, RestLogic.this.cashRegister, null, true, primarySales, primaryPlati, clientIndex);
                    }
                }.start();
                new Thread(){

                    @Override
                    public void run() {
                        RestLogic.this.printBonFiscal(o, f, RestLogic.this.secondaryCashRegister, null, true, secondarySales, secondaryPlati, clientIndex);
                    }
                }.start();
            } else {
                CashRegisterInterface cri = null;
                if (VpConfig.getInstance().bonFiscalDublu) {
                    cri = this.secondaryCashRegister;
                }
                this.printBonFiscal(o, f, this.cashRegister, cri, f, clientIndex, allSales);
            }
        } else if (this.secondaryCashRegister instanceof DummyCashRegister) {
            String message = "dummy ecr";
            Logger.logDebug(this, message);
            System.out.println(message);
        } else {
            this.printBonFiscal(o, false, this.secondaryCashRegister, null, true, clientIndex, allSales);
        }
    }

    public void addSecondaryCashRegisterSectieId(int idSectie) {
        this.secondaryCashRegisterSectiiIds.add(idSectie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<Sale> getSalesForBf(Order o, int clientIndex) {
        Vector<Sale> sales = new Vector();
        try {
            sales = this.getOrdersDao().getSales(o.getId(), true, -1, clientIndex, this.pool.requestConnection().getConnection(), new PrintSaleInterface());
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return sales;
    }

    private void printBonFiscal(Order o, boolean f, CashRegisterInterface cashRegister, boolean print, int clientIndex) {
        Vector<Sale> sales = this.getSalesForBf(o, clientIndex);
        this.printBonFiscal(o, f, cashRegister, null, print, clientIndex, sales);
    }

    private void printBonFiscal(Order o, boolean f, CashRegisterInterface cashRegister1, CashRegisterInterface cashRegister2, boolean print, int clientIndex, Vector<Sale> sales) {
        Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(o.getId(), clientIndex);
        this.printBonFiscal(o, f, cashRegister1, cashRegister2, print, sales, plati, clientIndex);
    }

    public void printBonFiscal(Order o, Vector<Sale> sales, Vector<Plata> plati, int clientIndex) {
        this.printBonFiscal(o, true, this.cashRegister, null, true, sales, plati, clientIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printBonFiscal(final Order order, boolean f, CashRegisterInterface cashRegister1, CashRegisterInterface cashRegister2, boolean print, Vector<Sale> sales, Vector<Plata> plati, int clientIndex) {
        if (order.isComanda()) {
            return;
        }
        try {
            order.setFiscal(f);
            this.getOrdersDao().setFiscal(order);
            User u = this.userLogic.getUserByIdNoCommit(order.getUser());
            Client c = ClientLogic.getInstance().getClientByIdNoCommit(order.getIdClient());
            String orderIdentifier = RestLogic.getOrderIdentifier(u.getLogin(), order.getId());
            Vector comments = this.getValoareConturiForBonFiscal(order);
            String simpleCodFiscal = order.getCodFiscal();
            String adresaLivrare = order.getAdresaLivrare();
            BonFIscalInterface bonFIscalInterface = new BonFIscalInterface(){

                @Override
                public double[] getIstoricIncasariClient(Client c, Date start, Date end) {
                    double[] result = new double[2];
                    double totalBonCurent = RestLogic.this.getTotal(order);
                    double total = RestLogic.this.getTotalIncasariClient(c, start, end);
                    result[0] = totalBonCurent;
                    result[1] = total;
                    return result;
                }

                @Override
                public void addPlata(int idOrder, TipPlata tp, double diff, String detalii, int clientIndex) throws SQLException {
                    PaymentLogic.getInstance().addPlataNoCommit(idOrder, tp, diff, detalii, clientIndex);
                }
            };
            Table t = this.getTableById(order.getTable());
            Location l = this.getLocationById(t.getIdLocatie());
            String tableName = t.getLabel();
            String locatieName = l.getName();
            int idClient = order.getIdClient();
            if (print) {
                boolean printProtocol;
                boolean bl = printProtocol = !order.isProtocol() || VpConfig.getInstance().protocolAdaosComercial >= 0 && VpConfig.getInstance().protocolAdaosComercialPrintBF;
                if (printProtocol && sales.size() > 0) {
                    this.printBonFiscalNoArch(cashRegister1, cashRegister2, sales, plati, u, c, orderIdentifier, comments, order.getId(), simpleCodFiscal, adresaLivrare, bonFIscalInterface, idClient, locatieName, tableName, clientIndex);
                }
            }
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.requestConnection().rollback();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void printBonFiscalNoArch(Vector<Sale> sales, Vector<Plata> plati, User user, Client client, String orderIdentifier, Vector<String> comments, int idOrder, String simpleCodFiscal, String adresaLivrare, BonFIscalInterface bonFIscalInterface, int idClient, String locatieName, String tableName, int clientIndex1) throws SQLException {
        this.printBonFiscalNoArch(this.cashRegister, null, sales, plati, user, client, orderIdentifier, comments, idOrder, simpleCodFiscal, adresaLivrare, bonFIscalInterface, idClient, locatieName, tableName, clientIndex1);
    }

    public void printBonFiscalNoArch(CashRegisterInterface cashRegister1, CashRegisterInterface cashRegister2, Vector<Sale> sales, Vector<Plata> plati, User user, Client client, String orderIdentifier, Vector<String> comments, int idOrder, String simpleCodFiscal, String adresaLivrare, BonFIscalInterface bonFIscalInterface, int idClient, String locatieName, String tableName, int clientIndex1) throws SQLException {
        int ecrValueDecimalPlaces = 2;
        int ecrQuantityDecimalPlaces = 3;
        String salesAsText = "Sales:\n";
        Vector<EcrSale> ecrSales = new Vector<EcrSale>();
        for (Sale s : sales) {
            EcrSale e = this.createEcrSale(s.getIdProduct(), FloatUtils.roundFloat(s.getPrice(), ecrValueDecimalPlaces), FloatUtils.roundFloat(s.getCantitateMarcata(), ecrQuantityDecimalPlaces), FloatUtils.roundFloat(s.getPpuOriginal(), ecrValueDecimalPlaces), FloatUtils.roundFloat(s.getDiscount(), ecrValueDecimalPlaces));
            if (e == null) continue;
            ecrSales.add(e);
            salesAsText = salesAsText + e.getProduct() + " cant " + Utils.getString2Decimals(s.getCantitateMarcata()) + " pret " + Utils.getString2Decimals(s.getPrice()) + " discount " + Utils.getString2Decimals(s.getDiscount()) + "\n";
        }
        if (ecrSales.size() > 0) {
            double totalSales = RestLogic.computeTotalForSalesForECR(sales);
            totalSales = FloatUtils.roundFloat(totalSales, 2);
            double totalPlati = PaymentLogic.getPlatiInVector(plati);
            TipPlata tpDefault = TipPlataProvider.getInstance().getDefaultTipPlataNoCommit();
            double diff = totalSales - totalPlati;
            if (Utils.isValueGreaterThanZero(diff) && tpDefault != null) {
                bonFIscalInterface.addPlata(idOrder, tpDefault, diff, "", clientIndex1);
                Plata plataNoua = new Plata(tpDefault.getId(), diff, tpDefault.getEcrMapping(), tpDefault.getLabel(), "", clientIndex1);
                plati.add(plataNoua);
            }
            Vector<EcrPlata> tipPlata2 = EcrUtils.getEcrPlati(plati, cashRegister1, tpDefault);
            TipPlata cashDefault = TipPlataProvider.getInstance().getDefaultTipPlataNoCommit();
            Logger.logDebug(this, "printing bon fiscal : " + ecrSales + " plati : " + tipPlata2 + " plata default : " + cashDefault);
            Vector<String> produsePretZero = new Vector<String>();
            if (VpConfig.getInstance().bonFiscalPrintProduseCuZeroAsComments) {
                for (Sale s : sales) {
                    String comment = this.createCommentForZeroPriceProduct(s.getIdProduct(), s.getPrice());
                    if (comment == null) continue;
                    produsePretZero.add(comment);
                }
            }
            if ((VpConfig.getInstance().bonFiscalPrintOspatar || VpConfig.getInstance().bonFiscalPrintMasa || VpConfig.getInstance().bonFiscalPrintIstoric && idClient != -1 || VpConfig.getInstance().bonFiscalPrintClientName && idClient != -1 || VpConfig.getInstance().bonFiscalPrintIdOrder || VpConfig.getInstance().bonFiscalPrintProduseCuZeroAsComments) && !VpConfig.getInstance().bonFiscalPrintClientPhone && produsePretZero.size() <= 0) {
                comments.add("");
            }
            comments.addAll(produsePretZero);
            if (VpConfig.getInstance().bonFiscalPrintClientPhone && client != null) {
                comments.add(client.getTelefoane(", "));
            }
            if (VpConfig.getInstance().bonFiscalPrintIdOrder) {
                comments.add("id: " + idOrder);
            }
            if (VpConfig.getInstance().bonFiscalPrintOspatar && user != null) {
                comments.add("Operator: " + user.getLogin());
            }
            if (VpConfig.getInstance().bonFiscalPrintMasa) {
                comments.add(tableName);
                comments.add(locatieName);
            }
            if (VpConfig.getInstance().bonFiscalPrintCodFiscal && idClient != -1 && client instanceof ClientPersJuridica) {
                ClientPersJuridica cpj = (ClientPersJuridica)client;
                comments.add("CUI " + cpj.getCui());
            }
            if (VpConfig.getInstance().bonFiscalPrintCodFiscal && Validators.correctString(simpleCodFiscal)) {
                comments.add("CUI " + simpleCodFiscal);
            }
            if (VpConfig.getInstance().bonFiscalPrintClientName && client != null) {
                comments.add(client.toString());
            }
            if (VpConfig.getInstance().bonFiscalPrintClientAddress && client != null) {
                comments.add(adresaLivrare);
            }
            if (VpConfig.getInstance().bonFiscalPrintIstoric && client != null) {
                Date stopDate = DateUtils.getEndOfDay(new Date());
                Date startDate = DateUtils.addDaysToDate(stopDate, -30);
                startDate = DateUtils.getStartOfDay(startDate);
                double[] istoricIncasari = bonFIscalInterface.getIstoricIncasariClient(client, startDate, stopDate);
                String perioada = Formatters.REZERVARI_FORMAT.format(startDate) + " - " + Formatters.REZERVARI_FORMAT.format(stopDate);
                comments.add(perioada);
                comments.add("");
                comments.add("TOTAL: " + Utils.getString2DecimalsNoTrunc(istoricIncasari[1] + istoricIncasari[0]));
            }
            if (VpConfig.getInstance().bonFiscalPrintOspatar || VpConfig.getInstance().bonFiscalPrintMasa || VpConfig.getInstance().bonFiscalPrintIstoric && idClient != -1 || VpConfig.getInstance().bonFiscalPrintClientName && idClient != -1) {
                comments.add("");
            }
            String platiAsText = "Plati:\n";
            boolean printSome = true;
            for (int i = 0; i < plati.size(); ++i) {
                Plata o1 = plati.elementAt(i);
                if (!Validators.correctString(o1.getEcrMapping())) {
                    printSome = false;
                }
                platiAsText = platiAsText + o1.getTipPlata() + "=" + Utils.getString2Decimals(o1.getSuma()) + "\n";
            }
            if (comments.size() > 0 && printSome) {
                printSome = true;
            }
            if (printSome) {
                Collections.sort(tipPlata2, new Comparator<EcrPlata>(){

                    @Override
                    public int compare(EcrPlata o1, EcrPlata o2) {
                        if (o1.isDefault()) {
                            return 1;
                        }
                        return -1;
                    }
                });
                cashRegister1.printBonFiscal(ecrSales, totalSales, tipPlata2, cashDefault, comments, orderIdentifier, idOrder);
                if (cashRegister2 != null) {
                    cashRegister2.printBonFiscal(ecrSales, totalSales, tipPlata2, cashDefault, comments, orderIdentifier, idOrder);
                }
                String commentsAsText = "Comments:\n";
                for (String comment : comments) {
                    commentsAsText = commentsAsText + comment + "\n";
                }
                Map map = this.buildMapForExport("Bon fiscal pt comanda " + idOrder + " / " + orderIdentifier, salesAsText, platiAsText, commentsAsText);
                GenericListenersLogic.getInstance().notifyObjectListeners(1006, map);
            }
        }
    }

    @Override
    public double getTotalIncasari(Client c, Date startDate) {
        Date stopDate = DateUtils.getEndOfDay(new Date());
        startDate = DateUtils.getStartOfDay(startDate);
        double total = this.getTotalIncasariClient(c, startDate, stopDate);
        return total;
    }

    private Vector<String> getValoareConturiForNota(Order o, Client c, Vector<Plata> platiPeNotaCurenta, Vector<Sale> sales) {
        Vector<String> result = new Vector<String>();
        if (o.getIdClient() > 0) {
            Vector<ValoareContClient> conturiInainteNotaCurenta = ClientLogic.getInstance().getConturiClient(o.getIdClient(), -1);
            String inainteS = "INAINTE NOTA : ";
            for (int i = 0; i < conturiInainteNotaCurenta.size(); ++i) {
                ValoareContClient o1 = conturiInainteNotaCurenta.elementAt(i);
                inainteS = inainteS + o1.getNumeCont() + "=" + Utils.getString2Decimals(o1.getValoare()) + ", ";
            }
            double discountBeforeNota = this.getAvailableDiscountBeforeNota(c);
            inainteS = inainteS + "DISCOUNT = " + Utils.getString2Decimals(discountBeforeNota);
            result.add(inainteS);
            String dupaS = "DUPA NOTA : ";
            for (ValoareContClient valoareContClient : conturiInainteNotaCurenta) {
                double valoare = valoareContClient.getValoare();
                for (Plata plata : platiPeNotaCurenta) {
                    if (!plata.getTipPlata().equals(valoareContClient.getNumeCont())) continue;
                    valoare -= plata.getSuma();
                }
                dupaS = dupaS + valoareContClient.getNumeCont() + "=" + Utils.getString2Decimals(valoare) + ", ";
            }
            double discountPeNotaInCurs = 0.0;
            for (Sale sale : sales) {
                discountPeNotaInCurs += sale.getDiscount() * sale.getCantitateMarcata();
            }
            double discountDupaNota = discountBeforeNota - discountPeNotaInCurs;
            dupaS = dupaS + "DISCOUNT = " + Utils.getString2Decimals(discountDupaNota);
            result.add(dupaS);
        }
        return result;
    }

    private Vector getValoareConturiForBonFiscal(Order o) {
        Vector<String> comments = new Vector<String>();
        if (o.getIdClient() > 0 && VpConfig.getInstance().bonFiscalPrintContDetails) {
            Vector<ValoareContClient> conturi = ClientLogic.getInstance().getConturiClient(o.getIdClient(), -1);
            comments.add(" ");
            for (int i = 0; i < conturi.size(); ++i) {
                ValoareContClient o1 = conturi.elementAt(i);
                String numeCont = o1.getNumeCont();
                double valoare = o1.getValoare();
                String s = numeCont + "=" + Utils.getString2Decimals(valoare);
                comments.add(s);
            }
            comments.add(" ");
        }
        return comments;
    }

    public void printBonFiscalAlimentareCont(int idProdus, double suma, Table table, int idUser, int idClient) {
        TipPlata tipPlata2 = TipPlataProvider.getInstance().getTipPlataByNameCommit(VpConfig.getInstance().tipPlataAlimentareCont);
        this.printBonFiscalAlimentareCont(idProdus, suma, table, idUser, idClient, tipPlata2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBonFiscalAlimentareCont(int idProdus, double suma, Table table, int idUser, int idClient, TipPlata tipPlata2) {
        Product p = this.nomeclaturaLogic.getProductById(idProdus);
        if (p == null) {
            return;
        }
        try {
            this.printBonFiscalAlimentareContNoCommit(idProdus, suma, table, idUser, idClient, tipPlata2, -1, null);
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.requestConnection().rollback();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void printBonFiscalAlimentareContNoCommit(int idProdus, double suma, Table table, int idUser, int idClient, TipPlata tipPlata2, int idPromotie, AbstractPrinter forcedPrinter) throws SQLException {
        Product p = this.nomeclaturaLogic.getProductByIdNoCommit(idProdus);
        if (p == null) {
            return;
        }
        int clientIndex = 0;
        long now = System.currentTimeMillis();
        Order o = this.newOrderNoCommit(table.getId(), idUser, false);
        o.setIdClient(idClient);
        Sale s = this.buildSaleNoCommit(p, 0.0, 1.0, "", o.getId(), -1, -1, -1, -1, now, 0);
        s.setPpuOriginal(suma);
        s.setPrice(suma);
        this.addSaleNoCommit(s, o.getUser());
        if (idPromotie > 0) {
            this.setPromotionForOrderNoCommit(o, idPromotie);
        }
        if (tipPlata2 != null) {
            Plata plata = new Plata(tipPlata2.getId(), suma, tipPlata2.getEcrMapping(), tipPlata2.getLabel(), "", clientIndex);
            PaymentLogic.getInstance().addPlataToOrderNoCommit(o, plata);
        }
        this.laPlataOrderNoCommit(o, table, VpConfig.getInstance().remizaAutomata, forcedPrinter, false, -1);
        this.printBonFiscalSeparatNoCommit(o, true);
        this.closeOrderNoCommit(o, null);
    }

    public static double computeTotalForSales(Collection sales) {
        return RestLogic.computeTotalForSalesForECR(sales);
    }

    public static double computeTotalForSalesForECR(Collection sales) {
        double total = 0.0;
        for (Sale element : sales) {
            double value = FloatUtils.roundDoubleUp((element.getCantitateNoua() + element.getCantitateMarcata()) * element.getPrice(), 2);
            total += value;
        }
        return total;
    }

    public static double computeTotalForSalesOriginalPrice(Collection sales) {
        double total = 0.0;
        for (Sale element : sales) {
            total += element.getCantitateMarcata() * element.getPpuOriginal();
        }
        return total;
    }

    public void printRaport(String raportTitle, String toPrint, double total, String[][] details) {
        String s = toPrint + "\n";
        for (int i = 0; i < details[0].length; ++i) {
            s = s + details[0][i] + " " + details[1][i] + "\n";
        }
        s = s + "\n";
        s = s + "TOTAL " + Utils.getString2Decimals(total);
        this.printer.printRaport(raportTitle, s, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSalesFacturate(Vector<Sale> note) {
        try {
            for (Sale sale : note) {
                Vector<Integer> ids = sale.getIdSales();
                for (Integer id : ids) {
                    this.getSalesDao().setSaleFacturata(id, true);
                }
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFreeFields(Sale toSet) {
        try {
            for (Integer idSale : toSet.getIdSales()) {
                this.getSalesDao().setFreeFieldsToSale(idSale, toSet);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSalesPrinted(Vector<Sale> note) {
        try {
            for (Sale sale : note) {
                Vector<Integer> ids = sale.getIdSales();
                for (Integer id : ids) {
                    this.getSalesDao().setSalePrinted(id);
                }
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printNotaIntermediara(Order toPrint, Table t, AbstractPrinter forcedPrinter, boolean groupByClientIndex, int clientiIndex) {
        this.printNotaInternally(toPrint, t, forcedPrinter, groupByClientIndex, clientiIndex, new PrintSaleInterface(), 0);
        Vector<Sale> salesToAlter = this.getSales(toPrint.getId(), false, 0, new ScreenSaleInterface());
        if (salesToAlter.size() == 0) {
            return;
        }
        try {
            for (int i = 0; i < salesToAlter.size(); ++i) {
                Sale sale = salesToAlter.elementAt(i);
                int idSale = sale.getFirstIdSale();
                this.getSalesDao().setSalePrinted(idSale);
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void printNota(Order toPrint, Table t, AbstractPrinter forcedPrinter, boolean groupByClientIndex, int clientiIndex) {
        this.printNotaInternally(toPrint, t, forcedPrinter, groupByClientIndex, clientiIndex, new PrintSaleInterface(), -1);
    }

    private void printNota(Order toPrint, Table t, AbstractPrinter forcedPrinter, SearchSaleInterface inter, boolean groupByClientIndex, int clientiIndex) {
        this.printNotaInternally(toPrint, t, forcedPrinter, groupByClientIndex, clientiIndex, inter, -1);
    }

    private void printNotaInternally(Order toPrint, Table t, AbstractPrinter forcedPrinter, boolean groupByClientIndex, int clientiIndex, SearchSaleInterface inter, int printedStatus) {
        Hashtable<Integer, Vector<Sale>> hashToPrint = new Hashtable<Integer, Vector<Sale>>();
        if (groupByClientIndex) {
            int maxClientIndexForOrder = this.getMaxClientsForOrder(toPrint, new Vector<Sale>());
            if (maxClientIndexForOrder > 0) {
                for (int i = 1; i <= maxClientIndexForOrder; ++i) {
                    if (clientiIndex > 0 && clientiIndex != i) continue;
                    Vector<Sale> salesToPrint = this.getSales(toPrint.getId(), true, printedStatus, inter, i);
                    hashToPrint.put(i, salesToPrint);
                }
            } else {
                Vector<Sale> salesToPrint = this.getSales(toPrint.getId(), true, printedStatus, inter);
                hashToPrint.put(-1, salesToPrint);
            }
        } else {
            Vector<Sale> salesToPrint = this.getSales(toPrint.getId(), true, printedStatus, inter);
            hashToPrint.put(-1, salesToPrint);
        }
        this.printNotaInternallyHash(toPrint, t, forcedPrinter, groupByClientIndex, hashToPrint);
    }

    private void printNotaInternallyHash(Order toPrint, Table t, AbstractPrinter forcedPrinter, boolean groupByClientIndex, Hashtable<Integer, Vector<Sale>> hashToPrint) {
        User w = this.userLogic.getUserById(toPrint.getUser());
        boolean protocol = toPrint.isProtocol();
        int nrNota = toPrint.getId();
        String adresaClient = "";
        String numeClient = "";
        String telefonClient = "";
        String idOrder = "";
        String cnpClient = "";
        String serieAct = "";
        Client c = null;
        if (toPrint.getIdClient() > 0) {
            c = ClientLogic.getInstance().getClientById(toPrint.getIdClient());
            if (VpConfig.getInstance().notaPrintAdresaClient && !Validators.correctString(adresaClient = toPrint.getAdresaLivrare())) {
                adresaClient = c.getAddressAsString() + " " + c.getCity();
            }
            if (VpConfig.getInstance().notaPrintNumeClient) {
                numeClient = c.toString();
            }
            if (VpConfig.getInstance().notaPrintTelefonClient) {
                telefonClient = c.getTelefoane(", ");
            }
            if (VpConfig.getInstance().notaPrintIdOrder) {
                idOrder = "Id: " + toPrint.getId() + "";
            }
            if (c instanceof ClientPersFizica) {
                BiCi bici;
                ClientPersFizica cpf = (ClientPersFizica)c;
                int idBuletin = cpf.getIdBuletin();
                if (idBuletin > 0 && (bici = ClientLogic.getInstance().getBiCiById(idBuletin)) != null) {
                    String cnp = bici.getCnp();
                    if (cnp != null) {
                        cnpClient = "CNP " + cnp;
                    }
                    String serNr = "";
                    String seria = bici.getSeria();
                    String nr = bici.getNumarul();
                    serNr = (seria != null ? seria : "") + (nr != null ? nr : "");
                    serieAct = "ACT " + serNr;
                }
            } else if (c instanceof ClientPersJuridica) {
                ClientPersJuridica cpj = (ClientPersJuridica)c;
                String cui = cpj.getCui();
                cnpClient = "CUI " + (cui != null ? cui : "");
                String j = cpj.getJ();
                serieAct = "NrReg " + (j != null ? j : "");
            }
        }
        String detaliiNota = "";
        if (Validators.correctString(toPrint.getDetalii())) {
            detaliiNota = toPrint.getDetalii() + " " + idOrder;
        }
        for (Integer clientIndexInternal : hashToPrint.keySet()) {
            Vector<Sale> salesToPrint = hashToPrint.get(clientIndexInternal);
            if (salesToPrint.size() <= 0) continue;
            this.printSalesGeneric(salesToPrint, protocol, w, t, toPrint, c, toPrint.getIdPromotie(), nrNota, adresaClient, numeClient, telefonClient, detaliiNota, forcedPrinter, groupByClientIndex, clientIndexInternal, cnpClient, serieAct);
        }
    }

    private void printSalesGeneric(Vector sales, boolean protocol, User w, Table t, Order order, Client client, int idPromotion, int nrNota, String adresaClient, String numeClient, String telefonClient, String detaliiNota, AbstractPrinter forcedPrinter, boolean groupByClientIndex, int clientiIndex, String cnpClient, String serieAct) {
        this.printSales(sales, protocol, w, t, order, client, idPromotion, nrNota, adresaClient, numeClient, telefonClient, detaliiNota, forcedPrinter, groupByClientIndex, clientiIndex, cnpClient, serieAct);
    }

    private void printSales(Vector sales, boolean protocol, User ospatar, Table masa, final Order order, Client client, int idPromotion, int nrNota, String adresaClient, String numeClient, String telefonClient, String detaliiNota, AbstractPrinter forcedPrinter, boolean groupByClientIndex, final int clientiIndex, String cnpClient, String serieAct) {
        NotaInterface nif = new NotaInterface(){

            @Override
            public Vector<Plata> getPlati() {
                Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(order.getId(), clientiIndex);
                return plati;
            }
        };
        Location locatie = this.getLocationById(masa.getIdLocatie());
        String table = "";
        if (VpConfig.getInstance().notaPrintMasa) {
            table = masa.getLabel() + " " + locatie.getName();
        }
        Vector<String> detaliiCont = this.getValoareConturiForNota(order, client, nif.getPlati(), sales);
        this.printSalesNoarch(sales, ospatar, locatie, order.getId() + "", detaliiNota, forcedPrinter, protocol, nrNota, numeClient, telefonClient, adresaClient, nif, table, detaliiCont, idPromotion, groupByClientIndex, clientiIndex, cnpClient, serieAct);
    }

    public void printSalesNoarch(Vector sales, User ospatar, Location locatie, String notaIdentifier, String detaliiNota, AbstractPrinter forcedPrinter, boolean protocol, int nrNota, String numeClient, String telefonClient, String adresaClient, NotaInterface nif, String table, Vector<String> detaliiCont, int idPromotion, boolean groupByClientIndex, int clientiIndex, String cnpClient, String serieAct) {
        Vector<PrinterSale> printerSales = new Vector<PrinterSale>();
        double reducere = 0.0;
        double totalInainteReducere = 0.0;
        double totalTva = 0.0;
        Iterator iter = sales.iterator();
        int i = 0;
        Vector<Sectie> allSectii = this.nomeclaturaLogic.getAllSectii();
        Hashtable<Integer, Sectie> allSectiiHash = new Hashtable<Integer, Sectie>();
        for (Sectie sectie1 : allSectii) {
            allSectiiHash.put(sectie1.getId(), sectie1);
        }
        String detaliiForExport = "";
        while (iter.hasNext()) {
            Categorie c;
            Sale sale = (Sale)iter.next();
            String productName = sale.getProductName();
            String sectieName = sale.getSectieName();
            String detalii = "";
            if (VpConfig.getInstance().notaPrintCodProdus) {
                Product prod = this.nomeclaturaLogic.getProductById(sale.getIdProduct());
                detalii = detalii + prod.getCod();
            }
            String linePrefix = "";
            if (VpConfig.getInstance().notaPrintProductsAsOnScreen) {
                int currentPlatouId = sale.getIdPlatou();
                String platouChar = this.getPlatouChar(sales, i, currentPlatouId);
                if (Validators.correctString(sale.getModPreparare())) {
                    if (detalii.length() > 0) {
                        detalii = detalii + ", ";
                    }
                    detalii = detalii + sale.getModPreparare();
                }
                linePrefix = platouChar + " ";
                if (platouChar.equalsIgnoreCase("/")) {
                    PrinterSale ps = new PrinterSale();
                    printerSales.add(ps);
                }
            }
            String newProductName = linePrefix + productName;
            if (detalii.length() > 0) {
                newProductName = newProductName + " (" + detalii + ")";
            }
            double productPrice = sale.getPpuOriginal();
            if (!VpConfig.getInstance().notaPrintDiscount) {
                productPrice = sale.getPrice();
            }
            if ((c = this.nomeclaturaLogic.getCategoryById(sale.getIdCategorie())) == null) {
                System.out.println("Categoria is null");
            }
            Sectie s = (Sectie)allSectiiHash.get(c.getSectie());
            sectieName = s.getName();
            double nrPortii = sale.getCantitateMarcata();
            double total = nrPortii * productPrice;
            PrinterSale ps = new PrinterSale(newProductName, Utils.getString2Decimals(productPrice), Utils.getString3Decimals(nrPortii), Utils.getString2Decimals(total), sectieName);
            printerSales.add(ps);
            totalInainteReducere += total;
            double discount = sale.getDiscount();
            if (!VpConfig.getInstance().notaPrintDiscount) {
                discount = 0.0;
            }
            reducere += nrPortii * discount;
            int idTva = c.getIdTva();
            double cotaTva = TvaLogic.getInstance().getTvaById(idTva).getCota();
            double valTva = TvaLogic.getTvaFromSumaCuTva(sale.getPrice() * nrPortii, cotaTva);
            totalTva += valTva;
            detaliiForExport = detaliiForExport + Utils.getString2Decimals(nrPortii) + " * " + newProductName + " = " + total + "\n";
            ++i;
        }
        totalInainteReducere = FloatUtils.roundFloat(totalInainteReducere, 2);
        reducere = FloatUtils.roundFloat(reducere, 2);
        VpConfig config = VpConfig.getInstance();
        String waiter = "";
        String waiterString = "";
        if (VpConfig.getInstance().notaPrintOspatar) {
            waiter = ospatar.getName();
            waiterString = LanguageLogic.print_nota_waiter_title + ": " + waiter;
        }
        if (groupByClientIndex && clientiIndex > 0) {
            table = table + " NOTA SEPARATA " + clientiIndex;
        }
        String tva = null;
        tva = config.printTva ? Utils.getString2Decimals(totalTva) : "";
        if (reducere != 0.0) {
            double totalDupaReducere = totalInainteReducere - reducere;
            String promoName = "";
            if (config.notaPrintPromoName && idPromotion != -1) {
                Promotion p = PromotionLogic.getInstance().getPromotionById(idPromotion);
                promoName = " " + p.getLabel();
            }
            if (VpConfig.getInstance().notaPrintContDetails) {
                if (detaliiNota.length() > 0) {
                    detaliiNota = detaliiNota + ",";
                }
                for (String line : detaliiCont) {
                    detaliiNota = detaliiNota + line + "\n";
                }
            }
            this.printer.printNota(printerSales, Utils.getString2Decimals(reducere), Utils.getString2Decimals(totalInainteReducere), Utils.getString2Decimals(totalDupaReducere), waiterString, table, protocol, tva, nif.getPlati(), promoName, nrNota, adresaClient, numeClient, telefonClient, detaliiNota, locatie, forcedPrinter, VpConfig.getInstance().notaValutaText, cnpClient, serieAct);
            String title = "NOTA " + nrNota + " / " + notaIdentifier + " " + table + " TOTAL INAINTE DISCOUNT " + Utils.getString2Decimals(totalInainteReducere) + " TOTAL DUPA DISCOUNT " + Utils.getString2Decimals(totalDupaReducere);
            Logger.logDebugVerbose(this, title);
            Map map = this.buildMapForExport(title, detaliiForExport, detaliiNota);
            GenericListenersLogic.getInstance().notifyObjectListeners(1005, map);
        } else {
            if (VpConfig.getInstance().notaPrintContDetails) {
                if (detaliiNota.length() > 0) {
                    detaliiNota = detaliiNota + ",";
                }
                for (String line : detaliiCont) {
                    detaliiNota = detaliiNota + line + "\n";
                }
            }
            this.printer.printNota(printerSales, null, Utils.getString2Decimals(totalInainteReducere), null, waiterString, table, protocol, tva, nif.getPlati(), "", nrNota, adresaClient, numeClient, telefonClient, detaliiNota, locatie, forcedPrinter, VpConfig.getInstance().notaValutaText, cnpClient, serieAct);
            String title = "NOTA " + nrNota + " / " + notaIdentifier + " " + table + " TOTAL " + Utils.getString2Decimals(totalInainteReducere);
            Logger.logDebugVerbose(this, title);
            Map map = this.buildMapForExport(title, detaliiForExport, detaliiNota);
            GenericListenersLogic.getInstance().notifyObjectListeners(1005, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<PlataLaCazareTotalBean> getTotalGroupBySectieAndTva(int idOrder, int clientIndex) {
        Hashtable<String, PlataLaCazareTotalBean> result = new Hashtable<String, PlataLaCazareTotalBean>();
        try {
            Vector<Sale> sales = this.getOrdersDao().getSales(idOrder, true, -1, clientIndex, this.pool.requestConnection().getConnection(), new ScreenSaleInterface());
            for (Sale element : sales) {
                int idSectie = element.getIdSectie();
                int idCategory = element.getIdCategorie();
                Categorie cat = this.nomeclaturaLogic.getCategoryByIdNoCommit(idCategory);
                int idTva = cat.getIdTva();
                String key = idSectie + "_" + idTva;
                PlataLaCazareTotalBean existing = (PlataLaCazareTotalBean)result.get(key);
                if (existing == null) {
                    existing = new PlataLaCazareTotalBean();
                    existing.setIdSectie(idSectie);
                    existing.setIdTva(idTva);
                    existing.setTotal(0.0);
                    result.put(key, existing);
                }
                existing.setTotal(existing.getTotal() + element.getCantitateMarcata() * element.getPrice());
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotalOriginalPrice(Order o) {
        double total = 0.0;
        try {
            total = this.getTotalOriginalPriceNoCommit(o);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return total;
    }

    private double getTotalOriginalPriceNoCommit(Order o) throws SQLException {
        double total = 0.0;
        if (o != null) {
            Vector<Sale> sales = this.getOrdersDao().getSales(o.getId(), true, -1, -1, this.pool.requestConnection().getConnection(), new ScreenSaleInterface());
            total = RestLogic.computeTotalForSalesOriginalPrice(sales);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTablesForLocation(LocationPanel2 locationPanel, Location l, DiagramPanel currentDiagram) {
        try {
            Vector<Table> allTables = this.getTablesByLocationNoCommit(l.getId());
            for (int i = 0; i < allTables.size(); ++i) {
                Table table = allTables.elementAt(i);
                Order o = this.getOpenOrderAtTableNoCommit(table);
                this.tableStatusChanged(table, o, currentDiagram, locationPanel);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshLocations(int idLocatie, DiagramPanel currentDiagram, ColorChooserInterface colorInterface) {
        try {
            Vector<Table> tables = this.getTablesByLocation(idLocatie);
            for (Table element : tables) {
                this.tableStatusChanged(element, this.getOpenOrderAtTableNoCommit(element), currentDiagram, colorInterface);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableStatusChangedCommit(Table t, Order o, DiagramPanel currentDiagram, ColorChooserInterface colorInterface) {
        try {
            this.tableStatusChanged(t, o, currentDiagram, colorInterface);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void tableStatusChanged(Table t, Order o, DiagramPanel currentDiagram, ColorChooserInterface colorInterface) throws SQLException {
        DiagramPanel locationPanel = currentDiagram;
        if (o != null) {
            User u = UsersLogic.getInstance().getUserByIdNoCommit(o.getUser());
            Color[] colors = colorInterface.getColorOrderAndUser(o, u);
            Color bgColor = colors[0];
            Color borderColor = colors[1];
            locationPanel.setMasaConturLineColor(t.getLabel(), borderColor);
            locationPanel.setMasaFillColor(t.getLabel(), bgColor);
            long time = o.getStartTime();
            Timestamp start = new Timestamp(time);
            Timestamp now = DateUtils.getCurrentTimestamp();
            String dateAndTime = "";
            dateAndTime = DateUtils.sameDay(start, now) ? Formatters.TIME_FORMAT.format(start) : Formatters.SHORT_DATE_AND_TIME_FORMAT.format(start);
            int idClient = o.getIdClient();
            String clientName = null;
            if (idClient > 0) {
                Client c1 = ClientLogic.getInstance().getClientByIdNoCommit(idClient);
                if (c1 == null) {
                    Logger.logWarning(this, "idClient not null but client null for id_client : " + idClient);
                } else {
                    clientName = c1.toString();
                }
            }
            locationPanel.setNameOspatar(t.getLabel(), u.getLogin(), dateAndTime, clientName, o.getDetalii());
        } else if (t != null) {
            locationPanel.setNameOspatar(t.getLabel(), "", null, null, null);
            locationPanel.setMasaConturLineColor(t.getLabel(), Color.BLACK);
            locationPanel.setMasaFillColor(t.getLabel(), Color.WHITE);
        }
    }

    public Order getOpenOrderAtTableNoCommit(Table t) throws SQLException {
        if (t == null) {
            return null;
        }
        Vector<Order> orders = this.getOrdersDao().getOpenOrderAtTable(t.getId());
        if (orders.size() > 0) {
            return orders.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Order getOpenOrderAtTable(Table t) {
        try {
            Order order = this.getOpenOrderAtTableNoCommit(t);
            return order;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Order order = null;
            return order;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<Order> getAllOpenOrdersAtTableNoCommit(Table t) throws SQLException {
        Vector<Order> orders = this.getOrdersDao().getOpenOrderAtTable(t.getId());
        return orders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Order> getAllOpenOrdersAtTable(Table t) {
        try {
            Vector<Order> vector = this.getAllOpenOrdersAtTableNoCommit(t);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Order> vector = new Vector<Order>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getOpenOrdersByUser(User u) {
        if (u == null) {
            return new Vector();
        }
        try {
            Vector result;
            Vector vector = result = this.getOrdersDao().getOpenOrdersByUser(u.getId());
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Collection getClosedOrders() {
        try {
            Collection result = this.getOrdersDao().getClosedOrders();
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return result;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    public Vector<Sale> getSalesNoCommitNoSort(int idOrder, boolean cumulate, int printedStatus, SearchSaleInterface search, int clientIndex) throws SQLException {
        Vector<Sale> sales = this.getOrdersDao().getSales(idOrder, cumulate, printedStatus, clientIndex, this.pool.requestConnection().getConnection(), search);
        return sales;
    }

    public Vector<Sale> getSalesNoCommitNoCategoriesSort(int idOrder, boolean cumulate, int printedStatus, SearchSaleInterface search) throws SQLException {
        Vector<Sale> sales = this.getOrdersDao().getSalesNoSort(idOrder, cumulate, printedStatus, this.pool.requestConnection().getConnection(), search);
        return sales;
    }

    public Vector<Sale> getSalesForIdOrdersNoCommitNoSortNoCumulate(Vector<Integer> idOrders) throws SQLException {
        return this.getOrdersDao().getSales(idOrders, this.pool.requestConnection().getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Sale> getSalesForIdOrdersNoSortNoCumulate(Vector<Integer> idOrders) {
        try {
            Vector<Sale> vector = this.getSalesForIdOrdersNoCommitNoSortNoCumulate(idOrders);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Sale> vector = new Vector<Sale>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<Sale> getSales(int idOrder, boolean cumulate, int printedStatus, SearchSaleInterface search) {
        return this.getSales(idOrder, cumulate, printedStatus, search, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Sale> getSales(int idOrder, boolean cumulate, int printedStatus, SearchSaleInterface search, int clientIndex) {
        try {
            Vector<Sale> sales = this.getSalesNoCommitNoSort(idOrder, cumulate, printedStatus, search, clientIndex);
            Collections.sort(sales);
            Vector<Sale> vector = sales;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Sale> vector = new Vector<Sale>();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void processAllOrders() {
        try {
            this.getOrdersDao().processAllOrders();
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOrder(Order o, User u, String explain, Component panel, boolean popup) {
        double total = this.getTotal(o);
        try {
            User w = this.getOrdersDao().getUserByOrderId(o.getId());
            if (this.deleteOrderNoCommit(o, u, explain, panel, popup)) {
                this.pool.commit();
                this.deleteForCard2ByIdentifier(o.getExternalId());
                String text = "Nota(" + w.getLogin() + ") stearsa:" + " " + Utils.getString2Decimals(total) + " LEI" + " de " + u.getLogin() + " la " + Formatters.currentDateAndTimeForPrinter.format(new Date());
                Map map = this.buildMapForExport(text, new String[0]);
                GenericListenersLogic.getInstance().notifyObjectListeners(1003, map);
                if (VpConfig.getInstance().smsSendAtOrderRemoval) {
                    this.sender.sendSms(text, this.alertDestinations);
                }
            } else {
                this.pool.rollBack();
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Map buildMapForExport(String title, String ... tokens) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        String desc = "<b>" + title + "</b><br/><br/><br/>";
        for (String token : tokens) {
            Vector lines = Utils.splitString(token, '\n');
            for (String line : lines) {
                desc = desc + line + "<br/>";
            }
            desc = desc + "<br/>";
        }
        map.put("node_title", title);
        map.put("node_description", desc);
        return map;
    }

    public void deleteOrderNoCommit(int idOrder) throws SQLException {
        PaymentLogic.getInstance().deleteAllPlatiForOrderAndClientIndexNoCommit(idOrder, -1);
        this.getOrdersDao().deleteOrder(idOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOrderCommit(int idOrder) {
        try {
            this.deleteOrderNoCommit(idOrder);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSalesForOrder(Order o) {
        try {
            this.getOrdersDao().deleteSalesForOrder(o);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public boolean deleteOrderNoCommit(Order o, User u, String explain, Component panel, boolean popup) throws SQLException {
        if (!this.canModifyDocument(3, o.getId())) {
            if (popup) {
                DialogUtils.errorDialog(panel, "Nu puteti sterge aceasta nota de plata", LangRoAll.nuPotContinua);
            }
            return false;
        }
        Vector<Sale> sales = this.getOrdersDao().getSales(o.getId(), false, -1, -1, this.pool.requestConnection().getConnection(), new ScreenSaleInterface());
        if (u != null) {
            UsersLogic.getInstance().addUserLogNoCommit(u.getId(), "Sters nota din : " + Formatters.DATE_AND_TIME_FORMAT.format(new Date(o.getStopTime())) + " total : " + Utils.getString2Decimals(RestLogic.computeTotalForSales(sales)));
        }
        for (Sale sale : sales) {
            Order order = this.getOrderById(sale.getIdOrder());
            Table t = this.getTableById(order.getTable());
            if (order.getStopTime() > this.eventsLogic.getLastOpenDateNoCommit(1).getTime()) {
                this.deleteSaleSimpleStock(sale, order, t, sale.getCantitateMarcata());
            }
            double nrPortii = sale.getCantitateMarcata();
            this.deleteSale(sale, u != null ? u.getId() : -1, explain, nrPortii, u != null);
        }
        PaymentLogic.getInstance().deleteAllPlatiForOrderAndClientIndexNoCommit(o.getId(), -1);
        this.getOrdersDao().deleteOrder(o.getId());
        this.documentDeleted(new Timestamp(o.getStopTime()));
        return true;
    }

    public Vector getLocations() {
        return this.getLocations(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getLocations(int tip) {
        try {
            Vector vector = this.getLocationsNoCommit(tip);
            return vector;
        }
        catch (SQLException ex) {
            Logger.logException(this, (Exception)ex);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector getLocationsNoCommit(int tip) throws SQLException {
        Vector u = (Vector)this.getLocationsDao().getAll(tip);
        Collections.sort(u, new Comparator(){

            public int compare(Object o1, Object o2) {
                return CompareUtils.compareLocations(o1, o2);
            }
        });
        return u;
    }

    public Location getLocationByIdNoCommit(int id) throws SQLException {
        Location result = this.getLocationsDao().getLocationById(id);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocationById(int id) {
        try {
            Location location = this.getLocationByIdNoCommit(id);
            return location;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Location location = null;
            return location;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Location getLocationByNameNoCommit(String name) throws SQLException {
        Location result = this.getLocationsDao().getLocationByName(name);
        return result;
    }

    public Location getLocationByCodNoCommit(String name) throws SQLException {
        Location result = this.getLocationsDao().getLocationByCod(name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocationByCod(String cod) {
        try {
            Location location = this.getLocationByCodNoCommit(cod);
            return location;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocationByName(String name) {
        try {
            Location result;
            Location location = result = this.getLocationByNameNoCommit(name);
            return location;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Location location = null;
            return location;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location addLocation(String name, int tip, String cod) {
        try {
            Location loc = new Location(-1, name, tip, true, cod, true);
            this.getLocationsDao().add(loc);
            int id = this.pool.requestConnection().getIndentityLocal();
            loc.setId(id);
            this.pool.requestConnection().commitTransaction();
            this.notifyListeners(54);
            Location location = loc;
            return location;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Location location = null;
            return location;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLocation(String newName, String oldName, int id) {
        try {
            this.getLocationsDao().update(newName, id);
            int idFile = DocumenteLogic.getInstance().getIdFileByFilenameNoCommit(oldName + ".xml");
            String newLocatieName = newName + ".xml";
            DocumenteLogic.getInstance().updateFileNoCommit(newLocatieName, newLocatieName, idFile);
            this.pool.commit();
        }
        catch (SQLException ex) {
            Logger.logException(this, (Exception)ex);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSearaOrders() {
        boolean result = true;
        try {
            Vector<Order> orders = this.getOrdersDao().getOpenOrders(-1, -1, -1);
            if (orders != null && orders.size() > 0) {
                for (Order toCheck : orders) {
                    Vector<Sale> sales = this.getOrdersDao().getSales(toCheck.getId(), true, -1, -1, this.pool.requestConnection().getConnection(), new ScreenSaleInterface());
                    if (sales.size() != 0) continue;
                    PaymentLogic.getInstance().deleteAllPlatiForOrderAndClientIndexNoCommit(toCheck.getId(), -1);
                    this.getOrdersDao().deleteOrder(toCheck.getId());
                }
            }
            this.pool.commit();
            orders = this.getOrdersDao().getOpenOrders(-1, -1, -1);
            if (orders != null && orders.size() > 0) {
                result = false;
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            result = false;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getOpenOrders(int idClient, int idUser, int idLocatie) {
        try {
            Vector<Order> vector = this.getOrdersDao().getOpenOrders(idClient, idUser, idLocatie);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private boolean getRaportZForUserSectieLocatie(Sectie sectie, Location locatie, int idUser, int what, String[] result) throws SQLException {
        String numeLocatie = "";
        int idLocatie = -1;
        if (locatie != null) {
            idLocatie = locatie.getId();
            numeLocatie = "-" + locatie.getName();
        }
        double[] total = this.getDao().getTotalForSectieAndUser(sectie.getId(), idUser, what, idLocatie);
        double comision = total[2];
        String comString = "";
        if (comision > 0.0) {
            comString = " comision " + Utils.getString2Decimals(comision);
        }
        double t1 = total[0];
        double t2 = total[1];
        if (t1 != 0.0 || t2 != 0.0) {
            String totalString = sectie.getName() + numeLocatie + " " + Utils.getString2Decimals(t1) + ", discount " + Utils.getString2Decimals(t2);
            result[1] = result[1] + totalString + comString + " ; ";
            String string = totalString = VpConfig.getInstance().zPrintTotals ? totalString : "";
            if (totalString.length() > 0 || comString.length() > 0) {
                result[0] = result[0] + "TOTAL " + totalString + comString + "\n";
            }
            return true;
        }
        return false;
    }

    private String[] getRaportZForUser(int idUser, int what, Location location, boolean printMonetar, boolean monetarNewLine) throws SQLException {
        boolean mustPrint = false;
        String[] result = new String[]{"", ""};
        StringBuffer sb2 = new StringBuffer();
        for (Sectie element : this.nomeclaturaLogic.getAllSectii()) {
            boolean mustPrint1 = this.getRaportZForUserSectieLocatie(element, location, idUser, what, result);
            if (!mustPrint1) continue;
            mustPrint = true;
        }
        int idLocatie = -1;
        if (location != null) {
            idLocatie = location.getId();
        }
        double[] totalGeneral = this.getDao().getTotalForSectieAndUser(-1, idUser, what, idLocatie);
        double comision = totalGeneral[2];
        String comString = "";
        if (comision > 0.0) {
            comString = " comision " + Utils.getString2Decimals(comision);
        }
        double t1 = totalGeneral[0];
        double t2 = totalGeneral[1];
        String totalString = Utils.getString2Decimals(t1) + ", discount " + Utils.getString2Decimals(t2);
        result[1] = result[1] + "TOTAL : " + totalString + comString + " Data : " + Formatters.DATE_FORMAT.format(new Date());
        totalString = VpConfig.getInstance().zPrintTotals ? totalString : "";
        result[0] = result[0] + "TOTAL GENERAL " + totalString + comString + "\n";
        sb2.append(result[0]);
        if (mustPrint && printMonetar) {
            sb2.append("\n\nMonetar :\n");
            String[] s2 = this.getZMonetarForUser(idUser, what, idLocatie, monetarNewLine);
            sb2.append(s2[0] + "\n");
            String s = s2[2];
            double documente = Utils.parseDouble(s);
            double numerar = t1 - documente;
            sb2.append("\nTOTAL NUMERAR: " + Utils.getString2Decimals(numerar) + "\n");
        }
        result[0] = sb2.toString();
        if (mustPrint) {
            return result;
        }
        return new String[]{"", ""};
    }

    private String[] getZMonetarForUser(int user, int what, int location, boolean newLine) throws SQLException {
        String[] result = new String[3];
        result[0] = "";
        result[1] = "";
        Hashtable<String, Comparable<Date>> criteria = new Hashtable<String, Comparable<Date>>();
        Timestamp startOfDay = this.eventsLogic.getLastOpenDateNoCommit(1);
        criteria.put(Constants.START_KEY, startOfDay);
        criteria.put(Constants.STOP_KEY, new Date());
        if (user != -1) {
            criteria.put("user_fo", Integer.valueOf(user));
        }
        double totalDocumente = 0.0;
        Vector<SimpleMonetarView> items = this.getZMonetarNoCommit(criteria, what, location);
        for (int i = 0; i < items.size(); ++i) {
            SimpleMonetarView o = items.elementAt(i);
            String s = o.getTipPlata() + "=" + Utils.getString2Decimals(o.getSuma());
            result[0] = result[0] + s + (newLine ? "\n" : ", ");
            result[1] = result[1] + s + (newLine ? "\n" : ", ");
            if (!o.isDocumentPlata()) continue;
            totalDocumente += o.getSuma();
        }
        result[2] = Utils.getString2Decimals(totalDocumente);
        return result;
    }

    public Vector<SimpleMonetarView> getZMonetarNoCommit(Hashtable criteria, int what, int location) throws SQLException {
        return this.getDao().getZMonetar(criteria, what, location);
    }

    public int getNrOrders(Hashtable criteria, int idLocatie) throws SQLException {
        return this.getDao().getNrOrders(criteria, idLocatie);
    }

    public void printXnou(int whatToPrint, User u, Component parent, boolean isAdmin, boolean isWaiter) throws SQLException {
        this.cashRegister.printX();
        String s = "";
        switch (whatToPrint) {
            case 2: {
                break;
            }
            case 3: {
                s = s + ".";
                break;
            }
            case 1: {
                s = s + "..";
                break;
            }
        }
        Vector<Shift> shifts = this.getShifts();
        Shift lastShift = shifts.lastElement();
        this.printZnou("X" + s, whatToPrint, lastShift, u, parent, isAdmin, isWaiter, true);
        if (u != null) {
            this.userLogic.addUserLogNoCommit(u.getId(), "X ");
        }
    }

    public void printZnou(final String numeRaport, final int whatToPrint, final Shift lastShift, final User u, final Component parent, final boolean isAdmin, final boolean isWaiter, final boolean printX) throws SQLException {
        final Vector selectableReports = new Vector();
        try {
            Utils.importXml(new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    block69: {
                        try {
                            Hashtable<String, Object> criteria;
                            Location l;
                            String s;
                            Vector locs;
                            String reportName;
                            Vector allRep;
                            String label;
                            if (qName.equalsIgnoreCase("xreport") && printX) {
                                label = attributes.getValue("selected");
                                allRep = Utils.splitString(label, ',');
                                selectableReports.addAll(allRep);
                            }
                            if (qName.equalsIgnoreCase("zreport") && !printX) {
                                label = attributes.getValue("selected");
                                allRep = Utils.splitString(label, ',');
                                selectableReports.addAll(allRep);
                            }
                            if (!qName.equalsIgnoreCase("reportdef") || !selectableReports.contains(reportName = attributes.getValue("name"))) break block69;
                            String accesType = attributes.getValue("acces");
                            if (accesType.equals("superuser")) {
                                if (!isAdmin) {
                                    return;
                                }
                            } else if (accesType.equals("operator")) {
                                if (!isWaiter) {
                                    return;
                                }
                            } else {
                                return;
                            }
                            boolean isSms = false;
                            String mediumType = attributes.getValue("medium");
                            if (mediumType.equals("sms")) {
                                isSms = true;
                            }
                            boolean askForPrint = false;
                            String askPrintReport = attributes.getValue("askForConfirmation");
                            if (Validators.correctBoolean(askPrintReport)) {
                                askForPrint = Boolean.parseBoolean(askPrintReport);
                            }
                            if (!isSms && askForPrint && !DialogUtils.confirmDialog(parent, "Tiparim \"" + reportName + "\"", LangRoAll.confirmare)) break block69;
                            String reportType = attributes.getValue("reporttype");
                            String locationType = attributes.getValue("location");
                            String userType = attributes.getValue("user");
                            String userorderType = attributes.getValue("userorder");
                            String locationorderType = attributes.getValue("locationorder");
                            Vector<Integer> users = new Vector<Integer>();
                            if (userType.equals("ask")) {
                                User user = (User)DialogUtils.getItemChooserDialog(RestLogic.this.getWaiters(), 4, true);
                                if (user != null) {
                                    users.add(user.getId());
                                } else {
                                    userType = "all";
                                }
                            } else if (userType.equals("login")) {
                                users.add(u.getId());
                            }
                            if (userType.equals("all")) {
                                if (userorderType.equals("allatonce")) {
                                    users.add(-1);
                                } else if (userorderType.equals("onebyone")) {
                                    Vector allUsers = RestLogic.this.getWaiters();
                                    for (User user : allUsers) {
                                        users.add(user.getId());
                                    }
                                }
                            }
                            Vector<Integer> locations = new Vector<Integer>();
                            String numeLocatie = "";
                            if (locationType.equals("ask")) {
                                Location l2;
                                locs = new Vector();
                                for (Object loc : TouchMain2.locations) {
                                    s = (String)loc;
                                    l = RestLogic.this.getLocationByName(s);
                                    locs.add(l);
                                }
                                if (locs.size() == 0) {
                                    locs = RestLogic.this.getLocations();
                                }
                                if ((l2 = (Location)DialogUtils.getItemChooserDialog(locs, 4, true)) != null) {
                                    numeLocatie = l2.getName();
                                    locations.add(l2.getId());
                                } else {
                                    locationType = "start";
                                }
                            } else if (locationType.equals("ask-all")) {
                                Location l3 = (Location)DialogUtils.getItemChooserDialog(RestLogic.this.getLocations(), 4, true);
                                if (l3 != null) {
                                    numeLocatie = l3.getName();
                                    locations.add(l3.getId());
                                } else {
                                    locationType = "all";
                                }
                            }
                            if (locationType.equals("start")) {
                                locs = TouchMain2.locations;
                                for (Object loc : locs) {
                                    s = (String)loc;
                                    l = RestLogic.this.getLocationByName(s);
                                    locations.add(l.getId());
                                    numeLocatie = numeLocatie + l.getName() + ",";
                                }
                                if (locs.size() == 0) {
                                    locationType = "all";
                                }
                            }
                            if (locationType.equals("all")) {
                                if (locationorderType.equals("allatonce")) {
                                    locations.add(-1);
                                    numeLocatie = "Toate locatiile";
                                } else if (locationorderType.equals("onebyone")) {
                                    Vector allLocations = RestLogic.this.getLocations();
                                    for (Location location : allLocations) {
                                        locations.add(location.getId());
                                    }
                                }
                            }
                            if (reportType.equals("totalvenue")) {
                                for (Integer locationIf : locations) {
                                    Location location;
                                    location = RestLogic.this.getLocationById(locationIf);
                                    for (Integer user : users) {
                                        String[] ss = RestLogic.this.getRaportZForUser(user, whatToPrint, location, true, false);
                                        String numeOperator = "Toti Operatorii";
                                        if (user != -1) {
                                            User u2 = UsersLogic.getInstance().getUserById(user);
                                            numeOperator = u2.getLogin();
                                        }
                                        String reportTitle = RestLogic.getReportTitleNou(lastShift, reportName, numeOperator, numeLocatie, numeRaport);
                                        Map map = RestLogic.this.buildMapForExport(reportTitle, ss[0]);
                                        GenericListenersLogic.getInstance().notifyObjectListeners(1007, map);
                                        if (isSms) {
                                            if (ss[1].length() <= 0) continue;
                                            RestLogic.this.sender.sendSms(ss[1], RestLogic.this.alertDestinations);
                                            continue;
                                        }
                                        if (ss[0].length() <= 0) continue;
                                        RestLogic.this.printer.printRaportInchidere(reportTitle, ss[0], 1);
                                    }
                                }
                                break block69;
                            }
                            if (reportType.equals("products")) {
                                criteria = new Hashtable<String, Object>();
                                Timestamp startOfDay = RestLogic.this.eventsLogic.getLastOpenDateNoCommit(1);
                                criteria.put(Constants.START_KEY, startOfDay);
                                criteria.put(Constants.STOP_KEY, new Date());
                                criteria.put("tip_produs_key", "All");
                                boolean isProtocol = false;
                                String includeOnthehouse = attributes.getValue("onTheHouseFilter");
                                if (includeOnthehouse.equals("onthehouseonly")) {
                                    criteria.put("Tip protocol", "true");
                                    isProtocol = true;
                                }
                                if (includeOnthehouse.equals("paidonly")) {
                                    criteria.put("Tip protocol", "false");
                                }
                                for (Integer locationId : locations) {
                                    Location location = RestLogic.this.getLocationById(locationId);
                                    if (location != null) {
                                        numeLocatie = location.getName();
                                    }
                                    for (Integer user : users) {
                                        String numeOperator = "Toti Operatorii";
                                        User u3 = null;
                                        if (user != -1) {
                                            u3 = UsersLogic.getInstance().getUserById(user);
                                            numeOperator = u3.getLogin();
                                        }
                                        File salesFile = new File(FileUtils.getCurrentDir() + File.separator + reportName + ".xls");
                                        if (u3 != null) {
                                            criteria.put(Constants.WAITER_KEY, u3.getId());
                                        }
                                        if (locationId > 0) {
                                            criteria.put(Constants.LOCATIE_KEY, locationId);
                                        }
                                        Vector<SalesEntry> sales = RestLogic.this.getSalesReport(criteria, whatToPrint);
                                        if (attributes.getValue("medium").equals("excel")) {
                                            try {
                                                ExcelUtils.writeExcel(salesFile, sales, new SalesExcelProcessor(), new Hashtable());
                                            }
                                            catch (IOException e) {
                                                Logger.logException(this, (Exception)e);
                                            }
                                            catch (WriteException e) {
                                                Logger.logException(this, (Exception)((Object)e));
                                            }
                                        }
                                        Collections.sort(sales, new Comparator(){

                                            public int compare(Object o1, Object o2) {
                                                SalesEntry se1 = (SalesEntry)o1;
                                                SalesEntry se2 = (SalesEntry)o2;
                                                if (se1.getCategory().equalsIgnoreCase(se2.getCategory())) {
                                                    if (se1.getProduct().equalsIgnoreCase(se2.getProduct())) {
                                                        return (int)(se1.getPrice() - se2.getPrice());
                                                    }
                                                    return se1.getProduct().compareToIgnoreCase(se2.getProduct());
                                                }
                                                return se1.getCategory().compareToIgnoreCase(se2.getCategory());
                                            }
                                        });
                                        if (sales.size() == 0) continue;
                                        String sectiiFilter = VpConfig.getInstance().zPrintSalesSectiiFilter;
                                        if (Validators.correctString(sectiiFilter)) {
                                            Vector items = Utils.splitString(sectiiFilter, ',');
                                            for (int i = 0; i < items.size(); ++i) {
                                                String sectie = (String)items.elementAt(i);
                                                StringBuffer s2 = RestLogic.this.generateZSalesReport(sales, sectie, true, true, true, isProtocol);
                                                String reportTitle = RestLogic.getReportTitleNou(lastShift, reportName, numeOperator, numeLocatie, numeRaport);
                                                Map map = RestLogic.this.buildMapForExport(reportTitle, s2.toString());
                                                GenericListenersLogic.getInstance().notifyObjectListeners(1007, map);
                                                RestLogic.this.printer.printRaportInchidere(reportTitle, s2.toString(), 1);
                                            }
                                            continue;
                                        }
                                        StringBuffer s2 = RestLogic.this.generateZSalesReport(sales, null, true, true, true, isProtocol);
                                        String reportTitle = RestLogic.getReportTitleNou(lastShift, reportName, numeOperator, numeLocatie, numeRaport);
                                        Map map = RestLogic.this.buildMapForExport(reportTitle, s2.toString());
                                        GenericListenersLogic.getInstance().notifyObjectListeners(1007, map);
                                        RestLogic.this.printer.printRaportInchidere(reportTitle, s2.toString(), 1);
                                    }
                                }
                                break block69;
                            }
                            if (reportType.equals("corrections")) {
                                criteria = new Hashtable();
                                criteria.put(Constants.START_KEY, lastShift.getStart());
                                criteria.put(Constants.STOP_KEY, lastShift.getStop());
                                Vector data = RestLogic.this.getCorrections(criteria);
                                double suma = 0.0;
                                for (CorrectionsEntry entry : data) {
                                    suma += entry.getSuma();
                                }
                                final double totalSuma = suma;
                                final Hashtable<String, String> printCriteria = new Hashtable<String, String>();
                                printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(lastShift.getStart()));
                                printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(lastShift.getStop()));
                                ReportInterface asciiReportInterface = new ReportInterface(){

                                    @Override
                                    public int getColumnCount() {
                                        return 1;
                                    }

                                    @Override
                                    public int getColumnSize(int column) {
                                        return 1;
                                    }

                                    @Override
                                    public String getColumnName(int column) {
                                        switch (column) {
                                            case 0: {
                                                return LangRoAll.produs + "|" + LangRoAll.cantitate + "|" + LangRoAll.valoare;
                                            }
                                        }
                                        return null;
                                    }

                                    @Override
                                    public String getTotal(int column) {
                                        if (column == 0) {
                                            String s = LangRoAll.total + ": " + Utils.getString2Decimals(totalSuma);
                                            return s;
                                        }
                                        return "";
                                    }

                                    @Override
                                    public String getReportTitle() {
                                        return "Raport corectii";
                                    }

                                    @Override
                                    public Hashtable getCriteria() {
                                        return printCriteria;
                                    }

                                    @Override
                                    public boolean isLandscape() {
                                        return false;
                                    }

                                    @Override
                                    public String getCellContent(Object row, int column) {
                                        CorrectionsEntry fe = (CorrectionsEntry)row;
                                        if (fe == null) {
                                            return null;
                                        }
                                        if (column == 0) {
                                            String s = fe.getWaiterName() + "|" + fe.getSupervisorName() + "|" + fe.getProdus() + "|" + Utils.getString3Decimals(fe.getQuantity()) + "|" + Utils.getString2Decimals(fe.getSuma()) + "|" + fe.getDate();
                                            return s;
                                        }
                                        return "";
                                    }
                                };
                                PrintLogic.getInstance().printReport(parent, asciiReportInterface, asciiReportInterface, data);
                                String asciiContent = PrintLogic.getInstance().buildReportAsciiText(data, asciiReportInterface);
                                Map map = RestLogic.this.buildMapForExport(asciiReportInterface.getReportTitle() + " " + Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date()), asciiContent);
                                GenericListenersLogic.getInstance().notifyObjectListeners(1007, map);
                            } else if (reportType.equals("stocks")) {
                                String magaziiAtribute = attributes.getValue("magazii");
                                String magaziiOrder = attributes.getValue("magaziiorder");
                                String medium = attributes.getValue("medium");
                                Vector<Magazie> magazii = RestLogic.this.stockLogic.getMagazii();
                                Vector listaMagaziiDorite = null;
                                if (magaziiAtribute.equalsIgnoreCase("*")) {
                                    if (magaziiOrder.equalsIgnoreCase("allatonce")) {
                                        RestLogic.this.doPrintOrWriteExcelForZStocks(null, medium, lastShift);
                                    } else {
                                        for (int i = 0; i < magazii.size(); ++i) {
                                            Magazie m = magazii.elementAt(i);
                                            RestLogic.this.doPrintOrWriteExcelForZStocks(m, medium, lastShift);
                                        }
                                    }
                                } else {
                                    listaMagaziiDorite = Utils.splitString(magaziiAtribute, ',');
                                    for (int i = 0; i < magazii.size(); ++i) {
                                        Magazie m = magazii.elementAt(i);
                                        if (!listaMagaziiDorite.contains(m.getLabel())) continue;
                                        RestLogic.this.doPrintOrWriteExcelForZStocks(m, medium, lastShift);
                                    }
                                }
                            }
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                        }
                    }
                }
            }, FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + "closereports.xml");
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SAXException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void doPrintOrWriteExcelForZStocks(Magazie m, String medium, Shift lastShift) {
        int idMagazie = -1;
        String numeMagazie = "ALL";
        if (m != null) {
            idMagazie = m.getId();
            numeMagazie = m.getLabel();
        }
        Vector<StockViewEntry> stocks = this.stockLogic.getStocksViewsForMagazie(idMagazie, -1, -1, -1, false, -1, -1);
        if (medium.equalsIgnoreCase("excel")) {
            File destination = new File(FileUtils.getCurrentDir() + File.separator + "stock_" + numeMagazie + ".xls");
            try {
                ExcelUtils.writeExcel(destination, stocks, new StockExcelProcessor("Stoc " + numeMagazie, StockViewPanel.columns), new Hashtable());
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
            }
            catch (WriteException e) {
                Logger.logException(this, (Exception)((Object)e));
            }
        } else if (medium.equalsIgnoreCase("print")) {
            this.printZStock(stocks, numeMagazie, lastShift);
        }
    }

    public void printX(int whatToPrint, User u, int idLocatie) throws SQLException {
        this.cashRegister.printX();
        String s = "";
        switch (whatToPrint) {
            case 2: {
                break;
            }
            case 3: {
                s = s + ".";
                break;
            }
            case 1: {
                s = s + "..";
                break;
            }
        }
        Vector<Shift> shifts = this.getShifts();
        Shift lastShift = shifts.lastElement();
        boolean allReports = false;
        allReports = UsersLogic.getInstance().isUserInGroup(u.getId(), "group_bo_users");
        this.printZ("X" + s, whatToPrint, lastShift, u, allReports, idLocatie, false);
        if (u != null) {
            this.userLogic.addUserLogNoCommit(u.getId(), "X ");
        }
    }

    private void printZ(String reportType, int whatToPrint, Shift lastShift, User u, boolean allReports, int locationId, boolean zReport) throws SQLException {
        String locatieName = "Toate locatiile";
        Location location = this.getLocationById(locationId);
        if (location != null) {
            locatieName = location.getName();
        }
        String reportTitle = RestLogic.getReportTitle(lastShift, reportType + locatieName + " ");
        if (allReports) {
            StringBuffer sb1 = new StringBuffer();
            String[] ss = this.getRaportZForUser(-1, whatToPrint, location, false, true);
            sb1.append(ss[0]);
            if (VpConfig.getInstance().zPrintTotals) {
                sb1.append("Monetar :\n");
                String[] ss2 = this.getZMonetarForUser(-1, whatToPrint, locationId, true);
                sb1.append(ss2[0]);
            }
            this.printer.printRaportInchidere(reportTitle, sb1.toString(), 1);
            this.sender.sendSms(ss[1], this.alertDestinations);
        }
        if (VpConfig.getInstance().zDetaliiOspatari) {
            StringBuffer sb2 = new StringBuffer();
            Vector users = this.getWaiters();
            for (int i = 0; i < users.size(); ++i) {
                String[] s1;
                User o = (User)users.elementAt(i);
                if (!allReports && o.getId() != u.getId() || !Validators.correctString((s1 = this.getRaportZForUser(o.getId(), whatToPrint, location, false, true))[0]) || !Validators.correctString(s1[1])) continue;
                sb2.append("Detalii operator : " + o.getLogin() + "\n");
                sb2.append(s1[0]);
                if (VpConfig.getInstance().zPrintTotals) {
                    sb2.append("Monetar :\n");
                    String[] s2 = this.getZMonetarForUser(o.getId(), whatToPrint, locationId, true);
                    sb2.append(s2[0] + "\n");
                }
                sb2.append('\n');
            }
            this.printer.printRaportInchidere(reportTitle, sb2.toString(), 1);
        }
        if (VpConfig.getInstance().zPrintProtocol && VpConfig.getInstance().zPrintTotals) {
            if (allReports) {
                this.printProtocol(lastShift, null, locationId);
            } else {
                this.printProtocol(lastShift, u, locationId);
            }
        }
        if (allReports && VpConfig.getInstance().zRaportOspatari && VpConfig.getInstance().zPrintTotals) {
            this.printIncasari(whatToPrint, lastShift, locationId);
        }
        Hashtable<String, Object> criteria = new Hashtable<String, Object>();
        Timestamp startOfDay = this.eventsLogic.getLastOpenDateNoCommit(1);
        criteria.put(Constants.START_KEY, startOfDay);
        criteria.put(Constants.STOP_KEY, new Date());
        criteria.put("tip_produs_key", "All");
        File salesFile = new File(FileUtils.getCurrentDir() + File.separator + "vanzari.xls");
        if (!allReports) {
            criteria.put(Constants.WAITER_KEY, u.getId());
        }
        if (locationId > 0) {
            criteria.put(Constants.LOCATIE_KEY, locationId);
        }
        Vector<SalesEntry> sales = this.getSalesReport(criteria, whatToPrint);
        try {
            ExcelUtils.writeExcel(salesFile, sales, new SalesExcelProcessor(), new Hashtable());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        if (allReports && VpConfig.getInstance().zPrintSales) {
            Collections.sort(sales, new Comparator(){

                public int compare(Object o1, Object o2) {
                    SalesEntry se1 = (SalesEntry)o1;
                    SalesEntry se2 = (SalesEntry)o2;
                    if (se1.getCategory().equalsIgnoreCase(se2.getCategory())) {
                        if (se1.getProduct().equalsIgnoreCase(se2.getProduct())) {
                            return (int)(se1.getPrice() - se2.getPrice());
                        }
                        return se1.getProduct().compareToIgnoreCase(se2.getProduct());
                    }
                    return se1.getCategory().compareToIgnoreCase(se2.getCategory());
                }
            });
            String sectiiFilter = VpConfig.getInstance().zPrintSalesSectiiFilter;
            if (Validators.correctString(sectiiFilter)) {
                Vector items = Utils.splitString(sectiiFilter, ',');
                for (int i = 0; i < items.size(); ++i) {
                    String s = (String)items.elementAt(i);
                    this.printZSales(sales, lastShift, s);
                }
            } else {
                this.printZSales(sales, lastShift, null);
            }
        }
        if (zReport && allReports) {
            Vector<Magazie> magazii = this.stockLogic.getMagazii();
            for (int i = 0; i < magazii.size(); ++i) {
                Magazie m = magazii.elementAt(i);
                Hashtable<String, Integer> result = new Hashtable<String, Integer>();
                result.put("id_magazie", m.getId());
                Vector<StockViewEntry> stocks = this.stockLogic.getStocksViewsForMagazie(m.getId(), -1, -1, -1, false, -1, -1);
                File destination = new File(FileUtils.getCurrentDir() + File.separator + "stock_" + m.getLabel() + ".xls");
                try {
                    ExcelUtils.writeExcel(destination, stocks, new StockExcelProcessor("Stoc " + m.getLabel(), StockViewPanel.columns), new Hashtable());
                }
                catch (IOException e) {
                    Logger.logException(this, (Exception)e);
                }
                catch (WriteException e) {
                    Logger.logException(this, (Exception)((Object)e));
                }
                if (!VpConfig.getInstance().zPrintStoc) continue;
                this.printZStock(stocks, m.getLabel(), lastShift);
            }
        }
    }

    public Vector getRaportProductie(Hashtable criteria) {
        try {
            Vector result = this.getDao().getRaportProductie(criteria);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return result;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return new Vector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCorrections(Hashtable criteria) {
        try {
            Vector result;
            Vector vector = result = this.getDao().getCorrections(criteria);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getMonetar(Hashtable criteria, int what) {
        try {
            Vector result;
            Vector vector = result = this.getDao().getMonetar(criteria, what);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<NoteView> getNote(Hashtable criteria, boolean siNoteDeschise, int what) {
        Vector<NoteView> result = new Vector();
        try {
            result = this.getDao().getNote(criteria, siNoteDeschise, what);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector<IncasareClientView> getIncasariClientiNoCommit(Hashtable criteria, int what) throws SQLException {
        return this.getDao().getIncasariClienti(criteria, what);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<IncasareClientView> getIncasariClienti(Hashtable criteria, int what) {
        try {
            Vector<IncasareClientView> result;
            Vector<IncasareClientView> vector = result = this.getIncasariClientiNoCommit(criteria, what);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<IncasareClientView> vector = new Vector<IncasareClientView>();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ClientiPeZileBean> getClientiPeZile(Hashtable criteria) {
        try {
            Vector<ClientiPeZileBean> result;
            Vector<ClientiPeZileBean> vector = result = this.getDao().getClientiPeZileReport(criteria);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<ClientiPeZileBean> vector = new Vector<ClientiPeZileBean>();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void printProtocol(Shift lasShift, User u, int idLocatie) throws SQLException {
        Collection result = this.getDao().getProtocol(u, idLocatie);
        String s = "";
        double total = 0.0;
        for (ProtocolEntry element : result) {
            String name = element.getName();
            String produs = element.getProdus();
            double value = element.getQuantity() * element.getPret();
            s = s + name + " " + produs + " " + element.getQuantity() + " * " + Utils.getString2Decimals(element.getPret()) + " = " + Utils.getString2Decimals(value) + "\n";
            total += value;
        }
        s = s + "\nTOTAL PROTOCOL: " + total + "\n";
        String reportTitle = RestLogic.getReportTitle(lasShift, LangRoAll.protocol);
        this.printer.printRaportInchidere(reportTitle, s, 1);
    }

    public void printZStock(Vector stocks, String magazie, Shift lastShift) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < stocks.size(); ++i) {
            StockViewEntry o = (StockViewEntry)stocks.elementAt(i);
            s.append(o.getNume());
            s.append(':');
            s.append(' ');
            s.append(Utils.getString3Decimals(o.getStocActual()));
            s.append('\n');
        }
        String reportTytle = RestLogic.getReportTitle(lastShift, "Stocuri " + magazie);
        this.printer.printRaportInchidere(reportTytle, s.toString(), 1);
    }

    public static String getReportTitle(Shift lastShift, String reportTitle) {
        return reportTitle + " nr: " + lastShift.getNr() + "\ndeschidere la: " + Formatters.DATE_AND_TIME_FORMAT.format(lastShift.getStart()) + "\ntiparit la: " + Utils.getCurrentDateAndTimeForPrinter();
    }

    public static String getReportTitleNou(Shift lastShift, String reportTitle, String operatori, String locatie, String reportType) {
        String s = reportType + " " + " nr: " + lastShift.getNr();
        s = s + "\ndeschidere la: " + Formatters.DATE_AND_TIME_FORMAT.format(lastShift.getStart());
        s = s + "\ntiparit la: " + Utils.getCurrentDateAndTimeForPrinter();
        s = s + "\n" + reportTitle + "-" + operatori + "-" + locatie + "\n";
        return s;
    }

    private StringBuffer generateZSalesReport(Vector sales, String sectie, boolean printQuantity, boolean printPrice, boolean printValue, boolean isProtocol) throws SQLException {
        int charsPerLine = Config.getInstance().getInt("charsPerLine");
        double total = 0.0;
        StringBuffer s = new StringBuffer();
        for (SalesEntry element : sales) {
            String s2;
            if (Validators.correctString(sectie) && !(s2 = element.getCategory()).equalsIgnoreCase(sectie)) continue;
            int size = 1;
            String end = "";
            if (printQuantity) {
                String cantitate = Utils.getString2Decimals(element.getQuantity());
                end = end + cantitate;
            }
            if (printPrice) {
                end = isProtocol ? end + "*" + Utils.getString2Decimals(element.getOriginalPrice()) : end + "*" + Utils.getString2Decimals(element.getPrice());
            }
            double val = 0.0;
            val = isProtocol ? element.getDiscount() * element.getQuantity() : element.getTotalValue();
            total += val;
            if (printValue) {
                end = end + "=" + Utils.getString2Decimals(val);
            }
            size += end.length();
            String name = element.getProduct();
            if (element.getIdPromotion() != -1) {
                name = name + " ";
                name = name + element.getPromotion();
            }
            name = Utils.getStringMaxSize(charsPerLine - size, name, Character.valueOf(' '), false);
            s.append(name);
            s.append(' ');
            s.append(end);
            s.append('\n');
        }
        String end = Utils.getString2Decimals(total);
        String t = Utils.getStringMaxSize(charsPerLine - end.length() - 1, "TOTAL", Character.valueOf(' '), false);
        s.append('\n');
        s.append(t);
        s.append(' ');
        s.append(end);
        s.append('\n');
        return s;
    }

    public void printZSales(Vector sales, Shift lastShift, String sectie) throws SQLException {
        StringBuffer s = this.generateZSalesReport(sales, sectie, true, true, true, false);
        String suffix = "";
        if (Validators.correctString(sectie)) {
            suffix = " " + sectie;
        }
        String reportTytle = RestLogic.getReportTitle(lastShift, LangRoAll.vanzari + suffix);
        this.printer.printRaportInchidere(reportTytle, s.toString(), 1);
    }

    public void printIncasari(int what, Shift lastShift, int idLocatie) throws SQLException {
        Collection result = this.getDao().getIncasari(what, idLocatie);
        String s = "";
        for (SimpleIncasariEntry element : result) {
            s = s + element.getName() + " " + Utils.getString2Decimals(element.getSuma()) + "\n";
        }
        String reportTytle = RestLogic.getReportTitle(lastShift, "Incasari");
        this.printer.printRaportInchidere(reportTytle, s, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean seara(int whatToPrint, Shift lastShift, User user, Component parent) {
        try {
            this.cashRegister.printZ();
            String s = "";
            switch (whatToPrint) {
                case 2: {
                    break;
                }
                case 3: {
                    s = s + ".";
                    break;
                }
                case 1: {
                    s = s + "..";
                    break;
                }
            }
            if (VpConfig.getInstance().zUserNewPrintingSystem) {
                boolean bl;
                boolean bl2 = false;
                boolean isWaiter = false;
                if (UsersLogic.getInstance().isUserInGroup(user.getId(), "group_bo_users")) {
                    bl = true;
                }
                if (!bl && VpConfig.getInstance().touch2AllowSearaReportByWaiters) {
                    isWaiter = true;
                }
                boolean canPrint = false;
                if (isWaiter || bl) {
                    canPrint = true;
                }
                if (canPrint) {
                    this.printZnou("Z" + s, whatToPrint, lastShift, user, parent, bl, isWaiter, false);
                }
            } else {
                int bl = RestLogic.getIdLocatieForXZReports(this.getLocations());
                this.printZ("Z" + s, whatToPrint, lastShift, user, true, bl, true);
            }
            this.processDay();
            this.eventsLogic.closeDay(1);
            this.eventsLogic.openDay(1);
            this.notifyListeners(6);
            if (this.productie != null) {
                this.productie.deleteAll();
            }
            if (user != null) {
                this.userLogic.addUserLogNoCommit(user.getId(), "Seara ");
            }
            this.pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException sQLException) {
                Logger.logException(this, (Exception)sQLException);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public static int getIdLocatieForXZReports(Vector locatii) {
        if (locatii.size() > 0 && VpConfig.getInstance().zPrintTotalsForSectieAndLocatie) {
            if (locatii.size() > 1) {
                LocatiiDialog dia = new LocatiiDialog(5, locatii);
                int idLocatie = dia.getIdLocatie();
                return idLocatie;
            }
            Location l = (Location)locatii.get(0);
            return l.getId();
        }
        return -1;
    }

    private void cleanupSalesNoCommit() throws SQLException {
        this.getBonsDao().processAllBons();
        this.getSalesDao().deleteFromSales();
        PaymentLogic.getInstance().deleteAllPlati();
        this.getOrdersDao().deleteAllOrders();
        this.getCorrectionsDao().deleteCorrections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteNFOrders() {
        try {
            this.getDao().deleteAllDocumentsNF(this.pool.requestConnection().getConnection());
            this.getSalesDao().deleteFromSalesNF();
            PaymentLogic.getInstance().deleteAllPlatiNF();
            this.getOrdersDao().deleteAllOrdersNF();
            Vector<Integer> ids = this.getOrdersDao().getOrderIdsByTipPlata(VpConfig.getInstance().tipPlataRosu);
            if (ids.size() > 0) {
                this.getDao().deleteOrdersByOrdersIds(this.pool.requestConnection().getConnection(), ids);
            }
            this.pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupSales() {
        try {
            this.cleanupSalesNoCommit();
            this.deleteAllDocuments(3);
            this.deleteAllDocuments(13);
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupRecipes() {
        try {
            this.cleanupRecipesNoCommit();
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.requestConnection().rollback();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void cleanupRecipesNoCommit() throws SQLException {
        this.getProductsDao().deleteAllRecipes();
    }

    public void processDay() throws SQLException {
        Logger.logDebug(this, "===== Processing day");
        this.getOrdersDao().processAllOrders();
        this.getBonsDao().processAllBons();
        this.getCorrectionsDao().processCorrections();
        Logger.logDebug(this, "===== Day processed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdineServire getOrdineServireByLabel(String label) {
        OrdineServire result = null;
        try {
            result = this.getSalesDao().getOrdineServireByLabel(label);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector<OrdineServire> getOrdineServireNoCommit(int idOrdineServire) throws SQLException {
        Vector<OrdineServire> result = this.getSalesDao().getOrdineServire(idOrdineServire);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<OrdineServire> getOrdineServire(int idOrdineServire) {
        Vector<OrdineServire> result = new Vector();
        try {
            result = this.getOrdineServireNoCommit(idOrdineServire);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public void addOrdineServire(String servire) {
        try {
            this.getSalesDao().addOrdineServire(servire);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            this.notifyListeners(9);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void deleteOrdineServire(OrdineServire toDelete) {
        try {
            this.getSalesDao().deleteOrdineServire(toDelete.getId());
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            this.notifyListeners(9);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getModuriPreparare() {
        try {
            Vector result;
            Vector vector = result = this.getMpDao().getModuriPreparare(-1);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getModPreparareById(int id) {
        try {
            Vector result;
            Vector vector = result = this.getMpDao().getModuriPreparare(id);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModPreparare(String modPreparare) {
        try {
            this.getMpDao().addModPreparare(modPreparare);
            this.pool.commit();
            this.notifyListeners(7);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void deleteModPreparare(ModPreparare toDelete) {
        try {
            this.getMpDao().deleteModPreparare(toDelete.getId());
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            this.notifyListeners(7);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public String deleteImpediments(Categorie sub) {
        String promotions = PromotionLogic.getInstance().getPromotionsThatUseSubcategory(sub.getId());
        if (promotions != null && promotions.length() > 0) {
            return "Urmatoarele promotii folosesc aceasta categorie. Va rugam stergeti-le.\n\"" + promotions + "\"";
        }
        return null;
    }

    public Vector getProductsThatUseIngredientNoCommit(int ingrId) throws SQLException {
        Vector<String> result = new Vector<String>();
        Vector produse = this.getProductsDao().getProductsThatUseIngredient(ingrId);
        for (String element : produse) {
            result.add(element);
        }
        return result;
    }

    public StockLogic getStockLogic() {
        return this.stockLogic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<RecipeEntry> getRecipesForCategory(int idSectie, int idCategorie, int idProdus) {
        try {
            Vector<RecipeEntry> result;
            Vector<RecipeEntry> vector = result = this.getRecipesForCategoryNoCommit(idSectie, idCategorie, idProdus);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<RecipeEntry> vector = new Vector<RecipeEntry>();
            return vector;
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<RecipeEntry> getRecipesForCategoryNoCommit(int idSectie, int idCategorie, int idProdus) throws SQLException {
        return this.getProductsDao().getRecipeEntries(idSectie, idCategorie, idProdus);
    }

    public Vector getPdaMeseEntries() {
        Vector<PdaMeseEntry> result = new Vector<PdaMeseEntry>();
        try {
            Vector<Table> tables = this.getTablesDao().getTables(1);
            for (int i = 0; i < tables.size(); ++i) {
                Table o = tables.elementAt(i);
                PdaMeseEntry pme = new PdaMeseEntry();
                pme.setMasa(this.getFullNameForTable(o.getLabel(), o.getIdLocatie()));
                pme.setIdMasa(o.getId());
                Vector activePdas = this.getDao().getPdaMese(o.getId());
                this.pool.requestConnection().commitTransaction();
                this.pool.releaseConnection();
                boolean[] data = new boolean[VpConfig.getInstance().noOfPdas];
                for (int j = 0; j < activePdas.size(); ++j) {
                    Integer o1 = (Integer)activePdas.elementAt(j);
                    data[o1.intValue() - 1] = true;
                }
                pme.setPdas(data);
                result.add(pme);
            }
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        return result;
    }

    public void savePdaMeseEntries(Vector entries) {
        try {
            this.getDao().deletePdaMese();
            for (PdaMeseEntry element : entries) {
                for (int i = 1; i <= VpConfig.getInstance().noOfPdas; ++i) {
                    if (!element.getPdas()[i - 1]) continue;
                    this.getDao().addPdaMasa(element.getIdMasa(), i);
                }
            }
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public Vector getPdaUsersEntries() {
        Vector<PdaUsersEntry> result = new Vector<PdaUsersEntry>();
        try {
            Vector users = this.getWaiters();
            for (int i = 0; i < users.size(); ++i) {
                User o = (User)users.elementAt(i);
                PdaUsersEntry pme = new PdaUsersEntry();
                pme.setUser(o.getLogin());
                pme.setIdUser(o.getId());
                int idPda = this.getDao().getPdaUsers(o.getId());
                pme.setPda(idPda);
                result.add(pme);
            }
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePdaUser(int idPda) {
        try {
            this.getDao().deletePdaUsers(idPda);
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPdaUser(int idPda, int idUser) {
        try {
            this.getDao().addPdaUser(idUser, idPda);
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePdaUsersEntries(Vector entries) {
        try {
            this.getDao().deletePdaUsers(-1);
            for (PdaUsersEntry element : entries) {
                if (element.getPda() <= 0) continue;
                this.getDao().addPdaUser(element.getIdUser(), element.getPda());
            }
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public String getFullNameForTable(String tableName, int idLocation) {
        return tableName + " " + this.getLocationById(idLocation).getName();
    }

    public String getFullNameForTableForLivrari(int idOrder, int idLocation, String ora, String adresaClient, String telefon) {
        return ora + " " + this.getLocationById(idLocation).getName() + " " + idOrder + ", " + adresaClient + ", " + telefon;
    }

    public String getFullNameForTableForLivrariLabel(String ora, int idOrder, int idLocation) throws SQLException {
        return ora + " " + idOrder + " " + this.getLocationByIdNoCommit(idLocation).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<SectieMagazieEntry> getSectieMagazieEntries() {
        Vector<SectieMagazieEntry> result = new Vector<SectieMagazieEntry>();
        Vector<Sectie> sectii = this.nomeclaturaLogic.getAllSectii();
        Vector locatii = this.getLocations();
        try {
            for (Sectie sectie : sectii) {
                for (int i = 0; i < locatii.size(); ++i) {
                    Location location = (Location)locatii.elementAt(i);
                    SectieMagazieEntry sme = new SectieMagazieEntry();
                    sme.setSectie(sectie.getName());
                    sme.setIdSectie(sectie.getId());
                    sme.setIdLocatie(location.getId());
                    sme.setLocatie(location.getName());
                    Vector<Magazie> data = this.getMagaziiForSectieAndLocatieNoCommit(sectie.getId(), location.getId());
                    sme.setValues(data);
                    result.add(sme);
                }
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Magazie> getMagaziiForSectieAndLocatieCommit(int idSectie, int idLocatie) {
        try {
            Vector<Magazie> vector = this.getMagaziiForSectieAndLocatieNoCommit(idSectie, idLocatie);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Magazie> vector = new Vector<Magazie>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<Magazie> getMagaziiForSectieAndLocatieNoCommit(int idSectie, int idLocatie) throws SQLException {
        return this.getPosDao().getMagaziiSectii(idSectie, idLocatie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSectieMagaziiEntries(Vector entries) {
        try {
            this.getPosDao().deleteAll();
            for (SectieMagazieEntry element : entries) {
                Vector values = element.getValues();
                for (int i = 0; i < values.size(); ++i) {
                    Magazie m = (Magazie)values.get(i);
                    this.getPosDao().addMagazieSectie(element.getIdSectie(), m.getId(), element.getIdLocatie());
                }
            }
            this.magazieByProductsLocationsHash.clear();
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    @Override
    public double getPriceForProductNoCommit(int idProduct) throws SQLException {
        double result = -1.0;
        int idReteta = this.getProductsDao().getIdRetetaForProduct(idProduct);
        if (idReteta > 0) {
            result = this.getProductsDao().getPriceForRetetaProduct(idReteta);
        } else {
            int idStock = this.getIdStockNoCommit(idProduct);
            result = this.stockLogic.getCatalogPriceForStockNoCommit(idStock);
        }
        result = FloatUtils.roundFloat(result, 2);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getPriceForProductCommit(int idProduct) {
        try {
            double d = this.getPriceForProductNoCommit(idProduct);
            return d;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            double d = -1.0;
            return d;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriceForRetetaProduct(int idReteta, double newPrice, boolean notify) {
        try {
            this.setPriceForRetetaProductNoCommit(idReteta, newPrice);
            this.pool.commit();
            if (notify) {
                this.notifyListeners(2);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void setPriceForRetetaProductNoCommit(int idReteta, double newPrice) throws SQLException {
        this.getProductsDao().setPriceForRetetaProduct(idReteta, newPrice);
    }

    public void printPLU(Component parent) {
        Vector sectii = this.getSectii();
        Vector<Integer> idSectii = new Vector<Integer>();
        for (int i = 0; i < sectii.size(); ++i) {
            Sectie sectie = (Sectie)sectii.elementAt(i);
            if (!DialogUtils.confirmDialog(parent, "Tiparim plu pentru sectia " + sectie.getName(), LangRoAll.confirmare)) continue;
            idSectii.add(sectie.getId());
        }
        Vector<PluItem> items = new Vector<PluItem>();
        for (Product element : this.nomeclaturaLogic.getAllProducts(0)) {
            double ppu;
            PluItem item = new PluItem();
            if (VpConfig.getInstance().datecsOnlineCodBare) {
                String codBare = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(element.getId());
                item.setCodBare(codBare);
            } else {
                item.setCod(element.getCod());
            }
            if (!((ppu = this.getPriceForProductCommit(element.getId())) > 0.0)) continue;
            item.setPrice(ppu);
            item.setProductName(element.getName());
            int idSectie = this.getSectieByCategorieId(element.getIdCategorie()).getId();
            item.setIdSectie(idSectie);
            if (!idSectii.contains(idSectie)) continue;
            items.add(item);
        }
        String result = LangRoAll.fisierulAFostSalvatLaLocatia + this.pluPrinter.printPLU(items);
        DialogUtils.okDialog(parent, result, "Rezultat");
    }

    private String buildRetetaFile(int idProduct) throws IOException, SQLException {
        Vector<RecipeEntry> allRetete = this.getRecipesForCategory(-1, -1, idProduct);
        String content = "";
        content = this.getContentForRetete(allRetete);
        String recipesFile = "conf" + File.separator + "A4wrapper.txt";
        String recipes = FileUtils.readFileToString(recipesFile);
        recipes = recipes.replaceAll("%%content%%", content);
        String filename = FileUtils.getTempDir() + File.separator + "retete.fo";
        FileWriter fw = new FileWriter(filename);
        fw.write(recipes);
        fw.close();
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void previewReteta(int idProduct) {
        try {
            String filename = this.buildRetetaFile(idProduct);
            PrintLogic.getInstance().printPreview(filename);
        }
        catch (IOException | SQLException e) {
            Logger.logException(this, e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printReteta(int idProduct) {
        try {
            String filename = this.buildRetetaFile(idProduct);
            PrintLogic.getInstance().printPdf(filename, 1);
        }
        catch (IOException | SQLException e) {
            Logger.logException(this, e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private String getContentForRetete(Vector<RecipeEntry> allRetete) throws SQLException, IOException {
        Hashtable<Integer, Integer> reteteSecundare = new Hashtable<Integer, Integer>();
        String content = "";
        for (RecipeEntry element : allRetete) {
            content = content + this.pdfForRecipeNoCommit(element, reteteSecundare, false) + "\n";
        }
        if (reteteSecundare.size() > 0) {
            boolean smth2Do = true;
            Hashtable<Integer, Integer> reteteSecundareProcesate = new Hashtable<Integer, Integer>();
            block1: do {
                smth2Do = false;
                for (Integer idProduct2Process : reteteSecundare.keySet()) {
                    if (reteteSecundareProcesate.get(idProduct2Process) != null) continue;
                    Hashtable<Integer, Integer> reteteSecundareNEW = new Hashtable<Integer, Integer>();
                    smth2Do = true;
                    Vector<RecipeEntry> allReteteSecundare = this.getRecipesForCategoryNoCommit(-1, -1, idProduct2Process);
                    String contentSecundar = "";
                    for (RecipeEntry element : allReteteSecundare) {
                        contentSecundar = contentSecundar + this.pdfForRecipeNoCommit(element, reteteSecundareNEW, true) + "\n";
                    }
                    reteteSecundareProcesate.put(idProduct2Process, idProduct2Process);
                    content = content + "\n" + contentSecundar + "\n";
                    if (reteteSecundareNEW.size() <= 0) continue;
                    boolean smthNew = false;
                    for (Integer id : reteteSecundareNEW.keySet()) {
                        if (reteteSecundare.get(id) != null) continue;
                        reteteSecundare.put(id, (Integer)reteteSecundareNEW.get(id));
                        smthNew = true;
                    }
                    if (!smthNew) continue;
                    continue block1;
                }
            } while (smth2Do);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printRetete(int idSectie) {
        try {
            Vector<RecipeEntry> allRetete = this.getRecipesForCategoryNoCommit(idSectie, -1, -1);
            String sectieName = this.nomeclaturaLogic.getSectieByIdNoCommit(idSectie).getName();
            File destination = new File("Retete_" + sectieName + ".pdf");
            String string = this.printSelectedReteteNoCommit(allRetete, destination);
            return string;
        }
        catch (IOException | SQLException e) {
            Logger.logException(this, e);
            String string = null;
            return string;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printReteteSelected(Vector<ArticolBean> selectedArticole) {
        try {
            Vector<RecipeEntry> allRetete = new Vector<RecipeEntry>();
            for (ArticolBean articolBean : selectedArticole) {
                Vector<RecipeEntry> toAdd = this.getRecipesForCategoryNoCommit(-1, -1, articolBean.getIdProdus());
                allRetete.addAll(toAdd);
            }
            File destination = new File("Retete_" + Formatters.currentDateAndTimeForFileSystem.format(new Date()) + ".pdf");
            String string = this.printSelectedReteteNoCommit(allRetete, destination);
            return string;
        }
        catch (IOException | SQLException e) {
            Logger.logException(this, e);
            String string = null;
            return string;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException sQLException) {
                Logger.logException(this, (Exception)sQLException);
            }
            this.pool.releaseConnection();
        }
    }

    private String printSelectedReteteNoCommit(Vector<RecipeEntry> allRetete, File destination) throws SQLException, IOException {
        String content = this.getContentForRetete(allRetete);
        String recipesFile = "conf" + File.separator + "A4wrapper.txt";
        String recipes = FileUtils.readFileToString(recipesFile);
        recipes = recipes.replaceAll("%%content%%", content);
        String filename = FileUtils.getTempDir() + File.separator + "retete.fo";
        FileWriter fw = new FileWriter(filename);
        fw.write(recipes);
        fw.close();
        PrintUtils.printPdf(filename, destination.getAbsolutePath());
        return destination.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tva getTvaForProduct(int idProduct) {
        try {
            Tva result;
            Tva tva = result = this.getTvaForProductNoCommit(idProduct);
            return tva;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Tva tva = null;
            return tva;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private Tva getTvaForProductNoCommit(int idProduct) throws SQLException {
        int idCat = this.nomeclaturaLogic.getIdCategoryForIdProductNoCommit(idProduct);
        Categorie categorie1 = this.nomeclaturaLogic.getCategoryByIdNoCommit(idCat);
        return TvaLogic.getInstance().getTvaByIdNoCommit(categorie1.getIdTva());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String pdfForRecipeNoCommit(RecipeEntry re, Map<Integer, Integer> reteteSecundareNEW, boolean intermediare) throws SQLException, IOException {
        String recipe = "conf" + File.separator + "recipe.txt";
        String recipeEntry = "conf" + File.separator + "recipeLine.txt";
        String foFile = "";
        foFile = FileUtils.readFileToString(recipe);
        String content = "";
        String origFile = FileUtils.readFileToString(recipeEntry);
        int idLang = AdministrationPanel.loggedUser.getLanguage();
        String valIngredientS = "Incomplet";
        String adaosS = "Incomplet";
        double valIngr = 0.0;
        try {
            Vector stack = new Vector();
            valIngr = this.getPretIngredienteNoCommit(re.getIdReteta(), new NotEnoughIngredientsException(), stack);
            Tva tvaProdus = this.getTvaForProductNoCommit(re.getIdProdus());
            double adaos = re.getPret() / ((1.0 + tvaProdus.getCota()) * valIngr);
            double adaosProcent = (adaos - 1.0) * 100.0;
            adaosS = Utils.getString2Decimals(adaosProcent) + " %";
            valIngredientS = Utils.getString2Decimals(valIngr);
        }
        catch (NotEnoughIngredientsException e) {
            // empty catch block
        }
        Vector<NewRecipeEntry> recipes = this.getRecipesForProdusRetetaNoCommit(re.getIdReteta(), idLang);
        for (NewRecipeEntry element : recipes) {
            boolean subreteta = false;
            int idProduct = element.getIdProduct();
            double quantity = element.getQuantity();
            double pret = 0.0;
            if (idProduct > 0) {
                int idReteta2 = this.getIdRetetaNoCommit(idProduct);
                if (idReteta2 > 0) {
                    subreteta = true;
                    System.out.println("subreteta");
                    Vector stack1 = new Vector();
                    Vector<RecipeEntry> allReteteSecundare = this.getRecipesForCategoryNoCommit(-1, -1, idProduct);
                    RecipeEntry re1 = allReteteSecundare.get(0);
                    double valIngr1 = 0.0;
                    try {
                        valIngr1 = this.getPretIngredienteNoCommit(re1.getIdReteta(), new NotEnoughIngredientsException(), stack1);
                    }
                    catch (NotEnoughIngredientsException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    pret = valIngr1;
                } else {
                    int idStock2 = this.getIdStockNoCommit(idProduct);
                    pret = this.internalGetPriceForStock(idStock2, quantity, new NotEnoughIngredientsException());
                }
            } else {
                pret = this.contaLogic.getPretAchizitieForStockNoCommit(element.getIdStock(), element.getQuantity(), VpConfig.getInstance().calculPretUseCurrentLot);
            }
            String entryFile = new String(origFile);
            entryFile = entryFile.replaceAll("%%ingredient%%", TextUtils.escapeForXML(element.getName() + (subreteta ? " (subreteta)" : "")));
            entryFile = entryFile.replaceAll("%%cantitate%%", Utils.getString6Decimals(element.getQuantity()) + " " + element.getUm());
            double value = element.getQuantity() * pret;
            entryFile = entryFile.replaceAll("%%pret%%", Utils.getString2Decimals(pret));
            entryFile = entryFile.replaceAll("%%valoare%%", Utils.getString2Decimals(value));
            content = content + entryFile + "\n";
            if (idProduct <= 0) continue;
            reteteSecundareNEW.put(idProduct, idProduct);
        }
        foFile = foFile.replaceAll("%%nume%%", TextUtils.escapeForXML(re.getDenumire()) + (intermediare ? " (SUBRETETA)" : ""));
        foFile = foFile.replaceAll("%%pret%%", Utils.getString2Decimals(re.getPret()));
        foFile = foFile.replaceAll("%%adaos%%", adaosS);
        foFile = foFile.replaceAll("%%val_ingrediente%%", valIngredientS);
        foFile = foFile.replaceAll("%%entries%%", content);
        String modPreparare = this.getModPreparareForRetetaNoCommit(re.getIdReteta());
        foFile = foFile.replaceAll("%%mod_preparare%%", modPreparare);
        return foFile;
    }

    public String excelProduse() {
        Vector<Product> allProduse = this.nomeclaturaLogic.getAllProducts(0);
        try {
            File f = new File("Produse.xls");
            ExcelUtils.writeExcel(f, allProduse, new ExcelProcessor(){

                @Override
                public String getSheetName() {
                    return LangRoAll.produse;
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public String[] getColumns() {
                    return new String[]{LangRoAll.sectie, LangRoAll.categorie, "Cod", LangRoAll.codBare, LangRoAll.produs, LangRoAll.pret};
                }

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    try {
                        Product element = (Product)o;
                        String barCode = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(element.getId());
                        Sectie s = RestLogic.this.getSectieByCategorieId(element.getIdCategorie());
                        Label sectie = new Label(0, row, s.getName());
                        sheet.addCell((WritableCell)sectie);
                        Categorie sc = RestLogic.this.getCategorieById(element.getIdCategorie());
                        Label categorie = new Label(1, row, sc.getName());
                        sheet.addCell((WritableCell)categorie);
                        Label cod = new Label(2, row, element.getCod() + "");
                        sheet.addCell((WritableCell)cod);
                        Label codBare = new Label(3, row, barCode + "");
                        sheet.addCell((WritableCell)codBare);
                        Label produs = new Label(4, row, element.getName());
                        sheet.addCell((WritableCell)produs);
                        double price = RestLogic.this.getPriceForProductCommit(element.getId());
                        Label pret = new Label(5, row, Utils.getString2Decimals(price));
                        sheet.addCell((WritableCell)pret);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, new Hashtable());
            return f.getAbsolutePath();
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        return null;
    }

    public String pdfMenu(int idSectie, int idCategorie) {
        try {
            Vector<Categorie> categories = new Vector<Categorie>();
            String sectie = "";
            if (idSectie > 0) {
                if (idCategorie > 0) {
                    Categorie c = this.nomeclaturaLogic.getCategoryById(idCategorie);
                    categories.add(c);
                } else {
                    categories.addAll(this.nomeclaturaLogic.getCategoriiForcedOrder(idSectie));
                }
                Sectie s = this.nomeclaturaLogic.getSectieById(idSectie);
                sectie = "_" + TextUtils.escapeForXML(s.getName());
            } else {
                categories.addAll(this.nomeclaturaLogic.getCategoriiForcedOrder(idSectie));
            }
            StringBuffer pages = new StringBuffer();
            for (int i = 0; i < categories.size(); ++i) {
                Categorie c = (Categorie)categories.elementAt(i);
                Vector products = this.nomeclaturaLogic.getProductsForCategorie(c);
                pages.append(this.getMenuCategorie(c.getName(), products));
            }
            String meniuFile = "conf" + File.separator + "meniu.txt";
            String tempFile = FileUtils.getTempDir() + File.separator + "meniu.fo";
            String meniu = FileUtils.readFileToString(meniuFile);
            meniu = meniu.replaceAll("%%content%%", pages.toString());
            FileWriter fw = new FileWriter(tempFile);
            fw.write(meniu);
            fw.close();
            File destination = new File(LangRoAll.meniu + sectie + ".pdf");
            PrintUtils.printPdf(tempFile, destination.getAbsolutePath());
            return destination.getAbsolutePath();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    private String getMenuCategorie(String categorie, Vector products) throws IOException {
        StringBuffer entries = new StringBuffer();
        for (int i = 0; i < products.size(); ++i) {
            Product o = (Product)products.elementAt(i);
            String price = Utils.getString2Decimals(this.getPriceForProductCommit(o.getId()));
            String line = this.getMenuLine(o.getName(), o.getLiber1(), o.getLiber2(), price) + "\n";
            entries.append(line);
        }
        String meniuFile = "conf" + File.separator + "meniu_pagina.txt";
        String meniu = FileUtils.readFileToString(meniuFile);
        meniu = meniu.replaceAll("%%content%%", entries.toString());
        meniu = meniu.replaceAll("%%categorie%%", TextUtils.escapeForXML(categorie));
        return meniu;
    }

    private String getMenuLine(String productName, String text1, String text2, String price) throws IOException {
        String meniuFile = "conf" + File.separator + "meniu_produs.txt";
        String meniu = FileUtils.readFileToString(meniuFile);
        meniu = meniu.replaceAll("%%denumire%%", TextUtils.escapeForXML(productName));
        String prefix = "white-space-collapse=\"false\">     ";
        String t1 = Validators.correctString(text1 = TextUtils.escapeForXML(text1)) ? prefix + text1 : ">" + text1;
        text2 = TextUtils.escapeForXML(text2);
        String t2 = Validators.correctString(text2) ? prefix + text2 : ">" + text2;
        meniu = meniu.replaceAll("%%text1%%", t1);
        meniu = meniu.replaceAll("%%text2%%", t2);
        meniu = meniu.replaceAll("%%pret%%", price);
        return meniu;
    }

    public PluFilePrinter getPluPrinter() {
        return this.pluPrinter;
    }

    public void setPluPrinter(PluFilePrinter pluPrinter) {
        this.pluPrinter = pluPrinter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Order transferaComanda(Table originalTable, Table newTable, Sale oldSale, double cantitate) {
        try {
            Order newOrder = this.getOpenOrderAtTableNoCommit(newTable);
            Order oldOrder = this.getOpenOrderAtTableNoCommit(originalTable);
            if (newOrder == null) {
                newOrder = this.newOrderNoCommit(newTable.getId(), oldOrder.getUser(), false);
            }
            Product rp = this.nomeclaturaLogic.getProductByIdNoCommit(oldSale.getIdProduct());
            Sale s = this.buildSale(rp, 0.0, cantitate, oldSale.getModPreparare(), newOrder.getId(), oldSale.getIdPlatou(), oldSale.getIdPromotie(), -1, oldSale.getIdServire(), oldSale.getSaledate(), oldSale.getClientIndex());
            this.addSaleNoCommit(s, newOrder.getUser());
            this.deleteSale(oldSale, oldOrder.getUser(), "Transfer", cantitate, false);
            String text = "Transfer " + s.getProductName() + " " + Utils.getString3Decimals(cantitate) + " de la " + originalTable + " la " + newTable;
            int iduser = newOrder.getUser();
            User u = UsersLogic.getInstance().getUserByIdNoCommit(iduser);
            String user = u.getLogin();
            this.userLogic.addUserLogNoCommit(iduser, text);
            this.pool.requestConnection().commitTransaction();
            Map map = this.buildMapForExport(text, new String[0]);
            GenericListenersLogic.getInstance().notifyObjectListeners(1004, map);
            Order order = newOrder;
            return order;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Order order = null;
            return order;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean splitSale(Sale sale, double quantity, int newClientIndex) {
        Vector<Integer> ids = sale.getIdSales();
        try {
            Order order = this.getOrderByIdNoCommit(sale.getIdOrder());
            Product rp = this.nomeclaturaLogic.getProductByIdNoCommit(sale.getIdProduct());
            Sale newSale = this.buildSale(rp, 0.0, quantity, sale.getModPreparare(), order.getId(), sale.getIdPlatou(), sale.getIdPromotie(), -1, sale.getIdServire(), sale.getSaledate(), newClientIndex);
            this.addSaleNoCommit(newSale, order.getUser());
            this.setClientIndexToSaleNoCommit1(newSale, newClientIndex);
            this.deleteSale(sale, order.getUser(), "Separa produse ", quantity, false);
            this.userLogic.addUserLogNoCommit(order.getUser(), "Separa produse " + newSale.getProductName() + " " + Utils.getString3Decimals(quantity));
            this.pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    @Override
    public Vector deleteImpedimentsNoCommit(int idStock) throws SQLException {
        return this.getProductsThatUseIngredientNoCommit(idStock);
    }

    public boolean getFinRespectWithDocumentPlata(Order o, boolean f) {
        Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(o.getId());
        Iterator<Plata> i$ = plati.iterator();
        while (i$.hasNext()) {
            Plata o1;
            Plata p = o1 = i$.next();
            TipPlata tp = TipPlataProvider.getInstance().getTipPlataById(p.getIdTipPlata());
            if (!tp.isDocumentDePlata()) continue;
            return true;
        }
        return f;
    }

    public double getSumaForPlataPlataSkip(Order o, int idTipPlata, double totalOrder, int idPlataSkip) {
        return this.getSumaForPlata(o, idTipPlata, totalOrder, idPlataSkip, -1);
    }

    public double getSumaForPlataNoPlataSkip(Order o, int idTipPlata, double totalOrder, int clientIndex) {
        return this.getSumaForPlata(o, idTipPlata, totalOrder, -1, clientIndex);
    }

    @Deprecated
    public double getSumaForPlata(Order o, int idTipPlata, double totalOrder, int idPlataSkip1, int clientIndex) {
        double result = -1.0;
        Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(o.getId(), clientIndex);
        for (Plata p : plati) {
            if (p.getIdTipPlata() != idTipPlata) continue;
            result = p.getSuma();
            break;
        }
        PaymentLogic.getInstance();
        double totalPlati = PaymentLogic.getPlatiInVector(plati);
        result = result < 0.0 ? totalOrder - totalPlati : totalOrder - totalPlati + result;
        if (result < 0.0) {
            result = 0.0;
        }
        return result;
    }

    @Override
    public synchronized Object prepareWebServer(int port) {
        if (this.server == null) {
            this.server = new Server();
            SocketListener listener = new SocketListener();
            listener.setPort(port);
            this.server.addListener((HttpListener)listener);
        }
        return this.server;
    }

    public synchronized Server getServer() {
        return this.server;
    }

    public synchronized void startJettyServer() throws Exception {
        this.server.start();
    }

    public void importProductsInPOS(String importFile) {
        try {
            ProduseXmlHandler handler = new ProduseXmlHandler();
            Utils.importXml((DefaultHandler)handler, importFile);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SAXException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public String exportUsersToPDA(UsersFilter filter) {
        try {
            StringBuffer bigFile = new StringBuffer();
            bigFile.append("<document>\n");
            Vector users = this.getWaiters();
            for (int i = 0; i < users.size(); ++i) {
                User u = (User)users.elementAt(i);
                if (!filter.acceptUser(u)) continue;
                bigFile.append("<user id=\"" + u.getId() + "\" login=\"" + TextUtils.escapeForXML(u.getLogin()) + "\" password=\"" + TextUtils.escapeForXML(u.getPassword()) + "\"/>\n");
            }
            bigFile.append("</document>");
            String destinationFile = FileUtils.getCurrentDir() + File.separator + "users.xml";
            FileUtils.writeTextToFile(destinationFile, bigFile.toString());
            return destinationFile;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    private void exportCategorieToPOS(Categorie sc, StringBuffer bigFile, Hashtable productsFilter) {
        String categorie = TextUtils.escapeForXMLStripQuote(sc.getName());
        bigFile.append(" <categorie cod=\"" + sc.getCod() + "\" label=\"" + categorie + "\"" + " ordine=\"" + sc.getNrOrdine() + "\" color=\"" + sc.getColorAsInt() + "\"" + " idTva=\"" + sc.getIdTva() + "\"" + " cod_departament=\"" + sc.getCodDepartament() + "\"" + " pretKg = \"" + sc.isPretKg() + "\"" + " id=\"" + sc.getId() + "\"" + " idSectie=\"" + sc.getSectie() + "\">\n");
        Vector products = this.nomeclaturaLogic.getProductsForCategorie(sc);
        for (int k = 0; k < products.size(); ++k) {
            Product p = (Product)products.elementAt(k);
            String productName = TextUtils.escapeForXMLStripQuote(p.getName());
            String casaName = TextUtils.escapeForXMLStripQuote(p.getNumeCasa());
            String sectieName = TextUtils.escapeForXMLStripQuote(p.getName());
            String liber1 = TextUtils.escapeForXMLStripQuote(p.getLiber1());
            String liber2 = TextUtils.escapeForXMLStripQuote(p.getLiber2());
            boolean productie = this.isProductie(p.getId());
            String mp = "";
            int idReteta = this.getIdReteta(p.getId());
            if (idReteta > 0) {
                mp = this.getModPreparareForReteta(idReteta);
            }
            String modPreparare = TextUtils.escapeForXMLStripQuote(mp);
            if (productsFilter.contains(p.getName())) continue;
            Vector<String> coduriBare = NomeclaturaLogic.getInstance().getAllBarCodesByIdProd(p.getId());
            double price = this.getPriceForProductCommit(p.getId());
            bigFile.append("  <produs cod=\"" + p.getCod() + "\"" + " label=\"" + productName + "\"" + " pret=\"" + Utils.getString2Decimals(price) + "\"" + " codBare=\"");
            String barcodes = this.getBarcodesStringForXml(p.getId());
            bigFile.append(barcodes);
            bigFile.append("\" id=\"" + p.getId() + "\"" + " short_label=\"" + casaName + "\"" + " sectie_label=\"" + sectieName + "\"" + " liber1=\"" + liber1 + "\"" + " liber2=\"" + liber2 + "\"" + " mod_preparare=\"" + modPreparare + "\"" + " uz_intern=\"" + p.isUzIntern() + "\"" + " productie=\"" + productie + "\"" + " idCategorie=\"" + p.getIdCategorie() + "\"" + " />\n");
            productsFilter.put(p.getName(), p);
        }
        bigFile.append(" </categorie>\n");
    }

    public String getBarcodesStringForXml(int idProduct) {
        StringBuffer bigFile = new StringBuffer();
        Vector<String> coduriBare = NomeclaturaLogic.getInstance().getAllBarCodesByIdProd(idProduct);
        int i = 0;
        for (String s : coduriBare) {
            bigFile.append(s);
            if (++i >= coduriBare.size()) continue;
            bigFile.append(",");
        }
        return bigFile.toString();
    }

    public String exportProductsToPOS(TablesFilter tableFilter, LocationsFilter locationFilter) {
        try {
            StringBuffer bigFile = new StringBuffer();
            Hashtable productsFilter = new Hashtable();
            bigFile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            bigFile.append("<document>\n");
            Vector<Sectie> categories = this.nomeclaturaLogic.getAllSectii();
            for (int i = 0; i < categories.size(); ++i) {
                Sectie c = categories.elementAt(i);
                String sectie = TextUtils.escapeForXMLStripQuote(c.getName());
                bigFile.append("<sectie cod=\"" + c.getCod() + "\" label=\"" + sectie + "\" id=\"" + c.getId() + "\">\n");
                Vector subcategories = this.nomeclaturaLogic.getCategoriiForcedOrder(c.getId());
                for (int j = 0; j < subcategories.size(); ++j) {
                    Categorie sc = (Categorie)subcategories.elementAt(j);
                    this.exportCategorieToPOS(sc, bigFile, productsFilter);
                }
                bigFile.append("</sectie>\n");
            }
            Vector<Meniu> meniuri = this.getAllMeniuri();
            for (int i = 0; i < meniuri.size(); ++i) {
                Meniu meniu = meniuri.elementAt(i);
                String label = TextUtils.escapeForXMLStripQuote(meniu.getLabel());
                bigFile.append("<meniu label=\"" + label + "\" id_meniu=\"" + meniu.getId() + "\">\n");
                Vector optiuniMeniu = this.getOptiuniForMenu(meniu.getId());
                for (int j = 0; j < optiuniMeniu.size(); ++j) {
                    OptiuneMeniu optiuneMeniu = (OptiuneMeniu)optiuniMeniu.elementAt(j);
                    String label2 = TextUtils.escapeForXMLStripQuote(optiuneMeniu.getNumeOptiune());
                    bigFile.append("<meniu_optiune label=\"" + label2 + "\" id_meniu_optiune=\"" + optiuneMeniu.getIdOptiune() + "\" id_meniu=\"" + meniu.getId() + "\">\n");
                    Vector optiuniProduse = this.getOptiuniProdusFrontOffice(meniu.getId(), optiuneMeniu.getIdOptiune());
                    for (int k = 0; k < optiuniProduse.size(); ++k) {
                        OptiuneProdus optiuneProdus = (OptiuneProdus)optiuniProduse.elementAt(k);
                        double cantitate = optiuneProdus.getCantitate();
                        double price = optiuneProdus.getPret();
                        String prod = TextUtils.escapeForXMLStripQuote(optiuneProdus.getProduct());
                        bigFile.append("<meniu_optiune_produs nume_produs=\"" + prod + "\"" + " id_product=\"" + optiuneProdus.getIdProdus() + "\"" + " id_optiune_produs=\"" + optiuneProdus.getId() + "\"" + " id_meniu_optiune=\"" + optiuneMeniu.getIdOptiune() + "\"" + " pret=\"" + Utils.getString2Decimals(price) + "\"" + " cantitate=\"" + Utils.getString2Decimals(cantitate) + "\" />\n");
                    }
                    bigFile.append("</meniu_optiune>\n");
                }
                bigFile.append("</meniu>\n");
            }
            Vector locatii = this.getLocations();
            for (int i = 0; i < locatii.size(); ++i) {
                Location location = (Location)locatii.elementAt(i);
                if (!locationFilter.acceptLocation(location)) continue;
                bigFile.append("<location id=\"" + location.getId() + "\" label=\"" + TextUtils.escapeForXML(location.getName()) + "\"/>\n");
            }
            Vector<Table> mese = this.getTables();
            for (int i = 0; i < mese.size(); ++i) {
                Table o = mese.elementAt(i);
                if (!tableFilter.acceptTable(o)) continue;
                bigFile.append("<table id=\"" + o.getId() + "\" label=\"" + TextUtils.escapeForXML(o.getLabel()) + "\" locatie=\"" + TextUtils.escapeForXML(this.getLocationById(o.getIdLocatie()).getName()) + "\" id_locatie=\"" + o.getIdLocatie() + "\"/>\n");
            }
            Vector preparare = this.getModuriPreparare();
            for (int i = 0; i < preparare.size(); ++i) {
                ModPreparare o = (ModPreparare)preparare.elementAt(i);
                bigFile.append("<preparare id=\"" + o.getId() + "\" label=\"" + TextUtils.escapeForXML(o.getModPreparare()) + "\"/>\n");
            }
            Vector<OrdineServire> os = this.getOrdineServire(-1);
            for (int i = 0; i < os.size(); ++i) {
                OrdineServire o = os.elementAt(i);
                bigFile.append("<servire id=\"" + o.getId() + "\" label=\"" + TextUtils.escapeForXML(o.getServire()) + "\"/>\n");
            }
            bigFile.append("</document>");
            String destinationFile = FileUtils.getCurrentDir() + File.separator + "products.xml";
            FileUtils.writeTextToFile(destinationFile, bigFile.toString(), "UTF-8");
            return destinationFile;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPretIngredienteCommit(int idReteta, NotEnoughIngredientsException notEnough, Vector stack) throws NotEnoughIngredientsException, StackOverflowError {
        try {
            double d = this.getPretIngredienteNoCommit(idReteta, notEnough, stack);
            return d;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            double d = 0.0;
            return d;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (Exception e) {
                Logger.logException(this, e);
            }
            this.pool.releaseConnection();
        }
    }

    public double getPretIngredienteNoCommit(int idReteta, NotEnoughIngredientsException notEnough, Vector stack) throws NotEnoughIngredientsException, StackOverflowError, SQLException {
        double total = 0.0;
        Vector recipeItems = this.getProductsDao().getRecipeItemsForProdusRetetaId(idReteta);
        for (int i = 0; i < recipeItems.size(); ++i) {
            double price1;
            boolean ok1;
            double quantity;
            block9: {
                RecipeItem item = (RecipeItem)recipeItems.elementAt(i);
                int idProductItem = item.getIdProduct();
                int stockItem = item.getIdStock();
                quantity = item.getQuantity();
                ok1 = true;
                price1 = -1.0;
                if (idProductItem != -1) {
                    int idReteta2 = this.getIdRetetaNoCommit(idProductItem);
                    if (idReteta2 > 0) {
                        try {
                            if (stack.contains(idReteta2)) {
                                System.out.println("Naspa treaba");
                                break block9;
                            }
                            stack.add(idReteta2);
                            price1 = this.getPretIngredienteNoCommit(idReteta2, notEnough, stack);
                        }
                        catch (NotEnoughIngredientsException e) {}
                    } else {
                        int idStock2 = this.getIdStockNoCommit(idProductItem);
                        price1 = this.internalGetPriceForStock(idStock2, quantity, notEnough);
                    }
                } else {
                    price1 = this.internalGetPriceForStock(stockItem, quantity, notEnough);
                }
            }
            boolean bl = ok1 = price1 != -1.0;
            if (!ok1) continue;
            total += quantity * price1;
        }
        if (!notEnough.somethingMissing()) {
            return total;
        }
        throw notEnough;
    }

    private double internalGetPriceForStock(int idStock2, double quantity, NotEnoughIngredientsException notEnough) throws SQLException {
        double price1 = -1.0;
        price1 = this.contaLogic.getPretAchizitieForStockNoCommit(idStock2, quantity, VpConfig.getInstance().calculPretUseCurrentLot);
        if (VpConfig.getInstance().calculPretUseCurrentLot) {
            this.pricesForStocks.put(idStock2, price1);
        }
        if (price1 == -1.0) {
            String label = this.stockLogic.getStockByIdNoCommit(idStock2).getLabel();
            notEnough.addMissing(label);
        }
        return price1;
    }

    private void updatePricesHashForStock(final int idStock) {
        Thread updateHashThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    double price1 = RestLogic.this.contaLogic.getPretAchizitieForStockNoCommit(idStock, 0.0, VpConfig.getInstance().calculPretUseCurrentLot);
                    RestLogic.this.pricesForStocks.put(idStock, price1);
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                finally {
                    try {
                        RestLogic.this.pool.commit();
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    RestLogic.this.pool.releaseConnection();
                }
            }
        };
        updateHashThread.setPriority(1);
        updateHashThread.start();
    }

    public String getAdaosNecesar(Vector necesare) {
        String s1 = "Sunt necesare urmatoarele :";
        String s2 = "";
        return Utils.getStringForJDialogList(s1, s2, necesare);
    }

    public void preparareProduseNoCommit(Vector<PreparareEntry> preparareItems, int idMagazie, Timestamp dataPreparare) throws SQLException {
        Timestamp newData = this.getTimeDocument(5, dataPreparare);
        this.getDao().addFabricare(idMagazie, newData);
        int idPreparare = this.pool.requestConnection().getIndentityLocal();
        this.addPreparareItems(preparareItems, idPreparare);
        this.fabricareAdded(idPreparare, newData, "Productie " + idPreparare);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preparareProduse(Vector<PreparareEntry> preparareItems, int idMagazie, Timestamp dataPreparare) {
        try {
            this.preparareProduseNoCommit(preparareItems, idMagazie, dataPreparare);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void addPreparareItems(Vector<PreparareEntry> preparareItems, int idPreparare) throws SQLException {
        for (int i = 0; i < preparareItems.size(); ++i) {
            PreparareEntry o = preparareItems.elementAt(i);
            this.getDao().addFabricareItem(idPreparare, o.getIdProdusReteta(), o.getCantitate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFabricareItems(int idFabricare) {
        try {
            Vector vector = this.getDao().getFabricareItems(idFabricare);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public boolean reprocesareFabricatie(int idFabricatie, String document, Timestamp time, boolean fiscal, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        Fabricare f = this.getDao().getFabricareById(idFabricatie);
        Vector entries = this.getDao().getFabricareItems(idFabricatie);
        for (int i = 0; i < entries.size(); ++i) {
            PreparareEntry o = (PreparareEntry)entries.elementAt(i);
            String codBare = o.getCodBare();
            if (codBare == null) {
                codBare = "";
            }
            int idProduct = this.getProductsDao().getidProductByIdReteta(o.getIdProdusReteta());
            double pretVz = this.getPriceForProductNoCommit(idProduct);
            double pretAchizitie = 0.0;
            try {
                Vector stack = new Vector();
                pretAchizitie = this.getPretIngredienteCommit(o.getIdProdusReteta(), new NotEnoughIngredientsException(), stack);
            }
            catch (NotEnoughIngredientsException e) {
                // empty catch block
            }
            this.preparareProdusNoCommit(o.getIdProdusReteta(), o.getProdus(), f.getIdMagazie(), o.getCantitate(), time, pretAchizitie, pretVz, codBare, document, fiscal, comandaType, o.getIdLot());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateFabricatie(int idFabricatie, int idMagazie, Timestamp oldData, Timestamp newData, Vector items, Component parent) {
        try {
            if (!this.canModifyDocument(5, idFabricatie)) {
                DialogUtils.errorDialog(parent, "Nu puteti modifica aceasta productie", LangRoAll.nuPotContinua);
                this.pool.requestConnection().rollback();
                this.pool.releaseConnection();
                boolean bl = false;
                return bl;
            }
            this.getDao().deleteFabricareItems(idFabricatie);
            if (!DateUtils.sameMinute(oldData, newData)) {
                newData = this.getTimeDocument(5, newData);
            }
            this.documentDeleted(oldData);
            this.documentDeleted(newData);
            this.getDao().updateFabricare(idFabricatie, newData, idMagazie);
            this.addPreparareItems(items, idFabricatie);
            this.fabricareUpdated(idFabricatie, newData, "Productie " + idFabricatie);
            this.pool.commit();
            DialogUtils.okDialog(parent, "Operatie efectuata", LangRoAll.succes);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProductRetetaForStockId(Integer idStock) {
        try {
            int result;
            int n = result = this.getDao().getIdProductByIdStock(idStock);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private void preparareProdusNoCommit(int idReteta, String productName, int idMagazie, double cantitate, Timestamp dataPreparare, double pretAchizitie, double pretVanzare, String codBare, String document, boolean fiscal, StockLogic.COMANDA_TYPE comandaType, int idLot) throws SQLException {
        int idStock = this.getDao().getPreparatByIdReteta(idReteta);
        if (idStock == -1) {
            this.stockLogic.addStock(productName, UnitsLogic.getInstance().getUnitByName("buc").getId(), 0.0, 0.0, pretVanzare, true);
            idStock = this.pool.requestConnection().getIndentityLocal();
            this.getDao().addPreparare(idReteta, idStock);
        }
        double valIntrarePa = cantitate * pretAchizitie;
        double valIntrarePv = cantitate * pretVanzare;
        this.stockLogic.addFisaMagazieIntrareNoCommit(idStock, idMagazie, 5, document, dataPreparare, pretAchizitie, pretVanzare, cantitate, valIntrarePa, valIntrarePv, productName, codBare, fiscal, comandaType, idLot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean productie(Vector<Sale> sales, Order o, int idMagazieProductie, int idMagazieBonConsum) {
        try {
            Vector<PreparareEntry> pes = new Vector<PreparareEntry>();
            for (Sale sale : sales) {
                PreparareEntry pp = new PreparareEntry();
                double cant = sale.getCantitateMarcata();
                double price = this.getPriceForProductCommit(sale.getIdProduct());
                pp.setCantitate(cant);
                pp.setProdus(sale.getProductName());
                double value = cant * price;
                pp.setPretVanzare(price);
                pp.setValoareVanzare(value);
                pp.setIdProdusReteta(this.getIdReteta(sale.getIdProduct()));
                pes.add(pp);
            }
            this.preparareProduseNoCommit(pes, idMagazieProductie, DateUtils.getCurrentTimestamp());
            User user = this.userLogic.getUserByIdNoCommit(o.getUser());
            Vector entries = this.getBonConsumItems(pes, user);
            double totalGeneral = 0.0;
            for (int i = 0; i < entries.size(); ++i) {
                BonConsumItem bonConsumItem = (BonConsumItem)entries.elementAt(i);
                totalGeneral += bonConsumItem.getCantitate() * bonConsumItem.getPretAcz();
            }
            int nrDoc = RegistreLogic.getInstance().getNewNumberForRegistruNoCommit(RegistreInterne.BON_CONSUM_TRANSFER_INTERN.key, RegistreInterne.BON_CONSUM_TRANSFER_INTERN.nume, true);
            this.stockLogic.adaugaBonConsumNoCommit(idMagazieBonConsum, DateUtils.getCurrentTimestamp(), entries, "Bon consum", true, totalGeneral, nrDoc, "Transfer");
            this.deleteOrderNoCommit(o, null, "", null, false);
            this.pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public double getPretCost(int idProduct, int idReteta, String productName, Hashtable<Integer, Double> pretAczForStock) throws SQLException {
        double valIngrediente = 0.0;
        if (idReteta > 0) {
            try {
                Vector stack = new Vector();
                valIngrediente = this.getPretIngredienteNoCommit(idReteta, new NotEnoughIngredientsException(), stack);
            }
            catch (NotEnoughIngredientsException e) {
            }
            catch (StackOverflowError stackOverflowError) {
                stackOverflowError.getMessage();
                Logger.logError((Object)this, "Produsul " + productName + " are reteta incorecta ( recursiva )");
            }
        } else {
            int idStock = RestLogic.getInstance().getIdStockNoCommit(idProduct);
            if (idStock > 0) {
                Double pretAcz;
                boolean priceFound = false;
                if (pretAczForStock != null && (pretAcz = pretAczForStock.get(idStock)) != null) {
                    valIngrediente = pretAcz;
                    priceFound = true;
                }
                if (!priceFound) {
                    valIngrediente = this.stockLogic.getBackupBuyPriceNoCommit(idStock);
                }
            }
        }
        return valIngrediente;
    }

    public AdaosReportEntry getAdaosEntry(Product o) throws SQLException {
        int idReteta = this.getIdRetetaNoCommit(o.getId());
        AdaosReportEntry toAdd = new AdaosReportEntry();
        double v = this.getPriceForProductNoCommit(o.getId());
        toAdd.setPretVanzare(v);
        toAdd.setProdus(o.getName());
        if (idReteta > 0) {
            toAdd.setIdReteta(idReteta);
            try {
                double valIngrediente = 0.0;
                Vector stack = new Vector();
                valIngrediente = this.getPretIngredienteNoCommit(idReteta, new NotEnoughIngredientsException(), stack);
                toAdd.setValIngrediente(valIngrediente);
                int idCat = o.getIdCategorie();
                Categorie cat = this.nomeclaturaLogic.getCategoryByIdNoCommit(idCat);
                Tva tva = TvaLogic.getInstance().getTvaByIdNoCommit(cat.getIdTva());
                double tvaProcent = tva.getCota();
                toAdd.setCotaTva(tvaProcent);
                double adaos = v / ((1.0 + tvaProcent) * valIngrediente);
                double adaosProcent = (adaos - 1.0) * 100.0;
                toAdd.setAdaosCoef(adaos);
                toAdd.setAdaosProcent(adaosProcent);
                double diffValue = v / (1.0 + tvaProcent) - valIngrediente;
                toAdd.setDiffValoare(diffValue);
                toAdd.setCompleted(true);
            }
            catch (NotEnoughIngredientsException e) {
            }
            catch (StackOverflowError stackOverflowError) {
                stackOverflowError.getMessage();
                Logger.logError((Object)this, "Produsul " + o.getName() + " are reteta incorecta ( recursiva )");
            }
        } else {
            int idStock = RestLogic.getInstance().getIdStockNoCommit(o.getId());
            if (idStock > 0) {
                double pretAchizitie = this.stockLogic.getBackupBuyPriceNoCommit(idStock);
                toAdd.setValIngrediente(pretAchizitie);
                toAdd.setCompleted(true);
                toAdd.setIdStock(idStock);
            }
        }
        toAdd.computeByPretVanzare(v);
        return toAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAdaosReport(Hashtable criteria) {
        Vector<AdaosReportEntry> result = new Vector<AdaosReportEntry>();
        Vector<Product> products = this.nomeclaturaLogic.getAllProducts(0);
        try {
            for (int i = 0; i < products.size(); ++i) {
                Product o = products.elementAt(i);
                AdaosReportEntry toAdd = this.getAdaosEntry(o);
                result.add(toAdd);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                AdaosReportEntry a1 = (AdaosReportEntry)o1;
                AdaosReportEntry a2 = (AdaosReportEntry)o2;
                return a1.getProdus().compareToIgnoreCase(a2.getProdus());
            }
        });
        return result;
    }

    public Vector getBonConsumItems(Vector productieEntries, User user) {
        Hashtable temp = new Hashtable();
        for (int i = 0; i < productieEntries.size(); ++i) {
            PreparareEntry pe = (PreparareEntry)productieEntries.elementAt(i);
            Vector<NewRecipeEntry> recipes = this.getRecipesForProdusReteta(pe.getIdProdusReteta(), user.getLanguage());
            for (int j = 0; j < recipes.size(); ++j) {
                NewRecipeEntry o = recipes.elementAt(j);
                this.recurseForProductieEntries(o, temp, pe.getCantitate());
            }
        }
        return new Vector(temp.values());
    }

    private void recurseForProductieEntries(NewRecipeEntry toRecurse, Hashtable productHash, double nrPortii) {
        double quantity = toRecurse.getQuantity() * nrPortii;
        String name = toRecurse.getName();
        int idStock = toRecurse.getIdStock();
        if (idStock > 0) {
            BonConsumItem existing = (BonConsumItem)productHash.get(idStock);
            if (existing == null) {
                BonConsumItem bci = new BonConsumItem();
                bci.setCantitate(quantity);
                bci.setDenumire(name);
                bci.setIdStock(idStock);
                productHash.put(idStock, bci);
            } else {
                existing.setCantitate(existing.getCantitate() + quantity);
            }
        } else {
            int idProduct = toRecurse.getIdProduct();
            if (idProduct > 0) {
                int idRetetaProduct = this.getIdReteta(idProduct);
                Vector<NewRecipeEntry> recipes = this.getRecipesForProdusReteta(idRetetaProduct, AdministrationPanel.loggedUser.getLanguage());
                for (int j = 0; j < recipes.size(); ++j) {
                    NewRecipeEntry o = recipes.elementAt(j);
                    this.recurseForProductieEntries(o, productHash, quantity);
                }
            } else {
                System.out.println("SHIT. this shouldnt'd happen !");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllDocumenteNevalidate() {
        try {
            Vector result;
            Vector vector = result = this.getAllDocumenteNevalidateNoCommit();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector getAllDocumenteNevalidateNoCommit() throws SQLException {
        return this.getDao().getDocumentNevalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDocumente(Hashtable criteria, int what) {
        Date startDate = (Date)criteria.get(Constants.START_KEY);
        Date stopDate = (Date)criteria.get(Constants.STOP_KEY);
        try {
            Vector result;
            Vector vector = result = this.getDao().getDocumente(new Timestamp(startDate.getTime()), new Timestamp(stopDate.getTime()), what);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valideazaPanaLaData(Timestamp t1) {
        try {
            this.getDao().valideazaPanaLaData(t1);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocumentNeprocesat() {
        try {
            Document result;
            Document document = result = this.getDocumentNeprocesatNoCommit();
            return document;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Document document = null;
            return document;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Document getDocumentNeprocesatNoCommit() throws SQLException {
        return this.getDao().getDocumentNeprocesat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculeazaDocumenteNevalidate() {
        try {
            Timestamp t1 = this.getDao().getLastValidate();
            if (t1 == null) {
                t1 = new Timestamp(0L);
            }
            this.getDao().setDocumenteUlterioareNeprocesate(t1);
            this.pool.requestConnection().commitTransaction();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void deleteDocumente(Timestamp start, Timestamp stop) {
    }

    public boolean proceseazaDocument(Document t) throws SQLException {
        if (t.getIdFactura() != 0) {
            int idFactura = t.getIdFactura();
            return ContaLogic.getInstance().reproceseazaFacturaNoCommit(idFactura, t.getTimeDocument(), t.getDocument(), t.isFiscal(), t.getComandaType());
        }
        if (t.getIdOrder() != 0) {
            Order o = this.getOrderByIdNoCommit(t.getIdOrder());
            if (o.isComanda()) {
                return false;
            }
            return this.descarcaNotaFast(o, t, VpConfig.getInstance().descarcaAllSales, t.getComandaType());
        }
        if (t.getIdTransfer() != 0) {
            return this.stockLogic.reproceseazaTransferNoCommit(t.getIdTransfer(), t.getDocument(), t.getTimeDocument(), t.isFiscal(), t.getComandaType());
        }
        if (t.getIdConsum() != 0) {
            return this.stockLogic.reproceseazaConsumNoCommit(t.getIdConsum(), t.getDocument(), t.getTimeDocument(), t.isFiscal(), t.getComandaType());
        }
        if (t.getIdProductie() != 0) {
            return this.reprocesareFabricatie(t.getIdProductie(), t.getDocument(), t.getTimeDocument(), t.isFiscal(), t.getComandaType());
        }
        if (t.getIdFacturaEmisa() != 0) {
            return FacturiLogic.getInstance().reprocessFacturaNoCommit(t.getIdFacturaEmisa(), t.getTimeDocument(), t.getDocument(), t.isFiscal(), false, t.getComandaType());
        }
        if (t.getIdCorectie() != 0) {
            Corectie c = this.stockLogic.getCorectieByIdNoCommit(t.getIdCorectie());
            Vector<BonConsumItem> items = this.stockLogic.getCorectieItemsNoCommit(c.getId());
            this.stockLogic.processCorectieItems(items, c.getIdMagazie(), c.getDateadd(), t.getDocument(), t.isFiscal(), t.getComandaType());
            return true;
        }
        if (t.getIdModificarePret() != 0) {
            this.stockLogic.processModificarePret(t.getIdModificarePret(), t.getComandaType());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTimeForDocument(Document t) {
        try {
            this.updateTimeForDocumentNoCommit(t);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void updateTimeForDocumentNoCommit(Document t) throws SQLException {
        Timestamp newData = null;
        if (t.getIdFactura() != 0) {
            newData = this.getTimeDocument(2, t.getTimeDocument());
        } else if (t.getIdOrder() != 0) {
            newData = this.getTimeDocument(3, t.getTimeDocument());
        } else if (t.getIdTransfer() != 0) {
            newData = this.getTimeDocument(7, t.getTimeDocument());
        } else if (t.getIdConsum() != 0) {
            newData = this.getTimeDocument(4, t.getTimeDocument());
        } else if (t.getIdProductie() != 0) {
            newData = this.getTimeDocument(5, t.getTimeDocument());
        } else if (t.getIdFacturaEmisa() != 0) {
            newData = this.getTimeDocument(8, t.getTimeDocument());
        } else if (t.getIdCorectie() != 0) {
            newData = this.getTimeDocument(9, t.getTimeDocument());
        }
        t.setTimeDocument(newData);
        this.getDao().updateDocument(t.getId(), t.getTimeDocument(), t.getDocument(), t.isFiscal(), t.getComandaType());
        Logger.logDebugVerbose(this, "Updated time for document due to duplication : " + t.getDocument() + " ," + t.getTimeDocument());
    }

    @Override
    public int facturaAdded(int idFactura, Timestamp time, String nume, boolean fiscal, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        this.getDao().addDocumentFactura(idFactura, time, nume, fiscal, comandaType);
        return this.pool.requestConnection().getIndentityLocal();
    }

    @Override
    public void facturaUpdated(int idFactura, Timestamp time, String nume, boolean fiscal, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        int idDoc = this.getDocumentId(2, idFactura);
        this.getDao().updateDocument(idDoc, time, nume, fiscal, comandaType);
        this.getDao().documentNeprocesat(idDoc);
    }

    @Override
    public int orderAdded(int idOrder, Timestamp time, String nume, boolean fiscal) throws SQLException {
        this.getDao().addDocumentOrder(idOrder, time, nume, fiscal);
        return this.pool.requestConnection().getIndentityLocal();
    }

    @Override
    public int facturaEmisaAdded(int idFacturaEmisa, Timestamp time, String nume, boolean fiscal, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        this.getDao().addDocumentFacturaEmisa(idFacturaEmisa, time, nume, fiscal, comandaType);
        return this.pool.requestConnection().getIndentityLocal();
    }

    @Override
    public void facturaEmisaUpdated(int idFacturaEmisa, Timestamp time, String nume, boolean fiscal, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        int idDoc = this.getDocumentId(8, idFacturaEmisa);
        this.getDao().updateDocument(idDoc, time, nume, fiscal, comandaType);
        this.getDao().documentNeprocesat(idDoc);
    }

    @Override
    public int consumAdded(int idConsum, Timestamp time, String nume, boolean fiscal) throws SQLException {
        this.getDao().addDocumentConsum(idConsum, time, nume, fiscal);
        return this.pool.requestConnection().getIndentityLocal();
    }

    @Override
    public void consumUpdated(int idBC, Timestamp time, String nume, boolean fiscal) throws SQLException {
        int idDoc = this.getDocumentId(4, idBC);
        this.getDao().updateDocument(idDoc, time, nume, fiscal, StockLogic.COMANDA_TYPE.EFECTUAT);
        this.getDao().documentNeprocesat(idDoc);
    }

    @Override
    public int corectieAdded(int idCorectie, Timestamp time, String nume, boolean fiscal) throws SQLException {
        this.getDao().addDocumentCorectie(idCorectie, time, nume, fiscal);
        return this.pool.requestConnection().getIndentityLocal();
    }

    @Override
    public void corectieUpdated(int idCorectie, Timestamp time, String nume, boolean fiscal) throws SQLException {
        int idDoc = this.getDocumentId(9, idCorectie);
        this.getDao().updateDocument(idDoc, time, nume, fiscal, StockLogic.COMANDA_TYPE.EFECTUAT);
        this.getDao().documentNeprocesat(idDoc);
    }

    @Override
    public int modificarePretAdded(int idModificare, Timestamp time, String nume, boolean fiscal) throws SQLException {
        this.getDao().addModificarePret(idModificare, time, nume, fiscal);
        return this.pool.requestConnection().getIndentityLocal();
    }

    @Override
    public void modificarePretUpdated(int idModificare, Timestamp time, String nume, boolean fiscal) throws SQLException {
        int idDoc = this.getDocumentId(6, idModificare);
        this.getDao().updateDocument(idDoc, time, nume, fiscal, StockLogic.COMANDA_TYPE.EFECTUAT);
        this.getDao().documentNeprocesat(idDoc);
    }

    public int mod(int idCorectie, Timestamp time, String nume, boolean fiscal) throws SQLException {
        this.getDao().addDocumentCorectie(idCorectie, time, nume, fiscal);
        return this.pool.requestConnection().getIndentityLocal();
    }

    @Override
    public int transferAdded(int idTransfer, Timestamp time, String nume) throws SQLException {
        this.getDao().addDocumentTransfer(idTransfer, time, nume);
        return this.pool.requestConnection().getIndentityLocal();
    }

    @Override
    public void transferUpdated(int idTransfer, Timestamp time, String nume) throws SQLException {
        int idDoc = this.getDocumentId(7, idTransfer);
        this.getDao().updateDocument(idDoc, time, nume, true, StockLogic.COMANDA_TYPE.EFECTUAT);
        this.getDao().documentNeprocesat(idDoc);
    }

    @Override
    public int fabricareAdded(int idFabricare, Timestamp time, String nume) throws SQLException {
        this.getDao().addDocumentFabricare(idFabricare, time, nume);
        return this.pool.requestConnection().getIndentityLocal();
    }

    @Override
    public void fabricareUpdated(int idFabricare, Timestamp time, String nume) throws SQLException {
        int idDoc = this.getDocumentId(5, idFabricare);
        this.getDao().updateDocument(idDoc, time, nume, true, StockLogic.COMANDA_TYPE.EFECTUAT);
        this.getDao().documentNeprocesat(idDoc);
    }

    @Override
    public boolean canModifyDocument(int tipDocument, int idObject) throws SQLException {
        int[] result = this.getDao().getStatusForDocumentAndTip(tipDocument, idObject);
        return result[0] != 3;
    }

    @Override
    public boolean canAddDocument(Timestamp time) throws SQLException {
        Timestamp d = this.getDao().getLastValidate();
        if (d != null) {
            return d.compareTo(time) < 0;
        }
        return true;
    }

    @Override
    public int getDocumentId(int tipDocument, int idObject) throws SQLException {
        int[] result = this.getDao().getStatusForDocumentAndTip(tipDocument, idObject);
        return result[1];
    }

    @Override
    public void documentProcessed(int idDocument) throws SQLException {
        this.getDao().documentProcesat(idDocument);
    }

    @Override
    public void documentDeleted(Timestamp dateOfDeadDocument) throws SQLException {
        StockLogic.getInstance().deleteFiseMagazieLaData(dateOfDeadDocument);
        StockLogic.getInstance().deleteStockConsumLaData(dateOfDeadDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document getDocumentById(int idDocument) throws SQLException {
        try {
            Document result;
            Document document = result = this.getDao().getDocumentById(idDocument);
            return document;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Document document = null;
            return document;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    @Override
    public void deleteAllDocuments(int tipDocument) throws SQLException {
        switch (tipDocument) {
            case 2: {
                this.getDao().deleteAllDocuments("id_intrare", this.pool.requestConnection().getConnection());
                break;
            }
            case 3: 
            case 13: {
                this.getDao().deleteAllDocuments("id_order", this.pool.requestConnection().getConnection());
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculareDeLaData(Timestamp t) {
        try {
            this.stockLogic.deleteStockConsumDupaData(t);
            this.getDao().setDocumenteUlterioareNeprocesate(t);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    @Override
    public Timestamp getTimeDocument(int tipDocument, Timestamp proposedTime) throws SQLException {
        switch (tipDocument) {
            case 2: {
                return this.getNextTimestamp(0, proposedTime);
            }
            case 7: {
                return this.getNextTimestamp(1, proposedTime);
            }
            case 9: {
                return this.getNextTimestamp(3, proposedTime);
            }
            case 3: 
            case 13: {
                return this.getNextTimestamp(4, proposedTime);
            }
            case 4: {
                return this.getNextTimestamp(5, proposedTime);
            }
            case 8: {
                return this.getNextTimestamp(6, proposedTime);
            }
            case 5: {
                return this.getNextTimestamp(7, proposedTime);
            }
            case 6: {
                return this.getNextTimestamp(8, proposedTime);
            }
        }
        return this.getNextTimestamp(9, proposedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp getNextTimestamp(int prioritate, Timestamp proposedTime) {
        int startIndex = prioritate * 100;
        int stopIndex = (prioritate + 1) * 100;
        boolean ok = false;
        while (!ok) {
            Timestamp start = DateUtils.setMillis(proposedTime, startIndex);
            Timestamp stop = DateUtils.setMillis(proposedTime, stopIndex);
            Vector documente = new Vector();
            try {
                documente = this.getDao().getDocumente(start, stop, -1);
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            finally {
                try {
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                this.pool.releaseConnection();
            }
            Timestamp max = start;
            for (int i = 0; i < documente.size(); ++i) {
                Document o = (Document)documente.elementAt(i);
                if (o.getTimeDocument().compareTo(max) <= 0) continue;
                max = o.getTimeDocument();
            }
            int lastIndex = (int)(max.getTime() % 1000L) + 1;
            if (lastIndex < stopIndex) {
                ok = true;
                proposedTime = DateUtils.setMillis(proposedTime, lastIndex);
                continue;
            }
            Date d = DateUtils.addMinutesToDate(proposedTime, 1);
            proposedTime.setTime(d.getTime());
            proposedTime = DateUtils.setMillis(proposedTime, startIndex);
        }
        return proposedTime;
    }

    @Override
    public Vector<TipDocument> getAllTipDocument() {
        Vector<TipDocument> result = new Vector<TipDocument>();
        TipDocument td1 = new TipDocument(2, "Intrare");
        result.add(td1);
        TipDocument td2 = new TipDocument(3, "Vanzare");
        result.add(td2);
        TipDocument td9 = new TipDocument(13, "Vanzare protocol");
        result.add(td9);
        TipDocument td3 = new TipDocument(4, "Bon consum");
        result.add(td3);
        TipDocument td4 = new TipDocument(5, "Productie");
        result.add(td4);
        TipDocument td5 = new TipDocument(6, "Modif pret");
        result.add(td5);
        TipDocument td6 = new TipDocument(7, "Transfer");
        result.add(td6);
        TipDocument td7 = new TipDocument(8, "Factura emisa");
        result.add(td7);
        TipDocument td8 = new TipDocument(9, "Corectie");
        result.add(td8);
        return result;
    }

    public Vector<TipDocument> getAllTipDocumentForConsum() {
        Vector<TipDocument> result = new Vector<TipDocument>();
        TipDocument td2 = new TipDocument(3, "Vanzare");
        result.add(td2);
        TipDocument td9 = new TipDocument(13, "Vanzare protocol");
        result.add(td9);
        TipDocument td3 = new TipDocument(4, "Bon consum");
        result.add(td3);
        TipDocument td4 = new TipDocument(5, "Productie");
        result.add(td4);
        return result;
    }

    @Override
    public Vector getTipDocumentConsum() {
        Vector<TipDocument> result = new Vector<TipDocument>();
        TipDocument td2 = new TipDocument(3, "Vanzare");
        result.add(td2);
        TipDocument td9 = new TipDocument(13, "Vanzare protocol");
        result.add(td9);
        TipDocument td3 = new TipDocument(4, "Bon consum");
        result.add(td3);
        TipDocument td6 = new TipDocument(7, "Transfer");
        result.add(td6);
        TipDocument td7 = new TipDocument(8, "Factura emisa");
        result.add(td7);
        TipDocument td8 = new TipDocument(9, "Corectie");
        result.add(td8);
        return result;
    }

    public void alertProductie(User user) {
        if (user == null) {
            return;
        }
        if (VpConfig.getInstance().productieAlert) {
            String text = "";
            for (Sectie element : this.getSectii()) {
                String channel = "productie_" + element.getId() + "_" + user.getId();
                Vector<Message> messages = Messenger.getInstance().getMessages(channel);
                if (messages == null || messages.size() == 0) continue;
                for (Message mess : messages) {
                    text = text + "<li>" + mess.getText();
                }
                DialogUtils.htmlOkFocusEaterDialog(GuiUtils.currentFrame, text, element.getName());
                Messenger.getInstance().deleteMessagesByChannel(channel);
            }
        }
    }

    public Vector getNecesarReport(Vector<PreparareEntry> produse, int what) {
        Hashtable<Integer, NecesarReportEntry> temp = new Hashtable<Integer, NecesarReportEntry>();
        for (int i = 0; i < produse.size(); ++i) {
            PreparareEntry pe = produse.elementAt(i);
            int idProdusReteta = pe.getIdProdusReteta();
            if (idProdusReteta <= 0) continue;
            Vector<NewRecipeEntry> recipes = this.getRecipesForProdusReteta(idProdusReteta, AdministrationPanel.loggedUser.getLanguage());
            for (int j = 0; j < recipes.size(); ++j) {
                NewRecipeEntry o = recipes.elementAt(j);
                double quantity = o.getQuantity() * pe.getCantitate();
                String name = o.getName();
                int idStock = o.getIdStock();
                NecesarReportEntry existing = (NecesarReportEntry)temp.get(idStock);
                if (existing == null) {
                    NecesarReportEntry nec = new NecesarReportEntry();
                    Vector<StockViewEntry> sve = this.stockLogic.getStocksViewsForMagazie(-1, idStock, -1, -1, false, -1, what);
                    double existent = 0.0;
                    if (sve != null) {
                        for (StockViewEntry stockViewEntry : sve) {
                            existent += stockViewEntry.getStocActual();
                        }
                    }
                    nec.setExistent(existent);
                    nec.setNecesar(quantity);
                    nec.setDeAchizitionat(nec.getNecesar() - nec.getExistent());
                    if (nec.getDeAchizitionat() < 0.0) {
                        nec.setDeAchizitionat(0.0);
                    }
                    nec.setProdus(name);
                    nec.setUm(o.getUm());
                    temp.put(idStock, nec);
                    continue;
                }
                existing.setNecesar(existing.getNecesar() + quantity);
                existing.setDeAchizitionat(existing.getNecesar() - existing.getExistent());
                if (!(existing.getDeAchizitionat() < 0.0)) continue;
                existing.setDeAchizitionat(0.0);
            }
        }
        Vector result = new Vector(temp.values());
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDetails(int idProduct) {
        StringBuffer sb = new StringBuffer();
        Map<Integer, Integer> reteteSecundare = Collections.synchronizedMap(new LinkedHashMap());
        try {
            this.getDetails(idProduct, sb, reteteSecundare, false);
            if (reteteSecundare.size() > 0) {
                sb.append("--- RETETE SECUNDARE ---");
                boolean smth2Do = true;
                Hashtable<Integer, Integer> reteteSecundareProcesate = new Hashtable<Integer, Integer>();
                do {
                    smth2Do = false;
                    for (Integer idProduct2Process : reteteSecundare.keySet()) {
                        if (reteteSecundareProcesate.get(idProduct2Process) != null) continue;
                        smth2Do = true;
                        this.getDetails(idProduct2Process, sb, reteteSecundare, true);
                        reteteSecundareProcesate.put(idProduct2Process, idProduct2Process);
                    }
                } while (smth2Do);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return sb.toString();
    }

    private void getDetails(int idProduct, StringBuffer sb, Map<Integer, Integer> subreteteSource, boolean subreteta) throws SQLException {
        Product rp = this.nomeclaturaLogic.getProductByIdNoCommit(idProduct);
        sb.append("Materii prime pt \"" + rp.getName() + "\"" + (subreteta ? " (SUBRETETA)" : "") + "\n\n");
        int idReteta = this.getIdReteta(rp.getId());
        int idLang = 1;
        Vector<NewRecipeEntry> recipeItems = this.getRecipesForProdusRetetaNoCommit(idReteta, idLang);
        for (int i = 0; i < recipeItems.size(); ++i) {
            NewRecipeEntry o = recipeItems.elementAt(i);
            sb.append(o.getName() + " " + o.getQuantity() + " " + o.getUm() + "\n");
            int idProdusSubreteta = o.getIdProduct();
            if (idProdusSubreteta <= 0) continue;
            subreteteSource.put(idProdusSubreteta, idProdusSubreteta);
        }
        sb.append('\n');
        sb.append('\n');
        sb.append("Mod preparare:\n\n");
        sb.append(this.getModPreparareForRetetaNoCommit(idReteta));
    }

    @Override
    public Vector getWaiters() {
        Vector<User> v1 = UsersLogic.getInstance().getUsersInGroup("group_fo_users");
        return v1;
    }

    @Override
    public boolean incasatFromProductie(int idOrder, int idUser) throws SQLException {
        Order o = this.getOrderByIdNoCommit(idOrder);
        this.setUserToOrderNoCommit(idUser, o);
        if (!VpConfig.getInstance().bonFiscalAtNota) {
            if (this.cashRegisterLikesPlatiNoCommit(o)) {
                this.printBonFiscalSeparat(o, true);
            } else {
                DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.casaMarcatUnModPlata, LangRoAll.nuPotContinua);
                return false;
            }
        }
        this.closeOrderNoCommit(o, null);
        return true;
    }

    @Override
    public boolean notaFromProductie(int idOrder, int idUser) throws SQLException {
        Order o = this.getOrderByIdNoCommit(idOrder);
        this.setUserToOrderNoCommit(idUser, o);
        Table t = this.getTableByIdNoCommit(o.getTable());
        this.laPlataOrderNoCommit(o, t, VpConfig.getInstance().remizaAutomata, null, false, -1);
        if (VpConfig.getInstance().bonFiscalAtNota) {
            if (this.cashRegisterLikesPlatiNoCommit(o)) {
                this.printBonFiscalSeparat(o, true);
            } else {
                DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.casaMarcatUnModPlata, LangRoAll.nuPotContinua);
                return false;
            }
        }
        return true;
    }

    public Vector getRealWaiters() {
        Vector<User> v1 = UsersLogic.getInstance().getUsersInGroup("group_fo_users");
        Vector<User> v2 = new Vector<User>();
        for (int i = 0; i < v1.size(); ++i) {
            User user = v1.elementAt(i);
            if (user.isVirtual()) continue;
            v2.add(user);
        }
        return v2;
    }

    public Vector getAdmins() {
        return UsersLogic.getInstance().getUsersInGroup("group_bo_users");
    }

    public Vector getVanzariPeZile(Hashtable criteria) {
        try {
            Date startDate = (Date)criteria.get(Constants.START_KEY);
            Date stopDate = (Date)criteria.get(Constants.STOP_KEY);
            Timestamp s1 = new Timestamp(startDate.getTime());
            Timestamp s2 = new Timestamp(stopDate.getTime());
            Vector result = this.getDao().getVanzariPeZile(s1, s2);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return result;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return new Vector();
        }
    }

    @Override
    public String canDeleteUser(User u) {
        Vector orders = this.getOpenOrdersByUser(u);
        if (orders.size() > 0) {
            return "Acest utilizator are mese deschise";
        }
        return null;
    }

    public Vector getLocationsByLocationNames(Vector locationNames) {
        Vector<Location> result = new Vector<Location>();
        for (int i = 0; i < locationNames.size(); ++i) {
            String o = (String)locationNames.elementAt(i);
            Location l = this.getLocationByName(o);
            result.add(l);
        }
        return result;
    }

    public Vector getDetaliiForVanzareNedescarcata(int idProduct, int idSectie) {
        return new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformaRetetaInProdusFinit(int idReteta, int idProdus) {
        Product p = this.nomeclaturaLogic.getProductById(idProdus);
        double pret = this.getPriceForProductCommit(idProdus);
        try {
            int idStock = this.stockLogic.addStockNoCommit(p.getName(), 1, 0.0, 0.0, pret, true);
            this.stockLogic.pasteExistingProductToStock(idStock, idProdus);
            Vector content = this.getProductsDao().getRecipeItemsForProdusRetetaId(idReteta);
            for (int i = 0; i < content.size(); ++i) {
                RecipeItem item = (RecipeItem)content.elementAt(i);
                this.getProductsDao().deleteRecipeItem(item.getId());
            }
            this.getProductsDao().deleteProdusReteta(idReteta);
            this.pool.commit();
            this.stockLogic.stockAdded(idStock);
            NomeclaturaLogic.getInstance().productAdded(idProdus, pret);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean transformaProdusFinitInReteta(int idStock, int idProdus, double price, boolean stergeStocul, boolean adaugaStocInReteta, Component parent) {
        boolean result = false;
        try {
            this.transformaMarfaInRetetaNoCommit(idStock, idProdus, price, stergeStocul, adaugaStocInReteta, parent);
            this.pool.requestConnection().commitTransaction();
            result = true;
            this.notifyListeners(2);
            Product rp = this.nomeclaturaLogic.getProductById(idProdus);
            this.notifyObjectListeners(101, rp);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.requestConnection().rollback();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    public int transformaMarfaInRetetaNoCommit(int idStock, int idProdus, double price, boolean stergeStocul, boolean adaugaStocInReteta, Component parent) throws SQLException {
        Vector<NewRecipeEntry> recipeItems = new Vector<NewRecipeEntry>();
        this.getProductsDao().addProdusReteta(idProdus, price, "", true);
        int idProdusReteta = this.pool.requestConnection().getIndentityLocal();
        this.stockLogic.deleteProdusFinitByProductId(idProdus);
        if (adaugaStocInReteta) {
            NewRecipeEntry rc = new NewRecipeEntry();
            rc.setQuantity(1.0);
            rc.setIdStock(idStock);
            recipeItems.add(rc);
        }
        if (stergeStocul) {
            this.stockLogic.deleteStock(idStock, parent);
        }
        if (recipeItems.size() > 0) {
            this.addItemsToRetetaProductNoCommit(idProdusReteta, recipeItems);
        }
        return idProdusReteta;
    }

    public Vector<Meniu> getAllMeniuriActive() {
        Vector<Meniu> result = new Vector<Meniu>();
        Vector<Meniu> all = this.getAllMeniuri();
        for (Meniu meniu1 : all) {
            if (!meniu1.isActiv()) continue;
            String start = meniu1.getOraStart();
            String stop = meniu1.getOraStop();
            if (!PromotionPeriod.isPromotionActive(meniu1.getZile(), 2, start, stop, new Date())) continue;
            result.add(meniu1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Meniu> getAllMeniuri() {
        Vector<Meniu> result = new Vector();
        try {
            result = this.getDao().getAllMeniuri(-1);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Meniu getMeniuById(int id) {
        Meniu result = null;
        try {
            result = this.getDao().getMeniuById(id);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.commit();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addMeniu(String label, String zile, String oraStart, String oraStop, String codsync) {
        int result = -1;
        try {
            this.getDao().addMeniu(label, zile, oraStart, oraStop, codsync);
            result = this.pool.getIdentityLocal();
            if (codsync != "") {
                this.setCodsyncForMeniu(result, codsync);
            } else {
                this.setCodsyncForMeniu(result, "" + result);
            }
            this.pool.requestConnection().commitTransaction();
            this.notifyListeners(401);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.requestConnection().rollback();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMeniu(String label, boolean activ, int id, String zile, String oraStart, String oraStop) {
        try {
            this.getDao().updateMeniu(label, activ, zile, oraStart, oraStop, id);
            this.pool.requestConnection().commitTransaction();
            this.notifyListeners(401);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.requestConnection().rollback();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMeniu(int id) {
        try {
            this.getDao().deleteMeniu(id);
            this.pool.requestConnection().commitTransaction();
            this.notifyListeners(401);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.requestConnection().rollback();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllOptiuni() {
        Vector result = new Vector();
        try {
            result = this.getDao().getAllOptiuni();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<OptiuneProdus> getOptiuniProdus(int idMeniu, int idOptiune) {
        try {
            Vector<OptiuneProdus> vector = this.getDao().getOptiuniProdus(idMeniu, idOptiune);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<OptiuneProdus> vector = new Vector<OptiuneProdus>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getOptiuniProdusFrontOffice(int idMeniu, int idOptiune) {
        try {
            Vector<OptiuneProdus> temp = this.getDao().getOptiuniProdus(idMeniu, idOptiune);
            Vector<OptiuneProdus> result = new Vector<OptiuneProdus>();
            for (int i = 0; i < temp.size(); ++i) {
                OptiuneProdus op = temp.elementAt(i);
                if (op.getIdCategorie() > 0) {
                    Categorie c = this.nomeclaturaLogic.getCategoryById(op.getIdCategorie());
                    Vector products = this.nomeclaturaLogic.getProductsForCategorie(c);
                    for (int j = 0; j < products.size(); ++j) {
                        Product product = (Product)products.elementAt(j);
                        OptiuneProdus op1 = new OptiuneProdus();
                        op1.setId(op.getId());
                        op1.setCantitate(op.getCantitate());
                        op1.setPret(op.getPret());
                        op1.setIdProdus(product.getId());
                        op1.setProduct(product.getName());
                        result.add(op1);
                    }
                    continue;
                }
                Product product = this.nomeclaturaLogic.getProductByIdNoCommit(op.getIdProdus());
                if (product == null || product.getStatus() != 1) continue;
                result.add(op);
            }
            Collections.sort(result, new Comparator(){

                public int compare(Object o1, Object o2) {
                    OptiuneProdus op1 = (OptiuneProdus)o1;
                    OptiuneProdus op2 = (OptiuneProdus)o2;
                    return op1.getProduct().compareToIgnoreCase(op2.getProduct());
                }
            });
            Vector<OptiuneProdus> i = result;
            return i;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getOptiuniForMenu(int idMeniu) {
        try {
            Vector vector = this.getDao().getOptiuniForMenu(idMeniu);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOptiuneProdus(int idMeniu, int idCategorie, int idProdus, int idOptiune, double pret, double cant) {
        try {
            this.getDao().addOptiuneProdus(idMeniu, idCategorie, idProdus, idOptiune, pret, cant);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOptiuneProdus(int id) {
        try {
            this.getDao().deleteOptiuneProdus(id);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void exportMeniuToXml(int idData, String destinationFile) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<document>");
        Meniu meniu = RestLogic.getInstance().getMeniuById(idData);
        if (meniu != null) {
            bigFile.append("<meniu ");
            bigFile.append("\tlabel=\"" + meniu.getLabel() + "\"\n");
            bigFile.append("\tcodsync=\"" + meniu.getCodsync() + "\"\n");
            bigFile.append("\tactiv=\"" + (meniu.isActiv() ? "true" : "false") + "\"\n");
            bigFile.append("\tzile=\"" + meniu.getZile() + "\"\n");
            bigFile.append("\torastart=\"" + meniu.getOraStart() + "\"\n");
            bigFile.append("\torastop=\"" + meniu.getOraStop() + "\"\n");
            bigFile.append("\tstatus=\"" + meniu.getStatus() + "\"\n");
            bigFile.append("/>\n");
            Vector<OptiuneProduseMeniu> optiuni = RestLogic.getInstance().getAllOptiuniProduse();
            for (OptiuneProduseMeniu op : optiuni) {
                if (op.getIdMeniu().intValue() != meniu.getId()) continue;
                bigFile.append("<optiune ");
                Product p = this.nomeclaturaLogic.getProductById(op.getIdProduct());
                if (p != null) {
                    bigFile.append("\tcodSync=\"" + p.getCodSync() + "\"\n");
                }
                String o = this.getLabelOptiuneFromId(op.getIdOptiune());
                bigFile.append("\toptiune=\"" + o + "\"\n");
                bigFile.append("\tlabelmeniu=\"" + this.getMeniuById(op.getIdMeniu()).getLabel() + "\"\n");
                bigFile.append("\tpret=\"" + op.getPret() + "\"\n");
                bigFile.append("\tcantitate=\"" + op.getCantitate() + "\"\n");
                Integer idSubcategory = op.getIdSubcategory();
                Categorie c = this.nomeclaturaLogic.getCategoryById(idSubcategory);
                if (c != null) {
                    bigFile.append("\tsubcategory=\"" + c.getName() + "\"\n");
                }
                bigFile.append("/>\n");
            }
        }
        bigFile.append("</document>");
        try {
            FileUtils.writeTextToFile(destinationFile, bigFile.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void exportSalesToXml(Hashtable criteria, Vector sales, String destinationFile, double totalOrder, int cardinal, long closedate, String optionalAttributes) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<document cardinal=\"" + cardinal + "\"" + " total=\"" + Utils.getString2Decimals(totalOrder) + "\"");
        String tipPlata2 = "";
        Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrder(cardinal);
        for (int i = 0; i < plati.size(); ++i) {
            Plata plata = plati.elementAt(i);
            double suma = plata.getSuma();
            String tp = plata.getTipPlata();
            String partialS = tp + "|" + Utils.getString2Decimals(suma);
            tipPlata2 = tipPlata2 + partialS + ";";
        }
        bigFile.append(" tipuri_plata=\"" + tipPlata2 + "\"");
        bigFile.append(" closedate=\"" + closedate + "\"");
        bigFile.append(" " + optionalAttributes);
        bigFile.append(">\n");
        bigFile.append("<filters ");
        for (Object o : criteria.keySet()) {
            Object v = criteria.get(o);
            bigFile.append("\t" + TextUtils.escapeForXML(o.toString()) + "=\"" + TextUtils.escapeForXML(v.toString()) + "\"\n");
        }
        bigFile.append("/>\n");
        Hashtable<Integer, Promotion> promotiiHash = new Hashtable<Integer, Promotion>();
        for (int i = 0; i < sales.size(); ++i) {
            bigFile.append("<sale ");
            SalesEntry s = (SalesEntry)sales.elementAt(i);
            bigFile.append("\tprodus=\"" + TextUtils.escapeForXML(s.getProduct()) + "\"\n");
            bigFile.append("\tcodBare=\"" + s.getProductCodBare() + "\"\n");
            bigFile.append("\tcodSync=\"" + s.getCodSync() + "\"\n");
            bigFile.append("\tpret=\"" + Utils.getString2Decimals(s.getPrice()) + "\"\n");
            bigFile.append("\tdiscount=\"" + Utils.getString2Decimals(s.getDiscount()) + "\"\n");
            bigFile.append("\toriginalPrice=\"" + Utils.getString2Decimals(s.getOriginalPrice()) + "\"\n");
            bigFile.append("\tcantitate=\"" + Utils.getString3Decimals(s.getQuantity()) + "\"\n");
            int idPromotion = s.getIdPromotion();
            Promotion existingPromo = (Promotion)promotiiHash.get(idPromotion);
            if (existingPromo == null && (existingPromo = PromotionLogic.getInstance().getPromotionById(idPromotion)) != null) {
                promotiiHash.put(idPromotion, existingPromo);
            }
            if (existingPromo != null) {
                bigFile.append("\tpromoName=\"" + existingPromo.getLabel() + "\"\n");
            }
            bigFile.append("/>\n");
        }
        bigFile.append("</document>");
        try {
            FileUtils.writeTextToFile(destinationFile, bigFile.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void importMateriiPrimeMasterERP(String excelFile) {
        try {
            ExcelUtils.readExcel(new File(excelFile), new ExcelImportInterface(){
                String name = "";
                boolean isCategory = false;
                double price = 0.0;
                int idCategorie = -1;
                int idSectie = 2;

                @Override
                public void sheetEnd(String sheetName) {
                }

                @Override
                public void lineEnd() {
                    if (this.name != null) {
                        if (this.isCategory) {
                            System.out.println("Am gasit categoria : " + this.name);
                            Categorie c = RestLogic.this.nomeclaturaLogic.getCategoryByName(this.name);
                            if (c == null) {
                                Tva t = TvaLogic.getInstance().getTvas().elementAt(0);
                                this.idCategorie = RestLogic.this.nomeclaturaLogic.newCategory(this.idSectie, this.name, Color.WHITE.getRGB(), "" + this.idSectie, t.getId(), false, 0.0);
                            } else {
                                this.idCategorie = c.getId();
                            }
                        } else {
                            String um = "buc";
                            Unit u = UnitsLogic.getInstance().getUnitByName(um);
                            Stock s = RestLogic.this.stockLogic.getStockByName(this.name);
                            if (s == null) {
                                int cod = RestLogic.this.nomeclaturaLogic.getNextProductCode();
                                String codBare = "" + cod;
                                Vector<String> barcodes = new Vector<String>();
                                barcodes.add(codBare);
                                RestLogic.this.stockLogic.addProdusFinit(this.name, u.getId(), this.idCategorie, cod, 0.0, 0.0, 0.0, false, null, true, barcodes);
                            }
                        }
                    }
                    this.isCategory = false;
                }

                @Override
                public void lineStart() {
                }

                @Override
                public void sheetStart(String sheetName) {
                }

                @Override
                public void valueRead(int row, int column, String value) {
                    switch (column) {
                        case 1: {
                            if (Validators.correctString(value)) {
                                this.name = value;
                                break;
                            }
                            this.name = null;
                            break;
                        }
                        case 10: {
                            if (!Validators.correctString(value)) break;
                            this.isCategory = true;
                            break;
                        }
                        case 14: {
                            if (!Validators.correctDouble(value)) break;
                            this.price = Utils.parseDouble(value);
                            break;
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (BiffException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }

    public void importRetetarMasterERP(String excelFile) {
        try {
            ExcelUtils.readExcel(new File(excelFile), new ExcelImportInterface(){
                int idSectie = 1;
                int idCategorie = -1;
                int idProdus = -1;
                boolean ingredientLine;
                String stockName = "";
                String stockQ = "";
                String productName = "";

                @Override
                public void lineEnd() {
                }

                @Override
                public void sheetEnd(String sheetName) {
                }

                @Override
                public void lineStart() {
                }

                @Override
                public void sheetStart(String sheetName) {
                }

                @Override
                public void valueRead(int row, int column, String value) {
                    if (Validators.correctString(value)) {
                        switch (column) {
                            case 0: {
                                System.out.println("Am gasit categoria : " + value);
                                Categorie c = RestLogic.this.nomeclaturaLogic.getCategoryByName(value);
                                if (c == null) {
                                    Tva t = TvaLogic.getInstance().getTvas().elementAt(0);
                                    this.idCategorie = RestLogic.this.nomeclaturaLogic.newCategory(this.idSectie, value, Color.WHITE.getRGB(), "" + this.idSectie, t.getId(), false, 0.0);
                                    break;
                                }
                                this.idCategorie = c.getId();
                                break;
                            }
                            case 1: {
                                System.out.println("\tAm gasit reteta : " + value);
                                int cod = RestLogic.this.nomeclaturaLogic.getNextProductCode();
                                Vector<String> barcodes = new Vector<String>();
                                barcodes.add(cod + "");
                                this.idProdus = RestLogic.this.newRetetaProduct(this.idCategorie, value, 0.0, new Vector(), cod, value, value, "", "", "", false, true, false, new Vector(), null, cod + "", barcodes);
                                break;
                            }
                            case 4: {
                                System.out.print("\t\tAm gasit ingredientul : " + value);
                                this.ingredientLine = true;
                                this.stockName = value;
                                break;
                            }
                            case 10: {
                                if (!this.ingredientLine) break;
                                System.out.print(" = " + value);
                                this.stockQ = value;
                                break;
                            }
                            case 11: {
                                if (this.ingredientLine) {
                                    System.out.print(" " + value + "\n");
                                    String um = value;
                                    double ration = 1.0;
                                    if (value.equalsIgnoreCase("GR")) {
                                        um = "kg";
                                        ration = 1000.0;
                                    } else if (value.equalsIgnoreCase("ML")) {
                                        um = "l";
                                        ration = 1000.0;
                                    } else if (value.equalsIgnoreCase("BUC")) {
                                        um = "buc";
                                    }
                                    Unit u = UnitsLogic.getInstance().getUnitByName(um);
                                    int idStock = -1;
                                    Stock s = RestLogic.this.stockLogic.getStockByName(this.stockName);
                                    idStock = s == null ? RestLogic.this.stockLogic.addStock(this.stockName, u.getId(), 0.0, 0.0, -1.0, true) : s.getId();
                                    double q = Utils.parseDouble(this.stockQ);
                                    int idReteta = RestLogic.this.getIdReteta(this.idProdus);
                                    RestLogic.this.addIngredientToProduct(idReteta, idStock, -1, q /= ration, this.stockName, this.productName);
                                }
                                this.ingredientLine = false;
                                this.stockName = "";
                                this.stockQ = "";
                                break;
                            }
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (BiffException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importProduseFromExcelBatch(Vector<ImportProduseBean> toImport, ImportProduseInterface importIterface) {
        int batchSize = 50;
        try {
            int positionInBatch = 1;
            for (ImportProduseBean bean : toImport) {
                String sectie = bean.sectie;
                String categorie = bean.categorie;
                String produs = bean.produs;
                Sectie s = null;
                s = this.nomeclaturaLogic.getSectieByNameNoCommit(sectie);
                if (s == null) {
                    int idSectie = this.nomeclaturaLogic.addSectieNoCommit(sectie, "", "");
                    s = this.nomeclaturaLogic.getSectieByIdNoCommit(idSectie);
                }
                Categorie c = null;
                c = this.nomeclaturaLogic.getCategoryByNameNoCommit(categorie);
                if (c == null) {
                    c = this.nomeclaturaLogic.newCategoryNoCommit(s.getId(), categorie, Color.WHITE.getRGB(), s.getCod() + "", 1, false, 0.0);
                }
                Product existingProduct = null;
                Double price = bean.pret / bean.cantitate;
                if (!importIterface.isInsert()) {
                    existingProduct = NomeclaturaLogic.getInstance().getProductForNameAndPriceNoCommit(produs, price);
                }
                int cod = 0;
                cod = existingProduct == null ? (Validators.correctInteger(bean.codIntern) ? Integer.parseInt(bean.codIntern) : NomeclaturaLogic.getInstance().getNextProductCodeNoCommit()) : existingProduct.getCod();
                importIterface.importProduse(s, c, existingProduct, bean.um, cod, produs, bean.pret, bean.cantitate, bean.ambalare, bean.eta, bean.codBare);
                if (batchSize > ++positionInBatch) continue;
                positionInBatch = 1;
                this.pool.commit();
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void importProduseFromExcel(String excelFile, final ImportProduseInterface importIterface1) {
        try {
            ExcelUtils.readExcel(new File(excelFile), new ExcelImportInterface(){
                int line = 1;
                ImportProduseBean importProduseBean = new ImportProduseBean();
                Vector<ImportProduseBean> importProduseBatch = new Vector();

                @Override
                public void sheetEnd(String sheetName) {
                    RestLogic.this.importProduseFromExcelBatch(this.importProduseBatch, importIterface1);
                    this.importProduseBatch.clear();
                }

                @Override
                public void lineEnd() {
                    if (this.importProduseBean.isCompleted()) {
                        this.importProduseBatch.add(this.importProduseBean);
                    } else {
                        Logger.logWarning(this, "Line incomplete : " + this.line);
                    }
                    ++this.line;
                }

                @Override
                public void lineStart() {
                    this.importProduseBean = new ImportProduseBean();
                }

                @Override
                public void sheetStart(String sheetName) {
                }

                @Override
                public void valueRead(int row, int column, String value) {
                    switch (column) {
                        case 0: {
                            this.importProduseBean.sectie = value;
                            break;
                        }
                        case 1: {
                            this.importProduseBean.categorie = value;
                            break;
                        }
                        case 2: {
                            this.importProduseBean.produs = value;
                            break;
                        }
                        case 3: {
                            if (!Validators.correctString(value)) break;
                            this.importProduseBean.codIntern = value;
                            break;
                        }
                        case 4: {
                            value = value.replaceAll(",", ".");
                            if (!Validators.correctDouble(value)) break;
                            this.importProduseBean.pret = Utils.parseDouble(value);
                            break;
                        }
                        case 5: {
                            this.importProduseBean.um = value;
                            break;
                        }
                        case 6: {
                            value = value.replaceAll(",", ".");
                            if (Validators.correctDouble(value)) {
                                this.importProduseBean.cantitate = Utils.parseDouble(value);
                                break;
                            }
                            this.importProduseBean.cantitate = 1.0;
                            break;
                        }
                        case 7: {
                            value = value.replaceAll(",", ".");
                            if (Validators.correctDouble(value)) {
                                this.importProduseBean.ambalare = Utils.parseDouble(value);
                                break;
                            }
                            this.importProduseBean.ambalare = 1.0;
                            break;
                        }
                        case 8: {
                            value = value.replaceAll(",", ".");
                            if (Validators.correctInteger(value)) {
                                this.importProduseBean.eta = Integer.parseInt(value);
                                break;
                            }
                            this.importProduseBean.eta = 1;
                            break;
                        }
                        default: {
                            if (!Validators.correctString(value)) break;
                            this.importProduseBean.codBare.add(value);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (BiffException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }

    public void importOrdersFromXml(String importFile) {
        try {
            Utils.importXml(new DefaultHandler(){
                private Vector tempSales = new Vector();
                boolean protocol = false;
                private int idTable;
                private int idWaiter;
                private long dateadd;
                private boolean fiscal;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equalsIgnoreCase("order")) {
                        this.idWaiter = Integer.parseInt(attributes.getValue("idWaiter"));
                        this.idTable = Integer.parseInt(attributes.getValue("idTable"));
                        this.dateadd = Long.parseLong(attributes.getValue("dateadd"));
                        this.fiscal = Boolean.parseBoolean(attributes.getValue("f"));
                    }
                    if (qName.equalsIgnoreCase("sale")) {
                        int idProduct = Integer.parseInt(attributes.getValue("idProduct"));
                        double q = Utils.parseDouble(attributes.getValue("quantity"));
                        double price = Utils.parseDouble(attributes.getValue("price"));
                        Product p = RestLogic.this.nomeclaturaLogic.getProductById(idProduct);
                        Sale s = RestLogic.this.buildSale(p, 0.0, q, "", -1, -1, -1, -1, -1, this.dateadd, price, "", 0);
                        this.tempSales.add(s);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equalsIgnoreCase("order")) {
                        try {
                            Order order = RestLogic.this.newOrderNoCommit(this.idTable, this.idWaiter, this.protocol);
                            RestLogic.this.allSalesToDbNoCommit(this.tempSales, order, this.idWaiter);
                            order.setFiscal(this.fiscal);
                            RestLogic.this.getOrdersDao().setFiscal(order);
                            RestLogic.this.closeOrderNoCommit(order, new Timestamp(this.dateadd));
                            RestLogic.this.pool.commit();
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                            try {
                                RestLogic.this.pool.rollBack();
                            }
                            catch (SQLException e1) {
                                Logger.logException(this, (Exception)e1);
                            }
                        }
                        finally {
                            RestLogic.this.pool.releaseConnection();
                        }
                        this.tempSales = new Vector();
                    }
                }
            }, importFile);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SAXException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void exportOrdersToXml(Hashtable criteria, Vector sales, String destinationFile) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<document>\n");
        bigFile.append("<filters ");
        for (Object o : criteria.keySet()) {
            Object v = criteria.get(o);
            bigFile.append("\t" + TextUtils.escapeForXML(o.toString()) + "=\"" + TextUtils.escapeForXML(v.toString()) + "\"\n");
        }
        bigFile.append("/>\n");
        boolean firstbon = true;
        int lastOrderId = -1;
        for (int i = 0; i < sales.size(); ++i) {
            NoteView noteView = (NoteView)sales.elementAt(i);
            boolean insideOrder = false;
            int currentId = noteView.getIdOrder();
            if (lastOrderId != currentId) {
                insideOrder = false;
                lastOrderId = currentId;
            } else {
                insideOrder = true;
            }
            if (!insideOrder) {
                if (!firstbon) {
                    bigFile.append("</order>\n");
                }
                bigFile.append("<order ");
                bigFile.append("dateadd=\"" + noteView.getData().getTime() + "\" ");
                bigFile.append("idTable=\"" + noteView.getIdTable() + "\" ");
                bigFile.append("idWaiter=\"" + noteView.getIdWaiter() + "\" ");
                bigFile.append("f=\"" + noteView.isFiscal() + "\" ");
                if (VpConfig.getInstance().showDetaliiNota) {
                    bigFile.append("detalii=\"" + noteView.getDetalii() + "\" ");
                }
                bigFile.append(">\n");
                firstbon = false;
            }
            bigFile.append("\t<sale ");
            bigFile.append("idProduct=\"" + noteView.getIdProdus() + "\" ");
            bigFile.append("productName=\"" + TextUtils.escapeForXML(noteView.getProdus()) + "\" ");
            bigFile.append("quantity=\"" + Utils.getString3Decimals(noteView.getCantitate()) + "\" ");
            double price = noteView.getSuma() / noteView.getCantitate();
            bigFile.append("price=\"" + Utils.getString3Decimals(price) + "\"/>\n");
        }
        bigFile.append("</order>\n");
        bigFile.append("</document>");
        try {
            FileUtils.writeTextToFile(destinationFile, bigFile.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void introduNumerar(double toInput) {
        this.cashRegister.introduNumerar(toInput);
    }

    public void forceEcrTotal() {
        this.cashRegister.forceTotal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserToOrder(int idUser, Order o) {
        try {
            this.setUserToOrderNoCommit(idUser, o);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void setUserToOrderNoCommit(int idUser, Order o) throws SQLException {
        o.setUser(idUser);
        this.getOrdersDao().setUserToOrder(o.getId(), idUser);
    }

    public Vector<Shift> getShifts() {
        return EventsLogic.getInstance().getShifts(1);
    }

    public String salveazaCoduriCantarBizerba(Component parent) {
        StringBuffer buf = new StringBuffer();
        String result = "";
        Vector<Product> allProducts = this.nomeclaturaLogic.getProduseCantar();
        Collections.sort(allProducts, new Comparator(){

            public int compare(Object o1, Object o2) {
                Product p1 = (Product)o1;
                Product p2 = (Product)o2;
                return p1.getId() - p2.getId();
            }
        });
        int charsPerLine = VpConfig.getInstance().cantardigicharsperline;
        for (int i = 0; i < allProducts.size(); ++i) {
            Product product = allProducts.elementAt(i);
            String codBare = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(product.getId());
            if (codBare == null || codBare.length() >= 5) continue;
            String line = "";
            String nume1 = product.getNumeCasa();
            nume1 = Utils.getStringMaxSize(charsPerLine, nume1, Character.valueOf(' '), false);
            String PLU = Utils.getStringMaxSize(4, codBare, Character.valueOf('0'), true);
            double pret = this.getPriceForProductCommit(product.getId());
            long c = FloatUtils.convertToLong(pret, 2);
            String pretS = Utils.getStringMaxSize(7, c + "", Character.valueOf('0'), true);
            line = PLU + nume1 + pretS + "0001";
            buf.append(line + "\r\n");
        }
        try {
            String exportFile = VpConfig.getInstance().cantarExportFile;
            FileUtils.writeTextToFile(exportFile, buf.toString());
            result = new File(exportFile).getAbsolutePath();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            result = null;
        }
        return result;
    }

    public String salveazaCoduriCantarDigi(Component parent) {
        StringBuffer buf = new StringBuffer();
        String result = "";
        Vector<Product> allProducts = this.nomeclaturaLogic.getProduseCantar();
        Collections.sort(allProducts, new Comparator(){

            public int compare(Object o1, Object o2) {
                Product p1 = (Product)o1;
                Product p2 = (Product)o2;
                return p1.getId() - p2.getId();
            }
        });
        int charsPerLine = VpConfig.getInstance().cantardigicharsperline;
        for (int i = 0; i < allProducts.size(); ++i) {
            String line = "";
            Product product = allProducts.elementAt(i);
            String codBare = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(product.getId());
            if (codBare == null || codBare.length() >= 5) continue;
            String nume1 = product.getNumeCasa();
            String nume2 = "";
            if (nume1.length() > charsPerLine) {
                nume2 = nume1.substring(charsPerLine, Math.min(2 * charsPerLine, nume1.length()));
                nume2 = nume2.trim();
                nume1 = nume1.substring(0, charsPerLine);
            }
            int baseSize = 29;
            if (Validators.correctString(nume2)) {
                baseSize += 2;
            }
            int pachetSize = baseSize + nume1.length() + nume2.length();
            String PLU = Utils.getStringMaxSize(8, codBare, Character.valueOf('0'), true);
            line = line + PLU;
            String PLU_RECORD_SIZE = Utils.getStringMaxSize(4, Utils.hexString((byte)pachetSize), Character.valueOf('0'), true);
            line = line + PLU_RECORD_SIZE;
            line = line + "7000";
            line = line + "0D2000";
            double pret = this.getPriceForProductCommit(product.getId());
            long c = FloatUtils.convertToLong(pret, 2);
            line = line + Utils.getStringMaxSize(8, c + "", Character.valueOf('0'), true);
            line = line + "11";
            line = line + "05";
            line = line + "29" + Utils.getStringMaxSize(5, codBare, Character.valueOf('0'), true) + "0000000";
            line = line + VpConfig.getInstance().cantardigifontsize;
            line = line + Utils.getStringMaxSize(2, Utils.hexString((byte)nume1.length()), Character.valueOf('0'), true);
            line = line + Utils.getAsciiEncoding(nume1);
            line = line + "0D";
            if (Validators.correctString(nume2)) {
                line = line + VpConfig.getInstance().cantardigifontsize;
                line = line + Utils.getStringMaxSize(2, Utils.hexString((byte)nume2.length()), Character.valueOf('0'), true);
                line = line + Utils.getAsciiEncoding(nume2);
            }
            line = line + "0C";
            line = line + "00";
            buf.append(line);
        }
        try {
            String exportFile = VpConfig.getInstance().cantarExportFile;
            FileUtils.writeTextToFile(exportFile, buf.toString());
            result = new File(exportFile).getAbsolutePath();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            result = null;
        }
        return result;
    }

    public String salveazaCoduriCantarDatecsDT15(Component parent) {
        StringBuffer buf = new StringBuffer();
        buf.append("\"Nr\",\"Code\",\"Price\",\"Name\",\r\n");
        String result = "";
        Vector<Product> allProducts = this.nomeclaturaLogic.getProduseCantar();
        Collections.sort(allProducts, new Comparator(){

            public int compare(Object o1, Object o2) {
                Product p1 = (Product)o1;
                Product p2 = (Product)o2;
                return p1.getId() - p2.getId();
            }
        });
        int k = 0;
        for (int i = 0; i < allProducts.size(); ++i) {
            Product product = allProducts.elementAt(i);
            String codBare = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(product.getId());
            if (codBare == null || codBare.length() >= 5) continue;
            double pret = this.getPriceForProductCommit(product.getId());
            long c = FloatUtils.convertToLong(pret, 2);
            String line = "\"" + (k + 1) + "\",\"" + codBare + "\",\"" + c + "\",\"" + product.getNumeCasa() + "\",\r\n";
            buf.append(line);
            ++k;
        }
        try {
            String exportFile = VpConfig.getInstance().cantarExportFile;
            FileUtils.writeTextToFile(exportFile, buf.toString());
            result = new File(exportFile).getAbsolutePath();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            result = null;
        }
        return result;
    }

    public String salveazaCoduriCantarAclas(Component parent) {
        String exportFile = VpConfig.getInstance().cantarExportFile;
        String result = null;
        if (Validators.correctString(exportFile)) {
            Vector<Product> allProducts = this.nomeclaturaLogic.getProduseCantar();
            Collections.sort(allProducts, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Product p1 = (Product)o1;
                    Product p2 = (Product)o2;
                    return p1.getId() - p2.getId();
                }
            });
            File f = new File(exportFile);
            try {
                ExcelUtils.writeExcel(f, allProducts, new ExcelProcessor(){

                    @Override
                    public void processLine(Object o, WritableSheet sheet, int row) {
                        try {
                            Product p = (Product)o;
                            String codBare = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(p.getId());
                            double pret = RestLogic.this.getPriceForProductCommit(p.getId());
                            int column = 0;
                            Label label = new Label(column, row, p.getNumeSectie());
                            sheet.addCell((WritableCell)label);
                            label = new Label(++column, row, codBare);
                            sheet.addCell((WritableCell)label);
                            label = new Label(++column, row, codBare);
                            sheet.addCell((WritableCell)label);
                            label = new Label(++column, row, "17");
                            sheet.addCell((WritableCell)label);
                            ++column;
                            double pd = FloatUtils.roundDouble(pret, 2);
                            CellFormat cl = label.getCellFormat();
                            Font font = cl.getFont();
                            WritableFont wf = new WritableFont(font);
                            WritableCellFormat numberFormat = new WritableCellFormat(wf, (DisplayFormat)new NumberFormat("#0.00"));
                            Number numberCell = new Number(column, row, pd, (CellFormat)numberFormat);
                            sheet.addCell((WritableCell)numberCell);
                            ++column;
                        }
                        catch (WriteException e) {
                            Logger.logException(this, (Exception)((Object)e));
                        }
                    }

                    @Override
                    public String[] getColumns() {
                        return new String[]{"Nume", "CodLF", "Cod", "Tip cod bare", "Pret unitar"};
                    }

                    @Override
                    public String getSheetName() {
                        return "PLU";
                    }

                    @Override
                    public int buildHeader(WritableSheet sheet, int startRow) {
                        return 0;
                    }

                    @Override
                    public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                    }
                }, new Hashtable());
                result = f.getAbsolutePath();
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
            }
            catch (WriteException e) {
                Logger.logException(this, (Exception)((Object)e));
            }
        }
        return result;
    }

    public void lanseazaProgramCantar() {
        Utils.runCommand(VpConfig.getInstance().cantarCmdLine, new File(VpConfig.getInstance().cantarDirectory), VpConfig.getInstance().cantarTimeoutSeconds);
    }

    public String exportDatePlatforma(Component parent) {
        boolean ok;
        Date d1 = DateUtils.getFirstDayOfCurrentMonth();
        String s1 = Formatters.DATE_AND_TIME_FORMAT.format(d1);
        String start = DialogUtils.inputDialog(parent, s1, "Introduceti data de start");
        if (!Validators.correctDate(start, Formatters.DATE_AND_TIME_FORMAT)) {
            DialogUtils.errorDialog(parent, "Format de data incorect", LangRoAll.nuPotContinua);
            return null;
        }
        try {
            d1 = Formatters.DATE_AND_TIME_FORMAT.parse(start);
        }
        catch (ParseException e) {
            // empty catch block
        }
        Timestamp t1 = new Timestamp(d1.getTime());
        Date d2 = DateUtils.getFirstDayOfCurrentMonth();
        d2 = DateUtils.advanceOneMonth(d2);
        String s2 = Formatters.DATE_AND_TIME_FORMAT.format(d2);
        String stop = DialogUtils.inputDialog(parent, s2, "Introduceti data de stop");
        if (!Validators.correctDate(stop, Formatters.DATE_AND_TIME_FORMAT)) {
            DialogUtils.errorDialog(parent, "Format de data incorect", LangRoAll.nuPotContinua);
            return null;
        }
        try {
            d2 = Formatters.DATE_AND_TIME_FORMAT.parse(stop);
        }
        catch (ParseException e) {
            // empty catch block
        }
        Timestamp t2 = new Timestamp(d2.getTime());
        String saveDir = new File(VpConfig.getInstance().contaExportDir).getAbsolutePath();
        File dir = new File(saveDir);
        if (dir.exists() && dir.isFile()) {
            DialogUtils.errorDialog(parent, "Fisierul " + saveDir + " ar trebui sa fie director. Va rugam sa-l stergeti.", LangRoAll.nuPotContinua);
            return null;
        }
        if (!dir.exists() && !(ok = dir.mkdirs())) {
            DialogUtils.errorDialog(parent, "Nu am putut crea directorul " + saveDir + ". Verificati drepturile de scriere.", LangRoAll.nuPotContinua);
            return null;
        }
        ok = this.exportNirPlatforma(saveDir, t1, t2);
        if (!ok) {
            return null;
        }
        ok = this.exportConsumPlatforma(saveDir, d1, d2);
        if (!ok) {
            return null;
        }
        return saveDir;
    }

    private boolean exportConsumPlatforma(String saveDir, Date start, Date stop) {
        String fileSuffix = Formatters.PLATFORMA_BC_FILE_FORMAT.format(start);
        String bcFile = saveDir + File.separator + "BC" + fileSuffix + ".TXT";
        RestLogic restLogic = this;
        Vector result = restLogic.stockLogic.getInstance().getExportConsumPlatforma(start, stop);
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < result.size(); ++i) {
            ExportBCPlatforma o = (ExportBCPlatforma)result.elementAt(i);
            s.append(o.toString());
            s.append("\n");
        }
        try {
            FileUtils.writeTextToFile(bcFile, s.toString());
            return true;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
    }

    private boolean exportNirPlatforma(String saveDir, Timestamp start, Timestamp stop) {
        boolean gata = false;
        Date currentDay = start;
        while (!gata) {
            Date nextDay = DateUtils.advanceOneDay(currentDay);
            Vector<ExportNirPlatforma> result = ContaLogic.getInstance().getExportNirPlatforma(new Timestamp(currentDay.getTime()), new Timestamp(nextDay.getTime()));
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < result.size(); ++i) {
                ExportNirPlatforma o = result.elementAt(i);
                s.append(o.toString());
                s.append("\n");
            }
            try {
                String fileSuffix = Formatters.PLATFORMA_NIR_FILE_FORMAT.format(currentDay);
                String nirFileName = saveDir + File.separator + "NIR" + fileSuffix + ".TXT";
                FileUtils.writeTextToFile(nirFileName, s.toString());
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
                return false;
            }
            currentDay = nextDay;
            if (currentDay.getTime() < stop.getTime()) continue;
            gata = true;
        }
        return true;
    }

    public Vector<PricePanelEntry> getPricesPanelEntries() {
        Hashtable<String, Object> criteria = new Hashtable<String, Object>();
        criteria.put("Cod bare", "NULL");
        criteria.put("Categorie", -1);
        criteria.put("Product", -1);
        return this.getPricesPanelEntries(criteria);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePretCostForPricePanelEntries(Vector<PricePanelEntry> result) {
        try {
            this.updatePretCostForPricePanelEntriesNoCommit(result);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private void updatePretCostForPricePanelEntriesNoCommit(Vector<PricePanelEntry> result) throws SQLException {
        Hashtable<Integer, Categorie> categorieHashtable = new Hashtable<Integer, Categorie>();
        Hashtable<Integer, Tva> tvaHashTable = new Hashtable<Integer, Tva>();
        Hashtable<Integer, Double> allBuyPrices = this.getDao().getLatestBuyPriceForStocks(this.pool.requestConnection().getConnection());
        for (PricePanelEntry pricePanelEntry : result) {
            Tva tva;
            int currentProduct = pricePanelEntry.getIdProduct();
            int idCat = pricePanelEntry.getIdCategorie();
            Categorie cat = (Categorie)categorieHashtable.get(idCat);
            if (cat == null) {
                cat = this.nomeclaturaLogic.getCategoryById(idCat);
                categorieHashtable.put(idCat, cat);
            }
            if ((tva = (Tva)tvaHashTable.get(idCat)) == null) {
                tva = TvaLogic.getInstance().getTvaById(cat.getIdTva());
                tvaHashTable.put(idCat, tva);
            }
            double tvaProcent = tva.getCota();
            double v = pricePanelEntry.getPret();
            double valIngrediente = this.getPretCost(currentProduct, pricePanelEntry.getIdReteta(), pricePanelEntry.getProduct(), allBuyPrices);
            double adaos = v / ((1.0 + tvaProcent) * valIngrediente);
            double adaosProcent = (adaos - 1.0) * 100.0;
            pricePanelEntry.setLastPretAcz(valIngrediente);
            pricePanelEntry.setAdaos(adaosProcent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<PricePanelEntry> getPricesPanelEntries(Hashtable criteria) {
        Vector<PricePanelEntry> result = new Vector<PricePanelEntry>();
        try {
            int idProduct = (Integer)criteria.get("Product");
            int idCategory = (Integer)criteria.get("Categorie");
            String codBare = (String)criteria.get("Cod bare");
            result = this.getDao().getRaportPreturi(idProduct, codBare, idCategory);
            if (VpConfig.getInstance().pricesReportComputePretCostByDefault) {
                this.updatePretCostForPricePanelEntries(result);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDiagramToDb(String filename, String autor) {
        int id = -1;
        try {
            try {
                File f = new File(filename);
                int size = (int)f.length();
                FileInputStream fin = new FileInputStream(filename);
                id = DocumenteLogic.getInstance().addFileNoCommit(filename, autor, filename, "", fin, size);
            }
            catch (FileNotFoundException e) {
                Logger.logException(this, (Exception)e);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return id;
    }

    public void generateRandomTableDiagram(String file, int idLocatie) {
        String s = "<graph>\n";
        Vector<Table> tables = this.getTablesByLocation(idLocatie);
        for (int i = 0; i < tables.size(); ++i) {
            Table table = tables.elementAt(i);
            s = s + "<table type=\"patrat\" name=\"" + table.getLabel() + "\" x=\"200\" y=\"200\" width=\"100\" height=\"100\"/>\n";
        }
        s = s + "</graph>";
        try {
            FileUtils.writeTextToFile(file, s);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void generateRandomLocatiiDiagram(String file) {
        String s = "<graph>\n";
        Vector locatii = this.getLocations();
        for (int i = 0; i < locatii.size(); ++i) {
            Location location = (Location)locatii.elementAt(i);
            s = s + "<table type=\"patrat\" name=\"" + location.getName() + "\" x=\"200\" y=\"200\" width=\"100\" height=\"100\"/>\n";
        }
        s = s + "</graph>";
        try {
            FileUtils.writeTextToFile(file, s);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public int saveDiagramToDiskFromDb(String locatie) {
        int id = DocumenteLogic.getInstance().getIdFileByFilenameCommit(locatie);
        if (id != -1) {
            File f = new File(locatie);
            DocumenteLogic.getInstance().saveDocument(f, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDiagramToDb(int idFile, String filename, String autor) {
        try {
            File f = new File(filename);
            int size = (int)f.length();
            FileInputStream fin = new FileInputStream(filename);
            DocumenteLogic.getInstance().addFileVersionNoCommit(idFile, autor, "", fin, size);
            this.pool.commit();
        }
        catch (FileNotFoundException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void setPriceToProductList(Vector data) {
        for (int i = 0; i < data.size(); ++i) {
            ProductWithPrice pp = (ProductWithPrice)data.elementAt(i);
            double price = this.getPriceForProductCommit(pp.getProduct().getId());
            pp.setPrice(price);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNrPersoaneToOrder(Order o, int nrPersoane) {
        try {
            this.getOrdersDao().setNrPersoaneToOrder(nrPersoane, o.getId());
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNrPersoaneForOrder(int idOrder) {
        int result = -1;
        try {
            result = this.getOrdersDao().getNrPersoaneForOrder(idOrder);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getManagerReport(Hashtable criteria, int what) {
        Vector<ManagerReportEntry> result = new Vector<ManagerReportEntry>();
        try {
            int nrNote = this.getDao().getNrNoteInPerioada(criteria, what);
            ManagerReportEntry me1 = new ManagerReportEntry();
            me1.setAttributeName("Numar note");
            me1.setAttributeValue(Utils.getString2Decimals(nrNote));
            result.add(me1);
            int nrPersoane = this.getDao().getNrPersoaneInPerioada(criteria, what);
            ManagerReportEntry me2 = new ManagerReportEntry();
            me2.setAttributeName(LangRoAll.numarPersoane);
            me2.setAttributeValue(Utils.getString2Decimals(nrPersoane));
            result.add(me2);
            double[] totalNote = this.getDao().getTotalNote(criteria, what);
            ManagerReportEntry me3 = new ManagerReportEntry();
            me3.setAttributeName("Total note");
            me3.setAttributeValue(Utils.getString2Decimals(totalNote[0]));
            result.add(me3);
            double medieNota = totalNote[0] / (double)nrNote;
            ManagerReportEntry me4 = new ManagerReportEntry();
            me4.setAttributeName("Valoare medie nota");
            me4.setAttributeValue(Utils.getString2Decimals(medieNota));
            result.add(me4);
            int nrNoteProtocol = this.getDao().getNrNoteInPerioada(criteria, what);
            ManagerReportEntry me5 = new ManagerReportEntry();
            me5.setAttributeName("Numar note protocol");
            me5.setAttributeValue(Utils.getString2Decimals(nrNoteProtocol));
            result.add(me5);
            ManagerReportEntry me6 = new ManagerReportEntry();
            me6.setAttributeName("Total discount");
            me6.setAttributeValue(Utils.getString2Decimals(totalNote[1]));
            result.add(me6);
            double comision = this.getDao().getComision(criteria, what);
            ManagerReportEntry me7 = new ManagerReportEntry();
            me7.setAttributeName("Total comision");
            me7.setAttributeValue(Utils.getString2Decimals(comision));
            result.add(me7);
            long durataTotala = this.getDao().getDurataTotalaNote(criteria, what);
            ManagerReportEntry me8 = new ManagerReportEntry();
            int nrTotalNote = nrNote + nrNoteProtocol;
            String diferenta = "N/A";
            if (nrTotalNote > 0) {
                diferenta = DateUtils.getDiferentaIntreOre(0L, durataTotala /= (long)nrTotalNote);
            }
            me8.setAttributeName("Durata medie nota");
            me8.setAttributeValue(diferenta);
            result.add(me8);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asociereCardToTable(int idTable, String codAutentificare) {
        try {
            this.getTablesDao().setCodAutentificare(codAutentificare, idTable);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTableByCodAutentificare(String codAutentificare) {
        Table result = null;
        try {
            result = this.getTablesDao().getByCodAutentificare(codAutentificare);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCoduriForTables() {
        try {
            Vector allCodes = this.getTablesDao().getAllCodAutentificareForTables();
            StringBuffer text = new StringBuffer("Locatie|Cod\n");
            for (int i = 0; i < allCodes.size(); ++i) {
                TableCodsBean tableCodsBean = (TableCodsBean)allCodes.elementAt(i);
                text.append(tableCodsBean.getLocatieName() + " " + tableCodsBean.getTableName() + "|" + tableCodsBean.getCod() + "\n");
            }
            this.printer.printRaport("Coduri", text.toString(), 1);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public boolean isHotelEnabled() {
        if (!VpConfig.getInstance().showHotelButtons) {
            return false;
        }
        Vector locations = this.getLocations();
        for (int i = 0; i < locations.size(); ++i) {
            Location location = (Location)locations.elementAt(i);
            if (location.getTip() != 2) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<RaportPeCategoriiSiCoteTva> getRaportPeCategoriiSiCoteTva(Vector<Integer> idCategorii, Timestamp start, Timestamp stop) {
        try {
            Vector<RaportPeCategoriiSiCoteTva> vector = this.getDao().getRaportPeCategoriiSiCoteTva(idCategorii, start, stop);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<RaportPeCategoriiSiCoteTva> vector = new Vector<RaportPeCategoriiSiCoteTva>();
            return vector;
        }
        finally {
            this.pool.releaseConnection();
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    public boolean transferMasaLaHotel(Component parent, double total, Table destinationTable, Order originalOrder, AbstractPrinter forcedPrinter) {
        String tipPlata2 = VpConfig.getInstance().hotelTipPlataTransferCamera;
        TipPlata tp = TipPlataProvider.getInstance().getTipPlataByNameCommit(tipPlata2);
        if (tp == null) {
            DialogUtils.errorDialog(parent, "Tip plata hotel incorect", LangRoAll.nuPotContinua);
            return false;
        }
        Vector<Order> allOrdersAtTable = RestLogic.getInstance().getAllOpenOrdersAtTable(destinationTable);
        if (allOrdersAtTable.size() <= 0) {
            DialogUtils.errorDialog(parent, "Camera goala", LangRoAll.nuPotContinua);
            return false;
        }
        HotelOrderBean chosen = null;
        if (allOrdersAtTable.size() > 1) {
            Vector<HotelOrderBean> beans = new Vector<HotelOrderBean>();
            for (Order order : allOrdersAtTable) {
                HotelOrderBean toAdd = new HotelOrderBean();
                toAdd.setClient(ClientLogic.getInstance().getClientById(order.getIdClient()));
                toAdd.setOrder(order);
                toAdd.setTable(destinationTable);
                beans.add(toAdd);
            }
            while (chosen == null) {
                chosen = (HotelOrderBean)DialogUtils.getItemChooserDialog(beans, 4, false);
            }
        } else {
            Order order = allOrdersAtTable.get(0);
            HotelOrderBean toAdd = new HotelOrderBean();
            toAdd.setClient(ClientLogic.getInstance().getClientById(order.getIdClient()));
            toAdd.setOrder(order);
            toAdd.setTable(destinationTable);
            chosen = toAdd;
        }
        Client client1 = chosen.getClient();
        if (client1 == null) {
            DialogUtils.errorDialog(parent, "Camera " + destinationTable.getLabel() + " Order " + chosen.getOrder().getId() + " nu are un client asociat !!", LangRoAll.nuPotContinua);
            return false;
        }
        if (!DialogUtils.confirmDialog(parent, "Confirmati ca doriti sa transferati pe clientul " + client1, LangRoAll.confirmare)) {
            return false;
        }
        final Order destinationOrder = chosen.getOrder();
        PaymentLogic.getInstance().deleteAllPlatiForOrder(originalOrder, -1);
        Plata plata = new Plata(tp.getId(), total, tp.getEcrMapping(), tp.getLabel(), "Transfer la camera " + destinationTable.getLabel(), 0);
        PaymentLogic.getInstance().addPlataToOrder(originalOrder, plata);
        final Vector tempSales = new Vector();
        String coduri = VpConfig.getInstance().hotelPlataLaCazareCoduri;
        boolean buildProduseOk = this.buildProdusePlataLaCazare(originalOrder, parent, new PlataLaCazareFacturareInterface(){

            @Override
            public void addSale(Product p, double total) {
                Sale se = RestLogic.this.buildSale(p, 0.0, 1.0, "", destinationOrder.getId(), -1, -1, -1, -1, System.currentTimeMillis(), total, "", 0);
                tempSales.add(se);
                se.setModPreparare(Formatters.DATE_AND_TIME_FORMAT.format(new Date()));
            }
        }, coduri, -1);
        if (buildProduseOk) {
            Hashtable<Sectie, Vector<Sale>> sectii = new Hashtable<Sectie, Vector<Sale>>();
            for (Sale tempSale : tempSales) {
                Sectie s = this.nomeclaturaLogic.getSectieById(tempSale.getIdSectie());
                Vector<Sale> temps = (Vector<Sale>)sectii.get(s);
                if (temps == null) {
                    temps = new Vector<Sale>();
                }
                temps.add(tempSale);
                sectii.put(s, temps);
            }
            for (Sectie sectie : sectii.keySet()) {
                this.productsSold((Vector)sectii.get(sectie), destinationOrder, destinationTable, sectie, false, forcedPrinter);
            }
            return true;
        }
        return false;
    }

    private double getTotalFromPlataLaCazareBeans(int idSectie, int idTva, Collection<PlataLaCazareTotalBean> beans) {
        double result = 0.0;
        for (PlataLaCazareTotalBean bean : beans) {
            if (idSectie > 0 && bean.getIdSectie() != idSectie || idTva > 0 && bean.getIdTva() != idTva) continue;
            result += bean.getTotal();
        }
        return result;
    }

    public boolean buildProdusePlataLaCazare(Order originalOrder, Component parent, PlataLaCazareFacturareInterface plataLaCazareFacturareInterface, String coduri, int clientIndex) {
        Collection<PlataLaCazareTotalBean> totalPeSectii = this.getTotalGroupBySectieAndTva(originalOrder.getId(), clientIndex);
        Vector pairs = Utils.splitString(coduri, ',');
        for (String pair : pairs) {
            double total;
            Vector values = Utils.splitString(pair, '=');
            String sectieS = (String)values.get(0);
            String cotaTvaS = (String)values.get(1);
            String codProdus = (String)values.get(2);
            if (!Validators.correctInteger(codProdus)) {
                DialogUtils.errorDialog(parent, "hotelPlataLaCazareCoduri: codProdus " + codProdus + " nu e un numar !!", LangRoAll.nuPotContinua);
                return false;
            }
            int codProdusI = Integer.parseInt(codProdus);
            Product p = this.nomeclaturaLogic.getProductByCod(codProdusI);
            if (p == null) {
                DialogUtils.errorDialog(parent, "hotelPlataLaCazareCoduri: nu am gasit produsul cu codul " + codProdusI, LangRoAll.nuPotContinua);
                return false;
            }
            int idSectie = -1;
            int idTva = -1;
            if (!sectieS.equals("*")) {
                Sectie sectie = this.nomeclaturaLogic.getSectieByName(sectieS);
                if (sectie == null) {
                    DialogUtils.errorDialog(parent, "hotelPlataLaCazareCoduri: Nu am gasit sectia " + sectieS, LangRoAll.nuPotContinua);
                    return false;
                }
                idSectie = sectie.getId();
            }
            if (!cotaTvaS.equals("*")) {
                Tva tva = TvaLogic.getInstance().getTvaByCota(Utils.parseDouble(cotaTvaS));
                if (tva == null) {
                    DialogUtils.errorDialog(parent, "hotelPlataLaCazareCoduri: Nu am gasit cota TVA " + cotaTvaS, LangRoAll.nuPotContinua);
                    return false;
                }
                idTva = tva.getId();
            }
            if (!Utils.isValueGreaterThanZero(total = this.getTotalFromPlataLaCazareBeans(idSectie, idTva, totalPeSectii))) continue;
            plataLaCazareFacturareInterface.addSale(p, total);
        }
        return true;
    }

    @Override
    public boolean backupDB(boolean zip, String tipbackup) {
        return Backup.backup(zip, tipbackup, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyDB() {
        Connection c = null;
        try {
            c = this.pool.requestConnection().getConnection();
            CommonsDao.verifyDatabase(c);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                c.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRaportActivitate(Hashtable criteria) {
        Vector result = new Vector();
        Sectie sectie = (Sectie)criteria.get(Constants.SECTIE_KEY);
        int idSectie = sectie.getId();
        Vector userActions = this.userLogic.getUserActions(criteria);
        try {
            for (int i = 0; i < userActions.size(); ++i) {
                String k;
                UserLogEntry ul = (UserLogEntry)userActions.elementAt(i);
                String s = ul.getText();
                if (!s.contains(k = "Bon marcaj " + sectie.getName())) continue;
                String s1 = s.substring(k.length());
                s1 = s1.substring(4);
                int nrBon = Integer.parseInt(s1);
                Vector items = this.getBonsDao().getEntriesForBon(nrBon, idSectie);
                if (items.size() <= 0) continue;
                List sub = items.subList(0, items.size());
                result.addAll(sub);
                result.add("");
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    @Override
    public int doActionForCard1(String card) {
        if (card.equalsIgnoreCase(VpConfig.getInstance().trickyCard1)) {
            this.deleteNFOrders();
            return 2;
        }
        return -1;
    }

    @Override
    public int doActionForCard2(String card) {
        if (card.equalsIgnoreCase(VpConfig.getInstance().trickyCard2)) {
            this.cashRegister.deleteNonPrintedBons();
            return 2;
        }
        return -1;
    }

    public void deleteForCard2ByIdentifier(String identifier) {
        this.cashRegister.deleteBonByIdentifier(identifier);
    }

    @Override
    public boolean isCardTricky1(String card) {
        return card.equalsIgnoreCase(VpConfig.getInstance().trickyCard1);
    }

    @Override
    public boolean isCardTricky2(String card) {
        return card.equalsIgnoreCase(VpConfig.getInstance().trickyCard2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void comaseazaProduse(Vector idStocuri, int idStocTarget) {
        try {
            String stockIds = Utils.getSqlInSequence(idStocuri);
            this.getDao().replaceIngredient(this.pool.requestConnection().getConnection(), idStocTarget, stockIds);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Vector getComenziReport(Hashtable criteria) {
        int zileComanda = (Integer)criteria.get("Numar zile comanda");
        Date d1 = (Date)criteria.get(Constants.START_KEY);
        Timestamp t1 = new Timestamp(d1.getTime());
        Date d2 = (Date)criteria.get(Constants.STOP_KEY);
        Timestamp t2 = new Timestamp(d2.getTime());
        int days = DateUtils.getNrZileForDiff(t2.getTime() - t1.getTime());
        if (days <= 0) {
            days = 1;
        }
        int idFurnizor = (Integer)criteria.get("Furnizor");
        int stockId = (Integer)criteria.get(Constants.STOCK_KEY);
        Vector<Integer> selectedProducts = ContaLogic.getInstance().getProduseForFurnizor(idFurnizor, stockId);
        String inSql = Utils.getSqlInSequence(new Vector<Integer>(selectedProducts));
        Vector<Object> quantities = new Vector();
        if (inSql.length() < 3) {
            return new Vector();
        }
        double cotaTva = Config.getInstance().getDouble("tvaProcent");
        quantities = this.stockLogic.getStockQuantitiesForIds(-1, inSql, cotaTva);
        Hashtable<Integer, Double> consumuri = this.stockLogic.getConsumuri(inSql, -1, t1, t2);
        Vector result = new Vector(quantities);
        Hashtable<Integer, ComenziReportEntry> hash = new Hashtable<Integer, ComenziReportEntry>();
        for (int i = 0; i < result.size(); ++i) {
            StockViewEntry stockViewEntry = (StockViewEntry)result.elementAt(i);
            ComenziReportEntry re = (ComenziReportEntry)hash.get(stockViewEntry.getIdStock());
            if (re == null) {
                re = new ComenziReportEntry();
                re.setProdus(stockViewEntry.getNume());
                re.setNrZileConsum(days);
                re.setNrZileComanda(zileComanda);
                re.setStoc(stockViewEntry.getStocActual());
                Double f = consumuri.get(stockViewEntry.getIdStock());
                if (f != null) {
                    re.setConsum(f.floatValue());
                }
                hash.put(stockViewEntry.getIdStock(), re);
            } else {
                re.setStoc(re.getStoc() + stockViewEntry.getStocActual());
            }
            re.compute();
        }
        Vector v1 = new Vector(hash.values());
        Collections.sort(v1, new Comparator(){

            public int compare(Object o1, Object o2) {
                ComenziReportEntry s1 = (ComenziReportEntry)o1;
                ComenziReportEntry s2 = (ComenziReportEntry)o2;
                return s1.getProdus().compareToIgnoreCase(s2.getProdus());
            }
        });
        return v1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPretOptiuneProdusById(int id) {
        try {
            double d = this.getDao().getPretOptiuneProdusById(id);
            return d;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            double d = -1.0;
            return d;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void switchAfisajClientOrderNoCommit(int idOrder) throws SQLException {
        int idTable;
        Table t;
        Order o;
        int newIdOrder = -1;
        if (idOrder > 0 && (o = this.getOrderByIdNoCommit(idOrder)) != null && !(t = this.getTableByIdNoCommit(idTable = o.getTable())).isVirtuala()) {
            newIdOrder = idOrder;
        }
        Config.getInstance().updateValueNoCommit("afisajClientCurrentOrder", newIdOrder + "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchAfisajClientOrderCommit(int idOrder) {
        try {
            this.switchAfisajClientOrderNoCommit(idOrder);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public boolean deleteProductie(int idProductie, Component parent, Timestamp data) {
        try {
            if (!this.canModifyDocument(5, idProductie)) {
                DialogUtils.errorDialog(parent, "Nu puteti sterge aceasta productie", LangRoAll.nuPotContinua);
                this.pool.requestConnection().rollback();
                this.pool.releaseConnection();
                return false;
            }
            this.getDao().deleteFabricareItems(idProductie);
            this.getDao().deleteFabricare(idProductie);
            this.documentDeleted(data);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return true;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imparteNota(Order o, Vector leftSales, Vector rightSales) {
        try {
            Sale sale;
            int i;
            Order newOrderRight = this.newOrder(o.getTable(), o.getUser());
            this.getOrdersDao().deleteSalesForOrder(o);
            for (i = 0; i < rightSales.size(); ++i) {
                sale = (Sale)rightSales.elementAt(i);
                sale.setIdOrder(newOrderRight.getId());
                sale.setCantitateNoua(sale.getCantitateMarcata());
                this.addSaleNoCommit(sale, newOrderRight.getUser());
            }
            for (i = 0; i < leftSales.size(); ++i) {
                sale = (Sale)leftSales.elementAt(i);
                sale.setCantitateNoua(sale.getCantitateMarcata());
                this.addSaleNoCommit(sale, newOrderRight.getUser());
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public AchizitiiProdusePanel getAchizitiiPanel() {
        return this.achizitiiPanel;
    }

    public void setAchizitiiPanel(AchizitiiProdusePanel achizitiiPanel) {
        this.achizitiiPanel = achizitiiPanel;
    }

    public boolean exportSalesToCSV(Vector sales, String destinationFile) {
        StringBuffer out = new StringBuffer();
        out.append(LangRoAll.sectie);
        out.append(',');
        out.append("Cod");
        out.append(',');
        out.append(LangRoAll.produs);
        out.append(',');
        out.append(LangRoAll.cantitate);
        out.append(',');
        out.append("Pret vanzare");
        out.append(',');
        out.append(LangRoAll.promotie);
        out.append(',');
        out.append(LangRoAll.discount);
        out.append('\r');
        out.append('\n');
        for (int i = 0; i < sales.size(); ++i) {
            SalesEntry salesEntry = (SalesEntry)sales.elementAt(i);
            out.append(salesEntry.getCategory());
            out.append(',');
            out.append(salesEntry.getProductCodBare());
            out.append(',');
            out.append(salesEntry.getProduct());
            out.append(',');
            out.append(Utils.getString2Decimals(salesEntry.getQuantity()));
            out.append(',');
            out.append(Utils.getString2Decimals(salesEntry.getPrice()));
            out.append(',');
            String promo = salesEntry.getPromotion();
            if (!Validators.correctString(promo)) {
                promo = " ";
            }
            out.append(promo);
            out.append(',');
            out.append(Utils.getString2Decimals(salesEntry.getDiscount()));
            out.append('\r');
            out.append('\n');
        }
        try {
            FileUtils.writeTextToFile(destinationFile, out.toString());
            return true;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
    }

    public void setSecondaryCashRegister(AbstractCashRegister secondaryCashRegister) {
        this.secondaryCashRegister = secondaryCashRegister;
        secondaryCashRegister.addListener(PaymentLogic.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processOrdersByTipPlata(String numeTipPlata) {
        TipPlata tp = TipPlataProvider.getInstance().getTipPlataByNameCommit(numeTipPlata);
        if (tp != null) {
            try {
                Vector<Integer> orderIds = this.getDao().getOrdersForTipPlataRosu(tp.getId());
                for (Integer idOrder : orderIds) {
                    RestLogic.getInstance().processNonPrintedBonNoCommit(idOrder);
                }
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
        } else {
            Logger.logWarning(this, "TP is null!!");
        }
    }

    public void processNonPrintedBonNoCommit(int idOrder) throws SQLException {
        Order o = this.getOrderByIdNoCommit(idOrder);
        if (o != null) {
            o.setFiscal(false);
            this.getOrdersDao().setFiscal(o);
            this.getDao().setNonFiscalForOrder(idOrder, 0);
        }
    }

    public void updateOrderF(Order o, boolean f) throws SQLException {
        o.setFiscal(f);
        this.getOrdersDao().setFiscal(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processNonPrintedBon(int idOrder) {
        try {
            this.processNonPrintedBonNoCommit(idOrder);
            this.pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void processPrintedBonNoCommit(int idOrder) throws SQLException {
        Order o = this.getOrderById(idOrder);
        if (o != null) {
            o.setFiscal(true);
            this.getOrdersDao().setFiscal(o);
            this.getDao().setNonFiscalForOrder(idOrder, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean printEticheteBarcodeRaft(Vector<PricePanelEntry> allProducts, int copii) {
        try {
            for (PricePanelEntry entry : allProducts) {
                if (!entry.isMustPrint()) continue;
                double priceRedus = entry.getPret();
                Product p = this.nomeclaturaLogic.getProductByIdNoCommit(entry.getIdProduct());
                if (p == null) continue;
                Categorie cat = this.nomeclaturaLogic.getCategoryById(p.getIdCategorie());
                PriceWrapper pw = this.priceProvider.getPriceForProduct(p.getId(), p.getIdCategorie(), cat.getSectie(), -1, priceRedus, System.currentTimeMillis(), 0.0, true);
                entry.setPretRedus(pw.getPrice());
            }
            this.pool.commit();
            for (PricePanelEntry entry : allProducts) {
                if (!entry.isMustPrint()) continue;
                for (int j = 0; j < copii; ++j) {
                    String codBare = entry.getCodBare();
                    String nume = entry.getProduct();
                    double pretOriginal = entry.getPret();
                    double pretRedus = entry.getPretRedus();
                    PrintLogic.getInstance().printEtichetaBarcodeRaft(nume, codBare, pretOriginal, pretRedus);
                }
            }
            this.nomeclaturaLogic.updateToPrint(false, -1);
            this.pool.commit();
            boolean i$ = true;
            return i$;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public String printEticheteRaftA4(Vector<PricePanelEntry> allProducts, PrintEticheteInterface eticheteInterface) {
        try {
            int etichetePerLine = Config.getInstance().getInt("etichetePerLine", 2);
            int i = 0;
            String content = "";
            boolean lineClosed = true;
            for (PricePanelEntry element : allProducts) {
                String longBarcodeByIdProd = NomeclaturaLogic.getInstance().getLongBarcodeByIdProd(element.getIdProduct());
                element.setCodBare(longBarcodeByIdProd);
                if (!element.isMustPrint()) continue;
                for (int j = 0; j < eticheteInterface.getCopyCount(element); ++j) {
                    if (i % etichetePerLine == 0) {
                        content = content + "<fo:table-row display-align=\"center\">\n\n";
                        lineClosed = false;
                    }
                    boolean pretKg = this.nomeclaturaLogic.isProdusLaKg(element.getIdProduct());
                    String etichetaItem = this.pdfForEticheta(element, pretKg);
                    content = content + etichetaItem + "\n";
                    if (i % etichetePerLine == etichetePerLine - 1) {
                        content = content + "</fo:table-row>\n\n";
                        lineClosed = true;
                    }
                    ++i;
                }
            }
            if (!lineClosed) {
                content = content + "</fo:table-row>";
            }
            String recipesFile = "conf" + File.separator + "A4Etichete.txt";
            String recipes = FileUtils.readFileToString(recipesFile);
            recipes = recipes.replaceAll("%%content%%", content);
            String filename = FileUtils.getTempDir() + File.separator + "retete.fo";
            FileWriter fw = new FileWriter(filename);
            fw.write(recipes);
            fw.close();
            File eticheteDir = new File(FileUtils.getTempDir() + File.separator + "etichete");
            eticheteDir.mkdirs();
            String destPath = eticheteDir.getAbsolutePath() + File.separator + "Etichete_" + Formatters.currentDateAndTimeForFileSystem.format(new Date()) + ".pdf";
            PrintUtils.printPdf(filename, destPath);
            this.nomeclaturaLogic.updateToPrint(false, -1);
            return destPath;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    private String pdfForEticheta(PricePanelEntry re, boolean pretLa100GR) {
        String eticheta = "conf" + File.separator + "eticheta.txt";
        String entryFile = "";
        try {
            entryFile = FileUtils.readFileToString(eticheta);
            entryFile = entryFile.replaceAll("%%nume%%", " " + TextUtils.escapeForXML(re.getProduct()));
            double pret = re.getPret();
            if (pretLa100GR) {
                Stock stockById;
                entryFile = entryFile.replaceAll("%%pretkg%%", Utils.getString2DecimalsNoTrunc(pret) + " / KG");
                String replacement = "100gr";
                String eticheteA4UnitateMasura = VpConfig.getInstance().eticheteA4UnitateMasura;
                if (Validators.correctString(eticheteA4UnitateMasura)) {
                    replacement = eticheteA4UnitateMasura;
                } else if (re.getIdStock() >= 0 && (stockById = StockLogic.getInstance().getStockById(re.getIdStock())) != null) {
                    Unit unit = UnitsLogic.getInstance().getUnitById(stockById.getIdUnit());
                    replacement = unit.getLabel();
                }
                entryFile = entryFile.replaceAll("%%um%%", replacement);
                pret /= 10.0;
            } else {
                entryFile = entryFile.replaceAll("%%pretkg%%", "");
                entryFile = entryFile.replaceAll("%%um%%", "BUC");
            }
            entryFile = entryFile.replaceAll("%%pret%%", Utils.getString2DecimalsNoTrunc(pret));
            FileUtils.buildDir(FileUtils.getTempDir(), "barcodes");
            String barcodesPath = FileUtils.getTempDir() + File.separator + "barcodes" + File.separator;
            String codBareFile = barcodesPath + re.getIdProduct() + ".jpg";
            String result = this.generateBarcodeEAN13_JPG(codBareFile, re.getCodBare());
            String barcodeString = "";
            if (result != null) {
                result = TextUtils.escapeForXML(result);
                barcodeString = "<fo:external-graphic src=\"url('" + result + "')\"/>";
            } else {
                barcodeString = "Cod intern : " + re.getCodIntern();
            }
            entryFile = entryFile.replaceAll("%%barcode%%", barcodeString);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        return entryFile;
    }

    public String generateBarcodeForOrder(Order o) {
        String dir = "barcodes_orders";
        FileUtils.buildDir(FileUtils.getTempDir(), dir);
        String barcode = o.getBarcode();
        if (!Validators.correctCodBare(barcode)) {
            barcode = this.getNewBarcode();
            o.setBarcode(barcode);
            this.setBarcodeForOrder(o);
        }
        String barcodesPath = FileUtils.getTempDir() + File.separator + dir + File.separator;
        String codBareFile = barcodesPath + o.getId() + ".png";
        String result = this.generateBarcodeEAN13_PNG(codBareFile, barcode);
        return result;
    }

    public Vector getPremiiForClient(int idClient, double totalBonCurent) {
        Vector<String> result = new Vector<String>();
        Vector allPremii = PromotionLogic.getInstance().getPremiiInstant();
        Date stopDate = DateUtils.getEndOfDay(new Date());
        Client c = ClientLogic.getInstance().getClientById(idClient);
        for (int i = 0; i < allPremii.size(); ++i) {
            PremiuInstantView premiuInstantView = (PremiuInstantView)allPremii.elementAt(i);
            Date startDate = DateUtils.addDaysToDate(stopDate, -premiuInstantView.getNumarZile());
            startDate = DateUtils.getStartOfDay(startDate);
            double total = this.getTotalIncasariClient(c, startDate, stopDate);
            double valoarePremiu = premiuInstantView.getValoare();
            double diff = total + totalBonCurent - valoarePremiu;
            String s1 = premiuInstantView.getPremiu() + (diff >= 0.0 ? "" : " ( Prag pt premiu = " + Utils.getString2Decimals(valoarePremiu) + ", Necesar = " + Utils.getString2Decimals(diff) + ")");
            if (diff >= 0.0) {
                result.add("!! " + s1);
                continue;
            }
            result.add(s1);
        }
        return result;
    }

    public double getTotalIncasariClient(Client client, Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        if (client instanceof ClientPersJuridica) {
            result.put("client_pj", client);
        } else if (client instanceof ClientPersFizica) {
            result.put("client_pf", client);
        }
        double total = 0.0;
        Vector<IncasareClientView> r = this.getIncasariClienti(result, 1);
        for (int i = 0; i < r.size(); ++i) {
            IncasareClientView incasareClientView = r.elementAt(i);
            total += incasareClientView.getTotal();
        }
        return total;
    }

    public int getCountIncasariClient(Client client, Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        if (client instanceof ClientPersJuridica) {
            result.put("client_pj", client);
        } else if (client instanceof ClientPersFizica) {
            result.put("client_pf", client);
        }
        Vector<IncasareClientView> r = this.getIncasariClienti(result, 1);
        return r.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraDefecta(int idCamera, boolean defecta) {
        try {
            this.getTablesDao().setDefecta(idCamera, defecta);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraMurdara(int idCamera, boolean murdara) {
        try {
            this.setCameraMurdareNoCommit(idCamera, murdara);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void setCameraMurdareNoCommit(int idCamera, boolean murdara) throws SQLException {
        this.getTablesDao().setMurdara(idCamera, murdara);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePreturiPentruCoduriIntern(String txtFile) {
        ConnectionPool pool = null;
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(txtFile));
            pool = ConnectionPool.getInstance();
            String line = reader.readLine();
            int i = 1;
            while (line != null) {
                Vector fields = Utils.splitStringKeepStructure(line, '|', ' ');
                String codS = (String)fields.get(0);
                String pret = (String)fields.get(1);
                if (Validators.correctInteger(codS) && Validators.correctDouble(pret)) {
                    Product p = this.nomeclaturaLogic.getProductByCodNoCommit(Integer.valueOf(codS));
                    double newPrice = Utils.parseDouble(pret);
                    if (p != null) {
                        int idReteta = this.getIdReteta(p.getId());
                        if (idReteta > 0) {
                            this.setPriceForRetetaProductNoCommit(idReteta, newPrice);
                        } else {
                            int idStock = this.getIdStock(p.getId());
                            StockLogic.getInstance().updatePriceForStockNoCommit(idStock, newPrice);
                        }
                    } else {
                        Logger.logWarning(this, "Nu am gasit produsul cu codul " + codS);
                    }
                } else {
                    Logger.logWarning(this, "Linia " + i + " incorecta");
                }
                line = reader.readLine();
                ++i;
            }
            pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            pool.releaseConnection();
        }
    }

    public String getNewBarcodeProductNoCommit() throws SQLException {
        String barcodePrefixConfigName = "barcodePrefix";
        String barcodeIndexConfigName = "barcodeGenerator_index";
        String result = this.getNewBarcodeGenericNoCommit(barcodePrefixConfigName, barcodeIndexConfigName);
        return result;
    }

    public String getNewBarcodeGenericNoCommit(String barcodePrefixConfigName, String barcodeIndexConfigName) throws SQLException {
        String barcode;
        String prefix = Config.getInstance().getStringNoCommit(barcodePrefixConfigName, "");
        String lastSequenceS = Config.getInstance().getStringNoCommit(barcodeIndexConfigName);
        if (!Validators.correctBigInteger(lastSequenceS)) {
            barcode = Utils.getStringMaxSize(12, prefix, Character.valueOf('0'), false);
            Config.getInstance().addConfigNoCommit(barcodeIndexConfigName, barcode + "", true);
        } else {
            BigInteger bi = new BigInteger(lastSequenceS);
            bi = bi.add(BigInteger.ONE);
            barcode = bi.toString();
            Config.getInstance().updateValueNoCommit(barcodeIndexConfigName, barcode);
        }
        int checksum = EAN13Barcode.getMod10CheckDigit((String)barcode);
        if (checksum == 10) {
            checksum = 0;
        }
        return barcode + checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNewBarcode() {
        try {
            String result = this.getNewBarcodeProductNoCommit();
            this.pool.commit();
            String string = result;
            return string;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            String string = null;
            return string;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public String generateBarcodeEAN13_PNG(String outputFile, String text) {
        try {
            int length = text.length();
            boolean ean13 = false;
            if (length == 13) {
                text = text.substring(0, 12);
                ean13 = true;
            } else if (length == 12) {
                ean13 = true;
            }
            if (ean13) {
                Barcode barcode = BarcodeFactory.createEAN13((String)text);
                File f = new File(outputFile);
                BarcodeImageHandler.savePNG((Barcode)barcode, (File)f);
                return outputFile;
            }
        }
        catch (BarcodeException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (OutputException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        return null;
    }

    public String generateBarcodeEAN13_JPG(String outputFile, String text) {
        try {
            int length = text.length();
            boolean ean13 = false;
            if (length == 13) {
                text = text.substring(0, 12);
                ean13 = true;
            } else if (length == 12) {
                ean13 = true;
            }
            if (ean13) {
                Barcode barcode = BarcodeFactory.createEAN13((String)text);
                File f = new File(outputFile);
                BarcodeImageHandler.saveJPEG((Barcode)barcode, (File)f);
                return outputFile;
            }
        }
        catch (BarcodeException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (OutputException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        return null;
    }

    public void printBonFiscalLiber(Product p, double valoare, User loggedUser) {
        TipPlata cashDefault = TipPlataProvider.getInstance().getDefaultTipPlataCommit();
        Vector<EcrPlata> tipPlata2 = new Vector<EcrPlata>();
        Vector<String> comments = new Vector<String>();
        Vector<EcrSale> ecrSales = new Vector<EcrSale>();
        Categorie cat = NomeclaturaLogic.getInstance().getCategoryById(p.getIdCategorie());
        Sectie sec = this.nomeclaturaLogic.getSectieByCategoryId(cat.getId());
        String departament = cat.getCodDepartament();
        int grupa = cat.getId();
        Tva tva = TvaLogic.getInstance().getTvaById(cat.getIdTva());
        String codTva = tva.getCodCasa();
        double cotaTva = tva.getCota();
        EcrSale sale = new EcrSale(p.getName(), 1.0, valoare, valoare, 0.0, p.getCod(), departament, grupa, codTva, cotaTva, sec.getName());
        ecrSales.add(sale);
        this.cashRegister.printBonFiscal(ecrSales, valoare, tipPlata2, cashDefault, comments, loggedUser.getLogin() + "_" + Utils.getLocalComputerName(), -1);
    }

    @Override
    public Vector getFurnizori(int status) {
        return ContaLogic.getInstance().getFurnizori(-1);
    }

    @Override
    public String getStockIdsForFurnizorId(int idFurnizor) {
        Vector<Integer> selectedProducts = ContaLogic.getInstance().getProduseForFurnizor(idFurnizor, -1);
        if (selectedProducts.size() > 0) {
            String inSql = Utils.getSqlInSequence(new Vector<Integer>(selectedProducts));
            return inSql;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFiscalDefault(int newStatus) {
        try {
            String propertyName = "fdefault";
            String value = Config.getInstance().getStringNoCommit(propertyName);
            boolean lastSeq = true;
            if (!Validators.correctInteger(value)) {
                Config.getInstance().addConfigNoCommit(propertyName, "1", false);
            } else {
                Config.getInstance().updateValueNoCommit(propertyName, newStatus + "");
            }
            RestLogic.getInstance().fiscalStatus = newStatus;
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFiscalDefaultFromDb() {
        try {
            String propertyName = "fdefault";
            String value = Config.getInstance().getStringNoCommit(propertyName);
            int lastSeq = 1;
            if (!Validators.correctInteger(value)) {
                Config.getInstance().addConfigNoCommit(propertyName, "1", false);
            } else {
                lastSeq = Integer.parseInt(value);
            }
            RestLogic.getInstance().fiscalStatus = lastSeq;
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    @Override
    public void readQuantity(double f) {
        for (ScaleMessageConsumer messageConsumer : this.scaleConsumers) {
            Logger.logDebug(this, "Notifying: " + messageConsumer.getClass().getName());
            messageConsumer.readQuantity(f);
        }
    }

    public void addScaleConsumer(ScaleMessageConsumer consumer) {
        this.scaleConsumers.add(consumer);
    }

    @Override
    public void hangup(String phone, String extension) {
        Logger.logDebug(this, "Hangup: Phone=\"" + phone + "\" Extension=\"" + extension + "\"");
        boolean listenerFound = false;
        for (String key : this.asteriskEventListeners.keySet()) {
            AsteriskEventInterface inter;
            if (!extension.startsWith(key) || (inter = (AsteriskEventInterface)this.asteriskEventListeners.get(key)) == null) continue;
            Logger.logDebug(this, "HANGUP: Notifying asterisk listeners");
            inter.hangup(phone, extension);
            listenerFound = true;
        }
        if (!listenerFound) {
            Logger.logDebug(this, "HANGUP: No asterisk listener for \"" + extension + "\" extension");
        }
    }

    @Override
    public void pickup(String phone, String extension) {
        Logger.logDebug(this, "Pickup: Phone=\"" + phone + "\" Extension=\"" + extension + "\"");
        boolean listenerFound = false;
        for (String key : this.asteriskEventListeners.keySet()) {
            AsteriskEventInterface inter;
            if (!extension.startsWith(key) || (inter = (AsteriskEventInterface)this.asteriskEventListeners.get(key)) == null) continue;
            Logger.logDebug(this, "PICKUP: Notifying asterisk listeners");
            inter.pickup(phone, extension);
            listenerFound = true;
        }
        if (!listenerFound) {
            Logger.logDebug(this, "PICKUP: No asterisk listener for \"" + extension + "\" extension");
        }
    }

    public void addAsteriskEventListener(String extension, AsteriskEventInterface listener) {
        this.asteriskEventListeners.put(extension, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportMateriePrimaToXml(int idStock, String targetFile) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        bigFile.append("<document>\n");
        try {
            Stock s = this.stockLogic.getStockByIdNoCommit(idStock);
            TextUtils.dumpToXml(s, bigFile, "stock", "");
            bigFile.append("</document>");
            FileUtils.writeTextToFile(targetFile, bigFile.toString());
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportRetetaToXml(int idProdus, String targetFile) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        bigFile.append("<document>\n");
        try {
            Product p = this.nomeclaturaLogic.getProductFromDb(idProdus);
            int idReteta = this.getIdRetetaNoCommit(p.getId());
            if (idReteta <= 0) {
                return;
            }
            Categorie cat = this.nomeclaturaLogic.getCategoryByIdNoCommit(p.getIdCategorie());
            Sectie sectie = this.nomeclaturaLogic.getSectieByIdNoCommit(cat.getSectie());
            double price = this.getPriceForProductNoCommit(p.getId());
            String barcodes = this.getBarcodesStringForXml(p.getId());
            TextUtils.dumpToXml(p, bigFile, "reteta", "barcodes=\"" + barcodes + "\" categorie=\"" + cat.getName() + "\" sectie=\"" + sectie.getName() + "\" price=\"" + price + "\"");
            Vector<NewRecipeEntry> ingrediente = this.getRecipesForProdusReteta(idReteta, 1);
            for (NewRecipeEntry recipeEntry : ingrediente) {
                int idStock = recipeEntry.getIdStock();
                if (idStock > 0) {
                    Stock stock = this.stockLogic.getStockByIdNoCommit(idStock);
                    String codUniq = stock.getUniqueCode();
                    String s = "<recipeentry stock_unique_id=\"" + codUniq + "\" quantity=\"" + Utils.getString6Decimals(recipeEntry.getQuantity()) + "\"/>\n";
                    bigFile.append(s);
                    continue;
                }
                String codUniq = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(recipeEntry.getIdProduct());
                String s = "<recipeentry product_unique_id=\"" + codUniq + "\" quantity=\"" + Utils.getString6Decimals(recipeEntry.getQuantity()) + "\"/>\n";
                bigFile.append(s);
            }
            bigFile.append("</document>");
            FileUtils.writeTextToFile(targetFile, bigFile.toString());
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IllegalAccessException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportProductToXml(int idProduct, String targetFile) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        bigFile.append("<document>\n");
        try {
            Product p = this.nomeclaturaLogic.getProductFromDb(idProduct);
            if (p != null) {
                int idStock = this.getIdStockForProductFromDB(idProduct);
                if (idStock > 0) {
                    Stock s = this.stockLogic.getStockByIdNoCommit(idStock);
                    double price = this.stockLogic.getCatalogPriceForStockNoCommit(idStock);
                    TextUtils.dumpToXml(s, bigFile, "stock", "price=\"" + price + "\"");
                    this.stockLogic.syncDone(p.getId(), s.getId());
                }
                Categorie cat = this.nomeclaturaLogic.getCategoryByIdNoCommit(p.getIdCategorie());
                Sectie sectie = this.nomeclaturaLogic.getSectieByIdNoCommit(cat.getSectie());
                String barcodes = this.getBarcodesStringForXml(p.getId());
                TextUtils.dumpToXml(p, bigFile, "product", "barcodes=\"" + barcodes + "\" categorie=\"" + cat.getName() + "\" sectie=\"" + sectie.getName() + "\"");
            }
            bigFile.append("</document>");
            FileUtils.writeTextToFile(targetFile, bigFile.toString());
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportStockToXml(int idStock, String targetFile) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        bigFile.append("<document>\n");
        try {
            Stock s = this.stockLogic.getStockByIdNoCommit(idStock);
            if (s != null) {
                double price = this.stockLogic.getCatalogPriceForStockNoCommit(idStock);
                TextUtils.dumpToXml(s, bigFile, "stock", "price=\"" + price + "\"");
                int idProduct = this.stockLogic.getProductForStockFromDBNoCommit(idStock);
                Product p = NomeclaturaLogic.getInstance().getProductFromDb(idProduct);
                if (p != null) {
                    Categorie cat = this.nomeclaturaLogic.getCategoryByIdNoCommit(p.getIdCategorie());
                    Sectie sectie = this.nomeclaturaLogic.getSectieByIdNoCommit(cat.getSectie());
                    String barcodes = this.getBarcodesStringForXml(p.getId());
                    TextUtils.dumpToXml(p, bigFile, "product", "barcodes=\"" + barcodes + "\" categorie=\"" + cat.getName() + "\" sectie=\"" + sectie.getName() + "\"");
                    this.stockLogic.syncDone(p.getId(), s.getId());
                }
            }
            bigFile.append("</document>");
            this.pool.commit();
            FileUtils.writeTextToFile(targetFile, bigFile.toString());
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public synchronized void importOrUpdateProductFromXml(String filename, final String channelCodePrefix) throws IOException, SAXException {
        Utils.importXml(new DefaultHandler(){
            int idStock = -1;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equalsIgnoreCase("stock")) {
                    Stock stock = new Stock();
                    try {
                        TextUtils.loadAttributesBySetters(stock, attributes);
                        String priceString = attributes.getValue("price");
                        double price = -1.0;
                        if (Validators.correctDouble(priceString)) {
                            price = Utils.parseDouble(priceString);
                        }
                        try {
                            String uniqueCode = channelCodePrefix + stock.getUniqueCode();
                            Stock s = RestLogic.this.stockLogic.getStockByCodUnicNoCommit(uniqueCode);
                            if (s != null) {
                                this.idStock = s.getId();
                                s.setLabel(channelCodePrefix + stock.getLabel());
                                RestLogic.this.stockLogic.updateStockShortNoCommit(s);
                                RestLogic.this.stockLogic.updatePriceForStockNoCommit(s.getId(), price);
                                if (stock.getStatus() == 2) {
                                    RestLogic.this.stockLogic.deleteStockShortNoCommit(stock.getId());
                                }
                                Logger.logDebug(this, "Updating existing stock: uniqueCode=\"" + uniqueCode + "\" stock = \"" + s.getLabel() + "\"");
                            } else {
                                stock.setLabel(channelCodePrefix + stock.getLabel());
                                this.idStock = RestLogic.this.stockLogic.addStockShortNoCommit(stock, price, uniqueCode);
                            }
                            RestLogic.this.pool.commit();
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                            try {
                                RestLogic.this.pool.rollBack();
                            }
                            catch (SQLException e1) {
                                Logger.logException(this, (Exception)e1);
                            }
                        }
                        finally {
                            RestLogic.this.pool.releaseConnection();
                        }
                    }
                    catch (IllegalAccessException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    catch (InvocationTargetException e) {
                        Logger.logException(this, (Exception)e);
                    }
                }
                if (qName.equalsIgnoreCase("product")) {
                    Product product = new Product();
                    try {
                        TextUtils.loadAttributesBySetters(product, attributes);
                        try {
                            String sectie = channelCodePrefix + attributes.getValue("sectie");
                            String categorie = channelCodePrefix + attributes.getValue("categorie");
                            Sectie sec = RestLogic.this.nomeclaturaLogic.getSectieByNameNoCommit(sectie);
                            Categorie cat = RestLogic.this.nomeclaturaLogic.getCategoryByNameNoCommit(categorie);
                            if (sec == null) {
                                int id = RestLogic.this.nomeclaturaLogic.addSectieNoCommit(sectie, "", "");
                                sec = RestLogic.this.nomeclaturaLogic.getSectieByIdNoCommit(id);
                                Logger.logDebug(this, "Added new sectie : " + sectie);
                            }
                            if (cat == null) {
                                Tva tva = TvaLogic.getInstance().getTvas().get(0);
                                cat = RestLogic.this.nomeclaturaLogic.newCategoryNoCommit(sec.getId(), categorie, Color.WHITE.getRGB(), sec.getId() + "", tva.getId(), false, 0.0);
                                Logger.logDebug(this, "Added new categ : " + cat);
                            }
                            product.setName(channelCodePrefix + product.getName());
                            product.setNumeCasa(channelCodePrefix + product.getNumeCasa());
                            product.setNumeSectie(channelCodePrefix + product.getNumeSectie());
                            String codSync = channelCodePrefix + product.getCodSync();
                            Product p1 = RestLogic.this.nomeclaturaLogic.getProductByCodSyncNoCommit(codSync);
                            if (p1 != null) {
                                Logger.logDebug(this, "Update product : " + product);
                                if (!p1.getName().equals(product.getName())) {
                                    Logger.logWarning(this, "POSIBILA EROARE DE COD SYNC (" + codSync + ") : existent : " + p1.getName() + " nou : " + product.getName());
                                }
                                product.setId(p1.getId());
                                product.setIdCategorie(cat.getId());
                                RestLogic.this.nomeclaturaLogic.updateProductNoCommit(product);
                                Vector coduriBare = Utils.splitString(attributes.getValue("barcodes"), ',');
                                RestLogic.this.nomeclaturaLogic.updateBarcodesForProductById(product.getId(), coduriBare);
                                if (product.getStatus() == 2) {
                                    RestLogic.this.nomeclaturaLogic.deleteProductNoCommit(product);
                                }
                            } else {
                                product.setCodSync(codSync);
                                Vector coduriBare = Utils.splitString(attributes.getValue("barcodes"), ',');
                                int idProduct = RestLogic.this.nomeclaturaLogic.addProductShortNoCommit(product, cat.getId(), coduriBare);
                                if (this.idStock > 0) {
                                    RestLogic.this.stockLogic.pasteExistingProductToStock(this.idStock, idProduct);
                                }
                                Logger.logDebug(this, "Added new product : " + product);
                            }
                            RestLogic.this.pool.commit();
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                            try {
                                RestLogic.this.pool.rollBack();
                            }
                            catch (SQLException e1) {
                                Logger.logException(this, (Exception)e1);
                            }
                        }
                        finally {
                            RestLogic.this.pool.releaseConnection();
                        }
                    }
                    catch (IllegalAccessException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    catch (InvocationTargetException e) {
                        Logger.logException(this, (Exception)e);
                    }
                }
            }
        }, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportNirToXml(int idNir, String targetFile) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        bigFile.append("<document>\n");
        try {
            Nir nir = ContaLogic.getInstance().getNirByIdNoCommit(idNir);
            if (nir == null) {
                return;
            }
            TextUtils.dumpToXml(nir, bigFile, "nir", "");
            int idFactura = nir.getIdFactura();
            Factura f = ContaLogic.getInstance().getFacturaByIdNoCommit(idFactura);
            int idFurnizor = f.getIdFurnizor();
            ClientPersJuridica fur = (ClientPersJuridica)ClientLogic.getInstance().getClientByIdNoCommit(idFurnizor);
            String cui = fur.getCui();
            TextUtils.dumpToXml(f, bigFile, "factura", "cui_furnizor=\"" + cui + "\"");
            Vector<NirEntryFull> nirEntries = ContaLogic.getInstance().getDataForNir(idNir);
            for (int i = 0; i < nirEntries.size(); ++i) {
                NirEntryFull nirEntryFull = nirEntries.elementAt(i);
                int idStock = nirEntryFull.getIngredientId();
                Stock s = this.stockLogic.getStockByIdNoCommit(idStock);
                String codUniq = s.getUniqueCode();
                TextUtils.dumpToXml(nirEntryFull, bigFile, "nir_entry", "codUnic=\"" + codUniq + "\"");
            }
            bigFile.append("</document>");
            FileUtils.writeTextToFile(targetFile, bigFile.toString());
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IllegalAccessException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public synchronized void importOrUpdateNirFromXml(String filename, final int idSocietateaNoastra) throws IOException, SAXException {
        Utils.importXml(new DefaultHandler(){
            Vector entries = new Vector();
            Nir nir = new Nir();
            Factura factura = new Factura();
            boolean furnizorFound = true;
            boolean stockFound = true;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (!this.furnizorFound || !this.stockFound) {
                    return;
                }
                if (qName.equalsIgnoreCase("document")) {
                    try {
                        Nir existing = ContaLogic.getInstance().getNirByNrNirNoCommit(this.nir.getNumarNir());
                        if (existing != null) {
                            System.out.println("Start Update existing NIR");
                            this.nir.setId(existing.getId());
                            int idFactura = existing.getIdFactura();
                            this.factura.setId(idFactura);
                            ContaLogic.getInstance().updateNirExternal(this.nir, this.factura, this.entries, ContaLogic.TIP_DOCUMENT_NIR.Factura.getTip(), StockLogic.COMANDA_TYPE.EFECTUAT);
                            ContaLogic.getInstance().closeNirNoCommit(this.nir.getId(), this.nir.getTotal(), this.nir.getTotalTva(), this.nir.getTotalGeneral(), this.factura.getTotal(), this.factura.getTotalTva(), this.factura.getTotalGeneral());
                            System.out.println("Stop Update existing NIR");
                        } else {
                            System.out.println("Start adding new NIR");
                            int idNir = ContaLogic.getInstance().addNirNoCommit(this.factura.getSerieFactura(), this.factura.getAuto(), this.factura.getDateadd(), this.factura.getIdFurnizor(), this.nir.getNumarNir(), this.entries, false, new Vector(), true, idSocietateaNoastra, ContaLogic.TIP_DOCUMENT_NIR.Factura.getTip(), StockLogic.COMANDA_TYPE.EFECTUAT, this.factura.getDataScadenta() != null ? this.factura.getDataScadenta() : this.factura.getDateadd());
                            ContaLogic.getInstance().closeNirNoCommit(idNir, this.nir.getTotal(), this.nir.getTotalTva(), this.nir.getTotalGeneral(), this.factura.getTotal(), this.factura.getTotalTva(), this.factura.getTotalGeneral());
                            System.out.println("Stop adding new NIR");
                        }
                        RestLogic.this.pool.commit();
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                        try {
                            RestLogic.this.pool.rollBack();
                        }
                        catch (SQLException e1) {
                            Logger.logException(this, (Exception)e1);
                        }
                    }
                    finally {
                        RestLogic.this.pool.releaseConnection();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                block27: {
                    if (!this.furnizorFound || !this.stockFound) {
                        return;
                    }
                    try {
                        if (qName.equalsIgnoreCase("nir")) {
                            TextUtils.loadAttributesBySetters(this.nir, attributes);
                        }
                        if (qName.equalsIgnoreCase("factura")) {
                            String cuiFurnizors = attributes.getValue("cui_furnizor");
                            Vector furnizori = ClientLogic.getInstance().getPersJuridiceByCodNoCommit(cuiFurnizors);
                            if (furnizori.size() > 0) {
                                TextUtils.loadAttributesBySetters(this.factura, attributes);
                                ClientPersJuridica furnizor = (ClientPersJuridica)furnizori.get(0);
                                this.factura.setIdFurnizor(furnizor.getId());
                            } else {
                                this.furnizorFound = false;
                            }
                        }
                        if (!qName.equalsIgnoreCase("nir_entry")) break block27;
                        String codUnic = attributes.getValue("codUnic");
                        Stock s = RestLogic.this.stockLogic.getStockByCodUnicNoCommit(codUnic);
                        if (s != null) {
                            NirEntryFull nirEntryFull = new NirEntryFull();
                            TextUtils.loadAttributesBySetters(nirEntryFull, attributes);
                            nirEntryFull.setIngredientId(s.getId());
                            this.entries.add(nirEntryFull);
                            break block27;
                        }
                        this.stockFound = false;
                        return;
                    }
                    catch (IllegalAccessException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    catch (InvocationTargetException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    finally {
                        try {
                            RestLogic.this.pool.commit();
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                        }
                        RestLogic.this.pool.releaseConnection();
                    }
                }
            }
        }, filename);
    }

    public synchronized void importOrUpdateMateriePrima(String filename) throws IOException, SAXException {
        Utils.importXml(new DefaultHandler(){
            int idStock = -1;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equalsIgnoreCase("stock")) {
                    Stock stock = new Stock();
                    try {
                        TextUtils.loadAttributesBySetters(stock, attributes);
                        try {
                            Stock s = RestLogic.this.stockLogic.getStockByCodUnicNoCommit(stock.getUniqueCode());
                            if (s != null) {
                                this.idStock = s.getId();
                                s.setLabel(stock.getLabel());
                                RestLogic.this.stockLogic.updateStockShortNoCommit(s);
                                Logger.logDebug(this, "Updating existing stock: uniqueCode=\"" + stock.getUniqueCode() + "\" stock = \"" + s.getLabel() + "\"");
                            } else {
                                this.idStock = RestLogic.this.stockLogic.addStockShortNoCommit(stock, -1.0, stock.getUniqueCode());
                            }
                            RestLogic.this.pool.commit();
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                            try {
                                RestLogic.this.pool.rollBack();
                            }
                            catch (SQLException e1) {
                                Logger.logException(this, (Exception)e1);
                            }
                        }
                        finally {
                            RestLogic.this.pool.releaseConnection();
                        }
                    }
                    catch (IllegalAccessException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    catch (InvocationTargetException e) {
                        Logger.logException(this, (Exception)e);
                    }
                }
            }
        }, filename);
    }

    public synchronized void importOrUpdateReteta(String filename, final String channelCodePrefix) throws IOException, SAXException {
        Utils.importXml(new DefaultHandler(){
            String codBareS = "";
            Vector<NewRecipeEntry> elements = new Vector();
            int idReteta = -1;
            Product p = null;

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (qName.equalsIgnoreCase("document")) {
                    if (this.p != null && !VpConfig.getInstance().dataSyncIgnoreRemoteRecipeItems) {
                        Vector<NewRecipeEntry> ingrediente = RestLogic.this.getRecipesForProdusReteta(this.idReteta, 1);
                        for (NewRecipeEntry entry : ingrediente) {
                            RestLogic.this.removeIngredientFromProduct(this.p.getName(), entry.getId(), entry.getName(), entry.getQuantity());
                        }
                        for (NewRecipeEntry entry : this.elements) {
                            RestLogic.this.addIngredientToProduct(this.idReteta, entry.getIdStock(), entry.getIdProduct(), entry.getQuantity(), entry.getName(), this.p.getName());
                        }
                    }
                    this.elements.clear();
                    this.codBareS = "";
                    this.p = null;
                    this.idReteta = -1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equalsIgnoreCase("recipeentry")) {
                    NewRecipeEntry newRecipeEntry = new NewRecipeEntry();
                    String codStock = attributes.getValue("stock_unique_id");
                    String codProdus = attributes.getValue("product_unique_id");
                    String quantityS = attributes.getValue("quantity");
                    double quantity = Utils.parseDouble(quantityS);
                    if (Validators.correctString(codStock)) {
                        Stock s = RestLogic.this.stockLogic.getStockByCodUnicCommit(codStock);
                        newRecipeEntry.setName(s.getLabel());
                        newRecipeEntry.setIdStock(s.getId());
                    } else {
                        Product p = RestLogic.this.nomeclaturaLogic.getProductByCodBare(codProdus);
                        newRecipeEntry.setIdProduct(p.getId());
                        newRecipeEntry.setName(p.getName());
                    }
                    newRecipeEntry.setQuantity(quantity);
                    this.elements.add(newRecipeEntry);
                }
                if (qName.equalsIgnoreCase("reteta")) {
                    this.p = new Product();
                    try {
                        TextUtils.loadAttributesBySetters(this.p, attributes);
                        try {
                            String sectie = channelCodePrefix + attributes.getValue("sectie");
                            String categorie = channelCodePrefix + attributes.getValue("categorie");
                            String priceS = attributes.getValue("price");
                            double price = Utils.parseDouble(priceS);
                            Sectie sec = RestLogic.this.nomeclaturaLogic.getSectieByNameNoCommit(sectie);
                            Categorie cat = RestLogic.this.nomeclaturaLogic.getCategoryByNameNoCommit(categorie);
                            if (sec == null) {
                                int id = RestLogic.this.nomeclaturaLogic.addSectieNoCommit(sectie, "", "");
                                sec = RestLogic.this.nomeclaturaLogic.getSectieByIdNoCommit(id);
                                Logger.logDebug(this, "Added new sectie : " + sectie);
                            }
                            if (cat == null) {
                                Tva tva = TvaLogic.getInstance().getTvas().get(0);
                                cat = RestLogic.this.nomeclaturaLogic.newCategoryNoCommit(sec.getId(), categorie, Color.WHITE.getRGB(), sec.getId() + "", tva.getId(), false, 0.0);
                                Logger.logDebug(this, "Added new categ : " + cat);
                            }
                            this.p.setName(channelCodePrefix + this.p.getName());
                            this.p.setNumeCasa(channelCodePrefix + this.p.getNumeCasa());
                            this.p.setNumeSectie(channelCodePrefix + this.p.getNumeSectie());
                            String codSync = channelCodePrefix + this.p.getCodSync();
                            Product p1 = RestLogic.this.nomeclaturaLogic.getProductByCodSyncNoCommit(codSync);
                            if (p1 != null) {
                                this.p.setId(p1.getId());
                                this.p.setIdCategorie(cat.getId());
                                this.idReteta = RestLogic.this.getIdRetetaNoCommit(p1.getId());
                                RestLogic.this.nomeclaturaLogic.updateProductNoCommit(this.p);
                                RestLogic.this.setPriceForRetetaProductNoCommit(this.idReteta, price);
                                Vector coduriBare = Utils.splitString(attributes.getValue("barcodes"), ',');
                                RestLogic.this.nomeclaturaLogic.updateBarcodesForProductById(this.p.getId(), coduriBare);
                                Logger.logDebug(this, "Update product : " + this.p);
                            } else {
                                this.p.setCodSync(codSync);
                                int cod = RestLogic.this.nomeclaturaLogic.getNextProductCodeNoCommit();
                                Vector<String> barcodes = new Vector<String>();
                                barcodes.add(this.codBareS);
                                int idProduct = RestLogic.this.newRetetaProduct(cat.getId(), this.p.getName(), price, new Vector(), cod, this.p.getNumeCasa(), this.p.getNumeSectie(), this.p.getLiber1(), this.p.getLiber2(), "", this.p.isUzIntern(), true, this.p.isExportCantar(), new Vector(), null, this.p.getCodSync(), barcodes);
                                this.idReteta = RestLogic.this.getIdRetetaNoCommit(idProduct);
                                this.p.setId(idProduct);
                                Logger.logDebug(this, "Added new product : " + this.p);
                                Vector coduriBare = Utils.splitString(attributes.getValue("barcodes"), ',');
                                for (String codBareCurent : coduriBare) {
                                    RestLogic.this.nomeclaturaLogic.addBarcodeToProductNoCommit(idProduct, codBareCurent);
                                }
                            }
                            RestLogic.this.pool.commit();
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                            try {
                                RestLogic.this.pool.rollBack();
                            }
                            catch (SQLException e1) {
                                Logger.logException(this, (Exception)e1);
                            }
                        }
                        finally {
                            RestLogic.this.pool.releaseConnection();
                        }
                    }
                    catch (IllegalAccessException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    catch (InvocationTargetException e) {
                        Logger.logException(this, (Exception)e);
                    }
                }
            }
        }, filename);
    }

    public Vector<IncasareClientView> getIncasariByIdClient(int idClient) {
        Hashtable<String, Comparable> result = new Hashtable<String, Comparable>();
        Client client = ClientLogic.getInstance().getClientById(idClient);
        if (client instanceof ClientPersJuridica) {
            result.put("client_pj", client);
        } else if (client instanceof ClientPersFizica) {
            result.put("client_pf", client);
        }
        result.put(Constants.START_KEY, DateUtils.getStartOfDays());
        result.put(Constants.STOP_KEY, DateUtils.getEndOfDays());
        return this.getIncasariClienti(result, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotalIncasariZiuaInCurs() {
        try {
            double[] values = ClDaoImpl.getTotalForSectieAndUser(-1, -1, 1, -1, ConnectionPool.getInstance().requestConnection().getConnection());
            double d = values[0];
            return d;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            double d = 0.0;
            return d;
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotalIncasariAllTime() {
        try {
            double[] values = ClDaoImpl.getTotalForSectieAndUser(-1, -1, 1, -1, ConnectionPool.getInstance().requestConnection().getConnection(), -1);
            double d = values[0];
            return d;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            double d = 0.0;
            return d;
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getOpenOrdersValue() {
        try {
            double d = this.getDao().getOpenOrdersValue();
            return d;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            double d = -1.0;
            return d;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOpenOrdersCount() {
        try {
            int n = this.getDao().getOpenOrdersCount();
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeAllOpenOrders() {
        try {
            Vector<Integer> ids = this.getDao().getOpenOrdersIds();
            for (Integer id : ids) {
                Order o = this.getOrderByIdNoCommit(id);
                this.closeOrderNoCommit(o, null);
            }
            this.pool.commit();
            boolean i$ = true;
            return i$;
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Vector<User> getUsersForPaging() {
        Vector waiters = RestLogic.getInstance().getWaiters();
        Vector<User> result = new Vector<User>();
        for (User waiter : waiters) {
            Vector openOrders;
            String codUnic = waiter.getCodUnic();
            if (!Validators.correctInteger(codUnic) || (openOrders = RestLogic.getInstance().getOpenOrdersByUser(waiter)).size() <= 0) continue;
            result.add(waiter);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxClientsForOrder(Order o, Vector<Sale> presales) {
        try {
            int max = 0;
            if (o != null) {
                max = this.getOrdersDao().getMaxClientIndexForOrder(o.getId());
            }
            for (Sale sale : presales) {
                if (sale.getClientIndex() <= max) continue;
                max = sale.getClientIndex();
            }
            int n = max;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void setClientIndexToSaleNoCommit1(Sale sale, int newClientIndex) throws SQLException {
        Vector<Integer> saleIds = sale.getIdSales();
        for (Integer idSale : saleIds) {
            this.getSalesDao().setClientIndexToSale(idSale, newClientIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientIndexToSale1(Sale sale, int newClientIndex) {
        try {
            this.setClientIndexToSaleNoCommit1(sale, newClientIndex);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServireToSale(Sale sale) {
        try {
            for (Integer idSale : sale.getIdSales()) {
                this.getSalesDao().setServireToSale(idSale, sale.getIdServire());
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllCorrections() {
        try {
            this.getDao().deleteCorrections();
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTableForOrder(int idTable, int idOrder) {
        try {
            this.getOrdersDao().updateTableForOrder(idTable, idOrder);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Integer, TipPlataValue> getTipPlataForSale(Vector<Integer> idSales) {
        try {
            Hashtable<Integer, TipPlataValue> hashtable = this.getOrdersDao().getTipPlataForSale(idSales, this.pool.requestConnection().getConnection());
            return hashtable;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Hashtable<Integer, TipPlataValue> hashtable = null;
            return hashtable;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AfisajClientBean getAfisajClientInfos() {
        Vector<Sale> sales = new Vector<Sale>();
        double totalFloat = 0.0;
        String platiString = null;
        platiString = "";
        AfisajClientBean result = new AfisajClientBean();
        result.setPlatiString(platiString);
        result.setRestdeplata(0.0);
        result.setSales(sales);
        result.setTotal(totalFloat);
        try {
            int currentOrder = Config.getInstance().getIntNoCommit("afisajClientCurrentOrder");
            if (currentOrder > 0) {
                sales = this.getSalesNoCommitNoCategoriesSort(currentOrder, false, -1, new ScreenSaleInterface());
                totalFloat = RestLogic.computeTotalForSales(sales);
                Order order = this.getOrderByIdNoCommit(currentOrder);
                int idClient = order.getIdClient();
                if (idClient > 0) {
                    String detaliiCont = "";
                    Vector<ValoareContClient> conturi = ClientLogic.getInstance().getConturiClientNoCommit(idClient, -1);
                    for (int i = 0; i < conturi.size(); ++i) {
                        ValoareContClient o1 = conturi.elementAt(i);
                        String numeCont = o1.getNumeCont();
                        double valoare = o1.getValoare();
                        String s = numeCont + ": " + Utils.getString2Decimals(valoare);
                        detaliiCont = detaliiCont + s + ", ";
                    }
                    if (detaliiCont.length() > 2) {
                        detaliiCont = detaliiCont.substring(0, detaliiCont.length() - 2);
                    }
                    result.setConturi(detaliiCont);
                    Client c = ClientLogic.getInstance().getClientByIdNoCommit(idClient);
                    result.setCustomerName(c.toString());
                }
                if (order.getIdPromotie() > 0) {
                    Promotion p = PromotionLogic.getInstance().getPromotionByIdNoCommit(order.getIdPromotie());
                    result.setPromotion(p.getLabel());
                }
                Vector<Plata> plati = PaymentLogic.getInstance().getPlatiForOrderNoCommit(currentOrder);
                for (int i = 0; i < plati.size(); ++i) {
                    Plata plata = plati.elementAt(i);
                    double s = plata.getSuma();
                    platiString = platiString + plata.getTipPlata() + " = " + Utils.getString2Decimals(s);
                    if (i >= plati.size() - 1) continue;
                    platiString = platiString + ", ";
                }
                result.setPlati(plati);
                result.setPlatiString(platiString);
                result.setRestdeplata(restOnCurrentOrderForAfisaj);
                result.setSales(sales);
                result.setTotal(totalFloat);
                result.setNull(false);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    @Override
    public ContaExportMapping getContaExportMappingForIdProduct(int idProduct) throws SQLException {
        return this.getDao().getContaExportMappingForIdProduct(idProduct);
    }

    @Override
    public Vector<ContaExportMapping> getAllContaExportMapping() throws SQLException {
        return this.getDao().getAllContaExportMapping();
    }

    @Override
    public ContaExportMapping getContaExportMappingForIdStock(int idStock) throws SQLException {
        return this.getDao().getContaExportMappingForIdStock(idStock);
    }

    @Override
    public ContaExportMapping getContaExportMappingForCodExtern(String codExtern) throws SQLException {
        return this.getDao().getContaExportMappingForCodExtern(codExtern);
    }

    @Override
    public void addContaExportMapping(String codExtern, int idProduct, int idStock) throws SQLException {
        this.getDao().addContaExportMapping(idStock, idProduct, codExtern);
    }

    @Override
    public void updateMappingById(String codExtern, int id) throws SQLException {
        this.getDao().updateContaExportMappingById(codExtern, id);
    }

    @Override
    public void updateMappingTvaByIdStock(double tva, int idStock) throws SQLException {
        this.getDao().updateContaExportTvaByIdStock(tva, idStock);
    }

    public void incasareNoCommit(Vector plati, String tipDocument, int idLocatie, String nrDocument, Timestamp closedate, String anexa, String explicatii, Vector facturiEmise) throws SQLException {
        for (int i = 0; i < plati.size(); ++i) {
            Plata plata = (Plata)plati.elementAt(i);
            ContaLogic.getInstance().adaugaIncasareNoCommit(plata, idLocatie, tipDocument, nrDocument, closedate, anexa, explicatii, facturiEmise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incasareCommit(Vector plati, String tipDocument, int idLocatie, String nrDocument, Timestamp closedate, String anexa, String explicatii, Vector<PlatiEntry> facturiEmise) {
        try {
            this.incasareNoCommit(plati, tipDocument, idLocatie, nrDocument, closedate, anexa, explicatii, facturiEmise);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    @Override
    public Vector<ClientHistoryCommentBean> getComments(Client c) {
        Vector<ClientHistoryCommentBean> result = new Vector<ClientHistoryCommentBean>();
        Vector<IncasareClientView> orders = this.getIncasariByIdClient(c.getId());
        for (IncasareClientView icv : orders) {
            Order o = RestLogic.getInstance().getOrderById(icv.getIdOrder());
            String detalii = o.getDetalii();
            if (!Validators.correctString(detalii)) continue;
            ClientHistoryCommentBean bean = new ClientHistoryCommentBean();
            bean.setComment(detalii);
            bean.setData(new Date(o.getStopTime()));
            result.add(bean);
        }
        Vector c1 = ContracteLogic.getInstance().getComments(c.getId());
        for (int i = 0; i < c1.size(); ++i) {
            String s = (String)c1.elementAt(i);
            ClientHistoryCommentBean bean = new ClientHistoryCommentBean();
            bean.setComment(s);
            bean.setData(null);
            result.add(bean);
        }
        return result;
    }

    @Override
    public Vector<ClientHistorySalesBean> getSales(Client c) {
        Vector<ClientHistorySalesBean> result = new Vector<ClientHistorySalesBean>();
        Hashtable<String, Comparable<Date>> criteria = new Hashtable<String, Comparable<Date>>();
        criteria.put(Constants.START_KEY, DateUtils.getStartOfDays());
        criteria.put(Constants.STOP_KEY, DateUtils.getEndOfDays());
        criteria.put("client_pf", c);
        Vector<NoteView> istoricVz = RestLogic.getInstance().getNote(criteria, false, -1);
        for (NoteView fe : istoricVz) {
            String detalii = fe.getData() != null ? (VpConfig.getInstance().showDetaliiNota ? fe.getDetalii() + "," : "") + fe.getOspatarMasa() + "," + Utils.getString2Decimals(fe.getTotalNota()) : "";
            String data = fe.getData() != null ? Formatters.DATE_AND_TIME_FORMAT.format(fe.getData()) : "";
            ClientHistorySalesBean bean = new ClientHistorySalesBean();
            bean.setDetalii(detalii);
            bean.setData(data);
            bean.setProdus(fe.getProdus());
            bean.setCantitate(fe.getCantitate());
            bean.setPret(fe.getSuma() / fe.getCantitate());
            result.add(bean);
        }
        return result;
    }

    public int getOrderByExternalIdNoCommit(String externalOrderId) throws SQLException {
        return this.getOrdersDao().getOrderByExternalId(externalOrderId);
    }

    public Vector<Plata> getPlatiForOrder(int orderId, int clientFilter1) {
        return PaymentLogic.getInstance().getPlatiForOrder(orderId, clientFilter1);
    }

    public void addPlataToOrder(Order order, Plata plata) {
        PaymentLogic.getInstance().addPlataToOrder(order, plata);
    }

    public void addPlataToOrderForHotel(Order order, Plata plata, Vector<Sale> newSales) {
        PaymentLogic.getInstance().addPlataToOrderForHotel(order, plata, newSales);
    }

    public void addPlataToOrderNoCommit(Order order, Plata plata) throws SQLException {
        PaymentLogic.getInstance().addPlataToOrderNoCommit(order, plata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllOrdersWithContForClient(int idClient) {
        try {
            Vector<Integer> ordersWithCont = this.getDao().getOrdersForTipPlataCont(idClient, this.pool.requestConnection().getConnection());
            for (Integer idOrder : ordersWithCont) {
                this.deleteOrderNoCommit(idOrder);
            }
            Vector<ValoareContClient> conturiClient = ClientLogic.getInstance().getConturiClient(idClient, -1);
            for (ValoareContClient valoareContClient : conturiClient) {
                ClientLogic.getInstance().adaugaTranzactieNoCommit(valoareContClient.getTipCont().getId(), idClient, -valoareContClient.getValoare(), "Corectie sold la zero");
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copySalesToCurrentOrderFromCont(int idClient, Order order) {
        try {
            Vector<Integer> ordersWithCont = this.getDao().getOrdersForTipPlataCont(idClient, this.pool.requestConnection().getConnection());
            for (Integer idOrder : ordersWithCont) {
                Vector<Sale> salesCurrent = this.getSalesNoCommitNoSort(idOrder, false, -1, new ScreenSaleInterface(), -1);
                for (Sale sale : salesCurrent) {
                    sale.setIdOrder(order.getId());
                    sale.setCantitateNoua(sale.getCantitateMarcata());
                    sale.setCantitateMarcata(0.0);
                    sale.setDiscount(0.0);
                    this.addSaleNoCommit(sale, order.getUser());
                }
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public boolean deleteStockAndNotifyListeners(PricePanelEntry pe, JComponent parent) {
        boolean action = StockLogic.getInstance().deleteStock(pe.getIdStock(), parent);
        if (action) {
            NomeclaturaLogic.getInstance().notifyListeners(2);
        }
        return action;
    }

    public BonFiscalNumber getBonFiscalNumber(int idOrder) throws SQLException {
        return this.getOrdersDao().getBonFiscalNumberForIdOrder(idOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<OptiuneProduseMeniu> getAllOptiuniProduse() {
        Vector<OptiuneProduseMeniu> result = new Vector();
        try {
            result = this.getDao().getAllOptiuniProduse();
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabelOptiuneFromId(int id) {
        String result = "";
        try {
            result = this.getDao().getLabelOptiuneFromId(id);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdMeniuFromCodsync(String codsync) {
        int result = -1;
        try {
            result = this.getDao().getIdMeniuFromCodsync(codsync);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdMeniuFromLabel(String label) {
        int result = -1;
        try {
            result = this.getDao().getIdMeniuFromLabel(label);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdOptiuneFromLabel(String label) {
        int result = -1;
        try {
            result = this.getDao().getIdOptiuneFromLabel(label);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllOptiuniProduse(int idMeniu) {
        try {
            this.getDao().deleteAllOptiuniProduse(idMeniu);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodsyncForMeniu(int idMeniu, String codsync) {
        try {
            this.getDao().setCodsyncForMeniu(idMeniu, codsync);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void exportTranzactieToXml(int idData1, String destinationFile, String remote) throws SQLException {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<document>");
        TranzactieContClient tr = ClientLogic.getInstance().getTranzactieById(idData1);
        if (tr != null && remote == null) {
            Client client = ClientLogic.getInstance().getClientByIdNoCommit(tr.getIdClient());
            String codSyncClient = client.getCodSyncClient();
            bigFile.append("<tranzactie ");
            bigFile.append("\ttipcont=\"" + tr.getTipCont() + "\"\n");
            bigFile.append("\tcodSyncClient=\"" + codSyncClient + "\"\n");
            bigFile.append("\tdata=\"" + tr.getData() + "\"\n");
            bigFile.append("\tvaloare=\"" + tr.getValoare() + "\"\n");
            bigFile.append("\tdetalii=\"" + tr.getDetalii() + "\"\n");
            bigFile.append("\tcodSyncTranzactie=\"" + tr.getCodSync() + "\"\n");
            bigFile.append("/>\n");
        } else {
            bigFile.append("<tranzactie \ttodelete=\"true\"\n");
            bigFile.append("\tcodSyncTranzactie=\"" + remote + "\"\n");
            bigFile.append("/>\n");
        }
        bigFile.append("</document>");
        try {
            FileUtils.writeTextToFile(destinationFile, bigFile.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void exportCarduriToXml(int idClient, String destinationFile, String deleteCodeSync) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<document>");
        if (deleteCodeSync == null) {
            Vector<ClientPromotieView> carduri = PromotionLogic.getInstance().getPromotiiClientByIdClient(idClient);
            if (!carduri.isEmpty()) {
                Client c = ClientLogic.getInstance().getClientById(idClient);
                for (ClientPromotieView pc : carduri) {
                    bigFile.append("<promotie ");
                    bigFile.append("\tcodSyncCard=\"" + pc.getCodSyncCard() + "\"\n");
                    bigFile.append("\tcodSyncClient=\"" + c.getCodSyncClient() + "\"\n");
                    Promotion p = PromotionLogic.getInstance().getPromotionById(pc.getIdPromotie());
                    bigFile.append("\tpromotie=\"" + p.getLabel() + "\"\n");
                    bigFile.append("\tcard=\"" + pc.getCodStart() + "\"\n");
                    bigFile.append("\tcardstop=\"" + pc.getCodStop() + "\"\n");
                    bigFile.append("\tdateadded=\"" + Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(pc.getDateadded()) + "\"\n");
                    bigFile.append("/>\n");
                }
            }
        } else {
            bigFile.append("<promotie ");
            bigFile.append("\tcodSyncCard=\"" + deleteCodeSync + "\"\n");
            bigFile.append("\tdelete=\"delete\"\n");
            bigFile.append("/>\n");
        }
        bigFile.append("</document>");
        try {
            FileUtils.writeTextToFile(destinationFile, bigFile.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void setReducereValoricaForOrderNoCommit(int idOrder, double reducereValorica) throws SQLException {
        this.getOrdersDao().setReducereValoricaForOrder(idOrder, reducereValorica);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAndSetReducereValoricaToOrder(Order o, double reducereValorica) {
        try {
            Vector<Sale> sales = this.getOrdersDao().getSales(o.getId(), false, -1, -1, this.pool.requestConnection().getConnection(), new ScreenSaleInterface());
            this.subtractDiscountFromSales(sales, reducereValorica);
            this.setReducereValoricaForOrderNoCommit(o.getId(), reducereValorica);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodFiscalToOrder(int idOrder, String codFiscal) {
        try {
            this.getOrdersDao().setCodFiscalToOrder(idOrder, codFiscal);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void updateSaleNoCommit(int idSale, double cant, int idPromo, double discount, double price) throws SQLException {
        this.getSalesDao().updateSale(idSale, cant, idPromo, discount, price);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Order> getFilteredOrders(Hashtable criteria) {
        Vector<Order> result = new Vector();
        int status = (Integer)criteria.get(Constants.STATUS);
        int idClient = (Integer)criteria.get(Constants.CLIENT_KEY);
        int idUser = (Integer)criteria.get("user");
        Vector idTables = (Vector)criteria.get(Constants.TABLE_KEY);
        try {
            result = this.getOrdersDao().getFilteredOrders(status, idClient, idUser, idTables);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatusForOrder(Order o, int status) {
        try {
            this.getOrdersDao().setStatusForOrder(o, status);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Order> getGataDeLivrareOrders(Vector<Order> orders) {
        Vector<Order> result = new Vector<Order>();
        try {
            for (Order order : orders) {
                Vector<Sale> sales = this.getSalesNoCommitNoSort(order.getId(), true, -1, new HotelOrderSaleInterface(), -1);
                if (!this.hasSaleForLivrare(sales)) continue;
                result.add(order);
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    public Hashtable<Integer, InformatieMagazieProdus> getAvailableStockInMagazieForProducts(Vector<Integer> idProducts, Order o) {
        Hashtable<Integer, InformatieMagazieProdus> result = new Hashtable<Integer, InformatieMagazieProdus>();
        for (Integer idProduct : idProducts) {
            if (result.get(idProduct) != null) continue;
            InformatieMagazieProdus detalii = this.stockLogic.getDetaliiProdusForTableNew(idProduct, o);
            result.put(idProduct, detalii);
        }
        return result;
    }

    public boolean isOrderGataDeLivrare(Order o) {
        Vector<Sale> sales = this.getSales(o.getId(), true, -1, new HotelOrderSaleInterface(), -1);
        return this.hasSaleForLivrare(sales);
    }

    public boolean hasSaleForLivrare(Vector<Sale> sales) {
        for (Sale sale : sales) {
            if (!sale.isFacturata() || sale.isPrinted()) continue;
            return true;
        }
        return false;
    }

    public Vector<Sale> buildSalesForFacturareGUI(Component parent, Vector<Sale> sales, Order o) {
        Vector<Sale> result = new Vector<Sale>();
        Vector<Integer> idProducts = new Vector<Integer>();
        for (Sale sale : sales) {
            int idProduct = sale.getIdProduct();
            if (idProducts.contains(idProduct)) continue;
            idProducts.add(idProduct);
        }
        SearchSaleInterface search = new SearchSaleInterface(){

            @Override
            public int getIndexForSale(Sale s, Vector data) {
                for (int i = 0; i < data.size(); ++i) {
                    Sale current = (Sale)data.elementAt(i);
                    if (!current.equalsForTipPlataIntermediara(s)) continue;
                    return i;
                }
                return -1;
            }
        };
        Hashtable<Integer, InformatieMagazieProdus> availableStock = this.getAvailableStockInMagazieForProducts(idProducts, o);
        Vector<Sale> cumulatedSales = new Vector<Sale>();
        Hashtable<Integer, Double> totalQuantitiesInSales = new Hashtable<Integer, Double>();
        for (Sale sale : sales) {
            this.addToCumulatedVector(cumulatedSales, new HotelOrderSaleInterface(), sale, true);
            Double q = (Double)totalQuantitiesInSales.get(sale.getIdProduct());
            if (q == null) {
                q = 0.0;
            }
            totalQuantitiesInSales.put(sale.getIdProduct(), q + sale.getCantitateMarcata());
        }
        for (Sale sale : cumulatedSales) {
            Double totalQuantity = (Double)totalQuantitiesInSales.get(sale.getIdProduct());
            if (sale.isFacturata() || !(totalQuantity > 0.0)) continue;
            InformatieMagazieProdus peStockInfos = availableStock.get(sale.getIdProduct());
            Hashtable<Integer, Double> cantitateRezervataPeOrder = StockLogic.getInstance().getCantitateRezervataPeOrder(o);
            Double rezervatPeComandaCurenta = cantitateRezervataPeOrder.get(sale.getIdProduct());
            double inMagazie = peStockInfos.getInMagazie();
            double disponibilDeFacturat = peStockInfos.getDisponibilDeFacturat();
            if (inMagazie > 0.0) {
                if (disponibilDeFacturat < totalQuantity) {
                    double comenziFerme = peStockInfos.getComenziFerme();
                    double rezervataPeAlteComenzi = comenziFerme - rezervatPeComandaCurenta;
                    double maxPosibilDeFacturat = Math.min(totalQuantity, inMagazie);
                    double minDeFacturat = disponibilDeFacturat > Double.valueOf(0.0) ? disponibilDeFacturat : 0.0;
                    double facturamAcum = maxPosibilDeFacturat;
                    if (comenziFerme > inMagazie) {
                        DialogUtils.okDialog(parent, "<html>Produsul <b>" + sale.getProductName() + "</b> are stoc " + inMagazie + " si comenzi ferme TOTALE <b>" + comenziFerme + "</b> din care : <br>" + " pe comanda in curs <b>" + rezervatPeComandaCurenta + "</b><br>" + " pe alte comenzi <b>" + rezervataPeAlteComenzi + "</b> . <br>" + "<h3><center>Cat facturam pe comanda curenta ? . Intre (" + minDeFacturat + " si " + maxPosibilDeFacturat + ")</h3></html>", LangRoAll.atentie);
                        String input = DialogUtils.inputDialog(parent, maxPosibilDeFacturat + "", LangRoAll.factura + " " + sale.getProductName());
                        if (!Validators.correctDouble(input)) {
                            DialogUtils.errorDialog(parent, "Nu ati introdus un numar. Ignor produsul " + sale.getProductName(), LangRoAll.operatieEsuata);
                            continue;
                        }
                        facturamAcum = Utils.parseDouble(input);
                    }
                    peStockInfos.setDisponibilDeFacturat(facturamAcum);
                } else {
                    peStockInfos.setDisponibilDeFacturat(disponibilDeFacturat);
                }
            }
            totalQuantitiesInSales.put(sale.getIdProduct(), 0.0);
        }
        for (Sale toAdd : sales) {
            if (!toAdd.isFacturata()) {
                InformatieMagazieProdus detalii = availableStock.get(toAdd.getIdProduct());
                double disponibil = detalii.getDisponibilDeFacturat();
                boolean isDisponibil = true;
                if (disponibil <= 0.0) {
                    isDisponibil = false;
                }
                if (toAdd.getCantitateMarcata() <= disponibil) {
                    toAdd.setSelectedForIntermediara(true);
                    this.addToCumulatedVector(result, search, toAdd);
                    detalii.setDisponibilDeFacturat(disponibil - toAdd.getCantitateMarcata());
                    availableStock.put(toAdd.getIdProduct(), detalii);
                    continue;
                }
                if (isDisponibil) {
                    Sale newSale = toAdd.clone();
                    newSale.addIdSale(toAdd.getFirstIdSale());
                    newSale.setCantitateMarcata(disponibil);
                    double cant = toAdd.getCantitateMarcata();
                    toAdd.setCantitateMarcata(cant - disponibil);
                    result.add(toAdd);
                    detalii.setDisponibilDeFacturat(0.0);
                    availableStock.put(toAdd.getIdProduct(), detalii);
                    newSale.setSelectedForIntermediara(true);
                    this.addToCumulatedVector(result, search, newSale);
                    continue;
                }
                this.addToCumulatedVector(result, search, toAdd);
                continue;
            }
            this.addToCumulatedVector(result, search, toAdd);
        }
        Collections.sort(result, new Comparator<Sale>(){

            @Override
            public int compare(Sale o1, Sale o2) {
                int result = -1;
                if (o1.isSelectedForIntermediara() && !o2.isSelectedForIntermediara() || o1.isFacturata() && !o2.isFacturata() || o1.isPrinted() && !o2.isPrinted()) {
                    result = 1;
                }
                return result;
            }
        });
        return result;
    }

    private void addToCumulatedVector(Vector<Sale> result, SearchSaleInterface search, Sale toAdd, boolean clone) {
        int index = search.getIndexForSale(toAdd, result);
        if (index != -1) {
            Sale existing = result.elementAt(index);
            existing.setCantitateMarcata(existing.getCantitateMarcata() + toAdd.getCantitateMarcata());
            existing.setCantitateNoua(existing.getCantitateNoua() + toAdd.getCantitateNoua());
            existing.addIdSale(toAdd.getFirstIdSale());
        } else if (clone) {
            Sale sale = toAdd.cloneWithBooleans();
            result.add(sale);
        } else {
            result.add(toAdd);
        }
    }

    private void addToCumulatedVector(Vector<Sale> result, SearchSaleInterface search, Sale toAdd) {
        this.addToCumulatedVector(result, search, toAdd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void splitSalesForFacturareIfNecessary(Order order, Vector<Sale> selectedSales) {
        Vector<Sale> sales = this.getSales(order.getId(), false, -1, new HotelOrderSaleInterface());
        Hashtable<Integer, Sale> salesWithId = new Hashtable<Integer, Sale>();
        for (Sale sale : sales) {
            salesWithId.put(sale.getFirstIdSale(), sale);
        }
        for (Sale selectedSale : selectedSales) {
            Double cantitate = selectedSale.getCantitateMarcata();
            Vector<Integer> idSales = selectedSale.getIdSales();
            for (Integer idSale : idSales) {
                Sale s = (Sale)salesWithId.get(idSale);
                if (cantitate >= s.getCantitateMarcata()) {
                    cantitate = cantitate - s.getCantitateMarcata();
                    continue;
                }
                if (!(cantitate > 0.0)) continue;
                double cantitateMarcata = s.getCantitateMarcata();
                s.setCantitateMarcata(cantitate);
                Sale sNew = s.clone();
                sNew.setCantitateMarcata(cantitateMarcata - cantitate);
                sNew.setCantitateNoua(cantitateMarcata - cantitate);
                cantitate = 0.0;
                try {
                    this.updateSaleNoCommit(s.getFirstIdSale(), s.getCantitateMarcata(), s.getIdPromotie(), s.getDiscount(), s.getPrice());
                    this.addSaleNoCommit(sNew, order.getUser());
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                    try {
                        this.pool.rollBack();
                    }
                    catch (SQLException e1) {
                        Logger.logException(this, (Exception)e1);
                    }
                }
                finally {
                    this.pool.releaseConnection();
                }
            }
        }
    }

    public boolean orderHasComandaFerma(Order o) {
        int documentId = FacturiLogic.getInstance().getDocumentForComandaFermaOnOrder(o);
        return documentId != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reproceseazaStocRezervat(Order o, Vector<Sale> selectedSales) {
        int documentId = FacturiLogic.getInstance().getDocumentForComandaFermaOnOrder(o);
        if (documentId != -1) {
            try {
                Document doc = this.getDocumentById(documentId);
                int factura_id = doc.getIdFacturaEmisa();
                Vector facturiItems = FacturiLogic.getInstance().getFacturiItemsNoCommit(factura_id);
                Vector<FacturaItemView> toAdd = new Vector<FacturaItemView>();
                for (Sale selectedSale : selectedSales) {
                    int idProduct = selectedSale.getIdProduct();
                    for (FacturaItemView facturiItem : facturiItems) {
                        if (facturiItem.getIdProduct() != idProduct) continue;
                        FacturiLogic.getInstance().deleteFacturaItemsByIdNoCommit(facturiItem.getId());
                        if (!(selectedSale.getCantitateMarcata() < facturiItem.getCantitate())) continue;
                        double cantitateRamasa = facturiItem.getCantitate() - selectedSale.getCantitateMarcata();
                        facturiItem.setCantitate(cantitateRamasa);
                        facturiItem.setValoare(cantitateRamasa * facturiItem.getPpuFaraTva());
                        facturiItem.setValoareTva(cantitateRamasa * facturiItem.getCotaTva());
                        toAdd.add(facturiItem);
                    }
                }
                FacturiLogic.getInstance().addFacturaItems(factura_id, toAdd);
                this.getDao().documentNeprocesat(documentId);
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                try {
                    this.pool.rollBack();
                }
                catch (SQLException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
            finally {
                this.pool.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertIntoSalesPictures(int idSale, String pictureName) {
        try {
            this.getSalesDao().insertIntoSalesPictures(idSale, pictureName);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImgSrcFromSalesPictures(int idSale) {
        try {
            String string = this.getSalesDao().getImgSrcFromSalesPictures(idSale);
            return string;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            String string = null;
            return string;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getTotalOnSales(Vector<Sale> sales) {
        Double result = new Double(0.0);
        try {
            result = this.getTotalOnSalesNoCommit(sales);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Double getTotalOnSalesNoCommit(Vector<Sale> sales) throws SQLException {
        Double result = new Double(0.0);
        for (Sale sale : sales) {
            double price = this.getPriceForProductNoCommit(sale.getIdProduct());
            result = result + price;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canBeBought(Integer idProduct, Client c, Vector<Sale> sales) {
        try {
            double productPrice = this.getPriceForProductNoCommit(idProduct);
            double totalSales = this.getTotalOnSalesNoCommit(sales);
            Double totalClient = ClientLogic.getInstance().getTotalDetaliiConturi(c.getId());
            if (productPrice + totalSales <= totalClient) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return false;
    }

    public static String getOrderIdentifier(String userName, int idOrder) {
        String codUnicDatabase = VpConfig.getInstance().codUnicDatabase;
        if (Validators.correctString(codUnicDatabase)) {
            return codUnicDatabase + "_" + idOrder;
        }
        return Utils.getLocalComputerName() + "_" + idOrder + "_" + userName;
    }

    public void updatePriceForArticolBean(ArticolBean articolBean) {
        switch (articolBean.getType()) {
            case RETETA_SAU_SERVICIU: {
                int idReteta = this.getIdReteta(articolBean.getIdProdus());
                RestLogic.getInstance().setPriceForRetetaProduct(idReteta, articolBean.getPretVanzare(), true);
                break;
            }
            case MARFA: {
                StockLogic.getInstance().modificaPret(articolBean.getIdStock(), articolBean.getPretVanzare(), true, DateUtils.getCurrentTimestamp());
            }
        }
    }

    public void updateUzInternForArticolBean(ArticolBean articolBean) {
        switch (articolBean.getType()) {
            case RETETA_SAU_SERVICIU: 
            case MARFA: {
                this.nomeclaturaLogic.updateUzInternForProductCommit(articolBean.isUzIntern(), articolBean.getIdProdus());
            }
        }
    }

    public Vector<ArticolBean> getAllArticole() {
        Hashtable criteriaNew = new Hashtable();
        Vector<ArticolBean.ARTICOL_TYPE> types = new Vector<ArticolBean.ARTICOL_TYPE>();
        types.add(ArticolBean.ARTICOL_TYPE.TOATE);
        criteriaNew.put("tip_produs_key", types);
        return this.getAllArticole(criteriaNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ArticolBean> getAllArticole(Hashtable criteria) {
        Vector result = new Vector();
        try {
            ArticolBean articolBean = (ArticolBean)criteria.get("Articol");
            if (articolBean != null) {
                Hashtable<String, Object> criteriaNew = new Hashtable<String, Object>();
                criteriaNew.put("Articol", articolBean);
                Vector<ArticolBean.ARTICOL_TYPE> types = new Vector<ArticolBean.ARTICOL_TYPE>();
                types.add(ArticolBean.ARTICOL_TYPE.TOATE);
                criteriaNew.put("tip_produs_key", types);
                Vector<ArticolBean> vector = this.getDao().getArticole(criteriaNew);
                return vector;
            }
            Vector<ArticolBean> vector = this.getDao().getArticole(criteria);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return new Vector<ArticolBean>();
    }

    public static enum RegistreInterne {
        NIR("nir", "NIR"),
        BON_CONSUM_TRANSFER_INTERN("bon_consum_transfer_intern", "Bon Consum Transfer intern"),
        CHITANTA_INTERN("chitanta_intern", "Chitanta");

        public String key;
        public String nume;

        private RegistreInterne(String key, String nume) {
            this.key = key;
            this.nume = nume;
        }
    }
}

