/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecronline.BonFiscal;
import ro.atreides.ecronline.BonFiscalItem;
import ro.atreides.ecronline.BonFiscalPlata;
import ro.atreides.restaurant.base.RemoteOrder;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.logic.SaleSyncImpl;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;

public class SalesSync
extends Thread {
    private int port;
    private static final int SLEEP_SECONDS = 60;
    private String host;
    private Connection remote;
    private PreparedStatement selectOrdersFromRemote;
    private PreparedStatement selectSalesFromRemote;
    private PreparedStatement deleteOrderFromRemote;
    private PreparedStatement deleteSalesFromRemote;
    private PreparedStatement selectPlatiFromRemote;
    private PreparedStatement deletePlatiFromRemote;
    private ConnectionPool pool;
    private static PrintWriter writer;

    private synchronized SaleSyncImpl getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        SaleSyncImpl dao = null;
        while (dao == null) {
            dao = (SaleSyncImpl)this.pool.getDao(SaleSyncImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(SaleSyncImpl.class.getName(), connection);
        }
        return dao;
    }

    public SalesSync(String host, int port) throws SQLException {
        this.host = host;
        this.port = port;
        this.pool = ConnectionPool.getInstance();
        this.setName("SaleSync");
        try {
            writer = new PrintWriter(new FileWriter("salesync.log", true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.start();
    }

    private void logException(Exception e) {
        writer.println(">>>> " + Formatters.currentDateAndTimeForFileSystem.format(DateUtils.getCurrentTimestamp()) + ": Exception: " + e.getMessage());
        e.printStackTrace(writer);
        writer.flush();
    }

    private void logInfo(String info) {
        writer.println(">>>> " + Formatters.currentDateAndTimeForFileSystem.format(DateUtils.getCurrentTimestamp()) + ": Info: " + info);
        writer.flush();
    }

    private void buildRemoteConnection() throws SQLException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        String url = "jdbc:derby://" + this.host + ":" + this.port + "/db";
        String driver = "org.apache.derby.jdbc.ClientDriver";
        Class.forName(driver).newInstance();
        Properties props = new Properties();
        props.put("user", "user1");
        props.put("password", "user1");
        this.remote = DriverManager.getConnection(url, props);
        this.remote.setAutoCommit(false);
        this.selectOrdersFromRemote = this.remote.prepareStatement("select * from orders where status = 4 order by closedate");
        this.deleteOrderFromRemote = this.remote.prepareStatement("delete from orders where id = ?");
        this.selectSalesFromRemote = this.remote.prepareStatement("select sales.*, products.cod from sales inner join products on sales.id_product = products.id where id_order = ?");
        this.deleteSalesFromRemote = this.remote.prepareStatement("delete from sales where id_order = ?");
        this.selectPlatiFromRemote = this.remote.prepareStatement("select suma, map_ecr from rest_incasari inner join tip_plata on rest_incasari.id_tip_plata = tip_plata.id where id_order = ?");
        this.deletePlatiFromRemote = this.remote.prepareStatement("delete from rest_incasari where id_order = ?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOrderAdded(Timestamp time) {
        boolean result = false;
        try {
            result = this.getDao().isOrderAdded(time);
        }
        catch (SQLException e) {
            this.logException(e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e1) {
                this.logException(e1);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Hashtable<Timestamp, RemoteOrder> existingOrders = new Hashtable<Timestamp, RemoteOrder>();
        block28: while (true) {
            boolean connected = false;
            while (!connected) {
                try {
                    this.buildRemoteConnection();
                    connected = true;
                    this.logInfo("Connected");
                }
                catch (Exception e) {
                    this.logException(e);
                    try {
                        SalesSync.sleep(60000L);
                    }
                    catch (InterruptedException e1) {}
                }
            }
            while (true) {
                int i;
                if (!connected) continue block28;
                Vector<RemoteOrder> allOrders = new Vector<RemoteOrder>();
                try {
                    ResultSet remoteOrders = this.selectOrdersFromRemote.executeQuery();
                    while (remoteOrders.next()) {
                        String pString = remoteOrders.getString("protocol");
                        boolean protocol = Boolean.valueOf(pString);
                        int idOrderRemote = remoteOrders.getInt("id");
                        int idPromotie = remoteOrders.getInt("id_promotie");
                        Timestamp closedate = remoteOrders.getTimestamp("closedate");
                        String fiscal = remoteOrders.getString("fiscal");
                        RemoteOrder toProcess = new RemoteOrder();
                        toProcess.setId(idOrderRemote);
                        toProcess.setClosedate(closedate);
                        toProcess.setId_promotie(idPromotie);
                        toProcess.setFiscal(fiscal);
                        toProcess.setProtocol(protocol);
                        allOrders.add(toProcess);
                    }
                    remoteOrders.close();
                }
                catch (SQLException e) {
                    this.logException(e);
                    connected = false;
                    continue;
                }
                finally {
                    try {
                        this.remote.commit();
                    }
                    catch (SQLException e) {
                        this.logException(e);
                    }
                    continue;
                }
                Vector<RemoteOrder> ordersToProcess = new Vector<RemoteOrder>();
                for (i = 0; i < allOrders.size(); ++i) {
                    RemoteOrder remoteOrder = (RemoteOrder)allOrders.elementAt(i);
                    Timestamp search = remoteOrder.getClosedate();
                    if (existingOrders.get(search) != null) continue;
                    if (this.isOrderAdded(search)) {
                        existingOrders.put(search, remoteOrder);
                        continue;
                    }
                    ordersToProcess.add(remoteOrder);
                }
                for (i = 0; i < ordersToProcess.size(); ++i) {
                    try {
                        int idTable = 1;
                        int idUser = 1;
                        RemoteOrder remoteOrder = (RemoteOrder)ordersToProcess.elementAt(i);
                        BonFiscal bf = new BonFiscal();
                        bf.setDataBon(remoteOrder.getClosedate().getTime());
                        Vector<BonFiscalPlata> plati = new Vector<BonFiscalPlata>();
                        this.selectPlatiFromRemote.setInt(1, remoteOrder.getId());
                        ResultSet remotePlati = this.selectPlatiFromRemote.executeQuery();
                        while (remotePlati.next()) {
                            BonFiscalPlata bfp = new BonFiscalPlata();
                            bfp.setSuma(remotePlati.getDouble("suma"));
                            String codCasa = remotePlati.getString("map_ecr");
                            TipPlata tp = TipPlataProvider.getInstance().getTipPlataByCodCasa(codCasa);
                            bfp.setTipPlata(tp.getId());
                            plati.add(bfp);
                        }
                        remotePlati.close();
                        bf.setPlati(plati);
                        Vector<BonFiscalItem> sales = new Vector<BonFiscalItem>();
                        this.selectSalesFromRemote.setInt(1, remoteOrder.getId());
                        ResultSet remoteSales = this.selectSalesFromRemote.executeQuery();
                        while (remoteSales.next()) {
                            int cod = remoteSales.getInt("cod");
                            double cantitate = remoteSales.getDouble("quantity_float");
                            int idPlatou = remoteSales.getInt("id_platou");
                            BonFiscalItem bfi = new BonFiscalItem();
                            bfi.setCod(cod);
                            bfi.setQuantity(cantitate);
                            bfi.setIdPlatou(idPlatou);
                            bfi.setIdPromotion(remoteOrder.getId_promotie());
                            sales.add(bfi);
                        }
                        remoteSales.close();
                        this.remote.commit();
                        bf.setItems(sales);
                        RestLogic.getInstance().notaByBonFiscal(bf, idTable, idUser, remoteOrder.isProtocol(), false, false);
                        this.pool.commit();
                        boolean fisc = Boolean.parseBoolean(remoteOrder.getFiscal());
                        if (!fisc) {
                            int idOrderRemote = remoteOrder.getId();
                            try {
                                this.deleteSalesFromRemote.setInt(1, idOrderRemote);
                                this.deleteSalesFromRemote.execute();
                                this.deletePlatiFromRemote.setInt(1, idOrderRemote);
                                this.deletePlatiFromRemote.execute();
                                this.deleteOrderFromRemote.setInt(1, idOrderRemote);
                                this.deleteOrderFromRemote.execute();
                                this.remote.commit();
                            }
                            catch (SQLException e) {
                                this.logException(e);
                                try {
                                    this.remote.rollback();
                                    this.logInfo("Remote rollback ok");
                                }
                                catch (SQLException e1) {
                                    this.logException(e1);
                                }
                                throw e;
                            }
                        }
                        existingOrders.put(remoteOrder.getClosedate(), remoteOrder);
                        continue;
                    }
                    catch (SQLException e) {
                        this.logException(e);
                        try {
                            this.pool.rollBack();
                            this.logInfo("Local rollback ok");
                        }
                        catch (SQLException e1) {
                            this.logException(e1);
                        }
                        connected = false;
                        continue;
                    }
                    finally {
                        this.pool.releaseConnection();
                    }
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                }
            }
            break;
        }
    }
}

