/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic.exports;

import java.io.File;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.base.reports.SalesEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.HttpUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.db.ConnectionPool;

@Deprecated
public class DataSyncXmlMultiExporter
implements Runnable {
    private static final int NEW = 1;
    private static final int DATA_COMPLETED = 2;
    private static final int SENT = 3;
    private static final int ERROR = 4;
    private static final int ERRCODE_NO_ERROR = 0;
    private static final int ERRCODE_PERMANENT_ERROR = 1;
    private static final int ERRCODE_TEMPORARY_ERROR = 2;
    private String serverIp;
    private int serverPort;
    public static final int SYNC_NOTA = 1;
    public static final int SYNC_PARTENER = 2;
    public static final int SYNC_PRODUCT = 3;
    public static final int SYNC_NIR = 4;
    public static final int SYNC_STOCK = 5;
    public static final int SYNC_MAT_PRIMA = 6;
    public static final int SYNC_RETETA = 7;
    public static final String POST_ORDER = "order";
    public static final String POST_PARTNER = "partner";
    public static final String POST_STOCK = "stock";
    public static final String POST_PRODUCT = "product";
    public static final String POST_NIR = "nir";
    public static final String POST_MAT_PRIMA = "matprima";
    public static final String POST_RETETA = "reteta";
    private String location = "";
    private String fallbackUser = "";
    private static String salesDir;
    private static String parteneriDir;
    private static String produseDir;
    private static String niruriDir;
    private static String stocuriDir;
    private static String materiePrimaDir;
    private static String reteteDir;
    private static Object lock;
    private static PreparedStatement insertTriggeredData;
    private static PreparedStatement updatePhase2;
    private static PreparedStatement updatePhase3SENT;
    private static PreparedStatement selectPhase1;
    private static PreparedStatement selectPhase2;
    private static PreparedStatement updatePhase3ERROR;
    private static Connection connection;

    public DataSyncXmlMultiExporter(String serverIp, int port, String location, String fallbackUser) {
        this.serverIp = serverIp;
        this.serverPort = port;
        this.location = location;
        this.fallbackUser = fallbackUser;
        String tmp = FileUtils.getTempDir();
        File f = new File(tmp + File.separator + "exports" + File.separator + "sales");
        f.mkdirs();
        salesDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "parteneri");
        f.mkdirs();
        parteneriDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "produse");
        f.mkdirs();
        produseDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "stocuri");
        f.mkdirs();
        stocuriDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "niruri");
        f.mkdirs();
        niruriDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + POST_MAT_PRIMA);
        f.mkdirs();
        materiePrimaDir = f.getAbsolutePath();
        f = new File(tmp + File.separator + "exports" + File.separator + "retete");
        f.mkdirs();
        reteteDir = f.getAbsolutePath();
    }

    public static int exportClosedOrder(int idClosedOrder) throws SQLException {
        System.out.println("order to export: " + idClosedOrder);
        DataSyncXmlMultiExporter.export(idClosedOrder, 1);
        return idClosedOrder;
    }

    public static int exportPartener(int id) throws SQLException {
        System.out.println("partener to export: " + id);
        DataSyncXmlMultiExporter.export(id, 2);
        return id;
    }

    public static int exportProduct(int id) throws SQLException {
        System.out.println("product to export: " + id);
        DataSyncXmlMultiExporter.export(id, 3);
        return id;
    }

    public static int exportStock(int id) throws SQLException {
        System.out.println("stock to export: " + id);
        DataSyncXmlMultiExporter.export(id, 5);
        return id;
    }

    public static int exportNir(int id) throws SQLException {
        System.out.println("nir to export: " + id);
        DataSyncXmlMultiExporter.export(id, 4);
        return id;
    }

    public static int exportMateriePrima(int id) throws SQLException {
        System.out.println("materie prima to export: " + id);
        DataSyncXmlMultiExporter.export(id, 6);
        return id;
    }

    public static int exportReteta(int id) throws SQLException {
        System.out.println("reteta to export: " + id);
        DataSyncXmlMultiExporter.export(id, 7);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void export(int id, int tip) throws SQLException {
        Object object = lock;
        synchronized (object) {
            if (insertTriggeredData != null) {
                insertTriggeredData.setInt(1, tip);
                insertTriggeredData.setInt(2, 1);
                insertTriggeredData.setInt(3, id);
                insertTriggeredData.execute();
                connection.commit();
            }
        }
    }

    private void buildPreparedStatements() throws SQLException {
        insertTriggeredData = connection.prepareStatement("insert into triggered_data ( what, id_data, error_type ) values (?, ?, ?, 0)");
        updatePhase2 = connection.prepareStatement("update triggered_data set status = 2, xml_data = ?, last_action = current_timestamp, post_action = ? where id = ?");
        updatePhase3SENT = connection.prepareStatement("update triggered_data set status = 3,last_action = current_timestamp where id = ?");
        updatePhase3ERROR = connection.prepareStatement("update triggered_data set status = 4, error_type = ?, error_details = ?, last_action = current_timestamp where id = ?");
        selectPhase1 = connection.prepareStatement("select * from triggered_data where status = 1");
        selectPhase2 = connection.prepareStatement("select * from triggered_data where status = 2 or (status = 4 and error_type = 2 and last_action < ?)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() {
        Object object = lock;
        synchronized (object) {
            try {
                connection = ConnectionPool.getInstance().requestConnection().getConnection();
                this.buildPreparedStatements();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
        }
    }

    private void updateStep2(String filename, int idTriggeredData, String action) throws SQLException {
        updatePhase2.setString(1, filename);
        updatePhase2.setString(2, action);
        updatePhase2.setInt(3, idTriggeredData);
        updatePhase2.execute();
        connection.commit();
    }

    private void notaStep2(int idData, int idTriggeredData) throws SQLException {
        String filename = salesDir + File.separator + idData + ".xml";
        Hashtable<String, Integer> hash = new Hashtable<String, Integer>();
        hash.put("id_order_key", new Integer(idData));
        Order o = RestLogic.getInstance().getOrderById(idData);
        if (o != null) {
            double total = RestLogic.getInstance().getTotal(o);
            Vector<SalesEntry> sales = RestLogic.getInstance().getSalesReport(hash, -1);
            String optionalAttributes = "";
            String username = "";
            User u = UsersLogic.getInstance().getUserById(o.getUser());
            if (u != null) {
                username = u.getLogin();
            }
            optionalAttributes = optionalAttributes + " location=\"" + this.location + "\"";
            optionalAttributes = optionalAttributes + " fallbackUser=\"" + this.fallbackUser + "\"";
            optionalAttributes = optionalAttributes + " idTable=\"" + o.getTable() + "\"";
            String tablename = "";
            Table t = RestLogic.getInstance().getTableById(o.getTable());
            if (t != null) {
                tablename = t.getLabel();
            }
            optionalAttributes = optionalAttributes + " tablename=\"" + tablename + "\"";
            optionalAttributes = optionalAttributes + " idUser=\"" + o.getUser() + "\"";
            optionalAttributes = optionalAttributes + " username=\"" + username + "\"";
            optionalAttributes = optionalAttributes + " f=\"" + o.isFiscal() + "\"";
            optionalAttributes = optionalAttributes + " orderIdentifier=\"" + RestLogic.getOrderIdentifier(u.getLogin(), o.getId()) + "\"";
            RestLogic.getInstance().exportSalesToXml(hash, sales, filename, total, o.getId(), o.getStopTime(), optionalAttributes);
        } else {
            Logger.logWarning(this, "Order deleted: " + idData);
        }
        this.updateStep2(filename, idTriggeredData, POST_ORDER);
    }

    private void partenerStep2(int idData, int idTriggeredData) throws SQLException {
        String filename = parteneriDir + File.separator + idData + ".xml";
        ClientLogic.getInstance().exportPartenerToXml(idData, filename);
        this.updateStep2(filename, idTriggeredData, POST_PARTNER);
    }

    private void productStep2(int idData, int idTriggeredData) throws SQLException {
        String filename = produseDir + File.separator + idData + ".xml";
        RestLogic.getInstance().exportProductToXml(idData, filename);
        this.updateStep2(filename, idTriggeredData, POST_PRODUCT);
    }

    private void materiePrimaStep2(int idData, int idTriggeredData) throws SQLException {
        String filename = materiePrimaDir + File.separator + idData + ".xml";
        RestLogic.getInstance().exportMateriePrimaToXml(idData, filename);
        this.updateStep2(filename, idTriggeredData, POST_PRODUCT);
    }

    private void retetaStep2(int idData, int idTriggeredData) throws SQLException {
        String filename = reteteDir + File.separator + idData + ".xml";
        RestLogic.getInstance().exportRetetaToXml(idData, filename);
        this.updateStep2(filename, idTriggeredData, POST_RETETA);
    }

    private void stockStep2(int idData, int idTriggeredData) throws SQLException {
        String filename = stocuriDir + File.separator + idData + ".xml";
        RestLogic.getInstance().exportStockToXml(idData, filename);
        this.updateStep2(filename, idTriggeredData, POST_STOCK);
    }

    private void nirStep2(int idData, int idTriggeredData) throws SQLException {
        String filename = niruriDir + File.separator + idData + ".xml";
        RestLogic.getInstance().exportNirToXml(idData, filename);
        this.updateStep2(filename, idTriggeredData, POST_NIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.reconnect();
        while (true) {
            boolean something = false;
            try {
                int idTriggeredData = -1;
                int tipD = 0;
                int idData = 0;
                ResultSet rs = selectPhase1.executeQuery();
                while (rs.next()) {
                    idTriggeredData = rs.getInt("id");
                    tipD = rs.getInt("what");
                    idData = rs.getInt("id_data");
                }
                rs.close();
                if (idTriggeredData > 0) {
                    something = true;
                    switch (tipD) {
                        case 1: {
                            this.notaStep2(idData, idTriggeredData);
                            break;
                        }
                        case 2: {
                            this.partenerStep2(idData, idTriggeredData);
                            break;
                        }
                        case 3: {
                            this.productStep2(idData, idTriggeredData);
                            break;
                        }
                        case 4: {
                            this.nirStep2(idData, idTriggeredData);
                            break;
                        }
                        case 5: {
                            this.stockStep2(idData, idTriggeredData);
                            break;
                        }
                        case 6: {
                            this.materiePrimaStep2(idData, idTriggeredData);
                            break;
                        }
                        case 7: {
                            this.retetaStep2(idData, idTriggeredData);
                        }
                    }
                }
                idTriggeredData = -1;
                tipD = 0;
                idData = 0;
                long retryIntervalForErrors = 10000L;
                Date d = DateUtils.addMillisToDate(new Date(), -retryIntervalForErrors);
                selectPhase2.setTimestamp(1, new Timestamp(d.getTime()));
                rs = selectPhase2.executeQuery();
                String xmlData = "";
                String action = "";
                while (rs.next()) {
                    something = true;
                    idTriggeredData = rs.getInt("id");
                    tipD = rs.getInt("what");
                    idData = rs.getInt("id_data");
                    xmlData = rs.getString("xml_data");
                    int errorType = rs.getInt("error_type");
                    String errorDetails = rs.getString("error_details");
                    Timestamp lastActionInfo = rs.getTimestamp("last_action");
                    action = rs.getString("post_action");
                    if (errorType > 0) {
                        Logger.logDebug(this, "Retrying message id=" + idTriggeredData + " errorType=" + errorType + " details=" + errorDetails + " lastAction=" + Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(lastActionInfo));
                    }
                    String encodedText = null;
                    String content = null;
                    try {
                        content = FileUtils.readFileToString(xmlData);
                        encodedText = URLEncoder.encode(content);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        updatePhase3ERROR.setInt(1, 1);
                        updatePhase3ERROR.setString(2, "File error while reading xml file \"" + xmlData + "\" from disk.");
                        updatePhase3ERROR.setInt(3, idTriggeredData);
                        updatePhase3ERROR.execute();
                        connection.commit();
                        Logger.logWarning(this, "Permanently dropping message with id=" + idTriggeredData);
                        continue;
                    }
                    String fullUrl = "http://" + this.serverIp + ":" + this.serverPort + "/datasyncserver/datasyncserver?action=" + action + "&xml=" + encodedText;
                    String reply = HttpUtils.postHttpPage(fullUrl);
                    if (reply != null) {
                        if (reply.startsWith("OK")) {
                            updatePhase3SENT.setInt(1, idTriggeredData);
                            updatePhase3SENT.execute();
                            connection.commit();
                            continue;
                        }
                        updatePhase3ERROR.setInt(1, 1);
                        updatePhase3ERROR.setString(2, "Server did not like posting");
                        updatePhase3ERROR.setInt(3, idTriggeredData);
                        updatePhase3ERROR.execute();
                        connection.commit();
                        continue;
                    }
                    updatePhase3ERROR.setInt(1, 2);
                    updatePhase3ERROR.setString(2, "Server down. Retrying");
                    updatePhase3ERROR.setInt(3, idTriggeredData);
                    updatePhase3ERROR.execute();
                    connection.commit();
                }
                rs.close();
                if (something) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
                Logger.logError((Object)this, th);
            }
        }
    }

    static {
        lock = new Object();
    }
}

