/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic.imports.ciel;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.gui.Validators;

public class CielPersJuridiceImporter {
    private static CielPersJuridiceImporter instance;

    public static synchronized CielPersJuridiceImporter getInstance() {
        if (instance == null) {
            instance = new CielPersJuridiceImporter();
        }
        return instance;
    }

    private CielPersJuridiceImporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importPersoaneJuridice(String inputFile) {
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(inputFile));
            String line = reader.readLine();
            int lineNumber = 1;
            while (line != null) {
                try {
                    Vector fields = Utils.splitStringKeepStructure(line, '|', ' ');
                    if (fields.size() >= 31) {
                        ClientPersFizica cpf;
                        String nume = (String)fields.get(1);
                        String isClientS = (String)fields.get(3);
                        String isFurnizorS = (String)fields.get(4);
                        String cui = (String)fields.get(6);
                        String j = (String)fields.get(7);
                        String adresa = (String)fields.get(8);
                        String oras = (String)fields.get(9);
                        int idTara = 1;
                        String codPostal = (String)fields.get(11);
                        String fix = (String)fields.get(12);
                        String fax = (String)fields.get(13);
                        String email = (String)fields.get(14);
                        String website = (String)fields.get(15);
                        String banca = (String)fields.get(16);
                        String iban = (String)fields.get(17);
                        String numeDelegat = (String)fields.get(18);
                        String prenumeDelegat = (String)fields.get(19);
                        String zileScadenta = (String)fields.get(20);
                        String credit = (String)fields.get(21);
                        String numeAgent = (String)fields.get(22);
                        String observatii = (String)fields.get(30);
                        String risk = "";
                        if (Validators.correctString(nume) && Validators.correctString(cui)) {
                            int idAgent = -1;
                            User u = UsersLogic.getInstance().getUserByLogin(numeAgent);
                            if (u != null) {
                                idAgent = u.getId();
                            } else {
                                Logger.logWarning(this, "Linia: " + lineNumber + " agent \"" + numeAgent + "\" inexistent");
                            }
                            int nrZileScadenta = 0;
                            if (Validators.correctInteger(zileScadenta)) {
                                nrZileScadenta = Integer.parseInt(zileScadenta);
                            } else {
                                Logger.logWarning(this, "Linia: " + lineNumber + " scadenta is not a number");
                            }
                            double creditF = 0.0;
                            if (Validators.correctDouble(credit)) {
                                creditF = Utils.parseDouble(credit);
                            } else {
                                Logger.logWarning(this, "Linia: " + lineNumber + " credit is not a number");
                            }
                            ClientPersJuridica cpj = null;
                            Vector cpjs = ClientLogic.getInstance().getPersJuridiceByCodNoCommit(cui);
                            if (cpjs.size() > 0) {
                                cpj = (ClientPersJuridica)cpjs.get(0);
                                System.out.println("Linia " + lineNumber + " : CLIENT DEJA EXISTENT");
                            } else {
                                boolean isFurnizor = isFurnizorS.equalsIgnoreCase("-1");
                                boolean isClient = isClientS.equalsIgnoreCase("-1");
                                String groups = "";
                                if (isFurnizor) {
                                    groups = groups + "1,";
                                }
                                if (isClient) {
                                    groups = groups + "2,";
                                }
                                int idClientPersJuridica = ClientLogic.getInstance().addPersJuridicaNoCommit(nume, cui, j, codPostal + " " + adresa, idTara, oras, banca, iban, "", fix, fax, "", email, website, numeAgent, 0.0, idAgent, observatii, nrZileScadenta, creditF, groups, "", "", "", "", "");
                                cpj = (ClientPersJuridica)ClientLogic.getInstance().getClientByIdNoCommit(idClientPersJuridica);
                                if (Validators.correctString(numeDelegat) || Validators.correctString(prenumeDelegat)) {
                                    ClientLogic.getInstance().addPersFizicaNoCommit(numeDelegat, prenumeDelegat, "", 1, "", -1, -1, cpj.getIdPersJuridica(), "", "", "", "", "", "", "", "", new Date(), null, new Date(), "");
                                }
                            }
                        } else if (Validators.correctString(nume) && (cpf = ClientLogic.getInstance().getPersFizicaByNameNoCommit(nume)) == null) {
                            ClientLogic.getInstance().addPersFizicaNoCommit(nume, "", adresa, idTara, oras, -1, -1, -1, fix, fax, "", email, website, observatii, risk, "", new Date(), null, new Date(), "");
                        }
                    }
                    ConnectionPool.getInstance().commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                    try {
                        ConnectionPool.getInstance().rollBack();
                    }
                    catch (SQLException e1) {
                        Logger.logException(this, (Exception)e1);
                    }
                }
                catch (NoSuchElementException e) {
                }
                finally {
                    ConnectionPool.getInstance().releaseConnection();
                }
                line = reader.readLine();
                ++lineNumber;
            }
            ClientLogic.getInstance().notifyListeners(42);
            ClientLogic.getInstance().notifyListeners(41);
            ClientLogic.getInstance().notifyListeners(11);
        }
        catch (IOException e) {
            Logger.logException("CielPersJuridiceImporter", (Exception)e);
        }
    }
}

