/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic.imports.ciel;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.units.UnitsLogic;

public class CielProductsImporter {
    private static final int ID_TVA = 1;
    private static CielProductsImporter instance;

    public static synchronized CielProductsImporter getInstance() {
        if (instance == null) {
            instance = new CielProductsImporter();
        }
        return instance;
    }

    private CielProductsImporter() {
    }

    private int importSectie(String sectie) {
        return NomeclaturaLogic.getInstance().addSectie(sectie, "", "");
    }

    private int importCategorie(String categorie, int idSectie, int idTva) {
        Categorie cat = NomeclaturaLogic.getInstance().getCategoryByName(categorie);
        if (cat != null) {
            return cat.getId();
        }
        String codDepartament = idSectie + "";
        int idCategorie = NomeclaturaLogic.getInstance().newCategory(idSectie, categorie, Color.WHITE.getRGB(), codDepartament, idTva, false, 0.0);
        return idCategorie;
    }

    public void importCategorii(String file, int idSectie, int idTva) {
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                StringTokenizer token = new StringTokenizer(line, "|", true);
                String categorie = token.nextToken();
                String sectie = null;
                try {
                    sectie = token.nextToken();
                    token.nextToken();
                }
                catch (NoSuchElementException e) {
                    Logger.logException(this, (Exception)e);
                }
                int idS = idSectie;
                if (Validators.correctString(sectie)) {
                    idS = this.importSectie(sectie);
                }
                this.importCategorie(categorie, idS, 1);
            }
        }
        catch (FileNotFoundException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private int importProdus(int idCategorie, String label, double pret, String codBare, int idUnitateMasura) {
        int code = NomeclaturaLogic.getInstance().getNextProductCode();
        Vector<String> barcodes = new Vector<String>();
        barcodes.add(codBare);
        int idProduct = StockLogic.getInstance().addProdusFinit(label, idUnitateMasura, idCategorie, code, 0.0, 0.0, pret, false, null, true, barcodes);
        return idProduct;
    }

    public void importProduse(String file) {
        int idSectie = -1;
        Vector<Sectie> sectii = NomeclaturaLogic.getInstance().getAllSectii();
        if (sectii.size() > 0) {
            Sectie s = sectii.get(0);
            idSectie = s.getId();
        } else {
            idSectie = this.importSectie("Sectie1");
        }
        String um = "buc";
        Unit u = UnitsLogic.getInstance().getUnitByName(um);
        if (u == null) {
            UnitsLogic.getInstance().addUnit(um);
        }
        u = UnitsLogic.getInstance().getUnitByName(um);
        int idUm = u.getId();
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                Vector fields = Utils.splitStringKeepStructure(line, '|', ' ');
                if (fields.size() >= 17) {
                    String cod = (String)fields.get(0);
                    String denumire = (String)fields.get(1);
                    String categorie = (String)fields.get(2);
                    String pretVz = (String)fields.get(16);
                    System.out.print("cod : \"" + cod + "\" denumire : \"" + denumire + "\" categorie : \"" + categorie + "\" pretVz : \"" + pretVz + "\"");
                    if (Validators.correctString(cod) && Validators.correctString(denumire) && Validators.correctString(categorie) && Validators.correctDouble(pretVz)) {
                        int idCategorie = this.importCategorie(categorie, idSectie, 1);
                        double pret = Utils.parseDouble(pretVz);
                        this.importProdus(idCategorie, denumire, pret, cod, idUm);
                        System.out.println(" IMPORTAT CORECT");
                    } else {
                        System.out.println(" DATE INCORECTE");
                    }
                } else {
                    System.out.println(" DATE INCORECTE");
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            Logger.logException("CielProductsImporter", (Exception)e);
        }
    }
}

