/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.logic.winmentor;

import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import org.ini4j.Wini;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.contabilitate.ContaLogic;
import ro.atreides.contabilitate.Factura;
import ro.atreides.contabilitate.FacturiEntry;
import ro.atreides.contabilitate.Nir;
import ro.atreides.contabilitate.NirEntryFull;
import ro.atreides.contabilitate.export.ContaExportBean;
import ro.atreides.contabilitate.export.ContaGenericExport;
import ro.atreides.facturi.FacturiEmiseView;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.SimpleMonetarView;
import ro.atreides.restaurant.base.reports.SalesEntry;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.BonConsum;
import ro.atreides.stocks.BonConsumItem;
import ro.atreides.stocks.Corectie;
import ro.atreides.stocks.FisaMagazieEntry;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.ModificarePret;
import ro.atreides.stocks.RaportGestiuneEntry;
import ro.atreides.stocks.SaleDescarcareBean;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.StockTransfer;
import ro.atreides.stocks.StockTransferItem;
import ro.atreides.utils.AtrFloat;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.ContaExportMapping;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ProductPriceInterface;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.documente.TipDocument;
import ro.atreides.utils.facturi.FacturaItemView;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.xcombo.XComboBoxIndex;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.registre.RegistreLogic;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.units.UnitsLogic;

public class WinmentorExportLogic {
    private static WinmentorExportLogic instance;

    public static synchronized WinmentorExportLogic getInstance() {
        if (instance == null) {
            instance = new WinmentorExportLogic();
        }
        return instance;
    }

    private WinmentorExportLogic() {
    }

    public String exportDateWinMentor(Component parent, ProductPriceInterface productInterface) {
        ContaExportBean exportBean = ContaGenericExport.exportDateConta(parent);
        String destinationPath = exportBean.getDestinationPath();
        int anStart = exportBean.getAnStart();
        int lunaStart = exportBean.getLunaStart();
        Date d1 = exportBean.getD1();
        Date d2 = exportBean.getD2();
        this.exportFurnizori(destinationPath);
        Map<String, String> coduriProduse = Collections.synchronizedMap(new LinkedHashMap());
        String niruriFacturiFile = destinationPath + File.separator + "facturi_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
        this.exportNiruriFacturi(niruriFacturiFile, d1, d2, anStart, lunaStart, coduriProduse);
        String niruriBonFiscalFile = destinationPath + File.separator + "bonurifiscale_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
        this.exportBonuriFiscaleAchizitie(niruriBonFiscalFile, d1, d2, anStart, lunaStart, coduriProduse);
        String niruriBonAchizitieFile = destinationPath + File.separator + "bonuriachizitie_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
        this.exportBorderouAchizitie(niruriBonAchizitieFile, d1, d2, anStart, lunaStart, coduriProduse);
        String monetarFile = destinationPath + File.separator + "monetar_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
        this.exportMonetar(monetarFile, d1, d2, anStart, lunaStart, null, destinationPath);
        String consumuriFile = destinationPath + File.separator + "bonconsum_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
        this.exportConsumuri(consumuriFile, d1, d2, anStart, lunaStart);
        String transferuriFile = destinationPath + File.separator + "transfer_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
        this.exportTransferuri(transferuriFile, d1, d2, anStart, lunaStart);
        String predareFile = destinationPath + File.separator + "notepredare_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
        this.exportNotePredare(predareFile, d1, d2, anStart, lunaStart);
        String modifPretFile = destinationPath + File.separator + "modificaripret_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
        this.exportModificariPret(modifPretFile, d1, d2, anStart, lunaStart);
        String marirestocFile = destinationPath + File.separator + "marirestoc_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
        this.exportDiffInventarGeneric(marirestocFile, d1, d2, anStart, lunaStart, new MarireDiminuareInterf(){

            @Override
            public boolean accept(FisaMagazieEntry fis) {
                return Utils.isValueGreaterThanZero(-fis.getIesita());
            }

            @Override
            public double getRealQty(FisaMagazieEntry fis) {
                return -fis.getIesita();
            }

            @Override
            public String getTipDocument() {
                return "MARIRE DE STOC";
            }

            @Override
            public String getTotalText() {
                return "TotalMariri";
            }

            @Override
            public String getSerieCarnet() {
                return "MS";
            }
        });
        String diminuarestocFile = destinationPath + File.separator + "diminuarestoc_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
        this.exportDiffInventarGeneric(diminuarestocFile, d1, d2, anStart, lunaStart, new MarireDiminuareInterf(){

            @Override
            public boolean accept(FisaMagazieEntry fis) {
                return Utils.isValueGreaterThanZero(fis.getIesita());
            }

            @Override
            public double getRealQty(FisaMagazieEntry fis) {
                return fis.getIesita();
            }

            @Override
            public String getTipDocument() {
                return "DIMINUARE DE STOC";
            }

            @Override
            public String getTotalText() {
                return "TotalDiminuari";
            }

            @Override
            public String getSerieCarnet() {
                return "DS";
            }
        });
        this.exportArticole(destinationPath, coduriProduse);
        return destinationPath;
    }

    private void exportNiruriFacturi(String niruriFile, Date start, Date stop, int an, int luna, Map<String, String> coduriProduse) {
        this.exportNiruriGeneric(niruriFile, start, stop, an, luna, ContaLogic.TIP_DOCUMENT_NIR.Factura, coduriProduse);
    }

    private void exportBonuriFiscaleAchizitie(String niruriFile, Date start, Date stop, int an, int luna, Map<String, String> coduriProduse) {
        this.exportNiruriGeneric(niruriFile, start, stop, an, luna, ContaLogic.TIP_DOCUMENT_NIR.BonFiscal, coduriProduse);
    }

    private void exportBorderouAchizitie(String niruriFile, Date start, Date stop, int an, int luna, Map<String, String> coduriProduse) {
        this.exportNiruriGeneric(niruriFile, start, stop, an, luna, ContaLogic.TIP_DOCUMENT_NIR.BorderouAchizitii, coduriProduse);
    }

    private String getTipDocumentStringByTipFactura(ContaLogic.TIP_DOCUMENT_NIR tip) {
        switch (tip) {
            case Factura: {
                return "FACTURA INTRARE";
            }
            case BonFiscal: {
                return "BON FISCAL INTRARE";
            }
            case BorderouAchizitii: {
                return "BON ACHIZITIE";
            }
        }
        return "";
    }

    private String getTotalTipDocumentStringByTipFactura(ContaLogic.TIP_DOCUMENT_NIR tip) {
        switch (tip) {
            case Factura: {
                return "TotalFacturi";
            }
            case BonFiscal: {
                return "TotalBonuri";
            }
            case BorderouAchizitii: {
                return "TotalBonuri";
            }
        }
        return "";
    }

    private String getItemTitleStringByTipFactura(ContaLogic.TIP_DOCUMENT_NIR tip) {
        switch (tip) {
            case Factura: {
                return "Factura";
            }
            case BonFiscal: {
                return "Bon";
            }
            case BorderouAchizitii: {
                return "Bon";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportNiruriGeneric(String niruriFile, Date start, Date stop, int an, int luna, ContaLogic.TIP_DOCUMENT_NIR tip_document_nir, Map<String, String> coduriProduse) {
        try {
            Vector clientTvaLaIncasare = ClientLogic.getInstance().getPartnersInGroupNoCommit("pers_juridice_groups_tvaincasare", -1);
            Vector clientPlatitorTva = ClientLogic.getInstance().getPartnersInGroupNoCommit("pers_juridice_groups_platitor_tva", -1);
            Hashtable<String, Object> criteria = new Hashtable<String, Object>();
            criteria.put("facturi_furnizor_key", -1);
            criteria.put(Constants.START_KEY, start);
            criteria.put(Constants.STOP_KEY, stop);
            criteria.put("Tip Factura", (Object)tip_document_nir);
            ContaLogic logic = ContaLogic.getInstance();
            Vector<FacturiEntry> facturi = logic.getFacturiNoCommit(criteria, 2);
            this.exportNiruriGeneric(niruriFile, start, stop, an, luna, tip_document_nir, coduriProduse, facturi, clientTvaLaIncasare, clientPlatitorTva);
            ConnectionPool.getInstance().commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, e);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    private void exportNiruriGeneric(String niruriFile, Date start, Date stop, int an, int luna, ContaLogic.TIP_DOCUMENT_NIR tip_document_nir, Map<String, String> coduriProduse, Vector<FacturiEntry> facturi, Vector<Client> clientTvaLaIncasare, Vector<Client> clientPlatitorTva) throws SQLException, IOException {
        ContaLogic logic = ContaLogic.getInstance();
        StringBuffer text = new StringBuffer();
        String lineEnd = "\r\n";
        boolean useGenerice = VpConfig.getInstance().contaExportUseCoduriGenerice;
        int i = 1;
        for (FacturiEntry facturiEntry : facturi) {
            if (!facturiEntry.getTipFactura().equals((Object)tip_document_nir)) continue;
            Factura f = logic.getFacturaById(facturiEntry.getIdFactura());
            Nir n = logic.getNirByFacturaId(f.getId());
            Vector<NirEntryFull> newData = logic.getDataForNirNoCommit(n.getId());
            text.append(lineEnd + lineEnd + lineEnd + lineEnd + "[" + this.getItemTitleStringByTipFactura(tip_document_nir) + "_" + i + "]" + lineEnd);
            int maxChars = 9;
            String serie = f.getSerieFactura();
            serie = serie.replaceAll("[^\\d.]", "");
            if (serie.length() > maxChars) {
                serie = serie.substring(serie.length() - maxChars, serie.length());
            }
            text.append("NrDoc=" + serie + lineEnd);
            text.append("Data=" + Formatters.DOTTED_DATE_FORMAT_RO.format(f.getDateadd()) + lineEnd + lineEnd);
            int idFurnizor = f.getIdFurnizor();
            ClientPersJuridica cpj = (ClientPersJuridica)ClientLogic.getInstance().getClientByIdNoCommit(idFurnizor);
            String stripped = this.getCorrectPartenerName(cpj, clientPlatitorTva);
            text.append("CodFurnizor=" + stripped + lineEnd);
            if (tip_document_nir.equals((Object)ContaLogic.TIP_DOCUMENT_NIR.Factura)) {
                boolean partenerCuTvaLaIncasare = clientTvaLaIncasare.contains(cpj);
                text.append("TVAINCASARE=" + (partenerCuTvaLaIncasare ? "D" : "N") + lineEnd);
                text.append("PRORATA=D" + lineEnd);
                text.append("Scadenta=" + Formatters.DOTTED_DATE_FORMAT_RO.format(f.getDateadd()) + lineEnd);
                text.append("Majorari=0" + lineEnd);
            }
            text.append("TotalArticole=" + newData.size() + lineEnd);
            text.append("Observatii=Dever" + lineEnd);
            text.append("[Items_" + i + "]" + lineEnd);
            int j = 1;
            for (NirEntryFull nirEntryFull : newData) {
                Magazie m = StockLogic.getInstance().getMagazieByIdNoCommit(nirEntryFull.getIdMagazie());
                String codMagazie = m.getContMateriiPrime();
                String prefixMarfa = m.getContMarfuri();
                String prefixMP = m.getContTvaNeexigibil();
                String codP1 = "";
                String um = "Buc";
                String denumireProdus = "";
                if (!useGenerice) {
                    ContaExportMapping mapping = null;
                    if (StockLogic.getInstance().isProdusFinitNoCommit(nirEntryFull.getIngredientId())) {
                        Product p = StockLogic.getInstance().getProductForStockNoCommit(nirEntryFull.getIngredientId());
                        mapping = this.getMappingForIdProductWithAdding(p.getId(), nirEntryFull.getDenumireProdus());
                    } else {
                        mapping = this.getMappingForStockIdWithAdding(nirEntryFull.getIngredientId(), nirEntryFull.getDenumireProdus());
                    }
                    if (mapping == null) {
                        ConnectionPool.getInstance().rollBack();
                        return;
                    }
                    codP1 = mapping.getExternalCode();
                    um = nirEntryFull.getUm();
                    denumireProdus = nirEntryFull.getDenumireProdus();
                } else {
                    if (StockLogic.getInstance().isProdusFinitNoCommit(nirEntryFull.getIngredientId())) {
                        codP1 = prefixMarfa;
                        denumireProdus = "Marfa generic ";
                    } else {
                        codP1 = prefixMP;
                        denumireProdus = "Materie prima generic ";
                    }
                    int idTva = nirEntryFull.getIdTva();
                    Tva tva = TvaLogic.getInstance().getTvaByIdNoCommit(idTva);
                    double d = FloatUtils.roundDouble(tva.getCota(), 2);
                    int cotaInt = (int)Math.ceil(d * 100.0);
                    codP1 = codP1 + cotaInt;
                    denumireProdus = denumireProdus + cotaInt;
                }
                if (!useGenerice) {
                    coduriProduse.put(codP1, denumireProdus);
                }
                double qty = nirEntryFull.getCant();
                double ppuc = nirEntryFull.getPpuc();
                String pretVz = "";
                if (StockLogic.getInstance().isProdusFinitNoCommit(nirEntryFull.getIngredientId()) && !nirEntryFull.isFacturaOnly()) {
                    pretVz = Utils.getString4DecimalsNoTrunc(nirEntryFull.getPpuvtva());
                }
                if (tip_document_nir.equals((Object)ContaLogic.TIP_DOCUMENT_NIR.BonFiscal)) {
                    int idTvaFurnizor = nirEntryFull.getIdTva();
                    Tva tva = TvaLogic.getInstance().getTvaByIdNoCommit(idTvaFurnizor);
                    double cota = tva.getCota();
                    cota = FloatUtils.roundDoubleUp(cota, 2);
                    ppuc *= 1.0 + cota;
                }
                String line = "Item_" + j + "=" + codP1 + ";" + um + ";" + Utils.getString5DecimalsNoTrunc(qty) + ";" + Utils.getString4DecimalsNoTrunc(ppuc) + ";" + codMagazie + ";;;" + pretVz + ";" + lineEnd;
                text.append(line);
                if (tip_document_nir.equals((Object)ContaLogic.TIP_DOCUMENT_NIR.Factura) || tip_document_nir.equals((Object)ContaLogic.TIP_DOCUMENT_NIR.BonFiscal)) {
                    text.append("Item_" + j + "_TVA=" + Utils.getString6DecimalsNoTrunc(nirEntryFull.getTvaFurnizorTotal()) + lineEnd);
                }
                ++j;
            }
            ++i;
        }
        if (i > 1) {
            text.append("[InfoPachet]" + lineEnd);
            text.append("AnLucru=" + an + lineEnd);
            text.append("LunaLucru=" + luna + lineEnd);
            text.append("TipDocument=" + this.getTipDocumentStringByTipFactura(tip_document_nir) + lineEnd);
            text.append(this.getTotalTipDocumentStringByTipFactura(tip_document_nir) + "=" + (i - 1) + lineEnd + lineEnd);
            FileUtils.writeTextToFile(niruriFile, text.toString());
        }
    }

    public String exportDateWinMentorSales(Component parent, Date start, Date stop, Vector<SalesEntry> sales) {
        ContaExportBean exportBean = ContaGenericExport.exportDateConta(parent, start, stop);
        int anStart = exportBean.getAnStart();
        int lunaStart = exportBean.getLunaStart();
        String destinationPath = Config.getInstance().getString("contaExportDir", "export");
        destinationPath = new File(destinationPath).getAbsolutePath();
        String monetareFile = destinationPath + File.separator + "monetare_" + Formatters.DATE_FORMAT_RO.format(start) + "__" + Formatters.DATE_FORMAT_RO.format(stop) + ".txt";
        this.exportMonetar(monetareFile, start, stop, anStart, lunaStart, sales, destinationPath);
        return destinationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportDateWinMentorFacturiReport(Component parent, Vector<FacturiEntry> facturi) {
        ContaExportBean exportBean = ContaGenericExport.exportDateConta(parent);
        String destinationPath = exportBean.getDestinationPath();
        int anStart = exportBean.getAnStart();
        int lunaStart = exportBean.getLunaStart();
        Date d1 = exportBean.getD1();
        Date d2 = exportBean.getD2();
        this.exportFurnizori(destinationPath);
        Map<String, String> coduriProduse = Collections.synchronizedMap(new LinkedHashMap());
        try {
            Vector clientTvaLaIncasare = ClientLogic.getInstance().getPartnersInGroupNoCommit("pers_juridice_groups_tvaincasare", -1);
            Vector clientPlatitorTva = ClientLogic.getInstance().getPartnersInGroupNoCommit("pers_juridice_groups_platitor_tva", -1);
            String niruriFacturiFile = destinationPath + File.separator + "facturi_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
            this.exportNiruriGeneric(niruriFacturiFile, d1, d2, anStart, lunaStart, ContaLogic.TIP_DOCUMENT_NIR.Factura, coduriProduse, facturi, clientTvaLaIncasare, clientPlatitorTva);
            String niruriBonFiscalFile = destinationPath + File.separator + "bonurifiscale_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
            this.exportNiruriGeneric(niruriBonFiscalFile, d1, d2, anStart, lunaStart, ContaLogic.TIP_DOCUMENT_NIR.BonFiscal, coduriProduse, facturi, clientTvaLaIncasare, clientPlatitorTva);
            String niruriBonAchizitieFile = destinationPath + File.separator + "bonuriachizitie_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
            this.exportNiruriGeneric(niruriBonAchizitieFile, d1, d2, anStart, lunaStart, ContaLogic.TIP_DOCUMENT_NIR.BorderouAchizitii, coduriProduse, facturi, clientTvaLaIncasare, clientPlatitorTva);
            this.exportArticole(destinationPath, coduriProduse);
            ConnectionPool.getInstance().commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
        return destinationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportArticole(String destinationPath, Map<String, String> coduriProduse) {
        StringBuffer result = new StringBuffer();
        try {
            Vector<ContaExportMapping> mappings = RestLogic.getInstance().getAllContaExportMapping();
            for (ContaExportMapping mapping : mappings) {
                XComboBoxIndex p;
                int idProduct = mapping.getIdProduct();
                int idStock = mapping.getIdStock();
                if (idProduct > 0) {
                    p = NomeclaturaLogic.getInstance().getProductByIdNoCommit(idProduct);
                    Categorie cat = NomeclaturaLogic.getInstance().getCategoryByIdNoCommit(((Product)p).getIdCategorie());
                    Tva tva = TvaLogic.getInstance().getTvaByIdNoCommit(cat.getIdTva());
                    if (p == null) continue;
                    double tva1 = FloatUtils.roundDoubleUp(tva.getCota(), 2) * 100.0;
                    this.addArticol(result, mapping.getExternalCode(), ((Product)p).getName(), tva1);
                    continue;
                }
                if (idStock <= 0 || (p = StockLogic.getInstance().getStockByIdNoCommit(idStock)) == null) continue;
                this.addArticol(result, mapping.getExternalCode(), ((Stock)p).getLabel(), null);
            }
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, e);
            }
        }
        finally {
            try {
                ConnectionPool.getInstance().commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            ConnectionPool.getInstance().releaseConnection();
        }
        for (String codP : coduriProduse.keySet()) {
            String denumire = coduriProduse.get(codP);
            this.addArticol(result, codP, denumire, null);
        }
        try {
            FileUtils.writeTextToFile(destinationPath + File.separator + "articole.txt", result.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private void addArticol(StringBuffer result, String id, String label, Double tva) {
        result.append("[ArticoleNoi_" + id + "]\n");
        result.append("Denumire=" + label + "\n");
        result.append("Serviciu=N \n");
        result.append("ContServiciu=\n");
        if (tva != null) {
            result.append("ProcTVA=" + Utils.getStringXDecimals(tva, 0) + "\n");
        }
        result.append("\n");
    }

    private String getCorrectPartenerName(ClientPersJuridica cpj, Vector<Client> clientPlatitorTva) {
        String cui = cpj.getCui();
        String stripped = cui.replaceAll("[^0-9]", "");
        if (clientPlatitorTva.contains(cpj)) {
            stripped = "RO" + stripped;
        }
        return stripped;
    }

    private void exportFurnizori(String destination) {
        StringBuffer result = new StringBuffer();
        Vector<Client> furnizori = ContaLogic.getInstance().getFurnizori(-1);
        Vector clientPlatitorTva = ClientLogic.getInstance().getPartnersInGroup("pers_juridice_groups_platitor_tva", -1);
        for (Client client : furnizori) {
            if (!(client instanceof ClientPersJuridica)) continue;
            ClientPersJuridica cpj = (ClientPersJuridica)client;
            String stripped = this.getCorrectPartenerName(cpj, clientPlatitorTva);
            result.append("[ParteneriNoi_" + stripped + "]\n");
            result.append("Denumire=" + cpj.getCompanyName() + "\n");
            result.append("Tara=Romania\n");
            result.append("Localitate=" + cpj.getCity() + "\n");
            result.append("Judet= \n");
            result.append("Adresa=" + cpj.getAddressAsString(';') + "\n");
            result.append("Sediu=" + cpj.getAddressAsString(';') + "\n");
            result.append("Telefon=" + cpj.getTelefoaneShort(";") + "\n");
            result.append("Email=" + cpj.getEmail() + ";" + cpj.getEmail() + "\n");
            result.append("\n");
        }
        try {
            FileUtils.writeTextToFile(destination + File.separator + "partner.txt", result.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public String exportDateWinMentorFacturiEmise(Component parent, Vector<FacturiEmiseView> facturi) {
        ContaExportBean exportBean = ContaGenericExport.exportDateConta(parent);
        String destinationPath = null;
        if (exportBean != null) {
            destinationPath = exportBean.getDestinationPath();
            int anStart = exportBean.getAnStart();
            int lunaStart = exportBean.getLunaStart();
            Date d1 = exportBean.getD1();
            Date d2 = exportBean.getD2();
            String facturiEmiseFile = destinationPath + File.separator + "facturiemise_" + Formatters.DATE_FORMAT_RO.format(d1) + "__" + Formatters.DATE_FORMAT_RO.format(d2) + ".txt";
            this.exportFacturiEmise(facturiEmiseFile, d1, d2, anStart, lunaStart, facturi);
        }
        return destinationPath;
    }

    private void exportFacturiEmise(String npFile, Date start, Date stop, int an, int luna, Vector<FacturiEmiseView> facturi) {
        try {
            FileUtils.writeTextToFile(npFile, "");
            Wini ini = new Wini(new File(npFile));
            ini.put("InfoPachet", "AnLucru", (Object)(an + ""));
            ini.put("InfoPachet", "LunaLucru", (Object)(luna + ""));
            ini.put("InfoPachet", "TipDocument", (Object)"FACTURA IESIRE");
            if (facturi != null) {
                int numarFacturi = facturi.size();
                ini.put("InfoPachet", "TotalFacturi", (Object)numarFacturi);
                int i = 1;
                for (FacturiEmiseView fev : facturi) {
                    String sectionName = "Factura_" + i;
                    ini.put(sectionName, "NrDoc", (Object)fev.getSerieNumar());
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.YYYY");
                    ini.put(sectionName, "Data", (Object)simpleDateFormat.format(fev.getData()));
                    ini.put(sectionName, "CodClient", (Object)fev.getIdClient());
                    ini.put(sectionName, "TVAINCASARE", (Object)"");
                    ini.put(sectionName, "Scadenta", (Object)simpleDateFormat.format(fev.getScadenta()));
                    ini.put(sectionName, "Majorari", (Object)"");
                    ini.put(sectionName, "Observatii", (Object)"Dever");
                    ini.put(sectionName, "Locatie", (Object)"");
                    ini.put(sectionName, "Discount", (Object)"");
                    Vector facturiItems = FacturiLogic.getInstance().getFacturiItems(fev.getIdFactura());
                    ini.put(sectionName, "TotalArticole", (Object)facturiItems.size());
                    ini.put(sectionName, "Operat", (Object)"d");
                    String itemName = "Items_" + i;
                    int j = 1;
                    for (FacturaItemView fi : facturiItems) {
                        ini.put(itemName, "Item_" + j, (Object)(fi.getProdus() + ";LEI;" + Utils.getString5DecimalsNoTrunc(fi.getCantitate()) + ";" + Math.round(fi.getPpuCuTva() * 1000.0)));
                        ini.put(itemName, "Item_" + j + "_TVA", (Object)fi.getCotaTva());
                        ++j;
                    }
                    ++i;
                }
            }
            ini.store();
            String content = FileUtils.readFileToString(npFile);
            content = content.replace(" = ", "=");
            FileUtils.writeTextToFile(npFile, content);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportNotePredare(String npFile, Date start, Date stop, int an, int luna) {
        try {
            FileUtils.writeTextToFile(npFile, "");
            Wini ini = new Wini(new File(npFile));
            ini.put("InfoPachet", "AnLucru", (Object)(an + ""));
            ini.put("InfoPachet", "LunaLucru", (Object)(luna + ""));
            ini.put("InfoPachet", "TipDocument", (Object)"NOTA PREDARE");
            Vector<Date> zile = DateUtils.getDaysInPerioada(start, stop);
            int i = 1;
            for (Date date : zile) {
                Date startDay = DateUtils.getStartOfDay(date);
                Date endDay = DateUtils.getEndOfDay(date);
                Vector<Magazie> magazii = StockLogic.getInstance().getMagazii();
                Iterator<Magazie> i$ = magazii.iterator();
                while (i$.hasNext()) {
                    Vector<SaleDescarcareBean> allNoteForMagazie;
                    String magaziiExcluse = VpConfig.getInstance().winmentorMagaziiExcluse;
                    Magazie magazie = i$.next();
                    if (magaziiExcluse.contains(magazie.getLabel()) || (allNoteForMagazie = StockLogic.getInstance().getValDescarcataForSaleNoCommit(new Timestamp(startDay.getTime()), new Timestamp(endDay.getTime()), magazie.getId())).size() <= 0) continue;
                    int nrDoc = RegistreLogic.getInstance().getNewNumberForRegistruNoCommit(RegistreConstants.NOTA_PREDARE.key, RegistreConstants.NOTA_PREDARE.nume, true);
                    String numeNota = "Nota_" + i;
                    ini.put(numeNota, "NrDoc", (Object)(nrDoc + ""));
                    ini.put(numeNota, "Data", (Object)Formatters.DOTTED_DATE_FORMAT_RO.format(date));
                    ini.put(numeNota, "Gestsursa", (Object)magazie);
                    String numeItem = "Items_" + i;
                    int j = 1;
                    for (SaleDescarcareBean bean : allNoteForMagazie) {
                        int idProduct = bean.getIdProduct();
                        ContaExportMapping mapping = RestLogic.getInstance().getContaExportMappingForIdProduct(idProduct);
                        Double quantity = bean.getQuantity();
                        double pretUnitarProductie = bean.getValDescarcarePa() / quantity;
                        String line = mapping.getExternalCode() + ";BUC;" + Utils.getString5DecimalsNoTrunc(quantity) + ";" + Utils.getString4DecimalsNoTrunc(pretUnitarProductie) + ";" + magazie;
                        ini.put(numeItem, "Item_" + j, (Object)line);
                        ++j;
                    }
                    ini.put(numeNota, "TotalArticole", (Object)allNoteForMagazie.size());
                    ini.put(numeNota, "Observatii", (Object)"Dever");
                    ++i;
                }
            }
            ini.put("InfoPachet", "TotalNote", (Object)(i - 1));
            ini.store();
            String content = FileUtils.readFileToString(npFile);
            content = content.replace(" = ", "=");
            FileUtils.writeTextToFile(npFile, content);
            ConnectionPool.getInstance().commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, e);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    private ContaExportMapping getMappingForIdProductWithAdding(int idProduct, String productName) throws SQLException {
        ContaExportMapping mapping = RestLogic.getInstance().getContaExportMappingForIdProduct(idProduct);
        while (mapping == null) {
            if (VpConfig.getInstance().contaExportUseCoduriExterne) {
                DialogUtils.errorDialog(null, "Nu am gasit codul extern pentru produsul : " + productName + ", id=" + idProduct, LangRoAll.nuPotContinua);
                if (!DialogUtils.confirmDialog(null, "Introducem ACUM codul extern din Mentor", LangRoAll.confirmare)) break;
                String codExtern = DialogUtils.inputDialog(null, "", "Introduceti codul extern !");
                if (Validators.correctString(codExtern)) {
                    RestLogic.getInstance().addContaExportMapping(codExtern, idProduct, -1);
                }
            } else {
                RestLogic.getInstance().addContaExportMapping("P" + idProduct, idProduct, -1);
            }
            mapping = RestLogic.getInstance().getContaExportMappingForIdProduct(idProduct);
        }
        return mapping;
    }

    private ContaExportMapping getMappingForStockIdWithAdding(int idStoc, String stocName) throws SQLException {
        ContaExportMapping mapping = RestLogic.getInstance().getContaExportMappingForIdStock(idStoc);
        while (mapping == null) {
            if (VpConfig.getInstance().contaExportUseCoduriExterne) {
                DialogUtils.errorDialog(null, "Nu am gasit codul extern pentru stoc : " + stocName + ", id " + idStoc, LangRoAll.nuPotContinua);
                if (!DialogUtils.confirmDialog(null, "Introducem ACUM codul extern din Mentor", LangRoAll.confirmare)) break;
                String codExtern = DialogUtils.inputDialog(null, "", "Introduceti codul extern !");
                if (Validators.correctString(codExtern)) {
                    RestLogic.getInstance().addContaExportMapping(codExtern, -1, idStoc);
                }
            } else {
                String cod = "null_" + idStoc;
                Stock s = StockLogic.getInstance().getStockByIdNoCommit(idStoc);
                if (s == null) {
                    System.out.println("stoc is null for idstoc : " + idStoc);
                    break;
                }
                RestLogic.getInstance().addContaExportMapping("S" + idStoc, -1, idStoc);
            }
            mapping = RestLogic.getInstance().getContaExportMappingForIdStock(idStoc);
        }
        return mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportMonetar(String monetareFile, Date start, Date stop, int an, int luna, Vector<SalesEntry> salesToExportForced, String destinationPath) {
        try {
            FileUtils.writeTextToFile(monetareFile, "");
            Wini ini = new Wini(new File(monetareFile));
            ini.put("InfoPachet", "AnLucru", (Object)(an + ""));
            ini.put("InfoPachet", "LunaLucru", (Object)(luna + ""));
            ini.put("InfoPachet", "TipDocument", (Object)"MONETAR");
            Vector<Date> zile = DateUtils.getDaysInPerioada(start, stop);
            String simbolCarnet = Config.getInstance().getString("contaExportMonetareSimbolCarnet", "M");
            String casa = Config.getInstance().getString("contaExportMonetareCasa", "CasaLei");
            Map<String, String> coduriProduse = Collections.synchronizedMap(new LinkedHashMap());
            boolean useGenerice = VpConfig.getInstance().contaExportUseCoduriGenerice;
            Hashtable<String, Vector<SalesEntry>> salesForcedPeZile = new Hashtable<String, Vector<SalesEntry>>();
            if (salesToExportForced != null) {
                for (SalesEntry sale : salesToExportForced) {
                    String data = sale.getDataOra();
                    Vector<SalesEntry> currentSales = (Vector<SalesEntry>)salesForcedPeZile.get(data);
                    if (currentSales == null) {
                        currentSales = new Vector<SalesEntry>();
                        salesForcedPeZile.put(data, currentSales);
                    }
                    currentSales.add(sale);
                }
            }
            int i = 1;
            for (Date date : zile) {
                double totalVanzari = 0.0;
                double totalVanzariTva = 0.0;
                double totalDiscount = 0.0;
                double totalDiscountTva = 0.0;
                Hashtable<String, Object> result = new Hashtable<String, Object>();
                Date startDay = DateUtils.getStartOfDay(date);
                Date endDay = DateUtils.getEndOfDay(date);
                result.put(Constants.START_KEY, startDay);
                result.put(Constants.STOP_KEY, endDay);
                result.put(Constants.GRUPARE_KEY, "Dupa data");
                String dataS = Formatters.DATE_FORMAT.format(date);
                Vector<SalesEntry> sales = (Vector<SalesEntry>)salesForcedPeZile.get(dataS);
                if (salesToExportForced == null) {
                    sales = RestLogic.getInstance().getSalesReportNoCommit(result, 2);
                }
                if (sales == null) continue;
                String tipPlataTichet = Config.getInstance().getString("contaExportMonetareTichet", "Tichet");
                String tipPlataCard = Config.getInstance().getString("contaExportMonetareCard", "Card");
                String tipPlataCec = Config.getInstance().getString("contaExportMonetareCec", "Cec");
                Hashtable<String, Date> criteria = new Hashtable<String, Date>();
                criteria.put(Constants.START_KEY, startDay);
                criteria.put(Constants.STOP_KEY, endDay);
                Vector<SimpleMonetarView> monetarInZiua = RestLogic.getInstance().getZMonetarNoCommit(criteria, 1, -1);
                double totalTichet = 0.0;
                double totalCard = 0.0;
                double totalCec = 0.0;
                for (SimpleMonetarView monetarView : monetarInZiua) {
                    String tipPlata2 = monetarView.getTipPlata();
                    if (tipPlata2.equalsIgnoreCase(tipPlataTichet)) {
                        totalTichet += monetarView.getSuma();
                    }
                    if (tipPlata2.equalsIgnoreCase(tipPlataCard)) {
                        totalCard += monetarView.getSuma();
                    }
                    if (!tipPlata2.equalsIgnoreCase(tipPlataCec)) continue;
                    totalCec += monetarView.getSuma();
                }
                int j = 1;
                if (sales == null) {
                    System.out.println("sales is null !!");
                }
                for (SalesEntry sale : sales) {
                    String codProdusGenericSectie;
                    String numeItem = "Items_" + i;
                    int idProduct = sale.getIdProduct();
                    Product product = NomeclaturaLogic.getInstance().getProductByIdNoCommit(sale.getIdProduct());
                    Categorie categorie = NomeclaturaLogic.getInstance().getCategoryByIdNoCommit(product.getIdCategorie());
                    Sectie sectie = NomeclaturaLogic.getInstance().getSectieById(categorie.getSectie());
                    Tva tva = TvaLogic.getInstance().getTvaByIdNoCommit(categorie.getIdTva());
                    String codProdus = codProdusGenericSectie = sectie.getAnalitic();
                    if (!useGenerice) {
                        ContaExportMapping mapping = this.getMappingForIdProductWithAdding(idProduct, sale.getProduct());
                        if (mapping == null) {
                            ConnectionPool.getInstance().rollBack();
                            return;
                        }
                        codProdus = mapping.getExternalCode();
                    } else {
                        double d = FloatUtils.roundDouble(tva.getCota(), 2);
                        int cotaInt = (int)Math.ceil(d * 100.0);
                        codProdus = codProdus + cotaInt;
                    }
                    String line = codProdus + ";BUC;" + Utils.getString5DecimalsNoTrunc(sale.getQuantity()) + ";" + Utils.getString4DecimalsNoTrunc(sale.getPrice()) + ";" + sectie + ";";
                    ini.put(numeItem, "Item_" + j, (Object)line);
                    if (!useGenerice) {
                        coduriProduse.put(codProdus, product.getName());
                    }
                    double cotaTva = tva.getCota();
                    double vanzare = sale.getOriginalPrice() * sale.getQuantity();
                    totalVanzari += vanzare;
                    double tvaVanzare = vanzare / (1.0 + cotaTva) * cotaTva;
                    totalVanzariTva += tvaVanzare;
                    totalDiscount += sale.getDiscount();
                    double tvaDiscount = sale.getDiscount() / (1.0 + cotaTva) * cotaTva;
                    totalDiscountTva += tvaDiscount;
                    ++j;
                }
                if (j <= true) continue;
                int nrOrders = RestLogic.getInstance().getNrOrders(criteria, -1);
                String numeMonetar = "Monetar_" + i;
                ini.put(numeMonetar, "NumarBonuri", (Object)(nrOrders + ""));
                ini.put(numeMonetar, "Operat", (Object)"D");
                int nrDoc = RegistreLogic.getInstance().getNewNumberForRegistruNoCommit(RegistreConstants.MONETAR.key, RegistreConstants.MONETAR.nume, true);
                ini.put(numeMonetar, "NrDoc", (Object)("" + nrDoc));
                ini.put(numeMonetar, "SimbolCarnet", (Object)simbolCarnet);
                ini.put(numeMonetar, "Operatie", (Object)"A");
                ini.put(numeMonetar, "Data", (Object)Formatters.DOTTED_DATE_FORMAT_RO.format(date));
                ini.put(numeMonetar, "Casa", (Object)casa);
                ini.put(numeMonetar, "TotalArticole", (Object)sales.size());
                ini.put(numeMonetar, "CEC", (Object)Utils.getString6DecimalsNoTrunc(totalCec));
                ini.put(numeMonetar, "CARD", (Object)Utils.getString6DecimalsNoTrunc(totalCard));
                ini.put(numeMonetar, "BONVALORIC", (Object)Utils.getString6DecimalsNoTrunc(totalTichet));
                ini.put(numeMonetar, "Observatii", (Object)"Dever");
                ini.put(numeMonetar, "Discount", (Object)Utils.getString6DecimalsNoTrunc(totalDiscount));
                ini.put(numeMonetar, "TVADiscount", (Object)Utils.getString6DecimalsNoTrunc(totalDiscountTva));
                ++i;
            }
            ini.put("InfoPachet", "TotalMonetare", (Object)(i - 1));
            ini.store();
            String content = FileUtils.readFileToString(monetareFile);
            content = content.replace(" = ", "=");
            FileUtils.writeTextToFile(monetareFile, content);
            this.exportArticole(destinationPath, coduriProduse);
            ConnectionPool.getInstance().commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, e);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTransferuri(String transferFile, Date start, Date stop, int an, int luna) {
        try {
            FileUtils.writeTextToFile(transferFile, "");
            final Wini ini = new Wini(new File(transferFile));
            ini.put("InfoPachet", "AnLucru", (Object)(an + ""));
            ini.put("InfoPachet", "LunaLucru", (Object)(luna + ""));
            ini.put("InfoPachet", "TipDocument", (Object)"TRANSFER");
            int i = 1;
            Vector<Date> zile = DateUtils.getDaysInPerioada(start, stop);
            for (Date date : zile) {
                Date startDay = DateUtils.getStartOfDay(date);
                Date endDay = DateUtils.getEndOfDay(date);
                Hashtable<String, Comparable<Date>> searchCriteria = new Hashtable<String, Comparable<Date>>();
                searchCriteria.put(Constants.START_KEY, startDay);
                searchCriteria.put(Constants.STOP_KEY, endDay);
                searchCriteria.put("id_magazie", Integer.valueOf(-1));
                searchCriteria.put("id_magazie_destinatie", Integer.valueOf(-1));
                searchCriteria.put("Tip transfer", Integer.valueOf(-1));
                Vector<StockTransfer> transferuri = StockLogic.getInstance().getTransferuri(searchCriteria);
                for (StockTransfer stockTransfer : transferuri) {
                    Vector<StockTransferItem> transferItems = StockLogic.getInstance().getTransferItems(stockTransfer.getId());
                    int articolePeBune = 0;
                    Vector<3> futureLines = new Vector<3>();
                    final String itemsForBon = "Items_" + i;
                    final AtrFloat j = new AtrFloat();
                    j.setValue(1.0);
                    for (StockTransferItem entry : transferItems) {
                        int idStoc = entry.getIdStock();
                        if (idStoc <= 0 || entry.getCantitate() == 0.0 && entry.getValoareAchizitie() == 0.0 && entry.getValoareVanzare() == 0.0) continue;
                        String string = entry.getUm();
                        double pret = entry.getValoareAchizitie() / entry.getCantitate();
                        ContaExportMapping mapping = this.getMappingForStockIdWithAdding(idStoc, entry.getDenumire());
                        if (mapping == null) {
                            ConnectionPool.getInstance().rollBack();
                            return;
                        }
                        final String line = mapping.getExternalCode() + ";" + string + ";" + Utils.getString5DecimalsNoTrunc(entry.getCantitate()) + ";" + Utils.getString4DecimalsNoTrunc(pret) + ";" + stockTransfer.getSursa() + ";;;";
                        Callable futureLine = new Callable(){

                            public Object call() throws Exception {
                                ini.put(itemsForBon, "Item_" + Utils.getStringXDecimals(j.getValue(), 0), (Object)line);
                                j.setValue(j.getValue() + 1.0);
                                return null;
                            }
                        };
                        futureLines.add(futureLine);
                        ++articolePeBune;
                    }
                    if (articolePeBune <= 0) continue;
                    String numeBon = "Transfer_" + i;
                    int nrDoc = stockTransfer.getNrBon();
                    ini.put(numeBon, "NrDoc", (Object)("" + nrDoc));
                    ini.put(numeBon, "Data", (Object)Formatters.DOTTED_DATE_FORMAT_RO.format(date));
                    ini.put(numeBon, "GestDest", (Object)stockTransfer.getDestinatie());
                    ini.put(numeBon, "TotalArticole", (Object)articolePeBune);
                    ini.put(numeBon, "Observatii", (Object)"Dever");
                    ini.put(numeBon, "Operat", (Object)"n");
                    ++i;
                    for (Callable callable : futureLines) {
                        callable.call();
                    }
                }
            }
            ini.put("InfoPachet", "TotalTransferuri", (Object)(i - 1));
            ini.store();
            String content = FileUtils.readFileToString(transferFile);
            content = content.replace(" = ", "=");
            FileUtils.writeTextToFile(transferFile, content);
            ConnectionPool.getInstance().commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, e);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportConsumuri(String consumFile, Date start, Date stop, int an, int luna) {
        try {
            FileUtils.writeTextToFile(consumFile, "");
            final Wini ini = new Wini(new File(consumFile));
            ini.put("InfoPachet", "AnLucru", (Object)(an + ""));
            ini.put("InfoPachet", "LunaLucru", (Object)(luna + ""));
            ini.put("InfoPachet", "TipDocument", (Object)"BON DE CONSUM");
            Vector<Magazie> magazii = StockLogic.getInstance().getAllMagaziiNoCommit();
            Vector<Date> zile = DateUtils.getDaysInPerioada(start, stop);
            int i = 1;
            for (Date date : zile) {
                Date startDay = DateUtils.getStartOfDay(date);
                Date endDay = DateUtils.getEndOfDay(date);
                Iterator<Magazie> i$ = magazii.iterator();
                while (i$.hasNext()) {
                    String winmentorMagaziiExcluse = VpConfig.getInstance().winmentorMagaziiExcluse;
                    Magazie magazie = i$.next();
                    if (winmentorMagaziiExcluse.contains(magazie.getLabel())) continue;
                    Hashtable<String, Object> searchCriteria = new Hashtable<String, Object>();
                    searchCriteria.put(Constants.START_KEY, startDay);
                    searchCriteria.put(Constants.STOP_KEY, endDay);
                    searchCriteria.put("id_magazie", magazie.getId());
                    searchCriteria.put("finit_ingredient", 1);
                    searchCriteria.put("vanzare_achizitie", 2);
                    Vector<TipDocument> allItems = StockLogic.getInstance().getDocumentInterface().getAllTipDocument();
                    allItems.remove(new TipDocument(5, "Productie"));
                    allItems.remove(new TipDocument(9, "Diff Inventar"));
                    allItems.remove(new TipDocument(7, "Transfer"));
                    allItems.remove(new TipDocument(6, "Modif pret"));
                    allItems.remove(new TipDocument(4, "Bon consum"));
                    String dbString = "";
                    for (TipDocument item : allItems) {
                        dbString = dbString + item.getTip();
                        dbString = dbString + ",";
                    }
                    if (dbString.length() > 0) {
                        dbString = dbString.substring(0, dbString.length() - 1);
                    }
                    searchCriteria.put("tip_document", dbString);
                    Vector<RaportGestiuneEntry> consumuri = StockLogic.getInstance().generateRaportGestiuneNoCommit(searchCriteria, true, 2);
                    int articolePeBune = 0;
                    Vector<4> futureLines = new Vector<4>();
                    final String itemsForBon = "Items_" + i;
                    final AtrFloat j = new AtrFloat();
                    j.setValue(1.0);
                    for (RaportGestiuneEntry entry : consumuri) {
                        int idStoc = entry.getIdStoc();
                        if (idStoc <= 0 || entry.getCantIesita() == 0.0 && entry.getValIesitaAcz() == 0.0 && entry.getValIesitaVz() == 0.0) continue;
                        String string = entry.getUm();
                        double pret = entry.getValIesitaAcz() / entry.getCantIesita();
                        ContaExportMapping mapping = this.getMappingForStockIdWithAdding(idStoc, entry.getProdus());
                        if (mapping == null) {
                            ConnectionPool.getInstance().rollBack();
                            return;
                        }
                        final String line = mapping.getExternalCode() + ";" + string + ";" + Utils.getString5DecimalsNoTrunc(entry.getCantIesita()) + ";" + Utils.getString4DecimalsNoTrunc(pret) + ";" + magazie.getLabel() + ";;;";
                        Callable futureLine = new Callable(){

                            public Object call() throws Exception {
                                ini.put(itemsForBon, "Item_" + Utils.getStringXDecimals(j.getValue(), 0), (Object)line);
                                j.setValue(j.getValue() + 1.0);
                                return null;
                            }
                        };
                        futureLines.add(futureLine);
                        ++articolePeBune;
                    }
                    if (articolePeBune > 0) {
                        String numeBon = "Bon_" + i;
                        int nrDoc = RegistreLogic.getInstance().getNewNumberForRegistruNoCommit(RegistreConstants.BON_CONSUM.key, RegistreConstants.BON_CONSUM.nume, true);
                        ini.put(numeBon, "NrDoc", (Object)("" + nrDoc));
                        ini.put(numeBon, "Data", (Object)Formatters.DOTTED_DATE_FORMAT_RO.format(date));
                        ini.put(numeBon, "GestConsum", (Object)magazie.getLabel());
                        ini.put(numeBon, "TotalArticole", (Object)articolePeBune);
                        ini.put(numeBon, "Observatii", (Object)"Dever consum specific");
                        ini.put(numeBon, "Operat", (Object)"n");
                        ++i;
                        for (Callable callable : futureLines) {
                            callable.call();
                        }
                    }
                    Hashtable<String, Comparable<Date>> criteria = new Hashtable<String, Comparable<Date>>();
                    criteria.put(Constants.START_KEY, startDay);
                    criteria.put(Constants.STOP_KEY, endDay);
                    criteria.put("id_magazie", Integer.valueOf(magazie.getId()));
                    Vector bonuriConsum = StockLogic.getInstance().getBonuriConsum(criteria);
                    if (bonuriConsum == null) continue;
                    for (BonConsum bonConsum : bonuriConsum) {
                        final String itemsForBonC = "Items_" + i;
                        final AtrFloat k = new AtrFloat();
                        k.setValue(1.0);
                        articolePeBune = 0;
                        Vector<5> futureLinesBC = new Vector<5>();
                        Vector entries = StockLogic.getInstance().getBonConsumItems(bonConsum.getId());
                        if (entries == null) continue;
                        for (BonConsumItem entry : entries) {
                            int idStoc = entry.getIdStock();
                            if (idStoc <= 0 || entry.getCantitate() == 0.0 && entry.getValoareAchizitie() == 0.0 && entry.getValoareVanzare() == 0.0) continue;
                            String string = entry.getUm();
                            double pret = entry.getValoareAchizitie() / entry.getCantitate();
                            ContaExportMapping mapping = this.getMappingForStockIdWithAdding(idStoc, entry.getDenumire());
                            if (mapping == null) {
                                ConnectionPool.getInstance().rollBack();
                                return;
                            }
                            final String line = mapping.getExternalCode() + ";" + string + ";" + Utils.getString5DecimalsNoTrunc(entry.getCantitate()) + ";" + Utils.getString4DecimalsNoTrunc(pret) + ";" + bonConsum.getMagazie() + ";;";
                            Callable futureLine = new Callable(){

                                public Object call() throws Exception {
                                    ini.put(itemsForBonC, "Item_" + Utils.getStringXDecimals(k.getValue(), 0), (Object)line);
                                    k.setValue(k.getValue() + 1.0);
                                    return null;
                                }
                            };
                            futureLinesBC.add(futureLine);
                            ++articolePeBune;
                        }
                        if (articolePeBune <= 0) continue;
                        String numeBon = "Bon_" + i;
                        int nrDoc = RegistreLogic.getInstance().getNewNumberForRegistruNoCommit(RegistreConstants.BON_CONSUM.key, RegistreConstants.BON_CONSUM.nume, true);
                        ini.put(numeBon, "NrDoc", (Object)("" + nrDoc));
                        ini.put(numeBon, "Data", (Object)Formatters.DOTTED_DATE_FORMAT_RO.format(date));
                        ini.put(numeBon, "GestConsum", (Object)magazie.getLabel());
                        ini.put(numeBon, "TotalArticole", (Object)articolePeBune);
                        ini.put(numeBon, "Observatii", (Object)bonConsum.getObservatii());
                        ini.put(numeBon, "Operat", (Object)"n");
                        ++i;
                        for (Callable callable : futureLinesBC) {
                            callable.call();
                        }
                    }
                }
            }
            ini.put("InfoPachet", "TotalBonuri", (Object)(i - 1));
            ini.store();
            String content = FileUtils.readFileToString(consumFile);
            content = content.replace(" = ", "=");
            FileUtils.writeTextToFile(consumFile, content);
            ConnectionPool.getInstance().commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, e);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportModificariPret(String consumFile, Date start, Date stop, int an, int luna) {
        try {
            FileUtils.writeTextToFile(consumFile, "");
            final Wini ini = new Wini(new File(consumFile));
            ini.put("InfoPachet", "AnLucru", (Object)(an + ""));
            ini.put("InfoPachet", "LunaLucru", (Object)(luna + ""));
            ini.put("InfoPachet", "TipDocument", (Object)"MODIFICARE PRET");
            Vector<Date> zile = DateUtils.getDaysInPerioada(start, stop);
            int i = 1;
            for (Date date : zile) {
                Date startDay = DateUtils.getStartOfDay(date);
                Date endDay = DateUtils.getEndOfDay(date);
                Hashtable<String, Comparable<Date>> searchCriteria = new Hashtable<String, Comparable<Date>>();
                searchCriteria.put(Constants.START_KEY, startDay);
                searchCriteria.put(Constants.STOP_KEY, endDay);
                searchCriteria.put("id_stock_key", Integer.valueOf(-1));
                Vector<ModificarePret> modificarePrets = StockLogic.getInstance().getAllModificariPret(searchCriteria);
                int articolePeBune = 0;
                Vector<6> futureLines = new Vector<6>();
                final String itemsForBon = "Items_" + i;
                final AtrFloat j = new AtrFloat();
                j.setValue(1.0);
                for (ModificarePret entry : modificarePrets) {
                    int idStoc = entry.getIdStock();
                    if (idStoc <= 0) continue;
                    Stock stock = StockLogic.getInstance().getStockByIdNoCommit(idStoc);
                    Unit u = UnitsLogic.getInstance().getUnitByIdNoCommit(stock.getIdUnit());
                    String um = u.getLabel();
                    ContaExportMapping mapping = this.getMappingForStockIdWithAdding(idStoc, entry.getNumeProdus());
                    if (mapping == null) {
                        ConnectionPool.getInstance().rollBack();
                        return;
                    }
                    double pret = entry.getPretNou();
                    if (pret == 0.0) continue;
                    Vector<FisaMagazieEntry> fisaMagazieEntries = StockLogic.getInstance().getFisaMagazieByTimeDocument(entry.getData());
                    if (fisaMagazieEntries.size() > 0) {
                        FisaMagazieEntry fisaMagazieEntry = fisaMagazieEntries.get(0);
                        double cant = fisaMagazieEntry.getValIntrataPv() / pret;
                        int idMagazie = fisaMagazieEntry.getIdMagazie();
                        Magazie m = StockLogic.getInstance().getMagazieByIdNoCommit(idMagazie);
                        if (m != null) {
                            final String line = mapping.getExternalCode() + ";" + um + ";" + Utils.getString5DecimalsNoTrunc(cant) + ";" + Utils.getString4DecimalsNoTrunc(pret) + ";" + m.getLabel();
                            Callable futureLine = new Callable(){

                                public Object call() throws Exception {
                                    ini.put(itemsForBon, "Item_" + Utils.getStringXDecimals(j.getValue(), 0), (Object)line);
                                    j.setValue(j.getValue() + 1.0);
                                    return null;
                                }
                            };
                            futureLines.add(futureLine);
                            ++articolePeBune;
                            continue;
                        }
                        Logger.logWarning(this, "Magazie inexistenta : id = " + idMagazie);
                        continue;
                    }
                    Logger.logWarning(this, "Modificare pret neprocesata : id = " + entry.getIdModificarePret());
                }
                if (articolePeBune <= 0) continue;
                String numeBon = "PV_" + i;
                int nrDoc = RegistreLogic.getInstance().getNewNumberForRegistruNoCommit(RegistreConstants.MODIFICARE_PRET.key, RegistreConstants.MODIFICARE_PRET.nume, true);
                ini.put(numeBon, "NrDoc", (Object)("" + nrDoc));
                ini.put(numeBon, "SimbolCarnet", (Object)"PV");
                ini.put(numeBon, "Operatie", (Object)"A");
                ini.put(numeBon, "Data", (Object)Formatters.DOTTED_DATE_FORMAT_RO.format(date));
                ini.put(numeBon, "TotalArticole", (Object)articolePeBune);
                ini.put(numeBon, "Operat", (Object)"D");
                ini.put(numeBon, "Observatii", (Object)"Dever");
                ++i;
                for (Callable callable : futureLines) {
                    callable.call();
                }
            }
            ini.put("InfoPachet", "TotalModifPret", (Object)(i - 1));
            ini.put("InfoPachet", "LogOn", (Object)"Master");
            ini.store();
            String content = FileUtils.readFileToString(consumFile);
            content = content.replace(" = ", "=");
            FileUtils.writeTextToFile(consumFile, content);
            ConnectionPool.getInstance().commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, e);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDiffInventarGeneric(String consumFile, Date start, Date stop, int an, int luna, MarireDiminuareInterf inter) {
        try {
            FileUtils.writeTextToFile(consumFile, "");
            final Wini ini = new Wini(new File(consumFile));
            ini.put("InfoPachet", "AnLucru", (Object)(an + ""));
            ini.put("InfoPachet", "LunaLucru", (Object)(luna + ""));
            ini.put("InfoPachet", "TipDocument", (Object)inter.getTipDocument());
            Vector<Date> zile = DateUtils.getDaysInPerioada(start, stop);
            int i = 1;
            for (Date date : zile) {
                Date startDay = DateUtils.getStartOfDay(date);
                Date endDay = DateUtils.getEndOfDay(date);
                Vector<Corectie> corectii = StockLogic.getInstance().getRaportCorectii(-1, new Timestamp(startDay.getTime()), new Timestamp(endDay.getTime()));
                for (Corectie corectie : corectii) {
                    Vector<7> futureLines = new Vector<7>();
                    int articolePeBune = 0;
                    final String itemsForBon = "Items_" + i;
                    final AtrFloat j = new AtrFloat();
                    j.setValue(1.0);
                    Vector<FisaMagazieEntry> fisaMagazieEntries = StockLogic.getInstance().getFisaMagazieByTimeDocument(corectie.getDateadd());
                    if (fisaMagazieEntries.size() < 0) {
                        Logger.logWarning(this, "Diferenta inventar neprocesata : " + corectie.getId());
                        continue;
                    }
                    for (FisaMagazieEntry fis : fisaMagazieEntries) {
                        int n;
                        if (!inter.accept(fis) || (n = fis.getIdStoc()) <= 0) continue;
                        Stock s = StockLogic.getInstance().getStockByIdNoCommit(n);
                        Unit u = UnitsLogic.getInstance().getUnitByIdNoCommit(s.getIdUnit());
                        String um = u.getLabel();
                        ContaExportMapping mapping = this.getMappingForStockIdWithAdding(n, s.getLabel());
                        if (mapping == null) {
                            ConnectionPool.getInstance().rollBack();
                            return;
                        }
                        double qty = FloatUtils.roundDoubleUp(inter.getRealQty(fis), 3);
                        if (Utils.isValueZero(qty)) continue;
                        double iesita = fis.getIesita();
                        int idMagazie = fis.getIdMagazie();
                        Magazie m = StockLogic.getInstance().getMagazieByIdNoCommit(idMagazie);
                        if (m != null) {
                            double pretVz = FloatUtils.roundDoubleUp(fis.getValIesitaPv() / iesita, 2);
                            if (pretVz <= 0.0) {
                                pretVz = 0.0;
                            }
                            double pretAcz = FloatUtils.roundDoubleUp(fis.getValIesitaPa() / iesita, 2);
                            final String line = mapping.getExternalCode() + ";" + um + ";" + Utils.getString5DecimalsNoTrunc(qty) + ";" + m.getLabel() + ";" + Utils.getString4DecimalsNoTrunc(pretVz) + ";" + Utils.getString4DecimalsNoTrunc(pretAcz);
                            Callable futureLine = new Callable(){

                                public Object call() throws Exception {
                                    ini.put(itemsForBon, "Item_" + Utils.getStringXDecimals(j.getValue(), 0), (Object)line);
                                    j.setValue(j.getValue() + 1.0);
                                    return null;
                                }
                            };
                            futureLines.add(futureLine);
                            ++articolePeBune;
                            continue;
                        }
                        Logger.logWarning(this, "Magazie inexistenta : id = " + idMagazie);
                    }
                    if (articolePeBune <= 0) continue;
                    String numeBon = "PV_" + i;
                    ini.put(numeBon, "NrDoc", (Object)("" + corectie.getId()));
                    ini.put(numeBon, "SimbolCarnet", (Object)inter.getSerieCarnet());
                    ini.put(numeBon, "Operatie", (Object)"A");
                    ini.put(numeBon, "Data", (Object)Formatters.DOTTED_DATE_FORMAT_RO.format(date));
                    ini.put(numeBon, "TotalArticole", (Object)articolePeBune);
                    ini.put(numeBon, "Operat", (Object)"D");
                    ini.put(numeBon, "Observatii", (Object)"Dever");
                    ++i;
                    for (Callable callable : futureLines) {
                        callable.call();
                    }
                }
            }
            ini.put("InfoPachet", inter.getTotalText(), (Object)(i - 1));
            ini.store();
            String content = FileUtils.readFileToString(consumFile);
            content = content.replace(" = ", "=");
            FileUtils.writeTextToFile(consumFile, content);
            ConnectionPool.getInstance().commit();
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, e);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importArticole(String file, Component parent) {
        StockLogic stockLogic = StockLogic.getInstance();
        Tva tva = TvaLogic.getInstance().getTvas().get(0);
        LineNumberReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(file));
            String line = null;
            int lineNr = 0;
            while ((line = reader.readLine()) != null) {
                int idStock;
                ContaExportMapping existing;
                ++lineNr;
                Vector tokens = Utils.splitStringKeepStructure(line, ';', ' ');
                if (tokens.size() != 14) {
                    if (DialogUtils.confirmDialog(parent, "Linia " + lineNr + " nu respecta structura. Va rog verificati!! Continuam", LangRoAll.confirmare)) continue;
                    throw new Exception("Canceled by user");
                }
                String numeProdus = (String)tokens.get(2);
                String codExtern = (String)tokens.get(3);
                String um = (String)tokens.get(4);
                String codBare = (String)tokens.get(5);
                String stocabil = (String)tokens.get(7);
                String tipContabil = (String)tokens.get(8);
                String pretVzS = (String)tokens.get(10);
                if (!Validators.correctString(codExtern)) {
                    Logger.logWarning(this, "Linia " + lineNr + " nu are cod extern.");
                    continue;
                }
                double pretVanzare = Utils.parseDouble(pretVzS);
                String serviciuKey = Config.getInstance().getStringNoCommit("contaTipContabilServiciuName");
                String materiePrimaKey = Config.getInstance().getStringNoCommit("contaTipContabilMateriiPrime");
                String produseKey = Config.getInstance().getStringNoCommit("contaTipContabilProduse");
                boolean isServiciu = stocabil.equalsIgnoreCase(serviciuKey);
                boolean isMateriePrima = tipContabil.equalsIgnoreCase(materiePrimaKey);
                boolean isReteta = isServiciu || tipContabil.equalsIgnoreCase(produseKey);
                System.out.println("Line nr : " + lineNr);
                int idCategorie = -1;
                if (!isMateriePrima) {
                    String categoria = (String)tokens.get(13);
                    if (!Validators.correctString(categoria)) {
                        Logger.logWarning(this, "Categorie lipsa pt MARFA : Ignoram linia : " + lineNr + " (" + line + ")");
                        continue;
                    }
                    Categorie cat = NomeclaturaLogic.getInstance().getCategoryByNameNoCommit(categoria);
                    if (cat == null) continue;
                    idCategorie = cat.getId();
                }
                int idUnit = -1;
                if (!isReteta) {
                    Unit unit = UnitsLogic.getInstance().getUnitByNameNoCommit(um);
                    idUnit = unit == null ? UnitsLogic.getInstance().addUnitNoCommit(um) : unit.getId();
                }
                if ((existing = ContaLogic.getInstance().getWinmentorExportInterface().getContaExportMappingForCodExtern(codExtern)) == null) {
                    idStock = -1;
                    int idProduct = -1;
                    if (!isReteta) {
                        Stock s = stockLogic.getStockByNameNoCommit(numeProdus);
                        if (s == null) {
                            idStock = stockLogic.addStockNoCommit(numeProdus, idUnit, 0.0, 0.0, pretVanzare, true);
                        } else {
                            idStock = s.getId();
                            stockLogic.updateStockNoCommit(idStock, numeProdus, idUnit, s.getWarningLevel(), s.getCriticalLevel(), true);
                        }
                        if (!isMateriePrima) {
                            int cod = NomeclaturaLogic.getInstance().getNextProductCodeNoCommit();
                            Vector<String> barcodes = new Vector<String>();
                            barcodes.add(codBare);
                            idProduct = stockLogic.addProdusFinitNoCommit(numeProdus, idStock, idCategorie, cod, false, false, null, codExtern, barcodes);
                        }
                    } else {
                        int cod = NomeclaturaLogic.getInstance().getNextProductCodeNoCommit();
                        Vector<String> codBares = new Vector<String>();
                        codBares.add(codBare);
                        int[] ids = RestLogic.getInstance().newRetetaProductNoCommit(idCategorie, numeProdus, pretVanzare, new Vector(), cod, numeProdus, numeProdus, "", "", "", false, true, false, new Vector(), null, codExtern, codBares);
                        idProduct = ids[0];
                    }
                    ContaLogic.getInstance().getWinmentorExportInterface().addContaExportMapping(codExtern, idProduct, idStock);
                    continue;
                }
                if (!isReteta) {
                    idStock = existing.getIdStock();
                    Stock stock = stockLogic.getStockByIdNoCommit(idStock);
                    if (stock == null) {
                        DialogUtils.errorDialog(parent, "CodExtern " + codExtern + " are idStock :" + idStock + " dar stock is null !!", "Linie ignorata: " + lineNr);
                        continue;
                    }
                    if (!isMateriePrima) {
                        int idProduct = existing.getIdProduct();
                        Product product = NomeclaturaLogic.getInstance().getProductByIdNoCommit(idProduct);
                        if (product == null) {
                            DialogUtils.errorDialog(parent, "CodExtern (stocabil) " + codExtern + " are idProduct :" + idProduct + " dar product is null !!", "Linie ignorata: " + lineNr);
                            continue;
                        }
                        Product p = stockLogic.getProductForStockNoCommit(idStock);
                        if (p.getId() != idProduct) {
                            DialogUtils.errorDialog(parent, "CodExtern (stocabil) " + codExtern + " are idProduct in mapare : " + idProduct + " dar in produse_finite : " + p.getId() + " !!", "Linie ignorata: " + lineNr);
                            continue;
                        }
                        stockLogic.updatePriceForStockNoCommit(idStock, pretVanzare);
                        NomeclaturaLogic.getInstance().updateProductNoCommit(p, pretVanzare, new Vector());
                    }
                    stockLogic.updateStockNoCommit(idStock, numeProdus, idUnit, stock.getWarningLevel(), stock.getCriticalLevel(), true);
                    continue;
                }
                int idProduct = existing.getIdProduct();
                Product product = NomeclaturaLogic.getInstance().getProductByIdNoCommit(idProduct);
                if (product == null) {
                    DialogUtils.errorDialog(parent, "CodExtern (serviciu)" + codExtern + " are idProduct :" + idProduct + " dar product is null !!", "Linie ignorata: " + lineNr);
                    continue;
                }
                NomeclaturaLogic.getInstance().updateProductNoCommit(product, pretVanzare, new Vector());
            }
            ConnectionPool.getInstance().commit();
            stockLogic.notifyListeners(26);
            NomeclaturaLogic.getInstance().notifyListeners(2);
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, e);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static interface MarireDiminuareInterf {
        public boolean accept(FisaMagazieEntry var1);

        public double getRealQty(FisaMagazieEntry var1);

        public String getTipDocument();

        public String getTotalText();

        public String getSerieCarnet();
    }

    private static enum RegistreConstants {
        NOTA_PREDARE("export_winmentor_note_predare", "Nota Predare"),
        BON_CONSUM("export_winmentor_bon_consum", "Bon Consum"),
        MODIFICARE_PRET("export_winmentor_modificare_pret", "Modificare pret"),
        BON_TRANSFER("export_winmentor_bon_transfer", "Bon transfer"),
        MONETAR("export_winmentor_monetar", "Monetar");

        String key;
        String nume;

        private RegistreConstants(String key, String nume) {
            this.key = key;
            this.nume = nume;
        }
    }
}

