/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.meniupda;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class Masa
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String action;
        Table t;
        String productImagesPath = "webapps/meniupda/productimages";
        File productImagesDirectory = new File(productImagesPath);
        if (!productImagesDirectory.exists()) {
            productImagesDirectory.mkdirs();
        } else if (!productImagesDirectory.isDirectory()) {
            Logger.logError((Object)this, productImagesDirectory + " is not a directory");
        }
        User ospatar = (User)request.getSession().getAttribute("ospatar");
        if (ospatar == null) {
            response.sendRedirect("login");
            return;
        }
        String idMasa = request.getParameter("masa");
        RestLogic logic = RestLogic.getInstance();
        Order o = logic.getOpenOrderAtTable(t = logic.getTableById(Integer.parseInt(idMasa)));
        if (o != null && o.getUser() != ospatar.getId()) {
            response.sendRedirect("mese");
            return;
        }
        Vector c1 = (Vector)request.getSession().getAttribute("content");
        if (c1 == null) {
            request.getSession().setAttribute("content", new Vector());
        }
        if ((action = request.getParameter("action")) == null) {
            action = "";
        }
        if (action.equalsIgnoreCase("marcaj")) {
            o = this.createOrderIfNull(o, t, ospatar, logic);
            for (Sectie element : logic.getSectii()) {
                String key = ospatar.getId() + "_" + t.getId() + "_" + element.getId();
                Vector tempSales = (Vector)request.getSession().getAttribute(key);
                if (tempSales == null || tempSales.size() == 0) continue;
                logic.productsSold(tempSales, o, t, element, false, null);
                Vector newProducts = new Vector();
                request.getSession().setAttribute(key, newProducts);
            }
        } else if (action.equalsIgnoreCase("stergeTemp")) {
            int idProduct = Integer.parseInt(request.getParameter("idProduct"));
            block3: for (Sectie element : logic.getSectii()) {
                String key = ospatar.getId() + "_" + t.getId() + "_" + element.getId();
                Vector tempSales = (Vector)request.getSession().getAttribute(key);
                if (tempSales == null) continue;
                for (Sale sale : tempSales) {
                    if (sale.getIdProduct() != idProduct) continue;
                    sale.setCantitateNoua(sale.getCantitateNoua() - 1.0);
                    if (!(sale.getCantitateNoua() <= 0.0)) continue block3;
                    tempSales.remove(sale);
                    continue block3;
                }
            }
        } else if (action.equalsIgnoreCase("preparare")) {
            String preparare = request.getParameter("modPreparare");
            String idPreparare = request.getParameter("modPreparareId");
            request.getSession().setAttribute("modPreparare", (Object)preparare);
            request.getSession().setAttribute("modPreparareId", (Object)new Integer(idPreparare));
        } else if (action.equalsIgnoreCase("navigate")) {
            int level = Integer.parseInt(request.getParameter("level"));
            int itemId = Integer.parseInt(request.getParameter("itemId"));
        } else if (action.equalsIgnoreCase("content")) {
            int level = Integer.parseInt(request.getParameter("level"));
            int itemId = Integer.parseInt(request.getParameter("itemId"));
            o = this.createOrderIfNull(o, t, ospatar, logic);
            Product product = NomeclaturaLogic.getInstance().getProductById(itemId);
            Sectie c2 = NomeclaturaLogic.getInstance().getSectieByCategoryId(product.getIdCategorie());
            String key = ospatar.getId() + "_" + t.getId() + "_" + c2.getId();
            Vector<Sale> tempSales = (Vector<Sale>)request.getSession().getAttribute(key);
            if (tempSales == null) {
                tempSales = new Vector<Sale>();
                request.getSession().setAttribute(key, tempSales);
            }
            boolean found = false;
            Object mpObject = request.getSession().getAttribute("modPreparareId");
            String modPreparare = "";
            if (mpObject != null) {
                modPreparare = (String)request.getSession().getAttribute("modPreparare");
            }
            for (Sale element : tempSales) {
                if (element.getIdProduct() != product.getId() || !element.getModPreparare().equals(modPreparare)) continue;
                found = true;
                element.setCantitateNoua(element.getCantitateNoua() + 1.0);
            }
            if (!found) {
                String platouKey = "platou_" + idMasa;
                String platouStatusKey = "platoustatus_" + idMasa;
                String platouStatus = (String)request.getSession().getAttribute(platouStatusKey);
                int idPlatou = -1;
                if (platouStatus != null) {
                    String platouId = (String)request.getSession().getAttribute(platouKey);
                    idPlatou = Integer.parseInt(platouId);
                }
                long now = System.currentTimeMillis();
                Sale ts = logic.buildSale(product, 0.0, 1.0, modPreparare, -1, idPlatou, -1, -1, -1, now, 0);
                tempSales.add(ts);
            }
            request.getSession().setAttribute("modPreparare", (Object)"");
            request.getSession().setAttribute("modPreparareId", (Object)new Integer(-1));
        } else if (action.equalsIgnoreCase("servire")) {
            String ordineServire = request.getParameter("servire");
            String key = "servire_" + idMasa;
            String current = (String)request.getSession().getAttribute(key);
            if (current != null && current.equalsIgnoreCase(ordineServire)) {
                ordineServire = null;
            }
            request.getSession().setAttribute(key, (Object)ordineServire);
        } else if (action.equalsIgnoreCase("platou")) {
            String key = "platou_" + idMasa;
            String keyStatus = "platoustatus_" + idMasa;
            String platou = (String)request.getSession().getAttribute(key);
            String platouStatus = (String)request.getSession().getAttribute(keyStatus);
            int currentPlatouId = 0;
            if (platou != null) {
                currentPlatouId = Integer.parseInt(platou);
            }
            if (platouStatus == null) {
                request.getSession().setAttribute(key, (Object)(++currentPlatouId + ""));
                request.getSession().setAttribute(keyStatus, (Object)"");
            } else {
                request.getSession().removeAttribute(keyStatus);
            }
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        catch (IllegalStateException e) {
            out = response.getWriter();
        }
        response.setContentType("text/html");
        File f = new File("webapps/meniupda/masa.html");
        String content = FileUtils.readFileToString(f.getAbsolutePath());
        Vector navigation = (Vector)request.getSession().getAttribute("navigation");
        Vector products = (Vector)request.getSession().getAttribute("content");
        String levelS = request.getParameter("level");
        if (Validators.correctInteger(levelS)) {
            int level = Integer.parseInt(levelS);
            if (level == 2 || level == 3) {
                String pageS = request.getParameter("page");
                int currentPage = 0;
                if (Validators.correctInteger(pageS)) {
                    currentPage = Integer.parseInt(pageS);
                }
                int itemId = Integer.parseInt(request.getParameter("itemId"));
                int maxPages = products.size() / (VpConfig.getInstance().meniupdaItemsPerLine * VpConfig.getInstance().meniupdaLinesPerPage);
            } else {
                content = content.replaceAll("%%paginare%%", "");
            }
        } else {
            content = content.replaceAll("%%paginare%%", "");
        }
        content = content.replaceAll("%%meniupdaPageHeight%%", VpConfig.getInstance().meniupdaPageHeight + "");
        content = content.replaceAll("%%meniupdaPageWidth%%", VpConfig.getInstance().meniupdaPageWidth + "");
        Vector tempS = new Vector();
        for (Sectie element : logic.getSectii()) {
            String key = ospatar.getId() + "_" + t.getId() + "_" + element.getId();
            Vector tempSales = (Vector)request.getSession().getAttribute(key);
            if (tempSales == null) continue;
            tempS.addAll(tempSales);
        }
        content = this.buildProductList(o, logic, content, tempS);
        content = content.replaceAll("%%id%%", idMasa);
        content = content.replaceAll("%%masa%%", logic.getFullNameForTable(t.getLabel(), t.getIdLocatie()));
        out.write(content);
        out.flush();
    }

    private String buildProductList(Order o, RestLogic logic, String mare, Vector tempSales) throws IOException {
        String result = "";
        double total = 0.0;
        if (o != null) {
            Sale element;
            String line;
            Vector<Sale> sales = logic.getSales(o.getId(), true, -1, new ScreenSaleInterface());
            File f = new File("webapps/meniupda/comanda_entry.html");
            String content = FileUtils.readFileToString(f.getAbsolutePath());
            Iterator<Object> iter = tempSales.iterator();
            while (iter.hasNext()) {
                line = new String(content);
                element = (Sale)iter.next();
                line = line.replaceAll("%%produs%%", element.getProductName() + " " + element.getModPreparare());
                line = line.replaceAll("%%cantitate%%", Utils.getString3Decimals(element.getCantitateNoua()));
                line = line.replaceAll("%%valoare%%", "<a href=\"masa?action=stergeTemp&masa=%%id%%&idProduct=" + element.getIdProduct() + "\">Sterge</a>");
                result = result + line + "\n";
            }
            iter = sales.iterator();
            while (iter.hasNext()) {
                line = new String(content);
                element = (Sale)iter.next();
                Product p = NomeclaturaLogic.getInstance().getProductById(element.getIdProduct());
                line = line.replaceAll("%%produs%%", p.getName() + " " + element.getModPreparare());
                line = line.replaceAll("%%cantitate%%", Utils.getString3Decimals(element.getCantitateMarcata()));
                total += element.getTotal();
                line = line.replaceAll("%%valoare%%", Utils.getString2Decimals(element.getTotal()));
                result = result + line + "\n";
            }
        }
        mare = mare.replaceAll("%%comanda%%", result);
        mare = mare.replaceAll("%%total%%", Utils.getString2Decimals(total));
        return mare;
    }

    private Order createOrderIfNull(Order o, Table t, User u, RestLogic logic) {
        if (o == null) {
            o = logic.newOrder(t.getId(), u.getId());
        }
        return o;
    }
}

