/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.meniupda;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Location;
import ro.atreides.utils.config.Config;

public class MeniuPDALocatiiServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getSession().getAttribute("user") == null) {
            response.sendRedirect("login");
            return;
        }
        if (request.getSession().getAttribute("blocked_table") != null) {
            int idTable = (Integer)request.getSession().getAttribute("blocked_table");
            response.sendRedirect("masa?idMasa=" + idTable);
            return;
        }
        Vector<Location> locationsWithTables = new Vector<Location>();
        Vector locatii = RestLogic.getInstance().getLocations();
        for (int i = 0; i < locatii.size(); ++i) {
            Vector<Table> tables;
            Location location = (Location)locatii.elementAt(i);
            if (location.getTip() != 1 || (tables = RestLogic.getInstance().getTablesByLocation(location.getId())).size() <= 0) continue;
            locationsWithTables.add(location);
        }
        if (locationsWithTables.size() == 1) {
            Location singleLoc = (Location)locationsWithTables.get(0);
            response.sendRedirect("mese?idLocatie=" + singleLoc.getId());
            return;
        }
        String content = "Adaugati mese in cel putin o locatie";
        if (locationsWithTables.size() > 0) {
            StringBuffer buf = new StringBuffer();
            String locatiiFile = FileUtils.readFileToString(FileUtils.getCurrentDir() + File.separator + "webapps/meniupda/locatii.shtml");
            for (int i = 0; i < locationsWithTables.size(); ++i) {
                Location location = (Location)locationsWithTables.elementAt(i);
                String locatieEntry = FileUtils.readFileToString(FileUtils.getCurrentDir() + File.separator + "webapps/meniupda/locatie_entry.shtml");
                locatieEntry = locatieEntry.replaceAll("%%nume_locatie%%", location.getName());
                locatieEntry = locatieEntry.replaceAll("%%idLocatie%%", location.getId() + "");
                buf.append(locatieEntry);
                buf.append('\n');
            }
            String locs = buf.toString();
            content = locatiiFile.replaceAll("%%locatii%%", locs);
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        catch (IllegalStateException e) {
            out = response.getWriter();
        }
        response.setContentType("text/html");
        File f = new File("webapps/meniupda/big.shtml");
        String fullFile = FileUtils.readFileToString(f.getAbsolutePath());
        fullFile = fullFile.replaceAll("%%entity%%", Config.getInstance().getString("entityName"));
        fullFile = fullFile.replaceAll("%%meniupdaPageHeight%%", VpConfig.getInstance().meniupdaPageHeight + "");
        fullFile = fullFile.replaceAll("%%meniupdaPageWidth%%", VpConfig.getInstance().meniupdaPageWidth + "");
        fullFile = fullFile.replaceAll("%%content%%", content);
        fullFile = fullFile.replaceAll("%%footer%%", "");
        out.write(fullFile);
        out.flush();
    }
}

