/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.meniupda;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.ProductIcon;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.Validators;

public class MeniuPDAMasaServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String content;
        Order o;
        if (request.getSession().getAttribute("user") == null) {
            response.sendRedirect("login");
            return;
        }
        String action = request.getParameter("action");
        if (action == null) {
            action = "";
        }
        if (action.equalsIgnoreCase("block")) {
            String idMasa = request.getParameter("idMasa");
            if (!Validators.correctInteger(idMasa)) {
                response.sendRedirect("locatii");
                return;
            }
            String password = request.getParameter("passw");
            if (!password.equalsIgnoreCase(VpConfig.getInstance().meniupdaBlockPassword)) {
                this.gotoMasa(idMasa, response);
                return;
            }
            if (request.getSession().getAttribute("blocked_table") == null) {
                int idTable = Integer.parseInt(idMasa);
                User sessionUser = (User)request.getSession().getAttribute("user");
                Table currentTable = RestLogic.getInstance().getTableById(idTable);
                Order o2 = RestLogic.getInstance().getOpenOrderAtTable(currentTable);
                if (o2 == null) {
                    o2 = RestLogic.getInstance().newOrder(idTable, sessionUser.getId());
                }
                if (o2 == null || o2.isLaPlata() || o2.getUser() != sessionUser.getId()) {
                    response.sendRedirect("locatii");
                    return;
                }
                request.getSession().setAttribute("blocked_table", (Object)idTable);
                this.gotoMasa(idMasa, response);
                return;
            }
            request.getSession().removeAttribute("blocked_table");
            response.sendRedirect("locatii");
            return;
        }
        Integer idMasaSession = (Integer)request.getSession().getAttribute("blocked_table");
        if (action.equalsIgnoreCase("navigate")) {
            String level = request.getParameter("level");
            if (!Validators.correctInteger(level)) {
                this.gotoMasa(idMasaSession + "", response);
                return;
            }
            int levelInt = Integer.parseInt(level);
            int idItemInt = 0;
            String item = request.getParameter("idItem");
            if (!Validators.correctInteger(item)) {
                this.gotoMasa(idMasaSession + "", response);
                return;
            }
            idItemInt = Integer.parseInt(item);
            for (int i = levelInt + 1; i < 3; ++i) {
                request.getSession().removeAttribute("level_" + i);
            }
            request.getSession().setAttribute("level_" + levelInt, (Object)idItemInt);
        }
        if (action.equalsIgnoreCase("addProduct")) {
            String item;
            String pageS = request.getParameter("page");
            int currentPage = 0;
            if (Validators.correctInteger(pageS)) {
                currentPage = Integer.parseInt(pageS);
            }
            if (Validators.correctInteger(item = request.getParameter("idProduct"))) {
                int idProduct = Integer.parseInt(item);
                Order o3 = this.createOrderIfNull(request);
                if (!o3.isLaPlata()) {
                    Product product = NomeclaturaLogic.getInstance().getProductById(idProduct);
                    String key = this.getKey(product, o3);
                    Vector<Sale> tempSales = (Vector<Sale>)request.getSession().getAttribute(key);
                    if (tempSales == null) {
                        tempSales = new Vector<Sale>();
                        request.getSession().setAttribute(key, tempSales);
                    }
                    boolean found = false;
                    for (Sale element : tempSales) {
                        if (element.getIdProduct() != product.getId()) continue;
                        found = true;
                        element.setCantitateNoua(element.getCantitateNoua() + 1.0);
                    }
                    if (!found) {
                        long now = System.currentTimeMillis();
                        Sale ts = RestLogic.getInstance().buildSale(product, 0.0, 1.0, "", -1, -1, -1, -1, -1, now, 0);
                        tempSales.add(ts);
                    }
                }
                this.gotoMasa(idMasaSession + "&page=" + currentPage, response);
                return;
            }
            this.gotoMasa(idMasaSession + "&page=" + currentPage, response);
            return;
        }
        if (action.equalsIgnoreCase("stergeProdus")) {
            String item = request.getParameter("idProduct");
            if (Validators.correctInteger(item)) {
                int idProduct = Integer.parseInt(item);
                Order o4 = this.createOrderIfNull(request);
                Product product = NomeclaturaLogic.getInstance().getProductById(idProduct);
                String key = this.getKey(product, o4);
                Vector tempSales = (Vector)request.getSession().getAttribute(key);
                if (tempSales != null) {
                    for (Sale element : tempSales) {
                        if (element.getIdProduct() != product.getId()) continue;
                        if (!(element.getCantitateNoua() > 0.0)) break;
                        element.setCantitateNoua(element.getCantitateNoua() - 1.0);
                        break;
                    }
                }
                response.sendRedirect("masa?action=verifica");
                return;
            }
            this.gotoMasa(idMasaSession + "", response);
            return;
        }
        if (action.equalsIgnoreCase("confirma")) {
            o = this.createOrderIfNull(request);
            if (o != null && !o.isLaPlata()) {
                Vector<Sectie> sectii = NomeclaturaLogic.getInstance().getAllSectii();
                for (int i = 0; i < sectii.size(); ++i) {
                    Sectie sectie = sectii.elementAt(i);
                    String key = this.getKey(sectie, o);
                    Vector tempSales = (Vector)request.getSession().getAttribute(key);
                    if (tempSales == null) continue;
                    int idTable = (Integer)request.getSession().getAttribute("blocked_table");
                    Table t = RestLogic.getInstance().getTableById(idTable);
                    Vector<Sale> filterForZeros = new Vector<Sale>();
                    for (int j = 0; j < tempSales.size(); ++j) {
                        Sale sale = (Sale)tempSales.elementAt(j);
                        if (!(sale.getCantitateNoua() > 0.0)) continue;
                        filterForZeros.add(sale);
                    }
                    RestLogic.getInstance().productsSold(filterForZeros, o, t, sectie, false, null);
                    Vector newProducts = new Vector();
                    request.getSession().setAttribute(key, newProducts);
                }
                response.sendRedirect("masa?action=verifica");
                return;
            }
            this.gotoMasa(idMasaSession + "", response);
            return;
        }
        if (action.equalsIgnoreCase("verifica")) {
            o = this.createOrderIfNull(request);
            if (o != null && !o.isLaPlata()) {
                String contentPrecomanda = FileUtils.readFileToString(FileUtils.getCurrentDir() + File.separator + "webapps/meniupda/precomanda.shtml");
                String precomandaEntry = FileUtils.readFileToString(FileUtils.getCurrentDir() + File.separator + "webapps/meniupda/precomanda_entry.shtml");
                String result = "";
                double total = 0.0;
                Vector<Sectie> sectii = NomeclaturaLogic.getInstance().getAllSectii();
                for (int i = 0; i < sectii.size(); ++i) {
                    Sectie sectie = sectii.elementAt(i);
                    String key = this.getKey(sectie, o);
                    Vector tempSales = (Vector)request.getSession().getAttribute(key);
                    if (tempSales == null) continue;
                    Iterator iter = tempSales.iterator();
                    while (iter.hasNext()) {
                        String line = new String(precomandaEntry);
                        Sale element = (Sale)iter.next();
                        line = line.replaceAll("%%produs%%", element.getProductName());
                        double cant = element.getCantitateNoua();
                        line = line.replaceAll("%%cantitate%%", Utils.getString3Decimals(cant));
                        line = line.replaceAll("%%item%%", element.getIdProduct() + "");
                        line = line.replaceAll("%%valoare%%", Utils.getString2Decimals(element.getTotal()));
                        result = result + line + "\n";
                        total += element.getTotal();
                    }
                }
                contentPrecomanda = contentPrecomanda.replaceAll("%%content%%", result);
                contentPrecomanda = contentPrecomanda.replaceAll("%%total%%", Utils.getString2Decimals(total));
                this.sendResponse(contentPrecomanda, response, request);
                return;
            }
            this.gotoMasa(idMasaSession + "", response);
            return;
        }
        if (action.equalsIgnoreCase("requestunblock") || idMasaSession == null) {
            content = FileUtils.readFileToString(FileUtils.getCurrentDir() + File.separator + "webapps/meniupda/block_table.shtml");
            String idMasaParam = request.getParameter("idMasa");
            if (!Validators.correctInteger(idMasaParam)) {
                response.sendRedirect("locatii");
                return;
            }
            content = content.replaceAll("%%idMasa%%", idMasaParam + "");
            this.sendResponse(content, response, request);
            return;
        }
        content = FileUtils.readFileToString(FileUtils.getCurrentDir() + File.separator + "webapps/meniupda/masa.shtml");
        String key0 = "level_0_Nav";
        String levelNav = FileUtils.readFileToString(FileUtils.getCurrentDir() + File.separator + "webapps/meniupda/" + key0 + ".shtml");
        content = content.replaceAll("%%" + key0 + "%%", levelNav);
        int maxLevelAvailable = 0;
        int maxLevelItem = 0;
        for (int i = 0; i < 3; ++i) {
            Integer item = (Integer)request.getSession().getAttribute("level_" + i);
            String key = "level_" + i + "_Nav";
            if (item != null) {
                levelNav = FileUtils.readFileToString(FileUtils.getCurrentDir() + File.separator + "webapps/meniupda/" + key + ".shtml");
                NavigationObject nav = this.getNavigationItem(item, request, i);
                String navName = "";
                String itemId = "";
                if (nav != null) {
                    navName = nav.name;
                    itemId = nav.id + "";
                }
                levelNav = levelNav.replaceAll("%%label%%", navName);
                levelNav = levelNav.replaceAll("%%idItem%%", itemId);
                content = content.replaceAll("%%" + key + "%%", levelNav);
                maxLevelAvailable = i;
                maxLevelItem = item;
                continue;
            }
            content = content.replaceAll("%%" + key + "%%", "&nbsp;");
        }
        String pageS = request.getParameter("page");
        int currentPage = 0;
        if (Validators.correctInteger(pageS)) {
            currentPage = Integer.parseInt(pageS);
        }
        int itemsPerLine = 0;
        int linesPerPage = 0;
        switch (maxLevelAvailable) {
            case 0: {
                itemsPerLine = 10;
                linesPerPage = 5;
                break;
            }
            case 1: {
                itemsPerLine = VpConfig.getInstance().meniupdaCategoriesPerLine;
                linesPerPage = VpConfig.getInstance().meniupdaCategoriesLinesPerPage;
                break;
            }
            case 2: {
                itemsPerLine = VpConfig.getInstance().meniupdaItemsPerLine;
                linesPerPage = VpConfig.getInstance().meniupdaLinesPerPage;
            }
        }
        int itemsPerPage = itemsPerLine * linesPerPage;
        Vector items = this.updateContent(maxLevelAvailable, maxLevelItem, RestLogic.getInstance(), request);
        String contentJos = this.buildContent(items, itemsPerLine, linesPerPage, currentPage);
        request.getSession().setAttribute("content_" + (maxLevelAvailable + 1), (Object)items);
        int maxPages = items.size() / itemsPerPage;
        if (items.size() % itemsPerPage > 0) {
            ++maxPages;
        }
        String paginare = "";
        if (maxPages > 1) {
            paginare = this.buildPaginare(maxLevelAvailable, maxLevelItem, idMasaSession, currentPage, maxPages);
        }
        content = content.replaceAll("%%paginare%%", paginare);
        content = content.replaceAll("%%content%%", contentJos);
        this.sendResponse(content, response, request);
    }

    private void gotoMasa(String idMasa, HttpServletResponse response) throws IOException {
        response.sendRedirect("masa?idMasa=" + idMasa);
    }

    private void sendResponse(String content, HttpServletResponse response, HttpServletRequest request) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        catch (IllegalStateException e) {
            out = response.getWriter();
        }
        response.setContentType("text/html");
        File f = new File("webapps/meniupda/big.shtml");
        String fullFile = FileUtils.readFileToString(f.getAbsolutePath());
        fullFile = fullFile.replaceAll("%%entity%%", Config.getInstance().getString("entityName"));
        fullFile = fullFile.replaceAll("%%meniupdaPageHeight%%", VpConfig.getInstance().meniupdaPageHeight + "");
        fullFile = fullFile.replaceAll("%%meniupdaPageWidth%%", VpConfig.getInstance().meniupdaPageWidth + "");
        fullFile = fullFile.replaceAll("%%content%%", content);
        Integer idMasaSession = (Integer)request.getSession().getAttribute("blocked_table");
        if (idMasaSession != null) {
            String footer = FileUtils.readFileToString(FileUtils.getCurrentDir() + File.separator + "webapps/meniupda/masa_footer.shtml");
            footer = footer.replaceAll("%%idMasa%%", idMasaSession + "");
            fullFile = fullFile.replaceAll("%%footer%%", footer);
        } else {
            fullFile = fullFile.replaceAll("%%footer%%", "");
        }
        out.write(fullFile);
        out.flush();
    }

    private NavigationObject getNavigationItem(int itemId, HttpServletRequest request, int level) throws IOException {
        Vector items = (Vector)request.getSession().getAttribute("content_" + level);
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                NavigationObject navigationObject = (NavigationObject)items.elementAt(i);
                if (navigationObject.id != itemId) continue;
                return navigationObject;
            }
        }
        return null;
    }

    private Vector updateContent(int level, int itemId, RestLogic logic, HttpServletRequest request) {
        Vector<NavigationObject> items = new Vector<NavigationObject>();
        switch (level) {
            case 0: {
                Vector categories = logic.getSectii();
                for (Sectie element : categories) {
                    NavigationObject nav = new NavigationObject();
                    nav.id = element.getId();
                    nav.level = 1;
                    nav.name = element.getName();
                    items.add(nav);
                }
                break;
            }
            case 1: {
                Vector subcats = NomeclaturaLogic.getInstance().getCategoriiForcedOrder(itemId);
                for (Categorie element : subcats) {
                    NavigationObject nav = new NavigationObject();
                    nav.id = element.getId();
                    nav.level = 2;
                    nav.name = element.getName();
                    items.add(nav);
                }
                break;
            }
            case 2: {
                Categorie sc = NomeclaturaLogic.getInstance().getCategoryById(itemId);
                Vector produse = NomeclaturaLogic.getInstance().getProductsForCategorie(sc);
                for (Product element : produse) {
                    String fullPath;
                    NavigationObject nav = new NavigationObject();
                    nav.id = element.getId();
                    nav.level = 3;
                    nav.name = element.getName();
                    nav.pret = Utils.getString2Decimals(RestLogic.getInstance().getPriceForProductCommit(element.getId()));
                    ProductIcon icon = NomeclaturaLogic.getInstance().loadIcon(element.getId(), "webapps/meniupda/productimages", -1);
                    if (icon != null && (fullPath = icon.getFullPath()) != null) {
                        File f = new File(fullPath);
                        String s = f.getPath();
                        int startCut = s.indexOf("productimages");
                        nav.picture = s = s.substring(startCut, s.length());
                    }
                    items.add(nav);
                }
                break;
            }
        }
        return items;
    }

    private String buildContent(Vector content, int productsPerLine, int productLinesPerPage, int currentPage) {
        try {
            String result = "";
            int maxItemsPerPage = productsPerLine * productLinesPerPage;
            int currentLine = 0;
            int i = currentPage * maxItemsPerPage;
            while (i < content.size()) {
                NavigationObject element = (NavigationObject)content.elementAt(i);
                String newLine = "";
                String key = "level_" + element.level + "_";
                File f = new File("webapps/meniupda/" + key + "Content.shtml");
                newLine = FileUtils.readFileToString(f.getAbsolutePath());
                newLine = newLine.replaceAll("%%picture%%", element.picture + "");
                newLine = newLine.replaceAll("%%picture_height%%", VpConfig.getInstance().meniupdaPictureHeight + "");
                newLine = newLine.replaceAll("%%picture_width%%", VpConfig.getInstance().meniupdaPictureWidth + "");
                newLine = newLine.replaceAll("%%level%%", element.level + "");
                newLine = newLine.replaceAll("%%item%%", element.id + "");
                newLine = newLine.replaceAll("%%name%%", element.name + "");
                newLine = newLine.replaceAll("%%pret%%", element.pret + "");
                newLine = newLine.replaceAll("%%page%%", currentPage + "");
                result = result + newLine + "\n";
                if (++i % productsPerLine == 0) {
                    result = result + "</tr>\n<tr>";
                    ++currentLine;
                }
                if (currentLine <= productLinesPerPage - 1) continue;
                break;
            }
            return result;
        }
        catch (IOException e) {
            Logger.logException((Object)this, (Exception)e);
            return "";
        }
    }

    private String buildPaginare(int level, int idCategorie, int idMasa, int currentPage, int maxPages) {
        String prevPage = "<td id=\"link\" width=\"30%\">&nbsp;</td>";
        if (currentPage > 0) {
            prevPage = "<td  width=\"30%\"  id=\"link\"><a href=\"masa?action=navigate&level=%%level%%&masa=%%id%%&idItem=%%item%%&page=%%page%%\" class=\"alb\" >Prev page</a></td>";
            prevPage = prevPage.replaceAll("%%level%%", level + "");
            prevPage = prevPage.replaceAll("%%item%%", idCategorie + "");
            prevPage = prevPage.replaceAll("%%id%%", idMasa + "");
            prevPage = prevPage.replaceAll("%%page%%", currentPage - 1 + "");
        }
        String nextPage = "<td id=\"link\" width=\"30%\">&nbsp;</td>";
        if (currentPage < maxPages - 1) {
            nextPage = "<td width=\"30%\" id=\"link\"><a href=\"masa?action=navigate&level=%%level%%&masa=%%id%%&idItem=%%item%%&page=%%page%%\" class=\"alb\" >Next page</a></td>";
            nextPage = nextPage.replaceAll("%%level%%", level + "");
            nextPage = nextPage.replaceAll("%%item%%", idCategorie + "");
            nextPage = nextPage.replaceAll("%%id%%", idMasa + "");
            nextPage = nextPage.replaceAll("%%page%%", currentPage + 1 + "");
        }
        return prevPage + " <td width=\"40%\" id=\"link\" > Pagina " + (currentPage + 1) + " / " + maxPages + " </td> " + nextPage;
    }

    private Order createOrderIfNull(HttpServletRequest request) {
        int idTable = (Integer)request.getSession().getAttribute("blocked_table");
        Table currentTable = RestLogic.getInstance().getTableById(idTable);
        Order o = RestLogic.getInstance().getOpenOrderAtTable(currentTable);
        if (o == null) {
            User u = (User)request.getSession().getAttribute("user");
            o = RestLogic.getInstance().newOrder(idTable, u.getId());
        }
        return o;
    }

    private String getKey(Product product, Order o) {
        Sectie c2 = NomeclaturaLogic.getInstance().getSectieByCategoryId(product.getIdCategorie());
        return this.getKey(c2, o);
    }

    private String getKey(Sectie sectie, Order o) {
        String key = o.getUser() + "_" + o.getTable() + "_" + sectie.getId();
        return key;
    }

    class NavigationObject {
        String name;
        int level;
        int id;
        String picture = "";
        String pret = "";

        NavigationObject() {
        }
    }
}

