/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.meniupda;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Order;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.Validators;

public class MeniuPDAMeseServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getSession().getAttribute("user") == null) {
            response.sendRedirect("login");
            return;
        }
        String locatieParam = request.getParameter("idLocatie");
        if (!Validators.correctInteger(locatieParam)) {
            response.sendRedirect("locatii");
        }
        int idLocatie = Integer.parseInt(locatieParam);
        Vector<Table> tables = RestLogic.getInstance().getTablesByLocation(idLocatie);
        String mese = this.replaceTables(tables, VpConfig.getInstance().meniupdaMesePerLine);
        String content = FileUtils.readFileToString(FileUtils.getCurrentDir() + File.separator + "webapps/meniupda/mese.shtml");
        content = content.replaceAll("%%mese%%", mese);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        catch (IllegalStateException e) {
            out = response.getWriter();
        }
        response.setContentType("text/html");
        File f = new File("webapps/meniupda/big.shtml");
        String fullFile = FileUtils.readFileToString(f.getAbsolutePath());
        fullFile = fullFile.replaceAll("%%entity%%", Config.getInstance().getString("entityName"));
        fullFile = fullFile.replaceAll("%%meniupdaPageHeight%%", VpConfig.getInstance().meniupdaPageHeight + "");
        fullFile = fullFile.replaceAll("%%meniupdaPageWidth%%", VpConfig.getInstance().meniupdaPageWidth + "");
        fullFile = fullFile.replaceAll("%%content%%", content);
        fullFile = fullFile.replaceAll("%%footer%%", "");
        out.write(fullFile);
        out.flush();
    }

    private String replaceTables(Vector tables, int tablesPerLine) throws IOException {
        String mes = "<tr>";
        int i = 1;
        File f = new File("webapps/meniupda/masa_entry.shtml");
        String masaEntry = FileUtils.readFileToString(f.getAbsolutePath());
        for (Table element : tables) {
            String currentMasa = new String(masaEntry);
            String bgColor = "";
            String fgColor = "";
            String ospatar = "";
            Order o = RestLogic.getInstance().getOpenOrderAtTable(element);
            if (o == null) {
                bgColor = "FFFFCC";
                fgColor = "";
                ospatar = "&nbsp;";
            } else if (o.isLaPlata()) {
                bgColor = "FF3333";
                fgColor = "class=\"alb\"";
            } else if (o.isProtocol()) {
                bgColor = "003300";
                fgColor = "class=\"alb\"";
            } else if (o.isClientFidel()) {
                bgColor = "FFCC44";
                fgColor = "";
            } else {
                bgColor = "FFFF66";
                fgColor = "";
            }
            if (o != null) {
                ospatar = UsersLogic.getInstance().getUserById(o.getUser()).getLogin();
            }
            currentMasa = currentMasa.replaceAll("%%ospatar%%", ospatar);
            currentMasa = currentMasa.replaceAll("%%fgcolor%%", fgColor);
            currentMasa = currentMasa.replaceAll("%%bgcolor%%", bgColor);
            currentMasa = currentMasa.replaceAll("%%idMasa%%", element.getId() + "");
            currentMasa = currentMasa.replaceAll("%%label%%", element.getLabel());
            mes = mes + currentMasa;
            if (i % tablesPerLine == 0) {
                mes = mes + "</tr>\n<tr>";
            }
            ++i;
        }
        return mes;
    }
}

