/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.acces.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.acces.contracte.StatusContractView;
import ro.atreides.acces.contracte.TipContract;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class SimpleClientAbonamentPanel
extends JDialog {
    private int idclient = -1;

    public SimpleClientAbonamentPanel(JFrame parent) {
        super((Frame)parent, true);
        this.display();
        this.pack();
        this.setVisible(true);
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        final SimpleClientAbonamentPanel parent = this;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.add((Component)new JLabel("Nume"), c);
        ++c.gridx;
        final JTextField nume = new JTextField(10);
        this.add((Component)nume, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Prenume"), c);
        ++c.gridx;
        final JTextField prenume = new JTextField(10);
        this.add((Component)prenume, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Abonament"), c);
        ++c.gridx;
        final JComboBox tipAbonament = new JComboBox();
        ComboUtils.replaceItemsForCombo(tipAbonament, ContracteLogic.getInstance().getTipuriContract(), false);
        this.add(tipAbonament, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Card"), c);
        ++c.gridx;
        final JTextField card = new JTextField(10);
        this.add((Component)card, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel(LangRoAll.promotie), c);
        ++c.gridx;
        final JComboBox promotie = new JComboBox();
        ComboUtils.replaceItemsForCombo(promotie, PromotionLogic.getInstance().getPromotions());
        this.add(promotie, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Plata partiala"), c);
        ++c.gridx;
        final JCheckBox plataPartiala = new JCheckBox();
        this.add((Component)plataPartiala, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Zile per plata"), c);
        ++c.gridx;
        final JTextField zilePerPlata = new JTextField(10);
        this.add((Component)zilePerPlata, c);
        ++c.gridy;
        c.gridx = 0;
        JButton salveaza = new JButton(LangRoAll.salveaza);
        salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String card1 = card.getText();
                String card2 = "";
                String nume1 = nume.getText();
                String prenume1 = prenume.getText();
                if (!Validators.correctString(nume1) && !Validators.correctString(prenume1)) {
                    DialogUtils.errorDialog(parent, "Completati numele sau prenumele", LangRoAll.nuPotContinua);
                    nume.setText("");
                    nume.requestFocus();
                }
                int idClient = SimpleClientAbonamentPanel.this.addPersFizica(nume1, prenume1);
                TipContract t = (TipContract)tipAbonament.getSelectedItem();
                int idPromotion = -1;
                if (ComboUtils.anythingButAllSelected(promotie)) {
                    Promotion p = (Promotion)promotie.getSelectedItem();
                    idPromotion = p.getId();
                }
                if (VpConfig.getInstance().abonamenteAutoGenerateCodCard) {
                    card1 = idClient + "_" + t.getId();
                }
                boolean pp = plataPartiala.isSelected();
                int nrZile = -1;
                if (pp) {
                    if (!Validators.correctInteger(zilePerPlata.getText())) {
                        DialogUtils.errorDialog(parent, "Numarul de zile pentru plata trebuie sa fie un numar", LangRoAll.nuPotContinua);
                        zilePerPlata.setText("");
                        zilePerPlata.requestFocus();
                        return;
                    }
                    nrZile = Integer.parseInt(zilePerPlata.getText());
                }
                if (!Validators.correctString(card1)) {
                    DialogUtils.errorDialog(parent, "Card incorect", LangRoAll.nuPotContinua);
                    card.setText("");
                    card.requestFocus();
                    return;
                }
                Vector<StatusContractView> contracte = ContracteLogic.getInstance().getStatusContracteByCard(card1);
                for (int i = 0; i < contracte.size(); ++i) {
                    StatusContractView scv = contracte.elementAt(i);
                    if (scv.getIdTipContract() == t.getId()) {
                        DialogUtils.errorDialog(parent, "Acest card este deja definit pentru tipul de abonament selectat", LangRoAll.nuPotContinua);
                        return;
                    }
                    if (scv.getIdClient() == idClient) continue;
                    DialogUtils.errorDialog(parent, "Acest card este deja folosit de un alt client", LangRoAll.nuPotContinua);
                    return;
                }
                ContracteLogic.getInstance().addContract(idClient, t.getId(), idPromotion, card1, card2, pp, nrZile);
                SimpleClientAbonamentPanel.this.idclient = idClient;
                SimpleClientAbonamentPanel.this.dispose();
            }
        });
        this.add((Component)salveaza, c);
        ++c.gridx;
        JButton renunta = new JButton(LangRoAll.renunta);
        renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SimpleClientAbonamentPanel.this.dispose();
            }
        });
        this.add((Component)renunta, c);
    }

    public int getIdclient() {
        return this.idclient;
    }

    private int addPersFizica(String nume, String prenume) {
        String phone = "";
        String adresa = "";
        String oras = "";
        String fax = "";
        String mobil = "";
        String email = "";
        String web = "";
        String loculNasterii = "";
        String cetatenie = "";
        String nationalitate = "";
        Date dataNasterii = new Date();
        Date dataNumeului = new Date();
        return ClientLogic.getInstance().addPersFizica(nume, prenume, adresa, 1, oras, -1, -1, -1, phone, fax, mobil, email, web, loculNasterii, cetatenie, nationalitate, dataNasterii, null, "", dataNumeului, "", true);
    }
}

