/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.afisajclientserial;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.restaurant.base.Meniu;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.logic.OrderEvent;
import ro.atreides.restaurant.logic.OrderEventReceiver;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;

public class Module
implements ro.atreides.utils.Module {
    private OutputStream outS;
    private SerialPort serialPort = null;
    private boolean connected = false;
    private Vector<String> outQueue = new Vector();
    private Map<OrderEvent.OrderEventTypes, String> messages = new Hashtable<OrderEvent.OrderEventTypes, String>();

    @Override
    public String getModuleName() {
        return "AfisajClientSerial";
    }

    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public void init(String[] cmdArgs, Hashtable runtimeObjects) throws ModuleInstantiationException {
        String params = Utils.getCmdlineValue("-afisajclientserialparams", cmdArgs, "/dev/ttyS0=9600=8=1=0");
        params = params.replace("/dev/", "");
        String millisBetweenMessages = Utils.getCmdlineValue("-showtimemillis", cmdArgs, "1000");
        final long millis = Long.parseLong(millisBetweenMessages);
        String message = "afisajclientserialparams : " + params + " millis : " + millis;
        Logger.logDebug(this, message);
        System.out.println(message);
        Vector p = Utils.splitString(params, '=');
        final String portName = (String)p.get(0);
        if (!Validators.correctString(portName)) {
            Logger.logError((Object)this, "Port serial incorect!!");
            Utils.systemExit();
        }
        String speedS = (String)p.get(1);
        final int speed = Integer.parseInt(speedS);
        String dataBitsS = (String)p.get(2);
        final int dataBits = Integer.parseInt(dataBitsS);
        String stopBitsS = (String)p.get(3);
        final int stopBits = Integer.parseInt(stopBitsS);
        String parityS = (String)p.get(4);
        final int parity = Integer.parseInt(parityS);
        this.processConfig("conf" + File.separator + "afisajclient.xml");
        Thread th = new Thread(){

            @Override
            public void run() {
                boolean showErr = true;
                block8: while (true) {
                    try {
                        while (true) {
                            if (!Module.this.connected) {
                                boolean buildOK = Module.this.buildPort(portName, speed, dataBits, stopBits, parity, showErr);
                                if (buildOK) {
                                    Module.this.connected = true;
                                    Logger.logDebug(this, "initializat port: " + portName);
                                    showErr = true;
                                } else {
                                    showErr = false;
                                    try {
                                        Thread.sleep(3000L);
                                        continue block8;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        continue;
                                    }
                                }
                            }
                            while (Module.this.connected) {
                                try {
                                    if (Module.this.outQueue.size() > 0) {
                                        Module.this.outS.write(((String)Module.this.outQueue.remove(0)).getBytes());
                                        Module.this.outS.flush();
                                        try {
                                            Thread.sleep(millis);
                                        }
                                        catch (InterruptedException e) {}
                                        continue;
                                    }
                                    Thread.sleep(100L);
                                }
                                catch (IOException e) {
                                    Logger.logException(this, (Exception)e);
                                    Module.this.connected = false;
                                }
                            }
                            if (Module.this.serialPort == null) continue;
                            Module.this.serialPort.close();
                        }
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        th.setName("AfisajClientSerial");
        th.start();
        RestLogic.getInstance().addOrderEventReceiver(new OrderEventReceiver(){

            @Override
            public void processEvent(OrderEvent event) {
                Vector<String[]> values = new Vector<String[]>();
                OrderEvent.OrderEventTypes type = event.getEventType();
                switch (type) {
                    case OPEN: {
                        break;
                    }
                    case CLOSE: {
                        break;
                    }
                    case SALE_ADDED: {
                        Sale s = (Sale)event.getValue();
                        String produs = s.getProductName();
                        String cant = Utils.getString2Decimals(s.getCantitateNoua());
                        String price = Utils.getString2Decimals(s.getPrice());
                        String total = Utils.getString2Decimals(s.getTotal());
                        values.add(new String[]{produs, cant, price, total});
                        break;
                    }
                    case SALE_SAVED: {
                        String total;
                        String price;
                        String cant;
                        String produs;
                        Vector sales = (Vector)event.getValue();
                        for (Sale s1 : sales) {
                            produs = s1.getProductName();
                            cant = Utils.getString2Decimals(s1.getCantitateNoua());
                            price = Utils.getString2Decimals(s1.getPrice());
                            total = Utils.getString2Decimals(s1.getTotal());
                            values.add(new String[]{produs, cant, price, total});
                        }
                        break;
                    }
                    case MENU_ADDED: {
                        Meniu m = (Meniu)event.getValue();
                        String mt = m.getLabel();
                        values.add(new String[]{mt});
                        break;
                    }
                    case REST: {
                        Double d = (Double)event.getValue();
                        values.add(new String[]{Utils.getString2Decimals(d)});
                        break;
                    }
                    case SALE_DELETED: 
                    case SALE_RETUR: {
                        Hashtable hash = (Hashtable)event.getValue();
                        Iterator i$ = hash.keySet().iterator();
                        if (!i$.hasNext()) break;
                        Sale sale = (Sale)i$.next();
                        String product = sale.getProductName();
                        Double qRetur = (Double)hash.get(sale);
                        String q = Utils.getString2Decimals(qRetur);
                        double pret = sale.getPrice();
                        String pretS = Utils.getString2Decimals(pret);
                        double value = pret * qRetur;
                        String valueS = Utils.getString2Decimals(value);
                        values.add(new String[]{product, q, pretS, valueS});
                        break;
                    }
                    case PAYMENT: {
                        Plata p = (Plata)event.getValue();
                        int tipPlataId = p.getIdTipPlata();
                        TipPlata tp = TipPlataProvider.getInstance().getTipPlataById(tipPlataId);
                        String tpLabel = tp.getLabel();
                        String val = Utils.getString2Decimals(p.getSuma());
                        values.add(new String[]{tpLabel, val});
                    }
                }
                for (String[] value : values) {
                    String result = Module.this.getResultString(type, value);
                    if (result == null) continue;
                    String max = Utils.getStringMaxSize(20, result, Character.valueOf(' '), false);
                    Module.this.outQueue.add('\f' + max);
                }
            }
        });
    }

    private String getResultString(OrderEvent.OrderEventTypes type, String[] values) {
        String template = this.messages.get((Object)type);
        if (template == null) {
            return null;
        }
        template = template.replace("__new_line__", "\r\n");
        String res = MessageFormat.format(template, values);
        Logger.logDebug(this, "Resultstring : \"" + res + "\"");
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConfig(String configFile) {
        try {
            Utils.importXml(new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equalsIgnoreCase("message")) {
                        OrderEvent.OrderEventTypes type = OrderEvent.OrderEventTypes.valueOf(attributes.getValue("type"));
                        String text = attributes.getValue("text");
                        Module.this.messages.put(type, text);
                    }
                }
            }, configFile);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SAXException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private boolean buildPort(String portName, int speed, int dataBits, int stopBits, int parity, boolean showErr) {
        try {
            boolean portFound = false;
            CommPortIdentifier portId = null;
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                portId = (CommPortIdentifier)portList.nextElement();
                String shortPortName = portName.replace("/dev/", "");
                String curentElementPortName = portId.getName();
                if (!curentElementPortName.equalsIgnoreCase(portName) && !curentElementPortName.equalsIgnoreCase(shortPortName)) continue;
                Logger.logDebug(this, "Found port: " + portName);
                portFound = true;
                break;
            }
            if (!portFound) {
                if (showErr) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "AfisajClientSerial: port incorect : \"" + portName + "\"", LangRoAll.nuPotContinua);
                }
                Logger.logDebug(this, "Port incorect: " + portName);
                return false;
            }
            PortSettingsPureJava settings = new PortSettingsPureJava();
            settings.setName(portName);
            settings.setSpeed(speed);
            settings.setDataBits(dataBits);
            settings.setStopBits(stopBits);
            settings.setPariry(parity);
            Logger.logInfo(Utils.class.getName(), ">>>>> Opening port: " + portName + "");
            this.serialPort = (SerialPort)portId.open("AfisajClientSerial", 2000);
            this.outS = this.serialPort.getOutputStream();
            this.serialPort.setSerialPortParams(settings.getSpeed(), settings.getDataBits(), settings.getStopBits(), settings.getPariry());
            Logger.logInfo(this, "Setari port serial DUPA setParams : baudRate=" + this.serialPort.getBaudRate() + " dataBits=" + this.serialPort.getDataBits() + " stopBits=" + this.serialPort.getStopBits() + " parity=" + this.serialPort.getParity());
            return true;
        }
        catch (PortInUseException e) {
            Logger.logError((Object)this, "AfisajClientSerial: port ocupat : \"" + portName + "\"");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }
}

