/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.asterisk;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionFactory;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.StatusAction;
import org.asteriskjava.manager.event.BridgeEvent;
import org.asteriskjava.manager.event.HangupEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ModuleInstantiationException;

public class Module
implements ro.atreides.utils.Module {
    private ManagerConnection managerConnection;

    @Override
    public String getModuleName() {
        return "AsteriskEventListener";
    }

    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public void init(String[] cmdArgs, Hashtable runtimeObjects) throws ModuleInstantiationException {
        String ip = VpConfig.getInstance().asteriskIP;
        String user = VpConfig.getInstance().asteriskUser;
        String passwd = VpConfig.getInstance().asteriskPassword;
        ManagerConnectionFactory factory = new ManagerConnectionFactory(ip, user, passwd);
        this.managerConnection = factory.createManagerConnection();
        this.managerConnection.addEventListener(new ManagerEventListener(){

            @Override
            public void onManagerEvent(ManagerEvent event) {
                if (event instanceof BridgeEvent) {
                    BridgeEvent be = (BridgeEvent)event;
                    RestLogic.getInstance().pickup(be.getCallerid1(), be.getChannel2());
                }
                if (event instanceof HangupEvent) {
                    HangupEvent he = (HangupEvent)event;
                    RestLogic.getInstance().hangup(he.getCallerIdNum(), he.getChannel());
                }
            }
        });
        Thread th = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        Module.this.managerConnection.login();
                        Module.this.managerConnection.sendAction(new StatusAction());
                    }
                    catch (IOException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    catch (AuthenticationFailedException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    catch (TimeoutException e) {
                        Logger.logException(this, (Exception)e);
                    }
                    catch (Throwable th) {
                        Logger.logError((Object)this, th);
                    }
                    finally {
                        Module.this.managerConnection.logoff();
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        th.setName("AsteriskEventThread");
        th.start();
    }
}

