/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.contracte;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.acces.contracte.StatusContractView;
import ro.atreides.acces.contracte.TipContract;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.print.PrintLogic;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ObjectEventListener;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.JMultilineLabel;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.CardInputDialog;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class StatusContracte
extends AbstractReportPanel {
    private static final String[] columns = new String[]{LangRoAll.client, "Abonament", LangRoAll.promotie, LangRoAll.status, "Card", "Plata partiala", "Zile per plata"};
    private static final Class[] types = new Class[]{String.class, String.class, String.class, String.class, String.class, Boolean.class, String.class};
    private ReportInterface pdfReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private JMultilineLabel total;
    private JComboBox clienti;
    private JComboBox abonamente;
    private JComboBox status;
    private JComboBox clientiT;
    private JComboBox abonamenteT;
    private JComboBox promotii;
    private JCheckBox plataPartiala;
    private JTextField card;
    private JTextField nrZilePlataPartiala;
    private StatusContractView toEdit;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Comparable cat;
        Hashtable<String, Integer> result = new Hashtable<String, Integer>();
        this.printCriteria.put("Data raport", Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(new Date()));
        if (ComboUtils.anythingButAllSelected(this.clienti)) {
            cat = (Client)this.clienti.getSelectedItem();
            result.put(Constants.CLIENT_KEY, ((Client)cat).getId());
            this.printCriteria.put(Constants.CLIENT_KEY, cat.toString());
        } else {
            this.printCriteria.remove(Constants.CLIENT_KEY);
        }
        if (ComboUtils.anythingButAllSelected(this.abonamente)) {
            cat = (TipContract)this.abonamente.getSelectedItem();
            result.put("Tip abonament", ((TipContract)cat).getId());
            this.printCriteria.put("Tip abonament", ((TipContract)cat).toString());
        } else {
            this.printCriteria.remove("Tip abonament");
        }
        String tipValue = (String)this.status.getSelectedItem();
        if (!tipValue.equalsIgnoreCase("All")) {
            int value = -1;
            if (tipValue.equalsIgnoreCase("ACTIV")) {
                value = 1;
            } else if (tipValue.equalsIgnoreCase("GRACED")) {
                value = 3;
            } else if (tipValue.equalsIgnoreCase("RENEW")) {
                value = 2;
            } else if (tipValue.equalsIgnoreCase("SUSPENDAT")) {
                value = 4;
            }
            result.put(Constants.STATUS_CONTRACT_KEY, value);
            this.printCriteria.put(Constants.STATUS_CONTRACT_KEY, tipValue);
        } else {
            this.printCriteria.remove(Constants.STATUS_CONTRACT_KEY);
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel categPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        categPanel.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        this.clienti = new JComboBox();
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        categPanel.add((Component)this.clienti, c);
        c.gridx = 0;
        ++c.gridy;
        categPanel.add((Component)new JLabel("Abonament"), c);
        ++c.gridx;
        this.abonamente = new JComboBox();
        this.abonamente.setPrototypeDisplayValue("111111111111111111111111111111111");
        categPanel.add((Component)this.abonamente, c);
        c.gridx = 0;
        ++c.gridy;
        categPanel.add((Component)new JLabel(LangRoAll.status), c);
        ++c.gridx;
        this.status = new JComboBox();
        this.status.setPrototypeDisplayValue("111111111111111111111111111111111");
        categPanel.add((Component)this.status, c);
        return categPanel;
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM model = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                StatusContractView scv = (StatusContractView)data.elementAt(rowIndex);
                if (scv == null) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return scv.getNumeClient();
                    }
                    case 1: {
                        return scv.getNumeContract();
                    }
                    case 2: {
                        return scv.getPromotie();
                    }
                    case 3: {
                        return scv.getNumeStatus();
                    }
                    case 4: {
                        return scv.getCard();
                    }
                    case 5: {
                        return new Boolean(scv.isPlataPartiala());
                    }
                    case 6: {
                        return scv.getNrZilePlataPartiala();
                    }
                }
                return null;
            }
        });
        return model;
    }

    public void setObjectToEdit(StatusContractView scv) {
        String card1 = "";
        String cardTemp1 = "";
        if (scv != null) {
            card1 = scv.getCard();
            cardTemp1 = scv.getCardTemporar();
            int idClient = scv.getIdClient();
            Client c = ClientLogic.getInstance().getClientById(idClient);
            this.clientiT.setSelectedItem(c);
            int idContract = scv.getIdTipContract();
            TipContract tc = ContracteLogic.getInstance().getTipContractById(idContract);
            this.abonamenteT.setSelectedItem(tc);
            int idPromotion = scv.getIdPromotie();
            Promotion p = PromotionLogic.getInstance().getPromotionById(idPromotion);
            if (p != null) {
                this.promotii.setSelectedItem(p);
            } else {
                this.promotii.setSelectedIndex(0);
            }
            if (scv.isPlataPartiala()) {
                this.nrZilePlataPartiala.setText(scv.getNrZilePlataPartiala() + "");
            } else {
                this.nrZilePlataPartiala.setText("");
            }
            this.plataPartiala.setSelected(scv.isPlataPartiala());
            this.nrZilePlataPartiala.setEditable(scv.isPlataPartiala());
            this.nrZilePlataPartiala.setEnabled(scv.isPlataPartiala());
        } else {
            this.plataPartiala.setSelected(false);
            this.nrZilePlataPartiala.setText("");
            this.nrZilePlataPartiala.setEditable(false);
            this.nrZilePlataPartiala.setEnabled(false);
        }
        this.card.setText(card1);
        this.toEdit = scv;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.clientiT = new JComboBox();
        result.add((Component)this.clientiT, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Card"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.card = new JTextField(10);
        this.card.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int clickCount = e.getClickCount();
                if (clickCount >= 2 && clickCount % 2 == 0) {
                    String cardCitit = StatusContracte.this.citireCard();
                    StatusContracte.this.card.setText(cardCitit);
                }
            }
        });
        result.add((Component)this.card, c);
        ++c.gridx;
        c.weightx = 0.0;
        JButton renunta = new JButton(LangRoAll.renunta);
        renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusContracte.this.setObjectToEdit(null);
            }
        });
        result.add((Component)renunta, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Abonament"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.abonamenteT = new JComboBox();
        result.add((Component)this.abonamenteT, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Plata partiala"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.plataPartiala = new JCheckBox();
        this.plataPartiala.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                StatusContracte.this.nrZilePlataPartiala.setEditable(StatusContracte.this.plataPartiala.isSelected());
                StatusContracte.this.nrZilePlataPartiala.setEnabled(StatusContracte.this.plataPartiala.isSelected());
            }
        });
        result.add((Component)this.plataPartiala, c);
        this.plataPartiala.setSelected(false);
        final StatusContracte parent = this;
        ++c.gridx;
        c.weightx = 0.0;
        JButton salveaza = new JButton(LangRoAll.salveaza);
        salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String card1 = StatusContracte.this.card.getText();
                String card2 = "";
                Client c = (Client)StatusContracte.this.clientiT.getSelectedItem();
                TipContract t = (TipContract)StatusContracte.this.abonamenteT.getSelectedItem();
                int idPromotion = -1;
                if (ComboUtils.anythingButAllSelected(StatusContracte.this.promotii)) {
                    Promotion p = (Promotion)StatusContracte.this.promotii.getSelectedItem();
                    idPromotion = p.getId();
                }
                if (VpConfig.getInstance().abonamenteAutoGenerateCodCard) {
                    card1 = c.getId() + "_" + t.getId();
                }
                boolean pp = StatusContracte.this.plataPartiala.isSelected();
                int nrZile = -1;
                if (pp) {
                    if (!Validators.correctInteger(StatusContracte.this.nrZilePlataPartiala.getText())) {
                        DialogUtils.errorDialog(parent, "Numarul de zile pentru plata trebuie sa fie un numar", LangRoAll.nuPotContinua);
                        StatusContracte.this.nrZilePlataPartiala.setText("");
                        StatusContracte.this.nrZilePlataPartiala.requestFocus();
                        return;
                    }
                    nrZile = Integer.parseInt(StatusContracte.this.nrZilePlataPartiala.getText());
                }
                if (Validators.correctString(card1)) {
                    Vector<StatusContractView> contracte = ContracteLogic.getInstance().getStatusContracteByCard(card1);
                    if (StatusContracte.this.toEdit == null) {
                        for (int i = 0; i < contracte.size(); ++i) {
                            StatusContractView scv = contracte.elementAt(i);
                            if (scv.getIdTipContract() == t.getId()) {
                                DialogUtils.errorDialog(parent, "Acest card este deja definit pentru tipul de abonament selectat", LangRoAll.nuPotContinua);
                                return;
                            }
                            if (scv.getIdClient() == c.getId()) continue;
                            DialogUtils.errorDialog(parent, "Acest card este deja folosit de un alt client", LangRoAll.nuPotContinua);
                            return;
                        }
                        ContracteLogic.getInstance().addContract(c.getId(), t.getId(), idPromotion, card1, card2, pp, nrZile);
                    } else {
                        for (int i = 0; i < contracte.size(); ++i) {
                            StatusContractView scv = contracte.elementAt(i);
                            if (scv.getId() == StatusContracte.this.toEdit.getId()) continue;
                            if (scv.getIdTipContract() == t.getId()) {
                                DialogUtils.errorDialog(parent, "Acest card este deja definit pentru tipul de abonament selectat", LangRoAll.nuPotContinua);
                                return;
                            }
                            if (scv.getIdClient() == c.getId()) continue;
                            DialogUtils.errorDialog(parent, "Acest card este deja folosit de un alt client", LangRoAll.nuPotContinua);
                            return;
                        }
                        StatusContracte.this.toEdit.setIdClient(c.getId());
                        StatusContracte.this.toEdit.setIdTipContract(t.getId());
                        StatusContracte.this.toEdit.setCard(card1);
                        StatusContracte.this.toEdit.setCardTemporar(card2);
                        StatusContracte.this.toEdit.setIdPromotie(idPromotion);
                        StatusContracte.this.toEdit.setPlataPartiala(pp);
                        StatusContracte.this.toEdit.setNrZilePlataPartiala(nrZile);
                        ContracteLogic.getInstance().updateContract(StatusContracte.this.toEdit);
                    }
                    StatusContracte.this.raport();
                    StatusContracte.this.setObjectToEdit(null);
                    StatusContracte.this.card.requestFocus();
                } else {
                    DialogUtils.errorDialog(parent, "Card incorect", LangRoAll.nuPotContinua);
                    StatusContracte.this.card.setText("");
                    StatusContracte.this.card.requestFocus();
                }
            }
        });
        result.add((Component)salveaza, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.promotie), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.promotii = new JComboBox();
        result.add((Component)this.promotii, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Zile per plata"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nrZilePlataPartiala = new JTextField(10);
        result.add((Component)this.nrZilePlataPartiala, c);
        this.nrZilePlataPartiala.setEditable(false);
        this.nrZilePlataPartiala.setEnabled(false);
        ++c.gridx;
        c.weightx = 0.0;
        JButton sterge = new JButton(LangRoAll.sterge);
        sterge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DialogUtils.confirmDialog(parent, "Stergem acest contract", LangRoAll.confirmare)) {
                    return;
                }
                ContracteLogic.getInstance().deleteContract(StatusContracte.this.toEdit);
                StatusContracte.this.raport();
                StatusContracte.this.setObjectToEdit(null);
            }
        });
        result.add((Component)sterge, c);
        result.setBorder(new TitledBorder("Salvare/stergere"));
        return result;
    }

    private String citireCard() {
        final StringBuffer card = new StringBuffer();
        EventGenerator soyal = RestLogic.getInstance().getAccesInterface();
        if (soyal != null) {
            System.out.println("StatusContracte: 1");
            final CardInputDialog dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().codFidelitateLength);
            ObjectEventListener l = new ObjectEventListener(){

                @Override
                public void dataChanged(Object o) {
                    System.out.println("Object Listener received data : " + o.toString());
                    card.append(o);
                    dialog.dispose();
                }

                @Override
                public String getName() {
                    return "touch3_soyal_fidelitate";
                }
            };
            soyal.addObjectListener(l, 701);
            dialog.setVisible(true);
            soyal.removeObjectListener(l);
        } else {
            CardInputDialog dialog = new CardInputDialog((Frame)GuiUtils.currentFrame, true, VpConfig.getInstance().codFidelitateLength);
            dialog.setVisible(true);
            card.append(dialog.getCodAutentificare());
        }
        return card.toString();
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }

    @Override
    public String getName() {
        return "Abonamente";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        Vector<StatusContractView> result = ContracteLogic.getInstance().getContracte(criteria);
        for (int i = 0; i < result.size(); ++i) {
            StatusContractView scv = result.elementAt(i);
            scv.setNumeClient(ClientLogic.getInstance().getClientById(scv.getIdClient()).toString());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.pdfReportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.pdfReportInterface, null, this.data);
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    StatusContractView entry = (StatusContractView)o;
                    try {
                        Label label = new Label(0, row, entry.getNumeClient());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, entry.getNumeContract());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, entry.getPromotie());
                        sheet.addCell((WritableCell)label);
                        label = new Label(3, row, entry.getNumeStatus());
                        sheet.addCell((WritableCell)label);
                        label = new Label(4, row, entry.getCard());
                        sheet.addCell((WritableCell)label);
                        label = new Label(5, row, entry.isPlataPartiala() ? "Da" : "Nu");
                        sheet.addCell((WritableCell)label);
                        label = new Label(6, row, entry.getNrZilePlataPartiala() + "");
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return StatusContracte.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private void refreshClients() {
        ComboUtils.replaceItemsForCombo(this.clienti, ClientLogic.getInstance().getAllClientsSorted());
        ComboUtils.replaceItemsForCombo(this.clientiT, ClientLogic.getInstance().getAllClientsSorted(), false);
    }

    private void refreshAbonamente() {
        ComboUtils.replaceItemsForCombo(this.abonamente, ContracteLogic.getInstance().getTipuriContract());
        ComboUtils.replaceItemsForCombo(this.abonamenteT, ContracteLogic.getInstance().getTipuriContract(), false);
    }

    private void refreshPromotii() {
        ComboUtils.replaceItemsForCombo(this.promotii, PromotionLogic.getInstance().getPromotions());
    }

    @Override
    public void doStuff() {
        this.refreshClients();
        this.refreshAbonamente();
        this.refreshPromotii();
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                StatusContracte.this.refreshClients();
            }

            @Override
            public String getName() {
                return "StatusContracte_persFizica";
            }
        }, 41);
        ClientLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                StatusContracte.this.refreshClients();
            }

            @Override
            public String getName() {
                return "StatusContracte_persJuridica";
            }
        }, 42);
        ContracteLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                StatusContracte.this.refreshAbonamente();
            }

            @Override
            public String getName() {
                return "StatusContracte_abonamente";
            }
        }, 801);
        PromotionLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                StatusContracte.this.refreshPromotii();
            }

            @Override
            public String getName() {
                return "StatusContracte_promotii";
            }
        }, 8);
        this.pdfReportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return StatusContracte.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return StatusContracte.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                StatusContractView scv = (StatusContractView)row;
                if (scv == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        return scv.getNumeClient();
                    }
                    case 1: {
                        return scv.getNumeContract();
                    }
                    case 2: {
                        return scv.getPromotie();
                    }
                    case 3: {
                        return scv.getNumeStatus();
                    }
                    case 4: {
                        return scv.getCard();
                    }
                    case 5: {
                        return scv.isPlataPartiala() ? "Da" : "Nu";
                    }
                    case 6: {
                        return scv.getNrZilePlataPartiala() + "";
                    }
                }
                return null;
            }
        };
        this.status.addItem("All");
        this.status.addItem("ACTIV");
        this.status.addItem("RENEW");
        this.status.addItem("GRACED");
        this.status.addItem("SUSPENDAT");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = StatusContracte.this.table.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() >= 2) {
                    StatusContractView p = (StatusContractView)StatusContracte.this.tm.getObjectAt(selRow);
                    StatusContracte.this.setObjectToEdit(p);
                }
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

