/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.contracte;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.acces.contracte.ContracteLogic;
import ro.atreides.acces.contracte.TipContract;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.util.CompareUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;

public class TipContractePanel
extends AbstractListPanel {
    private JTextField nume;
    private JTextField perioada;
    private JTextField renew;
    private JTextField graced;
    private JTextField sedinte;
    private TipContract toEdit;
    private JComboBox produse;

    @Override
    public String[] buildColumns() {
        return new String[]{"Nume", "Perioada", LangRoAll.produs, "Nr sedinte", "Renew", "Graced"};
    }

    @Override
    public Vector buildData() {
        return ContracteLogic.getInstance().getTipuriContract();
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Nume"), c);
        ++c.gridx;
        this.nume = new JTextField(27);
        result.add((Component)this.nume, c);
        ++c.gridx;
        result.add((Component)new JLabel("Perioada"), c);
        ++c.gridx;
        this.perioada = new JTextField(5);
        result.add((Component)this.perioada, c);
        ++c.gridx;
        result.add((Component)new JLabel("Sedinte"), c);
        ++c.gridx;
        this.sedinte = new JTextField(5);
        result.add((Component)this.sedinte, c);
        c.fill = 2;
        final TipContractePanel parent = this;
        ++c.gridx;
        JButton salveaza = new JButton(LangRoAll.salveaza);
        salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String toAdd = TipContractePanel.this.nume.getText();
                if (Validators.correctString(toAdd)) {
                    String per = TipContractePanel.this.perioada.getText();
                    if (Validators.correctInteger(per)) {
                        String ren = TipContractePanel.this.renew.getText();
                        if (Validators.correctInteger(per)) {
                            String gra = TipContractePanel.this.graced.getText();
                            if (Validators.correctInteger(gra)) {
                                String sed = TipContractePanel.this.sedinte.getText();
                                if (Validators.correctInteger(sed)) {
                                    int per1 = Integer.parseInt(per);
                                    int sed1 = Integer.parseInt(sed);
                                    Product p = (Product)TipContractePanel.this.produse.getSelectedItem();
                                    if (p == null) {
                                        DialogUtils.errorDialog(parent, "Alegeti un produs", LangRoAll.nuPotContinua);
                                        return;
                                    }
                                    int ren1 = Integer.parseInt(ren);
                                    int gra1 = Integer.parseInt(gra);
                                    if (TipContractePanel.this.toEdit == null) {
                                        ContracteLogic.getInstance().addTipContract(toAdd, per1, p.getId(), ren1, gra1, sed1);
                                    } else {
                                        TipContractePanel.this.toEdit.setGraced(gra1);
                                        TipContractePanel.this.toEdit.setNume(toAdd);
                                        TipContractePanel.this.toEdit.setPerioada(per1);
                                        TipContractePanel.this.toEdit.setRenew(ren1);
                                        TipContractePanel.this.toEdit.setNrSedinte(sed1);
                                        TipContractePanel.this.toEdit.setIdProdus(p.getId());
                                        ContracteLogic.getInstance().updateTipContract(TipContractePanel.this.toEdit);
                                    }
                                    TipContractePanel.this.refreshTable();
                                    TipContractePanel.this.setObjectToEdit(null);
                                    TipContractePanel.this.nume.requestFocus();
                                } else {
                                    DialogUtils.errorDialog(parent, "Numar sedinte incorect. Alegeti -1 pentru nelimitate, sau > 0.", LangRoAll.nuPotContinua);
                                    TipContractePanel.this.sedinte.setText("");
                                    TipContractePanel.this.sedinte.requestFocus();
                                }
                            } else {
                                DialogUtils.errorDialog(parent, "Graced incorect", LangRoAll.nuPotContinua);
                                TipContractePanel.this.graced.setText("");
                                TipContractePanel.this.graced.requestFocus();
                            }
                        } else {
                            DialogUtils.errorDialog(parent, "Renew incorect", LangRoAll.nuPotContinua);
                            TipContractePanel.this.renew.setText("");
                            TipContractePanel.this.renew.requestFocus();
                        }
                    } else {
                        DialogUtils.errorDialog(parent, "Perioada incorecta", LangRoAll.nuPotContinua);
                        TipContractePanel.this.perioada.setText("");
                        TipContractePanel.this.perioada.requestFocus();
                    }
                } else {
                    DialogUtils.errorDialog(parent, "Nume incorect", LangRoAll.nuPotContinua);
                    TipContractePanel.this.nume.setText("");
                    TipContractePanel.this.nume.requestFocus();
                }
                TipContractePanel.this.setObjectToEdit(null);
            }
        });
        result.add((Component)salveaza, c);
        c.fill = 0;
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel(LangRoAll.produs), c);
        ++c.gridx;
        this.produse = new JComboBox();
        result.add((Component)this.produse, c);
        ++c.gridx;
        result.add((Component)new JLabel("Renew"), c);
        ++c.gridx;
        this.renew = new JTextField(5);
        result.add((Component)this.renew, c);
        ++c.gridx;
        result.add((Component)new JLabel("Graced"), c);
        ++c.gridx;
        this.graced = new JTextField(5);
        result.add((Component)this.graced, c);
        c.fill = 2;
        ++c.gridx;
        JButton sterge = new JButton(LangRoAll.sterge);
        sterge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogUtils.confirmDialog(parent, "Stergem acest tip de contract", LangRoAll.confirmare)) {
                    ContracteLogic.getInstance().deleteTipContract(TipContractePanel.this.toEdit);
                }
                TipContractePanel.this.refreshTable();
                TipContractePanel.this.setObjectToEdit(null);
                TipContractePanel.this.nume.requestFocus();
            }
        });
        result.add((Component)sterge, c);
        result.setBorder(new TitledBorder("Salvare/stergere"));
        return result;
    }

    public void setObjectToEdit(TipContract tipContract) {
        String nume = "";
        String perioada = "";
        String renew = "";
        String graced = "";
        String sed = "";
        if (tipContract != null) {
            nume = tipContract.getNume();
            perioada = tipContract.getPerioada() + "";
            renew = tipContract.getRenew() + "";
            graced = tipContract.getGraced() + "";
            sed = tipContract.getNrSedinte() + "";
            Product p = NomeclaturaLogic.getInstance().getProductById(tipContract.getIdProdus());
            if (p != null) {
                this.produse.setSelectedItem(p);
            }
        }
        this.sedinte.setText(sed);
        this.nume.setText(nume);
        this.perioada.setText(perioada);
        this.renew.setText(renew);
        this.graced.setText(graced);
        this.toEdit = tipContract;
    }

    @Override
    public AbstractTM buildTableModel() {
        return new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                TipContract tipContract = (TipContract)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return tipContract.getNume();
                    }
                    case 1: {
                        return tipContract.getPerioada() + "";
                    }
                    case 2: {
                        Product p = NomeclaturaLogic.getInstance().getProductById(tipContract.getIdProdus());
                        return p.getName();
                    }
                    case 3: {
                        return tipContract.getNrSedinte() + "";
                    }
                    case 4: {
                        return tipContract.getRenew() + "";
                    }
                    case 5: {
                        return tipContract.getGraced() + "";
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void doStuff() {
        this.display();
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow;
                if (e.getClickCount() >= 2 && (selRow = TipContractePanel.this.table.rowAtPoint(e.getPoint())) != -1) {
                    TipContract tc = (TipContract)TipContractePanel.this.tm.getObjectAt(selRow);
                    TipContractePanel.this.setObjectToEdit(tc);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.rebuildProductsCombo();
        EventListener productsListener = new EventListener(){

            @Override
            public void dataChanged() {
                TipContractePanel.this.rebuildProductsCombo();
            }

            @Override
            public String getName() {
                return "TipContractePanel_Products";
            }
        };
        RestLogic.getInstance().addListener(productsListener, 2);
    }

    public void rebuildProductsCombo() {
        this.produse.removeAllItems();
        Vector<Product> sorted = new Vector<Product>(NomeclaturaLogic.getInstance().getAllProducts(-1));
        Collections.sort(sorted, new Comparator(){

            public int compare(Object o1, Object o2) {
                return CompareUtils.compareProductsByName(o1, o2);
            }
        });
        for (Product element : sorted) {
            this.produse.addItem(element);
        }
    }
}

