/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.datecsfpemulator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class Module
implements ro.atreides.utils.Module {
    private InputStream inS;
    private OutputStream outS;

    @Override
    public String getModuleName() {
        return "serialbarcodereader";
    }

    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public void init(String[] cmdArgs, Hashtable runtimeObjects) throws ModuleInstantiationException {
        String params = Utils.getCmdlineValue("-datecsfpemulatorparams", cmdArgs, "/dev/ttyUSB0=9600=8=1=0");
        params = params.replace("/dev/", "");
        Logger.logDebug(this, "serialbarcodeparams : " + params);
        System.out.println("serialbarcodeparams : " + params);
        Vector p = Utils.splitString(params, '=');
        String portName = (String)p.get(0);
        String speedS = (String)p.get(1);
        int speed = Integer.parseInt(speedS);
        String dataBitsS = (String)p.get(2);
        int dataBits = Integer.parseInt(dataBitsS);
        String stopBitsS = (String)p.get(3);
        int stopBits = Integer.parseInt(stopBitsS);
        String parityS = (String)p.get(4);
        int parity = Integer.parseInt(parityS);
        SerialPort serialPort = null;
        if (Validators.correctString(portName)) {
            boolean portFound = false;
            CommPortIdentifier portId = null;
            Logger.logDebug(this, "initializing port: " + portName);
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                portId = (CommPortIdentifier)portList.nextElement();
                String shortPortName = portName.replace("/dev/", "");
                String curentElementPortName = portId.getName();
                if (!curentElementPortName.equalsIgnoreCase(portName) && !curentElementPortName.equalsIgnoreCase(shortPortName)) continue;
                Logger.logDebug(this, "Found port: " + portName);
                portFound = true;
                break;
            }
            if (!portFound) {
                Logger.logDebug(this, "Port incorect: " + portName);
                DialogUtils.errorDialog(GuiUtils.currentFrame, "SerialBarCodeReader: port incorect : \"" + portName + "\"", LangRoAll.nuPotContinua);
                return;
            }
            try {
                PortSettingsPureJava settings = new PortSettingsPureJava();
                settings.setName(portName);
                settings.setSpeed(speed);
                settings.setDataBits(dataBits);
                settings.setStopBits(stopBits);
                settings.setPariry(parity);
                Logger.logInfo(Utils.class.getName(), ">>>>> Opening port: " + portName + "");
                serialPort = (SerialPort)portId.open("SerialBarCodeReader", 2000);
                this.inS = serialPort.getInputStream();
                this.outS = serialPort.getOutputStream();
                serialPort.setSerialPortParams(settings.getSpeed(), settings.getDataBits(), settings.getStopBits(), settings.getPariry());
                serialPort.setRTS(false);
                Logger.logInfo(this, "Setari port serial DUPA setParams : baudRate=" + serialPort.getBaudRate() + " dataBits=" + serialPort.getDataBits() + " stopBits=" + serialPort.getStopBits() + " parity=" + serialPort.getParity());
                Thread reader = new Thread(){

                    @Override
                    public void run() {
                        int crcCount = 0;
                        String rxString = "";
                        String crcString = "";
                        try {
                            while (true) {
                                int toRead = Module.this.inS.available();
                                boolean somethingDone = false;
                                if (toRead > 0) {
                                    byte[] take;
                                    somethingDone = true;
                                    int b = Module.this.inS.read();
                                    if (b == 255) continue;
                                    if (b == 6) {
                                        boolean isAck = true;
                                        System.out.println("Received ACK : " + Formatters.FULL_TIMESTAMP.format(new Date()));
                                    } else if (b == 19) {
                                        take = new byte[2];
                                        Module.this.inS.read(take);
                                        boolean isRelease = true;
                                        System.out.println("Received Release : " + Formatters.FULL_TIMESTAMP.format(new Date()));
                                    } else if (b == 17) {
                                        take = new byte[3];
                                        int charsRead = Module.this.inS.read(take);
                                        boolean isTakeRequest1 = true;
                                        System.out.println("Take : " + Formatters.FULL_TIMESTAMP.format(new Date()));
                                        byte[] content = "000000;6;A;;1;1;;;3;".getBytes();
                                        int length = content.length;
                                        byte[] reply = new byte[length + 4];
                                        System.arraycopy(content, 0, reply, 1, length);
                                        reply[0] = 10;
                                        reply[length + 4 - 3] = 13;
                                        reply[length + 4 - 2] = -126;
                                        reply[length + 4 - 1] = 105;
                                        Module.this.outS.write(reply);
                                        Module.this.outS.flush();
                                        System.out.println("Sent take reply : " + Formatters.FULL_TIMESTAMP.format(new Date()));
                                    } else if (b == 10) {
                                        boolean isMessage = true;
                                        rxString = "";
                                    } else if (b == 13) {
                                        crcCount = 2;
                                        crcString = "";
                                    } else if (crcCount > 0) {
                                        crcString = crcString + (char)b;
                                        if (--crcCount == 0) {
                                            System.out.println("Received : " + rxString + " crc : " + crcString + " " + Formatters.FULL_TIMESTAMP.format(new Date()));
                                            rxString = "";
                                        }
                                    } else {
                                        rxString = rxString + (char)b;
                                    }
                                }
                                if (somethingDone) continue;
                                Thread.sleep(50L);
                            }
                        }
                        catch (IOException e) {
                            Logger.logException(this, (Exception)e);
                        }
                        catch (Throwable th) {
                            Logger.logError((Object)this, th);
                        }
                    }
                };
                reader.setName("ReaderThread");
                reader.start();
                Thread writer = new Thread(){

                    @Override
                    public void run() {
                    }
                };
                writer.setName("WriterThread");
                writer.start();
            }
            catch (PortInUseException e) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "SerialBarCodeReader: port ocupat : \"" + portName + "\"", LangRoAll.nuPotContinua);
            }
            catch (Exception e) {
                Logger.logException(this, e);
            }
            catch (Throwable th) {
                Logger.logError((Object)this, th);
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] args) {
        try {
            Logger.getInstance(6, "datecsemulator.log");
            new Module().init(args, new Hashtable());
        }
        catch (ModuleInstantiationException e) {
            e.printStackTrace();
        }
    }
}

