/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.descarcare;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Random;
import java.util.Vector;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.DatabaseManager;
import ro.atreides.utils.documente.Document;

public class DescarcareThread
extends Thread {
    private RestLogic logic;
    private String id;
    private Connection lockConnection = null;

    public DescarcareThread(RestLogic logic) {
        this.logic = logic;
        this.setPriority(1);
        this.setName("Descarcare");
    }

    private void lock() throws SQLException {
        Utils.lock("descarcare_locking_table", this.lockConnection);
    }

    private void release() throws SQLException {
        Utils.release(this.lockConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deduplicateTimestamps() {
        try {
            this.lock();
            Vector documente = this.logic.getAllDocumenteNevalidateNoCommit();
            Timestamp lastTimeStamp = null;
            Document lastDocument = null;
            boolean updateLastDocument = false;
            for (int i = 0; i < documente.size(); ++i) {
                Document o = (Document)documente.elementAt(i);
                Timestamp newTime = o.getTimeDocument();
                if (newTime.equals(lastTimeStamp)) {
                    this.logic.updateTimeForDocumentNoCommit(lastDocument);
                    updateLastDocument = true;
                } else if (updateLastDocument) {
                    this.logic.updateTimeForDocumentNoCommit(lastDocument);
                    updateLastDocument = false;
                }
                lastTimeStamp = newTime;
                lastDocument = o;
            }
            if (updateLastDocument) {
                this.logic.updateTimeForDocumentNoCommit(lastDocument);
            }
            ConnectionPool.getInstance().commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                ConnectionPool.getInstance().rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            ConnectionPool.getInstance().releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block28: while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            connected = false;
            random = new Random(System.currentTimeMillis());
            this.id = random.nextLong() + "";
            try {
                this.lockConnection = DatabaseManager.getInstance().getClientConnectionPostgres(5);
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            catch (InstantiationException e) {
                Logger.logException(this, (Exception)e);
            }
            catch (IllegalAccessException e) {
                Logger.logException(this, (Exception)e);
            }
            catch (ClassNotFoundException e) {
                Logger.logException(this, (Exception)e);
            }
            if (this.lockConnection == null) {
                Logger.logError((Object)this, "Nu am obtinut conexiune la baza. Incerc din nou in 10 secunde !!");
                continue;
            }
            connected = true;
            Logger.logInfo(this, "Conexiune la baza OK !!");
            try {
                this.release();
            }
            catch (SQLException e) {
                connected = false;
                Logger.logError((Object)this, "Conexiune pierduta la baza . Incerc o reconectare !!");
            }
            while (true) {
                if (connected) ** break;
                continue block28;
                deProcesat = null;
                try {
                    this.lock();
                    deProcesat = this.logic.getDocumentNeprocesatNoCommit();
                    if (deProcesat != null) {
                        date = deProcesat.getTimeDocument();
                        Logger.logInfo(this, this.id + ": Procesam document : " + deProcesat.getDocument() + " data " + Formatters.currentDateAndTimeForFileSystem.format(deProcesat.getTimeDocument()) + " Tip Comanda " + (Object)deProcesat.getComandaType());
                        StockLogic.getInstance().deleteFiseMagazieLaData(date);
                        StockLogic.getInstance().deleteStockConsumLaData(date);
                        this.logic.proceseazaDocument(deProcesat);
                        this.logic.documentProcessed(deProcesat.getId());
                        ConnectionPool.getInstance().commit();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    connected = false;
                    Logger.logError((Object)this, "Conexiune pierduta la baza . Incerc o reconectare !!");
                }
                catch (Throwable th) {
                    Logger.logError((Object)this, th);
                    connected = false;
                    try {
                        ConnectionPool.getInstance().rollBack();
                    }
                    catch (SQLException connectionException) {
                        connected = false;
                        Logger.logError((Object)this, "Conexiune pierduta la baza . Incerc o reconectare !!");
                    }
                    try {
                        DescarcareThread.sleep(500L);
                    }
                    catch (InterruptedException in) {
                        // empty catch block
                    }
                }
                finally {
                    ConnectionPool.getInstance().releaseConnection();
                }
                try {
                    this.release();
                    if (deProcesat == null) {
                        try {
                            DescarcareThread.sleep(1000L);
                        }
                        catch (InterruptedException in) {}
                        continue;
                    }
                    try {
                        DescarcareThread.sleep((long)(1000.0 * VpConfig.getInstance().descarcareSleepSeconds));
                    }
                    catch (InterruptedException in) {}
                    continue;
                }
                catch (SQLException e) {
                    connected = false;
                    Logger.logError((Object)this, "Conexiune pierduta la baza . Incerc o reconectare !!");
                    continue;
                }
                break;
            }
            break;
        }
    }
}

