/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.droidsms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.restaurant.modules.droidsms.DroidSms;
import ro.atreides.utils.db.DaoInterface;

public class DroidSmsDao
implements DaoInterface {
    private Connection connection;
    private PreparedStatement addSms;
    private PreparedStatement getNew;
    private PreparedStatement setStatus;

    public DroidSmsDao(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.addSms = this.connection.prepareStatement("insert into droid_sms (number, text) values ( ?, ?)");
        this.getNew = this.connection.prepareStatement("select * from droid_sms where status = 1 and retrycount > 0");
        this.setStatus = this.connection.prepareStatement("update droid_sms set status = ?, retrycount = retrycount - ? where id = ?");
    }

    public void addSms(String number, String text) throws SQLException {
        this.addSms.setString(1, number);
        this.addSms.setString(2, text);
        this.addSms.execute();
    }

    public Vector<DroidSms> getNew() throws SQLException {
        Vector<DroidSms> result = new Vector<DroidSms>();
        ResultSet rs = this.getNew.executeQuery();
        while (rs.next()) {
            int id = rs.getInt("id");
            String number = rs.getString("number");
            String text = rs.getString("text");
            int status = rs.getInt("status");
            int retrycount = rs.getInt("retrycount");
            DroidSms sms = new DroidSms();
            sms.setId(id);
            sms.setNumber(number);
            sms.setStatus(status);
            sms.setText(text);
            sms.setRetryCount(retrycount);
            result.add(sms);
        }
        rs.close();
        return result;
    }

    public void setStatus(int id, int newStatus, int retryModif) throws SQLException {
        this.setStatus.setInt(1, newStatus);
        this.setStatus.setInt(2, retryModif);
        this.setStatus.setInt(3, id);
        this.setStatus.execute();
    }
}

