/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.fidelitybo;

import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.fidelitybo.EventDef;
import ro.atreides.restaurant.modules.fidelitybo.EventInstance;
import ro.atreides.restaurant.modules.fidelitybo.FidelityLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class EvenimenteFidelityReport
extends AbstractReportPanel {
    private static final String[] _columnNames = new String[]{LangRoAll.denumire, LangRoAll.locatie, LangRoAll.start, LangRoAll.stop, LangRoAll.status};
    private Hashtable printCriteria = new Hashtable();

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Date> result = new Hashtable<String, Date>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        return result;
    }

    @Override
    public void printReport() {
    }

    @Override
    public void printPreview() {
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return FidelityLogic.getInstance().getEvenimenteReport(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
    }

    @Override
    public String getName() {
        return "Evenimente";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(_columnNames, Utils.getStringClass(_columnNames.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                EventInstance pe = (EventInstance)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return pe.getNumeEventDef();
                    }
                    case 1: {
                        return pe.getNumeLocatie();
                    }
                    case 2: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(pe.getDataStart());
                    }
                    case 3: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(pe.getDataStop());
                    }
                    case 4: {
                        return pe.isDeleted() ? "Canceled" : "";
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel total = new JPanel((LayoutManager)new MigLayout());
        JButton add = new JButton("Adauga Eveniment");
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<FidelityLogic.TIP_EVENIMENT> tips = new Vector<FidelityLogic.TIP_EVENIMENT>();
                tips.add(FidelityLogic.TIP_EVENIMENT.MANUAL);
                Object result = DialogUtils.getItemChooserDialog(FidelityLogic.getInstance().getAllActiveEventDef(tips), 4, false);
                EventDef eventDef = (EventDef)result;
                Vector locations = RestLogic.getInstance().getLocations();
                FidelityLogic.getInstance().addEventInstanceLocally(eventDef, locations);
                EvenimenteFidelityReport.this.raport();
            }
        });
        total.add(add);
        return total;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        return null;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void doStuff() {
        final EvenimenteFidelityReport parent = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                int modifiers = e.getModifiers();
                if ((modifiers & 8) > 0 || (modifiers & 4) > 0) {
                    final EventInstance nv = (EventInstance)EvenimenteFidelityReport.this.data.elementAt(selRow);
                    final JPopupMenu popup = new JPopupMenu();
                    JMenuItem delete = new JMenuItem(LangRoAll.sterge);
                    popup.add(delete);
                    popup.setInvoker(EvenimenteFidelityReport.this.table);
                    delete.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            User loggedUser = AdministrationPanel.loggedUser;
                            if (loggedUser != null) {
                                if (UsersLogic.getInstance().isUserInGroup(loggedUser.getId(), "group_manager_evenimente")) {
                                    if (DialogUtils.confirmDialog(parent, "Stergem acest eveniment", LangRoAll.confirmare)) {
                                        FidelityLogic.getInstance().deleteEventInstance(nv);
                                        EvenimenteFidelityReport.this.raport();
                                    }
                                } else {
                                    DialogUtils.errorDialog(parent, "Drepturi insuficiente", LangRoAll.nuPotContinua);
                                }
                            } else {
                                DialogUtils.errorDialog(parent, LangRoAll.neautentificat, LangRoAll.nuPotContinua);
                            }
                            popup.setVisible(false);
                        }
                    });
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

