/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.fidelitybo;

import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import net.miginfocom.swing.MigLayout;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.fidelitybo.EventDef;
import ro.atreides.restaurant.modules.fidelitybo.FidelityLogic;
import ro.atreides.restaurant.modules.fidelitybo.RaportPuncteView;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TipCont;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class FidelityRaportPunctePanel
extends AbstractReportPanel
implements CleanupRequired {
    private static final String[] columns = new String[]{"Tip eveniment", "Locatie", "Client", "Tip card", "Card", "Nr puncte", "Data"};
    private JLabel nrPuncteTotal;
    private JLabel nrEvenimente;
    private JLabel nrClientiDistincti;
    private JLabel nrCarduriDistincte;
    private JLabel nrLiniiTabel;
    private Double puncteTotal;
    private JComboBox<EventDef> tipEvenimentCombo;
    private JComboBox<Location> locatieCombo;
    private JTextField client;
    private JComboBox<TipCont> tip_cardCombo;
    private JTextField card;
    private Hashtable printCriteria = new Hashtable();
    private Vector clientiDistincti = new Vector();
    private Vector carduriDistincte = new Vector();
    private static Comparator tipEvenimentComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String tipEv1 = ((RaportPuncteView)o1).getTipEveniment();
            String tipEv2 = ((RaportPuncteView)o2).getTipEveniment();
            return tipEv1.compareTo(tipEv2);
        }
    };
    private static Comparator locatieComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String loc1 = ((RaportPuncteView)o1).getLocatie();
            String loc2 = ((RaportPuncteView)o2).getLocatie();
            return loc1.compareTo(loc2);
        }
    };
    private static Comparator clientComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String client1 = ((RaportPuncteView)o1).getClient();
            String client2 = ((RaportPuncteView)o2).getClient();
            return client1.compareTo(client2);
        }
    };
    private static Comparator cardComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String card1 = ((RaportPuncteView)o1).getCard();
            String card2 = ((RaportPuncteView)o2).getCard();
            return card1.compareTo(card2);
        }
    };
    private static Comparator tipCardComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String tip1 = ((RaportPuncteView)o1).getTipCard();
            String tip2 = ((RaportPuncteView)o2).getTipCard();
            return tip1.compareTo(tip2);
        }
    };
    private static Comparator date_sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            String c1 = ((RaportPuncteView)o1).getData().toString();
            String c2 = ((RaportPuncteView)o2).getData().toString();
            if (c1 != null) {
                if (c2 != null) {
                    return c1.compareTo(c2);
                }
                return 1;
            }
            if (c2 != null) {
                return -1;
            }
            return 0;
        }
    };
    private static Comparator nrPuncteComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Double pct1 = ((RaportPuncteView)o1).getNrPuncte();
            Double pct2 = ((RaportPuncteView)o2).getNrPuncte();
            return (int)(pct1 - pct2);
        }
    };

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Object selectedItem;
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate.getTime());
        result.put(Constants.STOP_KEY, stopDate.getTime());
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (ComboUtils.anythingButAllSelected(this.tipEvenimentCombo)) {
            EventDef tipEveniment = (EventDef)this.tipEvenimentCombo.getSelectedItem();
            result.put("tip_eveniment", tipEveniment);
            this.printCriteria.put("tip_eveniment", tipEveniment);
        } else {
            this.printCriteria.remove("tip_eveniment");
        }
        if (ComboUtils.anythingButAllSelected(this.locatieCombo)) {
            selectedItem = (Location)this.locatieCombo.getSelectedItem();
            result.put(Constants.LOCATIE_KEY, selectedItem);
            this.printCriteria.put(Constants.LOCATIE_KEY, selectedItem);
        } else {
            this.printCriteria.remove(Constants.LOCATIE_KEY);
        }
        if (Validators.correctString(this.client.getText())) {
            result.put(Constants.CLIENT_KEY, this.client.getText());
            this.printCriteria.put(Constants.CLIENT_KEY, this.client.getText());
        } else {
            this.printCriteria.remove(Constants.CLIENT_KEY);
        }
        if (ComboUtils.anythingButAllSelected(this.tip_cardCombo)) {
            selectedItem = (TipCont)this.tip_cardCombo.getSelectedItem();
            result.put("tip_cont", selectedItem);
            this.printCriteria.put("tip_cont", selectedItem);
        } else {
            this.printCriteria.remove("tip_cont");
        }
        if (Validators.correctString(this.card.getText())) {
            result.put("cont", this.card.getText());
            this.printCriteria.put("cont", this.card.getText());
        } else {
            this.printCriteria.remove("cont");
        }
        return result;
    }

    @Override
    public void printReport() {
    }

    @Override
    public void printPreview() {
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return FidelityLogic.getInstance().getAllPuncteView(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object obj, WritableSheet sheet, int row) {
                    int column = 0;
                    RaportPuncteView o = (RaportPuncteView)obj;
                    try {
                        sheet.addCell((WritableCell)new Label(column++, row, o.getTipEveniment()));
                        sheet.addCell((WritableCell)new Label(column++, row, o.getLocatie()));
                        sheet.addCell((WritableCell)new Label(column++, row, o.getClient()));
                        sheet.addCell((WritableCell)new Label(column++, row, o.getTipCard()));
                        sheet.addCell((WritableCell)new Label(column++, row, o.getCard()));
                        sheet.addCell((WritableCell)new Number(column++, row, o.getNrPuncte().doubleValue()));
                        sheet.addCell((WritableCell)new Label(column++, row, Formatters.transferuriDateFormat.format(o.getData())));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return FidelityRaportPunctePanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Raport puncte";
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM abstractTM = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                RaportPuncteView o = (RaportPuncteView)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return o.getTipEveniment();
                    }
                    case 1: {
                        return o.getLocatie();
                    }
                    case 2: {
                        return o.getClient();
                    }
                    case 3: {
                        return o.getTipCard();
                    }
                    case 4: {
                        return o.getCard();
                    }
                    case 5: {
                        return Utils.getString2Decimals(o.getNrPuncte());
                    }
                    case 6: {
                        return Formatters.transferuriDateFormat.format(o.getData());
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return abstractTM;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fillx"));
        result.add((Component)new JLabel("Nr puncte total"), "growx");
        this.nrPuncteTotal = new JLabel("");
        result.add((Component)this.nrPuncteTotal, "growx");
        result.add((Component)new JLabel("Nr clienti distincti"), "growx");
        this.nrClientiDistincti = new JLabel("");
        result.add((Component)this.nrClientiDistincti, "growx");
        result.add((Component)new JLabel("Nr linii din tabel"), "growx");
        this.nrLiniiTabel = new JLabel("");
        result.add((Component)this.nrLiniiTabel, "growx");
        result.add((Component)new JLabel("Nr carduri distincte"), "growx");
        this.nrCarduriDistincte = new JLabel("");
        result.add((Component)this.nrCarduriDistincte, "growx");
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill"));
        result.add(new JLabel("Tip eveniment"));
        this.tipEvenimentCombo = new JComboBox();
        result.add(this.tipEvenimentCombo, "growx, wrap");
        result.add(new JLabel("Locatie"));
        this.locatieCombo = new JComboBox();
        result.add(this.locatieCombo, "growx, wrap");
        result.add(new JLabel("Client"));
        this.client = new JTextField();
        result.add((Component)this.client, "growx, wrap");
        result.add(new JLabel("Card"));
        this.card = new JTextField();
        result.add((Component)this.card, "growx, wrap");
        result.add(new JLabel("Tip card"));
        this.tip_cardCombo = new JComboBox();
        result.add(this.tip_cardCombo, "growx, wrap");
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        this.puncteTotal = new Double(0.0);
        this.carduriDistincte.removeAllElements();
        this.clientiDistincti.removeAllElements();
        for (Object o : this.tm.getData()) {
            RaportPuncteView x = (RaportPuncteView)o;
            if (!this.carduriDistincte.contains(x.getCard())) {
                this.carduriDistincte.add(x.getCard());
            }
            if (!this.clientiDistincti.contains(x.getIdClient())) {
                this.clientiDistincti.add(x.getClient());
            }
            this.puncteTotal = this.puncteTotal + x.getNrPuncte();
        }
        this.nrPuncteTotal.setText(this.puncteTotal + "");
        this.nrCarduriDistincte.setText(this.carduriDistincte.size() + "");
        this.nrClientiDistincti.setText(this.clientiDistincti.size() + "");
        this.nrLiniiTabel.setText(this.tm.getData().size() + "");
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void doStuff() {
        Vector<EventDef> allEventDef = FidelityLogic.getInstance().getAllActiveEventDef(FidelityLogic.getInstance().getAllTipEvenimente());
        ComboUtils.replaceItemsForCombo(this.tipEvenimentCombo, allEventDef);
        ComboUtils.replaceItemsForCombo(this.locatieCombo, RestLogic.getInstance().getLocations());
        ComboUtils.replaceItemsForCombo(this.tip_cardCombo, ClientLogic.getInstance().getAllConturi());
        GenericListenersLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                Vector<EventDef> allEventDef = FidelityLogic.getInstance().getAllActiveEventDef(FidelityLogic.getInstance().getAllTipEvenimente());
                ComboUtils.replaceItemsForCombo(FidelityRaportPunctePanel.this.tipEvenimentCombo, allEventDef);
            }

            @Override
            public String getName() {
                return "EventDefChanged";
            }
        }, Constants.EVENT_DEF_CHANGED);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

