/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.fidelitybo;

import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import net.miginfocom.swing.MigLayout;
import ro.atreides.restaurant.modules.fidelitybo.FidelityLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.reports.AbstractReportPanel;

public class RaportCentralizatorPanel
extends AbstractReportPanel
implements CleanupRequired {
    private static final String[] columns = new String[]{" ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " "};
    private JComboBox<Integer> years;
    private JComboBox<String> grupareSali;
    private Vector<Vector> tableData;
    private Hashtable printCriteria = new Hashtable();

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        this.printCriteria.clear();
        Integer selectedItem = (Integer)this.years.getSelectedItem();
        result.put("year", selectedItem);
        this.printCriteria.put("year", selectedItem);
        if (ComboUtils.anythingButAllSelected(this.grupareSali)) {
            result.put("cu sali", "yes");
            this.printCriteria.put("Grupare sali", "yes");
        }
        return result;
    }

    @Override
    public void printReport() {
    }

    @Override
    public void printPreview() {
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return FidelityLogic.getInstance().getRaportCentralizator(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object obj, WritableSheet sheet, int row) {
                    int column = 0;
                    try {
                        Vector line = (Vector)obj;
                        for (Object cell : line) {
                            sheet.addCell((WritableCell)new Label(column++, row, cell.toString()));
                        }
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return RaportCentralizatorPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Raport centralizator";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                return ((Vector)data.get(rowIndex)).get(columnIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        return null;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill", "[][grow]", ""));
        this.years = new JComboBox<Integer>(this.getYears());
        result.add(new JLabel("An :", 0));
        result.add(this.years, "growx, wrap");
        this.grupareSali = new JComboBox();
        result.add(new JLabel("Grupare :", 0));
        result.add(this.grupareSali, "growx");
        return result;
    }

    private Vector<Integer> getYears() {
        Vector<Integer> result = new Vector<Integer>();
        for (int i = 2016; i <= 2030; ++i) {
            result.add(i);
        }
        return result;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void doStuff() {
        Vector<String> strings = new Vector<String>();
        strings.add("Dupa sali");
        ComboUtils.replaceItemsForCombo(this.grupareSali, strings, true);
        GuiUtils.updateJTableRowSize(this.table, 45);
        this.table.getColumnModel().getColumn(0).setMinWidth(150);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(150);
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

