/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.fidelitybo;

import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import net.miginfocom.swing.MigLayout;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.fidelitybo.FidelityLogic;
import ro.atreides.restaurant.modules.fidelitybo.RaportComenziView;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class RaportComenziPanel
extends AbstractReportPanel
implements CleanupRequired {
    private static final String[] columns = new String[]{"Client", "Locatie", "Produs", "Cantitate", "Puncte consumate", "Data"};
    private JComboBox<Location> locatieCombo;
    private JTextField client;
    private JTextField produs;
    private Double nrPuncte;
    private Vector nrClientiDistincti = new Vector();
    private Vector nrProduseDistincte = new Vector();
    private JLabel nrPuncteLabel;
    private JLabel nrClientiDLabel;
    private JLabel nrProduseDLabel;
    private JLabel nrLinii;
    private Hashtable printCriteria = new Hashtable();

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate.getTime());
        result.put(Constants.STOP_KEY, stopDate.getTime());
        this.printCriteria.clear();
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        if (Validators.correctString(this.client.getText())) {
            result.put(Constants.CLIENT_KEY, this.client.getText());
            this.printCriteria.put(Constants.CLIENT_KEY, this.client.getText());
        }
        if (Validators.correctString(this.produs.getText())) {
            result.put("Product", this.produs.getText());
            this.printCriteria.put("Product", this.produs.getText());
        }
        if (ComboUtils.anythingButAllSelected(this.locatieCombo)) {
            Location selectedItem = (Location)this.locatieCombo.getSelectedItem();
            result.put(Constants.LOCATIE_KEY, selectedItem);
            this.printCriteria.put(Constants.LOCATIE_KEY, selectedItem);
        } else {
            this.printCriteria.remove(Constants.LOCATIE_KEY);
        }
        return result;
    }

    @Override
    public void printReport() {
    }

    @Override
    public void printPreview() {
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return FidelityLogic.getInstance().getAllComenziView(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object obj, WritableSheet sheet, int row) {
                    int column = 0;
                    RaportComenziView o = (RaportComenziView)obj;
                    try {
                        sheet.addCell((WritableCell)new Label(column++, row, o.getClient()));
                        sheet.addCell((WritableCell)new Label(column++, row, o.getLocatie()));
                        sheet.addCell((WritableCell)new Label(column++, row, o.getProdus()));
                        sheet.addCell((WritableCell)new Number(column++, row, o.getCantitate().doubleValue()));
                        sheet.addCell((WritableCell)new Number(column++, row, o.getPuncteConsumate().doubleValue()));
                        sheet.addCell((WritableCell)new Label(column++, row, Formatters.transferuriDateFormat.format(o.getData())));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return RaportComenziPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Raport comenzi";
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM abstractTM = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                RaportComenziView o = (RaportComenziView)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return o.getClient();
                    }
                    case 1: {
                        return o.getLocatie();
                    }
                    case 2: {
                        return o.getProdus();
                    }
                    case 3: {
                        return o.getCantitate();
                    }
                    case 4: {
                        return o.getPuncteConsumate();
                    }
                    case 5: {
                        return o.getData();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return abstractTM;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill"));
        result.add(new JLabel("Nr puncte"));
        this.nrPuncteLabel = new JLabel("");
        result.add(this.nrPuncteLabel);
        result.add(new JLabel("Nr linii"));
        this.nrLinii = new JLabel("");
        result.add(this.nrLinii);
        result.add(new JLabel("Nr clienti distincti"));
        this.nrClientiDLabel = new JLabel("");
        result.add(this.nrClientiDLabel);
        result.add(new JLabel("Nr produse distincte"));
        this.nrProduseDLabel = new JLabel("");
        result.add(this.nrProduseDLabel);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill"));
        result.add(new JLabel("Client"));
        this.client = new JTextField();
        result.add((Component)this.client, "growx, wrap");
        result.add(new JLabel("Locatie"));
        this.locatieCombo = new JComboBox();
        result.add(this.locatieCombo, "growx, wrap");
        result.add(new JLabel("Produs"));
        this.produs = new JTextField();
        result.add((Component)this.produs, "growx, wrap");
        return result;
    }

    @Override
    public void refreshTotalPanel() {
        this.nrPuncte = new Double(0.0);
        this.nrClientiDistincti.removeAllElements();
        this.nrProduseDistincte.removeAllElements();
        for (Object o : this.tm.getData()) {
            RaportComenziView x = (RaportComenziView)o;
            this.nrPuncte = this.nrPuncte + x.getPuncteConsumate();
            if (!this.nrClientiDistincti.contains(x.getIdClient())) {
                this.nrClientiDistincti.add(x.getIdClient());
            }
            if (this.nrProduseDistincte.contains(x.getIdProdus())) continue;
            this.nrProduseDistincte.add(x.getIdProdus());
        }
        this.nrPuncteLabel.setText(this.nrPuncte + "");
        this.nrProduseDLabel.setText(this.nrProduseDistincte.size() + "");
        this.nrClientiDLabel.setText(this.nrClientiDistincti.size() + "");
        this.nrLinii.setText(this.tm.getData().size() + "");
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.locatieCombo, RestLogic.getInstance().getLocations());
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

