/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.hotelanvelope;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.restaurant.modules.hotelanvelope.Anvelopa;
import ro.atreides.restaurant.modules.hotelanvelope.AnvelopaEntry;
import ro.atreides.restaurant.modules.hotelanvelope.FisaState;
import ro.atreides.restaurant.modules.hotelanvelope.FisePanelView;
import ro.atreides.restaurant.modules.hotelanvelope.ModelAnv;
import ro.atreides.utils.db.DaoInterface;

public class HaDao
implements DaoInterface {
    private PreparedStatement addModel;
    private PreparedStatement getModele;
    private PreparedStatement addFisa;
    private PreparedStatement addAnvelopa;
    private PreparedStatement addIstoric;
    private PreparedStatement getAnvelopaByCodBare;
    private PreparedStatement getLastUsedId;
    private PreparedStatement getModelByIdAnvelopa;
    private PreparedStatement getFise;
    private PreparedStatement getAnvelopeEntriesForFisa;
    private PreparedStatement setFisaStatus;
    private PreparedStatement updateFisa;
    private PreparedStatement deleteIstoricForFisa;
    private PreparedStatement updateAnvelopa;
    private PreparedStatement setNrLuniPlatiteForFisa;
    private PreparedStatement getCaracteristiciAnvelopaById;
    private Connection connection;

    public HaDao(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.setNrLuniPlatiteForFisa = this.connection.prepareStatement("update ha_fise set nr_luni_platite = ? where id = ?");
        this.deleteIstoricForFisa = this.connection.prepareStatement("delete from ha_istoric where id_fisa = ?");
        this.setFisaStatus = this.connection.prepareStatement("update ha_fise set status = ? where id = ?");
        this.addModel = this.connection.prepareStatement("insert into ha_modele ( indice_viteza, producator, model, indice_presiune ) values ( ?, ?, ?, ?) ");
        this.getModele = this.connection.prepareStatement("select * from ha_modele");
        this.addFisa = this.connection.prepareStatement("insert into ha_fise (id_client, auto, data, nr_km, termen, status ) values ( ?, ?, ?, ?, ?, " + FisaState.TEMPORAR.getState() + " )");
        this.updateFisa = this.connection.prepareStatement("update ha_fise set id_client = ?, auto = ?, data = ?, nr_km = ?, termen = ? where id = ?");
        this.getAnvelopaByCodBare = this.connection.prepareStatement("select * from ha_anvelope where codbare = ?");
        this.addAnvelopa = this.connection.prepareStatement("insert into ha_anvelope ( codbare, id_model, latime, inaltime, diametru, dot ) values ( ?, ?, ?, ?, ?, ? )");
        this.updateAnvelopa = this.connection.prepareStatement("update ha_anvelope set codbare = ?, id_model = ?, latime = ?, inaltime = ?, diametru = ?, dot = ? where id = ?");
        this.addIstoric = this.connection.prepareStatement("insert into ha_istoric ( id_anvelopa, id_fisa, uzura, observatii, pozitia_depozit, pozitia_masina, id_product, are_janta, detalii_janta, ppu, discount, id_promotion ) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
        this.getLastUsedId = this.connection.prepareStatement("select max(id) from ha_anvelope");
        this.getModelByIdAnvelopa = this.connection.prepareStatement("select ha_modele.* from ha_anvelope inner join ha_modele on ha_anvelope.id_model = ha_modele.id where ha_anvelope.id = ?");
        this.getCaracteristiciAnvelopaById = this.connection.prepareStatement("select * from ha_anvelope where id = ?");
        this.getFise = this.connection.prepareStatement("select id_client, ha_fise.id as id_fisa, auto, status, data, nr_luni_platite, nr_km, termen, (select count(id) from ha_istoric where ha_istoric.id_fisa = ha_fise.id) as nr_anvelope from ha_fise where (id_client = ? or ? = -1) and (ha_fise.id = ? or ? = -1 ) and auto like ?  and (status = ? or ? = -1) and data >= ? and data < ?");
        this.getAnvelopeEntriesForFisa = this.connection.prepareStatement("select ha_anvelope.id as id_anvelopa, ha_anvelope.codbare, ha_istoric.detalii_janta, ha_anvelope.diametru, ha_anvelope.dot, ha_anvelope.id_model, ha_istoric.id_product, ha_anvelope.inaltime, ha_istoric.are_janta, ha_anvelope.latime, ha_modele.producator || '_' || ha_modele.model || '_' || ha_modele.indice_presiune || '_' || ha_modele.indice_viteza as model, ha_istoric.observatii, ha_istoric.pozitia_depozit, ha_istoric.pozitia_masina, ha_istoric.uzura, ha_istoric.ppu, ha_istoric.discount, ha_istoric.id_promotion from ha_fise inner join ha_istoric on ha_fise.id = ha_istoric.id_fisa inner join ha_anvelope on ha_istoric.id_anvelopa = ha_anvelope.id inner join ha_modele on ha_anvelope.id_model = ha_modele.id where ha_fise.id = ?");
    }

    public void deleteIstoricForFisa(int idFisa) throws SQLException {
        this.deleteIstoricForFisa.setInt(1, idFisa);
        this.deleteIstoricForFisa.execute();
    }

    public void setFisaStatus(int id, int newStatus) throws SQLException {
        this.setFisaStatus.setInt(1, newStatus);
        this.setFisaStatus.setInt(2, id);
        this.setFisaStatus.execute();
    }

    public ModelAnv getModelByIdAnvelopa(int id) throws SQLException {
        ModelAnv result = null;
        this.getModelByIdAnvelopa.setInt(1, id);
        ResultSet rs = this.getModelByIdAnvelopa.executeQuery();
        if (rs.next()) {
            result = this.getModelFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Anvelopa getCaracteristiciAnvelopaById(int id) throws SQLException {
        Anvelopa a = null;
        this.getCaracteristiciAnvelopaById.setInt(1, id);
        ResultSet rs = this.getCaracteristiciAnvelopaById.executeQuery();
        if (rs.next()) {
            a = new Anvelopa();
            a.setLatime(rs.getDouble("latime"));
            a.setInaltime(rs.getDouble("inaltime"));
            a.setDiametru(rs.getDouble("diametru"));
            a.setDot(rs.getString("dot"));
            a.setId(rs.getInt("id"));
        }
        rs.close();
        return a;
    }

    public int getIdAnvelopaByCodBare(String codBare) throws SQLException {
        int result = -1;
        this.getAnvelopaByCodBare.setString(1, codBare);
        ResultSet rs = this.getAnvelopaByCodBare.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id");
        }
        rs.close();
        return result;
    }

    public void addAnvelopa(String codBare, int idModel, double latime, double inaltime, double raza, String dot) throws SQLException {
        this.addAnvelopa.setString(1, codBare);
        this.addAnvelopa.setInt(2, idModel);
        this.addAnvelopa.setDouble(3, latime);
        this.addAnvelopa.setDouble(4, inaltime);
        this.addAnvelopa.setDouble(5, raza);
        this.addAnvelopa.setString(6, dot);
        this.addAnvelopa.execute();
    }

    public void updateAnvelopa(int idAnvelopa, String codBare, int idModel, double latime, double inaltime, double raza, String dot) throws SQLException {
        this.updateAnvelopa.setString(1, codBare);
        this.updateAnvelopa.setInt(2, idModel);
        this.updateAnvelopa.setDouble(3, latime);
        this.updateAnvelopa.setDouble(4, inaltime);
        this.updateAnvelopa.setDouble(5, raza);
        this.updateAnvelopa.setString(6, dot);
        this.updateAnvelopa.setInt(7, idAnvelopa);
        this.updateAnvelopa.execute();
    }

    public void addIstoricAnv(int idAnvelopa, double uzura, String observatii, int idFisa, String pozitiaInDepozit, String pozitiaPeMasina, int idProduct, boolean areJanta, String detaliiJanta, double pret, double discount, int idPromotion) throws SQLException {
        this.addIstoric.setInt(1, idAnvelopa);
        this.addIstoric.setInt(2, idFisa);
        this.addIstoric.setDouble(3, uzura);
        this.addIstoric.setString(4, observatii);
        this.addIstoric.setString(5, pozitiaInDepozit);
        this.addIstoric.setString(6, pozitiaPeMasina);
        this.addIstoric.setInt(7, idProduct);
        this.addIstoric.setInt(8, areJanta ? 1 : 0);
        this.addIstoric.setString(9, detaliiJanta);
        this.addIstoric.setDouble(10, pret);
        this.addIstoric.setDouble(11, discount);
        if (idPromotion > 0) {
            this.addIstoric.setInt(12, idPromotion);
        } else {
            this.addIstoric.setNull(12, 4);
        }
        this.addIstoric.execute();
    }

    public void addFIsa(int idClient, String auto, Timestamp data, int nrKm, Timestamp termen) throws SQLException {
        this.addFisa.setInt(1, idClient);
        this.addFisa.setString(2, auto);
        this.addFisa.setTimestamp(3, data);
        this.addFisa.setInt(4, nrKm);
        this.addFisa.setTimestamp(5, data);
        this.addFisa.execute();
    }

    public void updateFisa(int idFisa, int idClient, String auto, Timestamp data, int nrKm, Timestamp termen) throws SQLException {
        this.updateFisa.setInt(1, idClient);
        this.updateFisa.setString(2, auto);
        this.updateFisa.setTimestamp(3, data);
        this.updateFisa.setInt(4, nrKm);
        this.updateFisa.setTimestamp(5, termen);
        this.updateFisa.setInt(6, idFisa);
        this.updateFisa.execute();
    }

    public Vector getModele() throws SQLException {
        Vector<ModelAnv> v = new Vector<ModelAnv>();
        ResultSet rs = this.getModele.executeQuery();
        while (rs.next()) {
            ModelAnv toAdd = this.getModelFromResultSet(rs);
            v.add(toAdd);
        }
        rs.close();
        return v;
    }

    private ModelAnv getModelFromResultSet(ResultSet rs) throws SQLException {
        String prod = rs.getString("producator");
        String profil = rs.getString("model");
        String indicePresiune = rs.getString("indice_presiune");
        String indiceViteza = rs.getString("indice_viteza");
        String label = prod + "_" + profil + "_" + indicePresiune + "_" + indiceViteza;
        int id = rs.getInt("id");
        ModelAnv toAdd = new ModelAnv(id, indicePresiune, indiceViteza, label, prod, profil);
        return toAdd;
    }

    public void addModel(String producator, String model, String indicePresiune, String indiceViteza) throws SQLException {
        this.addModel.setString(1, producator);
        this.addModel.setString(2, model);
        this.addModel.setString(3, indicePresiune);
        this.addModel.setString(4, indiceViteza);
        this.addModel.execute();
    }

    public int getLastUsedIdForAnvelope() throws SQLException {
        int result = 0;
        ResultSet rs = this.getLastUsedId.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public Vector getFise(int nrFisa, int status, int idClient, String nrAuto, Timestamp start, Timestamp stop) throws SQLException {
        Vector<FisePanelView> result = new Vector<FisePanelView>();
        this.getFise.setInt(1, idClient);
        this.getFise.setInt(2, idClient);
        this.getFise.setInt(3, nrFisa);
        this.getFise.setInt(4, nrFisa);
        this.getFise.setString(5, "%" + nrAuto);
        this.getFise.setInt(6, status);
        this.getFise.setInt(7, status);
        this.getFise.setTimestamp(8, start);
        this.getFise.setTimestamp(9, stop);
        ResultSet rs = this.getFise.executeQuery();
        while (rs.next()) {
            FisePanelView fpe = new FisePanelView();
            fpe.setAuto(rs.getString("auto"));
            fpe.setIdClient(rs.getInt("id_client"));
            fpe.setIdFisa(rs.getInt("id_fisa"));
            fpe.setNrAnvelope(rs.getInt("nr_anvelope"));
            fpe.setData(rs.getTimestamp("data"));
            fpe.setTermen(rs.getTimestamp("termen"));
            fpe.setNrKm(rs.getInt("nr_km"));
            int idStatus = rs.getInt("status");
            fpe.setIdStatus(idStatus);
            fpe.setNrLuniPlatite(rs.getDouble("nr_luni_platite"));
            result.add(fpe);
        }
        rs.close();
        return result;
    }

    public Vector getAnvelopeEntriesForFisa(int idFisa) throws SQLException {
        Vector<AnvelopaEntry> result = new Vector<AnvelopaEntry>();
        this.getAnvelopeEntriesForFisa.setInt(1, idFisa);
        ResultSet rs = this.getAnvelopeEntriesForFisa.executeQuery();
        while (rs.next()) {
            AnvelopaEntry ae = new AnvelopaEntry(rs.getInt("id_anvelopa"), rs.getString("codbare"), rs.getString("detalii_janta"), rs.getDouble("diametru"), rs.getString("dot"), rs.getInt("id_model"), rs.getInt("id_product"), rs.getDouble("inaltime"), rs.getInt("are_janta") == 1, rs.getDouble("latime"), rs.getString("model"), rs.getString("observatii"), rs.getString("pozitia_depozit"), rs.getString("pozitia_masina"), rs.getDouble("uzura"), rs.getDouble("ppu"), rs.getDouble("discount"), rs.getInt("id_promotion"));
            result.add(ae);
        }
        rs.close();
        return result;
    }

    public void setNrLuniPlatiteForFisa(int idFisa, double nrLuni) throws SQLException {
        this.setNrLuniPlatiteForFisa.setDouble(1, nrLuni);
        this.setNrLuniPlatiteForFisa.setInt(2, idFisa);
        this.setNrLuniPlatiteForFisa.execute();
    }
}

