/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.hotelanvelope;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.hotelanvelope.FisaState;
import ro.atreides.restaurant.modules.hotelanvelope.FisePanelView;
import ro.atreides.restaurant.modules.hotelanvelope.HaLogic;
import ro.atreides.restaurant.modules.hotelanvelope.HotelAnvelopePanel;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class ListaFisePanel
extends AbstractReportPanel
implements CleanupRequired {
    private JComboBox status;
    private XComboBox clienti;
    private JTextField nrAuto;
    private RestLogic logic;
    private ReportInterface pdfReportInterface;
    private Hashtable printCriteria = new Hashtable();
    private static String[] columns = new String[]{"Nr Fisa", LangRoAll.client, LangRoAll.data, "Nr auto", "Nr anvelope", "Achitat/Neachitat/Total", LangRoAll.status};
    private static Class[] types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private JLabel total;
    private FilterableComboBoxModel clientsComboModel;
    private HotelAnvelopePanel parent;

    public ListaFisePanel(HotelAnvelopePanel parent) {
        this.logic = RestLogic.getInstance();
        this.parent = parent;
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Object c = this.clienti.getSelectedItem();
        if (c instanceof Client) {
            Client c1 = (Client)c;
            result.put(Constants.CLIENT_KEY, c1.getId());
            this.printCriteria.put(Constants.CLIENT_KEY, c);
        } else {
            result.put(Constants.CLIENT_KEY, -1);
            this.printCriteria.remove(Constants.CLIENT_KEY);
        }
        if (ComboUtils.anythingButAllSelected(this.status)) {
            String stat = (String)this.status.getSelectedItem();
            int newStatus = FisaState.valueOf(stat).getState();
            result.put(Constants.STATUS_CONTRACT_KEY, newStatus);
            this.printCriteria.put(Constants.STATUS_CONTRACT_KEY, stat);
        } else {
            this.printCriteria.remove(Constants.STATUS_CONTRACT_KEY);
            result.put(Constants.STATUS_CONTRACT_KEY, -1);
        }
        String nrA = this.nrAuto.getText();
        if (Validators.correctString(nrA)) {
            result.put("Numar auto", nrA);
            this.printCriteria.put("Numar auto", nrA);
        } else {
            result.put("Numar auto", "");
            this.printCriteria.remove("Numar auto");
        }
        return result;
    }

    @Override
    public void printReport() {
        DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.functieNeimplementata, LangRoAll.nuPotContinua);
    }

    @Override
    public void printPreview() {
        DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.functieNeimplementata, LangRoAll.nuPotContinua);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        Vector result = HaLogic.getInstance().getFise(criteria);
        return result;
    }

    @Override
    public void writeExcel(File reportFile) {
        DialogUtils.errorDialog(GuiUtils.currentFrame, LangRoAll.functieNeimplementata, LangRoAll.nuPotContinua);
    }

    @Override
    public String getName() {
        return "Lista fise";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                FisePanelView lcv = (FisePanelView)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return lcv.getIdFisa();
                    }
                    case 1: {
                        return lcv.getClient();
                    }
                    case 2: {
                        return lcv.getDataS();
                    }
                    case 3: {
                        return lcv.getAuto();
                    }
                    case 4: {
                        return lcv.getNrAnvelope();
                    }
                    case 5: {
                        return lcv.getValoare();
                    }
                    case 6: {
                        return lcv.getStatus();
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        this.total = new JLabel("");
        result.add((Component)this.total, c);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel(LangRoAll.client), c);
        ++c.gridx;
        this.clientsComboModel = new FilterableComboBoxModel(ClientLogic.getInstance().getAllClientsSorted());
        this.clienti = new XComboBox(this.clientsComboModel, true);
        this.clienti.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.clienti.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ListaFisePanel.this.clienti.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        result.add((Component)this.clienti, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Numar auto"), c);
        ++c.gridx;
        this.nrAuto = new JTextField(10);
        result.add((Component)this.nrAuto, c);
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel(LangRoAll.status), c);
        ++c.gridx;
        this.status = new JComboBox();
        result.add((Component)this.status, c);
        return result;
    }

    @Override
    public void refreshTotalPanel() {
    }

    private void addMouseListeners() {
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                final int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                int modifiers = e.getModifiers();
                if ((modifiers & 8) > 0 || (modifiers & 4) > 0) {
                    final JPopupMenu popup = new JPopupMenu();
                    JMenuItem edit = new JMenuItem(LangRoAll.modifica);
                    popup.add(edit);
                    edit.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            popup.setVisible(false);
                            FisePanelView nv = (FisePanelView)ListaFisePanel.this.tm.getObjectAt(selRow);
                            ListaFisePanel.this.parent.setFisaToEdit(nv);
                        }
                    });
                    JMenuItem sterge = new JMenuItem(LangRoAll.sterge);
                    popup.add(sterge);
                    sterge.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            popup.setVisible(false);
                        }
                    });
                    popup.setInvoker(ListaFisePanel.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public void doStuff() {
        ClientLogic clientLogic = ClientLogic.getInstance();
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "ListaFisePanel_persJuridice";
            }

            @Override
            public void dataChanged() {
                ListaFisePanel.this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 42);
        clientLogic.addListener(new EventListener(){

            @Override
            public String getName() {
                return "ListaFisePanel_persFizice";
            }

            @Override
            public void dataChanged() {
                ListaFisePanel.this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
            }
        }, 41);
        this.clientsComboModel.refresh(ClientLogic.getInstance().getAllClientsSorted());
        this.setFocusable(true);
        this.customParamsPanel.setFocusCycleRoot(true);
        this.addMouseListeners();
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public void cleanup() {
    }
}

