/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.keyssonorom;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.PersFizicaViewEntry;
import ro.atreides.clienti.gui.ClientiPanel;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class PersFizicaReport
extends AbstractReportPanel {
    private static final String[] columns = new String[]{"Nume si prenume", "CNP, act", "Adresa"};
    private JLabel numarLabel;
    private ClientiPanel main;
    private JTextField numeField;
    private JTextField adresaField;
    private JTextField cnpField;
    private Hashtable printCriteria = new Hashtable();
    private int idCompanieFilter = -1;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String cnp = this.cnpField.getText();
        if (Validators.correctString(cnp)) {
            result.put("CNP", cnp);
            this.printCriteria.put("CNP", cnp);
        } else {
            this.printCriteria.remove("CNP");
        }
        String nume = this.numeField.getText();
        if (Validators.correctString(nume)) {
            result.put("Nume", nume);
            this.printCriteria.put("Nume", nume);
        } else {
            this.printCriteria.remove("Nume");
        }
        String adresa = this.adresaField.getText();
        if (Validators.correctString(adresa)) {
            result.put("Adresa", adresa);
            this.printCriteria.put("Adresa", adresa);
        } else {
            this.printCriteria.remove("Adresa");
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("CNP"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.cnpField = new JTextField(20);
        result.add((Component)this.cnpField, c);
        this.cnpField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PersFizicaReport.this.raport();
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Nume"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.numeField = new JTextField(20);
        result.add((Component)this.numeField, c);
        this.numeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PersFizicaReport.this.raport();
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Adresa"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.adresaField = new JTextField(20);
        result.add((Component)this.adresaField, c);
        this.adresaField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PersFizicaReport.this.raport();
            }
        });
        return result;
    }

    public Class[] buildTypes() {
        return new Class[]{String.class, String.class, String.class, String.class};
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PersFizicaViewEntry ve = (PersFizicaViewEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return ve.getNume() + " " + ve.getPrenuma();
                    }
                    case 1: {
                        return ve.getAct();
                    }
                    case 2: {
                        return ve.getAdresa();
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.1;
        c.weighty = 0.1;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Nr linii"), c);
        ++c.gridx;
        this.numarLabel = new JLabel("");
        result.add((Component)this.numarLabel, c);
        return result;
    }

    @Override
    public String getName() {
        return "Persoane fizice";
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        String nume = (String)criteria.get("Nume");
        String adresa = (String)criteria.get("Adresa");
        String cnp = (String)criteria.get("CNP");
        return ClientLogic.getInstance().getPersFiziceViewEntry(nume, adresa, cnp);
    }

    @Override
    public void printPreview() {
        DialogUtils.errorDialog(GuiUtils.currentFrame, "Functie indisponibila.", LangRoAll.nuPotContinua);
    }

    @Override
    public void printReport() {
        DialogUtils.errorDialog(GuiUtils.currentFrame, "Functie indisponibila.", LangRoAll.nuPotContinua);
    }

    @Override
    public void refreshTotalPanel() {
        this.numarLabel.setText(this.data.size() + "");
    }

    @Override
    public void writeExcel(File reportFile) {
        DialogUtils.errorDialog(GuiUtils.currentFrame, "Functie indisponibila.", LangRoAll.nuPotContinua);
    }

    @Override
    public void doStuff() {
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final PersFizicaViewEntry pve = (PersFizicaViewEntry)PersFizicaReport.this.tm.getObjectAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem modifica = new JMenuItem(LangRoAll.modifica);
                popup.add(modifica);
                popup.setInvoker(PersFizicaReport.this.table);
                modifica.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PersFizicaReport.this.main.editPersFizica(pve);
                        popup.setVisible(false);
                        System.out.println("1: " + new Date());
                        new Timer().schedule(new TimerTask(){

                            @Override
                            public void run() {
                                System.out.println("2: " + new Date());
                                PersFizicaReport.this.raport();
                            }
                        }, 6000L);
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    public void setMain(ClientiPanel main) {
        this.main = main;
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return null;
    }

    public int getIdCompanieFilter() {
        return this.idCompanieFilter;
    }

    public void setIdCompanieFilter(int idCompanieFilter) {
        this.idCompanieFilter = idCompanieFilter;
    }
}

