/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.keyssonorom;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.text.Document;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.restaurant.modules.keyssonorom.PersFizicaSearch;
import ro.atreides.restaurant.modules.keyssonorom.PersFizicaTextFieldActionListener;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;

public class PersFizicaTextField
extends JTextField {
    private ClientPersFizica selected = null;
    private Vector<PersFizicaTextFieldActionListener> listeners = new Vector();
    private int idCompanieFilter = -1;

    @Override
    public boolean isEditable() {
        return false;
    }

    public PersFizicaTextField(String text) {
        super(text);
        this.setListener();
    }

    public PersFizicaTextField(int columns) {
        super(columns);
        this.setListener();
    }

    public PersFizicaTextField(String text, int columns) {
        super(text, columns);
        this.setListener();
    }

    public PersFizicaTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.setListener();
    }

    private void setListener() {
        this.setBackground(Color.YELLOW);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PersFizicaSearch searchPanel = new PersFizicaSearch();
                searchPanel.setIdCompanieFilter(PersFizicaTextField.this.idCompanieFilter);
                searchPanel.doStuff();
                JDialog dia = DialogUtils.getJDialog(searchPanel, GuiUtils.currentFrame, "Cautare persoana fizica", 1.5, true);
                searchPanel.setParentDialog(dia);
                dia.setVisible(true);
                PersFizicaTextField.this.setPersFizicaExternally(searchPanel.getSelected());
            }
        });
    }

    public void setPersFizicaExternally(ClientPersFizica cpf) {
        this.selected = cpf;
        if (this.selected != null) {
            this.setText(this.selected.toString() + " (" + ClientLogic.getInstance().getCNPForPersFizica(this.selected) + ")");
        } else {
            this.setText("");
        }
        this.notifyListeners(this.selected);
    }

    public ClientPersFizica getSelected() {
        return this.selected;
    }

    public void addListener(PersFizicaTextFieldActionListener newListener) {
        this.listeners.add(newListener);
    }

    private void notifyListeners(ClientPersFizica selected) {
        for (PersFizicaTextFieldActionListener listener : this.listeners) {
            listener.selected(selected);
        }
    }

    public void setIdCompanieFilter(int idCompanieFilter) {
        this.idCompanieFilter = idCompanieFilter;
    }
}

