/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.memshareintegration;

import eu.memshare.filetransfer.FileTransferStatusListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.contabilitate.Factura;
import ro.atreides.contabilitate.Nir;
import ro.atreides.restaurant.modules.memshareintegration.ExportClient;
import ro.atreides.restaurant.modules.memshareintegration.ExportType;
import ro.atreides.restaurant.modules.memshareintegration.MemshareNode;
import ro.atreides.utils.Client;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ObjectEventListener;
import ro.deversoft.licensing.ExportLicense;

public class MemshareExport {
    private static MemshareExport instance;
    private ExecutorService executorService = Executors.newCachedThreadPool();

    private MemshareExport() {
    }

    public static MemshareExport getInstance() {
        if (instance == null) {
            instance = new MemshareExport();
        }
        return instance;
    }

    public void initListenersForChannels(String[] channels) {
        for (String channel : channels) {
            ExportType exportType = ExportType.getExportType(channel);
            if (exportType != null) {
                this.addListenerGeneric(exportType);
                continue;
            }
            Logger.logDebug(this, "ExportType '" + channel + "' not defined\n");
        }
    }

    private void addListenerGeneric(final ExportType exportType) {
        if (exportType != null) {
            GenericListenersLogic.getInstance().addObjectListener(new ObjectEventListener(){

                @Override
                public void dataChanged(Object o) {
                    MemshareExport.this.executeJobGeneric((Map)o, exportType);
                }

                @Override
                public String getName() {
                    return "ExportMemshare_" + exportType.getKey();
                }
            }, exportType.getEventType());
        }
    }

    private void executeJobGeneric(final Map o, final ExportType exportType) {
        Callable job = new Callable(){

            public Object call() throws Exception {
                MemshareNode node = MemshareExport.this.buildNode(o);
                Long idNode = ExportClient.getInstance().exportNodeFactura(node, exportType);
                Vector node_files = (Vector)o.get("node_files");
                if (node_files != null && idNode != null) {
                    for (String nodeFile : node_files) {
                        MemshareExport.this.exportFileForNode(nodeFile, idNode);
                    }
                }
                return "ok";
            }
        };
        this.executorService.submit(job);
    }

    private MemshareNode buildNode(Map o) {
        MemshareNode result = new MemshareNode();
        String nodeTitle = (String)o.get("node_title");
        String nodeDescription = (String)o.get("node_description");
        result.setTitle(nodeTitle);
        result.setDescription(nodeDescription);
        return result;
    }

    private MemshareNode buildNodeFromFacturaEmisa(Map map) {
        String title1 = (String)map.get("title");
        String serie = (String)map.get("serie");
        String cumparator = (String)map.get("cumparator");
        String numarFactura = (String)map.get("numar");
        String totalGeneral = (String)map.get("totalGeneral");
        String title = "Factura " + serie + " Nr " + numarFactura + " " + cumparator + " " + totalGeneral;
        String description = "";
        description = description + "Numar factura : " + numarFactura + "<br/>";
        description = description + "Client : " + cumparator + "<br/>";
        description = description + "Total : " + totalGeneral + "<br/>";
        return new MemshareNode(title, description);
    }

    private void exportFileForNode(String filePath, Long idNode) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            FileTransferStatusListener listener = ExportLicense.getInstance().getFileTransferListener();
            ExportClient.getInstance().exportFile(idNode, file, listener);
        }
    }

    private MemshareNode buildNodeFromPlatiFurnizori(Map map) {
        SimpleDateFormat formatSimple = new SimpleDateFormat("dd-MM-yyyy");
        SimpleDateFormat formatHour = new SimpleDateFormat("hh:mm");
        String title = map.get("Nume") + " " + map.get("actCasa") + " " + map.get("Total");
        String description = "";
        for (Object o : map.keySet()) {
            String s = (String)o;
            Object o1 = map.get(s);
            if (o1 instanceof String) {
                String valoare = (String)o1;
                description = description + s + " : " + valoare + "<br/>";
                continue;
            }
            if (o1 instanceof Date) {
                String data = formatSimple.format((Date)o1);
                description = description + s + " : " + data + "<br/>";
                continue;
            }
            if (!(o1 instanceof Double)) continue;
            description = description + s + " : " + String.valueOf(o1) + "<br/>";
        }
        return new MemshareNode(title, description);
    }

    private MemshareNode buildNodeFromIncasariClienti(Map map) {
        SimpleDateFormat formatSimple = new SimpleDateFormat("dd-MM-yyyy");
        String title = map.get("Client") + " " + map.get("actCasa") + " " + map.get("Total");
        String description = "";
        for (Object o : map.keySet()) {
            String s = (String)o;
            Object o1 = map.get(s);
            if (o1 instanceof String) {
                String valoare = (String)o1;
                description = description + s + " : " + valoare + "<br/>";
                continue;
            }
            if (o1 instanceof Date) {
                String data = formatSimple.format((Date)o1);
                description = description + s + " : " + data + "<br/>";
                continue;
            }
            if (!(o1 instanceof Double)) continue;
            description = description + s + " : " + String.valueOf(o1) + "<br/>";
        }
        return new MemshareNode(title, description);
    }

    private MemshareNode buildNodeFromNir(Map map) {
        Factura factura = (Factura)map.get("factura");
        Nir nir = (Nir)map.get("nir");
        String furnizor = ClientLogic.getInstance().getClientById(factura.getIdFurnizor()).toString();
        SimpleDateFormat formatSimple = new SimpleDateFormat("dd-MM-yyyy");
        SimpleDateFormat formatHour = new SimpleDateFormat("hh:mm");
        String data = formatSimple.format(factura.getDateadd());
        double totalGeneral = factura.getTotalGeneral();
        String title = "Factura Marfa " + furnizor + " " + totalGeneral;
        String description = "";
        description = description + "Furnizor : " + furnizor + "<br/>";
        description = description + "Data : " + data + "<br/>";
        description = description + "Total : " + totalGeneral + "<br/>";
        description = description + "Numar Nir : " + nir.getNumarNir() + "<br/>";
        return new MemshareNode(title, description);
    }

    private MemshareNode buildNodeFromPlatiFurnizoriFortat(Map map) {
        SimpleDateFormat formatSimple = new SimpleDateFormat("dd-MM-yyyy");
        String title = "Plata " + map.get("Nume") + " " + map.get("actCasa") + " " + map.get("Total");
        String description = "";
        for (Object o : map.keySet()) {
            String s = (String)o;
            Object o1 = map.get(s);
            if (o1 instanceof String) {
                String valoare = (String)o1;
                description = description + s + " : " + valoare + "<br/>";
                continue;
            }
            if (o1 instanceof Date) {
                String data = formatSimple.format((Date)o1);
                description = description + s + " : " + data + "<br/>";
                continue;
            }
            if (!(o1 instanceof Double)) continue;
            description = description + s + " : " + String.valueOf(o1) + "<br/>";
        }
        return new MemshareNode(title, description);
    }

    private MemshareNode buildNodeNotNir(Map map) {
        String furnizor = (String)map.get("Furnizor");
        SimpleDateFormat formatSimple = new SimpleDateFormat("dd-MM-yyyy");
        String data = formatSimple.format((Date)map.get("Data"));
        Object total = map.get("Total");
        String totalGeneral = String.valueOf(total);
        String serie = (String)map.get("Serie");
        String title = "Alte Facturi " + furnizor + " " + serie + " " + totalGeneral;
        String description = "";
        description = description + "Furnizor : " + furnizor + "<br/>";
        description = description + "Data : " + data + "<br/>";
        description = description + "Total : " + totalGeneral + "<br/>";
        return new MemshareNode(title, description);
    }

    private MemshareNode buildNodeFromFacturaNormala(Map map) {
        Client cl = (Client)map.get("client");
        Object o = map.get("tva");
        String tva = String.valueOf(o);
        o = map.get("total");
        String total = String.valueOf(o);
        String seria = (String)map.get("seria");
        SimpleDateFormat formatSimple = new SimpleDateFormat("dd-MM-yyyy");
        String data = formatSimple.format((Date)map.get("data"));
        String numarFactura = (String)map.get("numarFactura");
        String title = "Alte Facturi " + seria + " Nr " + numarFactura + " " + cl.toString() + " " + total;
        String description = "";
        description = description + "Numar factura : " + numarFactura + "<br/>";
        description = description + "Seria : " + seria + "<br/>";
        description = description + "Client : " + cl.toString() + "<br/>";
        description = description + "Data : " + data + "<br/>";
        description = description + "Total : " + total + "<br/>";
        return new MemshareNode(title, description);
    }

    private MemshareNode buildNodeFromIncasariFortat(Map map) {
        String title = "Incasare " + map.get("actCasa") + " " + map.get("Anexa") + " " + map.get("Total");
        String description = "";
        description = description + "actCasa : " + map.get("actCasa") + "<br/>";
        description = description + "Anexa : " + map.get("Anexa") + "<br/>";
        description = description + "Explicatii : " + map.get("Explicatii") + "<br/>";
        description = description + "Data : " + map.get("Data") + "<br/>";
        description = description + "Total : " + map.get("Total") + "<br/>";
        return new MemshareNode(title, description);
    }

    private MemshareNode buildNodeForIncasariChitanta(Map o) {
        String actCasa = (String)o.get("actCasa");
        String explicatii = (String)o.get("Explicatii");
        String data = (String)o.get("Data");
        String total = (String)o.get("Total");
        String client = (String)o.get("Client");
        String title = client + " " + actCasa + " " + total;
        String description = "";
        description = description + "Total : " + total + "<br/>";
        description = description + "Data : " + data + "<br/>";
        description = description + "Nume : " + client + "<br/>";
        description = description + "actCasa : " + actCasa + "<br/>";
        description = description + "Explicatii : " + explicatii + "<br/>";
        return new MemshareNode(title, description);
    }
}

