/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.pda4;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.logic.LocationsFilter;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.logic.TablesFilter;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.messaging.Message;
import ro.atreides.utils.messaging.Messenger;
import ro.atreides.vp_pda.v4.BonMarcaj;
import ro.atreides.vp_pda.v4.Sale;
import ro.atreides.vp_pda.v4.TableStatus;
import ro.atreides.vp_pda.v4.messages.AbstractMessage;
import ro.atreides.vp_pda.v4.messages.IncasatMessage;
import ro.atreides.vp_pda.v4.messages.IncasatReply;
import ro.atreides.vp_pda.v4.messages.LoginMessage;
import ro.atreides.vp_pda.v4.messages.LoginReply;
import ro.atreides.vp_pda.v4.messages.MarcajMessage;
import ro.atreides.vp_pda.v4.messages.MarcajReply;
import ro.atreides.vp_pda.v4.messages.NotaMessage;
import ro.atreides.vp_pda.v4.messages.NotaReply;
import ro.atreides.vp_pda.v4.messages.NotificationsAcknoledgedMessage;
import ro.atreides.vp_pda.v4.messages.NotificationsAcknoledgedReply;
import ro.atreides.vp_pda.v4.messages.PingMessage;
import ro.atreides.vp_pda.v4.messages.PingReply;
import ro.atreides.vp_pda.v4.messages.ReadDataMessage;
import ro.atreides.vp_pda.v4.messages.ReadDataReply;
import ro.atreides.vp_pda.v4.messages.ReadNotificationsMessage;
import ro.atreides.vp_pda.v4.messages.ReadNotificationsReply;
import ro.atreides.vp_pda.v4.messages.RefreshTableMessage;
import ro.atreides.vp_pda.v4.messages.RefreshTableReply;

public class Pda4ServerConnection
extends Thread {
    private Socket s;
    private ObjectOutputStream outS;
    private ObjectInputStream inputS;
    private int readTimeout = 30000;
    private String remoteIp;

    public Pda4ServerConnection(Socket s) {
        this.s = s;
        try {
            InetAddress sa = s.getInetAddress();
            this.remoteIp = sa.getHostAddress();
            Logger.logInfo(this, "New connection started by : " + this.remoteIp);
            OutputStream os = s.getOutputStream();
            this.outS = new ObjectOutputStream(os);
            this.outS.flush();
            InputStream ins = s.getInputStream();
            this.inputS = new ObjectInputStream(ins);
            this.setName(this.getClass().getName());
            this.start();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    User u;
                    Order o;
                    AbstractMessage log;
                    AbstractMessage reply;
                    AbstractMessage reply2;
                    AbstractMessage message = (AbstractMessage)this.inputS.readObject();
                    Logger.logDebug(this, this.toString() + ": Received message : " + message.getClass().getName() + " " + message.toString());
                    if (message instanceof ReadDataMessage) {
                        String xmlFile = RestLogic.getInstance().exportProductsToPOS(new TablesFilter(){

                            @Override
                            public boolean acceptTable(Table u) {
                                return true;
                            }
                        }, new LocationsFilter(){

                            @Override
                            public boolean acceptLocation(Location u) {
                                return true;
                            }
                        });
                        String content = FileUtils.readFileToString(xmlFile);
                        ReadDataReply reply3 = new ReadDataReply(content);
                        this.outS.writeObject(reply3);
                        this.outS.flush();
                    }
                    if (message instanceof ReadNotificationsMessage) {
                        ReadNotificationsMessage rd = (ReadNotificationsMessage)message;
                        Vector messages = Messenger.getInstance().getMessages("pda_" + rd.getIdUser());
                        messages = Utils.getDistinct(messages);
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < messages.size(); ++i) {
                            Message mess = (Message)messages.elementAt(i);
                            sb.append(mess.getText());
                            if (i >= messages.size() - 1) continue;
                            sb.append(',');
                        }
                        reply2 = new ReadNotificationsReply(sb.toString());
                        this.outS.writeObject(reply2);
                        this.outS.flush();
                    }
                    if (message instanceof RefreshTableMessage) {
                        Vector<TableStatus> tables = new Vector<TableStatus>();
                        for (int i = 0; i < RestLogic.getInstance().getTables().size(); ++i) {
                            Table t1 = RestLogic.getInstance().getTables().elementAt(i);
                            Order o1 = RestLogic.getInstance().getOpenOrderAtTable(t1);
                            int idWaiter = -1;
                            String waiterName = "";
                            int status = -1;
                            if (o1 != null) {
                                idWaiter = o1.getUser();
                                status = o1.getStatus();
                                waiterName = UsersLogic.getInstance().getUserById(idWaiter).getLogin();
                                waiterName = TextUtils.escapeForXML(waiterName);
                            }
                            TableStatus ts = new TableStatus(idWaiter, t1.getId().intValue(), waiterName, status);
                            tables.add(ts);
                        }
                        reply = new RefreshTableReply(tables);
                        this.outS.writeObject(reply);
                        this.outS.flush();
                    }
                    if (message instanceof NotificationsAcknoledgedMessage) {
                        NotificationsAcknoledgedMessage nam = (NotificationsAcknoledgedMessage)message;
                        Messenger.getInstance().deleteMessagesByChannel("pda_" + nam.getIdUser());
                        reply = new NotificationsAcknoledgedReply();
                        this.outS.writeObject(reply);
                        this.outS.flush();
                    }
                    if (message instanceof LoginMessage) {
                        log = (LoginMessage)message;
                        User userFO = UsersLogic.getInstance().verifyWaiterLogin(((LoginMessage)log).getUser(), ((LoginMessage)log).getPassword());
                        int idUser = -1;
                        if (userFO != null) {
                            idUser = userFO.getId();
                        }
                        reply2 = new LoginReply(idUser);
                        this.outS.writeObject(reply2);
                        this.outS.flush();
                    }
                    if (message instanceof NotaMessage) {
                        NotaMessage notaMessage = (NotaMessage)message;
                        int idTable = notaMessage.getIdTable();
                        Table t = RestLogic.getInstance().getTableById(idTable);
                        o = RestLogic.getInstance().getOpenOrderAtTable(t);
                        User u2 = UsersLogic.getInstance().getUserById(o.getUser());
                        NotaReply reply4 = null;
                        if (o != null && o.getUser() == notaMessage.getIdUser()) {
                            RestLogic.getInstance().laPlataOrder(o, t, null);
                            reply4 = new NotaReply(true, u2.getLogin(), idTable, o.getStatus(), o.getUser());
                        } else {
                            reply4 = new NotaReply(false, "Masa deschisa pe alt ospatar (" + u2.getLogin() + ").");
                        }
                        this.outS.writeObject(reply4);
                        this.outS.flush();
                    }
                    if (message instanceof IncasatMessage) {
                        IncasatMessage incasatMessage = (IncasatMessage)message;
                        int idTable = incasatMessage.getIdTable();
                        Table t = RestLogic.getInstance().getTableById(idTable);
                        o = RestLogic.getInstance().getOpenOrderAtTable(t);
                        IncasatReply reply5 = null;
                        if (o != null && o.getUser() == incasatMessage.getIdUser()) {
                            if (o.isLaPlata()) {
                                if (VpConfig.getInstance().printFiscalFromPda) {
                                    RestLogic.getInstance().printBonFiscalSeparat(o, true);
                                }
                                RestLogic.getInstance().closeOrder(o);
                                reply5 = new IncasatReply(true, -1, t.getId());
                            } else {
                                reply5 = new IncasatReply(false, "Emiteti nota de plata intai.");
                            }
                        } else if (o != null) {
                            u = UsersLogic.getInstance().getUserById(o.getUser());
                            reply5 = new IncasatReply(false, "Masa deschisa pe alt ospatar (" + u.getLogin() + ").");
                        } else {
                            reply5 = new IncasatReply(true, -1, t.getId());
                        }
                        this.outS.writeObject(reply5);
                        this.outS.flush();
                    }
                    if (message instanceof MarcajMessage) {
                        log = (MarcajMessage)message;
                        BonMarcaj bm = ((MarcajMessage)log).getBonMarcaj();
                        if (bm.getSales().size() > 0) {
                            System.out.println("Received: " + ((MarcajMessage)log).toString());
                        }
                        Table t = RestLogic.getInstance().getTableById(bm.getIdMasa());
                        o = RestLogic.getInstance().getOpenOrderAtTable(t);
                        MarcajReply mreply = null;
                        if (o != null && o.getUser() != bm.getIdOspatar()) {
                            u = UsersLogic.getInstance().getUserById(o.getUser());
                            mreply = new MarcajReply(false, "Masa deschisa pe alt ospatar (" + u.getLogin() + ")");
                        } else {
                            if (o == null) {
                                o = RestLogic.getInstance().newOrder(bm.getIdMasa(), bm.getIdOspatar());
                            }
                            u = UsersLogic.getInstance().getUserById(o.getUser());
                            this.marcaj(bm.getSales(), o, t);
                            int maxPlatou = 0;
                            Vector<Sale> newSales = new Vector<Sale>();
                            if (o != null) {
                                Vector<ro.atreides.restaurant.base.Sale> sales = RestLogic.getInstance().getSales(o.getId(), true, -1, new ScreenSaleInterface());
                                for (int i = 0; i < sales.size(); ++i) {
                                    ro.atreides.restaurant.base.Sale o1 = sales.elementAt(i);
                                    if (o1.getCantitateMarcata() <= 0.0) continue;
                                    Sale s = new Sale(o1.getIdProduct(), o1.getProductName(), (float)o1.getPrice(), (float)o1.getCantitateMarcata(), o1.getIdPlatou());
                                    String prep = o1.getModPreparare();
                                    if (Validators.correctString(prep)) {
                                        s.setPreparare(prep);
                                    }
                                    if (o1.getIdPlatou() > maxPlatou) {
                                        maxPlatou = o1.getIdPlatou();
                                    }
                                    newSales.add(s);
                                }
                            }
                            mreply = new MarcajReply(true, newSales, maxPlatou, t.getId(), o.getStatus(), u.getId(), u.getLogin());
                        }
                        this.outS.writeObject(mreply);
                        this.outS.flush();
                    }
                    if (!(message instanceof PingMessage)) continue;
                    this.outS.writeObject(new PingReply());
                }
            }
            catch (SocketTimeoutException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            catch (SocketException e) {
            }
            catch (EOFException e) {
            }
            catch (IOException e) {
                Logger.logException(this, (Exception)e);
            }
            catch (Throwable th) {
                Logger.logError((Object)this, th);
                continue;
            }
            break;
        }
        Logger.logInfo(this, "Closing connection with : " + this.remoteIp);
        if (this.inputS != null) {
            try {
                this.inputS.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.outS != null) {
            try {
                this.outS.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.s != null) {
            try {
                this.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Logger.logInfo(this, "CLOSED connection with : " + this.remoteIp + " . Normal exit");
    }

    private void marcaj(Vector presales, Order o, Table t) {
        int i;
        if (presales.size() < 1 || o.isLaPlata()) {
            return;
        }
        Hashtable nonEmptySectii = new Hashtable();
        for (i = 0; i < presales.size(); ++i) {
            Sale sale = (Sale)presales.elementAt(i);
            int idProduct = sale.getIdProduct();
            Product product = NomeclaturaLogic.getInstance().getProductById(idProduct);
            Sectie c2 = NomeclaturaLogic.getInstance().getSectieByCategoryId(product.getIdCategorie());
            Vector<ro.atreides.restaurant.base.Sale> tempSales = (Vector<ro.atreides.restaurant.base.Sale>)nonEmptySectii.get(c2);
            if (tempSales == null) {
                tempSales = new Vector<ro.atreides.restaurant.base.Sale>();
            }
            double q = sale.getCantitateNoua();
            int idPlatou = sale.getIdPlatou();
            String preparare = sale.getPreparare();
            String optiuneS = "";
            int idOptiuneProdus = -1;
            if (Validators.correctInteger(optiuneS)) {
                idOptiuneProdus = Integer.parseInt(optiuneS);
            }
            if (q > 0.0) {
                long now = System.currentTimeMillis();
                String numeSectiePrefix = "";
                double price = RestLogic.getInstance().getPriceForProductCommit(idProduct);
                if (idOptiuneProdus != -1) {
                    price = RestLogic.getInstance().getPretOptiuneProdusById(idOptiuneProdus);
                    numeSectiePrefix = "_M_ ";
                }
                ro.atreides.restaurant.base.Sale ts = RestLogic.getInstance().buildSale(product, 0.0, q, preparare, -1, idPlatou, -1, -1, -1, now, price, numeSectiePrefix, 0);
                tempSales.add(ts);
            }
            if (tempSales.size() <= 0) continue;
            nonEmptySectii.put(c2, tempSales);
        }
        i = 1;
        int max = new Vector(nonEmptySectii.keySet()).size();
        for (Sectie sectie : nonEmptySectii.keySet()) {
            Vector sales = (Vector)nonEmptySectii.get(sectie);
            boolean cutter = i == max;
            RestLogic.getInstance().productsSold(sales, o, t, sectie, false, null, cutter);
            ++i;
        }
    }
}

