/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.rezervari;

import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import ro.atreides.restaurant.modules.rezervari.CazariBean;
import ro.atreides.restaurant.modules.rezervari.ListaCamereCell;
import ro.atreides.utils.Client;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.gui.table.AbstractTM;

public class HotelCazariCellRenderer
extends DefaultTableCellRenderer {
    private AbstractTM model;

    public HotelCazariCellRenderer(AbstractTM model) {
        this.model = model;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        CazariBean line = (CazariBean)this.model.getData().elementAt(row);
        if (column == 2) {
            ListaCamereCell cell1 = line.getLooks();
            this.setBackground(cell1.getBackground());
            this.setForeground(cell1.getForeground());
        } else if (line.isSelected()) {
            this.setBackground(Color.BLACK);
            this.setForeground(Color.WHITE);
        } else {
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
        }
        String text = "";
        if (line.getIdCalendar() > 0) {
            Date start = line.getStart();
            String s1 = "-";
            if (start != null) {
                s1 = Formatters.DATE_AND_TIME_FORMAT.format(start);
            }
            String s2 = "-";
            Date stop = line.getStop();
            if (stop != null) {
                s2 = Formatters.DATE_AND_TIME_FORMAT.format(stop);
            }
            String client = "-";
            Client c = line.getTurist();
            if (c != null) {
                client = c.toString();
            }
            String dateContact = "-";
            if (c != null) {
                dateContact = c.getDateContact("<br><li>");
            }
            text = "<html>Camera: " + line.getCamera() + "<br>Id: " + line.getIdCalendar() + "<br>Client: " + client + "<br>" + "Start: " + s1 + "<br>" + "Stop: " + s2 + "<br>" + "Date contact: " + dateContact;
            text = text + "</html>";
        }
        this.setToolTipText(text);
        return this;
    }
}

