/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.rezervari;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import net.sf.jooreports.templates.DocumentTemplate;
import net.sf.jooreports.templates.DocumentTemplateException;
import net.sf.jooreports.templates.DocumentTemplateFactory;
import ro.atreides.clienti.AltAct;
import ro.atreides.clienti.BiCi;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.clienti.ClientPersFizica;
import ro.atreides.clienti.ClientPersJuridica;
import ro.atreides.facturi.FacturiEmiseView;
import ro.atreides.facturi.FacturiLogic;
import ro.atreides.facturi.gui.AddFacturaDialog;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.print.PrintLogic;
import ro.atreides.print.PrintUtils;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.RaportPeCategoriiSiCoteTva;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.ScreenSaleInterface;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.base.reports.SalesEntry;
import ro.atreides.restaurant.gui.hotel.HotelNrNoptiZeroException;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.rezervari.AvansStornatInterface;
import ro.atreides.restaurant.modules.rezervari.CameraId;
import ro.atreides.restaurant.modules.rezervari.CamereAsociateBean;
import ro.atreides.restaurant.modules.rezervari.CazareTaxeBean;
import ro.atreides.restaurant.modules.rezervari.CazariBean;
import ro.atreides.restaurant.modules.rezervari.CazariLipsaException;
import ro.atreides.restaurant.modules.rezervari.CazariReportBean;
import ro.atreides.restaurant.modules.rezervari.Column;
import ro.atreides.restaurant.modules.rezervari.HotelGroup;
import ro.atreides.restaurant.modules.rezervari.ListaCamereCell;
import ro.atreides.restaurant.modules.rezervari.ListaCamereView;
import ro.atreides.restaurant.modules.rezervari.PriceQuantityBean;
import ro.atreides.restaurant.modules.rezervari.RaportDetaliatBean;
import ro.atreides.restaurant.modules.rezervari.RezervareBean;
import ro.atreides.restaurant.modules.rezervari.RezervariDao;
import ro.atreides.restaurant.modules.rezervari.RezervariMeseView;
import ro.atreides.restaurant.modules.rezervari.ZiHotelieraBean;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.AtrFloat;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.NoteView;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.events.EventsLogic;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.TipPlataValue;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;

public class RezervariLogic
extends EventGenerator {
    public static final int LIBERA = 1;
    public static final String LIBERA_LABEL = "Libere";
    public static final int REZERVARI = 2;
    public static final String REZERVARI_LABEL = "Rezervari";
    public static final int SOSIRI = 3;
    public static final String SOSIRI_LABEL = "Sosiri";
    public static final int CAZATA = 4;
    public static final String CAZATA_LABEL = "Cazari";
    public static final int CHECKOUT = 5;
    public static final String CHECKOUT_LABEL = "Checkout";
    public static final int ISTORIC = 6;
    public static final String ISTORIC_LABEL = "Istoric";
    public static final String SEX_NA_LABEL = "";
    public static final int SEX_NA = -1;
    public static final String SEX_NA_LABEL_LONG = "Necompletat";
    public static final String SEX_M_LABEL = "M";
    public static final String SEX_M_LABEL_LONG = "Masculin";
    public static final int SEX_M = 1;
    public static final String SEX_F_LABEL = "F";
    public static final String SEX_F_LABEL_LONG = "Feminin";
    public static final int SEX_F = 2;
    public static final String SEX_C_LABEL = "C";
    public static final String SEX_C_LABEL_LONG = "Cuplu";
    public static final int SEX_C = 3;
    public static final String STATUS_KEY = LangRoAll.status;
    private static RezervariLogic instance;
    public static final String SOLD_INITIAL_KEY = "hotelSoldInitial";
    private ConnectionPool pool = ConnectionPool.getInstance();

    private synchronized RezervariDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        RezervariDao dao = null;
        while (dao == null) {
            dao = (RezervariDao)this.pool.getDao(RezervariDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(RezervariDao.class.getName(), connection);
        }
        return dao;
    }

    private RezervariLogic() {
        Thread statusUpdateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    RezervariLogic.this.updateStatusAllRoomsPeriodically();
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        });
        statusUpdateThread.setName("Status update thread");
        statusUpdateThread.start();
    }

    public static synchronized RezervariLogic getInstance() {
        if (instance == null) {
            instance = new RezervariLogic();
        }
        return instance;
    }

    public static Vector getRezervariIntervals(Date start, Date stop) {
        Vector<Column> result = new Vector<Column>();
        if (stop.getTime() - start.getTime() < DateUtils.dayMillis) {
            Date d = start;
            while (d.compareTo(stop) < 0) {
                Column c = new Column(Formatters.TIME_FORMAT.format(d), d);
                d = DateUtils.addMinutesToDate(d, VpConfig.getInstance().rezervariStepMinutes);
                c.setStop(d);
                result.add(c);
            }
        } else {
            Date d = start;
            while (d.compareTo(stop) < 0) {
                Column c = new Column(Formatters.REZERVARI_FORMAT.format(d), d);
                d = DateUtils.addDaysToDate(d, 1);
                c.setStop(d);
                result.add(c);
            }
        }
        return result;
    }

    private Map<Integer, RezervareBean> getStatusNoCommit(int idTable, Timestamp start, Timestamp stop, int idOrder, int idGrup) throws SQLException {
        return this.getDao().getInfo(start, stop, idTable, idOrder, idGrup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RezervareBean getCurrentRezervareForOrder(int idOrder, int idTable) {
        try {
            RezervareBean rezervareBean = this.getCurrentRezervareBeanNoCommit(idOrder, idTable);
            return rezervareBean;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            RezervareBean rezervareBean = null;
            return rezervareBean;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public RezervareBean getCurrentRezervareBeanNoCommit(int idOrder, int idTable) throws SQLException {
        Map<Integer, RezervareBean> statusNoCommit = this.getStatusNoCommit(idTable, DateUtils.getStartOfDays(), DateUtils.getEndOfDays(), idOrder, -1);
        Iterator<RezervareBean> i$ = statusNoCommit.values().iterator();
        if (i$.hasNext()) {
            RezervareBean rezervareBean = i$.next();
            return rezervareBean;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<CazariBean> getListaCazariRezervari(Hashtable criteria, Component parent) {
        Vector<CazariBean> result = new Vector<CazariBean>();
        Location loc = (Location)criteria.get(Constants.LOCATIE_KEY);
        Vector<Table> tables = loc != null ? RestLogic.getInstance().getTablesByLocationSortedByName(loc.getId()) : RestLogic.getInstance().getCamereSortedByName();
        Table t = (Table)criteria.get(Constants.TABLE_KEY);
        if (t != null) {
            tables.clear();
            tables.add(t);
        }
        int requestedClient = -1;
        Client c = (Client)criteria.get(Constants.CLIENT_KEY);
        if (c != null) {
            requestedClient = c.getId();
        }
        int s1 = -1;
        Integer i1 = (Integer)criteria.get(STATUS_KEY);
        if (i1 != null) {
            s1 = i1;
        }
        int s2 = -1;
        Integer i2 = (Integer)criteria.get(Constants.GROUP_KEY);
        if (i2 != null) {
            s2 = i2;
        }
        Date start = (Date)criteria.get(Constants.START_KEY);
        Date stop = (Date)criteria.get(Constants.STOP_KEY);
        try {
            Map<Integer, RezervareBean> infos = this.getStatusNoCommit(-1, new Timestamp(start.getTime()), new Timestamp(stop.getTime()), -1, s2);
            Hashtable<Integer, Client> societatiCache = new Hashtable<Integer, Client>();
            Hashtable<Integer, Product> productCache = new Hashtable<Integer, Product>();
            Vector<Integer> idCalendar1 = new Vector<Integer>(infos.keySet());
            Map<Integer, Vector<RezervariMeseView>> rezervariMeseForCalendars = this.getRezervariMeseForCalendarIdsNoCommit(idCalendar1);
            Vector<Integer> ordersForValori = new Vector<Integer>();
            for (Integer idCalendar : infos.keySet()) {
                RezervareBean rb = infos.get(idCalendar);
                int idOrder = rb.getIdOrder();
                if (idOrder <= 0) continue;
                ordersForValori.add(idOrder);
            }
            Map<Integer, CazariBean> getTotaluriForOrders = this.getTotaluriForOrders(ordersForValori, parent);
            for (Integer idCalendar : infos.keySet()) {
                CazariBean cb1;
                CazariBean cb = new CazariBean();
                RezervareBean rb = infos.get(idCalendar);
                if (s1 != -1 && s1 != rb.getStatus() || requestedClient != -1 && rb.getIdClient() != requestedClient) continue;
                cb.setIdCalendar(rb.getIdCalendar());
                cb.setCamera(rb.getNumeCamera());
                cb.setIdCamera(rb.getIdTable());
                cb.setStatus(rb.getStatus());
                int idOrder = rb.getIdOrder();
                cb.setIdOrder(idOrder);
                cb.setTarifValoare(rb.getTarif());
                int idTurist = rb.getIdClient();
                cb.setIdClient(idTurist);
                cb.setTurist(ClientLogic.getInstance().getClientByIdNoCommit(idTurist));
                int idAgentie = rb.getIdAgentie();
                Client agentie = (Client)societatiCache.get(idAgentie);
                if (agentie == null && (agentie = ClientLogic.getInstance().getClientByIdNoCommit(idAgentie)) != null) {
                    societatiCache.put(idAgentie, agentie);
                }
                cb.setSocietate(agentie);
                cb.setIdSocietate(idAgentie);
                cb.setStart(rb.getStart());
                cb.setStop(rb.getStop());
                int idProduct = rb.getIdProduct();
                Product product = (Product)productCache.get(idProduct);
                if (product == null) {
                    product = NomeclaturaLogic.getInstance().getProductByIdNoCommit(idProduct);
                    productCache.put(idProduct, product);
                }
                cb.setTarifNume(product.getName());
                cb.setAvans(rb.getAvans());
                cb.setAvansStornatDeja(rb.isStornatAvansFactura());
                String s = SEX_NA_LABEL;
                Vector<RezervariMeseView> serviciiMese = rezervariMeseForCalendars.get(idCalendar);
                for (RezervariMeseView rezervariMeseView : serviciiMese) {
                    int nrPersoane = rezervariMeseView.getNrPersoane();
                    if (nrPersoane <= 0) continue;
                    s = s + rezervariMeseView.getProduct() + "=" + nrPersoane + ",";
                }
                if (s.length() > 2) {
                    s = s.substring(0, s.length() - 1);
                }
                cb.setServicii(s);
                cb.setNrPersoane(rb.getNumarPersoane());
                cb.setIdGrup(rb.getIdGrup());
                if (idOrder > 0 && (cb1 = getTotaluriForOrders.get(idOrder)) != null) {
                    cb.setValoareCazareNefacturata(cb1.getValoareCazareNefacturata());
                    cb.setValoareServiciiNefacturate(cb1.getValoareServiciiNefacturate());
                    cb.setValoareServiciiNeincasate(cb1.getValoareServiciiNeincasate());
                    cb.setValoareCazareNeincasata(cb1.getValoareCazareNeincasata());
                    cb.setCazarePlatita(cb1.getCazarePlatita());
                    cb.setServiciiPlatite(cb1.getServiciiPlatite());
                    cb.setTotalCazare(cb1.getTotalCazare());
                    cb.setTotalServicii(cb1.getTotalServicii());
                }
                result.add(cb);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Map<Integer, CazariBean> getTotaluriForOrders(Vector<Integer> orders, Component parent) throws SQLException {
        Hashtable<Integer, CazariBean> result = new Hashtable<Integer, CazariBean>();
        Product productTaxe = NomeclaturaLogic.getInstance().getProductByCod(VpConfig.getInstance().hotelTaxeCodProdus);
        if (productTaxe == null) {
            DialogUtils.errorDialog(parent, "Produs Taxe neconfigurat", LangRoAll.nuPotContinua);
            return new Hashtable<Integer, CazariBean>();
        }
        Product productCazare = NomeclaturaLogic.getInstance().getProductByCod(VpConfig.getInstance().hotelCodProdusCazare);
        if (productCazare == null) {
            DialogUtils.errorDialog(parent, "Produs Cazare neconfigurat", LangRoAll.nuPotContinua);
            return new Hashtable<Integer, CazariBean>();
        }
        String hotelCodProdusServicii = VpConfig.getInstance().hotelCodProdusServicii;
        Hashtable<Tva, Product> productServiciiPerTva = new Hashtable<Tva, Product>();
        Vector pairs = Utils.splitString(hotelCodProdusServicii, ',');
        for (String pair : pairs) {
            Vector values = Utils.splitString(pair, '=');
            if (values.size() != 2) {
                DialogUtils.errorDialog(parent, "hotelCodProdusServicii : configurare incorecta !! (cotaTva=codProdus)", LangRoAll.nuPotContinua);
                return new Hashtable<Integer, CazariBean>();
            }
            String cotaTvaS = (String)values.get(0);
            String codProdus = (String)values.get(1);
            if (!Validators.correctInteger(codProdus)) {
                DialogUtils.errorDialog(parent, "hotelOrder: codProdus " + codProdus + " nu e un numar !!", LangRoAll.nuPotContinua);
                return new Hashtable<Integer, CazariBean>();
            }
            int codProdusI = Integer.parseInt(codProdus);
            Product p = NomeclaturaLogic.getInstance().getProductByCod(codProdusI);
            if (p == null) {
                DialogUtils.errorDialog(parent, "hotelOrder: nu am gasit produsul cu codul " + codProdusI, LangRoAll.nuPotContinua);
                return new Hashtable<Integer, CazariBean>();
            }
            Tva tva = TvaLogic.getInstance().getTvaByCota(Utils.parseDouble(cotaTvaS));
            if (tva == null) {
                DialogUtils.errorDialog(parent, "hotelOrder: Nu am gasit cota TVA " + cotaTvaS, LangRoAll.nuPotContinua);
                return new Hashtable<Integer, CazariBean>();
            }
            productServiciiPerTva.put(tva, p);
        }
        Vector<Categorie> categoriiServicii = new Vector<Categorie>();
        Vector numeCategorii = Utils.splitString(VpConfig.getInstance().hotelCategoriiServicii, ',');
        for (String categName : numeCategorii) {
            Categorie c = NomeclaturaLogic.getInstance().getCategoryByName(categName);
            if (c == null) continue;
            categoriiServicii.add(c);
        }
        Vector<Sale> allSales = RestLogic.getInstance().getSalesForIdOrdersNoCommitNoSortNoCumulate(orders);
        for (Sale sale : allSales) {
            int idOrder = sale.getIdOrder();
            CazariBean curr = (CazariBean)result.get(idOrder);
            if (curr == null) {
                curr = new CazariBean();
                result.put(idOrder, curr);
            }
            double valoare = sale.getPrice() * sale.getCantitateMarcata();
            if (RezervariLogic.isProdusCazare(sale, productCazare) || RezervariLogic.isProdusTaxa(sale, productTaxe)) {
                if (!sale.isFacturata()) {
                    curr.setValoareCazareNefacturata(curr.getValoareCazareNefacturata() + valoare);
                }
                if (sale.isPrinted()) {
                    curr.setCazarePlatita(curr.getCazarePlatita() + valoare);
                } else {
                    curr.setValoareCazareNeincasata(curr.getValoareCazareNeincasata() + valoare);
                }
                curr.setTotalCazare(curr.getTotalCazare() + valoare);
                continue;
            }
            if (!sale.isFacturata()) {
                curr.setValoareServiciiNefacturate(curr.getValoareServiciiNefacturate() + valoare);
            }
            if (sale.isPrinted()) {
                curr.setServiciiPlatite(curr.getServiciiPlatite() + valoare);
            } else {
                curr.setValoareServiciiNeincasate(curr.getValoareServiciiNeincasate() + valoare);
            }
            curr.setTotalServicii(curr.getTotalServicii() + valoare);
        }
        return result;
    }

    public static boolean isProdusTaxa(Sale toCheck, Product productTaxa) {
        int idCateg = toCheck.getIdCategorie();
        return idCateg == productTaxa.getIdCategorie();
    }

    public static boolean isProdusServiciu(Sale toCheck, Product productServicii, Vector<Categorie> categoriiServicii) {
        boolean found;
        block1: {
            Categorie cat;
            int idCateg = toCheck.getIdCategorie();
            boolean bl = found = idCateg == productServicii.getIdCategorie();
            if (found) break block1;
            Iterator<Categorie> i$ = categoriiServicii.iterator();
            while (i$.hasNext() && !(found = idCateg == (cat = i$.next()).getId())) {
            }
        }
        return found;
    }

    public static boolean isProdusCazare(Sale toCheck, Product productCazare) {
        int idCateg = toCheck.getIdCategorie();
        return RezervariLogic.isProdusCazare(productCazare, idCateg);
    }

    private static boolean isProdusCazare(Product productCazare, int idCateg) {
        return idCateg == productCazare.getIdCategorie();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ListaCamereView> getListaCamere(Hashtable criteria, Vector<Column> intervals, Date startReport, Date stopReport, Map<Integer, Client> clientMap) {
        Vector<ListaCamereView> result = new Vector<ListaCamereView>();
        Location loc = (Location)criteria.get(Constants.LOCATIE_KEY);
        Vector<Table> tables = loc != null ? RestLogic.getInstance().getTablesByLocationSortedByName(loc.getId()) : RestLogic.getInstance().getCamereSortedByName();
        Table t = (Table)criteria.get(Constants.TABLE_KEY);
        if (t != null) {
            tables.clear();
            tables.add(t);
        }
        int requestedClient = -1;
        Client c = (Client)criteria.get(Constants.CLIENT_KEY);
        if (c != null) {
            requestedClient = c.getId();
        }
        int s1 = -1;
        Integer i1 = (Integer)criteria.get(STATUS_KEY);
        if (i1 != null) {
            s1 = i1;
        }
        int s2 = -1;
        Integer i2 = (Integer)criteria.get(Constants.GROUP_KEY);
        if (i2 != null) {
            s2 = i2;
        }
        boolean filtered = s1 != -1 || s2 != -1;
        try {
            for (int i = 0; i < tables.size(); ++i) {
                Table table = tables.elementAt(i);
                if (table.getLabel().startsWith("0410")) {
                    System.out.println("Camera 410");
                }
                boolean clientOK = false;
                boolean filtersOK = false;
                double ocupareForCameraInPerioada = 0.0;
                Map<Column, Vector<RezervareBean>> infoForTable = Collections.synchronizedMap(new LinkedHashMap());
                int lineCountForTable = 1;
                for (int j = 0; j < intervals.size(); ++j) {
                    Column column = intervals.elementAt(j);
                    Map<Integer, RezervareBean> infos = this.getStatusNoCommit(table.getId(), new Timestamp(column.getStart().getTime()), new Timestamp(column.getStop().getTime()), -1, s2);
                    if (infos.size() > 0) {
                        ocupareForCameraInPerioada += 1.0;
                    }
                    if (lineCountForTable < infos.size()) {
                        lineCountForTable = infos.size();
                    }
                    infoForTable.put(column, new Vector<RezervareBean>(infos.values()));
                }
                Map<Integer, RezervareBean> allRezervariInPeriod = this.getStatusNoCommit(table.getId(), new Timestamp(startReport.getTime()), new Timestamp(stopReport.getTime()), -1, s2);
                Hashtable<Integer, Integer> position = new Hashtable<Integer, Integer>();
                for (Integer idCalendar : allRezervariInPeriod.keySet()) {
                    Integer existingPosition = (Integer)position.get(idCalendar);
                    RezervareBean currentBean = allRezervariInPeriod.get(idCalendar);
                    if (existingPosition != null) continue;
                    int nextPosition = -1;
                    boolean foundEmptySlot = false;
                    while (!foundEmptySlot) {
                        ++nextPosition;
                        foundEmptySlot = true;
                        for (RezervareBean checkAgainst : allRezervariInPeriod.values()) {
                            Integer checkAgainstPosition;
                            if (checkAgainst.getIdCalendar() == idCalendar.intValue() || currentBean.getStop().before(checkAgainst.getStart()) || checkAgainst.getStop().before(currentBean.getStart()) || (checkAgainstPosition = (Integer)position.get(checkAgainst.getIdCalendar())) == null || nextPosition != checkAgainstPosition) continue;
                            foundEmptySlot = false;
                        }
                    }
                    position.put(idCalendar, nextPosition);
                }
                for (int k = 0; k < lineCountForTable; ++k) {
                    Vector<ListaCamereCell> cells = new Vector<ListaCamereCell>();
                    RezervareBean lastRezervare = null;
                    Object lastCell = null;
                    for (int j = 0; j < intervals.size(); ++j) {
                        Column column = intervals.elementAt(j);
                        Vector infos = (Vector)infoForTable.get(column);
                        String content = SEX_NA_LABEL;
                        ListaCamereCell cell = new ListaCamereCell(table.getLabel());
                        cell.setIdTable(table.getId());
                        RezervareBean info = null;
                        for (RezervareBean infoCursor : infos) {
                            int idCalendar = infoCursor.getIdCalendar();
                            Integer destinationPoz = (Integer)position.get(idCalendar);
                            if (destinationPoz == null) {
                                System.out.println("Destination position is null, will default to 0 ");
                                destinationPoz = 0;
                            }
                            if (destinationPoz != k) continue;
                            info = infoCursor;
                        }
                        if (info == null) {
                            info = new RezervareBean();
                            info.setStatus(1);
                            info.setIdClient(-1);
                        }
                        int status = info.getStatus();
                        int clientId = info.getIdClient();
                        int groupId = info.getIdGrup();
                        if (requestedClient == clientId) {
                            clientOK = true;
                            if (requestedClient != -1) {
                                content = "*";
                            }
                        }
                        if (status != 1) {
                            if (lastRezervare != null && info != null) {
                                cell.setBeginningCell(info.getIdCalendar() != lastRezervare.getIdCalendar());
                            } else if (lastRezervare == null) {
                                cell.setBeginningCell(true);
                            }
                            lastRezervare = info;
                            Client client = clientMap.get(clientId);
                            if (client == null) {
                                client = ClientLogic.getInstance().getClientByIdNoCommit(clientId);
                                clientMap.put(clientId, client);
                            }
                            cell.setClient(client);
                            cell.setIdCalendar(info.getIdCalendar());
                            Timestamp start = info.getStart();
                            cell.setStart(start);
                            Timestamp stop = info.getStop();
                            cell.setStop(stop);
                            cell.setIdProduct(info.getIdProduct());
                            cell.setIdPromotion(info.getIdPromo());
                            int sex = info.getIdSex();
                            cell.setSex(sex);
                            content = Validators.correctString(content) ? content + " / " + this.getShortStringForSex(sex) : this.getShortStringForSex(sex);
                        }
                        cell.setStatus(status);
                        cell.setText(content);
                        cell.setInfo(info);
                        ListaCamereCell looks = RezervariLogic.getLooks(status);
                        cell.setBackground(looks.getBackground());
                        cell.setForeground(looks.getForeground());
                        cell.setStatusString(looks.getStatusString());
                        if (s1 != -1 && s1 != status || s2 != -1 && s2 != groupId) {
                            cell = new ListaCamereCell(table.getLabel());
                            cell.setBackground(Color.WHITE);
                            cell.setForeground(Color.BLACK);
                            cell.setStatusString(LIBERA_LABEL);
                            cell.setText(content);
                        } else {
                            filtersOK = true;
                        }
                        cells.add(cell);
                    }
                    double gradOcupareInPerioada = FloatUtils.roundDoubleUp(ocupareForCameraInPerioada / (double)intervals.size() * 100.0, 2);
                    if (!clientOK && requestedClient != -1 || filtered && !filtersOK) continue;
                    ListaCamereView unu = new ListaCamereView(cells, table.getLabel() + " - " + table.getLocuri(), table.getLocuri(), table.getId(), gradOcupareInPerioada, lineCountForTable > 1);
                    unu.setMurdara(table.isMurdara());
                    unu.setDefecta(table.isDefecta());
                    result.add(unu);
                }
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public static ListaCamereCell getLooks(int status) {
        ListaCamereCell cell = new ListaCamereCell(SEX_NA_LABEL);
        switch (status) {
            case 1: {
                cell.setBackground(Color.WHITE);
                cell.setForeground(Color.BLACK);
                cell.setStatusString(LIBERA_LABEL);
                break;
            }
            case 2: {
                cell.setBackground(Color.CYAN);
                cell.setForeground(Color.BLACK);
                cell.setStatusString(REZERVARI_LABEL);
                break;
            }
            case 3: {
                cell.setBackground(Color.GREEN);
                cell.setForeground(Color.BLACK);
                cell.setStatusString(SOSIRI_LABEL);
                break;
            }
            case 4: {
                cell.setBackground(Color.ORANGE);
                cell.setForeground(Color.BLACK);
                cell.setStatusString(CAZATA_LABEL);
                break;
            }
            case 5: {
                cell.setBackground(Color.RED);
                cell.setForeground(Color.BLACK);
                cell.setStatusString(CHECKOUT_LABEL);
                break;
            }
            case 6: {
                cell.setBackground(Color.LIGHT_GRAY);
                cell.setForeground(Color.BLACK);
                cell.setStatusString(ISTORIC_LABEL);
            }
        }
        return cell;
    }

    public String getShortStringForSex(int sex) {
        switch (sex) {
            case 3: {
                return SEX_C_LABEL;
            }
            case 2: {
                return SEX_F_LABEL;
            }
            case 1: {
                return SEX_M_LABEL;
            }
        }
        return SEX_NA_LABEL;
    }

    public String getLongStringForSex(int sex) {
        switch (sex) {
            case 3: {
                return SEX_C_LABEL_LONG;
            }
            case 2: {
                return SEX_F_LABEL_LONG;
            }
            case 1: {
                return SEX_M_LABEL_LONG;
            }
        }
        return SEX_NA_LABEL_LONG;
    }

    public Vector buildSexItems() {
        Vector<String> result = new Vector<String>();
        result.add(SEX_NA_LABEL_LONG);
        result.add(SEX_M_LABEL_LONG);
        result.add(SEX_F_LABEL_LONG);
        result.add(SEX_C_LABEL_LONG);
        return result;
    }

    public int getIdSexForString(String s) {
        if (s.equalsIgnoreCase(SEX_M_LABEL_LONG)) {
            return 1;
        }
        if (s.equalsIgnoreCase(SEX_F_LABEL_LONG)) {
            return 2;
        }
        if (s.equalsIgnoreCase(SEX_C_LABEL_LONG)) {
            return 3;
        }
        return -1;
    }

    public String isCameraTakenNoCommit(int idTable, Timestamp start, Timestamp stop, int idCalendar) throws SQLException {
        Map<Integer, RezervareBean> info1 = this.getDao().getInfo(start, stop, idTable, -1, -1);
        if (info1.size() == 0) {
            return null;
        }
        String result = "ocupata intre ";
        boolean celPutin1Ocupare = false;
        for (Integer id : info1.keySet()) {
            RezervareBean info = info1.get(id);
            int status = info.getStatus();
            int existingId = info.getIdCalendar();
            if (status == 1 || existingId == idCalendar) continue;
            Timestamp startInfo = info.getStart();
            Timestamp stopInfo = info.getStop();
            String s1 = Formatters.DATE_AND_TIME_FORMAT.format(startInfo) + " - " + Formatters.DATE_AND_TIME_FORMAT.format(stopInfo);
            result = result + s1 + ",";
            celPutin1Ocupare = true;
        }
        if (celPutin1Ocupare) {
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Table> getCamere(Vector<ListaCamereView> camereSelectate) {
        Vector<Table> camere = new Vector<Table>();
        try {
            for (ListaCamereView listaCamereView : camereSelectate) {
                int idTable = listaCamereView.getIdCamera();
                Table t = RestLogic.getInstance().getTableByIdNoCommit(idTable);
                camere.add(t);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return camere;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String verificaRezervari(Vector<Table> tables, Timestamp start, Timestamp stop, int idCalendar, String lineEnding) {
        String result = null;
        try {
            for (Table table : tables) {
                String pResult = this.isCameraTakenNoCommit(table.getId(), start, stop, idCalendar);
                if (pResult == null) continue;
                String toAppend = lineEnding + table.getLabel() + ": " + pResult;
                if (result == null) {
                    result = toAppend;
                    continue;
                }
                result = result + toAppend;
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    @Deprecated
    public Order getOpenOrderAtTable(Table t) {
        return RestLogic.getInstance().getOpenOrderAtTable(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<HotelGroup> getAllActiveGroups() {
        try {
            Vector<HotelGroup> vector = this.getAllActiveGroupsNoCommit();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<HotelGroup> vector = new Vector<HotelGroup>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private Vector<HotelGroup> getAllActiveGroupsNoCommit() throws SQLException {
        return this.getDao().getAllActiveGroups();
    }

    public HotelGroup getHotelGroupByIdNoCommit(int id) throws SQLException {
        return this.getDao().getHotelGroupById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HotelGroup getHotelGroupById(int id) {
        try {
            HotelGroup hotelGroup = this.getHotelGroupByIdNoCommit(id);
            return hotelGroup;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            HotelGroup hotelGroup = null;
            return hotelGroup;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void adaugaRezervare(int idTable, String detalii, int idClient, Timestamp start, Timestamp stop, int idProduct, int idPromotion, Vector mesePersoane, boolean checkin, int idUser, int sex, double tarif, int idAgentie, int numarPersoane, int idGrup, int idOrder, double avans) {
        try {
            this.getDao().addCalendar(idTable, detalii, idClient, start, stop, idProduct, idPromotion, sex, tarif, idAgentie, numarPersoane, idGrup, idOrder, avans);
            int idCalendar = this.pool.getIdentityLocal();
            for (int i = 0; i < mesePersoane.size(); ++i) {
                RezervariMeseView rezervariMeseView = (RezervariMeseView)mesePersoane.elementAt(i);
                this.getDao().addMasePersoaneEntry(idCalendar, rezervariMeseView.getIdProduct(), rezervariMeseView.getNrPersoane());
            }
            if (checkin) {
                this.getDao().updateStatus(idCalendar, 4);
            }
            this.updateStatusAtCamera(idCalendar);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stergeRezervare(int id, User supervizor, ListaCamereView lcv, ListaCamereCell cell) {
        try {
            Timestamp start = cell.getStart();
            String s1 = Formatters.DATE_AND_TIME_FORMAT.format(start);
            Timestamp stop = cell.getStop();
            String s2 = Formatters.DATE_AND_TIME_FORMAT.format(stop);
            Client c = cell.getClient();
            String client = c.toString();
            String dateContact = c.getDateContact(", ");
            String text = lcv.getLabel() + " Client: " + client + "; " + "Start: " + s1 + "; " + "Stop: " + s2 + "; Date contact: " + dateContact;
            RestLogic.getInstance().addCorrectionNoCommit(supervizor, "Rezervare", 1.0, text, 1.0);
            String action = SEX_NA_LABEL;
            switch (cell.getStatus()) {
                case 2: {
                    action = "Sters rezervare ";
                    break;
                }
                case 3: {
                    action = "Sters sosire ";
                    break;
                }
                case 4: {
                    action = "Sters cazare ";
                    break;
                }
                case 5: {
                    action = "Sters checkout ";
                }
            }
            UsersLogic.getInstance().addUserLogNoCommit(supervizor.getId(), action + text);
            this.getDao().deleteCalendar(id);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stergeRezervareGoala(int id) {
        try {
            this.getDao().deleteCalendar(id);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void updateCheckin(int idCamera, int idPromotie, int idClient, int idOrder) throws SQLException {
        Table t = RestLogic.getInstance().getTableById(idCamera);
        Order o = RestLogic.getInstance().getOrderById(idOrder);
        if (o != null) {
            RestLogic.getInstance().setClientAndPromotionForOrderNoCommit(o, idClient, idPromotie);
        }
    }

    public void checkout(int idOrder) throws SQLException {
        this.getDao().checkoutAtCamera(idOrder);
    }

    public void updateStatusForCalendarNoCommit(int idCalendar, int newStatus) throws SQLException {
        this.getDao().updateStatus(idCalendar, newStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutaRezervare(int idCalendar, int idTable) {
        try {
            this.getDao().updateCamera(idCalendar, idTable);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modificareRezervare(int idCalendar, Timestamp newStart, Timestamp newStop, int idClient, int idProduct, int idPromotie, Vector mesePersoane, boolean checkin, int idUser, int idCamera, boolean alreadyCheckedInd, int sex, int idOrder, int idAgentie, int nrPersoane, double tarif, int idGrup, String detalii, double avans) {
        try {
            this.getDao().updateStart(idCalendar, newStart);
            this.getDao().updateStop(idCalendar, newStop);
            this.getDao().updateCamera(idCalendar, idCamera);
            this.getDao().updateIdClient(idCalendar, idClient);
            this.getDao().updateIdProduct(idCalendar, idProduct);
            this.getDao().updateIdPromo(idCalendar, idPromotie);
            this.getDao().updateSex(idCalendar, sex);
            this.getDao().setIdAgentie(idAgentie, idCalendar);
            this.getDao().setNrPers(nrPersoane, idCalendar);
            this.getDao().setTarif(tarif, idCalendar);
            this.getDao().setIdGrup(idGrup, idCalendar);
            this.getDao().deleteMesePersoaneEntry(idCalendar);
            this.getDao().updateDetalii(detalii, idCalendar);
            this.getDao().updateAvans(avans, idCalendar);
            for (int i = 0; i < mesePersoane.size(); ++i) {
                RezervariMeseView rezervariMeseView = (RezervariMeseView)mesePersoane.elementAt(i);
                this.getDao().addMasePersoaneEntry(idCalendar, rezervariMeseView.getIdProduct(), rezervariMeseView.getNrPersoane());
            }
            if (checkin) {
                this.getDao().updateStatus(idCalendar, 4);
                this.getDao().setIdOrder(idOrder, idCalendar);
            } else if (alreadyCheckedInd) {
                this.updateCheckin(idCamera, idPromotie, idClient, idOrder);
            }
            this.updateStatusAtCamera(idCalendar);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraAsociate(int idHost, Vector<RezervareBean> guests) {
        try {
            this.getDao().deleteCamereAsociate(idHost);
            for (RezervareBean guest : guests) {
                this.getDao().addCameraAsociata(idHost, guest.getIdCalendar());
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RezervareBean getRezervareBeanById(int idCalendar) {
        try {
            RezervareBean rezervareBean = this.getRezervareBeanByIdNoCommit(idCalendar);
            return rezervareBean;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            RezervareBean rezervareBean = null;
            return rezervareBean;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public RezervareBean getRezervareBeanByIdNoCommit(int idCalendar) throws SQLException {
        return this.getDao().getRezervareById(idCalendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<RezervareBean> getCamereAsociate(int idHost) {
        Vector<RezervareBean> result = new Vector<RezervareBean>();
        try {
            Vector<CamereAsociateBean> beans = this.getDao().getCamereAsociate(idHost);
            for (CamereAsociateBean cab : beans) {
                RezervareBean bean = this.getRezervareBeanByIdNoCommit(cab.getIdGuest());
                result.add(bean);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<RezervariMeseView> getRezervariMeseViews(int idCalendar) {
        Vector<RezervariMeseView> result = new Vector<RezervariMeseView>();
        if (idCalendar > 0) {
            try {
                Vector<Integer> v = new Vector<Integer>();
                v.add(idCalendar);
                result = this.getRezervariMeseForCalendarIdsNoCommit(v).get(idCalendar);
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            finally {
                try {
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                this.pool.releaseConnection();
            }
        } else {
            Vector<Product> products = this.getServiciiHoteliereForInchidereZi();
            for (int i = 0; i < products.size(); ++i) {
                Product product = products.elementAt(i);
                RezervariMeseView rmv = new RezervariMeseView();
                rmv.setIdProduct(product.getId());
                rmv.setNrPersoane(0);
                rmv.setProduct(product.getName());
                result.add(rmv);
            }
        }
        return result;
    }

    public Map<Integer, Vector<RezervariMeseView>> getRezervariMeseForCalendarIdsNoCommit(Vector v) throws SQLException {
        return this.getDao().getRezervariMeseForCalendar(v);
    }

    public Vector<Product> getServiciiHoteliereForInchidereZi() {
        Vector<Product> products = new Vector<Product>();
        String categorii = VpConfig.getInstance().hotelCategorieMasa;
        if (Validators.correctString(categorii)) {
            Vector cats = Utils.splitString(categorii, ',');
            for (int i = 0; i < cats.size(); ++i) {
                String categorie = (String)cats.elementAt(i);
                Categorie c = NomeclaturaLogic.getInstance().getCategoryByName(categorie);
                if (c == null) continue;
                products.addAll(NomeclaturaLogic.getInstance().getProductsForCategorie(c));
            }
        }
        return products;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printListaServicii(Component parent) {
        try {
            Vector<Product> products = this.getServiciiHoteliereForInchidereZi();
            Collections.sort(products, new Comparator<Product>(){

                @Override
                public int compare(Product o1, Product o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            final Vector<Product> columns = new Vector<Product>();
            for (int i = 0; i < products.size(); ++i) {
                Product product = products.elementAt(i);
                columns.add(product);
            }
            Vector<CazariReportBean> rows = new Vector<CazariReportBean>();
            Date now = new Date();
            Date startZiHoteliera = RezervariLogic.getStartZiHoteliera(now);
            Timestamp start = new Timestamp(startZiHoteliera.getTime());
            Date endZiHoteliera = RezervariLogic.getEndZiHoteliera(now);
            Timestamp stop = new Timestamp(endZiHoteliera.getTime());
            Vector<CazariReportBean> cazariAzi = this.getDao().getCazariReport(start, stop);
            Vector<Integer> idCalendars = new Vector<Integer>();
            for (CazariReportBean bean : cazariAzi) {
                if (bean.isVirtuala()) continue;
                rows.add(bean);
                idCalendars.add(bean.getIdCalendar());
            }
            Collections.sort(rows, new Comparator<CazariReportBean>(){

                @Override
                public int compare(CazariReportBean o1, CazariReportBean o2) {
                    return o1.getCameraLong().compareToIgnoreCase(o2.getCameraLong());
                }
            });
            final Map<Integer, Vector<RezervariMeseView>> rezervariMese = this.getRezervariMeseForCalendarIdsNoCommit(idCalendars);
            final Hashtable<Integer, Integer> totaluriPerProdus = new Hashtable<Integer, Integer>();
            for (Vector<RezervariMeseView> meseViews : rezervariMese.values()) {
                for (RezervariMeseView view : meseViews) {
                    int idProduct = view.getIdProduct();
                    int nrPersoane = view.getNrPersoane();
                    if (totaluriPerProdus.get(idProduct) == null) {
                        totaluriPerProdus.put(idProduct, 0);
                    }
                    totaluriPerProdus.put(idProduct, (Integer)totaluriPerProdus.get(idProduct) + nrPersoane);
                }
            }
            ReportInterface pdfReportInterface = new ReportInterface(){

                @Override
                public int getColumnCount() {
                    return columns.size() + 1;
                }

                @Override
                public int getColumnSize(int column) {
                    switch (column) {
                        case 0: {
                            return 1;
                        }
                    }
                    return 1;
                }

                @Override
                public String getColumnName(int column) {
                    if (column == 0) {
                        return " Camera";
                    }
                    return " " + ((Product)columns.get(column - 1)).getName();
                }

                @Override
                public String getTotal(int column) {
                    switch (column) {
                        case 0: {
                            return " " + LangRoAll.total;
                        }
                    }
                    Product product = (Product)columns.get(column - 1);
                    return " " + totaluriPerProdus.get(product.getId());
                }

                @Override
                public String getReportTitle() {
                    return "Servicii hoteliere";
                }

                @Override
                public Hashtable getCriteria() {
                    Hashtable<String, String> criteria = new Hashtable<String, String>();
                    criteria.put(LangRoAll.data, Formatters.DATE_FORMAT_RO.format(new Date()));
                    return criteria;
                }

                @Override
                public boolean isLandscape() {
                    return false;
                }

                @Override
                public String getCellContent(Object row, int column) {
                    CazariReportBean lsi = (CazariReportBean)row;
                    if (lsi == null) {
                        return null;
                    }
                    switch (column) {
                        case 0: {
                            return " " + lsi.getCameraShort();
                        }
                    }
                    Product product = (Product)columns.get(column - 1);
                    Vector serviciiForCalendar = (Vector)rezervariMese.get(lsi.getIdCalendar());
                    for (RezervariMeseView meseView : serviciiForCalendar) {
                        if (product.getId() != meseView.getIdProduct()) continue;
                        return " " + meseView.getNrPersoane();
                    }
                    return RezervariLogic.SEX_NA_LABEL;
                }
            };
            Hashtable<String, String> content = PrintLogic.getInstance().printReport(parent, pdfReportInterface, null, rows);
            String foFile = content.get("pdf");
            if (foFile != null) {
                File destinationFile = new File(FileUtils.getTempDir() + File.separator + "ListaServicii_" + Formatters.DATE_FORMAT_RO.format(new Date()) + ".pdf");
                PrintUtils.printPdf(foFile, destinationFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public User getFirstReceptionistNoCommit() throws SQLException {
        Vector<User> users = UsersLogic.getInstance().getUsersInGroupNoCommit("group_receptioneri");
        User u = users.get(0);
        return u;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addProductsForZiHoteliera(JComponent panel, boolean addProductsAtInchidereZiHoteliera) {
        Date azi1200 = DateUtils.setTimeToDate(new Date(), 12, 0, 0, 0);
        Date s = DateUtils.advanceOneDay(azi1200);
        Date maine1200 = DateUtils.setTimeToDate(s, 11, 59, 59, 999);
        Date ieri1200 = DateUtils.addDaysToDate(azi1200, -1);
        try {
            Vector<CameraId> rezervariCazata = this.getDao().getCalendarByStatus(4, -1);
            Vector<CameraId> rezervariCheckout = this.getDao().getCalendarByStatus(5, -1);
            Hashtable<CameraId, CameraId> rezervariHash = new Hashtable<CameraId, CameraId>();
            for (CameraId cameraId : rezervariCazata) {
                rezervariHash.put(cameraId, cameraId);
            }
            for (CameraId cameraId : rezervariCheckout) {
                rezervariHash.put(cameraId, cameraId);
            }
            for (CameraId id : rezervariHash.values()) {
                RestLogic.getInstance().setCameraMurdareNoCommit(id.getIdTable(), true);
                if (addProductsAtInchidereZiHoteliera) {
                    this.addProductsAtInchidereZiHotelieraSimple(id);
                }
                int idCalendar = id.getIdCalendar();
                Timestamp t1 = this.getDao().getStopDateForCalendar(idCalendar);
                if (t1.getTime() - System.currentTimeMillis() >= DateUtils.dayMillis) continue;
                this.getDao().updateStatus(idCalendar, 5);
            }
            Vector<CameraId> rezervari = this.getDao().getCalendarByStatus(2, -1);
            for (int i = 0; i < rezervari.size(); ++i) {
                CameraId cameraId = rezervari.elementAt(i);
                int idCalendar = cameraId.getIdCalendar();
                Timestamp t1 = this.getDao().getStartDateForCalendar(idCalendar);
                if (t1.getTime() - System.currentTimeMillis() >= DateUtils.dayMillis) continue;
                this.getDao().updateStatus(idCalendar, 3);
            }
            this.pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (CazariLipsaException zane) {
            RezervariLogic.showCazariLipsaError(zane);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean e1 = false;
            return e1;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public static void showCazariLipsaError(CazariLipsaException ex) {
        String errorMessage = "Cazari Lipsa la camera " + ex.getCamera() + ":" + "<ol>";
        Vector<String> zileLipsa = ex.getZileLipsa();
        for (String zi : zileLipsa) {
            errorMessage = errorMessage + "<li>" + zi + "</li>";
        }
        errorMessage = errorMessage + "</ol>";
        DialogUtils.htmlOKDialog(GuiUtils.currentFrame, errorMessage, "Corectati cazarile lipsa intai!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inchidereTuraHoteliera(User receptioner, boolean close, Component parent) {
        try {
            Timestamp lastOpenDate = EventsLogic.getInstance().getLastOpenDateNoCommit(2);
            if (lastOpenDate == null) {
                lastOpenDate = DateUtils.getStartOfDays();
            }
            this.printInchidereTuraHoteliera(lastOpenDate, DateUtils.getCurrentTimestamp(), receptioner, parent);
            if (close) {
                EventsLogic.getInstance().closeDayNoCommit(2);
                EventsLogic.getInstance().openDayNoCommit(2);
            }
            this.pool.commit();
            if (close) {
                RestLogic.getInstance().notifyListeners(6);
            }
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private List getRealizariLine(RaportPeCategoriiSiCoteTva bean) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(bean.getCategorie());
        double cotaTva1 = bean.getCotaTva();
        if (cotaTva1 > 0.0) {
            result.add(Utils.getString2Decimals(cotaTva1));
        } else {
            result.add("-");
        }
        result.add(Utils.getString2Decimals(bean.getTotalBrut()));
        result.add(Utils.getString2Decimals(bean.getTotalNet()));
        result.add(Utils.getString2Decimals(bean.getTotalTva()));
        return result;
    }

    private List getRealizariLunaInCurs(List<Timestamp> dates) {
        Vector<Integer> categoriiIds = new Vector<Integer>();
        String catTarifeS = VpConfig.getInstance().hotelCategorieTarife;
        Categorie catTarife = NomeclaturaLogic.getInstance().getCategoryByName(catTarifeS);
        Sectie s = NomeclaturaLogic.getInstance().getSectieByCategoryId(catTarife.getId());
        Vector categoriiNaturalOrder = NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(s.getId());
        for (Categorie categorie1 : categoriiNaturalOrder) {
            categoriiIds.add(categorie1.getId());
        }
        ArrayList<List> result = new ArrayList<List>();
        Map<Double, RaportPeCategoriiSiCoteTva> sumeperTva = Collections.synchronizedMap(new LinkedHashMap());
        RaportPeCategoriiSiCoteTva totalGen = new RaportPeCategoriiSiCoteTva();
        totalGen.setCategorie("TOTAL GENERAL");
        totalGen.setCotaTva(-1.0);
        Date inceputLuna = DateUtils.getFirstDayOfCurrentMonth();
        Timestamp endZiHotelieraAnterioara = EventsLogic.getInstance().getStopForDay(new Timestamp(inceputLuna.getTime()), 2);
        dates.add(endZiHotelieraAnterioara);
        if (endZiHotelieraAnterioara != null) {
            Timestamp now = DateUtils.getCurrentTimestamp();
            dates.add(now);
            Vector<RaportPeCategoriiSiCoteTva> raportPeCategoriiSiCoteTva = RestLogic.getInstance().getRaportPeCategoriiSiCoteTva(categoriiIds, endZiHotelieraAnterioara, now);
            for (RaportPeCategoriiSiCoteTva bean : raportPeCategoriiSiCoteTva) {
                totalGen.setTotalBrut(totalGen.getTotalBrut() + bean.getTotalBrut());
                totalGen.setTotalNet(totalGen.getTotalNet() + bean.getTotalNet());
                totalGen.setTotalTva(totalGen.getTotalTva() + bean.getTotalTva());
                double tva = bean.getCotaTva();
                RaportPeCategoriiSiCoteTva perTva = (RaportPeCategoriiSiCoteTva)sumeperTva.get(tva);
                if (perTva == null) {
                    perTva = new RaportPeCategoriiSiCoteTva();
                    perTva.setCategorie("Total per TVA");
                    perTva.setCotaTva(tva);
                    sumeperTva.put(tva, perTva);
                }
                perTva.setTotalBrut(perTva.getTotalBrut() + bean.getTotalBrut());
                perTva.setTotalNet(perTva.getTotalNet() + bean.getTotalNet());
                perTva.setTotalTva(perTva.getTotalTva() + bean.getTotalTva());
                List line = this.getRealizariLine(bean);
                result.add(line);
            }
            for (RaportPeCategoriiSiCoteTva perTva : sumeperTva.values()) {
                List line = this.getRealizariLine(perTva);
                result.add(line);
            }
            List line = this.getRealizariLine(totalGen);
            result.add(line);
        }
        return result;
    }

    private boolean printInchidereTuraHoteliera(Timestamp startTura, Timestamp endTura, User receptioner, Component parent) throws DocumentTemplateException, IOException, SQLException {
        Hashtable<String, Object> mapping = new Hashtable<String, Object>();
        mapping.put("tura_start", Formatters.currentDateAndTimeForFileSystem.format(startTura));
        mapping.put("tura_stop", Formatters.currentDateAndTimeForFileSystem.format(endTura));
        String shortFilename = "inchidere_tura_hoteliera.odt";
        String templateFile = FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + shortFilename;
        String outputFile = FileUtils.getTempDir() + File.separator + "inchidere_tura_hoteliera_" + Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(endTura) + ".odt";
        Hashtable<String, Double> totalPeTipServiciu = new Hashtable<String, Double>();
        Hashtable<String, Double> totalPeTipDePlata = new Hashtable<String, Double>();
        Hashtable<String, Double> totalPeTipTVA = new Hashtable<String, Double>();
        Hashtable<Categorie, Double> totalPeCategorii = new Hashtable<Categorie, Double>();
        Vector<RaportDetaliatBean> servicii = new Vector<RaportDetaliatBean>();
        AtrFloat totalServicii = new AtrFloat();
        ArrayList raportTuraDetaliat = this.getRaportTuraDetaliat(startTura, endTura, totalPeTipServiciu, totalPeTipDePlata, servicii, true, totalServicii, totalPeTipTVA);
        mapping.put("rows_detaliat", raportTuraDetaliat);
        ArrayList structuraCazare = this.getStructuraPret(startTura, endTura, parent);
        mapping.put("rows_structuracazare", structuraCazare);
        ArrayList raportServicii = this.getRaportServicii(totalPeTipServiciu);
        mapping.put("rows_servicii", raportServicii);
        ArrayList raportPlati = this.getRaportMonetar(totalPeTipDePlata);
        mapping.put("rows_plati", raportPlati);
        ArrayList raportTVA = this.getRaportMonetar(totalPeTipTVA);
        mapping.put("rows_tva", raportTVA);
        ArrayList raportFacturi = this.getRaportFacturi(startTura, endTura);
        mapping.put("rows_facturi", raportFacturi);
        mapping.put("grad_ocupare", this.getGradOcupare(startTura, endTura));
        mapping.put("tiparit_de", receptioner.getName());
        ArrayList raportPrestatii = this.getPrestatii(startTura, endTura, totalPeCategorii, true);
        mapping.put("rows_prestatii", raportPrestatii);
        ArrayList<Timestamp> monthStartStop = new ArrayList<Timestamp>();
        List realizariLunare = this.getRealizariLunaInCurs(monthStartStop);
        mapping.put("rows_realizarilunare", realizariLunare);
        Timestamp startMonth = (Timestamp)monthStartStop.get(0);
        if (startMonth != null) {
            Timestamp endMonth = (Timestamp)monthStartStop.get(1);
            mapping.put("luna_start", Formatters.DATE_AND_TIME_FORMAT.format(startMonth));
            mapping.put("luna_stop", Formatters.DATE_AND_TIME_FORMAT.format(endMonth));
        } else {
            mapping.put("luna_start", "DATE INSUFICIENTE");
            mapping.put("luna_stop", SEX_NA_LABEL);
        }
        ArrayList raportOcupare = this.getOcupare(startTura, endTura);
        mapping.put("rows_ocupare", raportOcupare);
        ArrayList raportPersoane = this.getPersoane(startTura, endTura);
        mapping.put("rows_persoane", raportPersoane);
        Hashtable<String, Double> totalPeTipServiciuSold = new Hashtable<String, Double>();
        Hashtable<String, Double> totalPeTipDePlataSold = new Hashtable<String, Double>();
        Vector<RaportDetaliatBean> serviciiSold = new Vector<RaportDetaliatBean>();
        AtrFloat totalSoldPeCamere = new AtrFloat();
        ArrayList raportSoldDetaliat = this.getRaportTuraDetaliat(startTura, endTura, totalPeTipServiciuSold, totalPeTipDePlataSold, serviciiSold, false, totalSoldPeCamere, totalPeTipTVA);
        mapping.put("rows_sold", raportSoldDetaliat);
        ArrayList raportGestiune = this.getRaportGestiune(totalPeTipDePlata, totalPeCategorii);
        mapping.put("rows_rapgestiune", raportGestiune);
        String path = this.generateOdtDocumentNoTry(templateFile, mapping, outputFile);
        Logger.logDebug(this, "am generat documentul odt");
        boolean ok = PrintLogic.getInstance().printFacturaOpenOffice(path, "printer_items_facturi");
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getPrestatiiForCategorie(Timestamp startTura, Timestamp endTura, Sectie sectie, AtrFloat total, Hashtable<Categorie, Double> totalPeCategorii) {
        ArrayList result = new ArrayList();
        Hashtable<String, Object> criteria = new Hashtable<String, Object>();
        criteria.put(Constants.START_KEY, startTura);
        criteria.put(Constants.STOP_KEY, endTura);
        criteria.put("category", sectie);
        criteria.put("tip_produs_key", "All");
        criteria.put("StatusNota", 3);
        try {
            Vector<SalesEntry> salesEntries = RestLogic.getInstance().getSalesReportNoCommit(criteria, 2);
            for (SalesEntry entry : salesEntries) {
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(entry.getCategory());
                row.add(entry.getSubcategory());
                row.add(entry.getProduct());
                row.add(entry.getPrice());
                row.add(entry.getQuantity());
                row.add(entry.getTotalValue());
                total.setValue(total.getValue() + entry.getTotalValue());
                Product product = NomeclaturaLogic.getInstance().getProductByIdNoCommit(entry.getIdProduct());
                int idCat = product.getIdCategorie();
                Categorie categorie = NomeclaturaLogic.getInstance().getCategoryByIdNoCommit(idCat);
                Double totalCategorie = totalPeCategorii.get(categorie);
                if (totalCategorie == null) {
                    totalCategorie = 0.0;
                }
                totalCategorie = totalCategorie + entry.getTotalValue();
                totalPeCategorii.put(categorie, totalCategorie);
                result.add(row);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getStructuraPret(Timestamp startTura, Timestamp endTura, Component parent) {
        Hashtable<String, Object> criteria = new Hashtable<String, Object>();
        criteria.put(Constants.START_KEY, startTura);
        criteria.put(Constants.STOP_KEY, endTura);
        Vector<CazariBean> step1CazariBean = RezervariLogic.getInstance().getListaCazariRezervari(criteria, parent);
        Vector<Integer> idOrders = new Vector<Integer>();
        Vector<Integer> step4IdCalendars = new Vector<Integer>();
        Vector<CazariBean> step2CazariBean = new Vector<CazariBean>();
        for (CazariBean cazariBean : step1CazariBean) {
            switch (cazariBean.getStatus()) {
                case 4: 
                case 5: {
                    step2CazariBean.add(cazariBean);
                    idOrders.add(cazariBean.getIdOrder());
                    step4IdCalendars.add(cazariBean.getIdCalendar());
                }
            }
        }
        Product productCazare = NomeclaturaLogic.getInstance().getProductByCod(VpConfig.getInstance().hotelCodProdusCazare);
        Hashtable<Integer, Vector<SalesEntry>> step3Sales = new Hashtable<Integer, Vector<SalesEntry>>();
        Map<Object, Object> step4MeseViews = new Hashtable();
        ArrayList result = new ArrayList();
        String catTarifeS = VpConfig.getInstance().hotelCategorieTarife;
        Categorie catTarife = NomeclaturaLogic.getInstance().getCategoryByName(catTarifeS);
        if (catTarife != null) {
            Sectie sectieCazare = NomeclaturaLogic.getInstance().getSectieById(catTarife.getSectie());
            criteria = new Hashtable();
            criteria.put(Constants.START_KEY, startTura);
            criteria.put(Constants.STOP_KEY, endTura);
            criteria.put("category", sectieCazare);
            criteria.put("tip_produs_key", "All");
            criteria.put("StatusNota", 3);
            criteria.put(Constants.GRUPARE_KEY, "Dupa comanda");
            AtrFloat total = new AtrFloat();
            try {
                Vector<SalesEntry> salesEntries = RestLogic.getInstance().getSalesReportNoGroupNoCommit(criteria, 2);
                for (SalesEntry entry : salesEntries) {
                    Product product = NomeclaturaLogic.getInstance().getProductByIdNoCommit(entry.getIdProduct());
                    if (RezervariLogic.isProdusCazare(productCazare, product.getIdCategorie())) {
                        String idOrderS = entry.getDataOra();
                        Integer idOrder = Integer.parseInt(idOrderS);
                        Vector<SalesEntry> salesForOrder = (Vector<SalesEntry>)step3Sales.get(idOrder);
                        if (salesForOrder == null) {
                            salesForOrder = new Vector<SalesEntry>();
                            step3Sales.put(idOrder, salesForOrder);
                        }
                        salesForOrder.add(entry);
                        continue;
                    }
                    System.out.println("N-ar trb sa ajungem aici : " + product);
                }
                step4MeseViews = this.getRezervariMeseForCalendarIdsNoCommit(step4IdCalendars);
                Hashtable<PriceQuantityBean, PriceQuantityBean> valueForSales = new Hashtable<PriceQuantityBean, PriceQuantityBean>();
                Hashtable<PriceQuantityBean, PriceQuantityBean> valueForServicii = new Hashtable<PriceQuantityBean, PriceQuantityBean>();
                int i = 1;
                for (CazariBean cazariBean : step2CazariBean) {
                    Vector meseViews;
                    if (cazariBean.getCamera().startsWith("0303")) {
                        System.out.println("0303");
                    }
                    ArrayList<String> line = new ArrayList<String>();
                    line.add(SEX_NA_LABEL + i);
                    line.add(cazariBean.getCamera());
                    Client turist = cazariBean.getTurist();
                    Client societate = cazariBean.getSocietate();
                    String nume = turist.toString();
                    if (societate != null) {
                        nume = nume + " / " + societate;
                    }
                    line.add(nume);
                    int nrPersoane = cazariBean.getNrPersoane();
                    String structuraPretSiAdaos = "Tarif=" + Utils.getString2Decimals(cazariBean.getTarifValoare()) + ",Pers=" + nrPersoane;
                    double valoareAdaosCazareCurenta = 0.0;
                    int nrSalesProdusPrincipal = 0;
                    Vector sales = (Vector)step3Sales.get(cazariBean.getIdOrder());
                    if (sales != null && sales.size() > 0) {
                        for (SalesEntry sale : sales) {
                            Product product = NomeclaturaLogic.getInstance().getProductByIdNoCommit(sale.getIdProduct());
                            String currentSaleText = ",\"" + product.getName() + "\":";
                            double price = sale.getPrice();
                            currentSaleText = currentSaleText + " " + Utils.getString2Decimals(price);
                            double quantity = FloatUtils.roundDouble(sale.getQuantity(), 2);
                            currentSaleText = currentSaleText + "*" + Utils.getString2Decimals(quantity) + "zile";
                            nrSalesProdusPrincipal = (int)((double)nrSalesProdusPrincipal + quantity);
                            double val2 = quantity * price;
                            currentSaleText = currentSaleText + "=" + Utils.getString2Decimals(val2);
                            valoareAdaosCazareCurenta += val2;
                            PriceQuantityBean toAdd = new PriceQuantityBean(sale.getProduct(), price, quantity);
                            PriceQuantityBean existing = (PriceQuantityBean)valueForSales.get(toAdd);
                            if (existing != null) {
                                existing.setQty(existing.getQty() + toAdd.getQty());
                            } else {
                                valueForSales.put(toAdd, toAdd);
                            }
                            structuraPretSiAdaos = structuraPretSiAdaos + currentSaleText;
                        }
                    }
                    if ((meseViews = (Vector)step4MeseViews.get(cazariBean.getIdCalendar())) != null) {
                        structuraPretSiAdaos = structuraPretSiAdaos + " -MASA (";
                        for (RezervariMeseView view : meseViews) {
                            int viewNrPersoane = view.getNrPersoane();
                            if (viewNrPersoane <= 0) continue;
                            String currentMeseLine = SEX_NA_LABEL;
                            Product product = NomeclaturaLogic.getInstance().getProductByIdNoCommit(view.getIdProduct());
                            currentMeseLine = currentMeseLine + "\"" + product.getName() + "\":";
                            double price = RestLogic.getInstance().getPriceForProductNoCommit(view.getIdProduct());
                            currentMeseLine = currentMeseLine + " " + Utils.getString2Decimals(price);
                            int nrPersMeseView = viewNrPersoane * nrSalesProdusPrincipal;
                            currentMeseLine = currentMeseLine + "*" + nrSalesProdusPrincipal + " zile * " + viewNrPersoane + " pers";
                            double val2 = (double)(-nrPersMeseView) * price;
                            currentMeseLine = currentMeseLine + "=" + Utils.getString2Decimals(val2);
                            valoareAdaosCazareCurenta += val2;
                            PriceQuantityBean toAdd = new PriceQuantityBean(product.getName(), price, nrPersMeseView);
                            PriceQuantityBean existing = (PriceQuantityBean)valueForServicii.get(toAdd);
                            if (existing != null) {
                                existing.setQty(existing.getQty() + toAdd.getQty());
                            } else {
                                valueForServicii.put(toAdd, toAdd);
                            }
                            structuraPretSiAdaos = structuraPretSiAdaos + currentMeseLine;
                        }
                        structuraPretSiAdaos = structuraPretSiAdaos + ")";
                    }
                    structuraPretSiAdaos = structuraPretSiAdaos + " ->ADAOS CAZARE=" + Utils.getString2Decimals(valoareAdaosCazareCurenta);
                    line.add(structuraPretSiAdaos);
                    result.add(line);
                    ++i;
                }
                double totalAdaos = 0.0;
                double totalCazare = 0.0;
                double totalServiciu = 0.0;
                ArrayList<String> spacer = new ArrayList<String>();
                spacer.add(SEX_NA_LABEL + i++);
                spacer.add(SEX_NA_LABEL);
                spacer.add("TOTAL PER TIP CAZARE");
                spacer.add(SEX_NA_LABEL);
                result.add(spacer);
                Vector sortedSales = new Vector(valueForSales.values());
                Collections.sort(sortedSales);
                for (PriceQuantityBean bean : sortedSales) {
                    ArrayList<String> totalCamera = new ArrayList<String>();
                    totalCamera.add(SEX_NA_LABEL);
                    totalCamera.add(SEX_NA_LABEL);
                    totalCamera.add(SEX_NA_LABEL);
                    String currentLine = SEX_NA_LABEL;
                    currentLine = currentLine + bean.getNumeProdus();
                    double price = bean.getPrice();
                    currentLine = currentLine + " " + Utils.getString2Decimals(price);
                    double qty = bean.getQty();
                    currentLine = currentLine + "*" + Utils.getString2Decimals(qty) + " zile";
                    double value = price * qty;
                    currentLine = currentLine + "=" + Utils.getString2Decimals(value);
                    totalCamera.add(currentLine);
                    result.add(totalCamera);
                    totalAdaos += value;
                    totalCazare += value;
                }
                spacer = new ArrayList();
                spacer.add(SEX_NA_LABEL + i++);
                spacer.add(SEX_NA_LABEL);
                spacer.add("TOTAL PER TIP SERVICIU");
                spacer.add(SEX_NA_LABEL);
                result.add(spacer);
                Vector sortedServicii = new Vector(valueForServicii.values());
                Collections.sort(sortedServicii);
                for (PriceQuantityBean bean : sortedServicii) {
                    ArrayList<String> totalCamera = new ArrayList<String>();
                    totalCamera.add(SEX_NA_LABEL);
                    totalCamera.add(SEX_NA_LABEL);
                    totalCamera.add(SEX_NA_LABEL);
                    String currentLine = "\"" + bean.getNumeProdus() + "\":";
                    double price = bean.getPrice();
                    currentLine = currentLine + " " + Utils.getString2Decimals(price);
                    double qty = bean.getQty();
                    currentLine = currentLine + "*" + Utils.getString2Decimals(qty) + " (zile-persoane) ";
                    double value = price * qty;
                    currentLine = currentLine + "= -" + Utils.getString2Decimals(value);
                    totalCamera.add(currentLine);
                    result.add(totalCamera);
                    totalAdaos -= value;
                    totalServiciu -= value;
                }
                spacer = new ArrayList();
                spacer.add(SEX_NA_LABEL + i++);
                spacer.add("TOTAL GENERAL");
                spacer.add(SEX_NA_LABEL);
                spacer.add(SEX_NA_LABEL);
                result.add(spacer);
                ArrayList<String> totalCazareLine = new ArrayList<String>();
                totalCazareLine.add(SEX_NA_LABEL);
                totalCazareLine.add(SEX_NA_LABEL);
                totalCazareLine.add("TOTAL CAZARE");
                totalCazareLine.add(Utils.getString2Decimals(totalCazare));
                result.add(totalCazareLine);
                ArrayList<String> totalServiciiLine = new ArrayList<String>();
                totalServiciiLine.add(SEX_NA_LABEL);
                totalServiciiLine.add(SEX_NA_LABEL);
                totalServiciiLine.add("TOTAL SERVICII");
                totalServiciiLine.add(Utils.getString2Decimals(totalServiciu));
                result.add(totalServiciiLine);
                ArrayList<String> totalAdaosLine = new ArrayList<String>();
                totalAdaosLine.add(SEX_NA_LABEL);
                totalAdaosLine.add(SEX_NA_LABEL);
                totalAdaosLine.add("TOTAL ADAOS");
                totalAdaosLine.add(Utils.getString2Decimals(totalAdaos));
                result.add(totalAdaosLine);
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            finally {
                try {
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                this.pool.releaseConnection();
            }
            return result;
        }
        return result;
    }

    private ArrayList getPrestatii(Timestamp startTura, Timestamp endTura, Hashtable<Categorie, Double> totalPeCategorii, boolean includeMasa) {
        ArrayList result = new ArrayList();
        AtrFloat total = new AtrFloat();
        String catTarifeS = VpConfig.getInstance().hotelCategorieTarife;
        Categorie catTarife = NomeclaturaLogic.getInstance().getCategoryByName(catTarifeS);
        if (catTarife != null) {
            Sectie sectieCazare = NomeclaturaLogic.getInstance().getSectieById(catTarife.getSectie());
            ArrayList prestatiiCazare = this.getPrestatiiForCategorie(startTura, endTura, sectieCazare, total, totalPeCategorii);
            result.addAll(prestatiiCazare);
            if (includeMasa) {
                String catMasaS = VpConfig.getInstance().hotelCategorieMasa;
                Categorie catMasa = NomeclaturaLogic.getInstance().getCategoryByName(catMasaS);
                if (catMasa != null && catMasa.getSectie() != catTarife.getSectie()) {
                    Sectie sectieMasa = NomeclaturaLogic.getInstance().getSectieById(catMasa.getSectie());
                    ArrayList prestatiiMasa = this.getPrestatiiForCategorie(startTura, endTura, sectieMasa, total, totalPeCategorii);
                    result.addAll(prestatiiMasa);
                }
            }
        }
        ArrayList<String> row = new ArrayList<String>();
        row.add("-");
        row.add("-");
        row.add("TOTAL");
        row.add("-");
        row.add("-");
        row.add(Utils.getString2Decimals(total.getValue()));
        result.add(row);
        return result;
    }

    private ArrayList getOcupare(Timestamp startTura, Timestamp endTura) {
        ArrayList result = new ArrayList();
        ArrayList<String> row1 = new ArrayList<String>();
        row1.add("Capacitate inventar");
        row1.add(SEX_NA_LABEL);
        row1.add(SEX_NA_LABEL);
        result.add(row1);
        ArrayList<String> row3 = new ArrayList<String>();
        row3.add("Inchirieri pat suplimentar");
        row3.add(SEX_NA_LABEL);
        row3.add(SEX_NA_LABEL);
        result.add(row3);
        ArrayList<String> row4 = new ArrayList<String>();
        row4.add("Capacitate efectiv utilizata");
        row4.add(SEX_NA_LABEL);
        row4.add(SEX_NA_LABEL);
        result.add(row4);
        ArrayList<String> row5 = new ArrayList<String>();
        row5.add("Grad ocupare");
        row5.add(SEX_NA_LABEL);
        row5.add(SEX_NA_LABEL);
        result.add(row5);
        return result;
    }

    private ArrayList getPersoane(Timestamp startTura, Timestamp endTura) {
        ArrayList result = new ArrayList();
        ArrayList<String> row1 = new ArrayList<String>();
        row1.add("Existente");
        row1.add(SEX_NA_LABEL);
        row1.add(SEX_NA_LABEL);
        row1.add(SEX_NA_LABEL);
        result.add(row1);
        ArrayList<String> row2 = new ArrayList<String>();
        row2.add("Intrate");
        row2.add(SEX_NA_LABEL);
        row2.add(SEX_NA_LABEL);
        row2.add(SEX_NA_LABEL);
        result.add(row2);
        return result;
    }

    private double getSoldInitial() {
        String soldInitial = Config.getInstance().getString(SOLD_INITIAL_KEY);
        if (!Validators.correctDouble(soldInitial)) {
            Config.getInstance().addConfigCommit(SOLD_INITIAL_KEY, "0", false);
            soldInitial = "0";
        }
        return Utils.parseDouble(soldInitial);
    }

    private ArrayList getRaportGestiune(Hashtable<String, Double> totalPeTipDePlata, Hashtable<Categorie, Double> totalPeCategorii) {
        ArrayList result = new ArrayList();
        double soldInitial = this.getSoldInitial();
        ArrayList<String> soldInitialRow = new ArrayList<String>();
        soldInitialRow.add("Sold Initial");
        soldInitialRow.add(SEX_NA_LABEL);
        soldInitialRow.add(SEX_NA_LABEL);
        soldInitialRow.add(Utils.getString2Decimals(soldInitial));
        soldInitialRow.add(SEX_NA_LABEL);
        result.add(soldInitialRow);
        Vector<Categorie> categoriesSorted = new Vector<Categorie>(totalPeCategorii.keySet());
        Collections.sort(categoriesSorted, new Comparator(){

            public int compare(Object o1, Object o2) {
                String c1 = ((Categorie)o1).getName();
                String c2 = ((Categorie)o2).getName();
                return c1.compareTo(c2);
            }
        });
        double totalRealizari = 0.0;
        for (Categorie categorie : categoriesSorted) {
            double suma = totalPeCategorii.get(categorie);
            ArrayList<String> row = new ArrayList<String>();
            row.add(categorie.getName());
            row.add(SEX_NA_LABEL);
            row.add(SEX_NA_LABEL);
            row.add(SEX_NA_LABEL);
            row.add(Utils.getString2Decimals(suma));
            result.add(row);
            totalRealizari += suma;
        }
        ArrayList<String> totalHotelRow = new ArrayList<String>();
        totalHotelRow.add("Total realizari hotel");
        totalHotelRow.add(SEX_NA_LABEL);
        totalHotelRow.add(SEX_NA_LABEL);
        totalHotelRow.add(Utils.getString2Decimals(totalRealizari));
        totalHotelRow.add(SEX_NA_LABEL);
        result.add(totalHotelRow);
        double totalDeIncasat = soldInitial + totalRealizari;
        ArrayList<String> totalDeIncasatRow = new ArrayList<String>();
        totalDeIncasatRow.add("Total de incasat");
        totalDeIncasatRow.add(SEX_NA_LABEL);
        totalDeIncasatRow.add(SEX_NA_LABEL);
        totalDeIncasatRow.add(Utils.getString2Decimals(totalDeIncasat));
        totalDeIncasatRow.add(SEX_NA_LABEL);
        result.add(totalDeIncasatRow);
        double totalIncasat = 0.0;
        for (String tipPlata2 : totalPeTipDePlata.keySet()) {
            double suma = totalPeTipDePlata.get(tipPlata2);
            ArrayList<String> tipPlataRow = new ArrayList<String>();
            tipPlataRow.add(tipPlata2);
            tipPlataRow.add(SEX_NA_LABEL);
            tipPlataRow.add(Utils.getString2Decimals(suma));
            tipPlataRow.add(SEX_NA_LABEL);
            tipPlataRow.add(SEX_NA_LABEL);
            result.add(tipPlataRow);
            totalIncasat += suma;
        }
        ArrayList<String> totalPlatiRow = new ArrayList<String>();
        totalPlatiRow.add("Total incasari");
        totalPlatiRow.add(Utils.getString2Decimals(totalIncasat));
        totalPlatiRow.add(SEX_NA_LABEL);
        totalPlatiRow.add(SEX_NA_LABEL);
        totalPlatiRow.add(SEX_NA_LABEL);
        result.add(totalPlatiRow);
        double soldFinal = totalDeIncasat - totalIncasat;
        ArrayList<String> row1 = new ArrayList<String>();
        row1.add("Sold final");
        row1.add(SEX_NA_LABEL);
        row1.add(SEX_NA_LABEL);
        row1.add(Utils.getString2Decimals(soldFinal));
        row1.add(SEX_NA_LABEL);
        result.add(row1);
        Config.getInstance().updateValueAndCommit(SOLD_INITIAL_KEY, Utils.getString2Decimals(soldFinal));
        return result;
    }

    private String getGradOcupare(Timestamp startTura, Timestamp endTura) throws SQLException {
        int totalLocuri = 0;
        int totalCamere = 0;
        Vector hotelLocations = RestLogic.getInstance().getLocationsNoCommit(2);
        for (Location location : hotelLocations) {
            Vector<Table> tables = RestLogic.getInstance().getTablesByLocationNoCommit(location.getId());
            for (Table camera : tables) {
                if (camera.isVirtuala()) continue;
                totalLocuri += camera.getLocuri();
                ++totalCamere;
            }
        }
        Vector<ZiHotelieraBean> zileHoteliere = new Vector<ZiHotelieraBean>();
        Date d1 = startTura;
        Date d2 = RezervariLogic.getEndZiHoteliera(endTura);
        if (d2.after(endTura)) {
            d2 = DateUtils.addDaysToDate(d2, -1);
            d2 = RezervariLogic.getEndZiHoteliera(d2);
        }
        while (d1.before(d2)) {
            Date startZi = RezervariLogic.getStartZiHoteliera(d1);
            Date stopZi = RezervariLogic.getEndZiHoteliera(d1);
            ZiHotelieraBean bean = new ZiHotelieraBean();
            bean.setStart(startZi);
            bean.setStop(stopZi);
            zileHoteliere.add(bean);
            d1 = DateUtils.advanceOneDay(d1);
        }
        double totalCamereGO = totalCamere * zileHoteliere.size();
        double totalLocuriGO = totalLocuri * zileHoteliere.size();
        int locuriOcupate = 0;
        int camereOcupate = 0;
        for (ZiHotelieraBean bean : zileHoteliere) {
            Date startZiHoteliera = bean.getStart();
            Timestamp start = new Timestamp(startZiHoteliera.getTime());
            Date endZiHoteliera = bean.getStop();
            Timestamp stop = new Timestamp(endZiHoteliera.getTime());
            Vector<CazariReportBean> cazariAzi = this.getDao().getCazariReport(start, stop);
            for (CazariReportBean reportBean : cazariAzi) {
                RezervareBean currentRezervareBean = RezervariLogic.getInstance().getCurrentRezervareBeanNoCommit(reportBean.getIdOrder(), reportBean.getIdTable());
                ++camereOcupate;
                locuriOcupate += currentRezervareBean.getNumarPersoane();
            }
        }
        double ocupareCamere = (double)camereOcupate / totalCamereGO * 100.0;
        double ocupareLocuri = (double)locuriOcupate / totalLocuriGO * 100.0;
        String result = "Total Camere = " + totalCamere + " , GRAD OCUPARE = " + Utils.getString2Decimals(ocupareCamere) + " % , camere ocupate = " + Utils.getString2Decimals(camereOcupate);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getRaportTuraDetaliat(Timestamp startDate, Timestamp stopDate, Hashtable<String, Double> totalPeTipServiciu, Hashtable<String, Double> totalPeTipDePlata, Vector<RaportDetaliatBean> servicii, boolean incasate, AtrFloat totalGeneral, Hashtable<String, Double> totalPeTipTva) {
        ArrayList result = new ArrayList();
        try {
            Vector<RaportDetaliatBean> items = this.getDao().getRaportDetaliat(startDate, stopDate, this.pool.requestConnection().getConnection(), incasate);
            servicii.addAll(items);
            for (RaportDetaliatBean item : items) {
                int idCazat = item.getIdCazat();
                Client cazat = ClientLogic.getInstance().getClientFromHash(idCazat);
                if (cazat == null) {
                    cazat = ClientLogic.getInstance().getClientByIdNoCommit(idCazat);
                }
                String nume = cazat.toString();
                int idFirma = item.getIdFirma();
                Client firma = null;
                if (idFirma > 0 && (firma = ClientLogic.getInstance().getClientFromHash(idFirma)) == null) {
                    firma = ClientLogic.getInstance().getClientByIdNoCommit(idFirma);
                }
                if (firma != null) {
                    nume = nume + " / " + firma.toString();
                }
                item.setNume(nume);
            }
            double total = 0.0;
            int i = 1;
            for (RaportDetaliatBean item : items) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(SEX_NA_LABEL + i);
                if (item.getData() != null) {
                    row.add(Formatters.DATE_FORMAT_RO.format(item.getData()));
                } else {
                    row.add("-");
                }
                row.add(item.getCamera());
                row.add(item.getNume());
                row.add(item.getServiciu());
                row.add(Utils.getString2Decimals(item.getSuma()));
                row.add(item.getTipPlata());
                result.add(row);
                ++i;
                total += item.getSuma();
                Double existing = totalPeTipServiciu.get(item.getServiciu());
                if (existing == null) {
                    existing = 0.0;
                }
                existing = existing + item.getSuma();
                totalPeTipServiciu.put(item.getServiciu(), existing);
                Double existingP = totalPeTipDePlata.get(item.getTipPlata());
                if (existingP == null) {
                    existingP = 0.0;
                }
                existingP = existingP + item.getSuma();
                totalPeTipDePlata.put(item.getTipPlata(), existingP);
                String cotaTvaS = Utils.getString2Decimals(item.getCotaTva());
                Double existingT = totalPeTipTva.get(cotaTvaS);
                if (existingT == null) {
                    existingT = 0.0;
                }
                existingT = existingT + item.getSuma();
                totalPeTipTva.put(cotaTvaS, existingT);
            }
            ArrayList<String> row = new ArrayList<String>();
            row.add("-");
            row.add("-");
            row.add("-");
            row.add("TOTAL");
            row.add("-");
            row.add(Utils.getString2Decimals(total));
            row.add("-");
            result.add(row);
            totalGeneral.setValue(total);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    private ArrayList getRaportServicii(Hashtable<String, Double> totalPeTipServiciu) throws SQLException {
        ArrayList result = new ArrayList();
        double total = 0.0;
        int i = 1;
        for (String product : totalPeTipServiciu.keySet()) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(SEX_NA_LABEL + i);
            row.add(product);
            double suma = totalPeTipServiciu.get(product);
            row.add(Utils.getString2Decimals(suma));
            result.add(row);
            ++i;
            total += suma;
        }
        ArrayList<String> row = new ArrayList<String>();
        row.add("-");
        row.add("TOTAL");
        row.add(Utils.getString2Decimals(total));
        result.add(row);
        return result;
    }

    private ArrayList getRaportMonetar(Hashtable<String, Double> totalPeTipDePlata) throws SQLException {
        ArrayList result = new ArrayList();
        double total = 0.0;
        int i = 1;
        for (String tipPlata2 : totalPeTipDePlata.keySet()) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(SEX_NA_LABEL + i);
            row.add(tipPlata2);
            double suma = totalPeTipDePlata.get(tipPlata2);
            row.add(Utils.getString2Decimals(suma));
            result.add(row);
            ++i;
            total += suma;
        }
        ArrayList<String> row = new ArrayList<String>();
        row.add("-");
        row.add("TOTAL");
        row.add(Utils.getString2Decimals(total));
        result.add(row);
        return result;
    }

    private ArrayList getRaportFacturi(Timestamp startDate, Timestamp stopDate) {
        Hashtable<String, Comparable<Date>> criteria = new Hashtable<String, Comparable<Date>>();
        criteria.put(Constants.START_KEY, startDate);
        criteria.put(Constants.STOP_KEY, stopDate);
        criteria.put(Constants.CLIENT_KEY, Integer.valueOf(-1));
        criteria.put("Agent", Integer.valueOf(-1));
        criteria.put(Constants.STATUS_FACTURA_KEY, Integer.valueOf(-1));
        Vector<FacturiEmiseView> fev = FacturiLogic.getInstance().getFacturiEmise(criteria, 1);
        ArrayList result = new ArrayList();
        int i = 1;
        for (FacturiEmiseView view : fev) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(SEX_NA_LABEL + i);
            row.add(Formatters.DATE_FORMAT_RO.format(view.getData()));
            row.add(view.getSerieNumar());
            row.add(view.getClient());
            row.add(Utils.getString2Decimals(view.getTotal()));
            row.add(Utils.getString2Decimals(view.getTva()));
            row.add(Utils.getString2Decimals(view.getTotalGeneral()));
            row.add(FacturiLogic.getInstance().getStringForStatus(view.getStatusFactura()));
            result.add(row);
            ++i;
        }
        return result;
    }

    private String generateOdtDocumentNoTry(String templateFile, Hashtable mapping, String outputFile) throws DocumentTemplateException, IOException {
        DocumentTemplateFactory documentTemplateFactory = new DocumentTemplateFactory();
        DocumentTemplate template = documentTemplateFactory.getTemplate(new File(templateFile));
        template.createDocument((Object)mapping, (OutputStream)new FileOutputStream(outputFile));
        return outputFile;
    }

    private int getNextFreeSlot(Sale[] dates) {
        for (int i = 0; i < dates.length; ++i) {
            if (dates[i] != null) continue;
            return i;
        }
        return -1;
    }

    public long getDate(int days, Date cazareStart) {
        cazareStart = DateUtils.setTimeToDate(cazareStart, 12, 0, 0, 0);
        cazareStart = DateUtils.addDaysToDate(cazareStart, days);
        return cazareStart.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRightTimeForMarcatProduct(Product p, Order order, Date cazareStartD, Date cazareStopD, Vector<Sale> preorderSales, int zileLipsaAllowedLaFinal, Table table) throws CazariLipsaException {
        try {
            int result = this.getRightTimeForMarcatProductNoCommit(p, order, cazareStartD, cazareStopD, preorderSales, zileLipsaAllowedLaFinal, table);
            this.pool.commit();
            int n = result;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public int getRightTimeForMarcatProductNoCommit(Product p, Order order, Date cazareStartD, Date cazareStopD, Vector<Sale> preorderSales, int zileLipsaAllowedLaFinal, Table table) throws SQLException, CazariLipsaException {
        long cazareStop = cazareStopD.getTime();
        long cazareStart = cazareStartD.getTime();
        long millisDiff = cazareStop - cazareStart;
        Vector<Date> daysInPerioada = DateUtils.getDaysInPerioada(cazareStartD, cazareStopD);
        int nrOfDays = daysInPerioada.size();
        Sale[] dates = new Sale[nrOfDays];
        if (nrOfDays < 1) {
            return -1;
        }
        Vector<Sale> marcate = RestLogic.getInstance().getSalesNoCommitNoSort(order.getId(), false, -1, new ScreenSaleInterface(), -1);
        Collections.sort(marcate);
        for (Sale sale : marcate) {
            if (sale.getIdCategorie() != p.getIdCategorie()) continue;
            long saleDate = sale.getSaledate();
            long diff = saleDate - cazareStart;
            int days = (int)(diff / DateUtils.dayMillis);
            if (dates[days] != null) {
                days = this.getNextFreeSlot(dates);
                if (days >= 0) {
                    sale.setSaledate(this.getDate(days, cazareStartD));
                    Logger.logWarning(this, "Casuta ocupata ilegal ! Ajutooor !");
                    dates[days] = sale;
                    continue;
                }
                return -1;
            }
            dates[days] = sale;
        }
        Vector<String> errors = new Vector<String>();
        if (zileLipsaAllowedLaFinal > 0 && dates.length > zileLipsaAllowedLaFinal) {
            for (int i = 0; i < dates.length - zileLipsaAllowedLaFinal; ++i) {
                if (dates[i] != null) continue;
                Date d = new Date(this.getDate(i, cazareStartD));
                if (d.getTime() > System.currentTimeMillis() - DateUtils.dayMillis) {
                    System.out.println("Nu verific mai mult de data de " + Formatters.DATE_AND_TIME_FORMAT.format(d));
                    break;
                }
                String dS = Formatters.DATE_FORMAT_RO.format(d);
                errors.add("Ziua de " + dS + " lipsa ! ");
            }
        }
        if (errors.size() > 0) {
            throw new CazariLipsaException(errors, table.getLabel());
        }
        for (Sale sale : preorderSales) {
            if (sale.getIdCategorie() != p.getIdCategorie()) continue;
            long saleDate = sale.getSaledate();
            long diff = saleDate - cazareStart;
            int days = (int)(diff / DateUtils.dayMillis);
            if (dates[days] != null) {
                days = this.getNextFreeSlot(dates);
                if (days >= 0) {
                    sale.setSaledate(this.getDate(days, cazareStartD));
                    dates[days] = sale;
                    continue;
                }
                Logger.logWarning(this, "Nu mai am sloturi libere DESI AR TREBUI ! Ajutooor !");
                return -1;
            }
            dates[days] = sale;
        }
        int freeIndex = this.getNextFreeSlot(dates);
        return freeIndex;
    }

    private void addProductsAtInchidereZiHotelieraSimple(CameraId id) throws SQLException, CazariLipsaException {
        Vector<Sale> preorderSales;
        Date stopD;
        int idTable = id.getIdTable();
        Table t = RestLogic.getInstance().getTableByIdNoCommit(idTable);
        int idOrder = id.getIdOrder();
        if (idOrder <= 0) {
            Logger.logInfo(this, "InchidereZiHoteliera: Camera " + t.getLabel() + " e goala ! Skipping!");
            return;
        }
        RezervareBean currentRezervareBean = RezervariLogic.getInstance().getCurrentRezervareBeanNoCommit(idOrder, t.getId());
        Order order = RestLogic.getInstance().getOrderByIdNoCommit(idOrder);
        if (currentRezervareBean == null) {
            Logger.logError((Object)this, "InchidereZiHoteliera: Camera " + t.getLabel() + " nu are calendar asociat ! Skipping!");
            return;
        }
        Product tipTarif = null;
        double pret = 0.0;
        if (t.isVirtuala()) {
            Logger.logInfo(this, "InchidereZiHoteliera: Camera " + t.getLabel() + " e virtuala ! Adaugam intrerupere sejur !");
            int codProdusIntrerupereSejur = VpConfig.getInstance().hotelCodProdusIntrerupereSejur;
            tipTarif = NomeclaturaLogic.getInstance().getProductByCodNoCommit(codProdusIntrerupereSejur);
        } else {
            tipTarif = NomeclaturaLogic.getInstance().getProductByIdNoCommit(currentRezervareBean.getIdProduct());
            pret = currentRezervareBean.getTarif();
        }
        if (tipTarif == null) {
            Logger.logError((Object)this, "InchidereZiHoteliera: Camera " + t.getLabel() + " nu are TARIF asociat ! Skipping!");
            return;
        }
        Sectie sectie = NomeclaturaLogic.getInstance().getSectieByCategoryIdNoCommit(tipTarif.getIdCategorie());
        Date startD = DateUtils.getStartOfDay(currentRezervareBean.getStart());
        int newSlot = this.getRightTimeForMarcatProductNoCommit(tipTarif, order, startD, stopD = DateUtils.getStartOfDay(currentRezervareBean.getStop()), preorderSales = new Vector<Sale>(), 1, t);
        if (newSlot < 0) {
            return;
        }
        long now = this.getDate(newSlot, startD);
        if (newSlot < 0) {
            return;
        }
        if (now > System.currentTimeMillis()) {
            Logger.logInfo(this, "InchidereZiHoteliera: Camera " + t.getLabel() + " nu adaug inainte de ora 12 ! Skipping!");
            return;
        }
        String detaliiProdus = " " + Formatters.DATE_FORMAT_RO.format(new Date(now)) + " ";
        Sale toAdd = RestLogic.getInstance().buildSaleNoCommit(tipTarif, 0.0, 1.0, detaliiProdus, -1, -1, -1, -1, -1, now, pret, SEX_NA_LABEL, 0);
        preorderSales.add(toAdd);
        RestLogic.getInstance().productsSoldNoCommit(preorderSales, order, t, sectie, order.isProtocol(), null, null, order.getUser());
        Logger.logInfo(this, "InchidereZiHoteliera: Camera " + t.getLabel() + ": Adaugat produs " + tipTarif.getName() + " la " + Utils.getString2Decimals(currentRezervareBean.getTarif()) + " lei cu data " + toAdd.getModPreparare());
    }

    @Deprecated
    private void addProductsAtInchidereZiHoteliera(CameraId id) throws SQLException {
        int idTable = id.getIdTable();
        Table t = RestLogic.getInstance().getTableByIdNoCommit(idTable);
        if (t.isVirtuala()) {
            return;
        }
        Order o = RestLogic.getInstance().getOpenOrderAtTableNoCommit(t);
        if (o == null) {
            User u = this.getFirstReceptionistNoCommit();
            o = RestLogic.getInstance().newOrderNoCommit(idTable, u.getId(), false);
        }
        int idProduct = id.getIdProduct();
        Product p = NomeclaturaLogic.getInstance().getProductByIdNoCommit(idProduct);
        Sectie sectie = NomeclaturaLogic.getInstance().getSectieByCategoryIdNoCommit(p.getIdCategorie());
        double pretCazare = RestLogic.getInstance().getPriceForProductNoCommit(idProduct);
        Sale tempSale = RestLogic.getInstance().buildSaleNoCommit(p, 0.0, 1.0, SEX_NA_LABEL, o.getId(), -1, -1, -1, -1, DateUtils.getCurrentTimestamp().getTime(), 0);
        Vector<Sale> toSellNow = new Vector<Sale>();
        if (VpConfig.getInstance().hotelShowDateInProducts) {
            tempSale.setModPreparare(Formatters.DATE_FORMAT_RO.format(new Date()));
        }
        toSellNow.add(tempSale);
        RestLogic.getInstance().productsSoldNoCommit(toSellNow, o, t, sectie, false, null, null, o.getUser());
        int idCodProdusTaxe = VpConfig.getInstance().hotelTaxeCodProdus;
        if (idCodProdusTaxe > 0) {
            if (this.mustApplyTax(id.getIdCalendar())) {
                p = NomeclaturaLogic.getInstance().getProductByCodNoCommit(idCodProdusTaxe);
                sectie = NomeclaturaLogic.getInstance().getSectieByCategoryIdNoCommit(p.getIdCategorie());
                double taxValue = VpConfig.getInstance().hotelTaxePercent;
                taxValue = pretCazare * taxValue / 100.0;
                tempSale = RestLogic.getInstance().buildSaleNoCommit(p, 0.0, 1.0, SEX_NA_LABEL, o.getId(), -1, -1, -1, -1, DateUtils.getCurrentTimestamp().getTime(), taxValue, SEX_NA_LABEL, 0);
                toSellNow = new Vector();
                if (VpConfig.getInstance().hotelShowDateInProducts) {
                    tempSale.setModPreparare(Formatters.DATE_FORMAT_RO.format(new Date()));
                }
                toSellNow.add(tempSale);
                RestLogic.getInstance().productsSoldNoCommit(toSellNow, o, t, sectie, false, null, null, o.getUser());
            }
        } else {
            Logger.logWarning(this, "hotelTaxeCodProdus necompletat. NU adaugam taxele.");
        }
        Vector<RezervariMeseView> servicii = this.getRezervariMeseViews(id.getIdCalendar());
        for (int j = 0; j < servicii.size(); ++j) {
            RezervariMeseView rezervariMeseView = servicii.elementAt(j);
            idProduct = rezervariMeseView.getIdProduct();
            p = NomeclaturaLogic.getInstance().getProductByIdNoCommit(idProduct);
            sectie = NomeclaturaLogic.getInstance().getSectieByCategoryIdNoCommit(p.getIdCategorie());
            double q = rezervariMeseView.getNrPersoane();
            if (q <= 0.0) continue;
            tempSale = RestLogic.getInstance().buildSaleNoCommit(p, 0.0, q, SEX_NA_LABEL, o.getId(), -1, -1, -1, -1, System.currentTimeMillis(), 0);
            if (VpConfig.getInstance().hotelShowDateInProducts) {
                tempSale.setModPreparare(Formatters.DATE_FORMAT_RO.format(new Date()));
            }
            toSellNow = new Vector();
            toSellNow.add(tempSale);
            RestLogic.getInstance().productsSoldNoCommit(toSellNow, o, t, sectie, false, null, null, o.getUser());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatusAllRoomsPeriodically() {
        try {
            Vector<CameraId> rezervariCazate = this.getDao().getCalendarByStatus(4, -1);
            for (int i = 0; i < rezervariCazate.size(); ++i) {
                CameraId id = rezervariCazate.elementAt(i);
                int idCalendar = id.getIdCalendar();
                Timestamp t1 = this.getDao().getStopDateForCalendar(idCalendar);
                if (t1.getTime() - System.currentTimeMillis() >= DateUtils.dayMillis) continue;
                this.setStatusCheckout(idCalendar);
            }
            Vector<CameraId> rezervariCheckout = this.getDao().getCalendarByStatus(5, -1);
            for (int i = 0; i < rezervariCheckout.size(); ++i) {
                CameraId id = rezervariCheckout.elementAt(i);
                int idCalendar = id.getIdCalendar();
                Timestamp t1 = this.getDao().getStopDateForCalendar(idCalendar);
                if (t1.getTime() - System.currentTimeMillis() < DateUtils.dayMillis) continue;
                this.getDao().updateStatus(idCalendar, 4);
            }
            Vector<CameraId> rezervari = this.getDao().getCalendarByStatus(2, -1);
            for (int i = 0; i < rezervari.size(); ++i) {
                CameraId cameraId = rezervari.elementAt(i);
                int idCalendar = cameraId.getIdCalendar();
                Timestamp t1 = this.getDao().getStartDateForCalendar(idCalendar);
                if (t1.getTime() - System.currentTimeMillis() >= DateUtils.dayMillis) continue;
                this.getDao().updateStatus(idCalendar, 3);
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void updateStatusAtCamera(int idCalendar) throws SQLException {
        Timestamp t1;
        int newStatus = this.getDao().getStatusForCalendar(idCalendar);
        if (newStatus == 2) {
            Timestamp t12 = this.getDao().getStartDateForCalendar(idCalendar);
            if (t12.getTime() - System.currentTimeMillis() < DateUtils.dayMillis) {
                this.getDao().updateStatus(idCalendar, 3);
            }
        } else if (newStatus == 4 && (t1 = this.getDao().getStopDateForCalendar(idCalendar)).getTime() - System.currentTimeMillis() < DateUtils.dayMillis) {
            this.setStatusCheckout(idCalendar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTarifBlocat(int idCalendar, boolean blocat) {
        try {
            this.getDao().setTarifBlocat(blocat, idCalendar);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void setStatusCheckout(int idCalendar) throws SQLException {
        this.getDao().updateStatus(idCalendar, 5);
    }

    private boolean mustApplyTax(int idRezervare) throws SQLException {
        String taxS = VpConfig.getInstance().hotelApplyTaxInDay;
        if (taxS.contains("*")) {
            return true;
        }
        Vector days = Utils.splitString(taxS, ',');
        for (int i = 0; i < days.size(); ++i) {
            String s = (String)days.elementAt(i);
            if (s.contains("-")) {
                Vector startEnd = Utils.splitString(s, '-');
                String start = (String)startEnd.get(0);
                String end = (String)startEnd.get(1);
                if (Validators.correctInteger(start) && Validators.correctInteger(end)) {
                    int s1 = Integer.parseInt(start);
                    int s2 = Integer.parseInt(end);
                    if (s2 > s1) {
                        int ziCazare = this.getCazareDay(idRezervare);
                        if (ziCazare < s1 || ziCazare > s2) continue;
                        return true;
                    }
                    Logger.logError((Object)this, "hotelApplyTaxInDay: perioada definita incorect: " + s);
                    continue;
                }
                Logger.logError((Object)this, "hotelApplyTaxInDay: perioada definita incorect: " + s);
                continue;
            }
            if (Validators.correctInteger(s)) {
                int ziCazare;
                int s2 = Integer.parseInt(s);
                if (s2 != (ziCazare = this.getCazareDay(idRezervare))) continue;
                return true;
            }
            Logger.logError((Object)this, "hotelApplyTaxInDay: perioada definita incorect: " + s);
        }
        return false;
    }

    private int getCazareDay(int idRezervare) throws SQLException {
        Timestamp start = this.getDao().getStartDateForCalendar(idRezervare);
        Date stop = DateUtils.getStartOfDay(new Date());
        Vector<Date> days = DateUtils.getDaysInPerioada(new Date(start.getTime()), stop);
        int diff = days.size();
        return diff;
    }

    private boolean tiparesteFisaTratamentSauLegitimatieMasa(int numarFisa, Date data, String camera, String client, String cod, Date checkin, Date checkout, int idClient, String templateFile, String outputFile) {
        Hashtable<String, String> mapping = new Hashtable<String, String>();
        mapping.put("data", Formatters.DATE_FORMAT_RO.format(data));
        mapping.put("camera", camera);
        mapping.put("client", client);
        mapping.put("codclient", idClient + SEX_NA_LABEL);
        mapping.put("cnp", cod);
        mapping.put("checkin", Formatters.DATE_FORMAT_RO.format(checkin));
        mapping.put("checkout", Formatters.DATE_FORMAT_RO.format(checkout));
        mapping.put("nr", numarFisa + SEX_NA_LABEL);
        String path = PrintLogic.getInstance().generateOdtDocument(templateFile, mapping, outputFile);
        boolean ok = PrintLogic.getInstance().printFacturaOpenOffice(path, "printer_items_facturi");
        return ok;
    }

    public boolean tiparesteFisaTratament(int numarFisa, Date data, String camera, String client, String cod, Date checkin, Date checkout, int idClient) {
        String templateFile = FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + "template_fisa_tratament.odt";
        String outputFile = FileUtils.getTempDir() + File.separator + "fisa_tratament.odt";
        return this.tiparesteFisaTratamentSauLegitimatieMasa(numarFisa, data, camera, client, cod, checkin, checkout, idClient, templateFile, outputFile);
    }

    public boolean tiparesteLegitimatieMasa(int numarFisa, Date data, String camera, String client, String cod, Date checkin, Date checkout, int idClient) {
        String templateFile = FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + "template_legitimatie_masa.odt";
        String outputFile = FileUtils.getTempDir() + File.separator + "legitimatie_masa.odt";
        return this.tiparesteFisaTratamentSauLegitimatieMasa(numarFisa, data, camera, client, cod, checkin, checkout, idClient, templateFile, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumarFisa(int idCalendar) {
        try {
            int numarFisa = this.getDao().getNrFisa(idCalendar);
            if (numarFisa <= 0) {
                numarFisa = Config.getInstance().getIntNoCommit("numarFisaTratament");
                Config.getInstance().updateValueNoCommit("numarFisaTratament", ++numarFisa + SEX_NA_LABEL);
                this.getDao().setNrFisa(numarFisa, idCalendar);
            }
            this.pool.commit();
            int n = numarFisa;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<CazariReportBean> getRaportCazari(Hashtable criteria) {
        Vector<CazariReportBean> result = new Vector<CazariReportBean>();
        Date s1 = (Date)criteria.get(Constants.START_KEY);
        Date s2 = (Date)criteria.get(Constants.STOP_KEY);
        String nume = (String)criteria.get("Nume");
        String adresa = (String)criteria.get("Adresa");
        String camera = (String)criteria.get("Camera");
        try {
            Vector<CazariReportBean> cazari = this.getDao().getCazariReport(new Timestamp(s1.getTime()), new Timestamp(s2.getTime()));
            for (CazariReportBean bean : cazari) {
                String n;
                bean.computePerioada();
                int idClient = bean.getIdClient();
                Client c = ClientLogic.getInstance().getClientByIdNoCommit(idClient);
                if (c != null) {
                    bean.setNume(c.toString());
                    bean.setAdresa(c.getCity() + " " + c.getAddress1());
                    if (c instanceof ClientPersFizica) {
                        ClientPersFizica cpf = (ClientPersFizica)c;
                        String act = SEX_NA_LABEL;
                        if (cpf.getIdBuletin() > 0) {
                            BiCi bici = ClientLogic.getInstance().getBiCiByIdNoCommit(cpf.getIdBuletin());
                            act = act + " BiCi: " + bici.getSeria() + " " + bici.getNumarul();
                        }
                        if (cpf.getIdPassport() > 0) {
                            AltAct alt = ClientLogic.getInstance().getPassportByIdNoCommit(cpf.getIdPassport());
                            act = act + " " + alt.getTipAct() + ": " + alt.getSeria() + " ";
                        }
                        bean.setAct(act);
                    } else {
                        ClientPersJuridica cpj = (ClientPersJuridica)c;
                        bean.setAct("CUI: " + cpj.getCui());
                    }
                }
                boolean pass = true;
                if (Validators.correctString(nume) && !(n = bean.getNume().toLowerCase()).contains(nume.toLowerCase())) {
                    pass = false;
                }
                if (Validators.correctString(adresa) && !(n = bean.getAdresa().toLowerCase()).contains(adresa.toLowerCase())) {
                    pass = false;
                }
                if (Validators.correctString(camera) && !(n = bean.getCameraLong().toLowerCase()).contains(camera.toLowerCase())) {
                    pass = false;
                }
                if (!pass) continue;
                result.add(bean);
            }
            Vector<CazariReportBean> vector = result;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<CazariReportBean> vector = new Vector<CazariReportBean>();
            return vector;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<RezervareBean> getCazariActive(int id_client) {
        try {
            Vector<RezervareBean> vector = this.getDao().getCazariActive(id_client);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<RezervareBean> vector = new Vector<RezervareBean>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public static Date getStartZiHoteliera(Date source) {
        Date _12H = DateUtils.setTimeToDate(source, 12, 0, 0, 0);
        if (source.before(_12H)) {
            Date result = DateUtils.addDaysToDate(_12H, -1);
            return result;
        }
        return _12H;
    }

    public static Date getEndZiHoteliera(Date source) {
        Date start = RezervariLogic.getStartZiHoteliera(source);
        Date result = DateUtils.addDaysToDate(start, 1);
        result = DateUtils.addMillisToDate(result, -1L);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addHotelGroup(String nume, int idAgentie) {
        try {
            this.getDao().addGroup(nume, idAgentie);
            int res = this.pool.getIdentityLocal();
            this.pool.commit();
            this.notifyListeners(1101);
            int n = res;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHotelGroup(HotelGroup group) {
        try {
            this.getDao().updateGroup(group);
            this.pool.commit();
            this.notifyListeners(1101);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean factureazaGrup(Vector<CazariBean> hotelBeans, Component parent, User waiter, int idSocietateAgentie) {
        try {
            String result;
            Product productTaxe = NomeclaturaLogic.getInstance().getProductByCod(VpConfig.getInstance().hotelTaxeCodProdus);
            if (productTaxe == null) {
                DialogUtils.errorDialog(parent, "Produs Taxe neconfigurat", LangRoAll.nuPotContinua);
                return false;
            }
            Product productCazare = NomeclaturaLogic.getInstance().getProductByCod(VpConfig.getInstance().hotelCodProdusCazare);
            if (productCazare == null) {
                DialogUtils.errorDialog(parent, "Produs Cazare neconfigurat", LangRoAll.nuPotContinua);
                return false;
            }
            String hotelCodProdusServicii = VpConfig.getInstance().hotelCodProdusServicii;
            Hashtable<Tva, Product> productServiciiPerTva = new Hashtable<Tva, Product>();
            Vector pairs = Utils.splitString(hotelCodProdusServicii, ',');
            for (String pair : pairs) {
                Vector values = Utils.splitString(pair, '=');
                if (values.size() != 2) {
                    DialogUtils.errorDialog(parent, "hotelCodProdusServicii : configurare incorecta !! (cotaTva=codProdus)", LangRoAll.nuPotContinua);
                    return false;
                }
                String cotaTvaS = (String)values.get(0);
                String codProdus = (String)values.get(1);
                if (!Validators.correctInteger(codProdus)) {
                    DialogUtils.errorDialog(parent, "hotelOrder: codProdus " + codProdus + " nu e un numar !!", LangRoAll.nuPotContinua);
                    return false;
                }
                int codProdusI = Integer.parseInt(codProdus);
                Product p = NomeclaturaLogic.getInstance().getProductByCod(codProdusI);
                if (p == null) {
                    DialogUtils.errorDialog(parent, "hotelOrder: nu am gasit produsul cu codul " + codProdusI, LangRoAll.nuPotContinua);
                    return false;
                }
                Tva tva = TvaLogic.getInstance().getTvaByCota(Utils.parseDouble(cotaTvaS));
                if (tva == null) {
                    DialogUtils.errorDialog(parent, "hotelOrder: Nu am gasit cota TVA " + cotaTvaS, LangRoAll.nuPotContinua);
                    return false;
                }
                productServiciiPerTva.put(tva, p);
            }
            Vector<Categorie> categoriiServicii = new Vector<Categorie>();
            Vector numeCategorii = Utils.splitString(VpConfig.getInstance().hotelCategoriiServicii, ',');
            for (String categName : numeCategorii) {
                Categorie c = NomeclaturaLogic.getInstance().getCategoryByName(categName);
                if (c == null) continue;
                categoriiServicii.add(c);
            }
            double avans = 0.0;
            Vector<Integer> idOrders = new Vector<Integer>();
            for (CazariBean hotelBean : hotelBeans) {
                idOrders.add(hotelBean.getIdOrder());
                if (hotelBean.isAvansStornatDeja()) continue;
                avans += hotelBean.getAvans();
            }
            avans = FloatUtils.roundDoubleUp(avans, 2);
            Vector<Sale> allSales = RestLogic.getInstance().getSalesForIdOrdersNoSortNoCumulate(idOrders);
            Vector<Sale> selectedForFacturare = new Vector<Sale>();
            double total = 0.0;
            for (Sale sale : allSales) {
                if (!RezervariLogic.isProdusCazare(sale, productCazare) && !RezervariLogic.isProdusTaxa(sale, productTaxe) || sale.isFacturata()) continue;
                selectedForFacturare.add(sale);
                total += sale.getTotal();
            }
            if ((total = FloatUtils.roundDoubleUp(total, 2)) <= 0.0) {
                DialogUtils.errorDialog(parent, "Nimic de facturat !", LangRoAll.nuPotContinua);
                return false;
            }
            if (avans > total) {
                DialogUtils.errorDialog(parent, "Valoarea avansului (" + Utils.getString2Decimals(avans) + ") este mai mare decat valoarea cazarii (" + Utils.getString2Decimals(total) + ")", LangRoAll.nuPotContinua);
                return false;
            }
            Vector<NoteView> newData = this.getFacturaItems(false, false, true, -1, selectedForFacturare, productCazare, productServiciiPerTva, productTaxe, false, parent);
            if (avans > 0.0) {
                int idCodProdusAvans = VpConfig.getInstance().hotelCodProdusAvans;
                if (idCodProdusAvans <= 0) {
                    DialogUtils.errorDialog(parent, "Configurati codul de produs pentru avans ! ", LangRoAll.confirmare);
                    return false;
                }
                Product p = NomeclaturaLogic.getInstance().getProductByCod(idCodProdusAvans);
                if (p == null) {
                    DialogUtils.errorDialog(parent, "Produsul cu codul intern " + idCodProdusAvans + " nu a fost gasit ! ", LangRoAll.confirmare);
                    return false;
                }
                NoteView nv = new NoteView();
                nv.setCantitate(-1.0);
                nv.setProdus(p.getName());
                nv.setIdProdus(p.getId());
                nv.setSuma(-avans);
                nv.setIdOrder(-1);
                newData.add(nv);
            }
            User emitent = waiter;
            if (VpConfig.getInstance().touch2FacturaRequestEmitent) {
                emitent = UsersLogic.getInstance().requestWaiterLogin(GuiUtils.currentFrame, true, true);
            }
            String modPlata = "Neachitat";
            modPlata = VpConfig.getInstance().hotelSaleFacturataBeforeIncasata ? (result = DialogUtils.inputDialog(parent, "Neachitat", "Introduceti tipul de plata in forma <tip plata>=<suma>")) : this.buildModPlata(selectedForFacturare);
            if (emitent != null) {
                new AddFacturaDialog(true, parent, newData, idSocietateAgentie, emitent, null, modPlata);
            }
            if (!DialogUtils.confirmDialog(parent, "Ati Facturat ok", LangRoAll.confirmare)) return false;
            RestLogic.getInstance().setSalesFacturate(selectedForFacturare);
            this.setAvansStornat(hotelBeans);
            return true;
        }
        catch (HotelNrNoptiZeroException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvansStornat(Vector<CazariBean> toStornoAvans) {
        try {
            for (CazariBean bean : toStornoAvans) {
                this.setAvansStornatFacturaNoCommit(bean.getIdCalendar());
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            this.pool.releaseConnection();
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    private void setAvansStornatFacturaNoCommit(int idCalendar) throws SQLException {
        this.getDao().storneazaAvansFactura(idCalendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvansStornatFactura(int idCalendar) {
        try {
            this.setAvansStornatFacturaNoCommit(idCalendar);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void setAvansStornatBFNoCommit(int idCalendar) throws SQLException {
        this.getDao().storneazaAvansBF(idCalendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvansStornatBF(int idCalendar) {
        try {
            this.setAvansStornatBFNoCommit(idCalendar);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public String buildModPlata(Vector<Sale> acceptedSales) {
        Hashtable<String, AtrFloat> plati = new Hashtable<String, AtrFloat>();
        double totalFactura = 0.0;
        Vector<Integer> allIds = new Vector<Integer>();
        double totalNeachitatPeFactura = 0.0;
        double totalAchitatPeFactura = 0.0;
        for (Sale sale : acceptedSales) {
            totalFactura += sale.getTotal();
            if (!sale.isPrinted()) continue;
            allIds.addAll(sale.getIdSales());
        }
        if (allIds.size() > 0) {
            Hashtable<Integer, TipPlataValue> allPlati = RestLogic.getInstance().getTipPlataForSale(allIds);
            for (Integer idSale : allIds) {
                TipPlataValue tpv = allPlati.get(idSale);
                if (tpv != null) {
                    totalAchitatPeFactura += tpv.getSuma();
                    String tp = tpv.getTipPlata();
                    AtrFloat f = (AtrFloat)plati.get(tp);
                    if (f == null) {
                        f = new AtrFloat();
                        plati.put(tp, f);
                    }
                    f.setValue(f.getValue() + tpv.getSuma());
                    continue;
                }
                Logger.logWarning(this, "WARNING : TipPlata negasit dar sale marcat ca printat pt idsale : " + idSale);
            }
        }
        totalNeachitatPeFactura = totalFactura - totalAchitatPeFactura;
        String result = SEX_NA_LABEL;
        for (String tipPlata2 : plati.keySet()) {
            result = result + tipPlata2 + "=" + Utils.getString2Decimals(((AtrFloat)plati.get(tipPlata2)).getValue()) + " ";
        }
        if (result.length() > 1) {
            result = result.substring(0, result.length() - 1);
        }
        if (totalAchitatPeFactura > 0.0) {
            result = result + " Neachitat=" + Utils.getString2Decimals(totalNeachitatPeFactura);
        }
        return result;
    }

    public Vector<NoteView> getFacturaItemsWrapper(int idOrder, Vector<Sale> selectedSales, Component parent, RezervareBean currentRezervare, AvansStornatInterface avansStornatInterface) throws HotelNrNoptiZeroException {
        boolean cumuleazaServicii;
        boolean cumuleazaCazare;
        boolean mutaServiciiPeCazare;
        Product productTaxe = NomeclaturaLogic.getInstance().getProductByCod(VpConfig.getInstance().hotelTaxeCodProdus);
        if (productTaxe == null) {
            DialogUtils.errorDialog(parent, "Produs Taxe neconfigurat", LangRoAll.nuPotContinua);
            return new Vector<NoteView>();
        }
        Product productCazare = NomeclaturaLogic.getInstance().getProductByCod(VpConfig.getInstance().hotelCodProdusCazare);
        if (productCazare == null) {
            DialogUtils.errorDialog(parent, "Produs Cazare neconfigurat", LangRoAll.nuPotContinua);
            return new Vector<NoteView>();
        }
        String hotelCodProdusServicii = VpConfig.getInstance().hotelCodProdusServicii;
        Hashtable<Tva, Product> productServiciiPerTva = new Hashtable<Tva, Product>();
        Vector pairs = Utils.splitString(hotelCodProdusServicii, ',');
        for (String pair : pairs) {
            Vector values = Utils.splitString(pair, '=');
            if (values.size() != 2) {
                DialogUtils.errorDialog(parent, "hotelCodProdusServicii : configurare incorecta !! (cotaTva=codProdus)", LangRoAll.nuPotContinua);
                return new Vector<NoteView>();
            }
            String cotaTvaS = (String)values.get(0);
            String codProdus = (String)values.get(1);
            if (!Validators.correctInteger(codProdus)) {
                DialogUtils.errorDialog(parent, "hotelOrder: codProdus " + codProdus + " nu e un numar !!", LangRoAll.nuPotContinua);
                return new Vector<NoteView>();
            }
            int codProdusI = Integer.parseInt(codProdus);
            Product p = NomeclaturaLogic.getInstance().getProductByCod(codProdusI);
            if (p == null) {
                DialogUtils.errorDialog(parent, "hotelOrder: nu am gasit produsul cu codul " + codProdusI, LangRoAll.nuPotContinua);
                return new Vector<NoteView>();
            }
            Tva tva = TvaLogic.getInstance().getTvaByCota(Utils.parseDouble(cotaTvaS));
            if (tva == null) {
                DialogUtils.errorDialog(parent, "hotelOrder: Nu am gasit cota TVA " + cotaTvaS, LangRoAll.nuPotContinua);
                return new Vector<NoteView>();
            }
            productServiciiPerTva.put(tva, p);
        }
        boolean cazarePresenta = false;
        for (Sale sale : selectedSales) {
            if (!RezervariLogic.isProdusCazare(sale, productCazare)) continue;
            cazarePresenta = true;
            break;
        }
        Vector<Categorie> categoriiServicii = new Vector<Categorie>();
        Vector numeCategorii = Utils.splitString(VpConfig.getInstance().hotelCategoriiServicii, ',');
        for (String categName : numeCategorii) {
            Categorie c = NomeclaturaLogic.getInstance().getCategoryByName(categName);
            if (c == null) continue;
            categoriiServicii.add(c);
        }
        boolean serviciiPrezente = false;
        block3: for (Sale sale : selectedSales) {
            for (Product product : productServiciiPerTva.values()) {
                if (!RezervariLogic.isProdusServiciu(sale, product, categoriiServicii)) continue;
                serviciiPrezente = true;
                continue block3;
            }
        }
        if (serviciiPrezente && cazarePresenta) {
            mutaServiciiPeCazare = DialogUtils.confirmDialog(parent, "Includem serviciile in cazare", LangRoAll.confirmare);
            if (mutaServiciiPeCazare) {
                cumuleazaCazare = true;
                cumuleazaServicii = true;
            } else {
                cumuleazaServicii = DialogUtils.confirmDialog(parent, "Cumulam SERVICIILE ", LangRoAll.confirmare);
                cumuleazaCazare = DialogUtils.confirmDialog(parent, "Cumulam toate CAZARILE pe produsul \"" + productCazare.getName() + "\"", LangRoAll.confirmare);
            }
        } else if (serviciiPrezente) {
            mutaServiciiPeCazare = false;
            cumuleazaCazare = false;
            cumuleazaServicii = DialogUtils.confirmDialog(parent, "Cumulam SERVICIILE ", LangRoAll.confirmare);
        } else if (cazarePresenta) {
            mutaServiciiPeCazare = false;
            cumuleazaServicii = false;
            cumuleazaCazare = DialogUtils.confirmDialog(parent, "Cumulam toate CAZARILE pe produsul \"" + productCazare.getName() + "\"", LangRoAll.confirmare);
        } else {
            mutaServiciiPeCazare = false;
            cumuleazaCazare = false;
            cumuleazaServicii = false;
        }
        Vector<NoteView> newData = this.getFacturaItems(mutaServiciiPeCazare, cumuleazaServicii, cumuleazaCazare, idOrder, selectedSales, productCazare, productServiciiPerTva, productTaxe, serviciiPrezente, parent);
        double total = 0.0;
        for (NoteView noteView : newData) {
            total += noteView.getSuma();
        }
        total = FloatUtils.roundDoubleUp(total, 2);
        double avans = currentRezervare.getAvans();
        if (cazarePresenta && avans > 0.0 && !avansStornatInterface.isAvansStornat(currentRezervare)) {
            if (total < (avans = FloatUtils.roundDoubleUp(avans, 2))) {
                DialogUtils.errorDialog(parent, "Avansul este mai mare decat total facturat ! Nu pot storna avans !", LangRoAll.confirmare);
            } else {
                int idCodProdusAvans = VpConfig.getInstance().hotelCodProdusAvans;
                if (idCodProdusAvans > 0) {
                    Product p = NomeclaturaLogic.getInstance().getProductByCod(idCodProdusAvans);
                    if (p != null) {
                        NoteView nv = new NoteView();
                        nv.setCantitate(-1.0);
                        nv.setProdus(p.getName());
                        nv.setIdProdus(p.getId());
                        nv.setSuma(-avans);
                        nv.setIdOrder(-1);
                        nv.setIdCategorie(p.getIdCategorie());
                        newData.add(nv);
                    } else {
                        DialogUtils.errorDialog(parent, "Produsul cu codul intern " + idCodProdusAvans + " nu a fost gasit ! Nu pot storna avans !", LangRoAll.confirmare);
                    }
                } else {
                    DialogUtils.errorDialog(parent, "Configurati codul de produs pentru avans ! Nu pot storna avansul !", LangRoAll.confirmare);
                }
            }
        }
        return newData;
    }

    public Vector<NoteView> getFacturaItems(boolean mutaServiciiPeCazare, boolean cumuleazaServicii, boolean cumuleazaCazare, int idOrder, Vector<Sale> selectedSales, Product productCazare, Hashtable<Tva, Product> productServicii, Product productTaxe, boolean serviciiPrezente, Component panel) throws HotelNrNoptiZeroException {
        int idCazareCateg = productCazare.getIdCategorie();
        Categorie cazareCateg = NomeclaturaLogic.getInstance().getCategoryById(idCazareCateg);
        int idTva = cazareCateg.getIdTva();
        Tva cazareTva = TvaLogic.getInstance().getTvaById(idTva);
        Vector<NoteView> result = new Vector<NoteView>();
        Hashtable<Tva, Double> totalServicii = new Hashtable<Tva, Double>();
        double taxeProcent = VpConfig.getInstance().hotelTaxePercent;
        Hashtable<Integer, Vector<RezervariMeseView>> meseHash = new Hashtable<Integer, Vector<RezervariMeseView>>();
        Hashtable<String, CazareTaxeBean> recalculHash = new Hashtable<String, CazareTaxeBean>();
        Hashtable<Tva, Vector<Integer>> serviciiSales = new Hashtable<Tva, Vector<Integer>>();
        for (Sale sale : selectedSales) {
            if (sale.getIdProduct() == VpConfig.getInstance().hotelCodProdusIntrerupereSejur) continue;
            if (RezervariLogic.isProdusCazare(sale, productCazare)) {
                if (cumuleazaCazare) {
                    this.addCazareBeanToHash(sale, meseHash, recalculHash, productCazare, mutaServiciiPeCazare, serviciiPrezente);
                    continue;
                }
                int idCalendar = sale.getIdCalendar();
                Vector<RezervariMeseView> mese = (Vector<RezervariMeseView>)meseHash.get(idCalendar);
                if (mese == null) {
                    mese = RezervariLogic.getInstance().getRezervariMeseViews(idCalendar);
                    meseHash.put(idCalendar, mese);
                }
                double pretServicii = 0.0;
                for (RezervariMeseView meseView : mese) {
                    int nrPers = meseView.getNrPersoane();
                    int idProduct = meseView.getIdProduct();
                    double pppu = RestLogic.getInstance().getPriceForProductCommit(idProduct);
                    pretServicii += pppu * (double)nrPers * sale.getCantitateMarcata();
                }
                Vector<NoteView> recalculate = this.getCazareTaxeForItem((int)sale.getCantitateMarcata(), sale.getTotal(), pretServicii, taxeProcent, cazareTva, productCazare, productTaxe, sale.getIdSales(), idOrder);
                result.addAll(recalculate);
                continue;
            }
            Product product = NomeclaturaLogic.getInstance().getProductById(sale.getIdProduct());
            Categorie serviciuCateg = NomeclaturaLogic.getInstance().getCategoryById(product.getIdCategorie());
            int idTvaServiciu = serviciuCateg.getIdTva();
            Tva serviciuTva = TvaLogic.getInstance().getTvaById(idTvaServiciu);
            if (mutaServiciiPeCazare && Utils.isValueZero(serviciuTva.getCota() - cazareTva.getCota())) {
                this.addCazareBeanToHash(sale, meseHash, recalculHash, productCazare, mutaServiciiPeCazare, serviciiPrezente);
                continue;
            }
            if (cumuleazaServicii) {
                Double totalPerTva = (Double)totalServicii.get(serviciuTva);
                if (totalPerTva == null) {
                    totalPerTva = 0.0;
                }
                totalPerTva = totalPerTva + sale.getTotal();
                totalServicii.put(serviciuTva, totalPerTva);
                Vector<Integer> idServiciiPerTva = (Vector<Integer>)serviciiSales.get(serviciuTva);
                if (idServiciiPerTva == null) {
                    idServiciiPerTva = new Vector<Integer>();
                    serviciiSales.put(serviciuTva, idServiciiPerTva);
                }
                idServiciiPerTva.addAll(sale.getIdSales());
                continue;
            }
            NoteView nv = new NoteView();
            nv.setCantitate(1.0);
            nv.setSuma(sale.getTotal());
            nv.setProdus(sale.getProductName());
            nv.setIdProdus(sale.getIdProduct());
            nv.setIdOrder(idOrder);
            nv.setIdSales(sale.getIdSales());
            nv.setIdCategorie(sale.getIdCategorie());
            result.add(nv);
        }
        if (recalculHash.size() > 0) {
            Vector<NoteView> recalculate = this.getCazareNoua(productCazare, productTaxe, cazareTva, taxeProcent, idOrder, recalculHash);
            result.addAll(recalculate);
        }
        for (Tva tva : totalServicii.keySet()) {
            double totalServiciiValue = (Double)totalServicii.get(tva);
            if (!(totalServiciiValue > 0.0)) continue;
            NoteView nv = new NoteView();
            Product product = productServicii.get(tva);
            if (product == null) {
                DialogUtils.errorDialog(panel, "Produs servicii neconfigurat pentru TVA " + tva.getCota(), LangRoAll.nuPotContinua);
                return new Vector<NoteView>();
            }
            String produsServiciiLabel = product.getName();
            nv.setProdus(produsServiciiLabel);
            nv.setCantitate(1.0);
            nv.setSuma(totalServiciiValue);
            nv.setIdProdus(product.getId());
            nv.setIdOrder(idOrder);
            nv.setIdSales((Vector)serviciiSales.get(tva));
            nv.setIdCategorie(product.getIdCategorie());
            result.add(nv);
        }
        return result;
    }

    private Vector<NoteView> getCazareNoua(Product produsCazare, Product produsTaxe, Tva cotaTvaCazare, double procentTaxa, int idOrder, Hashtable<String, CazareTaxeBean> serviciiHash) throws HotelNrNoptiZeroException {
        Vector<NoteView> result = new Vector<NoteView>();
        for (String key : serviciiHash.keySet()) {
            System.out.println("key : " + key);
            CazareTaxeBean bean = serviciiHash.get(key);
            double pretServicii = bean.getTotalServiciiIncluse();
            double totalCazare = bean.getTotalCazare();
            int nrNopti = bean.getNrNopti();
            Vector<NoteView> cazareTaxe = this.getCazareTaxeForItem(nrNopti, totalCazare, pretServicii, procentTaxa, cotaTvaCazare, produsCazare, produsTaxe, bean.getIdSales(), idOrder);
            result.addAll(cazareTaxe);
        }
        return result;
    }

    private Vector<NoteView> getCazareTaxeForItem(int nrNopti, double totalCazare, double pretServicii, double procentTaxa, Tva cotaTvaCazare, Product produsCazare, Product produsTaxe, Vector<Integer> idSales, int idOrder) throws HotelNrNoptiZeroException {
        Vector<NoteView> result = new Vector<NoteView>();
        nrNopti = 1;
        double totalFaraServicii = (totalCazare - pretServicii) / (double)nrNopti;
        double totalFaraTaxe = totalFaraServicii / (1.0 + procentTaxa / 100.0);
        totalFaraTaxe = FloatUtils.roundFloat(totalFaraTaxe, 2);
        double totalFaraTva = totalFaraTaxe / (1.0 + cotaTvaCazare.getCota());
        totalFaraTva = FloatUtils.roundFloat(totalFaraTva, 2);
        double taxa = totalFaraTva * procentTaxa / 100.0;
        taxa = FloatUtils.roundFloat(taxa, 2);
        NoteView taxeView = new NoteView();
        taxeView.setProdus(produsTaxe.getName());
        taxeView.setCantitate(nrNopti);
        taxeView.setSuma(taxa * (double)nrNopti);
        taxeView.setIdProdus(produsTaxe.getId());
        taxeView.setIdOrder(idOrder);
        taxeView.setIdCategorie(produsTaxe.getIdCategorie());
        totalFaraTaxe = totalCazare - taxa * (double)nrNopti;
        NoteView cazare = new NoteView();
        cazare.setProdus(produsCazare.getName());
        cazare.setCantitate(nrNopti);
        cazare.setSuma(totalFaraTaxe);
        cazare.setIdProdus(produsCazare.getId());
        cazare.setIdOrder(idOrder);
        cazare.setIdSales(idSales);
        cazare.setIdCategorie(produsCazare.getIdCategorie());
        result.add(cazare);
        if (VpConfig.getInstance().hotelAddTaxeEnabled) {
            result.add(taxeView);
        }
        return result;
    }

    private void addCazareBeanToHash(Sale s, Hashtable<Integer, Vector<RezervariMeseView>> meseHash, Hashtable<String, CazareTaxeBean> recalculateHash, Product productCazare, boolean mutaServiciiPeCazare, boolean serviciiPrezente) {
        int idCalendar = s.getIdCalendar();
        Vector<RezervariMeseView> mese = meseHash.get(idCalendar);
        if (mese == null) {
            mese = RezervariLogic.getInstance().getRezervariMeseViews(idCalendar);
            meseHash.put(idCalendar, mese);
        }
        boolean isCazare = RezervariLogic.isProdusCazare(s, productCazare);
        double pretServicii = 0.0;
        for (RezervariMeseView meseView : mese) {
            int nrPers = meseView.getNrPersoane();
            int idProduct = meseView.getIdProduct();
            double pppu = RestLogic.getInstance().getPriceForProductCommit(idProduct);
            pretServicii += pppu * (double)nrPers * s.getCantitateMarcata();
        }
        String key = s.getIdCalendar() + SEX_NA_LABEL;
        CazareTaxeBean existing = recalculateHash.get(key);
        if (existing == null) {
            existing = new CazareTaxeBean();
            recalculateHash.put(key, existing);
        }
        existing.setTotalCazare(existing.getTotalCazare() + s.getTotal());
        if (isCazare) {
            existing.setTotalServiciiIncluse(existing.getTotalServiciiIncluse() + pretServicii);
            existing.setNrNopti(existing.getNrNopti() + (int)s.getCantitateMarcata());
        }
        existing.addIdSale(s.getIdSales());
    }

    public Map<CHECKOUT_ERROR, String> canCheckoutGroup(int idGrup, Component panel) {
        Hashtable<String, Comparable<Date>> criteria = new Hashtable<String, Comparable<Date>>();
        criteria.put(Constants.START_KEY, DateUtils.getStartOfDays());
        criteria.put(Constants.STOP_KEY, DateUtils.getEndOfDays());
        criteria.put(Constants.GROUP_KEY, Integer.valueOf(idGrup));
        Vector<CazariBean> cazariForGroup = this.getListaCazariRezervari(criteria, panel);
        String camereNeincasate = SEX_NA_LABEL;
        String camereNefacturate = SEX_NA_LABEL;
        Hashtable<CHECKOUT_ERROR, String> result = new Hashtable<CHECKOUT_ERROR, String>();
        for (CazariBean cazariBean : cazariForGroup) {
            if (cazariBean.getTotalNefacturat() > 0.0) {
                camereNefacturate = camereNefacturate + cazariBean.getCamera() + " ";
                result.put(CHECKOUT_ERROR.NEFACTURAT, camereNefacturate);
            }
            if (!(cazariBean.getTotalNeincasat() > 0.0)) continue;
            camereNeincasate = camereNeincasate + cazariBean.getCamera() + " ";
            result.put(CHECKOUT_ERROR.NEINCASAT, camereNeincasate);
        }
        return result;
    }

    public static enum CHECKOUT_ERROR {
        NEINCASAT,
        NEFACTURAT;

    }
}

